//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 4>, 344> tgamma_delta_ratio_int = { {
      { SC_(0.24302618503570556640625e1), SC_(0.1e1), SC_(0.4114782939349022594054088894256271572472e0), SC_(0.14302618503570556640625e1) }, 
      { SC_(0.301645793914794921875e2), SC_(0.1e1), SC_(0.3315146506841289877594755891064182591548e-1), SC_(0.291645793914794921875e2) }, 
      { SC_(0.301645793914794921875e2), SC_(0.3e1), SC_(0.3307223761155750711531487469609546246538e-4), SC_(0.2231320586281996185139958610577082254167e5) }, 
      { SC_(0.301645793914794921875e2), SC_(0.5e1), SC_(0.2918858268609190809990278724248604514024e-7), SC_(0.1469147518070480379794665014907786525186e8) }, 
      { SC_(0.301645793914794921875e2), SC_(0.7e1), SC_(0.2295219166275465213873613192776013762556e-10), SC_(0.8223734198694550134689130502530947232135e10) }, 
      { SC_(0.301645793914794921875e2), SC_(0.9e1), SC_(0.1618208430275734434924519990812495766662e-13), SC_(0.3857786609269072710128224389442555988969e13) }, 
      { SC_(0.301645793914794921875e2), SC_(0.11e2), SC_(0.1028721387871736550385318599923041671733e-16), SC_(0.1490824979713097171415993481052223628558e16) }, 
      { SC_(0.301645793914794921875e2), SC_(0.13e2), SC_(0.5926882460007524968122855042901912157197e-20), SC_(0.4648203922170334340207682876080006032116e18) }, 
      { SC_(0.301645793914794921875e2), SC_(0.15e2), SC_(0.3109028494792192917110790291054315941926e-23), SC_(0.1139409800082989383839979690424223084142e21) }, 
      { SC_(0.301645793914794921875e2), SC_(0.17e2), SC_(0.1491138039359247528148047903357857018565e-26), SC_(0.2124665771291534304735753615395767158197e23) }, 
      { SC_(0.301645793914794921875e2), SC_(0.19e2), SC_(0.6564083719175744994115607229861959803378e-30), SC_(0.2885559839005887499381495946913235780383e25) }, 
      { SC_(0.33848663330078125e2), SC_(0.1e1), SC_(0.2954326409431340851983450434701073702185e-1), SC_(0.32848663330078125e2) }, 
      { SC_(0.33848663330078125e2), SC_(0.3e1), SC_(0.2364827053120534463560561879334289442712e-4), SC_(0.3227344028825395710668999527115374803543e5) }, 
      { SC_(0.33848663330078125e2), SC_(0.5e1), SC_(0.1695614414470450244250500226271753919667e-7), SC_(0.2779046705870235738963729137775015086257e8) }, 
      { SC_(0.33848663330078125e2), SC_(0.7e1), SC_(0.1095310525613279305495592465256381394661e-10), SC_(0.2077891515483201757744317351815521823156e11) }, 
      { SC_(0.33848663330078125e2), SC_(0.9e1), SC_(0.6407340740919580652793383140467826508761e-14), SC_(0.1334639554269227650049353460252698351418e14) }, 
      { SC_(0.33848663330078125e2), SC_(0.11e2), SC_(0.3410234021200152276254976943763997265065e-17), SC_(0.7272585453555431260958160354377596176673e16) }, 
      { SC_(0.33848663330078125e2), SC_(0.13e2), SC_(0.1658471451363357954157478377453720607441e-20), SC_(0.3312774860859689395345508883625889572398e19) }, 
      { SC_(0.33848663330078125e2), SC_(0.15e2), SC_(0.7398454132291610784864741044066350592108e-24), SC_(0.123937789059580278543168468020516206455e22) }, 
      { SC_(0.33848663330078125e2), SC_(0.17e2), SC_(0.3038328895194104537239753148827028386063e-27), SC_(0.3727133034351634026738359532400494439921e24) }, 
      { SC_(0.33848663330078125e2), SC_(0.19e2), SC_(0.1152438286925339630084625472113528311441e-30), SC_(0.8771116810258575546832070468458856366617e26) }, 
      { SC_(0.3462689208984375e2), SC_(0.1e1), SC_(0.2887928831167915505519744344972123660605e-1), SC_(0.3362689208984375e2) }, 
      { SC_(0.3462689208984375e2), SC_(0.3e1), SC_(0.2213137918593517448219688061454782526597e-4), SC_(0.3469915936700885481513978447765111923218e5) }, 
      { SC_(0.3462689208984375e2), SC_(0.5e1), SC_(0.1522721097426024895896792330316918422863e-7), SC_(0.3148531028341027662367459391135879115051e8) }, 
      { SC_(0.3462689208984375e2), SC_(0.7e1), SC_(0.9458379866953813757703618778885035880068e-11), SC_(0.2490085216056195944036457961808452623757e11) }, 
      { SC_(0.3462689208984375e2), SC_(0.9e1), SC_(0.5330391348709183914871234647798016253296e-14), SC_(0.1699145729193855721519591364984158133864e14) }, 
      { SC_(0.3462689208984375e2), SC_(0.11e2), SC_(0.2737840710883982300048275891615376700953e-17), SC_(0.9886597038736954287739003770107517853574e16) }, 
      { SC_(0.3462689208984375e2), SC_(0.13e2), SC_(0.1286917838872088415509337429304986457503e-20), SC_(0.4837999869770538119582666222954992161451e19) }, 
      { SC_(0.3462689208984375e2), SC_(0.15e2), SC_(0.5556765445986870190361609497371887346956e-24), SC_(0.195862450405695992267877670894152909715e22) }, 
      { SC_(0.3462689208984375e2), SC_(0.17e2), SC_(0.2211687277609313503714629255037786857888e-27), SC_(0.643083442616985917719955843589721349925e24) }, 
      { SC_(0.3462689208984375e2), SC_(0.19e2), SC_(0.8140292584590354784620261881745875674798e-31), SC_(0.1670902155865215796953312290630024870723e27) }, 
      { SC_(0.38969058990478515625e2), SC_(0.1e1), SC_(0.2566138433684874120271097708825946441219e-1), SC_(0.37969058990478515625e2) }, 
      { SC_(0.38969058990478515625e2), SC_(0.3e1), SC_(0.1567112478553435406702123549078289771168e-4), SC_(0.504890624506973244356999863668988837162e5) }, 
      { SC_(0.38969058990478515625e2), SC_(0.5e1), SC_(0.8689906310391695151299331020686331039092e-8), SC_(0.5997424205505611045426742533651556939386e8) }, 
      { SC_(0.38969058990478515625e2), SC_(0.7e1), SC_(0.4394951869162062144764399567493282296601e-11), SC_(0.6321223889260369330291849413168960841557e11) }, 
      { SC_(0.38969058990478515625e2), SC_(0.9e1), SC_(0.2035525982765477083776753980340839550068e-14), SC_(0.5866813580649745354849775687876536135352e14) }, 
      { SC_(0.38969058990478515625e2), SC_(0.11e2), SC_(0.8665501322102869433082774775249219150551e-18), SC_(0.475351131137151882575690233470282894011e17) }, 
      { SC_(0.38969058990478515625e2), SC_(0.13e2), SC_(0.3402404204209133714893020990890855167026e-21), SC_(0.332917433408466146766602692025570579486e20) }, 
      { SC_(0.38969058990478515625e2), SC_(0.15e2), SC_(0.1236000924581999848584000411105138094148e-24), SC_(0.199246039489905250504763182886478199254e23) }, 
      { SC_(0.38969058990478515625e2), SC_(0.17e2), SC_(0.4166349010445106129065594246766652774957e-28), SC_(0.1005412674170810825848072062572878094182e26) }, 
      { SC_(0.38969058990478515625e2), SC_(0.19e2), SC_(0.1306678052162296296302493472338051227226e-31), SC_(0.4209988378715069570506244784182271066633e28) }, 
      { SC_(0.41507625579833984375e2), SC_(0.1e1), SC_(0.2409195867098306907239470727577262147923e-1), SC_(0.40507625579833984375e2) }, 
      { SC_(0.41507625579833984375e2), SC_(0.3e1), SC_(0.1302686404207614714166737816227289198388e-4), SC_(0.6162606769838344661754936382180858345237e5) }, 
      { SC_(0.41507625579833984375e2), SC_(0.5e1), SC_(0.6431633349331497141015690712861511428175e-8), SC_(0.8438545889861793470458005660841864423808e8) }, 
      { SC_(0.41507625579833984375e2), SC_(0.7e1), SC_(0.2910943566542678829029393631028762223452e-11), SC_(0.1033961398568079581975133990707297357778e12) }, 
      { SC_(0.41507625579833984375e2), SC_(0.9e1), SC_(0.1212136898003702865187467684297844048505e-14), SC_(0.1126245913457844277854195511466495940505e15) }, 
      { SC_(0.41507625579833984375e2), SC_(0.11e2), SC_(0.4659326979515309613033501220500527426672e-18), SC_(0.1082573300089022204314702243358580760484e18) }, 
      { SC_(0.41507625579833984375e2), SC_(0.13e2), SC_(0.1658384118269441042099831807050083163649e-21), SC_(0.91065236945021286603137668511485592393e20) }, 
      { SC_(0.41507625579833984375e2), SC_(0.15e2), SC_(0.5481194532589979478160202963103776716729e-25), SC_(0.6640129568173827446546480656426857387714e23) }, 
      { SC_(0.41507625579833984375e2), SC_(0.17e2), SC_(0.1686718935768932765905700917212028498685e-28), SC_(0.4150953075743104724995577406049683820437e26) }, 
      { SC_(0.41507625579833984375e2), SC_(0.19e2), SC_(0.4844596658382802531655518188204297321602e-32), SC_(0.2196272737681924152751776983696792699708e29) }, 
      { SC_(0.43424015045166015625e2), SC_(0.1e1), SC_(0.2302873188856175403626965536052891307432e-1), SC_(0.42424015045166015625e2) }, 
      { SC_(0.43424015045166015625e2), SC_(0.3e1), SC_(0.1141212965168497956273138117867728882609e-4), SC_(0.7104007410816445601492441497271101980004e5) }, 
      { SC_(0.43424015045166015625e2), SC_(0.5e1), SC_(0.5183530746499905821724585148177857891242e-8), SC_(0.1076135606728602311731733060546098971879e9) }, 
      { SC_(0.43424015045166015625e2), SC_(0.7e1), SC_(0.2165842442020049314291887953595061977946e-11), SC_(0.1466915836463339236767082142468157916416e12) }, 
      { SC_(0.43424015045166015625e2), SC_(0.9e1), SC_(0.8352634046179587916965001059409801159114e-15), SC_(0.1788811192909514734098773167283202538717e15) }, 
      { SC_(0.43424015045166015625e2), SC_(0.11e2), SC_(0.298233654616673156227132531689098798769e-18), SC_(0.1938607613675135351748920729783474442776e18) }, 
      { SC_(0.43424015045166015625e2), SC_(0.13e2), SC_(0.9887080919142083101358820841666548050753e-22), SC_(0.185339554706118008924758289308683203201e21) }, 
      { SC_(0.43424015045166015625e2), SC_(0.15e2), SC_(0.3051480135720957858617678876687093192759e-25), SC_(0.155008485690420948357495306520727205633e24) }, 
      { SC_(0.43424015045166015625e2), SC_(0.17e2), SC_(0.8789358031687555830222445881321568310609e-29), SC_(0.1123273000311193530381181760232005030144e27) }, 
      { SC_(0.43424015045166015625e2), SC_(0.19e2), SC_(0.236815091235828679607489497499356592008e-32), SC_(0.6975036999910042353046954606166180204346e29) }, 
      { SC_(0.48126312255859375e2), SC_(0.1e1), SC_(0.2077865419406304236580399656817393498934e-1), SC_(0.47126312255859375e2) }, 
      { SC_(0.48126312255859375e2), SC_(0.3e1), SC_(0.8437960653693735957134561491100566346538e-5), SC_(0.9809390766368974126976354455109685659409e5) }, 
      { SC_(0.48126312255859375e2), SC_(0.5e1), SC_(0.3166183100205642887826645435303326518589e-8), SC_(0.1866732086273901183859566573335806986036e9) }, 
      { SC_(0.48126312255859375e2), SC_(0.7e1), SC_(0.1101077573857436603217685657647966596415e-11), SC_(0.3234113100569470581250886609733700766947e12) }, 
      { SC_(0.48126312255859375e2), SC_(0.9e1), SC_(0.3558708932056748207836379171964544718017e-15), SC_(0.5077540178064275443217905666528310416763e15) }, 
      { SC_(0.48126312255859375e2), SC_(0.11e2), SC_(0.1071725362180794722991303758934862096345e-18), SC_(0.7187204167983311927130207619426523150668e18) }, 
      { SC_(0.48126312255859375e2), SC_(0.13e2), SC_(0.3014658675524784930232885637612008898403e-22), SC_(0.9120447991959640899074143906493307877248e21) }, 
      { SC_(0.48126312255859375e2), SC_(0.15e2), SC_(0.7938425564547933194404486603257095922217e-26), SC_(0.1031047379391541256772257192115735567411e25) }, 
      { SC_(0.48126312255859375e2), SC_(0.17e2), SC_(0.1961045599357850472573774141844422974584e-29), SC_(0.1031020187481179725740755298399728721963e28) }, 
      { SC_(0.48126312255859375e2), SC_(0.19e2), SC_(0.4553621212485033764098492374866479408138e-33), SC_(0.9046876114723798858579300473216770030017e30) }, 
      { SC_(0.5732621002197265625e2), SC_(0.1e1), SC_(0.1744402777746354370941916545967512574427e-1), SC_(0.5632621002197265625e2) }, 
      { SC_(0.5732621002197265625e2), SC_(0.3e1), SC_(0.5041228784640157070882863788866523052928e-5), SC_(0.1692976225938017575445293516622768947855e6) }, 
      { SC_(0.5732621002197265625e2), SC_(0.5e1), SC_(0.1362649746061762165780899778729496018362e-8), SC_(0.4724010543573353489898967888345099619178e9) }, 
      { SC_(0.5732621002197265625e2), SC_(0.7e1), SC_(0.3452470877574091776976939943305868253657e-12), SC_(0.1220237256004918374402794588004321635773e13) }, 
      { SC_(0.5732621002197265625e2), SC_(0.9e1), SC_(0.8215889635572593253088457299280361530952e-16), SC_(0.2908739076547419505386953128366070531788e16) }, 
      { SC_(0.5732621002197265625e2), SC_(0.11e2), SC_(0.1839861990383783313116790937960398559897e-19), SC_(0.6377247376024960772758581650103371965196e19) }, 
      { SC_(0.5732621002197265625e2), SC_(0.13e2), SC_(0.3884189924419906546211438160184542530819e-23), SC_(0.1281277708500950134229574278029254559604e23) }, 
      { SC_(0.5732621002197265625e2), SC_(0.15e2), SC_(0.7743442825181098725953308420937013100822e-27), SC_(0.2349650964632549829273721574544611802837e26) }, 
      { SC_(0.5732621002197265625e2), SC_(0.17e2), SC_(0.1460088396118344727050455134091626254268e-30), SC_(0.3915762470471681302080112870283482585318e29) }, 
      { SC_(0.5732621002197265625e2), SC_(0.19e2), SC_(0.2607900661303547815997784904334708204525e-34), SC_(0.5901933463224344925351004264635232794604e32) }, 
      { SC_(0.6708917999267578125e2), SC_(0.1e1), SC_(0.1490553320385152100190219767685565484466e-1), SC_(0.6608917999267578125e2) }, 
      { SC_(0.6708917999267578125e2), SC_(0.3e1), SC_(0.3168541314348230244338176586647618066319e-5), SC_(0.2756918187852909356618802405591850401834e6) }, 
      { SC_(0.6708917999267578125e2), SC_(0.5e1), SC_(0.6359235238270467694306514762948600692938e-9), SC_(0.1079927711069486764606829447481594714541e10) }, 
      { SC_(0.6708917999267578125e2), SC_(0.7e1), SC_(0.1206928980483395131401616270347952345323e-12), SC_(0.3964197272645173254186880587126054169797e13) }, 
      { SC_(0.6708917999267578125e2), SC_(0.9e1), SC_(0.2169449603169113441576634602908768007594e-16), SC_(0.1360687726333208376708933418787850648315e17) }, 
      { SC_(0.6708917999267578125e2), SC_(0.11e2), SC_(0.3698564833403065685495438101713488301888e-20), SC_(0.4357038155827756495735598627982153402271e20) }, 
      { SC_(0.6708917999267578125e2), SC_(0.13e2), SC_(0.5988599929974102276075093857646472184211e-24), SC_(0.1298279108340255309242599851104961474616e24) }, 
      { SC_(0.6708917999267578125e2), SC_(0.15e2), SC_(0.9221223430860084208480660478607176694238e-28), SC_(0.3590224502635946562912344519237920265067e27) }, 
      { SC_(0.6708917999267578125e2), SC_(0.17e2), SC_(0.1351942294317151246672282989779576780642e-31), SC_(0.9187438830712173265580555519935862232477e30) }, 
      { SC_(0.6708917999267578125e2), SC_(0.19e2), SC_(0.1889486089615175900821500798178282183061e-35), SC_(0.2168840476376953444396651759617824397927e34) }, 
      { SC_(0.8427097320556640625e2), SC_(0.1e1), SC_(0.1186648215822368525285940556232297759327e-1), SC_(0.8327097320556640625e2) }, 
      { SC_(0.8427097320556640625e2), SC_(0.3e1), SC_(0.1613080620689716420208484819235178725516e-5), SC_(0.5567698833397093278727574272579659009352e6) }, 
      { SC_(0.8427097320556640625e2), SC_(0.5e1), SC_(0.209395980014543864110860203206230236003e-9), SC_(0.3542814829846800003048627572579833469938e10) }, 
      { SC_(0.8427097320556640625e2), SC_(0.7e1), SC_(0.259842356333310682276090002104860605906e-13), SC_(0.2142720722760714805908684600682932675833e14) }, 
      { SC_(0.8427097320556640625e2), SC_(0.9e1), SC_(0.3085404888580255552989822799675831167521e-17), SC_(0.1230133905750725915299263587754107304015e18) }, 
      { SC_(0.8427097320556640625e2), SC_(0.11e2), SC_(0.3509034712860222962760251333254756074456e-21), SC_(0.6694273682440183097651850852425821561079e21) }, 
      { SC_(0.8427097320556640625e2), SC_(0.13e2), SC_(0.382588314145346844154066023890122614083e-25), SC_(0.3448101613978414848601011906343645503239e25) }, 
      { SC_(0.8427097320556640625e2), SC_(0.15e2), SC_(0.4002424816272686355251473755381408937122e-29), SC_(0.167844576749702313295927282736013280741e29) }, 
      { SC_(0.8427097320556640625e2), SC_(0.17e2), SC_(0.4020922226841006912343851260222267320224e-33), SC_(0.770852202612626995971591900878598550869e32) }, 
      { SC_(0.8427097320556640625e2), SC_(0.19e2), SC_(0.3882292927715049465002372600227544504974e-37), SC_(0.3334375868469712976869247382063715353114e36) }, 
      { SC_(0.89811798095703125e2), SC_(0.1e1), SC_(0.1113439460297191290516702101596593625518e-1), SC_(0.88811798095703125e2) }, 
      { SC_(0.89811798095703125e2), SC_(0.3e1), SC_(0.1335444490742688370916398221699506212709e-5), SC_(0.6770212257637661566889164532767608761787e6) }, 
      { SC_(0.89811798095703125e2), SC_(0.5e1), SC_(0.1533787499877055704851922853862331905913e-9), SC_(0.4927260887442264107449722332043254688884e10) }, 
      { SC_(0.89811798095703125e2), SC_(0.7e1), SC_(0.1688432955853503975755394195633939376132e-13), SC_(0.341981750103237950165321335502262598208e14) }, 
      { SC_(0.89811798095703125e2), SC_(0.9e1), SC_(0.1783053159360378987833322614212698623092e-17), SC_(0.2260963953658029194233890896268059400698e18) }, 
      { SC_(0.89811798095703125e2), SC_(0.11e2), SC_(0.1807896689731037912191952441414464398209e-21), SC_(0.1422171495262588623348401113709734075071e22) }, 
      { SC_(0.89811798095703125e2), SC_(0.13e2), SC_(0.1761424939222111582165573895943048297437e-25), SC_(0.850012578933500583549945901967278093095e25) }, 
      { SC_(0.89811798095703125e2), SC_(0.15e2), SC_(0.1650343978544310543504662580064669574542e-29), SC_(0.4820945735438993461637563603676492585253e29) }, 
      { SC_(0.89811798095703125e2), SC_(0.17e2), SC_(0.1488093455877324743839187146760945291604e-33), SC_(0.2590954487884657231576363385739495374147e33) }, 
      { SC_(0.89811798095703125e2), SC_(0.19e2), SC_(0.1292244496857133721942784586550645245778e-37), SC_(0.1317532108625735103660185175445868182099e37) }, 
      { SC_(0.9314194488525390625e2), SC_(0.1e1), SC_(0.1073630147225236337144701789380848326069e-1), SC_(0.9214194488525390625e2) }, 
      { SC_(0.9314194488525390625e2), SC_(0.3e1), SC_(0.1198669642925642401979083837454061384817e-5), SC_(0.7570116981991056119860594719739310676232e6) }, 
      { SC_(0.9314194488525390625e2), SC_(0.5e1), SC_(0.1283452526004013814258198209074314658733e-9), SC_(0.5947950219971087430537343410499591217973e10) }, 
      { SC_(0.9314194488525390625e2), SC_(0.7e1), SC_(0.1319069609528261818418334198064385877966e-13), SC_(0.446487440194934312111488167312319649152e14) }, 
      { SC_(0.9314194488525390625e2), SC_(0.9e1), SC_(0.1302328043147194287075115031894665144018e-17), SC_(0.3198639965807964312742815927019467533109e18) }, 
      { SC_(0.9314194488525390625e2), SC_(0.11e2), SC_(0.1236177836919721403765737215433819476809e-21), SC_(0.218449231007890018378859910694326655596e22) }, 
      { SC_(0.9314194488525390625e2), SC_(0.13e2), SC_(0.1128961840427586301269384284601706076889e-25), SC_(0.1420547666238493403538237866215459583699e26) }, 
      { SC_(0.9314194488525390625e2), SC_(0.15e2), SC_(0.9927335423863778471081674966421328808928e-30), SC_(0.8785100738704468872370378063630945463091e29) }, 
      { SC_(0.9314194488525390625e2), SC_(0.17e2), SC_(0.8410984479269716633215735173087903089852e-34), SC_(0.5160137754598078173774901830327704546949e33) }, 
      { SC_(0.9314194488525390625e2), SC_(0.19e2), SC_(0.6870939085563419432397431420737067143848e-38), SC_(0.2874800432534232773928956032078197165945e37) }, 
      { SC_(0.12710662078857421875e3), SC_(0.1e1), SC_(0.7867410791003353577486451327268430675675e-2), SC_(0.12610662078857421875e3) }, 
      { SC_(0.12710662078857421875e3), SC_(0.3e1), SC_(0.4756765450806589562531023018048496458968e-6), SC_(0.195800200705290083112997123748755257111e7) }, 
      { SC_(0.12710662078857421875e3), SC_(0.5e1), SC_(0.2788609589402406817185362690366395689257e-10), SC_(0.2943294748730343246175288002751992159513e11) }, 
      { SC_(0.12710662078857421875e3), SC_(0.7e1), SC_(0.1585854996116424482320092732249935154629e-14), SC_(0.4281230296503233084991678344162952208933e15) }, 
      { SC_(0.12710662078857421875e3), SC_(0.9e1), SC_(0.8752590775298130060265069047589397445736e-19), SC_(0.6022526744410914057834240385554659208174e19) }, 
      { SC_(0.12710662078857421875e3), SC_(0.11e2), SC_(0.4690281889744855025211609066562827248911e-23), SC_(0.8188741692549685597026365875536999321889e23) }, 
      { SC_(0.12710662078857421875e3), SC_(0.13e2), SC_(0.2441387098253283794183905419926209440688e-27), SC_(0.1075544343110230463520754387303580459511e28) }, 
      { SC_(0.12710662078857421875e3), SC_(0.15e2), SC_(0.1234896600646651797900206200766689032378e-31), SC_(0.1363790339503517746981497053843986612084e32) }, 
      { SC_(0.12710662078857421875e3), SC_(0.17e2), SC_(0.6072346650919668483463740483655999746732e-36), SC_(0.1668403080561633578115535406759464831818e36) }, 
      { SC_(0.1461273193359375e3), SC_(0.1e1), SC_(0.6843347325773238936574567174153666228098e-2), SC_(0.1451273193359375e3) }, 
      { SC_(0.1461273193359375e3), SC_(0.3e1), SC_(0.3140075547804910820730348007344007847771e-6), SC_(0.2993767158806684796218178234994411468506e7) }, 
      { SC_(0.1461273193359375e3), SC_(0.5e1), SC_(0.140256551243744605089693617870639830199e-10), SC_(0.6004912412162251444625808447134811783596e11) }, 
      { SC_(0.1461273193359375e3), SC_(0.7e1), SC_(0.6100605814397355322796047543443592595512e-15), SC_(0.1170689999491180219069492096430804603347e16) }, 
      { SC_(0.1461273193359375e3), SC_(0.9e1), SC_(0.25848816263883092276191275669970092037e-19), SC_(0.2217407326267892687686111316555017262592e20) }, 
      { SC_(0.1461273193359375e3), SC_(0.11e2), SC_(0.1067267952309297162763126740178063278718e-23), SC_(0.4078814285738904419812600606066702004165e24) }, 
      { SC_(0.1461273193359375e3), SC_(0.13e2), SC_(0.4295511230508811514272844224670430000081e-28), SC_(0.7283135060320315376814792476942850201157e28) }, 
      { SC_(0.1461273193359375e3), SC_(0.15e2), SC_(0.1685794679612132385053123312043503744524e-32), SC_(0.1261839651950400169932984542132106432972e33) }, 
      { SC_(0.1461273193359375e3), SC_(0.17e2), SC_(0.6453261961067914938560421194741957455187e-37), SC_(0.2120268147381352001198535387213620993483e37) }, 
      { SC_(0.15159515380859375e3), SC_(0.1e1), SC_(0.6596516939206477341584347766569299864921e-2), SC_(0.15059515380859375e3) }, 
      { SC_(0.15159515380859375e3), SC_(0.3e1), SC_(0.2814468728106491520838410045316091059219e-6), SC_(0.3347596975769214421006836346350610256195e7) }, 
      { SC_(0.15159515380859375e3), SC_(0.5e1), SC_(0.1170050174122274219289716906957470641344e-10), SC_(0.7243106622107697753701767427475453458565e11) }, 
      { SC_(0.15159515380859375e3), SC_(0.7e1), SC_(0.4741145783380803523167351947785780908503e-15), SC_(0.1524844421965691280990505705602018747263e16) }, 
      { SC_(0.15159515380859375e3), SC_(0.9e1), SC_(0.1873154920069057149770578865983941992405e-19), SC_(0.312226732797086143115011497185338443838e20) }, 
      { SC_(0.15159515380859375e3), SC_(0.11e2), SC_(0.7217934379337425962152588040048356136259e-24), SC_(0.6215682541734979693475414708593432978635e24) }, 
      { SC_(0.15159515380859375e3), SC_(0.13e2), SC_(0.2713531689941190571783863494210664248978e-28), SC_(0.1202561266975388195941606627628971416737e29) }, 
      { SC_(0.15159515380859375e3), SC_(0.15e2), SC_(0.9955663999437593890036396769373434643706e-33), SC_(0.2260193601781729884970189178049172916132e33) }, 
      { SC_(0.15159515380859375e3), SC_(0.17e2), SC_(0.3565713215942443442999683947434689182014e-37), SC_(0.4124955163635293971994182082506455289599e37) }, 
      { SC_(0.1645175628662109375e3), SC_(0.1e1), SC_(0.6078378396677444992372811165607151963077e-2), SC_(0.1635175628662109375e3) }, 
      { SC_(0.1645175628662109375e3), SC_(0.3e1), SC_(0.2205380873097440806860405853291950753265e-6), SC_(0.4292244566121655237562748652635491453111e7) }, 
      { SC_(0.1645175628662109375e3), SC_(0.5e1), SC_(0.7812285172733240207364672610505703104254e-11), SC_(0.1099045120729930198068250257000481111706e12) }, 
      { SC_(0.1645175628662109375e3), SC_(0.7e1), SC_(0.2702677780688999265822439850657810150329e-15), SC_(0.2744238752447014653148021426722207627682e16) }, 
      { SC_(0.1645175628662109375e3), SC_(0.9e1), SC_(0.9133818131191891504759712733991113958411e-20), SC_(0.6679814643612934693289752070516990660519e20) }, 
      { SC_(0.1645175628662109375e3), SC_(0.11e2), SC_(0.301626699016090637156467528907696851999e-24), SC_(0.1584529497354778901524029561541701436987e25) }, 
      { SC_(0.1645175628662109375e3), SC_(0.13e2), SC_(0.9735567644978941723183432881296453501902e-29), SC_(0.3661703384265443683470603906931571581675e29) }, 
      { SC_(0.1645175628662109375e3), SC_(0.15e2), SC_(0.3072125850090865013523395726218750822042e-33), SC_(0.8240670485158705651099714124647613897701e33) }, 
      { SC_(0.1645175628662109375e3), SC_(0.17e2), SC_(0.9480092992913423702080657306401947719897e-38), SC_(0.1805444286999578960267521449296940404066e38) }, 
      { SC_(0.16461895751953125e3), SC_(0.1e1), SC_(0.6074634507883788504540218314592952400656e-2), SC_(0.16361895751953125e3) }, 
      { SC_(0.16461895751953125e3), SC_(0.3e1), SC_(0.2201332742551199325713709533670328544111e-6), SC_(0.4300283572285784977111688931472599506378e7) }, 
      { SC_(0.16461895751953125e3), SC_(0.5e1), SC_(0.7788541854008919998266193972879733577099e-11), SC_(0.1102499415739219045543024521597047724335e12) }, 
      { SC_(0.16461895751953125e3), SC_(0.7e1), SC_(0.2691252735456801972892144185401932482745e-15), SC_(0.2756397897927628139714249621840003804363e16) }, 
      { SC_(0.16461895751953125e3), SC_(0.9e1), SC_(0.9084493849023664376903291056109451932335e-20), SC_(0.6718135215809466157643090447862959131928e20) }, 
      { SC_(0.16461895751953125e3), SC_(0.11e2), SC_(0.299648563361403962549091785801301281677e-24), SC_(0.1595718555038892084761727748419528720606e25) }, 
      { SC_(0.16461895751953125e3), SC_(0.13e2), SC_(0.9660586377062316532671879717337459492371e-29), SC_(0.369248112540577997190395267666155963113e29) }, 
      { SC_(0.16461895751953125e3), SC_(0.15e2), SC_(0.304499525945193970754803344804987526429e-33), SC_(0.8321172897192656490917059234703493962031e33) }, 
      { SC_(0.16461895751953125e3), SC_(0.17e2), SC_(0.9385796160679485820225356016712124423217e-38), SC_(0.1825580089607805279229537669486976536522e38) }, 
      { SC_(0.1900754241943359375e3), SC_(0.1e1), SC_(0.5261069410938602687387265235334034477441e-2), SC_(0.1890754241943359375e3) }, 
      { SC_(0.1900754241943359375e3), SC_(0.3e1), SC_(0.1433499012867343334427625347910197380543e-6), SC_(0.6652484511667035082549404023666284047067e7) }, 
      { SC_(0.1900754241943359375e3), SC_(0.5e1), SC_(0.3825602622303828512007981757322474714134e-11), SC_(0.2290981822147728430172148458292863371602e12) }, 
      { SC_(0.1900754241943359375e3), SC_(0.7e1), SC_(0.1000170712684688869093666734448899735268e-15), SC_(0.772053688814663031296777332295661575577e16) }, 
      { SC_(0.1900754241943359375e3), SC_(0.9e1), SC_(0.2562188446596318913021427533537801457325e-20), SC_(0.2545413505346771866533531375091737012538e21) }, 
      { SC_(0.1900754241943359375e3), SC_(0.11e2), SC_(0.6432794420061412959010552510461479377507e-25), SC_(0.8208216051152292122006711149420720664007e25) }, 
      { SC_(0.1900754241943359375e3), SC_(0.13e2), SC_(0.1583168643880265318797163963590872071244e-29), SC_(0.2588278814218988926866644375562441337541e30) }, 
      { SC_(0.1900754241943359375e3), SC_(0.15e2), SC_(0.3820138447649697048871342926349317943583e-34), SC_(0.7978752401651092215783220808668429278738e34) }, 
      { SC_(0.1900754241943359375e3), SC_(0.17e2), SC_(0.9039393276841188064583115373807867874483e-39), SC_(0.2403852716512804366596487028429967488599e39) }, 
      { SC_(0.19228924560546875e3), SC_(0.1e1), SC_(0.5200498846678920934578905286105202815963e-2), SC_(0.19128924560546875e3) }, 
      { SC_(0.19228924560546875e3), SC_(0.3e1), SC_(0.1384804771780416349572449360120986661323e-6), SC_(0.6890182721947382414100502501241862773895e7) }, 
      { SC_(0.19228924560546875e3), SC_(0.5e1), SC_(0.3612548760454780058130339253872345336028e-11), SC_(0.242979198378728992356654168561851726046e12) }, 
      { SC_(0.19228924560546875e3), SC_(0.7e1), SC_(0.9234452358142830367952048890690541027504e-16), SC_(0.8387008671431024081454643275024053858084e16) }, 
      { SC_(0.19228924560546875e3), SC_(0.9e1), SC_(0.2313500784493344895912716776617824202671e-20), SC_(0.283298364949157012739729209926861816494e21) }, 
      { SC_(0.19228924560546875e3), SC_(0.11e2), SC_(0.5681673642992491608895977423530118958427e-25), SC_(0.9362183678728566564870866597854197912608e25) }, 
      { SC_(0.19228924560546875e3), SC_(0.13e2), SC_(0.1368095376501954830607269915036171057433e-29), SC_(0.3026225028019096153622851894057081084744e30) }, 
      { SC_(0.19228924560546875e3), SC_(0.15e2), SC_(0.3230528589087087104485554346193884670649e-34), SC_(0.9565523832902803773297980989361219407399e34) }, 
      { SC_(0.19228924560546875e3), SC_(0.17e2), SC_(0.7482211335792048528718581996734357828283e-39), SC_(0.2955900761261892848473762268395051091364e39) }, 
      { SC_(0.218025848388671875e3), SC_(0.1e1), SC_(0.4586612125995780395228568457159589830789e-2), SC_(0.217025848388671875e3) }, 
      { SC_(0.218025848388671875e3), SC_(0.3e1), SC_(0.9517501181858641419252722414429361748138e-7), SC_(0.1008109835438870626191487644973676651716e8) }, 
      { SC_(0.218025848388671875e3), SC_(0.5e1), SC_(0.193943993954055604304910270889833561943e-11), SC_(0.4596278996487340212691736168175492263426e12) }, 
      { SC_(0.218025848388671875e3), SC_(0.7e1), SC_(0.3881709264892642744540975279173258431825e-16), SC_(0.205651010251540840475343366875533875512e17) }, 
      { SC_(0.218025848388671875e3), SC_(0.9e1), SC_(0.7631896786870356676948553272530092350159e-21), SC_(0.9028250275438757723326198506128512708297e21) }, 
      { SC_(0.218025848388671875e3), SC_(0.11e2), SC_(0.1474256668331860250887706591410200087125e-25), SC_(0.3888171966661098402376211452617202152346e26) }, 
      { SC_(0.218025848388671875e3), SC_(0.13e2), SC_(0.2798413963009846872720690855863686540029e-30), SC_(0.1642388114748076095339184748848267222298e31) }, 
      { SC_(0.218025848388671875e3), SC_(0.15e2), SC_(0.522053505136783860450894755535226562266e-35), SC_(0.6803185611143161435640527806051915880545e35) }, 
      { SC_(0.2378699798583984375e3), SC_(0.1e1), SC_(0.4203977318177307438998676442504791986322e-2), SC_(0.2368699798583984375e3) }, 
      { SC_(0.2378699798583984375e3), SC_(0.3e1), SC_(0.7337073887038401084510742741413977278066e-7), SC_(0.1312230729131015162911566562797816004604e8) }, 
      { SC_(0.2378699798583984375e3), SC_(0.5e1), SC_(0.1259384221515882824908863286623614691569e-11), SC_(0.7146578812667731938470483214291089236169e12) }, 
      { SC_(0.2378699798583984375e3), SC_(0.7e1), SC_(0.2126307488190618496285152514871326625392e-16), SC_(0.3825693533185043741461763953867673276231e17) }, 
      { SC_(0.2378699798583984375e3), SC_(0.9e1), SC_(0.3531709857006460790660631676199756407449e-21), SC_(0.2012710285654697856614104382945664580557e22) }, 
      { SC_(0.2378699798583984375e3), SC_(0.11e2), SC_(0.5771554545008699980336762812434398816258e-26), SC_(0.1040507973109529765694971815692678935317e27) }, 
      { SC_(0.2378699798583984375e3), SC_(0.13e2), SC_(0.9281244421003152741682573475481994446925e-31), SC_(0.5284883358835913909199591013057957458016e31) }, 
      { SC_(0.2378699798583984375e3), SC_(0.15e2), SC_(0.1468862378594779541244835664098708765596e-35), SC_(0.2636834307294278205059271375917019986283e36) }, 
      { SC_(0.2396336517333984375e3), SC_(0.1e1), SC_(0.4173036603024929398213813492338661124862e-2), SC_(0.2386336517333984375e3) }, 
      { SC_(0.2396336517333984375e3), SC_(0.3e1), SC_(0.7176925119148455626188464113809538811493e-7), SC_(0.1341887585023158702815848641876073088497e8) }, 
      { SC_(0.2396336517333984375e3), SC_(0.5e1), SC_(0.1214087829839193311748899044076091197599e-11), SC_(0.7418972281368740526297060256166891755519e12) }, 
      { SC_(0.2396336517333984375e3), SC_(0.7e1), SC_(0.2020440394443324313968944422690969321352e-16), SC_(0.4032289302272052201817721659456643269678e17) }, 
      { SC_(0.2396336517333984375e3), SC_(0.9e1), SC_(0.3308141271161855221906713800841144527579e-21), SC_(0.2154150355882571003560350589168197390899e22) }, 
      { SC_(0.2396336517333984375e3), SC_(0.11e2), SC_(0.5329923909490487799880018518255161273404e-26), SC_(0.113097159669886982043703458256007790423e27) }, 
      { SC_(0.2396336517333984375e3), SC_(0.13e2), SC_(0.8451093508158926832702660794846811220769e-31), SC_(0.5834619783240304562182451239383502427806e31) }, 
      { SC_(0.2396336517333984375e3), SC_(0.15e2), SC_(0.1318909002880679972666615314264026036024e-35), SC_(0.2957271852656461536789297467897909023669e36) }, 
      { SC_(0.2402838592529296875e3), SC_(0.1e1), SC_(0.416174437646005716683231471058140145548e-2), SC_(0.2392838592529296875e3) }, 
      { SC_(0.2402838592529296875e3), SC_(0.3e1), SC_(0.7119059913810169544717804123416115348579e-7), SC_(0.1352932804089974760797687736157968174666e8) }, 
      { SC_(0.2402838592529296875e3), SC_(0.5e1), SC_(0.119788348942875084133773888206856942214e-11), SC_(0.7521464634400629893693860969377187532556e12) }, 
      { SC_(0.2402838592529296875e3), SC_(0.7e1), SC_(0.1982940385943767333968884539729509742242e-16), SC_(0.41108296328096429708861234211995370188e17) }, 
      { SC_(0.2402838592529296875e3), SC_(0.9e1), SC_(0.3229723925503949352255112570136653530107e-21), SC_(0.2208481862402442717455341251684399357461e22) }, 
      { SC_(0.2402838592529296875e3), SC_(0.11e2), SC_(0.517652598316255671884628601969418476545e-26), SC_(0.1166086638308486633196885006984835989364e27) }, 
      { SC_(0.2402838592529296875e3), SC_(0.13e2), SC_(0.8165529252358491506884135141043317164656e-31), SC_(0.6050268105028971119072011722657983905528e31) }, 
      { SC_(0.2402838592529296875e3), SC_(0.15e2), SC_(0.1267821259689119178036978433293359702892e-35), SC_(0.3084311791351099946998151524574241380766e36) }, 
      { SC_(0.2446023712158203125e3), SC_(0.1e1), SC_(0.4088267807991398268562189973076545665726e-2), SC_(0.2436023712158203125e3) }, 
      { SC_(0.2446023712158203125e3), SC_(0.3e1), SC_(0.675008953440750234843128316666917127337e-7), SC_(0.1427834084973501079689484072332561481744e8) }, 
      { SC_(0.2446023712158203125e3), SC_(0.5e1), SC_(0.1096603094903015544428226380640814033626e-11), SC_(0.8231306247287089667176874048268970264256e12) }, 
      { SC_(0.2446023712158203125e3), SC_(0.7e1), SC_(0.1753135905193477392221071837121071626996e-16), SC_(0.4666532403500354283334158700893903515013e17) }, 
      { SC_(0.2446023712158203125e3), SC_(0.9e1), SC_(0.2758439299721590466200465663819285937366e-21), SC_(0.260131554194111224375528217072823422931e22) }, 
      { SC_(0.2446023712158203125e3), SC_(0.11e2), SC_(0.4272161654139629412902095558375556054415e-26), SC_(0.1425616390697479621614555443500242747887e27) }, 
      { SC_(0.2446023712158203125e3), SC_(0.13e2), SC_(0.6513615730195512823137766903610707082679e-31), SC_(0.7679975227568097316239522607894613615454e31) }, 
      { SC_(0.2446023712158203125e3), SC_(0.15e2), SC_(0.9777769042515169130578966217914304972965e-36), SC_(0.4066305058943527799012057784947902799586e36) }, 
      { SC_(0.2506675567626953125e3), SC_(0.1e1), SC_(0.3989347536293621238064935128969891127506e-2), SC_(0.2496675567626953125e3) }, 
      { SC_(0.2506675567626953125e3), SC_(0.3e1), SC_(0.6273720379307727725969616239885831681538e-7), SC_(0.1537624741355772771577292701294936705381e8) }, 
      { SC_(0.2506675567626953125e3), SC_(0.5e1), SC_(0.9711506618829705312909883481415605752997e-12), SC_(0.931773162074880986863739757384723927042e12) }, 
      { SC_(0.2506675567626953125e3), SC_(0.7e1), SC_(0.1479926042979277364594311329110873176647e-16), SC_(0.5555002914234808883854214712572599403515e17) }, 
      { SC_(0.2506675567626953125e3), SC_(0.9e1), SC_(0.2220436267734040821989616141535115554687e-21), SC_(0.3257724545763733239455669462423380942792e22) }, 
      { SC_(0.2506675567626953125e3), SC_(0.11e2), SC_(0.3280451636411783880817440530921953275331e-26), SC_(0.1879062206800944374946022762363162566372e27) }, 
      { SC_(0.2506675567626953125e3), SC_(0.13e2), SC_(0.4772844943345256088303076739119137231116e-31), SC_(0.1065870510318681455449175431176371850927e32) }, 
      { SC_(0.2506675567626953125e3), SC_(0.15e2), SC_(0.6839430210956838705822977255602522791877e-36), SC_(0.594487836790228861516910426475386693773e36) }, 
      { SC_(0.2636507568359375e3), SC_(0.1e1), SC_(0.3792896375496741174177376243560248112465e-2), SC_(0.2626507568359375e3) }, 
      { SC_(0.2636507568359375e3), SC_(0.3e1), SC_(0.5394941997103895837284167682236434180705e-7), SC_(0.1791264183242307000000437255948781967163e8) }, 
      { SC_(0.2636507568359375e3), SC_(0.5e1), SC_(0.7559193861982150138393393986991315957689e-12), SC_(0.1202992690472770559904649505606003814448e13) }, 
      { SC_(0.2636507568359375e3), SC_(0.7e1), SC_(0.1043483944902851139229023298184724891181e-16), SC_(0.7954940952306765555225249693645376903255e17) }, 
      { SC_(0.2636507568359375e3), SC_(0.9e1), SC_(0.1419271906061710275278584620049739523711e-21), SC_(0.5178798509667130333415308021207901325281e22) }, 
      { SC_(0.2636507568359375e3), SC_(0.11e2), SC_(0.1902226576385359426159396915871952052869e-26), SC_(0.3318835908817403429574080705532597847026e27) }, 
      { SC_(0.2636507568359375e3), SC_(0.13e2), SC_(0.2512593637222524929452981878672388791736e-31), SC_(0.2093403960863870474024148218903287575664e32) }, 
      { SC_(0.2636507568359375e3), SC_(0.15e2), SC_(0.3271082754229749735312410902642850923475e-36), SC_(0.1299498294934523204977507758178756030045e37) }, 
      { SC_(0.271831787109375e3), SC_(0.1e1), SC_(0.3678745633959420633487901722885192779384e-2), SC_(0.270831787109375e3) }, 
      { SC_(0.271831787109375e3), SC_(0.3e1), SC_(0.4924032731596502751976009876767690645394e-7), SC_(0.1964596492369054605660494416952133178711e8) }, 
      { SC_(0.271831787109375e3), SC_(0.5e1), SC_(0.6495456161893755702308272439128525814828e-12), SC_(0.1404019205039827281756688018301247600217e13) }, 
      { SC_(0.271831787109375e3), SC_(0.7e1), SC_(0.8445235550868735241912130607667853334817e-17), SC_(0.9884394502830581280217674894061376874235e17) }, 
      { SC_(0.271831787109375e3), SC_(0.9e1), SC_(0.1082361756878397050455619345941084436968e-21), SC_(0.6854173250900471775903524943465172192904e22) }, 
      { SC_(0.271831787109375e3), SC_(0.11e2), SC_(0.1367527916530076551512558387910771274925e-26), SC_(0.4680992709513771555839482351542631373181e27) }, 
      { SC_(0.271831787109375e3), SC_(0.13e2), SC_(0.1703518880648580763641852827220677410372e-31), SC_(0.3148095191897355169361499293068321504645e32) }, 
      { SC_(0.271831787109375e3), SC_(0.15e2), SC_(0.2092415709337656865957490293080909938549e-36), SC_(0.2084649705221358565843694703612661831578e37) }, 
      { SC_(0.274099365234375e3), SC_(0.1e1), SC_(0.364831198767982143222966551499005532145e-2), SC_(0.273099365234375e3) }, 
      { SC_(0.274099365234375e3), SC_(0.3e1), SC_(0.4803269712170291958762286578761598803649e-7), SC_(0.2014543827085088203602936118841171264648e8) }, 
      { SC_(0.274099365234375e3), SC_(0.5e1), SC_(0.6233061977138868663684224253038856376853e-12), SC_(0.1464242327106177610668728497392808429733e13) }, 
      { SC_(0.274099365234375e3), SC_(0.7e1), SC_(0.7973159863070018558286540553872979581751e-17), SC_(0.1048531781239106252425666771402693412894e18) }, 
      { SC_(0.274099365234375e3), SC_(0.9e1), SC_(0.1005468566547100377514670688591284526002e-21), SC_(0.7396633923105870428846178825572216613732e22) }, 
      { SC_(0.274099365234375e3), SC_(0.11e2), SC_(0.1250141979824775621810702988292219373285e-26), SC_(0.5139504878541688856369037060950164545717e27) }, 
      { SC_(0.274099365234375e3), SC_(0.13e2), SC_(0.1532661310316427362936292068175679370524e-31), SC_(0.3517167632289521085203290274879068687879e32) }, 
      { SC_(0.274099365234375e3), SC_(0.15e2), SC_(0.1852983963408025127050027652437224363032e-36), SC_(0.2370274853775499735793736259776542351768e37) }, 
      { SC_(0.274804931640625e3), SC_(0.1e1), SC_(0.3638944883666592336005387344183240775372e-2), SC_(0.273804931640625e3) }, 
      { SC_(0.274804931640625e3), SC_(0.3e1), SC_(0.4766500323634846786726418114758219069239e-7), SC_(0.2030256060269160057941917330026626586914e8) }, 
      { SC_(0.274804931640625e3), SC_(0.5e1), SC_(0.6154024546690911439951622301069331686792e-12), SC_(0.1483396562376533341738866147081245261408e13) }, 
      { SC_(0.274804931640625e3), SC_(0.7e1), SC_(0.7832477005907424889818045391405198637502e-17), SC_(0.1067856930955473531945270749186455957324e18) }, 
      { SC_(0.274804931640625e3), SC_(0.9e1), SC_(0.9827964089790961021148982989284943306226e-22), SC_(0.7573034896598354273614969311589563647814e22) }, 
      { SC_(0.274804931640625e3), SC_(0.11e2), SC_(0.121589512687081208208115625113120868527e-26), SC_(0.5290283392609316558714446432000706324911e27) }, 
      { SC_(0.274804931640625e3), SC_(0.13e2), SC_(0.1483336845938378842536785854889108110605e-31), SC_(0.3639906861316648922337742363934475695538e32) }, 
      { SC_(0.274804931640625e3), SC_(0.15e2), SC_(0.1784583808206143680516380935195677948469e-36), SC_(0.2466342921397522584830960161333299921649e37) }, 
      { SC_(0.28719293212890625e3), SC_(0.1e1), SC_(0.3481979840475847909058779449603208590017e-2), SC_(0.28619293212890625e3) }, 
      { SC_(0.28719293212890625e3), SC_(0.3e1), SC_(0.4177873173937715786615028868933817117241e-7), SC_(0.2319588437626001831290523114148527383804e8) }, 
      { SC_(0.28719293212890625e3), SC_(0.5e1), SC_(0.4944103935479594101728970184152086286306e-12), SC_(0.1853700117663054521198762979989883556474e13) }, 
      { SC_(0.28719293212890625e3), SC_(0.7e1), SC_(0.5771176926689689378272114553351095923104e-17), SC_(0.1460498293495902410425332026379780530262e18) }, 
      { SC_(0.28719293212890625e3), SC_(0.9e1), SC_(0.6645477608758422510175449153902904054049e-22), SC_(0.1134361728180550139843806606053711572247e23) }, 
      { SC_(0.28719293212890625e3), SC_(0.11e2), SC_(0.7549410333602551531197573935902332367997e-27), SC_(0.8684529178419808289808578708873987720728e27) }, 
      { SC_(0.28719293212890625e3), SC_(0.13e2), SC_(0.8461831166568759018593468368502015254964e-32), SC_(0.6552994599183951259948386008534097644671e32) }, 
      { SC_(0.28719293212890625e3), SC_(0.15e2), SC_(0.9358777379643248526116678325853529542453e-37), SC_(0.4872884452211613428565268037217322153101e37) }, 
      { SC_(0.2872945556640625e3), SC_(0.1e1), SC_(0.34807481739031415536832748605597495153e-2), SC_(0.2862945556640625e3) }, 
      { SC_(0.2872945556640625e3), SC_(0.3e1), SC_(0.4173456607681247504031635400359819979724e-7), SC_(0.2322068976483985302365908864885568618774e8) }, 
      { SC_(0.2872945556640625e3), SC_(0.5e1), SC_(0.493542599056095325492887019079469782537e-12), SC_(0.1857016860987350865488208769832611253273e13) }, 
      { SC_(0.2872945556640625e3), SC_(0.7e1), SC_(0.575704887226117173104059000343519557497e-17), SC_(0.1464171118451576900115689247386842164521e18) }, 
      { SC_(0.2872945556640625e3), SC_(0.9e1), SC_(0.6624639478608017189860202166580888604212e-22), SC_(0.1138043902274032262102313769657480009329e23) }, 
      { SC_(0.2872945556640625e3), SC_(0.11e2), SC_(0.7520584942137318140193092188213010036169e-27), SC_(0.871912063111857878002810464645372494142e27) }, 
      { SC_(0.2872945556640625e3), SC_(0.13e2), SC_(0.8423788942077451050455222863566182476902e-32), SC_(0.6583964742879698484706986690635311042633e32) }, 
      { SC_(0.2872945556640625e3), SC_(0.15e2), SC_(0.9310408458992971329277502791420183457416e-37), SC_(0.489956399730382818727393107483496092863e37) }, 
      { SC_(0.28788824462890625e3), SC_(0.1e1), SC_(0.3473570104569640055962131640759410960191e-2), SC_(0.28688824462890625e3) }, 
      { SC_(0.28788824462890625e3), SC_(0.3e1), SC_(0.4147778860826452996008042939379237489236e-7), SC_(0.2336595739914530255396130087319761514664e8) }, 
      { SC_(0.28788824462890625e3), SC_(0.5e1), SC_(0.4885092799811013921823782549177388581846e-12), SC_(0.1876488429114554752620527238325746098634e13) }, 
      { SC_(0.28788824462890625e3), SC_(0.7e1), SC_(0.5675297891024780138525697551464866109164e-17), SC_(0.1485786541228514073866161629333886138035e18) }, 
      { SC_(0.28788824462890625e3), SC_(0.9e1), SC_(0.6504343827584720578007790628197932503555e-22), SC_(0.115976844211059217259122774325677854357e23) }, 
      { SC_(0.28788824462890625e3), SC_(0.11e2), SC_(0.7354567247175934183847257682176508160719e-27), SC_(0.8923720939211117300320489938065609307863e27) }, 
      { SC_(0.28788824462890625e3), SC_(0.13e2), SC_(0.8205193867978273440011202644178884562983e-32), SC_(0.6767610329032719369025509390108872609635e32) }, 
      { SC_(0.28788824462890625e3), SC_(0.15e2), SC_(0.9033112602451792738749403271987921872272e-37), SC_(0.5058171670631253364671295649996237533421e37) }, 
      { SC_(0.289501678466796875e3), SC_(0.1e1), SC_(0.3454211406635041713966881609665888745256e-2), SC_(0.288501678466796875e3) }, 
      { SC_(0.289501678466796875e3), SC_(0.3e1), SC_(0.407905168480763018987021853172545228673e-7), SC_(0.2376380058306495433427585339813958853483e8) }, 
      { SC_(0.289501678466796875e3), SC_(0.5e1), SC_(0.4751385373606723027962691314425005391974e-12), SC_(0.1930231496923894088462545699714651073089e13) }, 
      { SC_(0.289501678466796875e3), SC_(0.7e1), SC_(0.5459747147595941934931644310213716724959e-17), SC_(0.154591661548185942785563127012845776958e18) }, 
      { SC_(0.289501678466796875e3), SC_(0.9e1), SC_(0.6189505505380654067781824225524105132565e-22), SC_(0.1220681936608413875283547987492080381155e23) }, 
      { SC_(0.289501678466796875e3), SC_(0.11e2), SC_(0.6923248423462699258122608833489787193542e-27), SC_(0.9501994073223823891184486514363262976698e27) }, 
      { SC_(0.289501678466796875e3), SC_(0.13e2), SC_(0.7641406071861718441256397914223803198376e-32), SC_(0.7290849633976240067942394862692220173534e32) }, 
      { SC_(0.289501678466796875e3), SC_(0.15e2), SC_(0.8323086212678717271324694441691502737994e-37), SC_(0.551375411474552213507390248281996458309e37) }, 
      { SC_(0.290340789794921875e3), SC_(0.1e1), SC_(0.3444228421043890893385637226929434835625e-2), SC_(0.289340789794921875e3) }, 
      { SC_(0.290340789794921875e3), SC_(0.3e1), SC_(0.404390772308938863697334002937411013455e-7), SC_(0.2397248344799799768131265409465413540602e8) }, 
      { SC_(0.290340789794921875e3), SC_(0.5e1), SC_(0.4683584166674361180389483263241938077867e-12), SC_(0.1958664738832016351565037051374224319343e13) }, 
      { SC_(0.290340789794921875e3), SC_(0.7e1), SC_(0.5351351314668937271340160893033367766944e-17), SC_(0.1578004983694902935556729547125288747567e18) }, 
      { SC_(0.290340789794921875e3), SC_(0.9e1), SC_(0.6032486205167581064858567225995659032751e-22), SC_(0.1253472175648567782767177252957740552768e23) }, 
      { SC_(0.290340789794921875e3), SC_(0.11e2), SC_(0.6709901097200500439708799760438557985054e-27), SC_(0.9816018026087682770199262928304104956695e27) }, 
      { SC_(0.290340789794921875e3), SC_(0.13e2), SC_(0.7364808408015348014875920182650010471344e-32), SC_(0.757750009443894137565133378045564307973e32) }, 
      { SC_(0.290340789794921875e3), SC_(0.15e2), SC_(0.7977567303667583794462380205536503660325e-37), SC_(0.5765560036226951637956770556326362477979e37) }, 
      { SC_(0.29069146728515625e3), SC_(0.1e1), SC_(0.3440073454302810870077806885983947303719e-2), SC_(0.28969146728515625e3) }, 
      { SC_(0.29069146728515625e3), SC_(0.3e1), SC_(0.4029340128900865341649997325071470796219e-7), SC_(0.2406005592837546327814379765186458826065e8) }, 
      { SC_(0.29069146728515625e3), SC_(0.5e1), SC_(0.4655593347102129154770919320328943988628e-12), SC_(0.197064624191144911113364924372333547971e13) }, 
      { SC_(0.29069146728515625e3), SC_(0.7e1), SC_(0.5306781300850624992667955983404647577365e-17), SC_(0.1591583373838064839072653291218129731538e18) }, 
      { SC_(0.29069146728515625e3), SC_(0.9e1), SC_(0.5968181020379241221614164786831856442513e-22), SC_(0.1267406078595540656088386383125599592152e23) }, 
      { SC_(0.29069146728515625e3), SC_(0.11e2), SC_(0.6622874185773110848120483926856882408505e-27), SC_(0.9950025958171749642234595698560649206203e27) }, 
      { SC_(0.29069146728515625e3), SC_(0.13e2), SC_(0.7252425880730941952837038289017818623456e-32), SC_(0.7700349214883739827198954590726953390616e32) }, 
      { SC_(0.29069146728515625e3), SC_(0.15e2), SC_(0.7837732137791901630412251772353086649926e-37), SC_(0.5873940084556647854075928357945884520601e37) }, 
      { SC_(0.291207244873046875e3), SC_(0.1e1), SC_(0.3433980498788601758552647643188802171892e-2), SC_(0.290207244873046875e3) }, 
      { SC_(0.291207244873046875e3), SC_(0.3e1), SC_(0.4008040930623875410783774854230681603441e-7), SC_(0.2418924493681085849559053713164757937193e8) }, 
      { SC_(0.291207244873046875e3), SC_(0.5e1), SC_(0.4614788198337042276507609088027282453366e-12), SC_(0.1988375146420684092396039255743712842102e13) }, 
      { SC_(0.291207244873046875e3), SC_(0.7e1), SC_(0.5241996237359538672911416208963837661703e-17), SC_(0.1611736435885476675751117506657723086633e18) }, 
      { SC_(0.291207244873046875e3), SC_(0.9e1), SC_(0.5874980228979750505195933021348442376062e-22), SC_(0.1288150308509289144242116755013782892893e23) }, 
      { SC_(0.291207244873046875e3), SC_(0.11e2), SC_(0.6497104124488598123554519089149390087186e-27), SC_(0.1015014875890825032948492161856198979056e28) }, 
      { SC_(0.291207244873046875e3), SC_(0.13e2), SC_(0.7090475834671838093657350842661830590173e-32), SC_(0.7884379604158280127712554109520427430725e32) }, 
      { SC_(0.291207244873046875e3), SC_(0.15e2), SC_(0.7636792489590183720543570028907531957389e-37), SC_(0.6036805286139762775881723279121968447932e37) }, 
      { SC_(0.294351806640625e3), SC_(0.1e1), SC_(0.33972952685862159057449623236968809744e-2), SC_(0.293351806640625e3) }, 
      { SC_(0.294351806640625e3), SC_(0.3e1), SC_(0.3881379282177214776636623282889873598749e-7), SC_(0.2498689343664573460409883409738540649414e8) }, 
      { SC_(0.294351806640625e3), SC_(0.5e1), SC_(0.4375088373240974671031998487110516857923e-12), SC_(0.2099244362868845821585772253776470963604e13) }, 
      { SC_(0.294351806640625e3), SC_(0.7e1), SC_(0.4866029054251045038186644286072296391012e-17), SC_(0.1739400555379920223170681407628313381261e18) }, 
      { SC_(0.294351806640625e3), SC_(0.9e1), SC_(0.534057883457178772917208250643286627359e-22), SC_(0.1421281681033299298280403078077015645206e23) }, 
      { SC_(0.294351806640625e3), SC_(0.11e2), SC_(0.5784500466126953910491646789719517325936e-27), SC_(0.1145149364382182705993366363639828841506e28) }, 
      { SC_(0.294351806640625e3), SC_(0.13e2), SC_(0.6183650292423694233820451668640331858573e-32), SC_(0.9097088412307421913798995051293929461461e32) }, 
      { SC_(0.294351806640625e3), SC_(0.15e2), SC_(0.6524731626576039436199662440884420606257e-37), SC_(0.7124547053047129902329409548948893697576e37) }, 
      { SC_(0.29787152099609375e3), SC_(0.1e1), SC_(0.3357152092472492109647570746796270004039e-2), SC_(0.29687152099609375e3) }, 
      { SC_(0.29787152099609375e3), SC_(0.3e1), SC_(0.3745857576153496103596756759785568454842e-7), SC_(0.2590028433522621662064011616166681051254e8) }, 
      { SC_(0.29787152099609375e3), SC_(0.5e1), SC_(0.4124278994306611649605113542682886173912e-12), SC_(0.2229149394453432862981100413241140703895e13) }, 
      { SC_(0.29787152099609375e3), SC_(0.7e1), SC_(0.4481254385408609056603897429430645730762e-17), SC_(0.1892483485866810077637251708385021969851e18) }, 
      { SC_(0.29787152099609375e3), SC_(0.9e1), SC_(0.4805556612415073905868174503601992803965e-22), SC_(0.1584682915857995126890517336563712708005e23) }, 
      { SC_(0.29787152099609375e3), SC_(0.11e2), SC_(0.5086482969169712932808559443461158258716e-27), SC_(0.1308665081238300833231561815310422586917e28) }, 
      { SC_(0.29787152099609375e3), SC_(0.13e2), SC_(0.5314446802305598153808326995941985254172e-32), SC_(0.1065733067256237279284265031964211394528e33) }, 
      { SC_(0.29787152099609375e3), SC_(0.15e2), SC_(0.5481525108002032281510522944958079149289e-37), SC_(0.8557747958232836453478265781438336038069e37) }, 
      { SC_(0.298941925048828125e3), SC_(0.1e1), SC_(0.3345131332236732968010854526498232035615e-2), SC_(0.297941925048828125e3) }, 
      { SC_(0.298941925048828125e3), SC_(0.3e1), SC_(0.3705896653431679485941827175484149138275e-7), SC_(0.2618241086285098069268428844225127249956e8) }, 
      { SC_(0.298941925048828125e3), SC_(0.5e1), SC_(0.4051450186662736366284562621407566077077e-12), SC_(0.2269904983065584876428858402786024561227e13) }, 
      { SC_(0.298941925048828125e3), SC_(0.7e1), SC_(0.4371220920128659338444328164220492742505e-17), SC_(0.1941268809835496579746004922828460068201e18) }, 
      { SC_(0.298941925048828125e3), SC_(0.9e1), SC_(0.4654869913634073404921977229252675829028e-22), SC_(0.1637581799972646839641245577548494961723e23) }, 
      { SC_(0.298941925048828125e3), SC_(0.11e2), SC_(0.489284975257170578658380454302158217284e-27), SC_(0.1362443397656620723242541241397155077558e28) }, 
      { SC_(0.298941925048828125e3), SC_(0.13e2), SC_(0.5076942804322773765508159231416954589399e-32), SC_(0.111786745604799935748770629080275328159e33) }, 
      { SC_(0.298941925048828125e3), SC_(0.15e2), SC_(0.5200735573667448543558639259673314877186e-37), SC_(0.9044325612703634083164448623285298649691e37) }
   } };
#undef SC_

