/* $Id: innconf-t.c 7748 2008-04-06 13:49:56Z iulius $ */
/* innconf test suite. */

#include "config.h"
#include "clibrary.h"

#include "inn/innconf.h"
#include "inn/messages.h"
#include "libtest.h"

static const char grep[] =
"egrep 'mta|organization|ovmethod|hismethod|path|pgpverify'\
 ../../samples/inn.conf > config/tmp";

int
main(void)
{
    struct innconf *standard;
    FILE *config;

    if (access("config/valid", F_OK) < 0)
        if (access("lib/config/valid", F_OK) == 0)
            chdir("lib");

    puts("9");

    ok(1, innconf_read("../../samples/inn.conf"));
    standard = innconf;
    innconf = NULL;
    if (system(grep) != 0)
        die("Unable to create stripped configuration file");
    ok(2, innconf_read("config/tmp"));
    unlink("config/tmp");
    ok(3, innconf_compare(standard, innconf));
    innconf_free(standard);
    innconf_free(innconf);
    innconf = NULL;
    ok(4, true);

    /* Checking inn.conf. */
    errors_capture();
    if (system(grep) != 0)
        die("Unable to create stripped configuration file");
    ok(5, innconf_check("config/tmp"));
    ok(6, errors == NULL);
    innconf_free(innconf);
    innconf = NULL;
    config = fopen("config/tmp", "a");
    if (config == NULL)
        sysdie("Unable to open stripped configuration file for append");
    fputs("foo: bar\n", config);
    fclose(config);
    ok(7, !innconf_check("config/tmp"));
    unlink("config/tmp");
    ok_string(8, "config/tmp:26: unknown parameter foo\n", errors);
    errors_uncapture();
    free(errors);
    errors = NULL;
    innconf_free(innconf);
    innconf = NULL;
    ok(9, true);

    return 0;
}
