/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    static final long serialVersionUID = 6680042567037222321L;
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this(0, 0);
    }

    public DefaultTableModel(int numRows, int numColumns) {
        Vector defaultNames = new Vector();
        for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
            defaultNames.addElement(super.getColumnName(columnIndex));
        }
    }

    public DefaultTableModel(Vector columnNames, int numRows) {
        Vector data = new Vector();
        int numColumns = columnNames == null ? 0 : columnNames.size();
        for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
            Vector rowData = new Vector();
            rowData.setSize(numColumns);
            data.addElement(rowData);
        }
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[] columnNames, int numRows) {
        this(DefaultTableModel.convertToVector(columnNames), numRows);
    }

    public DefaultTableModel(Vector data, Vector columnNames) {
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[][] data, Object[] columnNames) {
        this(DefaultTableModel.convertToVector(data), DefaultTableModel.convertToVector(columnNames));
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector data, Vector columnNames) {
        this.dataVector = data;
        this.columnIdentifiers = columnNames;
        int numRows = data.size();
        int numColumns = columnNames.size();
        for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
            Vector columnVector = (Vector)this.dataVector.get(rowIndex);
            columnVector.setSize(numColumns);
        }
    }

    public void setDataVector(Object[][] data, Object[] columnNames) {
        this.setDataVector(DefaultTableModel.convertToVector(data), DefaultTableModel.convertToVector(columnNames));
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent event) {
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.columnIdentifiers = columnIdentifiers;
        this.setColumnCount(columnIdentifiers.size());
    }

    public void setColumnIdentifiers(Object[] columnIdentifiers) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(columnIdentifiers));
    }

    public void setNumRows(int numRows) {
        this.setRowCount(numRows);
    }

    public void setRowCount(int rowCount) {
    }

    public void setColumnCount(int columnCount) {
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, new Vector(this.dataVector.size()));
    }

    public void addColumn(Object columnName, Vector columnData) {
    }

    public void addColumn(Object columnName, Object[] columnData) {
    }

    public void addRow(Vector rowData) {
    }

    public void addRow(Object[] rowData) {
        this.addRow(DefaultTableModel.convertToVector(rowData));
    }

    public void insertRow(int row, Vector rowData) {
        this.dataVector.add(row, rowData);
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, DefaultTableModel.convertToVector(rowData));
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        for (int index = 0; index < endIndex - startIndex; ++index) {
            Vector vector = (Vector)this.dataVector.remove(startIndex);
            this.dataVector.add(toIndex, vector);
        }
    }

    public void removeRow(int row) {
        this.dataVector.remove(row);
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        if (this.columnIdentifiers == null || column >= this.getColumnCount()) {
            return super.getColumnName(column);
        }
        return (String)this.columnIdentifiers.get(column);
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        Vector rowVector = (Vector)this.dataVector.get(row);
        return rowVector.get(column);
    }

    public void setValueAt(Object value, int row, int column) {
        Vector rowVector = (Vector)this.dataVector.get(row);
        rowVector.remove(column);
        rowVector.add(column, value);
    }

    protected static Vector convertToVector(Object[] data) {
        if (data == null) {
            return null;
        }
        Vector vector = new Vector();
        for (int index = 0; index < data.length; ++index) {
            vector.add(data[index]);
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] data) {
        Vector vector = new Vector();
        for (int index = 0; index < data.length; ++index) {
            vector.add(DefaultTableModel.convertToVector(data[index]));
        }
        return vector;
    }
}

