/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class UIDefaults
extends Hashtable {
    LinkedList bundles = new LinkedList();
    Set listeners = new HashSet();
    Locale defaultLocale = Locale.getDefault();
    private static final long serialVersionUID = 7341222528856548117L;

    public UIDefaults() {
    }

    public UIDefaults(Object[] entries) {
        int i = 0;
        while (2 * i + 1 < entries.length) {
            this.put(entries[2 * i], entries[2 * i + 1]);
            ++i;
        }
    }

    public Object get(Object key) {
        return this.get(key, this.getDefaultLocale());
    }

    public Object get(Object key, Locale loc) {
        Object obj = null;
        if (super.containsKey(key)) {
            obj = super.get(key);
        } else if (key instanceof String) {
            String keyString = (String)key;
            ListIterator i = this.bundles.listIterator(0);
            while (i.hasNext()) {
                String bundle_name = (String)i.next();
                ResourceBundle res = ResourceBundle.getBundle(bundle_name, loc);
                if (res == null) continue;
                try {
                    obj = res.getObject(keyString);
                    break;
                }
                catch (MissingResourceException me) {
                }
            }
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof LazyValue) {
            Object resolved = ((LazyValue)obj).createValue(this);
            super.remove(key);
            super.put(key, resolved);
            return resolved;
        }
        if (obj instanceof ActiveValue) {
            return ((ActiveValue)obj).createValue(this);
        }
        return obj;
    }

    public Object put(Object key, Object value) {
        Object old = super.put(key, value);
        if (key instanceof String && old != value) {
            this.firePropertyChange((String)key, old, value);
        }
        return old;
    }

    public void putDefaults(Object[] entries) {
        int i = 0;
        while (2 * i + 1 < entries.length) {
            super.put(entries[2 * i], entries[2 * i + 1]);
            ++i;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public Font getFont(Object key) {
        Object o = this.get(key);
        if (o instanceof Font) {
            return (Font)o;
        }
        return null;
    }

    public Font getFont(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Font) {
            return (Font)o;
        }
        return null;
    }

    public Color getColor(Object key) {
        Object o = this.get(key);
        if (o instanceof Color) {
            return (Color)o;
        }
        return null;
    }

    public Color getColor(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Color) {
            return (Color)o;
        }
        return null;
    }

    public Icon getIcon(Object key) {
        Object o = this.get(key);
        if (o instanceof Icon) {
            return (Icon)o;
        }
        return null;
    }

    public Icon getIcon(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Icon) {
            return (Icon)o;
        }
        return null;
    }

    public Border getBorder(Object key) {
        Object o = this.get(key);
        if (o instanceof Border) {
            return (Border)o;
        }
        return null;
    }

    public Border getBorder(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Border) {
            return (Border)o;
        }
        return null;
    }

    public String getString(Object key) {
        Object o = this.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String getString(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    int getInt(Object key) {
        Object o = this.get(key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    int getInt(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public boolean getBoolean(Object key) {
        return Boolean.TRUE.equals(this.get(key));
    }

    public boolean getBoolean(Object key, Locale l) {
        return Boolean.TRUE.equals(this.get(key, l));
    }

    public Insets getInsets(Object key) {
        Object o = this.get(key);
        if (o instanceof Insets) {
            return (Insets)o;
        }
        return null;
    }

    public Insets getInsets(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Insets) {
            return (Insets)o;
        }
        return null;
    }

    public Dimension getDimension(Object key) {
        Object o = this.get(key);
        if (o instanceof Dimension) {
            return (Dimension)o;
        }
        return null;
    }

    public Dimension getDimension(Object key, Locale l) {
        Object o = this.get(key, l);
        if (o instanceof Dimension) {
            return (Dimension)o;
        }
        return null;
    }

    public Class getUIClass(String id, ClassLoader loader) {
        String className = (String)this.get(id);
        if (className == null) {
            return null;
        }
        try {
            if (loader != null) {
                return loader.loadClass(className);
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class getUIClass(String id) {
        return this.getUIClass(id, null);
    }

    protected void getUIError(String msg) {
        System.err.println("UIDefaults.getUIError: " + msg);
    }

    public ComponentUI getUI(JComponent target) {
        Method factory;
        String classId = target.getUIClassID();
        Class cls = this.getUIClass(classId);
        if (cls == null) {
            this.getUIError("failed to locate UI class:" + classId);
            return null;
        }
        try {
            factory = cls.getMethod("createUI", new Class[]{UIDefaults.class$("javax.swing.JComponent")});
        }
        catch (NoSuchMethodException nme) {
            this.getUIError("failed to locate createUI method on " + cls.toString());
            return null;
        }
        try {
            return (ComponentUI)factory.invoke(null, new Object[]{target});
        }
        catch (InvocationTargetException ite) {
            this.getUIError("InvocationTargetException (" + ite.getTargetException() + ") calling createUI(...) on " + cls.toString());
            return null;
        }
        catch (Exception e) {
            this.getUIError("exception calling createUI(...) on " + cls.toString());
            return null;
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return (PropertyChangeListener[])this.listeners.toArray();
    }

    protected void firePropertyChange(String property, Object o, Object n) {
        Iterator i = this.listeners.iterator();
        PropertyChangeEvent pce = new PropertyChangeEvent(this, property, o, n);
        while (i.hasNext()) {
            PropertyChangeListener pcl = (PropertyChangeListener)i.next();
            pcl.propertyChange(pce);
        }
    }

    void addResourceBundle(String name) {
        this.bundles.addFirst(name);
    }

    void removeResourceBundle(String name) {
        this.bundles.remove(name);
    }

    void setDefaultLocale(Locale loc) {
        this.defaultLocale = loc;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public static class ProxyLazyValue
    implements LazyValue {
        LazyValue inner;

        public ProxyLazyValue(String s) {
            String className = s;
            this.inner = new LazyValue(this, className){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = this$1;
                    this.finit$(parm$className);
                }

                private /* synthetic */ void finit$(String parm$className) {
                    this.val$className = parm$className;
                }

                public Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(this.val$className).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String c, String m) {
            String className = c;
            String methodName = m;
            this.inner = new LazyValue(this, methodName, className){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ String val$methodName;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = this$1;
                    this.finit$(parm$methodName, parm$className);
                }

                private /* synthetic */ void finit$(String parm$methodName, String parm$className) {
                    this.val$className = parm$className;
                    this.val$methodName = parm$methodName;
                }

                public Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(this.val$className).getMethod(this.val$methodName, new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String c, Object[] os) {
            String className = c;
            Object[] objs = os;
            Class[] clss = new Class[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                clss[i] = objs[i].getClass();
            }
            this.inner = new LazyValue(this, clss, objs, className){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ Class[] val$clss;
                private /* synthetic */ Object[] val$objs;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = this$1;
                    this.finit$(parm$clss, parm$objs, parm$className);
                }

                private /* synthetic */ void finit$(Class[] parm$clss, Object[] parm$objs, String parm$className) {
                    this.val$className = parm$className;
                    this.val$objs = parm$objs;
                    this.val$clss = parm$clss;
                }

                public Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(this.val$className).getConstructor(this.val$clss).newInstance(this.val$objs);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public ProxyLazyValue(String c, String m, Object[] os) {
            String className = c;
            String methodName = m;
            Object[] objs = os;
            Class[] clss = new Class[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                clss[i] = objs[i].getClass();
            }
            this.inner = new LazyValue(this, clss, objs, methodName, className){
                private /* synthetic */ ProxyLazyValue this$1;
                private /* synthetic */ Class[] val$clss;
                private /* synthetic */ Object[] val$objs;
                private /* synthetic */ String val$methodName;
                private /* synthetic */ String val$className;
                {
                    this.this$1 = this$1;
                    this.finit$(parm$clss, parm$objs, parm$methodName, parm$className);
                }

                private /* synthetic */ void finit$(Class[] parm$clss, Object[] parm$objs, String parm$methodName, String parm$className) {
                    this.val$className = parm$className;
                    this.val$methodName = parm$methodName;
                    this.val$objs = parm$objs;
                    this.val$clss = parm$clss;
                }

                public Object createValue(UIDefaults table) {
                    try {
                        return Class.forName(this.val$className).getMethod(this.val$methodName, this.val$clss).invoke(null, this.val$objs);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }

        public Object createValue(UIDefaults table) {
            return this.inner.createValue(table);
        }
    }

    interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public static class LazyInputMap
    implements LazyValue {
        Object[] bind;

        public LazyInputMap(Object[] bindings) {
            this.bind = bindings;
        }

        public Object createValue(UIDefaults table) {
            InputMap im = new InputMap();
            int i = 0;
            while (2 * i + 1 < this.bind.length) {
                im.put(KeyStroke.getKeyStroke((String)this.bind[2 * i]), this.bind[2 * i + 1]);
                ++i;
            }
            return im;
        }
    }

    interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }
}

