/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    private static int KNOWN_SIZE = 1;
    private static int KNOWN_CSIZE = 2;
    private static int KNOWN_CRC = 4;
    private static int KNOWN_TIME = 8;
    private static Calendar cal;
    private String name;
    private int size;
    private int compressedSize;
    private int crc;
    private int dostime;
    private short known;
    private short method;
    private byte[] extra;
    private String comment;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private /* synthetic */ void finit$() {
        this.known = 0;
        this.method = (short)-1;
        this.extra = null;
        this.comment = null;
    }

    public ZipEntry(String name) {
        this.finit$();
        int length = name.length();
        if (length > 65535) {
            throw new IllegalArgumentException("name length is " + length);
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry e) {
        this.finit$();
        this.name = e.name;
        this.known = e.known;
        this.size = e.size;
        this.compressedSize = e.compressedSize;
        this.crc = e.crc;
        this.dostime = e.dostime;
        this.method = e.method;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    final void setDOSTime(int dostime) {
        this.dostime = dostime;
        this.known = (short)(this.known | (short)KNOWN_TIME);
    }

    final int getDOSTime() {
        if ((this.known & KNOWN_TIME) == 0) {
            return 0;
        }
        return this.dostime;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void ex;
            ZipEntry clone = (ZipEntry)super.clone();
            if (this.extra != null) {
                clone.extra = (byte[])this.extra.clone();
            }
            return ex;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long time) {
        Calendar cal;
        Calendar calendar = cal = ZipEntry.getCalendar();
        synchronized (calendar) {
            try {
                cal.setTime(new Date(time * (long)1000));
                this.dostime = (cal.get(1) - 1980 & 0x7F) << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
            }
            finally {
                Object var5_4 = null;
            }
            this.dostime = (int)((long)this.dostime / (long)1000);
            this.known = (short)(this.known | (short)KNOWN_TIME);
            return;
        }
    }

    public long getTime() {
        if ((this.known & KNOWN_TIME) == 0) {
            return -1;
        }
        int sec = 2 * (this.dostime & 0x1F);
        int min = this.dostime >> 5 & 0x3F;
        int hrs = this.dostime >> 11 & 0x1F;
        int day = this.dostime >> 16 & 0x1F;
        int mon = (this.dostime >> 21 & 0xF) - 1;
        int year = (this.dostime >> 25 & 0x7F) + 1980;
        try {
            Calendar calendar = cal = ZipEntry.getCalendar();
            synchronized (calendar) {
                try {
                    cal.set(year, mon, day, hrs, min, sec);
                    long l = cal.getTime().getTime();
                    Object var10_10 = null;
                    return l;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    throw throwable;
                }
            }
        }
        catch (RuntimeException ex) {
            this.known = (short)(this.known & ~((short)KNOWN_TIME));
            long l = -1;
            return l;
        }
    }

    private static synchronized Calendar getCalendar() {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return cal;
    }

    public void setSize(long size) {
        if ((size & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)size;
        this.known = (short)(this.known | (short)KNOWN_SIZE);
    }

    public long getSize() {
        if ((this.known & KNOWN_SIZE) != 0) {
            return (long)this.size & 0xFFFFFFFFL;
        }
        return -1;
    }

    public void setCompressedSize(long csize) {
        if ((csize & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.compressedSize = (int)csize;
        this.known = (short)(this.known | (short)KNOWN_CSIZE);
    }

    public long getCompressedSize() {
        if ((this.known & KNOWN_CSIZE) != 0) {
            return (long)this.compressedSize & 0xFFFFFFFFL;
        }
        return -1;
    }

    public void setCrc(long crc) {
        if ((crc & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)crc;
        this.known = (short)(this.known | (short)KNOWN_CRC);
    }

    public long getCrc() {
        if ((this.known & KNOWN_CRC) != 0) {
            return (long)this.crc & 0xFFFFFFFFL;
        }
        return -1;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (short)method;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] extra) {
        if (extra == null) {
            this.extra = null;
            return;
        }
        if (extra.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = extra;
        try {
            int len;
            for (int pos = 0; pos < extra.length; pos += len) {
                byte flags;
                int sig = extra[pos++] & 0xFF | (extra[pos++] & 0xFF) << 8;
                len = extra[pos++] & 0xFF | (extra[pos++] & 0xFF) << 8;
                if (sig != 21589 || ((flags = extra[pos]) & 1) == 0) continue;
                long time = extra[pos + 1] & 0xFF | (extra[pos + 2] & 0xFF) << 8 | (extra[pos + 3] & 0xFF) << 16 | (extra[pos + 4] & 0xFF) << 24;
                this.setTime(time);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int nlen = this.name.length();
        return nlen > 0 && this.name.charAt(nlen - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

