/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private Locale locale;
    private ResourceBundle res;

    private Currency() {
    }

    private Currency(Locale loc) {
        this.locale = loc;
        this.res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", this.locale);
    }

    public String getCurrencyCode() {
        try {
            return this.res.getString("intlCurrencySymbol");
        }
        catch (Exception _) {
            return null;
        }
    }

    public int getDefaultFractionDigits() {
        NumberFormat currency = NumberFormat.getCurrencyInstance(this.locale);
        return currency.getMaximumFractionDigits();
    }

    public static Currency getInstance(Locale locale) {
        return new Currency(locale);
    }

    public static Currency getInstance(String currencyCode) {
        Locale[] all_locales = Locale.getAvailableLocales();
        for (int i = 0; i < all_locales.length; ++i) {
            Currency test_currency = Currency.getInstance(all_locales[i]);
            if (test_currency.getCurrencyCode() == null || !test_currency.getCurrencyCode().equals(currencyCode)) continue;
            return test_currency;
        }
        return null;
    }

    public String getSymbol() {
        try {
            return this.res.getString("currencySymbol");
        }
        catch (Exception _) {
            return null;
        }
    }

    public String getSymbol(Locale locale) {
        try {
            ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale);
            if (res.equals(this.res)) {
                return res.getString("currencySymbol");
            }
            return res.getString("intlCurrencySymbol");
        }
        catch (Exception e1) {
            try {
                return this.res.getString("intlCurrencySymbol");
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public String toString() {
        try {
            return this.res.getString("intlCurrencySymbol");
        }
        catch (Exception _) {
            return "(unknown currency)";
        }
    }
}

