/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

final class MessageFormatElement {
    int argNumber;
    Format setFormat;
    Format format;
    Class formatClass;
    String type;
    String style;
    String trailer;

    void setLocale(Locale loc) {
        if (this.type != null) {
            if (this.type.equals("number")) {
                this.formatClass = MessageFormatElement.class$("java.lang.Number");
                if (this.style == null) {
                    this.format = NumberFormat.getInstance(loc);
                } else if (this.style.equals("currency")) {
                    this.format = NumberFormat.getCurrencyInstance(loc);
                } else if (this.style.equals("percent")) {
                    this.format = NumberFormat.getPercentInstance(loc);
                } else if (this.style.equals("integer")) {
                    NumberFormat nf = NumberFormat.getNumberInstance(loc);
                    nf.setMaximumFractionDigits(0);
                    nf.setGroupingUsed(false);
                    this.format = nf;
                } else {
                    this.format = NumberFormat.getNumberInstance(loc);
                    DecimalFormat df = (DecimalFormat)this.format;
                    df.applyPattern(this.style);
                }
            } else if (this.type.equals("time") || this.type.equals("date")) {
                this.formatClass = MessageFormatElement.class$("java.util.Date");
                int val = 2;
                if (this.style != null) {
                    if (this.style.equals("short")) {
                        val = 3;
                    } else if (this.style.equals("medium")) {
                        val = 2;
                    } else if (this.style.equals("long")) {
                        val = 1;
                    } else if (this.style.equals("full")) {
                        val = 0;
                    }
                }
                this.format = this.type.equals("time") ? DateFormat.getTimeInstance(val, loc) : DateFormat.getDateInstance(val, loc);
                if (this.style != null && val == 2) {
                    SimpleDateFormat sdf = (SimpleDateFormat)this.format;
                    sdf.applyPattern(this.style);
                }
            } else if (this.type.equals("choice")) {
                this.formatClass = MessageFormatElement.class$("java.lang.Number");
                if (this.style == null) {
                    throw new IllegalArgumentException("style required for choice format");
                }
                this.format = new ChoiceFormat(this.style);
            }
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    MessageFormatElement() {
    }
}

