/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;

public class CertPathValidator {
    private static final String CERT_PATH_VALIDATOR = "CertPathValidator";
    private final CertPathValidatorSpi validatorSpi;
    private final Provider provider;
    private final String algorithm;

    protected CertPathValidator(CertPathValidatorSpi validatorSpi, Provider provider, String algorithm) {
        this.validatorSpi = validatorSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static synchronized String getDefaultType() {
        String type = (String)AccessController.doPrivileged(new PrivilegedAction(null){
            private /* synthetic */ CertPathValidator this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return Security.getProperty("certpathvalidator.type");
            }
        });
        if (type == null) {
            type = "PKIX";
        }
        return type;
    }

    public static CertPathValidator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return CertPathValidator.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static CertPathValidator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CertPathValidator.getInstance(algorithm, p);
    }

    public static CertPathValidator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        try {
            return new CertPathValidator((CertPathValidatorSpi)Engine.getInstance(CERT_PATH_VALIDATOR, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathValidatorResult validate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        return this.validatorSpi.engineValidate(certPath, params);
    }
}

