/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;

public abstract class SocketChannel
extends AbstractSelectableChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    protected SocketChannel(SelectorProvider provider) {
        super(provider);
    }

    public static SocketChannel open() throws IOException {
        return SelectorProvider.provider().openSocketChannel();
    }

    public static SocketChannel open(SocketAddress remote) throws IOException {
        SocketChannel ch = SocketChannel.open();
        if (ch.connect(remote)) {
            // empty if block
        }
        return ch;
    }

    public final long read(ByteBuffer[] dsts) throws IOException {
        long b = 0L;
        for (int i = 0; i < dsts.length; ++i) {
            b += (long)this.read(dsts[i]);
        }
        return b;
    }

    public final long write(ByteBuffer[] dsts) throws IOException {
        long b = 0L;
        for (int i = 0; i < dsts.length; ++i) {
            b += (long)this.write(dsts[i]);
        }
        return b;
    }

    public final int validOps() {
        return 13;
    }

    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract boolean connect(SocketAddress var1) throws IOException;

    public abstract boolean finishConnect() throws IOException;

    public abstract boolean isConnected();

    public abstract boolean isConnectionPending();

    public abstract long read(ByteBuffer[] var1, int var2, int var3) throws IOException;

    public abstract Socket socket();

    public abstract int write(ByteBuffer var1) throws IOException;

    public abstract long write(ByteBuffer[] var1, int var2, int var3) throws IOException;
}

