/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.FloatBufferImpl;
import java.nio.ReadOnlyBufferException;

public abstract class FloatBuffer
extends Buffer
implements Comparable {
    int array_offset;
    float[] backing_buffer;

    FloatBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
        this.array_offset = 0;
    }

    FloatBuffer(float[] buffer, int offset, int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
        this.backing_buffer = buffer;
        this.array_offset = offset;
    }

    public static FloatBuffer allocate(int capacity) {
        return new FloatBufferImpl(capacity);
    }

    public static final FloatBuffer wrap(float[] array, int offset, int length) {
        return new FloatBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final FloatBuffer wrap(float[] array) {
        return FloatBuffer.wrap(array, 0, array.length);
    }

    public FloatBuffer get(float[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public FloatBuffer get(float[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public FloatBuffer put(FloatBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (src.remaining() > 0) {
            float[] toPut = new float[src.remaining()];
            src.get(toPut);
            src.put(toPut);
        }
        return this;
    }

    public FloatBuffer put(float[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final FloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final float[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object obj) {
        FloatBuffer a = (FloatBuffer)obj;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = (int)(this.get(i1) - a.get(i2));
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();
}

