/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.ProtocolException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public abstract class HttpURLConnection
extends URLConnection {
    static final int HTTP_CONTINUE = 100;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    private static boolean followRedirects = true;
    private static String valid_methods = "|GET|POST|HEAD|OPTIONS|PUT|DELETE|TRACE|";
    protected String method;
    protected int responseCode;
    protected String responseMessage;
    protected boolean instanceFollowRedirects;
    private boolean gotResponseVals;

    private /* synthetic */ void finit$() {
        this.method = "GET";
        this.responseCode = -1;
        this.responseMessage = null;
        this.instanceFollowRedirects = followRedirects;
        this.gotResponseVals = false;
    }

    protected HttpURLConnection(URL url) {
        super(url);
        this.finit$();
    }

    public abstract void disconnect();

    public abstract boolean usingProxy();

    public static void setFollowRedirects(boolean set) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        followRedirects = set;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean follow) {
        this.instanceFollowRedirects = follow;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (valid_methods.indexOf("|" + (method = method.toUpperCase()) + "|") == -1) {
            throw new ProtocolException("Invalid HTTP request method: " + method);
        }
        this.method = method;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (!this.gotResponseVals) {
            this.getResponseVals();
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (!this.gotResponseVals) {
            this.getResponseVals();
        }
        return this.responseMessage;
    }

    private void getResponseVals() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        this.gotResponseVals = true;
        if (this.responseCode == -1) {
            String respField = this.getHeaderField(0);
            if (respField == null || !respField.startsWith("HTTP/")) {
                this.responseCode = -1;
                this.responseMessage = null;
                return;
            }
            int firstSpc = respField.indexOf(32);
            int nextSpc = respField.indexOf(32, firstSpc + 1);
            this.responseMessage = respField.substring(nextSpc + 1);
            String codeStr = respField.substring(firstSpc + 1, nextSpc);
            try {
                this.responseCode = Integer.parseInt(codeStr);
            }
            catch (NumberFormatException e) {
                this.responseCode = -1;
                this.responseMessage = null;
            }
        }
    }

    public Permission getPermission() throws IOException {
        URL url = this.getURL();
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        host = host + ":" + port;
        return new SocketPermission(host, "connect");
    }

    public InputStream getErrorStream() {
        int code;
        if (!this.connected) {
            return null;
        }
        try {
            code = this.getResponseCode();
        }
        catch (IOException e) {
            code = -1;
        }
        if (code == -1) {
            return null;
        }
        if (code / 100 != 4 || code / 100 != 5) {
            return null;
        }
        try {
            PushbackInputStream pbis = new PushbackInputStream(this.getInputStream());
            int i = pbis.read();
            if (i == -1) {
                return null;
            }
            pbis.unread(i);
            return e;
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getHeaderFieldDate(String key, long value) {
        return super.getHeaderFieldDate(key, value);
    }
}

