/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Field
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private String name;
    private int offset;

    Field() {
    }

    public boolean equals(Object fld) {
        if (!(fld instanceof Field)) {
            return false;
        }
        Field f = (Field)fld;
        return this.declaringClass == f.declaringClass && this.offset == f.offset;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public native String getName();

    public native Class getType();

    public native int getModifiers();

    public int hashCode() {
        return this.declaringClass.hashCode() ^ this.offset;
    }

    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getBoolean(null, obj);
    }

    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getChar(null, obj);
    }

    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getByte(null, obj);
    }

    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getShort(null, obj);
    }

    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getInt(null, obj);
    }

    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getLong(null, obj);
    }

    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFloat(null, obj);
    }

    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getDouble(null, obj);
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.get(null, obj);
    }

    private native boolean getBoolean(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native char getChar(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native byte getByte(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native short getShort(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native int getInt(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native long getLong(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native float getFloat(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native double getDouble(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native Object get(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setByte(null, obj, b);
    }

    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setShort(null, obj, s);
    }

    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.setInt(null, obj, i);
    }

    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(null, obj, l);
    }

    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(null, obj, f);
    }

    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(null, obj, d);
    }

    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setChar(null, obj, c);
    }

    public void setBoolean(Object obj, boolean b) throws IllegalArgumentException, IllegalAccessException {
        this.setBoolean(null, obj, b);
    }

    private native void setByte(Class var1, Object var2, byte var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setShort(Class var1, Object var2, short var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setInt(Class var1, Object var2, int var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setLong(Class var1, Object var2, long var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setFloat(Class var1, Object var2, float var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setDouble(Class var1, Object var2, double var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setChar(Class var1, Object var2, char var3) throws IllegalArgumentException, IllegalAccessException;

    private native void setBoolean(Class var1, Object var2, boolean var3) throws IllegalArgumentException, IllegalAccessException;

    private native void set(Class var1, Object var2, Object var3, Class var4) throws IllegalArgumentException, IllegalAccessException;

    public void set(Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.set(null, object, value);
    }

    private void set(Class caller, Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class type = this.getType();
        if (!type.isPrimitive()) {
            this.set(caller, object, value, type);
        } else if (value instanceof Byte) {
            this.setByte(caller, object, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(caller, object, (Short)value);
        } else if (value instanceof Integer) {
            this.setInt(caller, object, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(caller, object, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(caller, object, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(caller, object, (Double)value);
        } else if (value instanceof Character) {
            this.setChar(caller, object, ((Character)value).charValue());
        } else if (value instanceof Boolean) {
            this.setBoolean(caller, object, (Boolean)value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int mods = this.getModifiers();
        if (mods != 0) {
            Modifier.toString(mods, sbuf);
            sbuf.append(' ');
        }
        Method.appendClassName(sbuf, this.getType());
        sbuf.append(' ');
        Method.appendClassName(sbuf, this.getDeclaringClass());
        sbuf.append('.');
        sbuf.append(this.getName());
        return sbuf.toString();
    }
}

