/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.RawData;

public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    ThreadGroup group;
    String name;
    private Runnable runnable;
    private int priority;
    private boolean daemon_flag;
    boolean interrupt_flag;
    private boolean alive_flag;
    private boolean startable_flag;
    private ClassLoader context_class_loader;
    RawData interp_frame;
    private Object data;

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkAccess(this);
        }
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public native void destroy();

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public static int enumerate(Thread[] threads) {
        return Thread.currentThread().group.enumerate(threads);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static native boolean holdsLock(Object var0);

    public native void interrupt();

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.interrupt_flag;
    }

    public final boolean isAlive() {
        return this.alive_flag;
    }

    public final boolean isDaemon() {
        return this.daemon_flag;
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long timeout) throws InterruptedException {
        this.join(timeout, 0);
    }

    public final native void join(long var1, int var3) throws InterruptedException;

    public final native void resume();

    private final native void finish_();

    private boolean isInterrupted(boolean clear_flag) {
        boolean r = this.interrupt_flag;
        if (clear_flag && r) {
            this.interrupt_flag = false;
        }
        return r;
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public final void setDaemon(boolean status) {
        this.checkAccess();
        if (!this.startable_flag) {
            throw new IllegalThreadStateException();
        }
        this.daemon_flag = status;
    }

    public synchronized ClassLoader getContextClassLoader() {
        ClassLoader callers;
        if (this.context_class_loader == null) {
            this.context_class_loader = ClassLoader.getSystemClassLoader();
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null && callers != null) {
            for (callers = null; callers != null && callers != this.context_class_loader; callers = callers.getParent()) {
            }
            if (callers != this.context_class_loader) {
                s.checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        return this.context_class_loader;
    }

    public synchronized void setContextClassLoader(ClassLoader cl) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.context_class_loader = cl;
    }

    public final void setName(String n) {
        this.checkAccess();
        if (n == null) {
            throw new NullPointerException();
        }
        this.name = n;
    }

    public final native void setPriority(int var1);

    public static void sleep(long timeout) throws InterruptedException {
        Thread.sleep(timeout, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    public native void start();

    public final void stop() {
        this.stop(null);
    }

    public final native void stop(Throwable var1);

    public final native void suspend();

    private final native void initialize_native();

    private static final native String gen_name();

    public Thread(ThreadGroup g, Runnable r, String n) {
        this(Thread.currentThread(), g, r, n);
    }

    public Thread(ThreadGroup g, Runnable r, String n, long size) {
        this(Thread.currentThread(), g, r, n);
    }

    private Thread(Thread current, ThreadGroup g, Runnable r, String n) {
        if (n == null) {
            throw new NullPointerException();
        }
        this.group = g == null ? (current == null ? ThreadGroup.root : current.getThreadGroup()) : g;
        this.data = null;
        this.interrupt_flag = false;
        this.alive_flag = false;
        this.startable_flag = true;
        if (current != null) {
            this.group.checkAccess();
            this.daemon_flag = current.isDaemon();
            int gmax = this.group.getMaxPriority();
            int pri = current.getPriority();
            this.priority = gmax < pri ? gmax : pri;
            this.context_class_loader = current.context_class_loader;
            InheritableThreadLocal.newChildThread(this);
        } else {
            this.daemon_flag = false;
            this.priority = 5;
        }
        this.name = n;
        this.group.addThread(this);
        this.runnable = r;
        this.initialize_native();
    }

    public Thread() {
        this(null, null, Thread.gen_name());
    }

    public Thread(Runnable r) {
        this(null, r, Thread.gen_name());
    }

    public Thread(String n) {
        this(null, null, n);
    }

    public Thread(ThreadGroup g, Runnable r) {
        this(g, r, Thread.gen_name());
    }

    public Thread(ThreadGroup g, String n) {
        this(g, null, n);
    }

    public Thread(Runnable r, String n) {
        this(null, r, n);
    }

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "," + (this.group == null ? "" : this.group.getName()) + "]";
    }

    public static native void yield();
}

