/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class InheritableThreadLocal
extends ThreadLocal {
    private static final Map threadMap = Collections.synchronizedMap(new WeakHashMap());

    public InheritableThreadLocal() {
        Thread currentThread = Thread.currentThread();
        List heritage = (List)threadMap.get(currentThread);
        if (heritage == null) {
            heritage = new ArrayList();
            threadMap.put(currentThread, heritage);
        }
        heritage.add(this);
    }

    protected Object childValue(Object parentValue) {
        return parentValue;
    }

    static void newChildThread(Thread childThread) {
        Thread parentThread = Thread.currentThread();
        ArrayList heritage = (ArrayList)threadMap.get(parentThread);
        if (heritage != null) {
            threadMap.put(childThread, heritage.clone());
            Iterator it = heritage.iterator();
            int i = heritage.size();
            while (--i >= 0) {
                InheritableThreadLocal local = (InheritableThreadLocal)it.next();
                Object parentValue = local.valueMap.get(parentThread);
                if (parentValue == null) continue;
                Object childValue = local.childValue(parentValue == ThreadLocal.NULL ? null : parentValue);
                local.valueMap.put(childThread, childValue == null ? ThreadLocal.NULL : parentValue);
            }
        }
    }
}

