/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String buf;
    private int pos;
    private int markedPos;
    private int count;

    public StringReader(String buffer) {
        this.buf = buffer;
        this.count = buffer.length();
        this.pos = 0;
        this.markedPos = 0;
    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.buf = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                this.markedPos = this.pos;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                if (this.pos < this.count) {
                    int n2 = this.buf.charAt(this.pos++) & 0xFFFF;
                    Object var3_4 = null;
                    return n2;
                }
                n = -1;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return n;
        }
    }

    public int read(char[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (this.pos >= this.count) {
                    int n2 = -1;
                    Object var8_7 = null;
                    return n2;
                }
                int lastChar = Math.min(this.count, this.pos + len);
                this.buf.getChars(this.pos, lastChar, b, off);
                int numChars = lastChar - this.pos;
                this.pos = lastChar;
                n = numChars;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
            Object var8_8 = null;
            return n;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return true;
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                this.pos = this.markedPos;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                long numChars = Math.min((long)(this.count - this.pos), n < 0L ? 0L : n);
                this.pos += (int)numChars;
                long l = numChars;
                Object var8_5 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                throw throwable;
            }
        }
    }
}

