/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class InputStream {
    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (b.length == 0) {
            return 0;
        }
        for (i = 0; i < len; ++i) {
            try {
                int ch = this.read();
                if (ch < 0) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                b[off + i] = (byte)ch;
                continue;
            }
            catch (IOException ex) {
                if (i == 0) {
                    throw ex;
                }
                return i;
            }
        }
        return i;
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public long skip(long n) throws IOException {
        int numread;
        int buflen = n > (long)2048 ? 2048 : (int)n;
        byte[] tmpbuf = new byte[buflen];
        long origN = n;
        while (n > 0L && (numread = this.read(tmpbuf, 0, n > (long)buflen ? buflen : (int)n)) > 0) {
            n -= (long)numread;
        }
        return origN - n;
    }
}

