/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int value) throws IOException {
        this.out.write(value);
        ++this.written;
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        this.out.write(buf, offset, len);
        this.written += len;
    }

    public final void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public final void writeByte(int value) throws IOException {
        this.write(value & 0xFF);
    }

    public final synchronized void writeShort(int value) throws IOException {
        this.write((byte)(value >> 8) & 0xFFFFFFFF);
        this.write((byte)value & 0xFFFFFFFF);
    }

    public final synchronized void writeChar(int value) throws IOException {
        this.write((byte)(value >> 8) & 0xFFFFFFFF);
        this.write((byte)value & 0xFFFFFFFF);
    }

    public final synchronized void writeInt(int value) throws IOException {
        this.write((byte)(value >> 24) & 0xFFFFFFFF);
        this.write((byte)(value >> 16) & 0xFFFFFFFF);
        this.write((byte)(value >> 8) & 0xFFFFFFFF);
        this.write((byte)value & 0xFFFFFFFF);
    }

    public final synchronized void writeLong(long value) throws IOException {
        this.write((byte)(value >> 56) & 0xFFFFFFFF);
        this.write((byte)(value >> 48) & 0xFFFFFFFF);
        this.write((byte)(value >> 40) & 0xFFFFFFFF);
        this.write((byte)(value >> 32) & 0xFFFFFFFF);
        this.write((byte)(value >> 24) & 0xFFFFFFFF);
        this.write((byte)(value >> 16) & 0xFFFFFFFF);
        this.write((byte)(value >> 8) & 0xFFFFFFFF);
        this.write((byte)value & 0xFFFFFFFF);
    }

    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public final void writeBytes(String value) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(value.charAt(i));
        }
    }

    public final void writeChars(String value) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(value.charAt(i));
        }
    }

    public final synchronized void writeUTF(String value) throws IOException {
        char c;
        int i;
        int len = value.length();
        int sum = 0;
        for (i = 0; i < len && sum <= 65535; ++i) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++sum;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                sum += 2;
                continue;
            }
            sum += 3;
        }
        if (sum > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(sum);
        for (i = 0; i < len; ++i) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                this.write(0xC0 | 0x1F & c >> 6);
                this.write(0x80 | 0x3F & c);
                continue;
            }
            this.write(0xE0 | 0xF & c >> 12);
            this.write(0x80 | 0x3F & c >> 6);
            this.write(0x80 | 0x3F & c);
        }
    }
}

