/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ComponentColorModel
extends ColorModel {
    private static int sum(int[] values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public ComponentColorModel(ColorSpace colorSpace, int[] bits, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency, int transferType) {
        super(ComponentColorModel.sum(bits), bits, colorSpace, hasAlpha, isAlphaPremultiplied, transparency, transferType);
    }

    public int getRed(int pixel) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(pixel)[0];
    }

    public int getGreen(int pixel) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(pixel)[0];
    }

    public int getBlue(int pixel) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(pixel)[0];
    }

    public int getAlpha(int pixel) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        int shift = 8 - this.getComponentSize(this.getNumColorComponents());
        if (shift >= 0) {
            return pixel << (shift & 0x1F);
        }
        return pixel >> (-shift & 0x1F);
    }

    public int getRGB(int pixel) {
        float[] rgb = this.getRGBFloat(pixel);
        int ret = this.getRGB(rgb);
        if (this.hasAlpha()) {
            ret |= this.getAlpha(pixel) << 24;
        }
        return ret;
    }

    private float[] getRGBFloat(int pixel) {
        float[] data = new float[]{pixel};
        return this.cspace.toRGB(data);
    }

    private float[] getRGBFloat(Object inData) {
        DataBuffer buffer = Buffers.createBufferFromData(this.transferType, inData, this.getNumComponents());
        int colors = this.getNumColorComponents();
        float[] data = new float[colors];
        for (int i = 0; i < colors; ++i) {
            float maxValue = (1 << (this.getComponentSize(i) & 0x1F)) - 1;
            data[i] = buffer.getElemFloat(i) / maxValue;
        }
        float[] rgb = this.cspace.toRGB(data);
        return rgb;
    }

    public int getRed(Object inData) {
        return (int)this.getRGBFloat(inData)[0] * 255;
    }

    public int getGreen(Object inData) {
        return (int)this.getRGBFloat(inData)[1] * 255;
    }

    public int getBlue(Object inData) {
        return (int)this.getRGBFloat(inData)[2] * 255;
    }

    public int getAlpha(Object inData) {
        DataBuffer buffer = Buffers.createBufferFromData(this.transferType, inData, this.getNumComponents());
        int shift = 8 - this.getComponentSize(this.getNumColorComponents());
        int alpha = buffer.getElem(this.getNumColorComponents());
        if (shift >= 0) {
            return alpha << (shift & 0x1F);
        }
        return alpha >> (-shift & 0x1F);
    }

    private int getRGB(float[] rgb) {
        int ret = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f) << 0;
        return ret;
    }

    public int getRGB(Object inData) {
        float[] rgb = this.getRGBFloat(inData);
        int ret = this.getRGB(rgb);
        if (this.hasAlpha()) {
            ret |= this.getAlpha(inData) << 24;
        }
        return ret;
    }

    public Object getDataElements(int rgb, Object pixel) {
        float[] rgbFloats = new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f};
        float[] data = this.cspace.fromRGB(rgbFloats);
        DataBuffer buffer = Buffers.createBuffer(this.transferType, pixel, this.getNumComponents());
        int numColors = this.getNumColorComponents();
        if (this.hasAlpha()) {
            float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
            if (this.isAlphaPremultiplied()) {
                int i = 0;
                while (i < numColors) {
                    int n = i++;
                    data[n] = data[n] * alpha;
                }
            }
            buffer.setElemFloat(numColors, alpha *= (float)(1 << (this.bits[numColors] - 1 & 0x1F)));
        }
        for (int i = 0; i < numColors; ++i) {
            float value = data[i] * (float)(1 << (this.bits[i] - 1 & 0x1F));
            buffer.setElemFloat(i, value);
        }
        return Buffers.getData(buffer);
    }

    public int[] getComponents(int pixel, int[] components, int offset) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            components = new int[this.getNumComponents() + offset];
        }
        components[offset] = pixel;
        return components;
    }

    public int[] getComponents(Object pixel, int[] components, int offset) {
        DataBuffer buffer = Buffers.createBuffer(this.transferType, pixel, this.getNumComponents());
        int numComponents = this.getNumComponents();
        if (components == null) {
            components = new int[numComponents + offset];
        }
        for (int i = 0; i < numComponents; ++i) {
            components[offset++] = buffer.getElem(i);
        }
        return components;
    }

    public int getDataElement(int[] components, int offset) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return components[offset];
    }

    public Object getDataElements(int[] components, int offset, Object obj) {
        DataBuffer buffer = Buffers.createBuffer(this.transferType, obj, this.getNumComponents());
        int numComponents = this.getNumComponents();
        for (int i = 0; i < numComponents; ++i) {
            buffer.setElem(i, components[offset++]);
        }
        return Buffers.getData(buffer);
    }

    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        if (this.isAlphaPremultiplied == isAlphaPremultiplied) {
            return this;
        }
        super.coerceData(raster, isAlphaPremultiplied);
        return new ComponentColorModel(this.cspace, this.bits, this.hasAlpha(), isAlphaPremultiplied, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        return super.isCompatibleRaster(raster);
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        SampleModel sm = this.createCompatibleSampleModel(w, h);
        Point origin = new Point(0, 0);
        return Raster.createWritableRaster(sm, origin);
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        int pixelStride = this.getNumComponents();
        int[] bandOffsets = new int[pixelStride];
        for (int i = 0; i < pixelStride; ++i) {
            bandOffsets[i] = i;
        }
        return new ComponentSampleModel(this.transferType, w, h, pixelStride, pixelStride * w, bandOffsets);
    }

    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm instanceof ComponentSampleModel && super.isCompatibleSampleModel(sm);
    }

    public WritableRaster getAlphaRaster(WritableRaster raster) {
        if (!this.hasAlpha()) {
            return null;
        }
        SampleModel sm = raster.getSampleModel();
        int[] alphaBand = new int[]{sm.getNumBands() - 1};
        SampleModel alphaModel = sm.createSubsetSampleModel(alphaBand);
        DataBuffer buffer = raster.getDataBuffer();
        Point origin = new Point(0, 0);
        return Raster.createWritableRaster(alphaModel, buffer, origin);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentColorModel)) {
            return false;
        }
        return super.equals(obj);
    }
}

