/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    protected CubicCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX1();

    public abstract double getCtrlY1();

    public abstract Point2D getCtrlP1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY2();

    public abstract Point2D getCtrlP2();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++]);
    }

    public void setCurve(Point2D p1, Point2D c1, Point2D c2, Point2D p2) {
        this.setCurve(p1.getX(), p1.getY(), c1.getX(), c1.getY(), c2.getX(), c2.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(Point2D[] pts, int offset) {
        this.setCurve(pts[offset].getX(), pts[offset++].getY(), pts[offset].getX(), pts[offset++].getY(), pts[offset].getX(), pts[offset++].getY(), pts[offset].getX(), pts[offset++].getY());
    }

    public void setCurve(CubicCurve2D c) {
        this.setCurve(c.getX1(), c.getY1(), c.getCtrlX1(), c.getCtrlY1(), c.getCtrlX2(), c.getCtrlY2(), c.getX2(), c.getY2());
    }

    public static double getFlatnessSq(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2) {
        return Math.max(Line2D.ptSegDistSq(x1, y1, x2, y2, cx1, cy1), Line2D.ptSegDistSq(x1, y1, x2, y2, cx2, cy2));
    }

    public static double getFlatness(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(x1, y1, cx1, cy1, cx2, cy2, x2, y2));
    }

    public static double getFlatnessSq(double[] coords, int offset) {
        return CubicCurve2D.getFlatnessSq(coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++]);
    }

    public static double getFlatness(double[] coords, int offset) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++]));
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public double getFlatness() {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2()));
    }

    public void subdivide(CubicCurve2D left, CubicCurve2D right) {
        double[] d = new double[]{this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        CubicCurve2D.subdivide(d, 0, d, 0, d, 6);
        if (left != null) {
            left.setCurve(d, 0);
        }
        if (right != null) {
            right.setCurve(d, 6);
        }
    }

    public static void subdivide(CubicCurve2D src, CubicCurve2D left, CubicCurve2D right) {
        src.subdivide(left, right);
    }

    public static void subdivide(double[] src, int srcOff, double[] left, int leftOff, double[] right, int rightOff) {
        double left_P1_x = src[srcOff];
        double left_P1_y = src[srcOff + 1];
        double src_C1_x = src[srcOff + 2];
        double src_C1_y = src[srcOff + 3];
        double src_C2_x = src[srcOff + 4];
        double src_C2_y = src[srcOff + 5];
        double right_P2_x = src[srcOff + 6];
        double right_P2_y = src[srcOff + 7];
        double left_C1_x = (left_P1_x + src_C1_x) / 2.0;
        double left_C1_y = (left_P1_y + src_C1_y) / 2.0;
        double right_C2_x = (right_P2_x + src_C2_x) / 2.0;
        double right_C2_y = (right_P2_y + src_C2_y) / 2.0;
        double Mid_x = (src_C1_x + src_C2_x) / 2.0;
        double Mid_y = (src_C1_y + src_C2_y) / 2.0;
        double left_C2_x = (left_C1_x + Mid_x) / 2.0;
        double left_C2_y = (left_C1_y + Mid_y) / 2.0;
        double right_C1_x = (Mid_x + right_C2_x) / 2.0;
        double right_C1_y = (Mid_y + right_C2_y) / 2.0;
        Mid_x = (left_C2_x + right_C1_x) / 2.0;
        Mid_y = (left_C2_y + right_C1_y) / 2.0;
        if (left != null) {
            left[leftOff] = left_P1_x;
            left[leftOff + 1] = left_P1_y;
            left[leftOff + 2] = left_C1_x;
            left[leftOff + 3] = left_C1_y;
            left[leftOff + 4] = left_C2_x;
            left[leftOff + 5] = left_C2_y;
            left[leftOff + 6] = Mid_x;
            left[leftOff + 7] = Mid_y;
        }
        if (right != null) {
            right[rightOff] = Mid_x;
            right[rightOff + 1] = Mid_y;
            right[rightOff + 2] = right_C1_x;
            right[rightOff + 3] = right_C1_y;
            right[rightOff + 4] = right_C2_x;
            right[rightOff + 5] = right_C2_y;
            right[rightOff + 6] = right_P2_x;
            right[rightOff + 7] = right_P2_y;
        }
    }

    public static int solveCubic(double[] eqn) {
        return CubicCurve2D.solveCubic(eqn, eqn);
    }

    public static int solveCubic(double[] eqn, double[] res) {
        double a;
        double c3 = eqn[3];
        if (c3 == 0.0) {
            return QuadCurve2D.solveQuadratic(eqn, res);
        }
        double c = eqn[0] / c3;
        double b = eqn[1] / c3;
        double d = a = eqn[2] / c3;
        double q = d * d - 3.0 * b;
        double r = 2.0 * a * a * a - 9.0 * a * b + 27.0 * c;
        double Q = q / 9.0;
        double R = r / 54.0;
        double d2 = Q;
        double Q3 = d2 * d2 * Q;
        double d3 = R;
        double R2 = d3 * d3;
        double CR2 = 729.0 * r * r;
        double CQ3 = 2916.0 * q * q * q;
        if (R == 0.0 && Q == 0.0) {
            res[0] = -a / 3.0;
            return 1;
        }
        if (CR2 == CQ3) {
            double sqrtQ = Math.sqrt(Q);
            if (R > 0.0) {
                res[0] = -2.0 * sqrtQ - a / 3.0;
                res[1] = sqrtQ - a / 3.0;
            } else {
                res[0] = -sqrtQ - a / 3.0;
                res[1] = 2.0 * sqrtQ - a / 3.0;
            }
            return 2;
        }
        if (CR2 < CQ3) {
            double sqrtQ;
            double d4 = sqrtQ = Math.sqrt(Q);
            double sqrtQ3 = d4 * d4 * sqrtQ;
            double theta = Math.acos(R / sqrtQ3);
            double norm = -2.0 * sqrtQ;
            res[0] = norm * Math.cos(theta / 3.0) - a / 3.0;
            res[1] = norm * Math.cos((theta + Math.PI * 2) / 3.0) - a / 3.0;
            res[2] = norm * Math.cos((theta - Math.PI * 2) / 3.0) - a / 3.0;
            return 3;
        }
        double sgnR = R >= 0.0 ? 1.0 : -1.0;
        double A = -sgnR * Math.pow(Math.abs(R) + Math.sqrt(R2 - Q3), 0.3333333333333333);
        double B = Q / A;
        res[0] = A + B - a / 3.0;
        return 1;
    }

    public boolean contains(double x, double y) {
        throw new Error("not implemented");
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        throw new Error("not implemented");
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new Error("not implemented");
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PathIterator(this, at){
            private /* synthetic */ CubicCurve2D this$0;
            private /* synthetic */ AffineTransform val$at;
            private int current;
            {
                this.this$0 = this$0;
                this.finit$(parm$at);
            }

            private /* synthetic */ void finit$(AffineTransform parm$at) {
                this.val$at = parm$at;
                this.current = 0;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.current > 1;
            }

            public void next() {
                ++this.current;
            }

            public int currentSegment(float[] coords) {
                int result;
                switch (this.current) {
                    case 0: {
                        coords[0] = (float)this.this$0.getX1();
                        coords[1] = (float)this.this$0.getY1();
                        result = 0;
                        break;
                    }
                    case 1: {
                        coords[0] = (float)this.this$0.getCtrlX1();
                        coords[1] = (float)this.this$0.getCtrlY1();
                        coords[2] = (float)this.this$0.getCtrlX2();
                        coords[3] = (float)this.this$0.getCtrlY2();
                        coords[4] = (float)this.this$0.getX2();
                        coords[5] = (float)this.this$0.getY2();
                        result = 3;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("cubic iterator out of bounds");
                    }
                }
                if (this.val$at != null) {
                    this.val$at.transform(coords, 0, coords, 0, 3);
                }
                return result;
            }

            public int currentSegment(double[] coords) {
                int result;
                switch (this.current) {
                    case 0: {
                        coords[0] = this.this$0.getX1();
                        coords[1] = this.this$0.getY1();
                        result = 0;
                        break;
                    }
                    case 1: {
                        coords[0] = this.this$0.getCtrlX1();
                        coords[1] = this.this$0.getCtrlY1();
                        coords[2] = this.this$0.getCtrlX2();
                        coords[3] = this.this$0.getCtrlY2();
                        coords[4] = this.this$0.getX2();
                        coords[5] = this.this$0.getY2();
                        result = 3;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("cubic iterator out of bounds");
                    }
                }
                if (this.val$at != null) {
                    this.val$at.transform(coords, 0, coords, 0, 3);
                }
                return result;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public static class Float
    extends CubicCurve2D {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = cx1;
            this.ctrly1 = cy1;
            this.ctrlx2 = cx2;
            this.ctrly2 = cy2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.ctrlx1 = (float)cx1;
            this.ctrly1 = (float)cy1;
            this.ctrlx2 = (float)cx2;
            this.ctrly2 = (float)cy2;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setCurve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = cx1;
            this.ctrly1 = cy1;
            this.ctrlx2 = cx2;
            this.ctrly2 = cy2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            float nx1 = Math.min(Math.min(this.x1, this.ctrlx1), Math.min(this.ctrlx2, this.x2));
            float ny1 = Math.min(Math.min(this.y1, this.ctrly1), Math.min(this.ctrly2, this.y2));
            float nx2 = Math.max(Math.max(this.x1, this.ctrlx1), Math.max(this.ctrlx2, this.x2));
            float ny2 = Math.max(Math.max(this.y1, this.ctrly1), Math.max(this.ctrly2, this.y2));
            return new Rectangle2D.Float(nx1, ny1, nx2 - nx1, ny2 - ny1);
        }
    }

    public static class Double
    extends CubicCurve2D {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = cx1;
            this.ctrly1 = cy1;
            this.ctrlx2 = cx2;
            this.ctrly2 = cy2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = cx1;
            this.ctrly1 = cy1;
            this.ctrlx2 = cx2;
            this.ctrly2 = cy2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double nx1 = Math.min(Math.min(this.x1, this.ctrlx1), Math.min(this.ctrlx2, this.x2));
            double ny1 = Math.min(Math.min(this.y1, this.ctrly1), Math.min(this.ctrly2, this.y2));
            double nx2 = Math.max(Math.max(this.x1, this.ctrlx1), Math.max(this.ctrlx2, this.x2));
            double ny2 = Math.max(Math.max(this.y1, this.ctrly1), Math.max(this.ctrly2, this.y2));
            return new Rectangle2D.Double(nx1, ny1, nx2 - nx1, ny2 - ny1);
        }
    }
}

