/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -7644114512714619750L;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    static final Object treeLock = new String("AWT_TREE_LOCK");
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean ignoreRepaint;
    boolean visible;
    boolean enabled;
    boolean valid;
    DropTarget dropTarget;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    boolean focusable;
    int isFocusTraversableOverridden;
    Set[] focusTraversalKeys;
    boolean focusTraversalKeysEnabled;
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly;
    long eventMask;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion;
    AccessibleContext accessibleContext;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentOrientation orientation;
    transient GraphicsConfiguration graphicsConfig;
    transient BufferStrategy bufferStrategy;
    private static transient boolean incrementalDraw = Boolean.getBoolean("awt.image.incrementalDraw");
    private static transient Long redrawRate = Long.getLong("awt.image.redrawrate");

    private /* synthetic */ void finit$() {
        this.visible = true;
        this.enabled = true;
        this.focusable = true;
        this.focusTraversalKeysEnabled = true;
        this.eventMask = 4096;
        this.componentSerializedDataVersion = 4;
        this.orientation = ComponentOrientation.UNKNOWN;
    }

    protected Component() {
        this.finit$();
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.nameExplicitlySet = true;
        this.name = name;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public void setDropTarget(DropTarget dt) {
        this.dropTarget = dt;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getGraphicsConfigurationImpl();
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        Toolkit tk;
        if (this.peer != null && (tk = this.peer.getToolkit()) != null) {
            return tk;
        }
        if (this.parent != null) {
            return this.parent.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDisplayable() {
        if (this.parent != null) {
            return this.parent.isDisplayable();
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (!this.visible || this.peer == null) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isShowing();
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        if (this.peer != null) {
            this.peer.setEnabled(b);
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean b) {
        this.setEnabled(b);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean enable) {
        throw new Error("not implemented");
    }

    public void setVisible(boolean b) {
        if (b) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (this.peer != null) {
            this.peer.setVisible(true);
        }
        this.visible = true;
    }

    public void show(boolean b) {
        this.setVisible(b);
    }

    public void hide() {
        if (this.peer != null) {
            this.peer.setVisible(false);
        }
        this.visible = false;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getForeground();
    }

    public void setForeground(Color c) {
        this.firePropertyChange("foreground", this.foreground, c);
        if (this.peer != null) {
            this.peer.setForeground(c);
        }
        this.foreground = c;
    }

    public boolean isForegroundSet() {
        return this.foreground != null;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBackground();
    }

    public void setBackground(Color c) {
        this.firePropertyChange("background", this.background, c);
        if (this.peer != null) {
            this.peer.setBackground(c);
        }
        this.background = c;
    }

    public boolean isBackgroundSet() {
        return this.background != null;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getFont();
    }

    public void setFont(Font f) {
        this.firePropertyChange("font", this.font, f);
        if (this.peer != null) {
            this.peer.setFont(f);
        }
        this.font = f;
    }

    public boolean isFontSet() {
        return this.font != null;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: can't determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale l) {
        this.firePropertyChange("locale", this.locale, l);
        this.locale = l;
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        if (config != null) {
            return config.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component not showing");
        }
        return this.peer.getLocationOnScreen();
    }

    public Point location() {
        return this.getLocation();
    }

    public void setLocation(int x, int y) {
        if (this.x == x && this.y == y) {
            return;
        }
        this.invalidate();
        this.x = x;
        this.y = y;
        if (this.peer != null) {
            this.peer.setBounds(x, y, this.width, this.height);
        }
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension size() {
        return this.getSize();
    }

    public void setSize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.invalidate();
        this.width = width;
        this.height = height;
        if (this.peer != null) {
            this.peer.setBounds(this.x, this.y, width, height);
        }
    }

    public void resize(int width, int height) {
        this.setSize(width, height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void resize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle bounds() {
        return this.getBounds();
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.x == x && this.y == y && this.width == w && this.height == h) {
            return;
        }
        this.invalidate();
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        if (this.peer != null) {
            this.peer.setBounds(x, y, w, h);
        }
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        r.x = this.x;
        r.y = this.y;
        r.width = this.width;
        r.height = this.height;
        return r;
    }

    public Dimension getSize(Dimension d) {
        if (d == null) {
            d = new Dimension();
        }
        d.width = this.width;
        d.height = this.height;
        return d;
    }

    public Point getLocation(Point p) {
        if (p == null) {
            p = new Point();
        }
        p.x = this.x;
        p.y = this.y;
        return p;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isLightweight() {
        return this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.prefSize == null) {
            if (this.peer == null) {
                return new Dimension(this.width, this.height);
            }
            this.prefSize = this.peer.getPreferredSize();
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.minSize == null) {
            this.minSize = this.peer != null ? this.peer.getMinimumSize() : new Dimension(this.width, this.height);
        }
        return this.minSize;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
    }

    public void layout() {
        this.doLayout();
    }

    public void validate() {
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
        this.prefSize = null;
        this.minSize = null;
        if (this.parent != null && this.parent.valid) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        if (this.peer != null) {
            Graphics gfx = this.peer.getGraphics();
            if (gfx != null) {
                return gfx;
            }
            Container parent = this.getParent();
            if (parent != null) {
                gfx = parent.getGraphics();
                Rectangle bounds = this.getBounds();
                gfx.setClip(bounds);
                gfx.translate(bounds.x, bounds.y);
                return gfx;
            }
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.peer == null) {
            return this.getToolkit().getFontMetrics(font);
        }
        return this.peer.getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        if (this.peer != null) {
            this.peer.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        if (this.parent != null) {
            return this.parent.getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    public boolean isCursorSet() {
        return this.cursor != null;
    }

    public void paint(Graphics g) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paintAll(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.peer != null) {
            this.peer.paint(g);
        }
        this.paint(g);
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long tm) {
        this.repaint(tm, 0, 0, this.width, this.height);
    }

    public void repaint(int x, int y, int w, int h) {
        this.repaint(0L, x, y, w, h);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.isLightweight() && this.parent != null) {
            if (this.parent != null) {
                this.parent.repaint(tm, x + this.getX(), y + this.getY(), width, height);
            }
        } else if (this.peer != null) {
            this.peer.repaint(tm, x, y, width, height);
        }
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void printAll(Graphics g) {
        this.paintAll(g);
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.repaint();
        } else if ((flags & 8) != 0 && incrementalDraw) {
            if (redrawRate != null) {
                long tm = redrawRate;
                if (tm < 0L) {
                    tm = 0L;
                }
                this.repaint(tm);
            } else {
                this.repaint(100);
            }
        }
        return (flags & 0xE0) == 0;
    }

    public Image createImage(ImageProducer producer) {
        if (this.peer != null) {
            return this.peer.createImage(producer);
        }
        return this.getToolkit().createImage(producer);
    }

    public Image createImage(int width, int height) {
        Image returnValue = null;
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.isLightweight() && this.parent != null) {
                returnValue = this.parent.createImage(width, height);
            } else if (this.peer != null) {
                returnValue = this.peer.createImage(width, height);
            }
        }
        return returnValue;
    }

    public VolatileImage createVolatileImage(int width, int height) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        if (config == null) {
            return null;
        }
        return config.createCompatibleVolatileImage(width, height);
    }

    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        if (config == null) {
            return null;
        }
        return config.createCompatibleVolatileImage(width, height, caps);
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.prepareImage(image, image.getWidth(observer), image.getHeight(observer), observer);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        if (this.peer != null) {
            return this.peer.prepareImage(image, width, height, observer);
        }
        return this.getToolkit().prepareImage(image, width, height, observer);
    }

    public int checkImage(Image image, ImageObserver observer) {
        return this.checkImage(image, -1, -1, observer);
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        if (this.peer != null) {
            return this.peer.checkImage(image, width, height, observer);
        }
        return this.getToolkit().checkImage(image, width, height, observer);
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.ignoreRepaint = ignoreRepaint;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && this.width > x && this.height > y;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public Component getComponentAt(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public Component locate(int x, int y) {
        return this.getComponentAt(x, y);
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public void deliverEvent(Event e) {
    }

    public final void dispatchEvent(AWTEvent e) {
        this.dispatchEventImpl(e);
        if (this.peer != null && !e.consumed) {
            this.peer.handleEvent(e);
        }
    }

    public boolean postEvent(Event e) {
        return false;
    }

    public synchronized void addComponentListener(ComponentListener l) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, l);
        if (this.componentListener != null) {
            this.enableEvents(1L);
        }
    }

    public synchronized void removeComponentListener(ComponentListener l) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, l);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        return (ComponentListener[])AWTEventMulticaster.getListeners(this.componentListener, Component.class$("java.awt.event.ComponentListener"));
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, l);
        if (this.focusListener != null) {
            this.enableEvents(4);
        }
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, l);
    }

    public synchronized FocusListener[] getFocusListeners() {
        return (FocusListener[])AWTEventMulticaster.getListeners(this.focusListener, Component.class$("java.awt.event.FocusListener"));
    }

    public synchronized void addHierarchyListener(HierarchyListener l) {
        this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, l);
        if (this.hierarchyListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyListener(HierarchyListener l) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, l);
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        return (HierarchyListener[])AWTEventMulticaster.getListeners(this.hierarchyListener, Component.class$("java.awt.event.HierarchyListener"));
    }

    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, l);
        if (this.hierarchyBoundsListener != null) {
            this.enableEvents(65536L);
        }
    }

    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, l);
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return (HierarchyBoundsListener[])AWTEventMulticaster.getListeners(this.hierarchyBoundsListener, Component.class$("java.awt.event.HierarchyBoundsListener"));
    }

    public synchronized void addKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, l);
        if (this.keyListener != null) {
            this.enableEvents(8);
        }
    }

    public synchronized void removeKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, l);
    }

    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])AWTEventMulticaster.getListeners(this.keyListener, Component.class$("java.awt.event.KeyListener"));
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, l);
        if (this.mouseListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseListener(MouseListener l) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, l);
    }

    public synchronized MouseListener[] getMouseListeners() {
        return (MouseListener[])AWTEventMulticaster.getListeners(this.mouseListener, Component.class$("java.awt.event.MouseListener"));
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, l);
        if (this.mouseMotionListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, l);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return (MouseMotionListener[])AWTEventMulticaster.getListeners(this.mouseMotionListener, Component.class$("java.awt.event.MouseMotionListener"));
    }

    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, l);
        if (this.mouseWheelListener != null) {
            this.enableEvents(131072L);
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, l);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return (MouseWheelListener[])AWTEventMulticaster.getListeners(this.mouseWheelListener, Component.class$("java.awt.event.MouseWheelListener"));
    }

    public synchronized void addInputMethodListener(InputMethodListener l) {
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, l);
        if (this.inputMethodListener != null) {
            this.enableEvents(2048);
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener l) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, l);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])AWTEventMulticaster.getListeners(this.inputMethodListener, Component.class$("java.awt.event.InputMethodListener"));
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Component.class$("java.awt.event.ComponentListener")) {
            return this.getComponentListeners();
        }
        if (listenerType == Component.class$("java.awt.event.FocusListener")) {
            return this.getFocusListeners();
        }
        if (listenerType == Component.class$("java.awt.event.HierarchyListener")) {
            return this.getHierarchyListeners();
        }
        if (listenerType == Component.class$("java.awt.event.HierarchyBoundsListener")) {
            return this.getHierarchyBoundsListeners();
        }
        if (listenerType == Component.class$("java.awt.event.KeyListener")) {
            return this.getKeyListeners();
        }
        if (listenerType == Component.class$("java.awt.event.MouseListener")) {
            return this.getMouseListeners();
        }
        if (listenerType == Component.class$("java.awt.event.MouseMotionListener")) {
            return this.getMouseMotionListeners();
        }
        if (listenerType == Component.class$("java.awt.event.MouseWheelListener")) {
            return this.getMouseWheelListeners();
        }
        if (listenerType == Component.class$("java.awt.event.InputMethodListener")) {
            return this.getInputMethodListeners();
        }
        if (listenerType == Component.class$("java.beans.PropertyChangeListener")) {
            return this.getPropertyChangeListeners();
        }
        return (EventListener[])Array.newInstance(listenerType, 0);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getInputContext();
    }

    protected final void enableEvents(long eventsToEnable) {
        this.eventMask |= eventsToEnable;
        if (this.isLightweight() && this.parent != null) {
            this.parent.enableEvents(eventsToEnable);
        } else if (this.peer != null) {
            this.peer.setEventMask(this.eventMask);
        }
    }

    protected final void disableEvents(long eventsToDisable) {
        this.eventMask &= eventsToDisable ^ (long)-1;
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        switch (existingEvent.id) {
            case 503: 
            case 506: {
                return newEvent;
            }
            case 800: 
            case 801: {
                return this.coalescePaintEvents((PaintEvent)existingEvent, (PaintEvent)newEvent);
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e);
        } else if (e instanceof PaintEvent) {
            this.processPaintEvent((PaintEvent)e);
        } else if (e instanceof MouseWheelEvent) {
            this.processMouseWheelEvent((MouseWheelEvent)e);
        } else if (e instanceof MouseEvent) {
            if (e.id == 503 || e.id == 506) {
                this.processMouseMotionEvent((MouseEvent)e);
            } else {
                this.processMouseEvent((MouseEvent)e);
            }
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e);
        } else if (e instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)e);
        } else if (e instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)e);
        } else if (e instanceof HierarchyEvent) {
            if (e.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)e);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)e);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e) {
        if (this.componentListener == null) {
            return;
        }
        switch (e.id) {
            case 103: {
                this.componentListener.componentHidden(e);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(e);
                break;
            }
            case 101: {
                this.componentListener.componentResized(e);
                break;
            }
            case 102: {
                this.componentListener.componentShown(e);
            }
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (this.focusListener == null) {
            return;
        }
        switch (e.id) {
            case 1004: {
                this.focusListener.focusGained(e);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(e);
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.keyListener == null) {
            return;
        }
        switch (e.id) {
            case 401: {
                this.keyListener.keyPressed(e);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(e);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(e);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.mouseListener == null) {
            return;
        }
        switch (e.id) {
            case 500: {
                this.mouseListener.mouseClicked(e);
                break;
            }
            case 504: {
                this.mouseListener.mouseEntered(e);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(e);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(e);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (e.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(e);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(e);
            }
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (this.mouseWheelListener != null && e.id == 507) {
            this.mouseWheelListener.mouseWheelMoved(e);
        }
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (e.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(e);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(e);
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent e) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (e.id == 1400) {
            this.hierarchyListener.hierarchyChanged(e);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (e.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(e);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(e);
            }
        }
    }

    public boolean handleEvent(Event evt) {
        return false;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        return false;
    }

    public boolean keyDown(Event evt, int key) {
        return false;
    }

    public boolean keyUp(Event evt, int key) {
        return false;
    }

    public boolean action(Event evt, Object what) {
        return false;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        }
        this.peer.setEventMask(this.eventMask);
    }

    public void removeNotify() {
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.peer = null;
    }

    public boolean gotFocus(Event evt, Object what) {
        return false;
    }

    public boolean lostFocus(Event evt, Object what) {
        return false;
    }

    public boolean isFocusTraversable() {
        return this.enabled && this.visible && (this.peer == null || this.peer.isFocusTraversable());
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.firePropertyChange("focusable", this.focusable, focusable);
        this.focusable = focusable;
    }

    public void setFocusTraversalKeys(int id, Set keystrokes) {
        String name;
        Set sb;
        Set sa;
        if (keystrokes == null) {
            throw new IllegalArgumentException();
        }
        switch (id) {
            case 0: {
                sa = this.getFocusTraversalKeys(1);
                sb = this.getFocusTraversalKeys(2);
                name = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(2);
                name = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                name = "upCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator iter = keystrokes.iterator();
        while (--i >= 0) {
            Object o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && ((AWTKeyStroke)o).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[3];
        }
        keystrokes = Collections.unmodifiableSet(new HashSet(keystrokes));
        this.firePropertyChange(name, this.focusTraversalKeys[id], keystrokes);
        this.focusTraversalKeys[id] = keystrokes;
    }

    public Set getFocusTraversalKeys(int id) {
        if (id < 0 || id > 2) {
            throw new IllegalArgumentException();
        }
        Set s = null;
        if (this.focusTraversalKeys != null) {
            s = this.focusTraversalKeys[id];
        }
        if (s == null && this.parent != null) {
            s = this.parent.getFocusTraversalKeys(id);
        }
        if (s == null) {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
        }
        return s;
    }

    public boolean areFocusTraversalKeysSet(int id) {
        if (id < 0 || id > 2) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[id] != null;
    }

    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.firePropertyChange("focusTraversalKeysEnabled", this.focusTraversalKeysEnabled, focusTraversalKeysEnabled);
        this.focusTraversalKeysEnabled = focusTraversalKeysEnabled;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    public void requestFocus() {
        if (this.peer != null) {
            this.peer.requestFocus();
        }
    }

    protected boolean requestFocus(boolean temporary) {
        this.requestFocus();
        return true;
    }

    public boolean requestFocusInWindow() {
        this.requestFocus();
        return true;
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        this.requestFocus();
        return true;
    }

    public void transferFocus() {
        Component next = this.parent == null ? this.findNextFocusComponent(null) : this.parent.findNextFocusComponent(this);
        if (next != null && next != this) {
            next.requestFocus();
        }
    }

    public Container getFocusCycleRootAncestor() {
        throw new Error("not implemented");
    }

    public boolean isFocusCycleRoot(Container c) {
        return c == this.getFocusCycleRootAncestor();
    }

    public void nextFocus() {
        this.transferFocus();
    }

    public void transferFocusBackward() {
        throw new Error("not implemented");
    }

    public void transferFocusUpCycle() {
        throw new Error("not implemented");
    }

    public boolean hasFocus() {
        return this.isFocusOwner();
    }

    public boolean isFocusOwner() {
        throw new Error("not implemented");
    }

    public synchronized void add(PopupMenu popup) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.add(popup);
    }

    public synchronized void remove(MenuComponent popup) {
        if (this.popups != null) {
            this.popups.remove(popup);
        }
    }

    protected String paramString() {
        StringBuffer param = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            param.append(name).append(",");
        }
        param.append(this.width).append("x").append(this.height).append("+").append(this.x).append("+").append(this.y);
        if (!this.isValid()) {
            param.append(",invalid");
        }
        if (!this.isVisible()) {
            param.append(",invisible");
        }
        if (!this.isEnabled()) {
            param.append(",disabled");
        }
        if (!this.isOpaque()) {
            param.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            param.append(",doublebuffered");
        }
        return param.toString();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.paramString() + ']';
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream out) {
        this.list(out, 0);
    }

    public void list(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println(this.toString());
    }

    public void list(PrintWriter out) {
        this.list(out, 0);
    }

    public void list(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(property);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void setComponentOrientation(ComponentOrientation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.orientation = o;
    }

    public ComponentOrientation getComponentOrientation() {
        return this.orientation;
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        this.setComponentOrientation(o);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    String generateName() {
        return null;
    }

    final void setPeer(ComponentPeer peer) {
        this.peer = peer;
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        GraphicsConfiguration config;
        if (this.peer != null && (config = this.peer.getGraphicsConfiguration()) != null) {
            return config;
        }
        if (this.parent != null) {
            return this.parent.getGraphicsConfiguration();
        }
        return null;
    }

    void dispatchEventImpl(AWTEvent e) {
        if (this.eventTypeEnabled(e.id)) {
            this.processEvent(e);
        }
    }

    boolean eventTypeEnabled(int type) {
        if (type > 1999) {
            return true;
        }
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return this.componentListener != null || ((int)this.eventMask & 1) != 0;
            }
            case 400: 
            case 401: 
            case 402: {
                return this.keyListener != null || ((int)((long)this.eventMask >> 3) & 1) != 0;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                return this.mouseListener != null || this.mouseMotionListener != null || ((int)((long)this.eventMask >> 4) & 1) != 0;
            }
            case 1004: 
            case 1005: {
                return this.focusListener != null || ((int)((long)this.eventMask >> 2) & 1) != 0;
            }
            case 1100: 
            case 1101: {
                return this.inputMethodListener != null || ((int)((long)this.eventMask >> 11) & 1) != 0;
            }
            case 800: 
            case 801: {
                return ((int)((long)this.eventMask >> 13) & 1) != 0;
            }
        }
        return false;
    }

    private PaintEvent coalescePaintEvents(PaintEvent queuedEvent, PaintEvent newEvent) {
        Rectangle r1 = queuedEvent.getUpdateRect();
        Rectangle r2 = newEvent.getUpdateRect();
        Rectangle union = r1.union(r2);
        int ua = union.width * union.height;
        int r1a = r1.width * r1.height;
        int r2a = r2.width * r2.height;
        if (ua > (r1a + r2a) * 2) {
            return null;
        }
        newEvent.setUpdateRect(union);
        return newEvent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processPaintEvent(PaintEvent event) {
        if (this.peer == null) {
            return;
        }
        Graphics gfx = this.getGraphics();
        try {
            Rectangle clip = event.getUpdateRect();
            gfx.setClip(clip);
            switch (event.id) {
                case 800: {
                    this.paint(gfx);
                    return;
                }
                case 801: {
                    this.update(gfx);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("unknown paint event");
                }
            }
        }
        finally {
            Object var3_3 = null;
            gfx.dispose();
        }
    }

    Component findNextFocusComponent(Component child) {
        return null;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        String key = (String)s.readObject();
        while (key != null) {
            Object listener = s.readObject();
            if ("componentL".equals(key)) {
                this.addComponentListener((ComponentListener)listener);
            } else if ("focusL".equals(key)) {
                this.addFocusListener((FocusListener)listener);
            } else if ("keyL".equals(key)) {
                this.addKeyListener((KeyListener)listener);
            } else if ("mouseL".equals(key)) {
                this.addMouseListener((MouseListener)listener);
            } else if ("mouseMotionL".equals(key)) {
                this.addMouseMotionListener((MouseMotionListener)listener);
            } else if ("inputMethodL".equals(key)) {
                this.addInputMethodListener((InputMethodListener)listener);
            } else if ("hierarchyL".equals(key)) {
                this.addHierarchyListener((HierarchyListener)listener);
            } else if ("hierarchyBoundsL".equals(key)) {
                this.addHierarchyBoundsListener((HierarchyBoundsListener)listener);
            } else if ("mouseWheelL".equals(key)) {
                this.addMouseWheelListener((MouseWheelListener)listener);
            }
            key = (String)s.readObject();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "componentL", this.componentListener);
        AWTEventMulticaster.save(s, "focusL", this.focusListener);
        AWTEventMulticaster.save(s, "keyL", this.keyListener);
        AWTEventMulticaster.save(s, "mouseL", this.mouseListener);
        AWTEventMulticaster.save(s, "mouseMotionL", this.mouseMotionListener);
        AWTEventMulticaster.save(s, "inputMethodL", this.inputMethodListener);
        AWTEventMulticaster.save(s, "hierarchyL", this.hierarchyListener);
        AWTEventMulticaster.save(s, "hierarchyBoundsL", this.hierarchyBoundsListener);
        AWTEventMulticaster.save(s, "mouseWheelL", this.mouseWheelListener);
        s.writeObject(null);
    }

    protected class FlipBufferStrategy
    extends BufferStrategy {
        private /* synthetic */ Component this$0;
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;

        protected FlipBufferStrategy(Component this$0, int num, BufferCapabilities caps) throws AWTException {
            this.this$0 = this$0;
            this.caps = caps;
            this.createBuffers(num, caps);
        }

        protected void createBuffers(int num, BufferCapabilities caps) throws AWTException {
        }

        protected Image getBackBuffer() {
            return this.drawBuffer;
        }

        protected void flip(BufferCapabilities.FlipContents flipAction) {
        }

        protected void destroyBuffers() {
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return null;
        }

        protected void revalidate() {
        }

        public boolean contentsLost() {
            return false;
        }

        public boolean contentsRestored() {
            return false;
        }

        public void show() {
        }
    }

    protected class BltBufferStrategy
    extends BufferStrategy {
        private /* synthetic */ Component this$0;
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;

        protected BltBufferStrategy(Component this$0, int num, BufferCapabilities caps) {
            this.this$0 = this$0;
            this.caps = caps;
            this.createBackBuffers(num);
        }

        protected void createBackBuffers(int num) {
            this.backBuffers = new VolatileImage[num];
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return null;
        }

        public void show() {
        }

        protected void revalidate() {
        }

        public boolean contentsLost() {
            return false;
        }

        public boolean contentsRestored() {
            return false;
        }
    }

    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        private /* synthetic */ Component this$0;
        private static final long serialVersionUID = 642321655757800191L;
        protected ComponentListener accessibleAWTComponentHandler;
        protected FocusListener accessibleAWTFocusHandler;

        private /* synthetic */ void finit$() {
            this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler(this);
            this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler(this);
        }

        protected AccessibleAWTComponent(Component this$0) {
            this.this$0 = this$0;
            this.finit$();
            this$0.addComponentListener(this.accessibleAWTComponentHandler);
            this$0.addFocusListener(this.accessibleAWTFocusHandler);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.this$0.addPropertyChangeListener(l);
            super.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.this$0.removePropertyChangeListener(l);
            super.removePropertyChangeListener(l);
        }

        public String getAccessibleName() {
            if (this.accessibleName == null) {
                return this.this$0.getName();
            }
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet s = new AccessibleStateSet();
            if (this.this$0.isEnabled()) {
                s.add(AccessibleState.ENABLED);
            }
            if (this.this$0.isFocusable()) {
                s.add(AccessibleState.FOCUSABLE);
            }
            if (this.this$0.isFocusOwner()) {
                s.add(AccessibleState.FOCUSED);
            }
            if (this.this$0.isOpaque()) {
                s.add(AccessibleState.OPAQUE);
            }
            if (this.this$0.isShowing()) {
                s.add(AccessibleState.SHOWING);
            }
            if (this.this$0.isVisible()) {
                s.add(AccessibleState.VISIBLE);
            }
            return s;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null) {
                Container parent = this.this$0.getParent();
                this.accessibleParent = parent instanceof Accessible ? (Accessible)((Object)parent) : null;
            }
            return this.accessibleParent;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() == null) {
                return -1;
            }
            AccessibleContext context = ((Component)((Object)this.accessibleParent)).getAccessibleContext();
            if (context == null) {
                return -1;
            }
            int i = context.getAccessibleChildrenCount();
            while (--i >= 0) {
                if (context.getAccessibleChild(i) != this.this$0) continue;
                return i;
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() {
            return this.this$0.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return this.this$0.getBackground();
        }

        public void setBackground(Color c) {
            this.this$0.setBackground(c);
        }

        public Color getForeground() {
            return this.this$0.getForeground();
        }

        public void setForeground(Color c) {
            this.this$0.setForeground(c);
        }

        public Cursor getCursor() {
            return this.this$0.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.this$0.setCursor(cursor);
        }

        public Font getFont() {
            return this.this$0.getFont();
        }

        public void setFont(Font f) {
            this.this$0.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return this.this$0.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return this.this$0.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.this$0.setEnabled(b);
        }

        public boolean isVisible() {
            return this.this$0.isVisible();
        }

        public void setVisible(boolean b) {
            this.this$0.setVisible(b);
        }

        public boolean isShowing() {
            return this.this$0.isShowing();
        }

        public boolean contains(Point p) {
            return this.this$0.contains(p.x, p.y);
        }

        public Point getLocationOnScreen() {
            if (this.this$0.isShowing()) {
                return this.this$0.getLocationOnScreen();
            }
            return null;
        }

        public Point getLocation() {
            if (this.this$0.isShowing()) {
                return this.this$0.getLocation();
            }
            return null;
        }

        public void setLocation(Point p) {
            this.this$0.setLocation(p.x, p.y);
        }

        public Rectangle getBounds() {
            if (this.this$0.isShowing()) {
                return this.this$0.getBounds();
            }
            return null;
        }

        public void setBounds(Rectangle r) {
            this.this$0.setBounds(r.x, r.y, r.width, r.height);
        }

        public Dimension getSize() {
            if (this.this$0.isShowing()) {
                return this.this$0.getSize();
            }
            return null;
        }

        public void setSize(Dimension d) {
            this.this$0.setSize(d.width, d.height);
        }

        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        public boolean isFocusTraversable() {
            return this.this$0.isFocusTraversable();
        }

        public void requestFocus() {
            this.this$0.requestFocus();
        }

        public void addFocusListener(FocusListener l) {
            this.this$0.addFocusListener(l);
        }

        public void removeFocusListener(FocusListener l) {
            this.this$0.removeFocusListener(l);
        }

        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleAWTComponent this$1;

            protected AccessibleAWTFocusHandler(AccessibleAWTComponent this$1) {
                this.this$1 = this$1;
            }

            public void focusGained(FocusEvent e) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent e) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            private /* synthetic */ AccessibleAWTComponent this$1;

            protected AccessibleAWTComponentHandler(AccessibleAWTComponent this$1) {
                this.this$1 = this$1;
            }

            public void componentHidden(ComponentEvent e) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }
    }
}

