/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.X509CRLEntry;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CRL
extends java.security.cert.X509CRL {
    private static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    private static final OID ID_DSA_WITH_SHA1 = new OID("1.2.840.10040.4.3");
    private static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    private static final OID ID_RSA_WITH_MD2 = new OID("1.2.840.113549.1.1.2");
    private static final OID ID_RSA_WITH_MD5 = new OID("1.2.840.113549.1.1.4");
    private static final OID ID_RSA_WITH_SHA1 = new OID("1.2.840.113549.1.1.5");
    private byte[] encoded;
    private byte[] tbsCRLBytes;
    private int version;
    private OID algId;
    private byte[] algParams;
    private Date thisUpdate;
    private Date nextUpdate;
    private X500Principal issuerDN;
    private HashMap revokedCerts = new HashMap();
    private HashMap extensions = new HashMap();
    private HashSet critOids = new HashSet();
    private HashSet nonCritOids = new HashSet();
    private OID sigAlg;
    private byte[] sigAlgParams;
    private byte[] rawSig;
    private byte[] signature;

    /*
     * WARNING - void declaration
     */
    public X509CRL(InputStream encoded) throws CRLException, IOException {
        try {
            this.parse(encoded);
        }
        catch (IOException ioe) {
            void x;
            ioe.printStackTrace();
            throw x;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new CRLException(x.toString());
        }
    }

    public boolean equals(Object o) {
        return ((X509CRL)o).revokedCerts.equals(this.revokedCerts);
    }

    public int hashCode() {
        return this.revokedCerts.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = Signature.getInstance(this.sigAlg.toString());
        this.doVerify(sig, key);
    }

    public void verify(PublicKey key, String provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = Signature.getInstance(this.sigAlg.toString(), provider);
        this.doVerify(sig, key);
    }

    public int getVersion() {
        return this.version;
    }

    public Principal getIssuerDN() {
        return this.issuerDN;
    }

    public X500Principal getIssuerX500Principal() {
        return this.issuerDN;
    }

    public Date getThisUpdate() {
        return (Date)this.thisUpdate.clone();
    }

    public Date getNextUpdate() {
        if (this.nextUpdate != null) {
            return (Date)this.nextUpdate.clone();
        }
        return null;
    }

    public java.security.cert.X509CRLEntry getRevokedCertificate(BigInteger serialNo) {
        return (java.security.cert.X509CRLEntry)this.revokedCerts.get(serialNo);
    }

    public Set getRevokedCertificates() {
        return Collections.unmodifiableSet(new HashSet(this.revokedCerts.values()));
    }

    public byte[] getTBSCertList() throws CRLException {
        return (byte[])this.tbsCRLBytes.clone();
    }

    public byte[] getSignature() {
        return (byte[])this.rawSig.clone();
    }

    public String getSigAlgName() {
        if (this.sigAlg.equals(ID_DSA_WITH_SHA1)) {
            return "SHA1withDSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_MD2)) {
            return "MD2withRSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_MD5)) {
            return "MD5withRSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_SHA1)) {
            return "SHA1withRSA";
        }
        return "unknown";
    }

    public String getSigAlgOID() {
        return this.sigAlg.toString();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            return (byte[])this.sigAlgParams.clone();
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        return Collections.unmodifiableSet(this.critOids);
    }

    public Set getNonCriticalExtensionOIDs() {
        return Collections.unmodifiableSet(this.nonCritOids);
    }

    public byte[] getExtensionValue(String oid) {
        byte[] ext = (byte[])this.extensions.get(oid);
        if (ext != null) {
            return (byte[])ext.clone();
        }
        return null;
    }

    public String toString() {
        return X509CRL.class$("gnu.java.security.x509.X509CRL").getName();
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public boolean isRevoked(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("not a X.509 certificate");
        }
        BigInteger certSerial = ((X509Certificate)cert).getSerialNumber();
        java.security.cert.X509CRLEntry ent = (java.security.cert.X509CRLEntry)this.revokedCerts.get(certSerial);
        if (ent == null) {
            return false;
        }
        return ent.getRevocationDate().compareTo(new Date()) < 0;
    }

    private void doVerify(Signature sig, PublicKey key) throws CRLException, InvalidKeyException, SignatureException {
        sig.initVerify(key);
        sig.update(this.tbsCRLBytes);
        if (!sig.verify(this.signature)) {
            throw new CRLException("signature not verified");
        }
    }

    private void parse(InputStream in) throws Exception {
        int len;
        DERReader der = new DERReader(in);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new ASN1ParsingException("malformed CertificateList");
        }
        this.encoded = val.getEncoded();
        val = der.read();
        if (!val.isConstructed()) {
            throw new ASN1ParsingException("malformed TBSCertList");
        }
        this.tbsCRLBytes = val.getEncoded();
        val = der.read();
        if (val.getValue() instanceof BigInteger) {
            this.version = ((BigInteger)val.getValue()).intValue() + 1;
            val = der.read();
        } else {
            this.version = 1;
        }
        if (!val.isConstructed()) {
            throw new ASN1ParsingException("malformed AlgorithmIdentifier");
        }
        DERValue algIdVal = der.read();
        this.algId = (OID)algIdVal.getValue();
        if (val.getLength() > algIdVal.getEncodedLength()) {
            val = der.read();
            this.algParams = val.getEncoded();
            if (val.isConstructed()) {
                in.skip(val.getLength());
            }
        }
        this.issuerDN = new X500Principal(in);
        this.thisUpdate = (Date)der.read().getValue();
        val = der.read();
        if (val.getValue() instanceof Date) {
            this.nextUpdate = (Date)val.getValue();
            val = der.read();
        }
        if (val.getTag() != 0) {
            X509CRLEntry entry;
            for (len = 0; len < val.getLength(); len += ((java.security.cert.X509CRLEntry)entry).getEncoded().length) {
                entry = new X509CRLEntry(this.version, in);
                this.revokedCerts.put(((java.security.cert.X509CRLEntry)entry).getSerialNumber(), entry);
            }
        }
        if (this.version >= 2 && val.getTagClass() != 0 && val.getTag() == 0) {
            DERValue ext;
            val = der.read();
            for (len = 0; len < val.getLength(); len += ext.getEncodedLength()) {
                ext = der.read();
                OID extId = (OID)der.read().getValue();
                DERValue val2 = der.read();
                Boolean crit = false;
                if (val2.getValue() instanceof Boolean) {
                    crit = (Boolean)val2.getValue();
                    val2 = der.read();
                }
                byte[] extVal = (byte[])val2.getValue();
                this.extensions.put(extId.toString(), extVal);
                if (crit.booleanValue()) {
                    this.critOids.add(extId.toString());
                    continue;
                }
                this.nonCritOids.add(extId.toString());
            }
        }
        if (!(val = der.read()).isConstructed()) {
            throw new ASN1ParsingException("malformed AlgorithmIdentifier");
        }
        DERValue sigAlgVal = der.read();
        this.sigAlg = (OID)sigAlgVal.getValue();
        if (val.getLength() > sigAlgVal.getEncodedLength()) {
            val = der.read();
            this.sigAlgParams = val.getEncoded();
            if (val.isConstructed()) {
                in.skip(val.getLength());
            }
        }
        val = der.read();
        this.rawSig = val.getEncoded();
        this.signature = ((BitString)val.getValue()).toByteArray();
    }
}

