/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;

public class RMIObjectInputStream
extends ObjectInputStream {
    public RMIObjectInputStream(InputStream strm) throws IOException {
        super(strm);
        this.enableResolveObject(true);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String annotation = (String)this.getAnnotation();
        try {
            if (annotation == null) {
                return RMIClassLoader.loadClass(desc.getName());
            }
            return RMIClassLoader.loadClass(annotation, desc.getName());
        }
        catch (MalformedURLException _) {
            throw new ClassNotFoundException(desc.getName());
        }
    }

    protected Object getAnnotation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    protected Class resolveProxyClass(String[] intfs) throws IOException, ClassNotFoundException {
        String annotation = (String)this.getAnnotation();
        Class[] clss = new Class[intfs.length];
        clss[0] = annotation == null ? RMIClassLoader.loadClass(intfs[0]) : RMIClassLoader.loadClass(annotation, intfs[0]);
        ClassLoader loader = clss[0].getClassLoader();
        for (int i = 0; i < intfs.length; ++i) {
            clss[i] = Class.forName(intfs[i], false, loader);
        }
        try {
            return Proxy.getProxyClass(loader, clss);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected Object readValue(Class valueClass) throws IOException, ClassNotFoundException {
        if (valueClass.isPrimitive()) {
            if (valueClass == Boolean.TYPE) {
                return new Boolean(this.readBoolean());
            }
            if (valueClass == Byte.TYPE) {
                return new Byte(this.readByte());
            }
            if (valueClass == Character.TYPE) {
                return new Character(this.readChar());
            }
            if (valueClass == Short.TYPE) {
                return new Short(this.readShort());
            }
            if (valueClass == Integer.TYPE) {
                return new Integer(this.readInt());
            }
            if (valueClass == Long.TYPE) {
                return new Long(this.readLong());
            }
            if (valueClass == Float.TYPE) {
                return new Float(this.readFloat());
            }
            if (valueClass == Double.TYPE) {
                return new Double(this.readDouble());
            }
            throw new Error("Unsupported primitive class: " + valueClass);
        }
        return this.readObject();
    }
}

