/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.HeaderFieldHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Connection
extends HttpURLConnection {
    private Socket socket;
    private static int proxyPort = 80;
    private static boolean proxyInUse = false;
    private static String proxyHost = null;
    private DataInputStream inputStream;
    private OutputStream outputStream;
    private ByteArrayOutputStream bufferedOutputStream;
    private HashMap requestProperties;
    private HeaderFieldHelper headers;

    private /* synthetic */ void finit$() {
        this.requestProperties = new HashMap();
        this.headers = new HeaderFieldHelper();
    }

    protected Connection(URL url) {
        super(url);
        this.finit$();
        this.doOutput = false;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (proxyInUse) {
            int port = proxyPort;
            this.socket = new Socket(proxyHost, port);
        } else {
            int port = this.url.getPort();
            if (port == -1) {
                port = 80;
            }
            this.socket = new Socket(this.url.getHost(), port);
        }
        this.inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.sendRequest();
        this.receiveReply();
        this.connected = true;
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    void sendRequest() throws IOException {
        PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter(this.outputStream, "8859_1"));
        outputWriter.print(this.getRequestMethod() + " " + this.url.getFile() + " HTTP/1.1\r\n");
        if (this.getRequestProperty("Host") == null) {
            this.setRequestProperty("Host", this.url.getHost());
        }
        if (this.getRequestProperty("Connection") == null) {
            this.setRequestProperty("Connection", "Close");
        }
        if (this.getRequestProperty("user-agent") == null) {
            this.setRequestProperty("user-agent", "gnu-libgcj/" + System.getProperty("java.vm.version"));
        }
        if (this.getRequestProperty("accept") == null) {
            this.setRequestProperty("accept", "*/*");
        }
        if (this.getRequestProperty("Content-type") == null) {
            this.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        }
        if (this.bufferedOutputStream != null) {
            this.setRequestProperty("Content-length", String.valueOf(this.bufferedOutputStream.size()));
        }
        Iterator itr = this.getRequestProperties().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            outputWriter.print(e.getKey() + ": " + e.getValue() + "\r\n");
        }
        outputWriter.print("\r\n");
        outputWriter.flush();
        if (this.bufferedOutputStream != null) {
            this.bufferedOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
        }
    }

    private void receiveReply() throws IOException {
        String line;
        String saveline = line = this.inputStream.readLine();
        int idx = line.indexOf(" ");
        if (idx == -1 || line.length() < idx + 6) {
            throw new IOException("Server reply was unparseable: " + saveline);
        }
        this.headers.addHeaderField(null, line);
        line = line.substring(idx + 1);
        String code = line.substring(0, 3);
        try {
            this.responseCode = Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new IOException("Server reply was unparseable: " + saveline);
        }
        this.responseMessage = line.substring(4);
        String key = null;
        String value = null;
        while (!(line = this.inputStream.readLine()).equals("")) {
            if (line.startsWith(" ") || line.startsWith("\t")) {
                do {
                    if (line.length() != 1) continue;
                    throw new IOException("Server header lines were unparseable: " + line);
                } while ((line = line.substring(1)).startsWith(" ") || line.startsWith("\t"));
                value = value + " " + line;
                continue;
            }
            if (key != null) {
                this.headers.addHeaderField(key.toLowerCase(), value);
                key = null;
                value = null;
            }
            if ((idx = line.indexOf(":")) == -1 || line.length() < idx + 2) {
                throw new IOException("Server header lines were unparseable: " + line);
            }
            key = line.substring(0, idx);
            value = line.substring(idx + 1);
            while (value.startsWith(" ") || value.startsWith("\t")) {
                if (value.length() == 1) {
                    throw new IOException("Server header lines were unparseable: " + line);
                }
                value = value.substring(1);
            }
        }
        if (key != null) {
            this.headers.addHeaderField(key.toLowerCase(), value.toLowerCase());
        }
    }

    public boolean usingProxy() {
        return proxyInUse;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("You cannot get an output stream for an existing http connection");
        }
        if (!this.doOutput) {
            throw new ProtocolException("Want output stream while haven't setDoOutput(true)");
        }
        if (this.bufferedOutputStream == null) {
            this.bufferedOutputStream = new ByteArrayOutputStream(256);
        }
        return this.bufferedOutputStream;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (!((method = method.toUpperCase()).equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
            throw new ProtocolException("Unsupported or unknown request method " + method);
        }
        super.setRequestMethod(method);
    }

    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        String old = (String)this.requestProperties.put(key, value);
        if (old != null) {
            this.requestProperties.put(key, old + "," + value);
        }
    }

    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return (String)this.requestProperties.get(key);
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.requestProperties.put(key, value);
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.requestProperties;
    }

    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        return this.headers.getHeaderFieldValueByKey(name.toLowerCase());
    }

    public Map getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        return this.headers.getHeaderFields();
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        return this.headers.getHeaderFieldValueByIndex(n);
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        return this.headers.getHeaderFieldKeyByIndex(n);
    }

    static {
        String port = null;
        proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            proxyInUse = true;
            port = System.getProperty("http.proxyPort");
            if (port != null) {
                try {
                    proxyPort = Integer.parseInt(port);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

