/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class Connection
extends URLConnection {
    private static final String DEFAULT_PERMISSION = "read";
    private File file;
    private InputStream inputStream;
    private OutputStream outputStream;
    private FilePermission permission = new FilePermission(this.getURL().getFile(), "read");

    public Connection(URL url) {
        super(url);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.file = new File(this.getURL().getFile());
        if (this.doInput) {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
        }
        if (this.doOutput) {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.outputStream;
    }

    public long getLastModified() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.file.lastModified();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return (int)this.file.length();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public Permission getPermission() throws IOException {
        return this.permission;
    }
}

