import java.util.*;

import org.kde.qt.*;
import org.kde.koala.*;

/**
  * The base class for JavaApiTest application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KBaseView creates your center view, which is connected
  * to the window's Doc object.
  * KBase reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
public class KPenBrushDlg extends QDialog {

   private QSpinBox width_spbox;
   private QLabel width_label;
   private QPushButton default_btn;
   private QPushButton ok_btn;
   private QPushButton cancel_btn;

   public KPenBrushDlg(int curr, QWidget parent, String name) {
      super (parent,name,true,WStyle_ContextHelp);
      initDialog();
      QWhatsThis.add(width_spbox,i18n("Select brush width"));

      width_spbox.setValue(curr);
      connect(default_btn, SIGNAL("clicked()"), this, SLOT("slotDefault()"));
      connect(ok_btn, SIGNAL("clicked()"), this, SLOT("accept()"));
      connect(cancel_btn, SIGNAL("clicked()"), this, SLOT("reject()"));


   }

   int getPenWidth() {
      return width_spbox.value();
   };

   void  initDialog(){
     this.resize(370,210);
     this.setMinimumSize(0,0);
     width_spbox= new QSpinBox(this,"width_spbox");
     width_spbox.setGeometry(150,50,100,25);
     width_spbox.setMinimumSize(0,0);
     width_spbox.setValue(1);
     width_spbox.setRange(1,99);

     width_label= new QLabel(this,"width_label");
     width_label.setGeometry(20,50,120,25);
     width_label.setMinimumSize(0,0);
     width_label.setText(i18n("Pen width:"));

     default_btn= new QPushButton(this,"default");
     default_btn.setGeometry(30,160,100,30);
     default_btn.setMinimumSize(0,0);
     default_btn.setText(i18n("&Default"));
     default_btn.setAutoDefault(true);

     ok_btn= new QPushButton(this,"ok");
     ok_btn.setGeometry(140,160,100,30);
     ok_btn.setMinimumSize(0,0);
     ok_btn.setText(i18n("&OK"));
     ok_btn.setAutoDefault(true);

     cancel_btn= new QPushButton(this,"cancel");
     cancel_btn.setGeometry(250,160,100,30);
     cancel_btn.setMinimumSize(0,0);
     cancel_btn.setText(i18n("&Cancel"));
     cancel_btn.setAutoDefault(true);

   }

   void slotDefault(){
     width_spbox.setValue(3);
   }
}
