/***************************************************************************
                          status.cpp  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include "status.h"
#include "stuff.h"

extern deviceinfo* information;

bool Status::generateStatsWidget ()
{
  content = new QGroupBox (2, Qt::Horizontal, i18n ("Status of Active Connection"), this);
  if ((information->has_freq!=1) || (information->qual.qual == 0))
    {
      stat = new QLabel (i18n ("Searching for network: "), content);
    }
  else stat = new QLabel (i18n ("Connected to network: "), content);
  net_id = new QLabel (information->essid, content);
  ap_str = new QLabel (i18n ("Access point: "), content);
  char stupid[255];
  ap_ad = new QLabel (iw_pr_ether (stupid, (const unsigned char*)information->ap_addr.sa_data), content);
  local_ip_string = new QLabel (i18n ("Local IP: "), content);
  local_ip_content = new QLabel (information->ip_addr, content);
  fr_str = new QLabel (i18n ("Frequency [channel]: "), content);
  QString temp3 = "%1";
  QString temp2 = "%1";
  if (information->freq >= GIGA) {
  if (information->freq / 1000000. > 2474.)
    {
      temp3 = temp3.arg (14);
    }
  else if (information->freq / 1000000. > 2469.)
    {
      temp3 = temp3.arg (13);
    }
  else if (information->freq / 1000000. > 2464.)
    {
      temp3 = temp3.arg (12);
    }
  else if (information->freq / 1000000. > 2459.)
    {
      temp3 = temp3.arg (11);
    }
  else if (information->freq / 1000000. > 2454.)
    {
      temp3 = temp3.arg (10);
    }
  else if (information->freq / 1000000. > 2449.)
    {
      temp3 = temp3.arg (9);
    }
  else if (information->freq / 1000000. > 2444.)
    {
      temp3 = temp3.arg (8);
    }
  else if (information->freq / 1000000. > 2439.)
    {
      temp3 = temp3.arg (7);
    }
  else if (information->freq / 1000000. > 2434.)
    {
      temp3 = temp3.arg (6);
    }
  else if (information->freq / 1000000. > 2429.)
    {
      temp3 = temp3.arg (5);
    }
  else if (information->freq / 1000000. > 2424.)
    {
      temp3 = temp3.arg (4);
    }
  else if (information->freq / 1000000. > 2419.)
    {
      temp3 = temp3.arg (3);
    }
  else if (information->freq / 1000000. > 2414.)
    {
      temp3 = temp3.arg (2);
    }
  else if (information->freq / 1000000. >= 2400.)
    {
      temp3 = temp3.arg (1);
    }
  else
    temp3 = temp3.arg ("?");  
  temp2 = temp2.arg (information->freq / 1000000000.);
  }

  if (information->freq < GIGA) {
  if (information->freq >= 14.)
    {
      temp2 = temp2.arg (2.484);
    }
  else if (information->freq >= 13.)
    {
      temp2 = temp2.arg (2.472);
    }
  else if (information->freq >= 12.)
    {
      temp2 = temp2.arg (2.467);
    }
  else if (information->freq >= 11.)
    {
      temp2 = temp2.arg (2.462);
    }
  else if (information->freq >= 10.)
    {
      temp2 = temp2.arg (2.457);
    }
  else if (information->freq >= 9.)
    {
      temp2 = temp2.arg (2.452);
    }
  else if (information->freq >= 8.)
    {
      temp2 = temp2.arg (2.447);
    }
  else if (information->freq >= 7.)
    {
      temp2 = temp2.arg (2.442);
    }
  else if (information->freq >= 6.)
    {
      temp2 = temp2.arg (2.437);
    }
  else if (information->freq >= 5.)
    {
      temp2 = temp2.arg (2.432);
    }
  else if (information->freq >= 4.)
    {
      temp2 = temp2.arg (2.427);
    }
  else if (information->freq >= 3.)
    {
      temp2 = temp2.arg (2.422);
    }
  else if (information->freq >= 2.)
    {
      temp2 = temp2.arg (2.417);
    }
  else if (information->freq >= 1.)
    {
      temp2 = temp2.arg (2.412);
    }
  else
    temp2 = temp2.arg ("?");  
  temp3 = temp3.arg (information->freq);
  }

  fr = new QLabel (temp2 + " [" + temp3 + "]", content);
  if (geteuid () == 0)
    {
      enc_str = new QLabel (i18n ("Encryption: "), content);
      if (information->has_key)
	if ((information->key_flags & IW_ENCODE_DISABLED) || (information->key_size == 0))
	  {
	    enc = new QLabel (i18n ("off"), content);
	  }
	else
	  enc = new QLabel (i18n ("active"), content);
    }
  content->setFixedSize (content->sizeHint ());
  setFixedSize (content->sizeHint ());
  content->show ();
  widgetbild = QPixmap::grabWidget (content);
  delete
    content;
  return true;
}

void
Status::paintEvent (QPaintEvent *)
{
  QPainter *test = new QPainter (this);
  generateStatsWidget ();
  test->drawPixmap (0, 0, widgetbild);
  delete test;
}
