/**
 * Copyright (C) 1997-2002 the KGhostView authors. See file AUTHORS.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef MARKLIST_H
#define MARKLIST_H

#include "qttableview.h"
#include "kpopupmenu.h"
#include <qstrlist.h>
#include <qlabel.h>
#include <qstring.h>

class KAction;
class KActionMenu;

class MarkListTableItem
{
public:
    MarkListTableItem( const QString& text, const QString& tip ) :
	_marked( false ),
	_selected( false ),
	_text( text ),
	_tip( tip )
    {}

    void setMarked( bool flag )
    {
	_marked = flag;
    }

    bool isMarked() const
    {
	return _marked;
    }

    void toggle()
    {
	setMarked( !isMarked() );
    }

    void setSelected( bool flag )
    {
	_selected = flag;
    }

    bool isSelected() const
    {
	return _selected;
    }

    QString text() const
    {
	return _text;
    }

    QString tip() const
    {
	return _tip;
    }

private:
    bool _marked;
    bool _selected;
    QString _text;
    QString _tip;
};


class MarkListTable: public QtTableView
{
    Q_OBJECT

public:
    MarkListTable( QWidget* parent = 0, const char* name = 0 );
    ~MarkListTable();
    QValueList<int> markList() const;
    void insertItem( const QString& text, int index = -1,
                     const QString& tip = QString::null );
    void setAutoUpdate( bool enable );
    void clear();
    int	rowHeight() const;
    QString text( int index );

public slots:
    void select( int );
    void markCurrent();
    void markAll();
    void markEven();
    void markOdd();
    void toggleMarks();
    void removeMarks();

signals:
    void selected( int );

protected:
    void mousePressEvent( QMouseEvent* );
    void mouseMoveEvent( QMouseEvent* );
    void wheelEvent( QWheelEvent* );
    void paintCell( QPainter*, int row, int col );
    void updateItem( int i );

    int	cellWidth( int );

private:
    void changeMarks( int, int = 0 );
    void initPixmaps();

    KAction* _markCurrent;
    KAction* _markAll;
    KAction* _markEven;
    KAction* _markOdd;
    KAction* _toggleMarks;
    KAction* _removeMarks;

    KActionMenu* _actionMenu;

    int _sel;
    int	_drag;

    QPtrList< MarkListTableItem > _items;

    QPixmap* _flag;
    QPixmap* _bullet;
};


class MarkList: public QWidget
{
    Q_OBJECT

public:
    MarkList( QWidget* parent = 0, const char* name = 0 );

    QValueList<int> markList() const
    {
	return _table->markList();
    }

    QString text( int index )
    {
	return _table->text( index );
    }

    void clear()
    {
	_table->clear();
    }

    void setAutoUpdate ( bool enable )
    {
	_table->setAutoUpdate( enable );
    }

    void insertItem( const QString& text, int index = -1,
                     const QString& tip = QString::null )
    {
	_table->insertItem( text, index, tip);
    }

public slots:
    void select( int index )
    {
	_table->select( index );
    }

    void markCurrent()
    {
	_table->markCurrent();
    }

    void markAll()
    {
	_table->markAll();
    }

    void markEven()
    {
	_table->markEven();
    }

    void markOdd()
    {
	_table->markOdd();
    }

    void toggleMarks()
    {
	_table->toggleMarks();
    }

    void removeMarks()
    {
	_table->removeMarks();
    }

signals:
    void selected( int );

protected:
    void resizeEvent( QResizeEvent* );
    void wheelEvent( QWheelEvent* );

    QPixmap flagPixmap();

private:
    QLabel* _markLabel;
    QLabel* _pageLabel;
    MarkListTable* _table;
};

#endif
