/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.options;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.core.options.UISupport;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.modules.appui.options.NetworkOptionsModel;
import org.graalvm.visualvm.modules.appui.options.NetworkOptionsPanelController;
import org.graalvm.visualvm.uisupport.JExtendedSpinner;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class NetworkOptionsPanel
extends JPanel {
    private static final String GRAALJS_CODENAMEBASE = "org.graalvm.visualvm.modules.graaljs";
    private static final String GRAALJS_DISPLAYNAME = "GraalJS";
    private final NetworkOptionsPanelController controller;
    private boolean passwordChanged;
    private RequestProcessor jsEngineNotifierProcessor;
    private JRadioButton noProxyRadio;
    private JRadioButton systemProxyRadio;
    private JRadioButton manualProxyRadio;
    private JCheckBox sameSettingsCheckBox;
    private JLabel httpProxyLabel;
    private JTextField httpProxyField;
    private JLabel httpProxyPortLabel;
    private SpinnerModel httpProxySpinnerModel;
    private JSpinner httpProxyPortSpinner;
    private JLabel httpsProxyLabel;
    private JTextField httpsProxyField;
    private JLabel httpsProxyPortLabel;
    private SpinnerModel httpsProxySpinnerModel;
    private JSpinner httpsProxyPortSpinner;
    private JLabel socksProxyLabel;
    private JTextField socksProxyField;
    private JLabel socksProxyPortLabel;
    private SpinnerModel socksProxySpinnerModel;
    private JSpinner socksProxyPortSpinner;
    private JLabel noProxyLabel;
    private JTextField noProxyField;
    private JCheckBox authenticationCheckBox;
    private JLabel usernameLabel;
    private JTextField usernameField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JButton systemProxyButton;

    NetworkOptionsPanel(NetworkOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.initListeners();
    }

    void update() {
        NetworkOptionsModel model = this.controller.getModel();
        switch (model.getProxyType()) {
            case 0: {
                this.noProxyRadio.setSelected(true);
                break;
            }
            case 1: 
            case 3: {
                this.systemProxyRadio.setSelected(true);
                break;
            }
            case 2: {
                this.manualProxyRadio.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown proxy configuration");
            }
        }
        this.httpProxyField.setText(model.getHttpProxyHost());
        this.httpProxySpinnerModel.setValue(Integer.parseInt(model.getHttpProxyPort()));
        this.sameSettingsCheckBox.setSelected(model.useProxyAllProtocols());
        this.httpsProxyField.setText(model.getHttpsProxyHost());
        this.httpsProxySpinnerModel.setValue(Integer.parseInt(model.getHttpsProxyPort()));
        this.socksProxyField.setText(model.getSocksHost());
        this.socksProxySpinnerModel.setValue(Integer.parseInt(model.getSocksPort()));
        this.noProxyField.setText(model.getNonProxyHosts());
        this.authenticationCheckBox.setSelected(model.useProxyAuthentication());
        this.usernameField.setText(model.getProxyAuthenticationUsername());
        this.passwordField.setText(new String(model.getProxyAuthenticationPassword()));
        this.updateManualSettings();
    }

    void applyChanges() {
        NetworkOptionsModel model = this.controller.getModel();
        if (this.noProxyRadio.isSelected()) {
            model.setProxyType(0);
        } else if (this.systemProxyRadio.isSelected()) {
            model.setProxyType(1);
        } else if (this.manualProxyRadio.isSelected()) {
            model.setProxyType(2);
        } else {
            throw new IllegalArgumentException("Unknown proxy configuration");
        }
        model.setHttpProxyHost(this.httpProxyField.getText().trim());
        model.setHttpProxyPort(this.httpProxySpinnerModel.getValue().toString());
        model.setUseProxyAllProtocols(this.sameSettingsCheckBox.isSelected());
        model.setHttpsProxyHost(this.httpsProxyField.getText().trim());
        model.setHttpsProxyPort(this.httpsProxySpinnerModel.getValue().toString());
        model.setSocksHost(this.socksProxyField.getText().trim());
        model.setSocksPort(this.socksProxySpinnerModel.getValue().toString());
        model.setNonProxyHosts(this.noProxyField.getText().trim());
        model.setUseProxyAuthentication(this.authenticationCheckBox.isSelected());
        model.setAuthenticationUsername(this.usernameField.getText());
        model.setAuthenticationPassword(this.passwordField.getPassword());
        this.passwordChanged = false;
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        NetworkOptionsModel model = this.controller.getModel();
        int proxyType = model.getProxyType();
        if (this.noProxyRadio.isSelected() && proxyType != 0) {
            return true;
        }
        if (this.systemProxyRadio.isSelected() && proxyType != 1 && proxyType != 3) {
            return true;
        }
        if (this.manualProxyRadio.isSelected() && proxyType != 2) {
            return true;
        }
        if (!this.httpProxyField.getText().equals(model.getHttpProxyHost())) {
            return true;
        }
        if (!this.httpProxySpinnerModel.getValue().toString().equals(model.getHttpProxyPort())) {
            return true;
        }
        if (this.sameSettingsCheckBox.isSelected() != model.useProxyAllProtocols()) {
            return true;
        }
        if (!this.httpsProxyField.getText().equals(model.getHttpsProxyHost())) {
            return true;
        }
        if (!this.httpsProxySpinnerModel.getValue().toString().equals(model.getHttpsProxyPort())) {
            return true;
        }
        if (!this.socksProxyField.getText().equals(model.getSocksHost())) {
            return true;
        }
        if (!this.socksProxySpinnerModel.getValue().toString().equals(model.getSocksPort())) {
            return true;
        }
        if (!this.noProxyField.getText().equals(model.getNonProxyHosts())) {
            return true;
        }
        if (this.authenticationCheckBox.isSelected() != model.useProxyAuthentication()) {
            return true;
        }
        if (!this.usernameField.getText().equals(model.getProxyAuthenticationUsername())) {
            return true;
        }
        return this.passwordChanged;
    }

    private void initComponents() {
        ButtonGroup radiosGroup = new ButtonGroup();
        this.setLayout(new GridBagLayout());
        SectionSeparator sectionSeparator = UISupport.createSectionSeparator((String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_ProxySettingsCaption"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)sectionSeparator, c);
        this.noProxyRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.noProxyRadio, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_NoProxyRadio"));
        radiosGroup.add(this.noProxyRadio);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(2, 10, 2, 0);
        this.add((Component)this.noProxyRadio, c);
        JPanel autoProxySettings = new JPanel(null);
        autoProxySettings.setLayout(new BoxLayout(autoProxySettings, 2));
        c = new GridBagConstraints();
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 10, 2, 0);
        this.add((Component)autoProxySettings, c);
        this.systemProxyRadio = new JRadioButton(){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                super.fireItemStateChanged(e);
                NetworkOptionsPanel.this.updateJSEngineNotifier(this.isSelected());
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.systemProxyRadio, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_SystemProxyRadio"));
        radiosGroup.add(this.systemProxyRadio);
        autoProxySettings.add(this.systemProxyRadio);
        if (!NetworkOptionsPanel.hasDefaultJS()) {
            autoProxySettings.add(Box.createHorizontalStrut(15));
            this.systemProxyButton = new JButton("<html><a href='#'>JavaScript engine may be required</a></html>"){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    NetworkOptionsPanel.this.notifyJSEngine();
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.systemProxyButton, (String)("<html><a href='#'>" + NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_JavaScript_Required_Msg") + "</a></html>"));
            this.systemProxyButton.setToolTipText(NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_JavaScript_Required_Tooltip"));
            this.systemProxyButton.setContentAreaFilled(false);
            this.systemProxyButton.setBorderPainted(true);
            this.systemProxyButton.setMargin(new Insets(0, 0, 0, 0));
            this.systemProxyButton.setBorder(BorderFactory.createEmptyBorder());
            this.systemProxyButton.setCursor(Cursor.getPredefinedCursor(12));
            this.systemProxyButton.setVisible(false);
            autoProxySettings.add(this.systemProxyButton);
        }
        this.manualProxyRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.manualProxyRadio, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_ManualProxyRadio"));
        radiosGroup.add(this.manualProxyRadio);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(2, 10, 2, 0);
        this.add((Component)this.manualProxyRadio, c);
        JPanel manualSettingsPanel = new JPanel(new GridBagLayout());
        manualSettingsPanel.setBorder(BorderFactory.createEmptyBorder(5, 40, 0, 0));
        this.httpProxyLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.httpProxyLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_HttpProxy"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 5);
        manualSettingsPanel.add((Component)this.httpProxyLabel, c);
        this.httpProxyField = new JTextField();
        this.httpProxyLabel.setLabelFor(this.httpProxyField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.httpProxyField, c);
        this.httpProxyPortLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.httpProxyPortLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_HttpProxyPort"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 8, 3, 5);
        manualSettingsPanel.add((Component)this.httpProxyPortLabel, c);
        this.httpProxySpinnerModel = new SpinnerNumberModel(0, 0, 65535, 1);
        this.httpProxyPortSpinner = this.createJSpinner(this.httpProxySpinnerModel);
        this.httpProxyPortLabel.setLabelFor(this.httpProxyPortSpinner);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.httpProxyPortSpinner, c);
        this.sameSettingsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.sameSettingsCheckBox, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_SameSettingsCheckbox"));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        manualSettingsPanel.add((Component)this.sameSettingsCheckBox, c);
        this.httpsProxyLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.httpsProxyLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_HttpsProxy"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 5);
        manualSettingsPanel.add((Component)this.httpsProxyLabel, c);
        this.httpsProxyField = new JTextField();
        this.httpsProxyLabel.setLabelFor(this.httpsProxyField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.httpsProxyField, c);
        this.httpsProxyPortLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.httpsProxyPortLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_HttpsProxyPort"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 8, 3, 5);
        manualSettingsPanel.add((Component)this.httpsProxyPortLabel, c);
        this.httpsProxySpinnerModel = new SpinnerNumberModel(0, 0, 65535, 1);
        this.httpsProxyPortSpinner = this.createJSpinner(this.httpsProxySpinnerModel);
        this.httpsProxyPortLabel.setLabelFor(this.httpsProxyPortSpinner);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.httpsProxyPortSpinner, c);
        this.socksProxyLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.socksProxyLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_SocksProxy"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 5);
        manualSettingsPanel.add((Component)this.socksProxyLabel, c);
        this.socksProxyField = new JTextField();
        this.socksProxyLabel.setLabelFor(this.socksProxyField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.socksProxyField, c);
        this.socksProxyPortLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.socksProxyPortLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_SocksProxyPort"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(3, 8, 3, 5);
        manualSettingsPanel.add((Component)this.socksProxyPortLabel, c);
        this.socksProxySpinnerModel = new SpinnerNumberModel(0, 0, 65535, 1);
        this.socksProxyPortSpinner = this.createJSpinner(this.socksProxySpinnerModel);
        this.socksProxyPortLabel.setLabelFor(this.socksProxyPortSpinner);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.socksProxyPortSpinner, c);
        this.noProxyLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.noProxyLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_NoProxyHosts"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 3, 5);
        manualSettingsPanel.add((Component)this.noProxyLabel, c);
        this.noProxyField = new JTextField();
        this.noProxyLabel.setLabelFor(this.noProxyField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(10, 0, 3, 0);
        manualSettingsPanel.add((Component)this.noProxyField, c);
        JLabel noProxyHintLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)noProxyHintLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_NoProxyHint"));
        noProxyHintLabel.setEnabled(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 17;
        c.gridwidth = 0;
        manualSettingsPanel.add((Component)noProxyHintLabel, c);
        this.authenticationCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.authenticationCheckBox, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_AuthCheckbox"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(5, 0, 0, 0);
        manualSettingsPanel.add((Component)this.authenticationCheckBox, c);
        this.usernameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_Username"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.anchor = 17;
        c.insets = new Insets(3, 30, 3, 5);
        manualSettingsPanel.add((Component)this.usernameLabel, c);
        this.usernameField = new JTextField();
        this.usernameLabel.setLabelFor(this.usernameField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 7;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(3, 0, 3, 0);
        manualSettingsPanel.add((Component)this.usernameField, c);
        this.passwordLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_Password"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 8;
        c.anchor = 17;
        c.insets = new Insets(3, 30, 0, 5);
        manualSettingsPanel.add((Component)this.passwordLabel, c);
        this.passwordField = new JPasswordField();
        this.passwordLabel.setLabelFor(this.passwordField);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 8;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(3, 0, 0, 0);
        manualSettingsPanel.add((Component)this.passwordField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 9;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 0;
        manualSettingsPanel.add((Component)Spacer.create(), c);
        c = new GridBagConstraints();
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        this.add((Component)manualSettingsPanel, c);
        this.updateJSEngineNotifier(this.systemProxyRadio.isSelected());
    }

    private JExtendedSpinner createJSpinner(SpinnerModel model) {
        JExtendedSpinner spinner = new JExtendedSpinner(model);
        JSpinner.NumberEditor seditor = (JSpinner.NumberEditor)spinner.getEditor();
        seditor.getFormat().setGroupingUsed(false);
        return spinner;
    }

    private void initListeners() {
        this.manualProxyRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }
        });
        this.httpProxyField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }
        });
        this.httpProxySpinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }
        });
        this.sameSettingsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }
        });
        this.authenticationCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NetworkOptionsPanel.this.updateManualSettings();
            }
        });
        this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NetworkOptionsPanel.this.passwordChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NetworkOptionsPanel.this.passwordChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NetworkOptionsPanel.this.passwordChanged = true;
            }
        });
    }

    private void updateManualSettings() {
        boolean manual = this.manualProxyRadio.isSelected();
        boolean shared = this.sameSettingsCheckBox.isSelected();
        boolean passwd = this.authenticationCheckBox.isSelected();
        this.httpProxyLabel.setEnabled(manual);
        this.httpProxyField.setEnabled(manual);
        this.httpProxyPortLabel.setEnabled(manual);
        this.httpProxyPortSpinner.setEnabled(manual);
        this.sameSettingsCheckBox.setEnabled(manual);
        this.httpsProxyLabel.setEnabled(manual && !shared);
        this.httpsProxyField.setEnabled(manual && !shared);
        this.httpsProxyPortLabel.setEnabled(manual && !shared);
        this.httpsProxyPortSpinner.setEnabled(manual && !shared);
        this.socksProxyLabel.setEnabled(manual && !shared);
        this.socksProxyField.setEnabled(manual && !shared);
        this.socksProxyPortLabel.setEnabled(manual && !shared);
        this.socksProxyPortSpinner.setEnabled(manual && !shared);
        this.noProxyLabel.setEnabled(manual);
        this.noProxyField.setEnabled(manual);
        this.authenticationCheckBox.setEnabled(manual);
        this.usernameLabel.setEnabled(manual && passwd);
        this.usernameField.setEnabled(manual && passwd);
        this.passwordLabel.setEnabled(manual && passwd);
        this.passwordField.setEnabled(manual && passwd);
        if (shared) {
            String proxy = this.httpProxyField.getText();
            Object port = this.httpProxySpinnerModel.getValue();
            this.httpsProxyField.setText(proxy);
            this.httpsProxySpinnerModel.setValue(port);
            this.socksProxyField.setText(proxy);
            this.socksProxySpinnerModel.setValue(port);
        }
    }

    void updateTestConnectionStatus(NetworkOptionsModel.TestingStatus testingStatus, Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void updateJSEngineNotifier(boolean autoProxySelected) {
        if (this.systemProxyButton != null) {
            if (autoProxySelected) {
                if (this.jsEngineNotifierProcessor == null) {
                    this.jsEngineNotifierProcessor = new RequestProcessor("JavaScript engine notifier");
                }
                this.jsEngineNotifierProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        ScriptEngineManager manager = new ScriptEngineManager();
                        final boolean hasJSEngine = manager.getEngineByName("JavaScript") != null;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NetworkOptionsPanel.this.systemProxyButton.setVisible(!hasJSEngine);
                            }
                        });
                    }
                });
            } else {
                this.systemProxyButton.setVisible(false);
            }
        }
    }

    private void notifyJSEngine() {
        NotifyDescriptor.Confirmation descr = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_JavaScript_Install_Msg"), NbBundle.getMessage(NetworkOptionsPanel.class, (String)"NetworkOptionsPanel_JavaScript_Install_Caption"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descr) == NotifyDescriptor.YES_OPTION) {
            PluginManager.installSingle((String)GRAALJS_CODENAMEBASE, (String)GRAALJS_DISPLAYNAME, (Object[])new Object[0]);
        }
    }

    private static boolean hasDefaultJS() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion == null) {
            return true;
        }
        return javaVersion.startsWith("1.8") || javaVersion.startsWith("1.9") || javaVersion.startsWith("9") || javaVersion.startsWith("10") || javaVersion.startsWith("11") || javaVersion.startsWith("12") || javaVersion.startsWith("13") || javaVersion.startsWith("14");
    }
}

