/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.javasound;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSinkAsync;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.PipedAudioStream;
import org.openhab.core.audio.URLAudioStream;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.audio.internal.javasound.AudioPlayer;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.library.types.PercentType;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AudioSink.class}, immediate=true)
public class JavaSoundAudioSink
extends AudioSinkAsync {
    private final Logger logger = LoggerFactory.getLogger(JavaSoundAudioSink.class);
    private boolean isMac = false;
    private @Nullable PercentType macVolumeValue = null;
    private static @Nullable Player streamPlayer = null;
    private NamedThreadFactory threadFactory = new NamedThreadFactory("audio");
    private static final Set<AudioFormat> SUPPORTED_AUDIO_FORMATS = Set.of(AudioFormat.MP3, AudioFormat.WAV, AudioFormat.PCM_SIGNED);
    private static final Set<Class<? extends AudioStream>> SUPPORTED_AUDIO_STREAMS = Set.of(AudioStream.class);

    @Activate
    protected void activate(BundleContext context) {
        String os = context.getProperty("org.osgi.framework.os.name");
        if (os != null && os.toLowerCase().startsWith("macos")) {
            this.isMac = true;
        }
    }

    @Override
    public synchronized void processAsynchronously(@Nullable AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        PipedAudioStream pipedAudioStream;
        if (audioStream instanceof PipedAudioStream && AudioFormat.PCM_SIGNED.isCompatible((pipedAudioStream = (PipedAudioStream)audioStream).getFormat())) {
            pipedAudioStream.onClose(() -> this.playbackFinished(pipedAudioStream));
            AudioPlayer audioPlayer = new AudioPlayer(pipedAudioStream);
            audioPlayer.start();
            try {
                audioPlayer.join();
            }
            catch (InterruptedException e) {
                this.logger.debug("Audio stream has been interrupted.");
            }
        } else if (audioStream != null && !"MP3".equals(audioStream.getFormat().getCodec())) {
            AudioPlayer audioPlayer = new AudioPlayer(audioStream);
            audioPlayer.start();
            try {
                audioPlayer.join();
                this.playbackFinished(audioStream);
            }
            catch (InterruptedException e) {
                this.logger.error("Playing audio has been interrupted.");
            }
        } else {
            if (audioStream == null || audioStream instanceof URLAudioStream) {
                Player player = streamPlayer;
                if (player instanceof Player) {
                    Player player2 = player;
                    player2.close();
                    streamPlayer = null;
                }
                if (audioStream == null) {
                    return;
                }
                try {
                    this.playInThread(audioStream, true);
                }
                catch (JavaLayerException e) {
                    this.logger.error("An exception occurred while playing url audio stream : '{}'", (Object)e.getMessage());
                }
                return;
            }
            try {
                this.playInThread(audioStream, false);
            }
            catch (JavaLayerException e) {
                this.logger.error("An exception occurred while playing audio : '{}'", (Object)e.getMessage());
            }
        }
    }

    private void playInThread(AudioStream audioStream, boolean store) throws JavaLayerException {
        Player streamPlayerFinal = new Player(audioStream);
        if (store) {
            streamPlayer = streamPlayerFinal;
        }
        this.threadFactory.newThread(() -> {
            try {
                try {
                    streamPlayerFinal.play();
                }
                catch (Exception e) {
                    this.logger.error("An exception occurred while playing audio : '{}'", (Object)e.getMessage());
                    streamPlayerFinal.close();
                    this.playbackFinished(audioStream);
                }
            }
            finally {
                streamPlayerFinal.close();
                this.playbackFinished(audioStream);
            }
        }).start();
    }

    protected synchronized void deactivate() {
        Player player = streamPlayer;
        if (player instanceof Player) {
            Player player2 = player;
            player2.close();
            streamPlayer = null;
        }
    }

    @Override
    public Set<AudioFormat> getSupportedFormats() {
        return SUPPORTED_AUDIO_FORMATS;
    }

    @Override
    public Set<Class<? extends AudioStream>> getSupportedStreams() {
        return SUPPORTED_AUDIO_STREAMS;
    }

    @Override
    public String getId() {
        return "enhancedjavasound";
    }

    @Override
    public @Nullable String getLabel(@Nullable Locale locale) {
        return "System Speaker";
    }

    @Override
    public PercentType getVolume() throws IOException {
        if (!this.isMac) {
            Float[] volumes = new Float[1];
            this.runVolumeCommand(input -> {
                FloatControl volumeControl = input;
                floatArray[0] = Float.valueOf(volumeControl.getValue());
                return true;
            });
            if (volumes[0] != null) {
                return new PercentType(Math.round(volumes[0].floatValue() * 100.0f));
            }
            this.logger.warn("Cannot determine master volume level - assuming 100%");
            return PercentType.HUNDRED;
        }
        PercentType cachedVolume = this.macVolumeValue;
        if (cachedVolume == null) {
            String value;
            Process p = Runtime.getRuntime().exec(new String[]{"osascript", "-e", "output volume of (get volume settings)"});
            Throwable throwable = null;
            Object var5_7 = null;
            try (Scanner scanner = new Scanner(p.getInputStream(), StandardCharsets.UTF_8.name());){
                value = scanner.useDelimiter("\\A").next().strip();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                this.macVolumeValue = cachedVolume = new PercentType(value);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Cannot determine master volume level, received response '{}' - assuming 100%", (Object)value);
                return PercentType.HUNDRED;
            }
        }
        return cachedVolume;
    }

    @Override
    public void setVolume(PercentType volume) throws IOException {
        if (volume.intValue() < 0 || volume.intValue() > 100) {
            throw new IllegalArgumentException("Volume value must be in the range [0,100]!");
        }
        if (!this.isMac) {
            this.runVolumeCommand(input -> {
                input.setValue(volume.floatValue() / 100.0f);
                return true;
            });
        } else {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", "set volume output volume " + volume.intValue()});
            this.macVolumeValue = volume;
        }
    }

    private void runVolumeCommand(Function<FloatControl, Boolean> closure) {
        Mixer.Info[] infos;
        Mixer.Info[] infoArray = infos = AudioSystem.getMixerInfo();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info info = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(info);
            if (mixer.isLineSupported(Port.Info.SPEAKER)) {
                try {
                    Port port = (Port)mixer.getLine(Port.Info.SPEAKER);
                    port.open();
                    if (port.isControlSupported(FloatControl.Type.VOLUME)) {
                        FloatControl volume = (FloatControl)port.getControl(FloatControl.Type.VOLUME);
                        closure.apply(volume);
                    }
                    port.close();
                }
                catch (LineUnavailableException e) {
                    this.logger.error("Cannot access master volume control", (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

