/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CertificateTypeExtension
extends HelloExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateTypeExtension.class);
    protected static final int LIST_FIELD_LENGTH_BITS = 8;
    protected static final int EXTENSION_TYPE_BITS = 8;
    public static final List<CertificateType> EMPTY = Collections.emptyList();
    public static final List<CertificateType> DEFAULT_X509 = CertificateTypeExtension.asList(CertificateType.X_509);
    private final boolean isClientExtension;
    protected final List<CertificateType> certificateTypes;

    protected CertificateTypeExtension(HelloExtension.ExtensionType type, DatagramReader extensionDataReader) {
        super(type);
        List<Object> types;
        if (extensionDataReader == null) {
            throw new NullPointerException("extension data must not be null!");
        }
        if (!extensionDataReader.bytesAvailable()) {
            throw new IllegalArgumentException("extension data must not be empty!");
        }
        boolean bl = this.isClientExtension = extensionDataReader.bitsLeft() > 8;
        if (this.isClientExtension) {
            int length = extensionDataReader.read(8);
            types = new ArrayList(length);
            DatagramReader rangeReader = extensionDataReader.createRangeReader(length);
            while (rangeReader.bytesAvailable()) {
                int typeCode = rangeReader.read(8);
                CertificateType certificateType = CertificateType.getTypeFromCode(typeCode);
                if (certificateType != null) {
                    types.add((Object)certificateType);
                    continue;
                }
                LOG.debug("Client indicated preference for unknown {} certificate type code [{}]", (Object)(this.getType().equals((Object)HelloExtension.ExtensionType.CLIENT_CERT_TYPE) ? "client" : "server"), (Object)typeCode);
            }
            if (types.isEmpty()) {
                throw new IllegalArgumentException("Empyt client certificate types!");
            }
        } else {
            int typeCode = extensionDataReader.read(8);
            CertificateType certificateType = CertificateType.getTypeFromCode(typeCode);
            if (certificateType != null) {
                types = CertificateTypeExtension.asList(certificateType);
            } else {
                LOG.debug("Server selected an unknown {} certificate type code [{}]", (Object)(this.getType().equals((Object)HelloExtension.ExtensionType.CLIENT_CERT_TYPE) ? "client" : "server"), (Object)typeCode);
                throw new IllegalArgumentException("unknown certificate type code " + typeCode + "!");
            }
        }
        this.certificateTypes = ListUtils.init(types);
    }

    protected CertificateTypeExtension(HelloExtension.ExtensionType type, List<CertificateType> certificateTypes) {
        super(type);
        if (certificateTypes == null) {
            throw new NullPointerException("certificate types must not be null!");
        }
        if (certificateTypes.isEmpty()) {
            throw new IllegalArgumentException("certificate types data must not be empty!");
        }
        this.isClientExtension = true;
        this.certificateTypes = certificateTypes;
    }

    protected CertificateTypeExtension(HelloExtension.ExtensionType type, CertificateType certificateType) {
        super(type);
        if (certificateType == null) {
            throw new NullPointerException("certificate type must not be null!");
        }
        this.isClientExtension = false;
        this.certificateTypes = CertificateTypeExtension.asList(certificateType);
    }

    public boolean isClientExtension() {
        return this.isClientExtension;
    }

    public List<CertificateType> getCertificateTypes() {
        return this.certificateTypes;
    }

    public CertificateType getCertificateType() {
        return this.certificateTypes.get(0);
    }

    public boolean contains(CertificateType type) {
        return this.certificateTypes.contains((Object)type);
    }

    public List<CertificateType> getCommonCertificateTypes(List<CertificateType> supportedCertificateTypes) {
        ArrayList<CertificateType> common = new ArrayList<CertificateType>();
        for (CertificateType certType : this.certificateTypes) {
            if (!supportedCertificateTypes.contains((Object)certType)) continue;
            common.add(certType);
        }
        return common;
    }

    public String toString(int indent, String side) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation((int)(indent + 1));
        if (this.isClientExtension()) {
            sb.append(indentation).append(side).append(" certificate types: (").append(this.getCertificateTypes().size()).append(" types)").append(StringUtil.lineSeparator());
            String indentation2 = StringUtil.indentation((int)(indent + 2));
            for (CertificateType type : this.getCertificateTypes()) {
                sb.append(indentation2).append(side).append(" certificate type: ").append((Object)type).append(StringUtil.lineSeparator());
            }
        } else {
            sb.append(indentation).append(side).append(" certificate type: ").append((Object)this.getCertificateType()).append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        if (this.isClientExtension) {
            return 1 + this.certificateTypes.size();
        }
        return 1;
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        if (this.isClientExtension) {
            writer.write(this.certificateTypes.size(), 8);
            for (CertificateType type : this.certificateTypes) {
                writer.write(type.getCode(), 8);
            }
        } else {
            writer.write(this.certificateTypes.get(0).getCode(), 8);
        }
    }

    private static List<CertificateType> asList(CertificateType certificateType) {
        ArrayList<CertificateType> certificateTypes = new ArrayList<CertificateType>(1);
        certificateTypes.add(certificateType);
        return certificateTypes;
    }
}

