/*	$OpenBSD: sincos.c,v 1.1 2018/03/10 20:52:58 kettenis Exp $	*/

/*
 * Copyright (c) 2009 Gaston H. Gonnet <gonnet@inf.ethz.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* This program was generated automatically by a program written
   by Gaston H. Gonnet on enigma on 2002-09-01 17:42:09.
   Do not edit, rerun the original maple program.       */
#include "header.h"
#define DBL_MAX_EXP 1024
#define N 1257
#define F sincos_sin
#define Fs "sincos sin"
#define Fn fpaccuracy_sincos_sin

double sincos_sin(double);

static struct input_point { double arg_m, val, eps;
	int arg_e, val_e; } input_points[N] = {
 -7958517471031996.,6212835604728892.,.130833791443020784676,-48,101,
 -7958517471031995.,-5588727300024200.,.261667582886055137131,-48,102,
 -7958517471031969.,-7405673258539934.,-.120911444006621323138,-48,96,
 -7958517471029387.,-5735734868167607.,-.235319538568943385656,-48,89,
 -7958517470771212.,-8960446310473519.,.138230043465246743807,-48,83,
 -7074237752028441.,-6523320454730237.,.439258852050649861914,-48,101,
 -7074237752028440.,4967757600021511.,-.121482295898715466354,-48,102,
 -7074237752028407.,4683147721975992.,.053738419552382839132,-48,95,
 -7074237752025168.,7195810507888803.,-.124160499281507210719,-48,89,
 -7074237751701192.,5622082568348465.,.271200950923179606269,-48,82,
 -6189958033024886.,6833805304731581.,-.009351495544320606337,-48,101,
 -6189958033024885.,-8693575800037644.,-.037405982177248259838,-48,103,
 -6189958033024884.,-5590296602375202.,.495324252227861954253,-48,100,
 -6189958033024814.,-5013160476848593.,.476489441494583545252,-48,94,
 -6189958033017771.,-7822191026877127.,-.258179019650541974984,-48,88,
 -6189958032313442.,-6111250908646246.,.449802454767560031340,-48,81,
 -5305678314198564.,-6089706763479862.,-.090896353359190238911,-48,83,
 -5305678314023102.,-7792428794092300.,.313759545668310313647,-48,90,
 -5305678314021348.,-5008333671416556.,.080607629348272501979,-48,96,
 -5305678314021331.,-7144290154732925.,-.420555860962008546748,-48,101,
 -5305678314021330.,7451636400032266.,.317776556151927322001,-48,103,
 -8842797190035551.,5902350754727548.,-.299073565063304663147,-49,102,
 -8842797190035550.,-6209697000026889.,.401852869873393727593,-49,103,
 -8842797190035547.,-7531611566059105.,-.074768391265781521372,-49,100,
 -8842797190035219.,-5829077737928285.,.241603372279800849465,-49,93,
 -8842797190002404.,-4555598928011245.,.275327658586077643888,-49,86,
 -7074237752028441.,-6523320454730237.,.439258852050644463614,-49,102,
 -7074237752028440.,4967757600021511.,-.121482295898714870318,-49,103,
 -7074237752028432.,4658842052371168.,.214953678252997362028,-49,98,
 -7074237752027622.,7197629755056780.,-.496641351311827911854,-49,92,
 -7074237751946628.,5622096781216965.,.089850199524424779073,-49,85,
 -5611213340383481.,4652070016093056.,-.499998959884557667038,-49,53,
 -5611213340369957.,4652070015907767.,-.497442054272881026266,-49,53,
 -5611213340369917.,4652070015907218.,.472396915142160649035,-49,53,
 -5611213340369897.,4652070015906944.,.457316399840873879892,-49,53,
 -5611213340369820.,4652070015905889.,.499256415876099806074,-49,53,
 -5611213340369556.,4652070015902273.,-.499806386949586537223,-49,53,
 -5611213340361068.,4652070015785981.,-.499977653344776178378,-49,53,
 -5589917886911323.,8714095416787853.,-.499998315907917689630,-49,54,
 -5589917886910908.,8714095416776230.,-.389376806057253401320,-49,54,
 -5589917886910893.,8714095416775810.,-.493812173259762111249,-49,54,
 -5589917886910892.,8714095416775781.,.499225468926517333395,-49,54,
 -5584028471356741.,8548676923307456.,.499554512628701620738,-49,54,
 -5584028471356586.,8548676923303091.,-.442341916454404957759,-49,54,
 -5584028471356562.,8548676923302415.,-.459151686176827992968,-49,54,
 -5584028471356508.,8548676923300894.,-.496973668109088894332,-49,54,
 -5584028471356502.,8548676923300724.,.498823889449137751487,-49,54,
 -5584028471355552.,8548676923273966.,-.499896176080930915301,-49,54,
 -5584028471354124.,8548676923233742.,.499922458563984758803,-49,54,
 -5584028471315813.,8548676922154622.,.499938137545812416381,-49,54,
 -5584028471277502.,8548676921075502.,.499914224631142269594,-49,54,
 -5555479367778394.,7733877897149014.,.498194433718948127849,-49,54,
 -5555479367778323.,7733877897146963.,-.467976183757718174230,-49,54,
 -5555479367778303.,7733877897146385.,-.486615794336733055531,-49,54,
 -5555479367778293.,7733877897146096.,-.495935599629901068532,-49,54,
 -5555479367778182.,7733877897142888.,-.499385438547949837018,-49,54,
 -5555479367777001.,7733877897108755.,.499945535966937517766,-49,54,
 -5555479367774104.,7733877897025029.,.499997748435205964563,-49,54,
 -5545533983891579.,7445255117838313.,.499953679017880276498,-49,54,
 -5545533983828595.,7445255116003015.,.499866878281156920177,-49,54,
 -5545533983828480.,7445255115999665.,-.498323381954439508972,-49,54,
 -5545533983828365.,7445255115996314.,-.496513642500731957644,-49,54,
 -5545533983828343.,7445255115995672.,.442963003272399324280,-49,54,
 -5545533983828329.,7445255115995264.,.495357232394835337739,-49,54,
 -5545533983827488.,7445255115970758.,.499896273374760833679,-49,54,
 -5545533983824167.,7445255115873987.,.499984285918123912375,-49,54,
 -5545533983823060.,7445255115841731.,-.499986434146571281581,-49,54,
 -5544198963895300.,7406332917910339.,-.499994971767098549189,-49,54,
 -5544198963889625.,7406332917744797.,-.499933748091774878947,-49,54,
 -5544198963889044.,7406332917727848.,.499720054538118231755,-49,54,
 -5544198963888997.,7406332917726477.,.491086196574639771345,-49,54,
 -5544198963846191.,7406332916477809.,.499981272734332414279,-49,54,
 -5539725571708487.,7275609834821478.,.499985253055923466757,-49,54,
 -5539725571705812.,7275609834743170.,.499796602236188531044,-49,54,
 -5539725571705768.,7275609834741882.,.442971067914837318139,-49,54,
 -5539725571705750.,7275609834741356.,-.489366650683980435597,-49,54,
 -5539725571705739.,7275609834741033.,.496426965724191393968,-49,54,
 -5539725571704334.,7275609834699904.,-.499933870432698202045,-49,54,
 -5539725571682372.,7275609834056988.,-.499994340368070567080,-49,54,
 -5537279579438704.,7203937359838968.,.499999058449149989697,-49,54,
 -5537279579436764.,7203937359782069.,-.499799330481731796179,-49,54,
 -5537279579434630.,7203937359719479.,-.499577657119091292292,-49,54,
 -5537279579434627.,7203937359719391.,-.489268067210660436512,-49,54,
 -5537279579434606.,7203937359718775.,-.417100937857372813839,-49,54,
 -5522619698292048.,6771570642152360.,.499911939891685382213,-49,54,
 -5522619698198654.,6771570639382933.,.499855746087560314850,-49,54,
 -5522619698197691.,6771570639354378.,-.490905381817256626937,-49,54,
 -5522619698197688.,6771570639354289.,-.450378157947609811314,-49,54,
 -5522619698197642.,6771570639352925.,-.495627391970439596103,-49,54,
 -5522619698197593.,6771570639351471.,.499650597825074524915,-49,54,
 -5522619698194632.,6771570639263669.,-.499979542608105490634,-49,54,
 -5522215089853399.,6759570976392264.,.499936161964552260624,-49,54,
 -5522215089853198.,6759570976386302.,.479076040222845856731,-49,54,
 -5522215089853195.,6759570976386213.,.493690068250024921094,-49,54,
 -5522215089852920.,6759570976378056.,.499975969926121114745,-49,54,
 -5522215089852441.,6759570976363849.,-.499984227006159248299,-49,54,
 -5522215089827465.,6759570975623015.,.499996720135387389244,-49,54,
 -5512667243258777.,6475406094855963.,-.499449014049899453593,-49,54,
 -5512667243258525.,6475406094848437.,.485772164743541172920,-49,54,
 -5512667243258460.,6475406094846497.,-.490262055222627687090,-49,54,
 -5512667243258316.,6475406094842197.,-.498707096685920387008,-49,54,
 -5512667243257819.,6475406094827355.,.499923555564536308278,-49,54,
 -5512667243256400.,6475406094784983.,-.499961994257300891459,-49,54,
 -5512667243248347.,6475406094544510.,.499982023697618042065,-49,54,
 -5512667243195772.,6475406092974559.,.499956505097263724003,-49,54,
 -5486380295692487.,5683674037828652.,.499988359788258983742,-49,54,
 -5486380295690170.,5683674037758296.,-.458277432697175324799,-49,54,
 -5486380295690148.,5683674037757627.,.499822762165220324823,-49,54,
 -5486380295662463.,5683674036916957.,.499992918459051883178,-49,54,
 -5482520377149080.,5566332839437440.,.487703427588966263896,-49,54,
 -5482520377149057.,5566332839436741.,-.495500261287941987039,-49,54,
 -5482520377149004.,5566332839435127.,.499726020829895036327,-49,54,
 -5482520377148587.,5566332839422436.,.499902616149026765141,-49,54,
 -5482520377148170.,5566332839409746.,-.499920791586071278634,-49,54,
 -5482520377119890.,5566332838549071.,-.499942237071479593698,-49,54,
 -5482520376995458.,5566332834762100.,.499796522579056940346,-49,54,
 -5468820810102350.,5147792518152047.,.499920089577544279220,-49,54,
 -5468820810014038.,5147792515443904.,-.499966681744417248146,-49,54,
 -5468820810002999.,5147792515105386.,-.499961435610613204563,-49,54,
 -5468820810001172.,5147792515049359.,.375752621569139357980,-49,54,
 -5468820810001109.,5147792515047427.,.440432415677242355858,-49,54,
 -5468820810001052.,5147792515045679.,.498952229338544443015,-49,54,
 -5468820810000726.,5147792515035683.,-.499688837402113392338,-49,54,
 -5468820810000077.,5147792515015780.,.499949033793940553710,-49,54,
 -5468088758213645.,5125339332333894.,.499975877850471021692,-49,54,
 -5468088758161793.,5125339330743205.,-.499979960944669530267,-49,54,
 -5468088758157272.,5125339330604511.,.498980402986912199716,-49,54,
 -5468088758157179.,5125339330601658.,.490996173426713311532,-49,54,
 -5468088758157117.,5125339330599756.,.485673353642204136528,-49,54,
 -5468088758157114.,5125339330599664.,.453157733328473626638,-49,54,
 -5468088758156903.,5125339330593191.,.499559104230962947533,-49,54,
 -5468088758156534.,5125339330581872.,-.499862196727079936656,-49,54,
 -5468088758153151.,5125339330478090.,-.499976828204930801832,-49,54,
 -5465050034923429.,5032044667506620.,-.499991903237315811647,-49,54,
 -5465050034923261.,5032044667501457.,.497994140674588895473,-49,54,
 -5465050034923009.,5032044667493714.,.494973205702164560771,-49,54,
 -5465050034922987.,5032044667493039.,-.481481002954396447392,-49,54,
 -5465050034922976.,5032044667492701.,-.469708107285558868958,-49,54,
 -5465050034910518.,5032044667109913.,.499993772397313803075,-49,54,
 -5418613610005258.,7179474664950594.,.499626489065263885410,-49,55,
 -5418613610005191.,7179474664946392.,.497470679233703312017,-49,55,
 -5418613610003410.,7179474664834694.,.499866204489753984131,-49,55,
 -5418613610002486.,7179474664776744.,.499986033189289251994,-49,55,
 -5418613609935690.,7179474660587536.,.499939208604795184661,-49,55,
 -5413189175949861.,6838945386852834.,-.499994430708534262693,-49,55,
 -5413189175913193.,6838945384548748.,-.499979024543708126849,-49,55,
 -5413189175912759.,6838945384521476.,.491948550330228003409,-49,55,
 -5413189175912741.,6838945384520345.,.436314210029839216095,-49,55,
 -5413189175912710.,6838945384518398.,-.492833820503886967775,-49,55,
 -5413189175912600.,6838945384511486.,-.499488122565106247413,-49,55,
 -5398648100197461.,5923056452061726.,-.499918759733346049624,-49,55,
 -5398648100196958.,5923056452029972.,-.499263816261055743070,-49,55,
 -5398648100196935.,5923056452028520.,-.471400866672594514359,-49,55,
 -5398648100196927.,5923056452028014.,.494812333181944021226,-49,55,
 -5398648100192903.,5923056451773983.,-.499948291604580587179,-49,55,
 -5398648100183787.,5923056451198496.,.499991479786349834335,-49,55,
 -5398648100150194.,5923056449077796.,.499975520867696132095,-49,55,
 -5358514779854742.,6753142658154098.,.499846278992070624700,-49,56,
 -5358514779729599.,6753142642206296.,-.439943425700363057491,-49,56,
 -5358514779729592.,6753142642205404.,-.496395482115909679733,-49,56,
 -5358514779729450.,6753142642187308.,-.498708626770999343783,-49,56,
 -5358514779729379.,6753142642178260.,-.499865199259673395736,-49,56,
 -5358514779728511.,6753142642067645.,-.499920206819331293038,-49,56,
 -5358514779727643.,6753142641957030.,-.499975230433822410286,-49,56,
 -5357868470797996.,6670774773654320.,-.499959177001602339099,-49,56,
 -5357868470793064.,6670774773025735.,-.499507634405544337416,-49,56,
 -5357868470792944.,6670774773010440.,.461573905262571767782,-49,56,
 -5357868470792933.,6670774773009039.,-.491993620283016909869,-49,56,
 -5357868470792913.,6670774773006490.,-.498480030372430683336,-49,56,
 -5357868470792138.,6670774772907716.,-.499828427821700124302,-49,56,
 -5357868470785354.,6670774772043092.,.499980673381329165717,-49,56,
 -5357868470738641.,6670774766089505.,.499966539808520790108,-49,56,
 -5340868642030055.,9002858075942352.,-.499999567510129621708,-49,57,
 -5340868642030053.,9002858075941841.,-.499986682883159495444,-49,57,
 -5340868642029943.,9002858075913736.,-.499278028574795899252,-49,57,
 -5340868642026707.,9002858075086938.,-.478430861081203575908,-49,57,
 -5340868642025337.,9002858074736903.,-.469605048527975030810,-49,57,
 -5340868642025317.,9002858074731793.,-.469476204943967136017,-49,57,
 -5334469363683153.,7367296052893990.,.499999809069905540594,-49,57,
 -5334469363655190.,7367296045744822.,.470704330379467058803,-49,57,
 -5334469363655175.,7367296045740987.,.491609112821074163907,-49,57,
 -5334469363655169.,7367296045739453.,.499971025796252439448,-49,57,
 -5334469363643210.,7367296042681952.,.499988907616124526959,-49,57,
 -5325827369906433.,5157057057842082.,.499972107232987246078,-49,57,
 -5325827369870741.,5157057048710782.,.499970344688235904690,-49,57,
 -5325827369852895.,5157057044145132.,.499961689579452355385,-49,57,
 -5325827369851541.,5157057043798730.,.499512541657770195514,-49,57,
 -5325827369851071.,5157057043678488.,-.440082073532463514451,-49,57,
 -5325827369851053.,5157057043673883.,-.488832505675048997707,-49,57,
 -5325827369851047.,5157057043672347.,.494917350276250866076,-49,57,
 -5325827369850864.,5157057043625529.,.499287956509482997091,-49,57,
 -5317788020392809.,6199691505849210.,.499994874906830447356,-49,58,
 -5317788020390040.,6199691504431810.,.499980448898540918953,-49,58,
 -5317788020389736.,6199691504276199.,-.489909190252342854372,-49,58,
 -5317788020389719.,6199691504267497.,-.476185913547710102449,-49,58,
 -5317788020389677.,6199691504245997.,.498895122992438415707,-49,58,
 -5307605800727999.,7894970124880674.,.499988124870354061428,-49,61,
 -5307605800692179.,7894969978162814.,.499707353695941054856,-49,61,
 -5307605800691221.,7894969974238870.,-.499742247059479801221,-49,61,
 -5307605800678684.,7894969922887619.,-.499848367687876068394,-49,61,
 -5307605800660774.,7894969849528688.,.499993239049629048278,-49,61,
 -5305678314065639.,6089754163653848.,.365188728149908596756,-49,86,
 -5305678314021773.,7789699923340335.,-.255037977637273428780,-49,93,
 -5305678314021334.,8541471979738975.,.355138965240439868439,-49,100,
 -5305678314021331.,7144290154732925.,.420555860962015638086,-49,102,
 -5305678314021330.,-7451636400032266.,-.317776556151927824906,-49,104,
 -5299460840261238.,-6366563696336530.,-.499997766638501205250,-49,59,
 -5299460840243913.,-6366563714076249.,.499696208616982453112,-49,59,
 -5299460840243897.,-6366563714092632.,.498945568033319992978,-49,59,
 -5299460840243417.,-6366563714584122.,.476426352914880372482,-49,59,
 -5299460840243305.,-6366563714698803.,.471171870053246023999,-49,59,
 -5299460840242584.,-6366563715437062.,.499846142664231251180,-49,59,
 -5299460840241255.,-6366563716797875.,.499996112194083414221,-49,59,
 -5266341419853530.,-5031025950084337.,-.499985273828726109257,-49,56,
 -5266341419832068.,-5031025952824769.,-.499976674386093474558,-49,56,
 -5266341419812069.,-5031025955378394.,-.491481975117204309773,-49,56,
 -5266341419812037.,-5031025955382480.,-.495768592841602642216,-49,56,
 -5266341419812005.,-5031025955386567.,.499944789450255146948,-49,56,
 -5266341419810606.,-5031025955565201.,-.499960762586839321008,-49,56,
 -5242088987178115.,-8122135881181049.,.499999686447252564259,-49,56,
 -5242088987167728.,-8122135882502112.,.499094325479729869910,-49,56,
 -5242088987167690.,-8122135882506945.,.496876712021787047118,-49,56,
 -5242088987167652.,-8122135882511778.,.494659098600852416370,-49,56,
 -5242088987167283.,-8122135882558709.,.499440696516818663247,-49,56,
 -5242088987166393.,-8122135882671902.,-.499866546183490115412,-49,56,
 -5242088987163685.,-8122135883016318.,.499994237962218467258,-49,56,
 -5208774931143459.,-6171234740779278.,.499999901220162336585,-49,55,
 -5208774931125089.,-6171234741937583.,.499859190769440055705,-49,55,
 -5208774931124849.,-6171234741952715.,-.499598238280683264229,-49,55,
 -5208774931124812.,-6171234741955049.,.496318741507212026866,-49,55,
 -5208774931124738.,-6171234741959715.,.488152701162978151466,-49,55,
 -5208774931119458.,-6171234742292640.,-.499910442751117803191,-49,55,
 -5208774931108436.,-6171234742987623.,-.499990506212703052710,-49,55,
 -5161411928706809.,-4566159379852245.,.499995283505396611547,-49,54,
 -5161411928699038.,-4566159380092796.,.499966325677312653601,-49,54,
 -5161411928695974.,-4566159380187641.,-.499787485701841872908,-49,54,
 -5161411928695530.,-4566159380201386.,.497637234313890733334,-49,54,
 -5161411928695330.,-4566159380207576.,-.494513791778157687485,-49,54,
 -5161411928695308.,-4566159380208258.,.496349595386901953454,-49,54,
 -5161411928674193.,-4566159380861871.,-.499991735252788297500,-49,54,
 -5120907462136485.,-5807077948366709.,-.499992327046999084216,-49,54,
 -5120907462135402.,-5807077948399515.,-.492508340717233961295,-49,54,
 -5120907462135354.,-5807077948400969.,-.497716806199694032913,-49,54,
 -5120907462135330.,-5807077948401697.,.499678961074907786984,-49,54,
 -5119822908964471.,-5839920192101598.,-.499983317297960421500,-49,54,
 -5119822908932313.,-5839920193075081.,.485312256992592576282,-49,54,
 -5119822908932302.,-5839920193075414.,.495009326342811597355,-49,54,
 -5119822908932291.,-5839920193075746.,-.495293604304739649363,-49,54,
 -5119822908929922.,-5839920193147460.,-.497806525450835266515,-49,54,
 -5119822908927862.,-5839920193209820.,-.499991590209490134858,-49,54,
 -5095830265926884.,-6560698847046669.,-.499963642042803225310,-49,54,
 -5095830265902192.,-6560698847782550.,.499983110454627245500,-49,54,
 -5095830265871327.,-6560698848702400.,.499934300555017496062,-49,54,
 -5095830265869551.,-6560698848755329.,.499446104674266205616,-49,54,
 -5095830265869465.,-6560698848757892.,.496044087837560189246,-49,54,
 -5095830265869455.,-6560698848758190.,.472392690540903385772,-49,54,
 -7074237752028441.,-6523320454730237.,.439258852050643114039,-50,103,
 -7074237752028440.,4967757600021511.,-.121482295898714721309,-50,104,
 -7074237752028438.,5124569327373185.,-.140185286987342823443,-50,101,
 -7074237752028235.,7222498929773102.,.013434604850808816997,-50,95,
 -7074237752007987.,5622153632690964.,.359479648623543693521,-50,88,
 -7074237752028441.,6523320454730237.,-.439258852050642776645,-51,104,
 -7074237752028440.,-4967757600021511.,.121482295898714684057,-51,105,
 -7074237752028439.,-5745539027375874.,.280370573974678975280,-51,103,
 -7074237752028389.,-7216422512371896.,-.053738419562667649482,-51,98,
 -7074237752023327.,-5622106160680017.,-.437919826571286137851,-51,91,
 -8871213671092317.,-7504962526444771.,-.499994356426362647532,-53,53,
 -8871213671077773.,-7504962526436729.,-.478099669195175532480,-53,53,
 -8871213671077764.,-7504962526436725.,.498399028018327575475,-53,53,
 -8871213671077339.,-7504962526436490.,.499726396442283465672,-53,53,
 -8871213671077254.,-7504962526436443.,.499991870129079707039,-53,53,
 -8108579655028955.,-7056886948212518.,.499990962962087826487,-53,53,
 -8108579655012266.,-7056886948202146.,-.499918615255350226267,-53,53,
 -8108579655012126.,-7056886948202060.,.499902384250890642569,-53,53,
 -8108579655011706.,-7056886948201799.,.499365382779842431918,-53,53,
 -8108579655010726.,-7056886948201190.,.498112379407066840301,-53,53,
 -8108579655010710.,-7056886948201180.,.440949065066979909969,-53,53,
 -8108579654961919.,-7056886948170860.,.499994795686109707594,-53,53,
 -7881394195549603.,-6913478057984781.,.499997922780307662077,-53,53,
 -7881394195509958.,-6913478057959368.,-.499987891080840223787,-53,53,
 -7881394195507972.,-6913478057958095.,-.496279269228611509884,-53,53,
 -7881394195507958.,-6913478057958087.,.477563591148176267211,-53,53,
 -7881394195507933.,-6913478057958070.,-.497717015321804016997,-53,53,
 -7881394195507894.,-6913478057958045.,-.499154761414866911796,-53,53,
 -7881394195507855.,-6913478057958021.,.499407492492199805718,-53,53,
 -7881394195506479.,-6913478057957139.,.499962912475768844569,-53,53,
 -7109328173650617.,-6393815952054821.,.499925342262490988657,-53,53,
 -7109328173649467.,-6393815952054011.,.498586434490820526144,-53,53,
 -7109328173647742.,-6393815952052796.,.496578073028738672583,-53,53,
 -7109328173647715.,-6393815952052776.,-.486062057844455988951,-53,53,
 -7109328173647708.,-6393815952052772.,.444364574892132551247,-53,53,
 -7109328173643186.,-6393815952049587.,.499969323535347987772,-53,53,
 -7109328173635755.,-6393815952044352.,-.499986690839933034561,-53,53,
 -7109328173568531.,-6393815951997003.,-.499992294503629014633,-53,53,
 -7006352135983028.,-6320868855797199.,-.471216124094699415249,-53,53,
 -7006352135983014.,-6320868855797189.,-.497392370402231408043,-53,53,
 -7006352135982096.,-6320868855796535.,-.499520521105642805661,-53,53,
 -7006352135981943.,-6320868855796426.,-.499875212883161362791,-53,53,
 -7006352135976289.,-6320868855792398.,-.499910684219115423114,-53,53,
 -7006352135962154.,-6320868855782328.,-.499999351662503538231,-53,53,
 -6828286958492436.,-6192785514806772.,-.499998774494554852054,-53,53,
 -6828286958448748.,-6192785514775049.,.499978681245168085331,-53,53,
 -6828286958433006.,-6192785514763617.,-.461574910858342634174,-53,53,
 -6828286958432984.,-6192785514763601.,-.486295669263749309140,-53,53,
 -6828286958432973.,-6192785514763593.,-.498656048466438792369,-53,53,
 -6828286958432648.,-6192785514763358.,.499787293276448747138,-53,53,
 -6828286958432082.,-6192785514762946.,-.499846763853613616849,-53,53,
 -6828286958426904.,-6192785514759187.,.499967463748915666781,-53,53,
 -6595469068453604.,-6021675207910344.,.499959047936277295473,-53,53,
 -6595469068453405.,-6021675207910196.,.491475843050525314827,-53,53,
 -6595469068453366.,-6021675207910167.,.494838431038084219155,-53,53,
 -6595469068453288.,-6021675207910108.,-.498436392986459293200,-53,53,
 -6595469068434273.,-6021675207895967.,-.499984826009113774815,-53,53,
 -6595469068421188.,-6021675207886236.,-.499998549369526037637,-53,53,
 -5292230209358232.,-4992944525072436.,.499999481635783697188,-53,53,
 -5292230209355334.,-4992944525070023.,-.499893485408907668274,-53,53,
 -5292230209321524.,-4992944525041883.,-.498644729406671084529,-53,53,
 -5292230209316533.,-4992944525037729.,-.498460383275853242916,-53,53,
 -5292230209316521.,-4992944525037720.,.489117699706072252043,-53,53,
 -5292230209316509.,-4992944525037710.,.476695782688006609165,-53,53,
 -4510984822842145.,-8649522041055297.,.499997213742297123022,-53,54,
 -4510984822809884.,-8649522040998699.,.499990902936971901598,-53,54,
 -4510984822796066.,-8649522040974456.,-.499949771801003272215,-53,54,
 -4510984822793725.,-8649522040970350.,.499770803412660980321,-53,54,
 -4510984822793611.,-8649522040970150.,.498902860486254760781,-53,54,
 -4510984822793517.,-8649522040969985.,.410467890004119957023,-53,54,
 -4510984822793497.,-8649522040969950.,.498034917561234091462,-53,54,
 -4510984822791441.,-8649522040966343.,.499925350660094160222,-53,54,
 -8644717199335558.,-8316727887441656.,-.499996832825479521771,-54,54,
 -8644717199268023.,-8316727887381749.,-.499963765314177643427,-54,54,
 -8644717199267660.,-8316727887381428.,.499607005765053084990,-54,54,
 -8644717199267616.,-8316727887381388.,-.470141991679659172714,-54,54,
 -8644717199267607.,-8316727887381380.,-.486681559338798749537,-54,54,
 -8644717199267598.,-8316727887381373.,.496778873002063749500,-54,54,
 -8644717199256354.,-8316727887371398.,-.499987654192388166384,-54,54,
 -7492339963682932.,-7278196578327819.,-.477091118135622734778,-54,54,
 -7492339963682920.,-7278196578327809.,.499905023288848217810,-54,54,
 -7492339963678486.,-7278196578323753.,.499979279851929900305,-54,54,
 -7492339963677008.,-7278196578322400.,-.499995967862390412146,-54,54,
 -7298995560608219.,-7100919050987427.,-.499994123597666439878,-54,54,
 -7298995560597338.,-7100919050977428.,.499983171831126739590,-54,54,
 -7298995560586568.,-7100919050967530.,.487278043582559372036,-54,54,
 -7298995560586556.,-7100919050967518.,-.484323856280368884332,-54,54,
 -7298995560586494.,-7100919050967462.,.495732994427885320356,-54,54,
 -7298995560586457.,-7100919050967428.,.499960469850593227963,-54,54,
 -4924871031076076.,-4863752809009387.,.499987547927853871713,-54,54,
 -4924871031066975.,-4863752809000623.,-.489125572617140940294,-54,54,
 -4924871031066921.,-4863752809000571.,-.494554878020471691327,-54,54,
 -4924871031066867.,-4863752809000519.,-.499984183423758738532,-54,54,
 -4924871031040344.,-4863752808974982.,.499988651277477875482,-54,54,
 -4514338150834310.,-8934474822275393.,.494879526103372287052,-54,55,
 -4514338150834294.,-8934474822275362.,.495352170604725579023,-54,55,
 -4514338150834150.,-8934474822275083.,.499605971117222369366,-54,55,
 -4514338150834134.,-8934474822275051.,-.499921384381353858084,-54,55,
 -4514338150832021.,-8934474822270958.,.499997230149849336978,-54,55,
 -6979532375146596.,-6935959796480662.,.499999987383497452755,-55,55,
 -6979532375142586.,-6935959796476727.,.491772176343512067159,-55,55,
 -6979532375142585.,-6935959796476726.,.473066882625058946330,-55,55,
 -6979532375142533.,-6935959796476674.,-.499608390734495973722,-55,55,
 -6979532375141143.,-6935959796475310.,-.499966659378782135058,-55,55,
 -5360050515998697.,-5340300145254397.,-.499987017892626368724,-55,55,
 -5360050515985027.,-5340300145240878.,-.499517649909795716333,-55,55,
 -5360050515984665.,-5340300145240520.,-.498188468391681664079,-55,55,
 -5360050515984574.,-5340300145240431.,.496620800995553349550,-55,55,
 -5360050515984564.,-5340300145240421.,.386160281147998835220,-55,55,
 -5360050515983669.,-5340300145239536.,.499943754793535928378,-55,55,
 -5360050515967102.,-5340300145223151.,-.499999476024108801728,-55,55,
 -5003579018638415.,-4987510616361550.,-.499997804217384712225,-55,55,
 -5003579018617746.,-4987510616341081.,.499879441918079049952,-55,55,
 -5003579018617038.,-4987510616340379.,-.316709987136791542247,-55,55,
 -5003579018617019.,-4987510616340360.,-.499641059385412662963,-55,55,
 -5003579018615461.,-4987510616338817.,-.499988983767624437070,-55,55,
 -4503599627370496.,-4503599627370496.,0.000000000000000000000,-1074,1074,
 0.,0.,0.000000000000000000000,0,0,
 4503599627370496.,4503599627370496.,0.000000000000000000000,-1074,1074,
 4789513629070445.,4789513629070445.,.000000000000000000000,-1073,1073,
 4808649095124370.,4808649095124370.,.000000000000000000000,-1073,1073,
 4869155331943481.,4869155331943481.,.000000000000000000000,-1073,1073,
 5109627874242034.,5109627874242034.,.000000000000000000000,-1073,1073,
 5599035507166465.,5599035507166465.,.000000000000000000000,-1073,1073,
 7089807759713476.,7089807759713476.,.000000000000000000000,-1073,1073,
 7312899440849907.,7312899440849907.,.000000000000000000000,-1073,1073,
 7758212862373409.,7758212862373409.,.000000000000000000000,-1073,1073,
 7761896134481174.,7761896134481174.,.000000000000000000000,-1073,1073,
 7809167192039829.,7809167192039829.,.000000000000000000000,-1073,1073,
 8147981785960724.,8147981785960724.,.000000000000000000000,-1073,1073,
 8591267199417325.,8591267199417325.,.000000000000000000000,-1073,1073,
 4662142971001321.,4662142971001321.,-.000000000000000000000,-1072,1072,
 5622124846588744.,5622124846588744.,0.000000000000000000000,-1072,1072,
 5828119186624356.,5828119186624356.,-.000000000000000000000,-1072,1072,
 6028194942529344.,6028194942529344.,-.000000000000000000000,-1072,1072,
 6103477745868087.,6103477745868087.,.000000000000000000000,-1072,1072,
 6329313323327537.,6329313323327537.,-.000000000000000000000,-1072,1072,
 6394464867675505.,6394464867675505.,0.000000000000000000000,-1072,1072,
 6432992472198426.,6432992472198426.,.000000000000000000000,-1072,1072,
 6588689718419168.,6588689718419168.,.000000000000000000000,-1072,1072,
 7001573392314120.,7001573392314120.,-.000000000000000000000,-1072,1072,
 7563218214160189.,7563218214160189.,-.000000000000000000000,-1072,1072,
 8051935603675861.,8051935603675861.,-.000000000000000000000,-1072,1072,
 8383198532805953.,8383198532805953.,.000000000000000000000,-1072,1072,
 8438077864727187.,8438077864727187.,-.000000000000000000000,-1072,1072,
 8443454242934633.,8443454242934633.,0.000000000000000000000,-1072,1072,
 8447626959944861.,8447626959944861.,-.000000000000000000000,-1072,1072,
 8862962614828875.,8862962614828875.,0.000000000000000000000,-1072,1072,
 4509952695599631.,4509952695599631.,0.000000000000000000000,-1071,1071,
 4701762730015372.,4701762730015372.,.000000000000000000000,-1071,1071,
 4883252779508383.,4883252779508383.,0.000000000000000000000,-1071,1071,
 4988752457694256.,4988752457694256.,.000000000000000000000,-1071,1071,
 5120758840307769.,5120758840307769.,-.000000000000000000000,-1071,1071,
 6175493946614273.,6167937026292498.,-.499999067951243516795,-56,56,
 6175493946645879.,6167937026323988.,-.499892592376961776181,-56,56,
 6175493946646315.,6167937026324422.,-.100093616768275752673,-56,56,
 6175493946646415.,6167937026324522.,-.467112200344297032582,-56,56,
 6175493946646424.,6167937026324530.,.499856127133860469561,-56,56,
 6175493946649966.,6167937026328060.,-.499942103136513075772,-56,56,
 6175493946654053.,6167937026332132.,-.499991613915906569388,-56,56,
 6823990675709392.,6813795146809843.,.499748043248782396478,-56,56,
 6823990675709394.,6813795146809845.,.490786295160713891913,-56,56,
 6823990675709432.,6813795146809883.,.320513081487411307830,-56,56,
 6823990675710731.,6813795146811176.,.499857698285743931650,-56,56,
 6823990675712070.,6813795146812509.,.499967353320352635938,-56,56,
 6823990675721220.,6813795146821618.,.499969850319866248778,-56,56,
 6823990675812720.,6813795146912708.,.499994814272255037251,-56,56,
 8359220028884124.,8340483278553595.,-.499993321859920667023,-56,56,
 8359220028897663.,8340483278567042.,.499987179515833959409,-56,56,
 8359220028905102.,8340483278574432.,-.499949673424760108166,-56,56,
 8359220028906441.,8340483278575762.,-.499803880463028768588,-56,56,
 8359220028906590.,8340483278575909.,.498718690971668418706,-56,56,
 8359220028906722.,8340483278576041.,-.388496212186884669242,-56,56,
 8359220028906738.,8340483278576057.,-.496037412569741490874,-56,56,
 8359220028906739.,8340483278576057.,.497241262406329944120,-56,56,
 8513798801089932.,8494003767665470.,-.499981069172221956340,-56,56,
 8513798801093231.,8494003767668745.,.499677621686796846142,-56,56,
 8513798801093472.,8494003767668985.,-.180553434847085717025,-56,56,
 8513798801093516.,8494003767669029.,-.487317611143738433693,-56,56,
 8513798801093518.,8494003767669030.,.498738562660959094844,-56,56,
 8513798801094235.,8494003767669742.,.499876871644601407052,-56,56,
 8513798801104849.,8494003767680282.,.499991253069771531189,-56,56,
 8513798801139990.,8494003767715178.,.499993086846188599808,-56,56,
 4515410989972602.,9007199254723903.,.000013631360214449974,-55,56,
 4515410989976172.,9007199254730987.,-.000850993029360901694,-55,56,
 4515410989981017.,9007199254740601.,-.002024411985236287351,-55,56,
 4515410989981214.,4503599627370496.,-.046134101095920915704,-55,55,
 4515410989981215.,4503599627370497.,-.053977359446699445840,-55,55,
 4515410989981236.,4503599627370518.,-.218685784813049380123,-55,55,
 4515410989981271.,4503599627370553.,-.493199827090302670653,-55,55,
 4515410989981272.,4503599627370553.,.498956914558918601453,-55,55,
 7082784227656672.,7037251671944098.,-.499999183600064468351,-55,55,
 7082784227659216.,7037251671946592.,.499953154216911612401,-55,55,
 7082784227659839.,7037251671947204.,-.499665436016433429356,-55,55,
 7082784227659943.,7037251671947305.,.497187961440395517273,-55,55,
 7082784227659948.,7037251671947310.,.400882836318126200864,-55,55,
 4551882811606989.,4503599627370496.,-.114840883649549053627,-54,54,
 4551882811606990.,4503599627370497.,-.146595047097694837625,-54,54,
 4551882811607000.,4503599627370507.,-.464136681579153440884,-54,54,
 4551882811607001.,4503599627370508.,-.495890845027299377538,-54,54,
 4551882811607190.,4503599627370691.,-.497427736727130580774,-54,54,
 4551882811607505.,4503599627370996.,-.499989222894617538298,-54,54,
 4551882811611410.,4503599627374777.,-.499997488037651785881,-54,54,
 5299073463177461.,5222983057736055.,.498886881027664175727,-54,54,
 5299073463177624.,5222983057736211.,.497499342704822375411,-54,54,
 5299073463177647.,5222983057736234.,-.490426506261011814085,-54,54,
 5299073463177648.,5222983057736234.,.466620195957864767150,-54,54,
 5299073463178043.,5222983057736613.,-.499932427587144400499,-54,54,
 5299073463183095.,5222983057741448.,-.499992818060202327354,-54,54,
 5299073463216969.,5222983057773866.,.499998131961369860507,-54,54,
 5354986034440022.,5276468756249209.,-.499999044014156103768,-54,54,
 5354986034456712.,5276468756265167.,-.486586295166978421083,-54,54,
 5354986034456735.,5276468756265189.,-.495315564599493213917,-54,54,
 5354986034456758.,5276468756265210.,.495955165967983392040,-54,54,
 5354986034458468.,5276468756266845.,.499126873351934945124,-54,54,
 5354986034458924.,5276468756267281.,.499972661979625699611,-54,54,
 6318840445917290.,6190060189901315.,-.499999512892226335106,-54,54,
 6318840445924434.,6190060189908023.,.499987248917136001931,-54,54,
 6318840445926142.,6190060189909627.,.499424173348862110527,-54,54,
 6318840445926224.,6190060189909705.,-.493577098430405724337,-54,54,
 6318840445926240.,6190060189909720.,-.467821249021497329526,-54,54,
 6318840445926257.,6190060189909735.,.497044340975462489538,-54,54,
 7852441928000621.,7606123709016936.,-.499990910280040077776,-54,54,
 7852441928001915.,7606123709018108.,.499636856990325822143,-54,54,
 7852441928002193.,7606123709018361.,-.495806327480667539168,-54,54,
 7852441928002204.,7606123709018370.,.475596999752457339033,-54,54,
 7852441928002300.,7606123709018457.,.498753310150517715760,-54,54,
 7852441928043633.,7606123709055926.,-.499999025718848555392,-54,54,
 8717776617210548.,8381466754453032.,-.499993539374519683516,-54,54,
 8717776617240079.,8381466754479171.,.499867942514535255871,-54,54,
 8717776617241185.,8381466754480150.,.499557989788494364559,-54,54,
 8717776617241211.,8381466754480174.,-.485982750511051229531,-54,54,
 8717776617246027.,8381466754484437.,-.499990646297247408193,-54,54,
 4716158501326072.,9007199254695575.,-.000002654216819555679,-53,54,
 4716158501347800.,9007199254733209.,-.000055760604160935966,-53,54,
 4716158501350711.,9007199254738251.,-.000154926620515093651,-53,54,
 4716158501352062.,9007199254740591.,.000486099068752993849,-53,54,
 4716158501352271.,9007199254740953.,-.000895119032945395364,-53,54,
 4716158501352286.,9007199254740979.,-.020133005499760983828,-53,54,
 4716158501352293.,9007199254740991.,.104222647482383192838,-53,54,
 4716158501352294.,4503599627370496.,.418136727525630244136,-53,53,
 4716158501366617.,4503599627382900.,.499995126345973997280,-53,53,
 6059040276400288.,5612305914300059.,-.499992090484602280462,-53,53,
 6059040276406439.,5612305914304870.,-.499951379573784375501,-53,53,
 6059040276408142.,5612305914306202.,-.499777533396664803784,-53,53,
 6059040276408523.,5612305914306499.,.499086961815732357961,-53,53,
 6059040276408601.,5612305914306561.,-.493271487984542781251,-53,53,
 6059040276408624.,5612305914306578.,.496161276817859841421,-53,53,
 6059040276423189.,5612305914317970.,.499996893251050569100,-53,53,
 6179968525049261.,5706381209621443.,.499998312101238506751,-53,53,
 6179968525077420.,5706381209643231.,-.499953762943618508092,-53,53,
 6179968525077557.,5706381209643336.,.498803528220126304305,-53,53,
 6179968525077663.,5706381209643419.,-.487559443581093793237,-53,53,
 6179968525077672.,5706381209643425.,.475862568247068101188,-53,53,
 6179968525077694.,5706381209643442.,.497560819382550969454,-53,53,
 6179968525079033.,5706381209644479.,-.499986532026468045913,-53,53,
 6230674196595456.,5745522248169652.,.499960572474548751572,-53,53,
 6230674196597144.,5745522248170952.,.487591535456410254729,-53,53,
 6230674196597157.,5745522248170962.,.499344617516506509261,-53,53,
 6230674196598349.,5745522248171881.,-.499911242870143885690,-53,53,
 6230674196611622.,5745522248182102.,.499985533123381035197,-53,53,
 6230674196619705.,5745522248188327.,.499998006507367039503,-53,53,
 7511273082104712.,6670465360114516.,.499877093640175246900,-53,53,
 7511273082104883.,6670465360114631.,.408244419709601485687,-53,53,
 7511273082104901.,6670465360114644.,-.496137967020072450377,-53,53,
 7511273082109230.,6670465360117552.,.499898023719732812068,-53,53,
 7511273082130314.,6670465360131720.,.499995675233507257562,-53,53,
 7511273082131067.,6670465360132226.,.499999162111589540034,-53,53,
 7913137471600263.,6933782166632562.,-.499999964275395803283,-53,53,
 7913137471604960.,6933782166635560.,-.499820316118815270902,-53,53,
 7913137471605007.,6933782166635589.,.499329874091660803160,-53,53,
 7913137471605029.,6933782166635604.,-.458514717724776966630,-53,53,
 7913137471606146.,6933782166636317.,-.499987856822825551848,-53,53,
 8575032706797082.,7337163377200022.,-.498809031934412171223,-53,53,
 8575032706797170.,7337163377200073.,-.455385260047651846611,-53,53,
 8575032706797182.,7337163377200080.,-.494918382063147883040,-53,53,
 8575032706797563.,7337163377200300.,.499904993938082219667,-53,53,
 8575032706800649.,7337163377202090.,.499970448414374118348,-53,53,
 8575032706802192.,7337163377202986.,-.499996824670457054436,-53,53,
 8668443273566846.,7390949614701891.,.499996050709032043072,-53,53,
 8668443273592922.,7390949614716795.,.499765219549314360204,-53,53,
 8668443273592950.,7390949614716812.,-.496553482097434607970,-53,53,
 8668443273592985.,7390949614716832.,-.491951859155971256475,-53,53,
 8668443273594012.,7390949614717419.,-.499784237466141380609,-53,53,
 8668443273604877.,7390949614723629.,-.499880436477139606720,-53,53,
 8668443273617915.,7390949614731081.,-.499995889485948603343,-53,53,
 9007199254740991.,7579296827247853.,.475702091928739384102,-53,53,
 4503599627370497.,7579296827247855.,.096609009533158396171,-52,53,
 4503599627370502.,7579296827247860.,.499632068214549030637,-52,53,
 4503599627372090.,7579296827249576.,.499755504951558026099,-52,53,
 4503599627375266.,7579296827253009.,-.499997624401461796309,-52,53,
 7074237752025378.,4503599627370496.,-.000000001041115290277,-52,52,
 7074237752028409.,4503599627370496.,-.000000000000108599078,-52,52,
 7074237752028440.,4503599627370496.,-.000000000000000008443,-52,52,
 7074237752028441.,4503599627370496.,-.000000000000000058233,-52,52,
 9007199254726846.,8190223105253956.,-.499989547748931710791,-52,53,
 9007199254731014.,8190223105250486.,.499981015573400766164,-52,53,
 9007199254739350.,8190223105243548.,.499922121172875354416,-52,53,
 9007199254740632.,8190223105242481.,.499433214817996139387,-52,53,
 9007199254740954.,8190223105242214.,-.499129521515825802680,-52,53,
 9007199254740960.,8190223105242209.,-.492891560081449646724,-52,53,
 9007199254740990.,8190223105242184.,-.461701752909786923899,-52,53,
 9007199254740991.,8190223105242183.,-.293995426004071092180,-52,53,
 4503599627370497.,8190223105242180.,.209123554713073980121,-51,53,
 4503599627398210.,8190223105196049.,.499998010581159252123,-51,53,
 7074237752023327.,5622106160680017.,.437919826571286137851,-51,91,
 7074237752028389.,7216422512371896.,.053738419562667649482,-51,98,
 7074237752028439.,5745539027375874.,-.280370573974678975280,-51,103,
 7074237752028440.,4967757600021511.,-.121482295898714684057,-51,105,
 7074237752028441.,-6523320454730237.,.439258852050642776645,-51,104,
 5868404969532796.,-7905417279733033.,.492220531012408382921,-50,53,
 5868404969532802.,-7905417279733010.,.496291553949242031832,-50,53,
 5868404969532808.,-7905417279732986.,-.499637423113699813370,-50,53,
 5868404969533790.,-7905417279729222.,.499986667276751569123,-50,53,
 5868404969563021.,-7905417279617149.,-.499998576677265831494,-50,53,
 5888592265913846.,-7826752402509450.,-.499940151275240182854,-50,53,
 5888592265915295.,-7826752402503713.,-.499815531399605783997,-50,53,
 5888592265916351.,-7826752402499532.,-.497654309576559749417,-50,53,
 5888592265916400.,-7826752402499338.,-.492819176957391865321,-50,53,
 5888592265916523.,-7826752402498852.,.498909829478483303589,-50,53,
 5888592265916744.,-7826752402497976.,-.499690898560575029636,-50,53,
 5888592265937423.,-7826752402416102.,-.499981216464609389611,-50,53,
 5888592265945282.,-7826752402384986.,-.499994142173612461207,-50,53,
 5943141639396850.,-7601676205109238.,-.499893626943081000086,-50,53,
 5943141639401450.,-7601676205089498.,-.499870197228951777147,-50,53,
 5943141639532090.,-7601676204528882.,-.499151819546339765033,-50,53,
 5943141639583610.,-7601676204307794.,-.498840376670392537314,-50,53,
 5943141639584300.,-7601676204304833.,-.498836097545815242002,-50,53,
 5943141639584307.,-7601676204304803.,-.459705619337168926494,-50,53,
 6303973650769013.,-5692554797346166.,-.499999662710007091071,-50,53,
 6303973650790851.,-5692554797210777.,.499981461210906541811,-50,53,
 6303973650801380.,-5692554797145499.,-.400017716190711180780,-50,53,
 6303973650801405.,-5692554797145344.,-.406428578874477712295,-50,53,
 6303973650801720.,-5692554797143391.,-.487205448449462562407,-50,53,
 6303973650801770.,-5692554797143082.,.499972826262151797586,-50,53,
 6421931254427748.,-4931372232082266.,-.499987628729420483311,-50,53,
 6421931254447243.,-4931372231951758.,.499985874816579163918,-50,53,
 6421931254448585.,-4931372231942774.,.499881514832406803639,-50,53,
 6421931254449711.,-4931372231935236.,.490852079595273694023,-50,53,
 6421931254449724.,-4931372231935148.,-.480832984903530012676,-50,53,
 6421931254449747.,-4931372231934995.,.492339593292504727589,-50,53,
 6421931254449927.,-4931372231933790.,.499777161854284737290,-50,53,
 6619016067705734.,-7086718655199506.,-.499997865983038989555,-50,54,
 6619016067722837.,-7086718654947922.,-.499009383037874049590,-50,54,
 6619016067723054.,-7086718654944730.,-.443334081600853272709,-50,54,
 6619016067723068.,-7086718654944525.,.495741744307349091927,-50,54,
 6619016067723461.,-7086718654938744.,.499798857748984756989,-50,54,
 6619016067724216.,-7086718654927638.,.499959472508696247377,-50,54,
 6787616684047236.,-4536564471785779.,-.499997595257032970650,-50,54,
 6787616684084059.,-4536564471215599.,-.495720138590037201162,-50,54,
 6787616684084088.,-4536564471215150.,-.449740068615834755366,-50,54,
 6787616684084092.,-4536564471215089.,.487636492760153501535,-50,54,
 6787616684084187.,-4536564471213617.,-.499670174543296474009,-50,54,
 6787616684085209.,-4536564471197792.,-.499958740754567139117,-50,54,
 6787616684092299.,-4536564471088009.,.499996416524817898678,-50,54,
 6792176747025452.,-8931835744354410.,.499989740419401007360,-50,55,
 6792176747028249.,-8931835744267700.,.499920502652228237112,-50,55,
 6792176747028830.,-8931835744249688.,.123073806977045155424,-50,55,
 6792176747029016.,-8931835744243922.,.322568669105142440685,-50,55,
 6792176747029178.,-8931835744238900.,.496322258899193984066,-50,55,
 6792176747029181.,-8931835744238807.,.499539917971198076900,-50,55,
 6935652144170605.,-8847099188080298.,.499797165179434916065,-50,56,
 6935652144171270.,-8847099188038060.,.496793445521866944726,-50,56,
 6935652144171460.,-8847099188025992.,.495935240472298841916,-50,56,
 6935652144171462.,-8847099188025864.,-.472494845895303987129,-50,56,
 6935652144172854.,-8847099187937450.,-.499834950975552923672,-50,56,
 6935652144177542.,-8847099187639688.,-.499957274368803098073,-50,56,
 6935652144179886.,-8847099187490808.,.499981621453105179212,-50,56,
 6935652144228825.,-8847099184382409.,.499994484567286342654,-50,56,
 7074237752007987.,-5622153632690964.,-.359479648623543693521,-50,88,
 7074237752028235.,-7222498929773102.,-.013434604850808816997,-50,95,
 7074237752028438.,-5124569327373185.,.140185286987342823443,-50,101,
 7074237752028440.,-4967757600021511.,.121482295898714721309,-50,104,
 7074237752028441.,6523320454730237.,-.439258852050643114039,-50,103,
 7272069881162685.,6298102991156363.,.499080184494525663552,-50,55,
 7272069881162744.,6298102991158222.,.428853389145144958080,-50,55,
 7272069881162754.,6298102991158538.,-.498303694814091268283,-50,55,
 7272069881163097.,6298102991169345.,-.499791674916673878680,-50,55,
 7272069881163852.,6298102991193132.,.499848483439577371619,-50,55,
 7272069881169206.,6298102991361822.,.499945631114899160899,-50,55,
 7272069881171883.,6298102991446167.,.499994151545558823903,-50,55,
 7274706301332278.,6381152088344754.,.499775270030966279430,-50,55,
 7274706301332448.,6381152088350108.,.496660691543178402004,-50,55,
 7274706301332450.,6381152088350171.,.484859343560103312135,-50,55,
 7274706301333549.,6381152088384784.,-.499981376185130108794,-50,55,
 7274706301345751.,6381152088769074.,.499994136767206642675,-50,55,
 7641538687419749.,8697591601478064.,-.499998752335907685830,-50,54,
 7641538687451807.,8697591601927247.,-.499992735287590017407,-50,54,
 7641538687453706.,8697591601953854.,.476705883918684904076,-50,54,
 7641538687453708.,8697591601953882.,.499851432741035436388,-50,54,
 7642555474090221.,8711834833233132.,.499984866895210017569,-50,54,
 7642555474142065.,8711834833959186.,.499986864166218432863,-50,54,
 7642555474143372.,8711834833977491.,-.499974746919883907649,-50,54,
 7642555474148600.,8711834834050707.,-.499821308662440209074,-50,54,
 7642555474148782.,8711834834053255.,.335685177197282008586,-50,54,
 7642555474148816.,8711834834053731.,.491768806398587973821,-50,54,
 7642555474148818.,8711834834053760.,-.499049803648641435557,-50,54,
 7661357941793655.,8973928672413302.,.499949668543048829575,-50,54,
 7661357941794129.,8973928672419879.,-.496447165522681127655,-50,54,
 7661357941794445.,8973928672424263.,-.494045055783457866794,-50,54,
 7661357941794453.,8973928672424373.,.493357529264056710465,-50,54,
 7661357941796989.,8973928672459556.,.499976966490210665386,-50,54,
 7661357941800323.,8973928672505811.,-.499995814251665851145,-50,54,
 7952142228788689.,6332885946315814.,-.499997738894701410755,-50,53,
 7952142228792455.,6332885946337238.,-.499925351608991001520,-50,53,
 7952142228792696.,6332885946338608.,.499548210858245298521,-50,53,
 7952142228792937.,6332885946339979.,.499021773035322505369,-50,53,
 7952142228792982.,6332885946340235.,.494774097891010743236,-50,53,
 7952142228792998.,6332885946340327.,-.484513964384960261621,-50,53,
 7975281835689739.,6463175724981405.,-.499994950935294709874,-50,53,
 7975281835699968.,6463175725038400.,.499973713573631907708,-50,53,
 7975281835705454.,6463175725068968.,.498392507725017444253,-50,53,
 7975281835705468.,6463175725069047.,-.493591112026850900558,-50,53,
 7975281835705475.,6463175725069086.,-.489582921903159816142,-50,53,
 7975281835706204.,6463175725073147.,.499270019610585810297,-50,53,
 7975281835706704.,6463175725075933.,.499855025941002225238,-50,53,
 7975281835723919.,6463175725171855.,.499996016461349682237,-50,53,
 8134778399524060.,7284178321557554.,-.498476895292401164733,-50,53,
 8134778399524067.,7284178321557586.,.441435385242444914949,-50,53,
 8134778399524393.,7284178321559121.,-.499792693018050125605,-50,53,
 8134778399528953.,7284178321580579.,-.499792870122803932802,-50,53,
 8134778399991793.,7284178323758565.,.499567611574241207790,-50,53,
 8395085770619731.,8304408067720316.,.499974100617459173593,-50,53,
 8395085770623139.,8304408067730874.,.499849561262352463508,-50,53,
 8395085770624190.,8304408067734131.,-.497254588730703147046,-50,53,
 8395085770624241.,8304408067734289.,-.499017016745093950716,-50,53,
 8395085770624843.,8304408067736153.,.499787263052316894937,-50,53,
 8395085770635618.,8304408067769534.,.499979743272606824196,-50,53,
 8395085770683279.,8304408067917188.,.499986750496020102476,-50,53,
 8472742745241456.,8525053540527131.,.499991846512155159947,-50,53,
 8472742745247233.,8525053540542049.,.499953826610962223149,-50,53,
 8472742745247640.,8525053540543100.,.499778039352638510886,-50,53,
 8472742745247901.,8525053540543774.,.482466293128984567667,-50,53,
 8472742745247920.,8525053540543824.,-.453659849334304244482,-50,53,
 8472742745247968.,8525053540543947.,.497179369694994299114,-50,53,
 8472742745248047.,8525053540544151.,.499602250980311781006,-50,53,
 8472742745292635.,8525053540659291.,.499993411694784706460,-50,53,
 8714420965774119.,8948712322874838.,-.499998884140770938848,-50,53,
 8714420965792848.,8948712322891884.,.499768873343361115357,-50,53,
 8714420965793260.,8948712322892259.,.499176412174042336694,-50,53,
 8714420965793360.,8948712322892351.,-.481549913533209153620,-50,53,
 8714420965793371.,8948712322892361.,-.469429809365316513674,-50,53,
 8714420965793427.,8948712322892412.,-.498636551796560846139,-50,53,
 8714420965794251.,8948712322893162.,-.499821478701429096606,-50,53,
 8714420965796066.,8948712322894813.,.499995686027846610166,-50,53,
 8743627225396470.,8972282029192496.,-.499689675983590365841,-50,53,
 8743627225396497.,8972282029192515.,-.498866162974343137348,-50,53,
 8743627225396848.,8972282029192762.,-.488160494323668815658,-50,53,
 8743627225396892.,8972282029192792.,.476144489719182419842,-50,53,
 8743627225396902.,8972282029192800.,-.486513468454807873099,-50,53,
 8743627225397675.,8972282029193344.,-.499973637446233566539,-50,53,
 8743627225401317.,8972282029195906.,.499997928590394201598,-50,53,
 8897696383646605.,8996493776079214.,-.499851663604137145277,-50,53,
 8897696383647995.,8996493776078672.,-.499321686626042079514,-50,53,
 8897696383649921.,8996493776077920.,.499973783991547446575,-50,53,
 8897696383661259.,8996493776073499.,.499979504685551484367,-50,53,
 8897696383695273.,8996493776060236.,.499991192854784239773,-50,53,
 8979216647905793.,8941163147859879.,-.499999844558201124916,-50,53,
 8979216647925187.,8941163147841125.,.499984897954134123087,-50,53,
 8979216647926004.,8941163147840336.,-.496973625029862008780,-50,53,
 8979216647926034.,8941163147840306.,.494570125566547555918,-50,53,
 8979216647926125.,8941163147840219.,-.497747164329842228470,-50,53,
 8979216647926488.,8941163147839867.,.499932217150609929105,-50,53,
 4523144813455067.,8860484359923904.,.499994688918557629673,-49,53,
 4523144813456221.,8860484359920586.,-.499998145988077256999,-49,53,
 4523144813464299.,8860484359897353.,-.499949032862063536373,-49,53,
 4523144813466607.,8860484359890715.,-.499935335638483853420,-49,53,
 4523144813466954.,8860484359889716.,.499200159687281869610,-49,53,
 4523144813467067.,8860484359889392.,-.498199521235874841518,-49,53,
 4612325947553258.,8494113961762945.,.499996908975443983895,-49,53,
 4612325947564114.,8494113961705158.,.499972816894571976549,-49,53,
 4612325947564665.,8494113961702226.,-.499015225584006380608,-49,53,
 4612325947564795.,8494113961701534.,-.495146706847043378343,-49,53,
 4612325947564820.,8494113961701400.,.428674162088903895269,-49,53,
 4612325947564826.,8494113961701368.,.490391170631038590048,-49,53,
 4612325947565151.,8494113961699639.,-.499937534778315546115,-49,53,
 4802115455492662.,7024722001562261.,.499988415850531659792,-49,53,
 4802115455517437.,7024722001314154.,-.499867705508902486547,-49,53,
 4802115455518129.,7024722001307224.,-.499298796326153221565,-49,53,
 4802115455518475.,7024722001303759.,-.499014345715236385365,-49,53,
 4802115455518542.,7024722001303088.,-.467167357030784363889,-49,53,
 4802115455518544.,7024722001303068.,-.496067446922330183338,-49,53,
 4802115455520828.,7024722001280195.,-.499970160934779790348,-49,53,
 4802115455531347.,7024722001174853.,-.499994704636042189412,-49,53,
 5059472696394537.,7629809413056530.,.499867273686662177248,-49,54,
 5059472696394705.,7629809413051661.,-.498294908191864463686,-49,54,
 5059472696394955.,7629809413044413.,.480630415135719970965,-49,54,
 5059472696394957.,7629809413044356.,-.495538182283726362785,-49,54,
 5059472696395628.,7629809413024904.,.499897378056000434343,-49,54,
 5059472696398901.,7629809412930026.,.499987519224829257364,-49,54,
 5059472696432638.,7629809411952055.,.499985043884926743002,-49,54,
 5079689563117984.,7038967591717587.,.499996052218113004271,-49,54,
 5079689563118416.,7038967591704862.,.499969542210204143164,-49,54,
 5079689563128352.,7038967591412187.,.499358667975769231129,-49,54,
 5079689563132229.,7038967591297987.,-.484676584509126418288,-49,54,
 5079689563132240.,7038967591297662.,.499119033334887178339,-49,54,
 5107897798820630.,6199578063912964.,.499959609591848065640,-49,54,
 5107897798875374.,6199578062268163.,.499979346633581159916,-49,54,
 5107897798880780.,6199578062105738.,.499868514060393820656,-49,54,
 5107897798881111.,6199578062095793.,.498936811139054419082,-49,54,
 5107897798881133.,6199578062095133.,-.498103966774578559323,-49,54,
 5107897798881795.,6199578062075243.,-.499967379331999013509,-49,54,
 5222449517569069.,5307259332638852.,.499997814072804293847,-49,55,
 5222449517587295.,5307259331485114.,-.499986772480007871000,-49,55,
 5222449517593643.,5307259331083274.,-.463331772065680424250,-49,55,
 5222449517593653.,5307259331082641.,-.481547501960986238673,-49,55,
 5222449517593663.,5307259331082008.,-.499763231857966728856,-49,55,
 5222449517594816.,5307259331009020.,.499963099791992557917,-49,55,
 5270585385650166.,8977972334548269.,.499983231304848825274,-49,57,
 5270585385680819.,8977972326716343.,.499963758482573360756,-49,57,
 5270585385682436.,8977972326303196.,-.457562556851685401596,-49,57,
 5270585385682450.,8977972326299619.,-.496155858606588581448,-49,57,
 5270585385682452.,8977972326299107.,.498330812570829121091,-49,57,
 5270585385682814.,8977972326206616.,-.499581706183026542408,-49,57,
 5270585385683721.,8977972325974875.,-.499876348203938038873,-49,57,
 5270585385687530.,8977972325001664.,.499988566637272296796,-49,57,
 5305678314021330.,7451636400032266.,.317776556151927824906,-49,104,
 5305678314021331.,-7144290154732925.,-.420555860962015638086,-49,102,
 5305678314021334.,-8541471979738975.,-.355138965240439868439,-49,100,
 5305678314021773.,-7789699923340335.,.255037977637273428780,-49,93,
 5305678314065639.,-6089754163653848.,-.365188728149908596756,-49,86,
 5489113122509524.,-5766590505972803.,-.499976845738517727153,-49,54,
 5489113122558586.,-5766590507460176.,.499838728546571021502,-49,54,
 5489113122559364.,-5766590507483761.,-.481493589234718853990,-49,54,
 5489113122559383.,-5766590507484337.,-.488749776806258401415,-49,54,
 5489113122559402.,-5766590507484913.,-.496005964371229138246,-49,54,
 5489113122559557.,-5766590507489613.,.497430400475700476436,-49,54,
 5489113122560101.,-5766590507506104.,-.499799386537413228184,-49,54,
 5489113122567268.,-5766590507723381.,.499932948024559935773,-49,54,
 5489113122573056.,-5766590507898851.,.499996522995190166771,-49,54,
 5503648895911618.,-6205288324971386.,-.499973738980018623286,-49,54,
 5503648895962147.,-6205288326489359.,.485689825768444636719,-49,54,
 5503648895962219.,-6205288326491522.,.490478552617422010395,-49,54,
 5503648895962363.,-6205288326495847.,-.499943993380108278789,-49,54,
 5503648895962988.,-6205288326514624.,.499958155433257052862,-49,54,
 5503648895973012.,-6205288326815761.,.499989824024073405078,-49,54,
 5548511370793943.,-7531909000925620.,-.498524734181729257128,-49,54,
 5548511370794001.,-7531909000927306.,-.486574568763232663608,-49,54,
 5548511370794016.,-7531909000927743.,.482033232651114828833,-49,54,
 5548511370794103.,-7531909000930272.,.499958480959782308538,-49,54,
 5548511370804647.,-7531909001236772.,-.499996300034844049055,-49,54,
 7074237751946628.,-5622096781216965.,-.089850199524424779073,-49,85,
 7074237752027622.,-7197629755056780.,.496641351311827911854,-49,92,
 7074237752028432.,-4658842052371168.,-.214953678252997362028,-49,98,
 7074237752028440.,-4967757600021511.,.121482295898714870318,-49,103,
 7074237752028441.,6523320454730237.,-.439258852050644463614,-49,102,
 8842797190002404.,4555598928011245.,-.275327658586077643888,-49,86,
 8842797190035219.,5829077737928285.,-.241603372279800849465,-49,93,
 8842797190035547.,7531611566059105.,.074768391265781521372,-49,100,
 8842797190035550.,6209697000026889.,-.401852869873393727593,-49,103,
 8842797190035551.,-5902350754727548.,.299073565063304663147,-49,102,
 5305678314021330.,-7451636400032266.,-.317776556151927322001,-48,103,
 5305678314021331.,7144290154732925.,.420555860962008546748,-48,101,
 5305678314021348.,5008333671416556.,-.080607629348272501979,-48,96,
 5305678314023102.,7792428794092300.,-.313759545668310313647,-48,90,
 5305678314198564.,6089706763479862.,.090896353359190238911,-48,83,
 6189958032313442.,6111250908646246.,-.449802454767560031340,-48,81,
 6189958033017771.,7822191026877127.,.258179019650541974984,-48,88,
 6189958033024814.,5013160476848593.,-.476489441494583545252,-48,94,
 6189958033024884.,5590296602375202.,-.495324252227861954253,-48,100,
 6189958033024885.,8693575800037644.,.037405982177248259838,-48,103,
 6189958033024886.,-6833805304731581.,.009351495544320606337,-48,101,
 7074237751701192.,-5622082568348465.,-.271200950923179606269,-48,82,
 7074237752025168.,-7195810507888803.,.124160499281507210719,-48,89,
 7074237752028407.,-4683147721975992.,-.053738419552382839132,-48,95,
 7074237752028440.,-4967757600021511.,.121482295898715466354,-48,102,
 7074237752028441.,6523320454730237.,-.439258852050649861914,-48,101,
 7958517470771212.,8960446310473519.,-.138230043465246743807,-48,83,
 7958517471029387.,5735734868167607.,.235319538568943385656,-48,89,
 7958517471031969.,7405673258539934.,.120911444006621323138,-48,96,
 7958517471031995.,5588727300024200.,-.261667582886055137131,-48,102,
 7958517471031996.,-6212835604728892.,-.130833791443020784676,-48,101,
 8842797189902967.,-4555529036101627.,-.181000287630395951828,-48,83,
 8842797190034224.,-5833325713030551.,-.189599135426896881270,-48,90,
 8842797190035537.,-7512402425727896.,-.268692097813642185791,-48,97,
 8842797190035550.,-6209697000026889.,.401852869873394891725,-48,102,
 8842797190035551.,5902350754727548.,-.299073565063308661913,-48,101,
 4863538453516224.,8618527817847321.,-.135593642405418129307,-47,80,
 4863538454509520.,5515529430533692.,-.005719729398922638716,-47,86,
 4863538454519453.,7015031191576063.,.268472581138259342165,-47,93,
 4863538454519552.,6211266302377890.,.364490460784791977980,-47,100,
 4863538454519553.,-5591865904726203.,-.271019078430361802978,-47,101,
 5305678314021330.,-7451636400032266.,-.317776556151925310381,-47,102,
 5305678314021331.,7144290154732925.,.420555860961980181399,-47,100,
 5305678314021401.,4981626859270331.,-.020151907546313475028,-47,93,
 5305678314028419.,7794210523408067.,-.078443169238682495950,-47,87,
 5305678314730268.,6089729273174733.,.497070764995780233326,-47,80,
 5747818173215646.,5282152198434968.,.029678169246222224809,-47,81,
 5747818173520033.,6761389711969284.,.336619188159492966303,-47,88,
 5747818173523077.,8648054024831531.,.087324931721656571241,-47,95,
 5747818173523107.,6521751152379235.,-.205602182708881605514,-47,100,
 5747818173523108.,-4970896204723514.,-.411204365417702485823,-47,101,
 6189958030179114.,-6111247206630105.,.027270142024565772512,-47,78,
 6189958032996427.,-7822541802532018.,.185508344975829410276,-47,85,
 6189958033024600.,-5018017932717172.,-.130877636204264942796,-47,91,
 6189958033024882.,-7298747928558097.,.247662126114567147423,-47,98,
 6189958033024885.,-8693575800037644.,-.037405982177245065461,-47,102,
 6189958033024886.,6833805304731581.,-.009351495544345431876,-47,100,
 6632097890420188.,4523620098869152.,-.394781996261123698126,-47,78,
 6632097892505598.,5790236735164387.,.086990841343358342309,-47,85,
 6632097892526452.,7415406560539019.,.137594939313521536976,-47,92,
 6632097892526661.,7919717628560786.,-.387847413101467332520,-47,99,
 6632097892526662.,6832236002380579.,.224305173797444419749,-47,100,
 6632097892526663.,-8699853009441651.,-.102779304810085740922,-47,102,
 7074237750719446.,-5622087605065932.,-.237057684164276992758,-47,79,
 7074237752015350.,-7196455207724585.,.281050460666808032482,-47,86,
 7074237752028309.,-4618855395199534.,-.013434604221042098557,-47,92,
 7074237752028439.,-5745539027375874.,.280370573974757354721,-47,99,
 7074237752028440.,-4967757600021511.,.121482295898717850495,-47,101,
 7074237752028441.,6523320454730237.,-.439258852050671455114,-47,100,
 7516377611074848.,7823193474107748.,.338346432660412223080,-47,81,
 7516377611525664.,5006948355430679.,-.472211052807333875441,-47,87,
 7516377611530172.,6444791989308228.,-.442902929327722852851,-47,94,
 7516377611530217.,7142720852381924.,-.345787469696229964857,-47,100,
 7516377611530218.,-7457913609436273.,-.383149878784765988291,-47,102,
 7958517469988862.,-8960446905669580.,.366279451512945860217,-47,80,
 7958517471021564.,-5734673449087726.,.191175345516176573307,-47,86,
 7958517471031891.,-7340180360492776.,.469772139667680334380,-47,93,
 7958517471031994.,-5900781452376546.,.065416895721598740370,-47,99,
 7958517471031995.,-5588727300024200.,.261667582886058531739,-47,101,
 7958517471031996.,6212835604728892.,.130833791443002130311,-47,100,
 8400657330533772.,7453205702383268.,.084119886810095222043,-47,100,
 8400657330533773.,-6215974209430896.,.336479547240554211743,-47,102,
 8400657330533817.,-6216730636890021.,-.436185626666522155004,-47,94,
 8400657330538200.,-4867727672642911.,-.292469397407354042386,-47,87,
 8400657330976454.,-7605204634249781.,-.476404135737427877345,-47,81,
 8842797189505217.,-4555528742993407.,.215488982227191020622,-47,80,
 8842797190030247.,-5831089171922790.,.202601590744756815128,-47,87,
 8842797190035497.,-7507600140645094.,-.067173024274345874707,-47,94,
 8842797190035549.,-6056023877377218.,-.149536782531559519992,-47,99,
 8842797190035550.,-6209697000026889.,.401852869873399548252,-47,101,
 8842797190035551.,5902350754727548.,-.299073565063324656974,-47,100,
 5426391276952917.,4925247681619198.,.494231855162409579292,-44,53,
 5426391276979477.,4925247693004797.,.499955051979762759576,-44,53,
 5426391276979769.,4925247693129971.,-.498990200890980739318,-44,53,
 5426391276979846.,4925247693162978.,.449917845381466080822,-44,53,
 5426391276979852.,4925247693165550.,.497884702167299361906,-44,53,
 5426391276980436.,4925247693415896.,.499989354267011247465,-44,53,
 5506672652921126.,-8188620198921929.,-.498286649998564224711,-44,53,
 5506672652932514.,-8188620196493254.,-.499300362549874968302,-44,53,
 5506672652932777.,-8188620196437165.,-.499897918051488508456,-44,53,
 5506672652934479.,-8188620196074186.,-.499918461986345175647,-44,53,
 5562950707701891.,7959710905218892.,.499967564823230441438,-44,53,
 5562950707703171.,7959710904912156.,-.482759247640939889669,-44,53,
 5562950707703182.,7959710904909519.,.496295261195173847465,-44,53,
 5562950707703276.,7959710904886993.,.499124573415829356887,-44,53,
 5562950707703323.,7959710904875731.,-.499460855694455345789,-44,53,
 5562950707727338.,7959710899120817.,.492489509254662793523,-44,53,
 5565768841151349.,7185351745633006.,.460015450913106399819,-44,53,
 5565768841151353.,7185351745631771.,.497344327751846622222,-44,53,
 5565768841151380.,7185351745623435.,.499314236696976869443,-44,53,
 5565768841153925.,7185351744837690.,.499735222860429397297,-44,53,
 5565768841154943.,7185351744523392.,.499861511516499523021,-44,53,
 5565768841195046.,7185351732141965.,.477834574786233926276,-44,53,
 5637442019535798.,5203844502139369.,-.499998370441910635843,-44,59,
 5637442019535926.,5203844506333502.,-.402291701083010287657,-44,59,
 5637442019535968.,5203844507709702.,-.479606760227487710915,-44,59,
 5637442019535980.,5203844508102901.,.498303217426182945233,-44,59,
 5666178554236040.,8984047687816206.,.490790283457037061337,-44,53,
 5666178554260108.,8984047686933247.,-.499950692518811249492,-44,53,
 5666178554261242.,8984047686891645.,-.487630763286210855775,-44,53,
 5666178554261258.,8984047686891058.,-.464529514596860695906,-44,53,
 5666178554261277.,8984047686890361.,-.499596791430407763452,-44,53,
 5666178554304651.,8984047685299139.,.472660546074007600680,-44,53,
 5835612929826931.,-8660970603896953.,-.499603964551493496872,-44,53,
 5835612929831679.,-8660970603229427.,-.499823767782800121910,-44,53,
 5835612929832212.,-8660970603154493.,.495557413543751236776,-44,53,
 5835612929832217.,-8660970603153790.,.450485980089220286503,-44,53,
 5835612929832234.,-8660970603151400.,.497243111577029755454,-44,53,
 5835612929832278.,-8660970603145213.,-.499385451722040243428,-44,53,
 6029337333126160.,-5229716333760498.,.499636891025268202806,-44,54,
 6029337333126170.,-5229716333770296.,-.498273536302551578277,-44,54,
 6029337333126200.,-5229716333799693.,-.492004808147136014217,-44,54,
 6029337333126210.,-5229716333809492.,-.489915228715705857083,-44,54,
 6029337333127597.,-5229716335168614.,.499925809656522217981,-44,54,
 6029337333128076.,-5229716335637985.,-.499970129887732817225,-44,54,
 6157045845774343.,-8604786539146163.,-.448756141808213140500,-44,53,
 6157045845834325.,-8604786548223139.,.499928894242406496499,-44,53,
 6157045845834989.,-8604786548323621.,.498653601542129651089,-44,53,
 6157045845835056.,-8604786548333759.,-.498462351040450453628,-44,53,
 6157045845837447.,-8604786548695585.,-.499936509254591950781,-44,53,
 6245226045767564.,-8897040800882148.,.499846673315729735514,-44,68,
 6245226045767679.,-8897042730261987.,.376442884067159831739,-44,68,
 6245226045767681.,-8897042763816419.,.391688038921992588840,-44,68,
 6245226045767686.,-8897042847702499.,.429800926562162656205,-44,68,
 6245226045767695.,-8897042998697443.,.498404126125586224275,-44,68,
 6245226045770319.,-8897087022112206.,-.499852602615462184402,-44,68,
 6245226045789735.,-8897412768537914.,-.492997460757270432277,-44,68,
 6245226045794589.,-8897494205144341.,-.489590274736833273543,-44,68,
 6268442428667591.,-8724803201165547.,-.475131916511628419737,-44,53,
 6268442428709253.,-8724803206464970.,.499988060178560209852,-44,53,
 6268442428709592.,-8724803206508090.,-.426949504109109647412,-44,53,
 6268442428709617.,-8724803206511270.,-.436310553145773695832,-44,53,
 6268442428709772.,-8724803206530986.,-.494348663903624203231,-44,53,
 6268442428709787.,-8724803206532894.,-.499965219323303649732,-44,53,
 6328789084878694.,9000816055887664.,.308073197232497249527,-44,53,
 6328789084993582.,9000816053673514.,.456042396987204418544,-44,53,
 6328789084993593.,9000816053673302.,.461312887707819192528,-44,53,
 6328789084993670.,9000816053671818.,.498206224218223319307,-44,53,
 6328789084994243.,9000816053660776.,-.499982544782687729517,-44,53,
 6477002457250980.,-5149761703815698.,-.476445643598413541145,-44,53,
 6477002457250996.,-5149761703822419.,-.488008689319655696671,-44,53,
 6477002457251012.,-5149761703829140.,-.499571730781114811527,-44,53,
 6477002457251186.,-5149761703902232.,.499680468381039434212,-44,53,
 6477002457252483.,-5149761704447054.,.499869343589285731031,-44,53,
 6477002457253780.,-5149761704991875.,-.499913789618991677101,-44,53,
 6477002457300567.,-5149761724645373.,-.479541476118260561827,-44,53,
 6491364931154787.,-8911683808844645.,.499987029016280960443,-44,53,
 6491364931154921.,-8911683808854609.,-.499037530238177602331,-44,53,
 6491364931154932.,-8911683808855428.,.478654506518541560133,-44,53,
 6491364931199883.,-8911683812198238.,-.470906303351489321554,-44,53,
 6544022097406501.,8620355612595320.,.467638257865309584112,-44,53,
 6544022097454683.,8620355619747341.,.475233332465172859282,-44,53,
 6544022097454811.,8620355619766341.,.489446581178867916962,-44,53,
 6544022097454907.,8620355619780592.,-.499893781770684553020,-44,53,
 6544022097457720.,8620355620198146.,.499841827033605565242,-44,53,
 6616319171054698.,-7038283486052072.,-.469501887304552167571,-44,53,
 6616319171103679.,-7038283470402668.,-.499931956426577423904,-44,53,
 6616319171106486.,-7038283469505833.,-.461375217829566587559,-44,53,
 6616319171106502.,-7038283469500721.,-.469704982880274065438,-44,53,
 6616319171106558.,-7038283469482829.,-.498859114710038639007,-44,53,
 6616319171106560.,-7038283469482190.,-.499900332384927417062,-44,53,
 6702751591225331.,-6911136938702042.,-.499901622292520280918,-44,53,
 6702751591225878.,-6911136938881648.,.489449222635582561857,-44,53,
 6702751591225904.,-6911136938890184.,-.494603404497053322307,-44,53,
 6702751591225959.,-6911136938908243.,-.499330065996669533303,-44,53,
 6702751591228717.,-6911136939813820.,-.499900393888011884951,-44,53,
 6702751591275684.,-6911136955235225.,-.472296297299590642865,-44,53,
 6740450947157420.,-8914209096688882.,-.499818179497634070369,-44,56,
 6740450947157433.,-8914209096636044.,.474424742811021796630,-44,56,
 6740450947157886.,-8914209094794809.,.499969614194196520990,-44,56,
 6740450947176444.,-8914209019365140.,-.494813130033361534063,-44,56,
 6740450947195002.,-8914208943935472.,-.479676014431182924500,-44,56,
 6754791752061971.,5741424028077882.,.499346245211323599310,-44,53,
 6754791752062152.,5741424028149287.,.339646895953593158995,-44,53,
 6754791752062218.,5741424028175324.,.463734274844893711222,-44,53,
 6754791752062238.,5741424028183215.,-.498663505081765213797,-44,53,
 6754791752062503.,5741424028287757.,.499565210337415099326,-44,53,
 6754791752063567.,5741424028707507.,.499987388995084943961,-44,53,
 6754791752068088.,5741424030491050.,.499667341039408164496,-44,53,
 6794379564777760.,7162509413519012.,.499407557313294621873,-44,55,
 6794379564778169.,7162509412698099.,.493647710047810053082,-44,55,
 6794379564778218.,7162509412599751.,-.497262653594461616350,-44,55,
 6794379564778308.,7162509412419109.,.499024288831760417044,-44,55,
 6794379564779633.,7162509409759672.,.499893690249861681412,-44,55,
 6794379564782054.,7162509404900429.,.499867856182108426368,-44,55,
 6794379564797676.,7162509373545165.,.495613374470409585149,-44,55,
 6794379564805487.,7162509357867533.,.491368113306582766685,-44,55,
 6990987887114136.,9005430516762466.,.483118656654022787301,-44,53,
 6990987887148174.,9005430517107821.,-.497046306006405550962,-44,53,
 6990987887148195.,9005430517108034.,-.428297779814023674419,-44,53,
 6990987887148304.,9005430517109139.,.499968173786287331341,-44,53,
 6990987887160697.,9005430517234880.,.497713642538579754837,-44,53,
 7138546116895383.,-8855698191057577.,-.499929779277591103536,-44,54,
 7138546116897457.,-8855698192907019.,.497269586714890451726,-44,54,
 7138546116897501.,-8855698192946254.,-.473858890916259283224,-44,54,
 7138546116897512.,-8855698192956063.,-.466641001668219719365,-44,54,
 7138546116897596.,-8855698193030969.,.497568448578792224737,-44,54,
 7138546116898569.,-8855698193898619.,.499675961621264825078,-44,54,
 7138546116898708.,-8855698194022569.,.499979246340926745022,-44,54,
 7138546116938886.,-8855698229850360.,-.475511599357758988408,-44,54,
 7322656671988526.,9006019365558209.,.499684161023428603712,-44,53,
 7322656671992129.,9006019365588068.,-.499889961190417678738,-44,53,
 7322656671992805.,9006019365593670.,-.499297051828828868256,-44,53,
 7322656671993143.,9006019365596471.,-.499005583901724068444,-44,53,
 7322656671993202.,9006019365596959.,.432997615552879820564,-44,53,
 7322656671993237.,9006019365597249.,.477406245325911791449,-44,53,
 7322656671993251.,9006019365597365.,.495169687253818395756,-44,53,
 7322656671995394.,9006019365615124.,.499892148514659518513,-44,53,
 7357968097658117.,-7349500407631196.,-.499530412912279483570,-44,54,
 7357968097663086.,-7349500412276730.,.499948908795689701337,-44,54,
 7357968097664220.,-7349500413336910.,.499509762692673592962,-44,54,
 7357968097664354.,-7349500413462187.,.497696219712441083607,-44,54,
 7357968097664385.,-7349500413491168.,-.495260583974085226672,-44,54,
 7357968097664395.,-7349500413500518.,.474753355188824612008,-44,54,
 7461059150899550.,6681804354461914.,.499940445808595919156,-44,61,
 7461059150900673.,6681804207268677.,-.499841381398710924567,-44,61,
 7461059150902114.,6681804018394717.,.499508214769176875630,-44,61,
 7461059150902234.,6681804002666144.,-.463073993658175168728,-44,61,
 7461059150902243.,6681804001486500.,.489732328176735951908,-44,61,
 7461059150902263.,6681803998865071.,.495968592659861673026,-44,61,
 7461059150911416.,6681802799168092.,.499088677083036878159,-44,61,
 7819356134935921.,-8992864847946726.,.499961999365180756841,-44,53,
 7819356134936048.,-8992864847950392.,-.499110626364389961580,-44,53,
 7819356134936056.,-8992864847950623.,-.491178177648423745660,-44,53,
 7819356134936072.,-8992864847951085.,-.475313274637448723670,-44,53,
 7819356134945628.,-8992864848227005.,-.498671005488200974539,-44,53,
 7880037969502917.,8724180330457179.,.498986018163460575286,-44,53,
 7880037969509904.,8724180329567466.,.499813008835845570037,-44,53,
 7880037969511237.,8724180329397724.,.489080245982470808667,-44,53,
 7880037969511261.,8724180329394668.,.368856541404398022983,-44,53,
 7880037969511302.,8724180329389447.,.496807675187885486122,-44,53,
 7880037969512233.,8724180329270895.,.499782860769904710937,-44,53,
 7880037969524011.,8724180327771104.,.497717905973426752505,-44,53,
 7880037969547434.,8724180324788458.,.481565552205218558087,-44,53,
 7961347698809129.,5771335184486205.,.499915941399055986332,-44,55,
 7961347698810220.,5771335186691721.,-.498543958951099784511,-44,55,
 7961347698810229.,5771335186709914.,.484053438105025143985,-44,55,
 7961347698810910.,5771335188086593.,-.499414565947128831835,-44,55,
 7961347698813726.,5771335193779287.,.499838843015274278763,-44,55,
 7961347698822920.,5771335212365451.,.498502402727158080399,-44,55,
 8016984453607759.,-6516512838653414.,-.470915152196985767883,-44,55,
 8016984453656019.,-6516512935859793.,-.499786586287429021557,-44,55,
 8016984453658967.,-6516512941797722.,.499790444859640472227,-44,55,
 8016984453660324.,-6516512944531021.,-.465064594797044156166,-44,55,
 8016984453660333.,-6516512944549149.,-.467779052953875844919,-44,55,
 8016984453660432.,-6516512944748557.,-.497637980113707535607,-44,55,
 8016984453660441.,-6516512944766686.,.499647582195882027690,-44,55,
 8049376796585164.,-8101215316279530.,-.457467052802254938237,-44,53,
 8049376796616936.,-8101215309169198.,-.491640695946622821024,-44,53,
 8049376796640765.,-8101215303836449.,-.499930134247179088071,-44,53,
 8049376796642080.,-8101215303542162.,-.499451244072310853513,-44,53,
 8049376796642133.,-8101215303530302.,.497527181057887862593,-44,53,
 8049376796642167.,-8101215303522693.,.438985077403533811467,-44,53,
 8049376796642186.,-8101215303518441.,.494505679717702118892,-44,53,
 8049376796642422.,-8101215303465626.,.499920264532193347655,-44,53,
 8198893031068675.,8016624414346944.,-.499442883396543154676,-44,53,
 8198893031068710.,8016624414355113.,.470106087399978985622,-44,53,
 8198893031068738.,8016624414361649.,.445745241190653217313,-44,53,
 8198893031070646.,8016624414807029.,.499965450760607561252,-44,53,
 8198893031087230.,8016624418678194.,.495567980269726537177,-44,53,
 8466376832747454.,-5042111624814001.,-.481686871650184682798,-44,53,
 8466376832794331.,-5042111644702130.,.499795228414465004828,-44,53,
 8466376832794728.,-5042111644870561.,-.499184761080705102410,-44,53,
 8466376832794854.,-5042111644924019.,.493582831953224211446,-44,53,
 8466376832794873.,-5042111644932079.,-.483698222845541927771,-44,53,
 8466376832796400.,-5042111645579927.,-.499898501663844152242,-44,53,
 8466376832799305.,-5042111646812408.,-.499834100656945073611,-44,53,
 8627767282627698.,6064183514929205.,.499920468043830143403,-44,54,
 8627767282627973.,6064183515194370.,.498927256763518660558,-44,54,
 8627767282628024.,6064183515243547.,-.446711647126084877935,-44,54,
 8627767282628028.,6064183515247403.,.498728436687970271543,-44,54,
 8627767282632720.,6064183519771600.,.499730882303583829407,-44,54,
 8627767282642764.,6064183529456390.,.497869167514491598415,-44,54,
 8666709478623493.,4971138076363839.,.493072283521916481495,-44,53,
 8666709478648689.,4971138065606164.,.499928376372564124609,-44,53,
 8666709478652430.,4971138064008909.,-.499883385489109573165,-44,53,
 8666709478652875.,4971138063818911.,.461898971855566850371,-44,53,
 8666709478652876.,4971138063818485.,-.497737475867194416354,-44,53,
 8666709478662662.,4971138059640257.,.499215906118167084101,-44,53,
 8704521642365796.,-9007033143360346.,.499913265715819016289,-44,53,
 8704521642366353.,-9007033143362077.,-.480432401340219255340,-44,53,
 8704521642366371.,-9007033143362133.,-.451071787547565965935,-44,53,
 8704521642366408.,-9007033143362249.,.498169503749933824341,-44,53,
 8704521642366545.,-9007033143362675.,.499414631922834162618,-44,53,
 8704521642369815.,-9007033143372842.,-.499900847405102495998,-44,53,
 8704521642385891.,-9007033143422830.,-.494456430823921458056,-44,53,
 7146344544202515.,-5664593475764366.,-.264191654117720678617,-36,68,
 7146344544205550.,-5651558250023401.,-.492275489606574606073,-36,68,
 7146344544206764.,-5646344159727012.,-.495459653897401249922,-36,68,
 7146344544206806.,-5646163771100614.,.496437567296774464323,-36,68,
 7146344544206847.,-5645987677441510.,.276276348322878160942,-36,68,
 7146344544206848.,-5645983382474215.,.490443865143164849654,-36,68,
 7146344544206849.,-5645979087506919.,-.295387422453062310149,-36,68,
 7146344544224381.,-5570679720887042.,.447827479311610627319,-36,68,
 7170739958448096.,-6501843853097744.,-.498018990749645833128,-36,69,
 7170739958448119.,-6502041421593349.,.486885101881944715732,-36,69,
 7170739958448121.,-6502058601462531.,-.470914903643388072262,-36,69,
 7170739958448127.,-6502110141070080.,-.344281875414016273441,-36,69,
 7170739958448129.,-6502127320939263.,-.302059851020595902141,-36,69,
 7170739958448167.,-6502453738453739.,-.498794942903490688595,-36,69,
 7170739958449067.,-6510184679586070.,.107330671873303471485,-36,69,
 7170739958449967.,-6517915620718399.,-.169889677795187091615,-36,69,
 7170739958494683.,-6902023135909449.,.189697677001847768205,-36,69,
 7158542251322394.,4877362288068754.,-.459864201856895264983,-35,69,
 7158542251327426.,4790913186337764.,.489986480020034407409,-35,69,
 7158542251327472.,4790122912355327.,-.486061500180152524195,-35,69,
 7158542251327487.,4789865214317575.,-.001846514977179322205,-35,69,
 7158542251327488.,4789848034448392.,-.436264640562781418045,-35,69,
 7158542251327489.,4789830854579208.,.129313176692518967076,-35,69,
 7158542251327548.,4788817242297385.,.491223746876062042566,-35,69,
 7158542251327792.,4784625354216627.,.312603422958985270626,-35,69,
 5371956115275269.,6779401237121191.,-.472545200358289849985,-34,71,
 5371956115275774.,6848807908624262.,-.496061838569303186396,-34,71,
 5371956115275775.,6848945347577733.,-.074236621364534482445,-34,71,
 5371956115275777.,6849220225484676.,-.230655802809018470595,-34,71,
 5371956115275838.,6857604001646432.,.453951120246026480724,-34,71,
 5371956115281547.,7642242987014378.,.158653370331579616131,-34,71,
 5371956115312579.,5953624295560178.,.117148012027400209323,-34,70,
 7161591678107647.,5461501442824271.,.367204809242481278970,-33,71,
 7161591678107649.,5460951687010385.,-.162309375639435698215,-33,71,
 7161591678107654.,5459577297475669.,-.487389942332281208200,-33,71,
 7161591678107722.,5440885599803526.,.308062685516740952231,-33,71,
 7161591678107926.,5384810506787098.,-.346674160702762396684,-33,71,
 7161591678137217.,-5333276531008744.,.392644044316313122487,-33,72,
 4923784867822300.,6589305048283398.,.289680922363736285539,-32,69,
 4923784867862330.,8700989927483741.,.375226168990261485895,-32,72,
 4923784867864257.,6582231020762181.,.117604572506830375355,-32,72,
 4923784867871965.,-7571218424532180.,.476643823333144494098,-32,74,
 4923784867872710.,-5423881537652133.,.002039768250550315580,-32,73,
 4923784867872760.,-5533832700429714.,-.497395360720570532642,-32,73,
 4923784867872767.,-5549225863218576.,.152190781783874938035,-32,73,
 4923784867872768.,-5551424886474127.,-.468094569271074963661,-32,73,
 4923784867872769.,-5553623909729679.,-.088078976979909598166,-32,73,
 4588037610665507.,-6850191620325553.,.442125291434398896354,-30,71,
 4588037610666381.,-4928245294979136.,.228395855102084936530,-30,71,
 4588037610668031.,-5199427693287393.,-.317535561337497733613,-30,73,
 4588037610668033.,-5181835507242980.,.025710854981768624036,-30,73,
 4588037610668038.,-5137855042131947.,.462347583777452769433,-30,73,
 4588037610668062.,-4926748809598985.,.492208546298728625198,-30,73,
 4588037610668129.,-8674821154222239.,.038553450329220524799,-30,74,
 4588037610768106.,6836481095720302.,-.016288723779051301828,-30,66,
 5818983827634773.,6201168844505622.,.235478712776202786271,-30,72,
 5818983827635815.,6473617519748019.,-.084631118551208453720,-30,74,
 5818983827636223.,-5631955090988658.,.399195708307081972945,-30,77,
 5818983827636224.,-5772692579343986.,.499399987357493704568,-30,77,
 5818983827636225.,-5913430067699313.,-.395388720923602004402,-30,77,
 5818983827638308.,-4672962786119567.,-.328373171793910596211,-30,71,
 5818983827647871.,-6425555544614704.,-.359205869376511516992,-30,69,
 5818983827666997.,-8470092619419134.,.141839141613328287534,-30,68,
 5378363199848147.,-5312688698518718.,.077471598562072647154,-26,70,
 5378363199848322.,-8936224563050060.,-.454746988297900643881,-26,72,
 5378363199848439.,-5624651954149625.,.175621376109609486018,-26,75,
 5378363199848441.,-8997504094614022.,.056640525419207801348,-26,76,
 5378363199848447.,-8968418614233196.,.484670612069352553853,-26,78,
 5378363199848449.,4963921984997782.,-.433895313344602229315,-26,85,
 5378363199848497.,6756611336071036.,.288962397877130385941,-26,73,
 5378363199849255.,7089726719167689.,.462475989520125993049,-26,69,
 5378363199850363.,8417898892831053.,-.224282263620340510952,-26,68,
 5378363199859402.,6021480136746468.,.349598647942496311757,-26,65,
 5378363199895558.,6474612310849757.,-.363851591904364337193,-26,63,
 5560206444457848.,4652813891337958.,-.012324416651601840789,-25,65,
 5560206444461755.,5712351583125413.,.245250154454826018792,-25,69,
 5560206444461838.,8504400282982534.,.332012545318330609467,-25,70,
 5560206444462079.,6391452069778419.,.377448972963056097547,-25,78,
 5560206444462081.,-5811473219851781.,.359401038364582028115,-25,77,
 5560206444462084.,-4830568025490804.,-.355598969944805715713,-25,75,
 5560206444462087.,-8208267746018625.,.062608276728609194611,-25,75,
 8249388044351482.,4785926593330462.,-.334087245181575095084,-25,62,
 8249388044378847.,8199283857602472.,.151943823554669171443,-25,65,
 8249388044385273.,4535288819325084.,.374432768529834303742,-25,67,
 8249388044386191.,7966113965513265.,-.487048013623771510126,-25,71,
 8249388044386303.,5428135528320559.,.175382541432844737181,-25,77,
 8249388044386305.,-7158127452840863.,.354577739125881952027,-25,78,
 8249388044386311.,-7650165372660800.,.368834950717042344353,-25,75,
 8249388044386323.,-5290241063692808.,-.350816535029397638575,-25,73,
 8249388044386366.,-8696832531120730.,-.479991921534667629965,-25,72,
 6904797244423595.,-5250893179935818.,.203320686825141879679,-24,67,
 6904797244423774.,-7352785059376571.,-.019896615523172469739,-24,68,
 6904797244424132.,-8438259649871543.,.063570278119088233819,-24,71,
 6904797244424188.,-8911364831858104.,.071032210903440853208,-24,75,
 6904797244424191.,-8623861563209766.,.411355773421189600412,-24,77,
 6904797244424193.,4695268473136104.,-.156635787444181080085,-24,76,
 6904797244424201.,5090508186512263.,-.105458961261277232928,-24,73,
 8967144255500256.,5638292417329436.,-.310012125566755782466,-23,61,
 8967144255520753.,8449182442499160.,.261233383607616852575,-23,72,
 8967144255520767.,4543064756842390.,.270923321049377290109,-23,75,
 8967144255520769.,-8928268995797161.,.218342493204407957496,-23,76,
 8967144255521090.,-5664529744248972.,-.273686360091744592503,-23,67,
 8967144255523395.,-5776814727830040.,.383583528766174465582,-23,64,
 8967144255562421.,-5724720000282061.,.252945315172533760352,-23,60,
 5346671783305164.,-4532174741094225.,-.287186992345632965535,-21,60,
 5346671783313066.,-6016511092550103.,.129014449183179290452,-21,65,
 5346671783313392.,-9006670999530532.,-.446523518098164248234,-21,70,
 5346671783313405.,-6753286420561068.,.212629783463605132047,-21,72,
 5346671783313407.,-8998747172771154.,-.130827102482143670028,-21,74,
 5346671783313409.,4507825668355074.,-.399648554978521816834,-21,73,
 5346671783314057.,5708672534279079.,.197609700359476432314,-21,64,
 5346671783318008.,5057750463849714.,.274933782613593596632,-21,61,
 5346671783332169.,5156915884907076.,-.256113842129952063110,-21,59,
 6467564815197495.,7694158457753160.,.069595014158335943481,-20,57,
 6467564815252374.,4969792286143380.,-.123932645506241227276,-20,62,
 6467564815252536.,8514618217166241.,.025524871209206437933,-20,63,
 6467564815253503.,4504306727569052.,.416375462631839455536,-20,72,
 6467564815253505.,-9005785054341149.,.499619536438339366537,-20,73,
 6467564815253508.,-9006845704619530.,.463341029355129047210,-20,71,
 6467564815257616.,-4521180052804444.,.393213159223261121202,-20,60,
 6467564815278584.,-6893280570123314.,-.439221696876370466024,-20,58,
 7804232761081636.,-7740558902619957.,-.213007320049015036990,-19,64,
 7804232761081813.,-6051701073430576.,-.274896714167321374940,-19,66,
 7804232761081855.,-9006500434641636.,-.373046353784050331636,-19,72,
 7804232761081857.,4503949037414712.,.480044869367149458447,-19,71,
 7804232761081860.,4503686979838540.,-.263425036978154096491,-19,69,
 7804232761081865.,5066593256798838.,.037561568739374830105,-19,68,
 5519007584323628.,8412923421012485.,-.421225712864406194777,-18,56,
 5519007584350422.,8536296274778100.,.461182643099359286862,-18,59,
 5519007584353556.,6579468656466393.,-.003381311206845869310,-18,61,
 5519007584354303.,4503601697385909.,.278266040396377130279,-18,70,
 5519007584354305.,-9007195114666475.,.223198743361498887020,-18,71,
 5519007584354313.,-5066549321043188.,-.157556302660084088134,-18,67,
 5519007584354314.,-5629499274094495.,.139965468666348370777,-18,67,
 5519007584354348.,-6192449393869971.,-.286757037157812236112,-18,65,
 5519007584354417.,-7951667813477454.,-.460149721453701021042,-18,64,
 7304668022890131.,8375572950390052.,-.051890879738437208388,-12,53,
 7304668022910929.,-6614516798179550.,.324696568804068586505,-12,59,
 7304668022910975.,-9007199139549656.,-.035521643731176792368,-12,65,
 7304668022910977.,9007199190975358.,-.168854982196523057174,-12,65,
 7304668022911101.,8794727752652333.,-.243620194290625766355,-12,58,
 7304668022911680.,6162005947942807.,-.130318021606954128614,-12,55,
 7304668022915561.,8104968146647738.,.269916011962678463381,-12,53,
 7304668022922744.,4779753490759630.,-.300840654282271858760,-12,54,
 7347785269663743.,9007198903458364.,-.021919879766200681973,-11,64,
 7347785269663745.,-9007198890195746.,.111413503171721881634,-11,64,
 5500059640559615.,9007197819972738.,.419116646084534239269,-10,63,
 5500059640559617.,-9007197826197851.,-.447546919358002225496,-10,63,
 4586976137695743.,-9007193528220571.,-.199161840817056272896,-9,62,
 4586976137695745.,9007193528017475.,-.332693586842657359045,-9,62,
 8944333985714495.,9006832755334834.,-.081722808608585275535,-6,59,
 8944333985714497.,-9006832755343096.,.064132570972028475637,-6,59,
 6851593493588863.,9001336337944357.,.314533243558015997417,-4,57,
 6851593493588865.,-9001336337944208.,-.097401991988137061758,-4,57 };
#include "trailer.h"

double
sincos_sin(double x)
{
	double y, z;

	sincos(x, &y, &z);
	return y;
}
