/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.AttackDelegate;
import de.rub.nds.tlsattacker.attacks.ec.ICEAttacker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.converters.BigIntegerConverter;
import de.rub.nds.tlsattacker.core.config.converters.NamedGroupConverter;
import de.rub.nds.tlsattacker.core.config.converters.PointFormatConverter;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ProtocolVersionDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurveOverFp;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import java.math.BigInteger;
import java.util.LinkedList;

public class InvalidCurveAttackConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "invalid_curve";
    @Parameter(names={"-named_curve"}, description="Named curve to be used", converter=NamedGroupConverter.class)
    private NamedGroup namedGroup = NamedGroup.SECP256R1;
    @Parameter(names={"-additional_equations"}, description="Additional equations used when attacking Oracle JSSE server (needed because of a faulty JSSE implementation).")
    private int additionalEquations = 3;
    @Parameter(names={"-server_type"}, description="Allows to switch between a normal vulnerable server type and an Oracle server type (for oracle a slightly different algorithm is needed).")
    private ICEAttacker.ServerType serverType = ICEAttacker.ServerType.NORMAL;
    @Parameter(names={"-curve_field_size"}, description="Curve field size. 32 works for 256bits.")
    private int curveFieldSize = 32;
    @Parameter(names={"-protocol_flows"}, description="Number of Protocol flows")
    private int protocolFlows = 15;
    @Parameter(names={"-premaster_secret"}, description="Premaster Secret String (use 0x at the beginning for a hex value)", hidden=true, converter=BigIntegerConverter.class)
    private BigInteger premasterSecret;
    @Parameter(names={"-public_point_base_x"}, hidden=true, description="Public key point coordinate X sent to the server (use 0x at the beginning for a hex value)", converter=BigIntegerConverter.class)
    private BigInteger publicPointBaseX = new BigInteger("b70bf043c144935756f8f4578c369cf960ee510a5a0f90e93a373a21f0d1397f", 16);
    @Parameter(names={"-public_point_base_y"}, hidden=true, description="Public key point coordinate Y sent to the server (use 0x at the beginning for a hex value)", converter=BigIntegerConverter.class)
    private BigInteger publicPointBaseY = new BigInteger("4a2e0ded57a5156bb82eb4314c37fd4155395a7e51988af289cce531b9c17192", 16);
    @Parameter(names={"-ephemeral"}, description="If set to true, the attack with ephemeral cipher suites (ECDHE) is attempted.")
    private boolean ephemeral = false;
    @ParametersDelegate
    private ClientDelegate clientDelegate;
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate;
    @ParametersDelegate
    private ProtocolVersionDelegate protocolVersionDelegate;
    @ParametersDelegate
    private AttackDelegate attackDelegate;
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate;
    private EllipticCurveOverFp twistedCurve;
    private boolean curveTwistAttack = false;
    @Parameter(names={"-curve_twist_d"}, hidden=true, description="Non quadratic residue used to obtain twisted curve", converter=BigIntegerConverter.class)
    private BigInteger curveTwistD;
    @Parameter(names={"-point_format"}, description="The format used for the public key", converter=PointFormatConverter.class)
    private ECPointFormat pointCompressionFormat = ECPointFormat.UNCOMPRESSED;
    @Parameter(names={"-renegotiation"}, description="If set to true, the attack will be carried out in a renegotiation handshake")
    private boolean attackInRenegotiation = false;

    public InvalidCurveAttackConfig(GeneralDelegate delegate) {
        super(delegate);
        this.clientDelegate = new ClientDelegate();
        this.ciphersuiteDelegate = new CiphersuiteDelegate();
        this.protocolVersionDelegate = new ProtocolVersionDelegate();
        this.attackDelegate = new AttackDelegate();
        this.starttlsDelegate = new StarttlsDelegate();
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
        this.addDelegate(this.protocolVersionDelegate);
        this.addDelegate(this.attackDelegate);
        this.addDelegate(this.starttlsDelegate);
    }

    public BigInteger getPremasterSecret() {
        return this.premasterSecret;
    }

    public void setPremasterSecret(BigInteger premasterSecret) {
        this.premasterSecret = premasterSecret;
    }

    public BigInteger getPublicPointBaseX() {
        return this.publicPointBaseX;
    }

    public void setPublicPointBaseX(BigInteger publicPointBaseX) {
        this.publicPointBaseX = publicPointBaseX;
    }

    public BigInteger getPublicPointBaseY() {
        return this.publicPointBaseY;
    }

    public void setPublicPointBaseY(BigInteger publicPointBaseY) {
        this.publicPointBaseY = publicPointBaseY;
    }

    public NamedGroup getNamedGroup() {
        return this.namedGroup;
    }

    public void setNamedGroup(NamedGroup namedGroup) {
        this.namedGroup = namedGroup;
    }

    public int getCurveFieldSize() {
        return this.curveFieldSize;
    }

    public void setCurveFieldSize(int curveFieldSize) {
        this.curveFieldSize = curveFieldSize;
    }

    public int getProtocolFlows() {
        return this.protocolFlows;
    }

    public void setProtocolFlows(int protocolFlows) {
        this.protocolFlows = protocolFlows;
    }

    public int getAdditionalEquations() {
        return this.additionalEquations;
    }

    public void setAdditionalEquations(int additionalEquations) {
        this.additionalEquations = additionalEquations;
    }

    public ICEAttacker.ServerType getServerType() {
        return this.serverType;
    }

    public void setServerType(ICEAttacker.ServerType serverType) {
        this.serverType = serverType;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    @Override
    public boolean isExecuteAttack() {
        return this.attackDelegate.isExecuteAttack();
    }

    public boolean isCurveTwistAttack() {
        return this.curveTwistAttack;
    }

    public void setCurveTwistAttack(boolean curveTwistAttack) {
        this.curveTwistAttack = curveTwistAttack;
    }

    public EllipticCurveOverFp getTwistedCurve() {
        return this.twistedCurve;
    }

    public void setTwistedCurve(EllipticCurveOverFp twistedCurve) {
        this.twistedCurve = twistedCurve;
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        LinkedList<CipherSuite> cipherSuites = new LinkedList<CipherSuite>();
        if (this.ephemeral) {
            cipherSuites.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
            cipherSuites.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_RC4_128_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
            cipherSuites.add(CipherSuite.TLS_ECDHE_RSA_WITH_RC4_128_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
            cipherSuites.add(CipherSuite.TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
            config.setDefaultSelectedCipherSuite(CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA);
        } else {
            cipherSuites.add(CipherSuite.TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256);
            cipherSuites.add(CipherSuite.TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384);
            cipherSuites.add(CipherSuite.TLS_ECDH_RSA_WITH_AES_128_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256);
            cipherSuites.add(CipherSuite.TLS_ECDH_RSA_WITH_AES_256_CBC_SHA);
            cipherSuites.add(CipherSuite.TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384);
            config.setDefaultSelectedCipherSuite(CipherSuite.TLS_ECDH_RSA_WITH_AES_128_CBC_SHA);
        }
        config.setQuickReceive(true);
        config.setStopActionsAfterFatal(true);
        config.setStopReceivingAfterFatal(true);
        config.setEarlyStop(true);
        config.setStopActionsAfterIOException(true);
        config.setAddECPointFormatExtension(true);
        config.setAddEllipticCurveExtension(true);
        config.setAddServerNameIndicationExtension(true);
        config.setAddRenegotiationInfoExtension(true);
        config.setDefaultClientSupportedCiphersuites(cipherSuites);
        LinkedList<NamedGroup> namedCurves = new LinkedList<NamedGroup>();
        namedCurves.add(this.namedGroup);
        config.setDefaultClientNamedGroups(namedCurves);
        config.setWorkflowTraceType(WorkflowTraceType.HANDSHAKE);
        return config;
    }

    public BigInteger getCurveTwistD() {
        return this.curveTwistD;
    }

    public void setCurveTwistD(BigInteger curveTwistD) {
        this.curveTwistD = curveTwistD;
    }

    public ECPointFormat getPointCompressionFormat() {
        return this.pointCompressionFormat;
    }

    public void setPointCompressionFormat(ECPointFormat pointCompressionFormat) {
        this.pointCompressionFormat = pointCompressionFormat;
    }

    public boolean isAttackInRenegotiation() {
        return this.attackInRenegotiation;
    }

    public void setAttackInRenegotiation(boolean attackInRenegotiation) {
        this.attackInRenegotiation = attackInRenegotiation;
    }
}

