/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectlibre;

import java.io.IOException;
import java.io.InputStream;

public class SearchableInputStream
extends InputStream {
    private final InputStream m_stream;
    private final byte[] m_pattern;
    private boolean m_searching = true;

    public SearchableInputStream(InputStream inputStream, String string) {
        this.m_stream = inputStream;
        this.m_pattern = string.getBytes();
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.m_searching) {
            int n2 = 0;
            n = -1;
            while (this.m_searching) {
                n = this.m_stream.read();
                if (n == -1) {
                    throw new IOException("Pattern not found");
                }
                if (n == this.m_pattern[n2]) {
                    if (++n2 != this.m_pattern.length) continue;
                    this.m_searching = false;
                    n = this.m_stream.read();
                    continue;
                }
                n2 = 0;
            }
        } else {
            n = this.m_stream.read();
        }
        return n;
    }
}

