/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.shared.common.sanity.SanityManager;

public class LogCounter
implements LogInstant {
    public static final long INVALID_LOG_INSTANT = 0L;
    public static final long DERBY_10_0_MAX_LOGFILE_NUMBER = 0x3FFFFFL;
    public static final long MAX_LOGFILE_NUMBER = Integer.MAX_VALUE;
    private static final long FILE_NUMBER_SHIFT = 32L;
    public static final long MAX_LOGFILE_SIZE = 0xFFFFFFFL;
    private static final long FILE_POSITION_MASK = Integer.MAX_VALUE;
    private long fileNumber;
    private long filePosition;

    public LogCounter(long value) {
        this.fileNumber = LogCounter.getLogFileNumber(value);
        this.filePosition = LogCounter.getLogFilePosition(value);
    }

    public LogCounter(long fileNumber, long position) {
        SanityManager.ASSERT((fileNumber > 0L ? 1 : 0) != 0, (String)"illegal fileNumber");
        SanityManager.ASSERT((position > 0L ? 1 : 0) != 0, (String)"illegal file position");
        SanityManager.ASSERT((position < 0xFFFFFFFL ? 1 : 0) != 0, (String)("log file position exceeded max log file size. log file position = " + position));
        SanityManager.ASSERT((fileNumber < Integer.MAX_VALUE ? 1 : 0) != 0, (String)("log file number exceeded max log file number. log file number = " + fileNumber));
        this.fileNumber = fileNumber;
        this.filePosition = position;
    }

    public LogCounter() {
    }

    public static final long makeLogInstantAsLong(long filenum, long filepos) {
        SanityManager.ASSERT((filenum > 0L ? 1 : 0) != 0, (String)"illegal fileNumber");
        SanityManager.ASSERT((filepos > 0L ? 1 : 0) != 0, (String)"illegal file position");
        SanityManager.ASSERT((filepos < 0xFFFFFFFL ? 1 : 0) != 0, (String)("log file position exceeded max log file size. log file position = " + filepos));
        SanityManager.ASSERT((filenum < Integer.MAX_VALUE ? 1 : 0) != 0, (String)("log file number exceeded max log file number. log file number = " + filenum));
        return filenum << 32 | filepos;
    }

    public static final long getLogFilePosition(long valueAsLong) {
        return valueAsLong & Integer.MAX_VALUE;
    }

    public static final long getLogFileNumber(long valueAsLong) {
        return valueAsLong >>> 32;
    }

    @Override
    public boolean lessThan(DatabaseInstant other) {
        LogCounter compare = (LogCounter)other;
        return this.fileNumber == compare.fileNumber ? this.filePosition < compare.filePosition : this.fileNumber < compare.fileNumber;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogCounter)) {
            return false;
        }
        LogCounter compare = (LogCounter)other;
        return this.fileNumber == compare.fileNumber && this.filePosition == compare.filePosition;
    }

    @Override
    public DatabaseInstant next() {
        return new LogCounter(LogCounter.makeLogInstantAsLong(this.fileNumber, this.filePosition) + 1L);
    }

    @Override
    public DatabaseInstant prior() {
        return new LogCounter(LogCounter.makeLogInstantAsLong(this.fileNumber, this.filePosition) - 1L);
    }

    public int hashCode() {
        return (int)(this.filePosition ^ this.fileNumber);
    }

    @Override
    public String toString() {
        return "(" + this.fileNumber + "," + this.filePosition + ")";
    }

    public static String toDebugString(long instant) {
        return "(" + LogCounter.getLogFileNumber(instant) + "," + LogCounter.getLogFilePosition(instant) + ")";
    }

    public long getValueAsLong() {
        return LogCounter.makeLogInstantAsLong(this.fileNumber, this.filePosition);
    }

    public long getLogFilePosition() {
        return this.filePosition;
    }

    public long getLogFileNumber() {
        return this.fileNumber;
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.fileNumber = CompressedNumber.readLong(oi);
        this.filePosition = CompressedNumber.readLong(oi);
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        CompressedNumber.writeLong(oo, this.fileNumber);
        CompressedNumber.writeLong(oo, this.filePosition);
    }

    @Override
    public int getTypeFormatId() {
        return 130;
    }
}

