/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Copy;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.UseAttributeSets;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCopy
extends StyleElement {
    private String use;
    private AttributeSet[] attributeSets = null;
    private boolean copyNamespaces = true;
    private boolean inheritNamespaces = true;
    private int validationAction = 3;
    private SchemaType schemaType = null;
    private Expression select = null;
    private Expression onEmpty = null;
    private boolean selectSpecified = false;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String copyNamespacesAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String inheritAtt = null;
        String selectAtt = null;
        String onEmptyAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("use-attribute-sets")) {
                this.use = atts.getValue(a);
                continue;
            }
            if (f.equals("copy-namespaces")) {
                copyNamespacesAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("inherit-namespaces")) {
                inheritAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("on-empty")) {
                onEmptyAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (copyNamespacesAtt != null) {
            this.copyNamespaces = this.processBooleanAttribute("copy-namespaces", copyNamespacesAtt);
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The type and validation attributes must not both be specified", "XTSE1505");
        }
        this.validationAction = validationAtt != null ? this.validateValidationAttribute(validationAtt) : this.getDefaultValidation();
        if (typeAtt != null) {
            this.schemaType = this.getSchemaType(typeAtt);
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.validationAction = 8;
        }
        if (inheritAtt != null) {
            this.inheritNamespaces = this.processBooleanAttribute("inherit-namespaces", inheritAtt);
        }
        if (selectAtt != null) {
            if (!this.isXslt30Processor()) {
                this.compileError("The @select attribute of xsl:copy requires XSLT 3.0");
            }
            this.select = this.makeExpression(selectAtt);
            this.selectSpecified = true;
        }
        if (onEmptyAtt != null) {
            if (!this.isXslt30Processor()) {
                this.compileError("The 'on-empty' attribute requires XSLT 3.0");
            }
            this.onEmpty = this.makeExpression(onEmptyAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        if (this.select != null && !this.isXslt30Processor()) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.compileWarning("xsl:copy/@select is ignored in forwards-compatibility mode", "");
            } else {
                this.compileError("The xsl:copy/@select attribute is not recognized by an XSLT 2.0 processor");
            }
        }
        if (this.onEmpty != null) {
            RoleLocator role = new RoleLocator(4, "xsl:copy/on-empty", 0);
            role.setErrorCode("XTTE3330");
            this.onEmpty = TypeChecker.staticTypeCheck(this.onEmpty, SequenceType.OPTIONAL_ELEMENT_NODE, false, role, this.makeExpressionVisitor());
        }
        if (this.select == null) {
            this.select = new ContextItemExpression();
            this.select.setLocationId(this.getLineNumber());
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, "xsl:copy/select", 0);
            role.setErrorCode("XTTE3180");
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.OPTIONAL_ITEM, false, role, this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        Expression content = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            InstanceOfExpression condition = new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType(NodeKindTest.ELEMENT, 16384));
            Expression choice = Choose.makeConditional(condition, use);
            if (content == null) {
                content = choice;
            } else {
                content = Block.makeBlock(choice, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence(this);
        }
        Copy inst = new Copy(this.copyNamespaces, this.inheritNamespaces, this.schemaType, this.validationAction, this.onEmpty);
        inst.setContentExpression(content);
        if (this.selectSpecified) {
            if (this.onEmpty != null && !Literal.isEmptySequence(this.onEmpty)) {
                try {
                    return this.getConfiguration().rewriteCopyOnEmpty(this, inst, this.select, this.onEmpty);
                }
                catch (Exception e) {
                    throw new XPathException("Problem in xsl:copy/@on-empty:" + e.getMessage());
                }
            }
            return new ForEach(this.select, inst);
        }
        return inst;
    }
}

