/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBSecurity;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.security.cert.CertViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class KeystoreGUI
extends CBDialog
implements ActionListener {
    public static final String ERRORCERT = "<unable to read>";
    public static final String DELETEDCERT = "<deleted>";
    CBButton viewCert;
    CBButton addCert;
    CBButton deleteCert;
    CBButton passwordButton;
    CBButton importKeyButton;
    CBButton exportKeyButton;
    CBButton[] commandButtons;
    protected KeyStore keystore = null;
    final JList certList;
    DefaultListModel certListModel;
    public static ImageIcon smallCert;
    public static ImageIcon smallKeyCert;
    Properties properties;
    protected CBHelpSystem helpBroker;
    char[] password = null;
    protected String keystoreFile;
    protected String keystoreType;
    private static Logger log;
    private boolean crippled = false;
    private boolean cripplePassword = false;
    private boolean changed = false;

    public KeystoreGUI(Frame owner, Properties props, String keyStoreLocation, char[] keyStorePassword, String keyStoreType, String title, boolean handlePrivateKeys, String helpTopic) {
        super(owner, title, helpTopic);
        if ("KSE".equals(keyStoreType)) {
            this.crippled = true;
        }
        this.properties = props;
        this.password = keyStorePassword;
        CertViewer.setProperties(this.properties);
        if (smallCert == null) {
            smallCert = this.getImageIcon("sslcert.gif");
        }
        if (smallKeyCert == null) {
            smallKeyCert = this.getImageIcon("sslkeycert.gif");
        }
        this.keystoreFile = keyStoreLocation;
        this.keystoreType = keyStoreType;
        this.display.makeHeavy();
        JScrollPane scrollPane = new JScrollPane();
        this.certList = new JList();
        if (this.password != null || "JKS".equalsIgnoreCase(this.keystoreType)) {
            this.setupCertificateList();
        } else if ("KSE".equalsIgnoreCase(this.keystoreType) && this.keystoreFile != null && this.keystoreFile.toLowerCase().endsWith(".der")) {
            this.setupCertificateList();
            this.cripplePassword = true;
        } else if (this.setupPasswordAndKeystore(this.keystoreType, this.keystoreFile, this)) {
            this.refreshView();
            this.certList.setModel(this.certListModel);
        }
        scrollPane.getViewport().setView(this.certList);
        this.display.add(scrollPane, 1, 1, 2, handlePrivateKeys ? 7 : 5);
        this.display.makeLight();
        this.viewCert = new CBButton("  " + CBIntText.get("View Certificate"), CBIntText.get("View a certificate in detail."), this.getImageIcon("sslview.gif"));
        this.display.add((Component)this.viewCert, 3, 1);
        this.addCert = new CBButton("  " + CBIntText.get("Add Certificate"), CBIntText.get("Add a new trusted server certificate"), this.getImageIcon("ssladd.gif"));
        this.display.add((Component)this.addCert, 3, 2);
        if (this.crippled) {
            this.addCert.setEnabled(false);
        }
        this.deleteCert = new CBButton("  " + CBIntText.get("Delete Certificate"), CBIntText.get("Delete an unwanted or out of date server certificate"), this.getImageIcon("ssldelete.gif"));
        this.display.add((Component)this.deleteCert, 3, 3);
        this.passwordButton = new CBButton("  " + CBIntText.get("Set Password"), CBIntText.get("Change the certificate keystore password."), this.getImageIcon("sslpassword.gif"));
        this.display.add((Component)this.passwordButton, 3, 4);
        this.importKeyButton = new CBButton("  " + CBIntText.get("Set Private Key"), CBIntText.get("Match a PKCS-8 private key with a certificate"), this.getImageIcon("sslprivatekey.gif"));
        this.exportKeyButton = new CBButton("  " + CBIntText.get("Export Private Key"), CBIntText.get("Export the PKCS-8 private key matching a certificate"), this.getImageIcon("sslexprivatekey.gif"));
        if (handlePrivateKeys) {
            this.display.add((Component)this.importKeyButton, 3, 5);
            this.display.add((Component)this.exportKeyButton, 3, 6);
        }
        this.commandButtons = new CBButton[]{this.viewCert, this.addCert, this.deleteCert, this.passwordButton, this.importKeyButton, this.exportKeyButton};
        for (int i = 0; i < this.commandButtons.length; ++i) {
            this.commandButtons[i].setHorizontalAlignment(2);
            this.commandButtons[i].addActionListener(this);
        }
        if (this.crippled) {
            JButton[] crippledButton = new JButton[]{this.addCert, this.deleteCert, this.exportKeyButton, this.importKeyButton};
            for (int i = 0; i < 4; ++i) {
                crippledButton[i].setEnabled(false);
                crippledButton[i].removeActionListener(this);
                crippledButton[i].setToolTipText(CBIntText.get("Not available with this security provider"));
                crippledButton[i].setForeground(Color.gray);
            }
        }
        if (this.cripplePassword) {
            this.passwordButton.setEnabled(false);
            this.passwordButton.removeActionListener(this);
            this.passwordButton.setToolTipText(CBIntText.get("Not available with this security provider"));
            this.passwordButton.setForeground(Color.gray);
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                    CertItem cert = (CertItem)KeystoreGUI.this.certList.getSelectedValue();
                    KeystoreGUI.this.viewCurrentCert(cert);
                }
            }
        };
        this.certList.addMouseListener(mouseListener);
        this.display.add((Component)new JLabel("    "), 3, handlePrivateKeys ? 7 : 5);
    }

    public void actionPerformed(ActionEvent e) {
        JButton src = (JButton)e.getSource();
        CertItem cert = (CertItem)this.certList.getSelectedValue();
        if (src == this.viewCert) {
            this.viewCurrentCert(cert);
        } else if (src == this.addCert) {
            this.addNewCert();
        } else if (src == this.deleteCert) {
            if (cert == null) {
                CBUtility.error(CBIntText.get("Please select a certificate to delete."), null);
            } else {
                this.deleteCurrentCert(cert);
            }
        } else if (src == this.passwordButton) {
            this.setupPasswords();
        } else if (src == this.importKeyButton) {
            this.importKey(cert);
        } else if (src == this.exportKeyButton) {
            this.exportKey(cert);
        }
    }

    public void doOK() {
        if (this.changed) {
            if (!this.checkPassword()) {
                return;
            }
            try {
                if (!KeystoreGUI.writeKeyStore(this.password, this.keystore, this.keystoreFile, this.keystoreType)) {
                    this.clearPassword(this.password);
                    this.password = null;
                    return;
                }
            }
            catch (Exception e) {
                CBUtility.error(CBIntText.get("Error importing key file."), e);
                return;
            }
        }
        this.changed = false;
        this.clearPassword(this.password);
        this.password = null;
        super.doOK();
    }

    public void doCancel() {
        if (this.changed) {
            Object[] options = new String[]{CBIntText.get("Revise Changes"), CBIntText.get("Discard Changes")};
            int opt = JOptionPane.showOptionDialog(null, CBIntText.get("You have unsaved changes!"), "Warning", -1, 2, null, options, options[0]);
            if (opt == 0) {
                return;
            }
        }
        super.doCancel();
    }

    protected void importKey(CertItem certItem) {
        try {
            if (certItem == null || certItem.getX509Cert() == null) {
                CBUtility.error(CBIntText.get("Please select a certificate to match with a key."), null);
                return;
            }
            File keyFile = this.getKeyFile(CBIntText.get("Select a pkcs8 private key file"));
            if (keyFile == null) {
                return;
            }
            FileInputStream in = new FileInputStream(keyFile);
            byte[] buffer = new byte[(int)keyFile.length()];
            in.read(buffer);
            in.close();
            if (CBSecurity.isPEM(buffer)) {
                byte[] pemData = CBSecurity.convertFromPEM(buffer, new String(CBSecurity.PEM_KEY_HEADER).getBytes());
                if (pemData != null) {
                    buffer = pemData;
                } else {
                    CBUtility.error(CBIntText.get("Unable to load key: does not begin with {0} ", new String[]{new String(CBSecurity.PEM_KEY_HEADER)}));
                    return;
                }
            }
            if (!this.checkPassword()) {
                return;
            }
            String alias = certItem.getAlias();
            Certificate[] certChain = this.keystore.getCertificateChain(alias);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PrivateKey key = factory.generatePrivate(keySpec);
            if (certChain == null || certChain.length == 0) {
                certChain = new Certificate[]{certItem.getX509Cert()};
            }
            this.keystore.setKeyEntry(alias, key, this.password, certChain);
            this.refreshView();
            this.changed = true;
        }
        catch (Exception e) {
            CBUtility.error("Error importing key file.", e);
            e.printStackTrace();
        }
    }

    protected void exportKey(CertItem certItem) {
        try {
            if (certItem == null || certItem.getX509Cert() == null) {
                CBUtility.error(CBIntText.get("Please select a certificate to match with a key."), null);
                return;
            }
            File keyFile = this.getKeyFile(CBIntText.get("Select a file to save the pkcs8 key to."));
            if (keyFile == null) {
                return;
            }
            if (!this.checkPassword()) {
                return;
            }
            Key myKey = this.keystore.getKey(certItem.getAlias(), this.password);
            if (myKey == null) {
                return;
            }
            byte[] data = myKey.getEncoded();
            if (data == null) {
                throw new Exception("Unable to access encoded private key data");
            }
            if (keyFile.toString().toLowerCase().endsWith(".pem")) {
                data = CBSecurity.convertToPEMPrivateKey(data);
            }
            FileOutputStream out = new FileOutputStream(keyFile);
            out.write(data);
            out.close();
        }
        catch (Exception e) {
            CBUtility.error("Error exporting key file.", e);
            e.printStackTrace();
        }
    }

    protected File getKeyFile(String title) {
        JFileChooser chooser = new JFileChooser(this.properties.getProperty("cert.homeDir"));
        chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"der", "pem"}, "Certificate Files (*.der, *.pem)"));
        chooser.setDialogTitle(title);
        int option = chooser.showOpenDialog(this.owner);
        while (option == 0) {
            File keyFile = chooser.getSelectedFile();
            if (keyFile == null) {
                CBUtility.error(CBIntText.get("Please select a file"));
                continue;
            }
            this.properties.setProperty("cert.homeDir", keyFile.getParent());
            chooser = null;
            return keyFile;
        }
        chooser = null;
        return null;
    }

    protected void viewCurrentCert(CertItem cert) {
        if (cert == null || cert.getX509Cert() == null) {
            CBUtility.error(CBIntText.get("Please select a certificate to view."), null);
            return;
        }
        CertViewer viewer = new CertViewer(this.owner, cert.getX509Cert());
        viewer.setVisible(true);
    }

    protected void deleteCurrentCert(CertItem certItem) {
        if (certItem == null) {
            return;
        }
        int delete = JOptionPane.showConfirmDialog(this, CBIntText.get("delete certificate: {0} ?", new String[]{certItem.getAlias()}), CBIntText.get("Confirm Certificate Deletion"), 2);
        if (delete != 0) {
            return;
        }
        if (this.keystore == null) {
            CBUtility.error(CBIntText.get("Internal Error: unable to find Certificate Keystore"), null);
            return;
        }
        if (!this.checkPassword()) {
            return;
        }
        try {
            this.keystore.deleteEntry(certItem.getAlias());
            this.refreshView();
            this.changed = true;
            return;
        }
        catch (KeyStoreException e) {
            CBUtility.error(CBIntText.get("Error - unable to delete key: {0} from key store", new String[]{certItem.getAlias()}), e);
            try {
                this.keystore.setCertificateEntry(certItem.getAlias(), certItem.getX509Cert());
            }
            catch (Exception e2) {
                log.log(Level.WARNING, "unable to recover key store.", e2);
            }
            return;
        }
    }

    protected boolean checkPassword() {
        if (this.password != null) {
            return true;
        }
        return this.setupPasswordAndKeystore(this.keystoreType, this.keystoreFile, this);
    }

    public boolean setupPasswordAndKeystore(String keystoreType, String keystoreFile, Component owner) {
        if (this.password != null && this.keystore != null) {
            return true;
        }
        String message = CBIntText.get("Enter Key Store Password");
        while ((this.password = KeystoreGUI.getPassword(owner, message)) != null) {
            this.keystore = KeystoreGUI.readKeyStore(this.password, keystoreType, keystoreFile);
            if (this.keystore != null) {
                return true;
            }
            message = CBIntText.get("Password incorrect. Please try again.");
        }
        return false;
    }

    public static char[] getPassword(Component owner, String message) {
        JPasswordField passwordInput = new JPasswordField();
        int response = JOptionPane.showConfirmDialog(owner, passwordInput, message, 2);
        char[] password = response != 0 ? null : passwordInput.getPassword();
        return password;
    }

    private boolean listContains(String aliasName) {
        if (aliasName == null) {
            return false;
        }
        for (int i = 0; i < this.certListModel.size(); ++i) {
            if (!aliasName.equals(((CertItem)this.certListModel.get((int)i)).alias)) continue;
            return true;
        }
        return false;
    }

    protected void addNewCert() {
        CertViewer.CertAndFileName info = CertViewer.loadCertificate(this.owner);
        if (info == null || info.cert == null) {
            return;
        }
        String alias = null;
        if (info.fileName != null && (alias = new File(info.fileName).getName()) != null && alias.indexOf(46) > 0) {
            alias = alias.substring(0, alias.indexOf(46));
        }
        if (alias == null) {
            alias = CBIntText.get("default");
        }
        boolean nameAlreadyExists = false;
        do {
            if (!(nameAlreadyExists = this.listContains(alias = (String)JOptionPane.showInputDialog(this, CBIntText.get("Please enter a short unique name for this Certificate"), CBIntText.get("Enter Certificate Alias"), 3, null, null, alias)))) continue;
            JOptionPane.showMessageDialog(this, CBIntText.get("That name already exists."), CBIntText.get("Duplicate Alias"), 0);
        } while (nameAlreadyExists);
        if (alias == null || alias.length() == 0) {
            return;
        }
        if (!this.checkPassword()) {
            return;
        }
        try {
            this.keystore.setCertificateEntry(alias, info.cert);
            this.refreshView();
            this.changed = true;
            return;
        }
        catch (KeyStoreException e) {
            CBUtility.error(CBIntText.get("Error - unable to add key: {0} from key store", new String[]{alias}), e);
            try {
                this.keystore.deleteEntry(alias);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return;
        }
    }

    protected void refreshView() {
        CertItem[] certs = KeystoreGUI.getKeyStoreCerts(this.keystore);
        if (this.certListModel == null) {
            this.setupCertificateListGUI();
        }
        this.certListModel.removeAllElements();
        for (int i = 0; i < certs.length; ++i) {
            this.certListModel.addElement(certs[i]);
        }
    }

    protected void setupCertificateListGUI() {
        this.certListModel = new DefaultListModel();
        this.certList.setModel(this.certListModel);
        this.certList.setCellRenderer(new CertificateListRenderer());
    }

    protected void setupCertificateList() {
        this.keystore = KeystoreGUI.readKeyStore(this.password, this.keystoreType, this.keystoreFile);
        this.setupCertificateListGUI();
        if (this.keystore == null) {
            JOptionPane.showMessageDialog(this, CBIntText.get("Unable to find/open keystore: {0}", new String[]{this.keystoreFile}), CBIntText.get("Error: no Keystore"), 0);
        } else {
            this.refreshView();
        }
    }

    protected void setupPasswords() {
        PasswordDialog newPassword = new PasswordDialog(this.owner);
        while (!newPassword.wasCancelled()) {
            char[] newPass2;
            newPassword.setVisible(true);
            if (newPassword.wasCancelled()) {
                return;
            }
            char[] oldPass = newPassword.old.getPassword();
            char[] newPass1 = newPassword.new1.getPassword();
            if (Arrays.equals(newPass1, newPass2 = newPassword.new2.getPassword())) {
                KeyStore newKeystore = KeystoreGUI.readKeyStore(oldPass, this.keystoreType, this.keystoreFile);
                if (newKeystore != null) {
                    if (!KeystoreGUI.writeKeyStore(newPass1, newKeystore, this.keystoreFile, this.keystoreType)) continue;
                    this.keystore = newKeystore;
                    this.password = newPass1;
                    JOptionPane.showMessageDialog(this, CBIntText.get("Passwords successfully changed!"), CBIntText.get("Success!"), 1);
                    return;
                }
                CBUtility.error(CBIntText.get("Unable to change password - incorrect password entered?"));
                continue;
            }
            CBUtility.error(CBIntText.get("The new passwords were not identical!"), null);
        }
    }

    protected void clearPassword(char[] c) {
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                c[i] = '\u0000';
            }
        }
    }

    public static CertItem[] getKeyStoreCerts(KeyStore keystore) {
        try {
            Vector<CertItem> certVector = new Vector<CertItem>(10);
            Enumeration<String> a = keystore.aliases();
            while (a.hasMoreElements()) {
                X509Certificate userCert;
                String alias = a.nextElement();
                CertItem item = new CertItem(alias);
                if (keystore.isKeyEntry(alias)) {
                    userCert = (X509Certificate)keystore.getCertificate(alias);
                    item.addX509Cert(userCert);
                    item.setHasPrivateKey(true);
                } else {
                    userCert = (X509Certificate)keystore.getCertificate(alias);
                    item.addX509Cert(userCert);
                }
                certVector.add(item);
            }
            return certVector.toArray(new CertItem[0]);
        }
        catch (Exception e) {
            CBUtility.error(CBIntText.get("Error reading certificate from keystore."), e);
            return null;
        }
    }

    public static KeyStore readKeyStore(char[] pass, String storeType, String keyFile) {
        try {
            KeyStore keystore = KeyStore.getInstance(storeType);
            FileInputStream fis = new FileInputStream(keyFile);
            keystore.load(fis, pass);
            fis.close();
            return keystore;
        }
        catch (Exception e) {
            CBUtility.error(CBIntText.get("Error opening certificate keystore {0}.  Probably an incorrect password", new String[]{keyFile}), e);
            return null;
        }
    }

    public static boolean writeKeyStore(char[] password, KeyStore keystore, String keyFile, String keystoreType) {
        if ("KSE".equalsIgnoreCase(keystoreType)) {
            CertItem[] certs = KeystoreGUI.getKeyStoreCerts(keystore);
            if (certs.length > 2) {
                return KeystoreGUI.givePKCS12ErrorMsg(CBIntText.get("This PKCS12 File can only have one certificate, one key, and one CA certificate"));
            }
            if (certs.length == 2 && certs[0].hasPrivateKey && certs[1].hasPrivateKey) {
                return KeystoreGUI.givePKCS12ErrorMsg(CBIntText.get("This PKCS12 File can only have one certificate, one key, and one CA certificate"));
            }
        }
        FileOutputStream fos = null;
        try {
            if (password == null) {
                throw new KeyStoreException("null password not allowed");
            }
            fos = new FileOutputStream(keyFile);
            keystore.store(fos, password);
            fos.close();
            return true;
        }
        catch (Exception e) {
            CBUtility.error(CBIntText.get("Error saving certificate keystore.") + "\n" + CBIntText.get("Probably an invalid password"), e);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static boolean givePKCS12ErrorMsg(String msg) {
        CBUtility.error(msg);
        return false;
    }

    public ImageIcon getImageIcon(String name) {
        ImageIcon newIcon = new ImageIcon(this.properties.getProperty("dir.images") + name);
        return newIcon;
    }

    private static void printUsageAndExit() {
        System.out.println("USAGE: java KeystoreGUI [keystore file|path] [keystore password] [keystore type] [provider]\n(defaults are 'security/clientcerts' and 'jks'");
        System.exit(0);
    }

    public static void main(String[] argsv) {
        String keystoreType = "jks";
        String provider = null;
        String password = null;
        Frame rootFrame = new Frame();
        CBUtility.initDefaultDisplay(rootFrame);
        System.out.println("running KeystoreGUI 1.0 stand alone demo - Chris Betts 2002\n");
        String localDir = System.getProperty("user.dir") + File.separator;
        Properties props = new Properties();
        props.setProperty("cert.homeDir", localDir + "certs" + File.separator);
        props.setProperty("dir.images", localDir + "images" + File.separator);
        String keystoreName = localDir + "security" + File.separator + "clientcerts";
        if (argsv.length < 1) {
            KeystoreGUI.printUsageAndExit();
        }
        if (argsv[0].startsWith("-h")) {
            KeystoreGUI.printUsageAndExit();
        }
        keystoreName = argsv[0].length() < 2 ? argsv[0] : (argsv[0].charAt(1) == ':' || argsv[0].charAt(0) == '/' ? argsv[0] : localDir + argsv[0]);
        if (argsv.length > 1) {
            password = argsv[1];
        }
        if (argsv.length > 2) {
            keystoreType = argsv[2];
        }
        if (argsv.length > 3) {
            provider = argsv[3];
            try {
                Class<?> providerClass = Class.forName(provider);
                Provider providerObject = (Provider)providerClass.newInstance();
                Security.insertProviderAt(providerObject, 1);
                System.out.println("\nPROVIDER: " + providerObject.getName() + " v" + providerObject.getVersion() + " has been registered ");
            }
            catch (Exception e) {
                System.err.println("\n*** unable to load new security provider: " + (provider == null ? "null" : provider));
                System.err.println(e + "\n");
                KeystoreGUI.printUsageAndExit();
            }
        }
        Provider[] current = Security.getProviders();
        for (int i = 0; i < current.length; ++i) {
            System.out.println("registered security providers: " + i + " = " + current[i].getName() + " " + current[i].getInfo());
        }
        char[] pwd = null;
        class StandaloneKeystore
        extends KeystoreGUI {
            public StandaloneKeystore(Frame owner, Properties props, String keyStoreLocation, char[] pwd, String keystoreType, String title, boolean handlePrivateKeys, String helpTopic) {
                super(owner, props, keyStoreLocation, pwd, keystoreType, title, handlePrivateKeys, helpTopic);
            }

            public void doOK() {
                super.doOK();
                System.exit(0);
            }

            public void doCancel() {
                super.doCancel();
                System.exit(0);
            }
        }
        StandaloneKeystore gui = new StandaloneKeystore(rootFrame, props, keystoreName, pwd, keystoreType, "CB Keystore GUI Demo", true, null);
        gui.setSize(450, 440);
        CBUtility.center(gui, null);
        gui.setVisible(true);
    }

    static {
        log = Logger.getLogger(KeystoreGUI.class.getName());
    }

    class CertificateListRenderer
    extends JLabel
    implements ListCellRenderer {
        Color highlight = new Color(0, 0, 128);

        CertificateListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof CertItem)) {
                System.err.println("Rendering error in KeystoreGUI");
                this.setText(KeystoreGUI.ERRORCERT);
                return this;
            }
            if (index == -1 && (index = list.getSelectedIndex()) == -1) {
                this.setText("<error>");
                return this;
            }
            if (value == null) {
                this.setBackground(Color.white);
                this.setForeground(Color.gray);
                this.setText(KeystoreGUI.DELETEDCERT);
                return this;
            }
            CertItem item = (CertItem)value;
            this.setIcon(item.getIcon());
            if (isSelected) {
                this.setText(item.getSelectedText());
                this.setBackground(this.highlight);
                this.setForeground(Color.white);
            } else {
                this.setText(item.toString());
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    public static class CertItem {
        public String alias;
        public X509Certificate x509Cert = null;
        public boolean hasPrivateKey = false;

        public CertItem(String certAlias) {
            this(certAlias, null);
        }

        public CertItem(String certAlias, X509Certificate cert) {
            this.alias = certAlias;
            this.x509Cert = cert;
        }

        public void addX509Cert(X509Certificate x) {
            this.x509Cert = x;
        }

        public String toString() {
            if (this.hasPrivateKey) {
                return "<html><b><font color=black>" + this.alias + "</font><br><font color=blue>(has private key)</font></b></html>";
            }
            return this.alias;
        }

        public String getSelectedText() {
            if (this.hasPrivateKey) {
                return "<html><b><font color=white>" + this.alias + "</font><br><font color=white>(has private key)</font></b></html>";
            }
            return this.alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public ImageIcon getIcon() {
            if (this.hasPrivateKey) {
                return smallKeyCert;
            }
            return smallCert;
        }

        public X509Certificate getX509Cert() {
            return this.x509Cert;
        }

        public void setHasPrivateKey(boolean state) {
            this.hasPrivateKey = state;
        }

        public boolean getHasPrivateKey() {
            return this.hasPrivateKey;
        }
    }

    public class PasswordDialog
    extends CBDialog {
        public JPasswordField old;
        public JPasswordField new1;
        public JPasswordField new2;

        public PasswordDialog(Frame owner) {
            super(owner, CBIntText.get("Change the Key Store Password."), null);
            this.addln(new JLabel(KeystoreGUI.this.getImageIcon("sslpassword.gif")));
            this.addln(new JLabel(CBIntText.get("This screen allows you to enter")));
            this.addln(new JLabel(CBIntText.get("a new key store password")));
            this.addln(new JLabel(" "));
            this.addln(new JLabel(CBIntText.get("Enter the old password")));
            this.old = new JPasswordField();
            this.addln(this.old);
            this.addln(new JLabel(CBIntText.get("The new Password") + ":"));
            this.new1 = new JPasswordField();
            this.addln(this.new1);
            this.addln(new JLabel(CBIntText.get("Confirm the new Password") + ":"));
            this.new2 = new JPasswordField();
            this.addln(this.new2);
            this.setSize(240, 320);
            CBUtility.center(this, owner);
        }
    }
}

