/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.findusages;

import com.almworks.tracklink.findusages.FindUsagesSettings;
import com.almworks.tracklink.util.ItemAdapter;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.almworks.tracklink.vcslinks.cache.VCSCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.GuiUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class FindUsagesActionUtil {
    private static FindUsagesSettings ourSettings = new FindUsagesSettings();

    public static FindUsagesSettings getDefaultFindUsagesSettings() {
        return ourSettings;
    }

    public static void setDefaultFindUsagesSettings(FindUsagesSettings settings) {
        ourSettings = settings;
    }

    static FindUsagesSettings getFindUsageSettings(Project project, String ... url) {
        UsageTypeDialogWrapper wrapper = new UsageTypeDialogWrapper(project, url);
        wrapper.show();
        return ourSettings;
    }

    private static class UsageTypeDialogWrapper
    extends DialogWrapper {
        private final JCheckBox myCodeCheckbox = new JCheckBox(StringBundle.get("find.dialog.codelinks", new Object[0]), FindUsagesActionUtil.access$000().needSearchInCode());
        private final JCheckBox myVcsCheckbox = new JCheckBox(StringBundle.get("find.dialog.vcslinks", new Object[0]), FindUsagesActionUtil.access$000().needSearchInVCS());
        private final JCheckBox myRefreshCheckbox = new JCheckBox(StringBundle.get("find.dialog.refresh", new Object[0]), false);
        private final JCheckBox myOpenInNewTabCheckbox = new JCheckBox(StringBundle.get("find.dialog.openInNewTab", new Object[0]), FindUsagesActionUtil.access$000().openInNewTab());
        private final String[] myURL;
        private final ItemListener myItemListener = new ItemAdapter(){

            protected void fireSelected(boolean isSelected) {
                UsageTypeDialogWrapper.this.checkOKAction();
            }
        };
        private JPanel myPanel;
        private final JLabel myLastRefresh = new JLabel();

        public UsageTypeDialogWrapper(Project project, String[] url) {
            super(project, true);
            this.myURL = url;
            this.myCodeCheckbox.setMnemonic(StringBundle.get("find.dialog.codelinks.mnemonic", new Object[0]).charAt(0));
            this.myVcsCheckbox.setMnemonic(StringBundle.get("find.dialog.vcslinks.mnemonic", new Object[0]).charAt(0));
            this.myRefreshCheckbox.setMnemonic(StringBundle.get("find.dialog.refresh.mnemonic", new Object[0]).charAt(0));
            this.myOpenInNewTabCheckbox.setMnemonic(StringBundle.get("find.dialog.openInNewTab.mnemonic", new Object[0]).charAt(0));
            this.myCodeCheckbox.addItemListener(this.myItemListener);
            this.myVcsCheckbox.addItemListener(this.myItemListener);
            this.setTitle(StringBundle.get("find.dialog.title", new Object[0]));
            VCSCache vcsCache = Utils.getVCSCache(project);
            this.myRefreshCheckbox.setSelected(vcsCache.isUpdateNeeded());
            long lastUpdateTime = vcsCache.getLastUpdateTime();
            String labelText = lastUpdateTime <= 0L ? StringBundle.get("find.dialog.last.refresh.never", new Object[0]) : (lastUpdateTime / 86400000L == System.currentTimeMillis() / 86400000L ? StringBundle.get("find.dialog.last.refresh.today", new Date(lastUpdateTime)) : StringBundle.get("find.dialog.last.refresh.otherday", new Date(lastUpdateTime)));
            this.myLastRefresh.setText(labelText);
            this.init();
            this.pack();
            this.checkOKAction();
        }

        private void checkOKAction() {
            this.setOKActionEnabled(this.myCodeCheckbox.isSelected() || this.myVcsCheckbox.isSelected());
            this.myRefreshCheckbox.setEnabled(this.myVcsCheckbox.isSelected());
            this.myLastRefresh.setEnabled(this.myVcsCheckbox.isSelected());
        }

        protected void dispose() {
            this.myCodeCheckbox.removeItemListener(this.myItemListener);
            this.myVcsCheckbox.removeItemListener(this.myItemListener);
            if (this.getExitCode() == 0) {
                ourSettings.mySearchInCode = this.myCodeCheckbox.isSelected();
                ourSettings.mySearchInVCS = this.myVcsCheckbox.isSelected();
                ourSettings.myOpenInNewTab = this.myOpenInNewTabCheckbox.isSelected();
                ourSettings.myRefresh = this.myRefreshCheckbox.isSelected();
            }
            super.dispose();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myPanel;
        }

        protected Action getOKAction() {
            Action okAction = super.getOKAction();
            okAction.putValue("Name", StringBundle.get("find.dialog.okbutton", new Object[0]));
            okAction.putValue("SmallIcon", IconLoader.getIcon((String)"/actions/find.png"));
            return okAction;
        }

        public boolean isOKActionEnabled() {
            return this.myCodeCheckbox.isSelected() || this.myVcsCheckbox.isSelected();
        }

        protected JComponent createCenterPanel() {
            Box find = Box.createVerticalBox();
            Box options = Box.createVerticalBox();
            this.enbox(find, this.myCodeCheckbox, 0.0f, 0);
            this.enbox(find, this.myVcsCheckbox, 0.0f, 0);
            this.enbox(options, this.myRefreshCheckbox, 0.0f, 0);
            this.enbox(options, this.myLastRefresh, 0.0f, 10);
            JPanel titledFind = GuiUtils.makeTitledPanel((JComponent)find, (String)StringBundle.get("find.dialog.find.bordertitle", new Object[0]));
            JPanel titledOptions = GuiUtils.makeTitledPanel((JComponent)options, (String)StringBundle.get("find.dialog.options.bordertitle", new Object[0]));
            JPanel panel = new JPanel(GuiUtils.createGridLayout((int)1, (int)2));
            panel.add(titledFind);
            panel.add(titledOptions);
            this.myPanel = new JPanel(GuiUtils.createBorderLayout());
            JLabel messageLabel = new JLabel(this.myURL.length == 1 ? StringBundle.get("find.dialog.message", this.myURL[0]) : StringBundle.get("find.dialog.multimessage", new Object[0]));
            JPanel bottomPanel = new JPanel(new FlowLayout(2, 0, 0));
            bottomPanel.add(this.myOpenInNewTabCheckbox);
            this.myPanel.add((Component)messageLabel, "North");
            this.myPanel.add((Component)panel, "Center");
            this.myPanel.add((Component)bottomPanel, "South");
            return this.myPanel;
        }

        private void enbox(Box options, JComponent component, float alignmentX, int indent) {
            Border border = component.getBorder();
            EmptyBorder wrapper = new EmptyBorder(2, indent, 2, 0);
            AbstractBorder newBorder = border == null ? wrapper : new CompoundBorder(wrapper, border);
            component.setBorder(newBorder);
            component.setAlignmentX(alignmentX);
            options.add(component);
        }
    }
}

