/*
 * Copyright © 2023 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 */

#ifndef INTEL_WA_H
#define INTEL_WA_H

#include "util/macros.h"

#ifdef __cplusplus
extern "C" {
#endif

struct intel_device_info;
void intel_device_info_init_was(struct intel_device_info *devinfo);

enum intel_wa_steppings {
   INTEL_STEPPING_A0,
   INTEL_STEPPING_B0,
   INTEL_STEPPING_C0,
   INTEL_STEPPING_RELEASE
};

enum intel_workaround_id {
   INTEL_WA_220579888,
   INTEL_WA_1305770284,
   INTEL_WA_1306055483,
   INTEL_WA_1306463417,
   INTEL_WA_1405543622,
   INTEL_WA_1405586840,
   INTEL_WA_1406306137,
   INTEL_WA_1406337848,
   INTEL_WA_1406606421,
   INTEL_WA_1406609750,
   INTEL_WA_1406614636,
   INTEL_WA_1406697149,
   INTEL_WA_1406756463,
   INTEL_WA_1406950495,
   INTEL_WA_1407240128,
   INTEL_WA_1407528679,
   INTEL_WA_1407685933,
   INTEL_WA_1408224581,
   INTEL_WA_1408264532,
   INTEL_WA_1408556878,
   INTEL_WA_1408908852,
   INTEL_WA_1409392000,
   INTEL_WA_1409600907,
   INTEL_WA_1508744258,
   INTEL_WA_1509820217,
   INTEL_WA_1604061319,
   INTEL_WA_1604366864,
   INTEL_WA_1605967699,
   INTEL_WA_1606932921,
   INTEL_WA_1607446692,
   INTEL_WA_1607610283,
   INTEL_WA_1607794140,
   INTEL_WA_1607854226,
   INTEL_WA_1607956946,
   INTEL_WA_1805811773,
   INTEL_WA_1805992985,
   INTEL_WA_1806068545,
   INTEL_WA_1806230709,
   INTEL_WA_1806527549,
   INTEL_WA_1806565034,
   INTEL_WA_1808121037,
   INTEL_WA_1808850743,
   INTEL_WA_1809626530,
   INTEL_WA_2201039848,
   INTEL_WA_14010013414,
   INTEL_WA_14010017096,
   INTEL_WA_14010755945,
   INTEL_WA_14010840176,
   INTEL_WA_14010915640,
   INTEL_WA_14012437816,
   INTEL_WA_14012688258,
   INTEL_WA_14013111325,
   INTEL_WA_14013672992,
   INTEL_WA_14014063774,
   INTEL_WA_14014097488,
   INTEL_WA_14014176256,
   INTEL_WA_14014414195,
   INTEL_WA_14014595444,
   INTEL_WA_14014617373,
   INTEL_WA_14014851047,
   INTEL_WA_14015055625,
   INTEL_WA_14015360517,
   INTEL_WA_14015420481,
   INTEL_WA_14015782607,
   INTEL_WA_14015868140,
   INTEL_WA_14015907227,
   INTEL_WA_14016074189,
   INTEL_WA_14016243945,
   INTEL_WA_14016407139,
   INTEL_WA_14016712196,
   INTEL_WA_14016896531,
   INTEL_WA_14017240301,
   INTEL_WA_14017245111,
   INTEL_WA_14017468336,
   INTEL_WA_14018126777,
   INTEL_WA_14018545335,
   INTEL_WA_14018912822,
   INTEL_WA_14019028097,
   INTEL_WA_15011116421,
   INTEL_WA_16010655327,
   INTEL_WA_16011107343,
   INTEL_WA_16011411144,
   INTEL_WA_16011448509,
   INTEL_WA_16011478345,
   INTEL_WA_16011627967,
   INTEL_WA_16011773973,
   INTEL_WA_16012775297,
   INTEL_WA_16013000631,
   INTEL_WA_16013063087,
   INTEL_WA_16013994831,
   INTEL_WA_16014390852,
   INTEL_WA_16014538804,
   INTEL_WA_16014912113,
   INTEL_WA_16016015852,
   INTEL_WA_16018063123,
   INTEL_WA_18012201914,
   INTEL_WA_18012660806,
   INTEL_WA_18013179988,
   INTEL_WA_18013889147,
   INTEL_WA_18019110168,
   INTEL_WA_18019816803,
   INTEL_WA_18020335297,
   INTEL_WA_18020603990,
   INTEL_WA_18022330953,
   INTEL_WA_18022502561,
   INTEL_WA_18022508906,
   INTEL_WA_18023881693,
   INTEL_WA_22010893396,
   INTEL_WA_22011186057,
   INTEL_WA_22011440098,
   INTEL_WA_22011782311,
   INTEL_WA_22012699309,
   INTEL_WA_22012725308,
   INTEL_WA_22013045878,
   INTEL_WA_22013073587,
   INTEL_WA_22013689345,
   INTEL_WA_22014344549,
   INTEL_WA_22014412737,
   INTEL_WA_22015614752,
   INTEL_WA_NUM
};

/* These defines are used to identify when a workaround potentially applies
 * in genxml code.  They should not be used directly. intel_needs_workaround()
 * checks these definitions to eliminate bitset tests at compile time.
 */
#define INTEL_WA_220579888_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1305770284_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1306055483_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1306463417_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1405543622_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1405586840_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1406306137_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1406337848_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1406606421_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1406609750_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1406614636_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1406697149_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1406756463_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1406950495_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1407240128_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1407528679_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1407685933_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1408224581_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1408264532_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1408556878_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1408908852_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1409392000_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1409600907_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1508744258_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1509820217_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_1604061319_GFX_VER ((GFX_VERx10 == 110) || (GFX_VERx10 == 120))
#define INTEL_WA_1604366864_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1605967699_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1606932921_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1607446692_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1607610283_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1607794140_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1607854226_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1607956946_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1805811773_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1805992985_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1806068545_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1806230709_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_1806527549_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1806565034_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1808121037_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1808850743_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_1809626530_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_2201039848_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_14010013414_GFX_VER ((GFX_VERx10 == 110) || (GFX_VERx10 == 120))
#define INTEL_WA_14010017096_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_14010755945_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14010840176_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_14010915640_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_14012437816_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14012688258_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14013111325_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_14013672992_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14014063774_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14014097488_GFX_VER ((GFX_VERx10 == 110) || (GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14014176256_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14014414195_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14014595444_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14014617373_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_14014851047_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14015055625_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14015360517_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14015420481_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14015782607_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14015868140_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14015907227_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14016074189_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14016243945_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14016407139_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14016712196_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14016896531_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14017240301_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14017245111_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14017468336_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14018126777_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_14018545335_GFX_VER ((GFX_VERx10 == 110) || (GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_14018912822_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_14019028097_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_15011116421_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16010655327_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_16011107343_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_16011411144_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16011448509_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_16011478345_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_16011627967_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16011773973_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16012775297_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16013000631_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16013063087_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16013994831_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_16014390852_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16014538804_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16014912113_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_16016015852_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_16018063123_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18012201914_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18012660806_GFX_VER ((GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_18013179988_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18013889147_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_18019110168_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18019816803_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18020335297_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18020603990_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_18022330953_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_18022502561_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_18022508906_GFX_VER ((GFX_VERx10 == 110) || (GFX_VERx10 == 120) || (GFX_VERx10 == 125))
#define INTEL_WA_18023881693_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22010893396_GFX_VER (GFX_VERx10 == 110)
#define INTEL_WA_22011186057_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_22011440098_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22011782311_GFX_VER (GFX_VERx10 == 120)
#define INTEL_WA_22012699309_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22012725308_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22013045878_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22013073587_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22013689345_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22014344549_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22014412737_GFX_VER (GFX_VERx10 == 125)
#define INTEL_WA_22015614752_GFX_VER (GFX_VERx10 == 125)

/* These defines are suitable for use to compile out genxml code using #if
 * guards.  Workarounds that apply to part of a generation must use a
 * combination of run time checks and INTEL_WA_{NUM}_GFX_VER macros.  Those
 * workarounds are 'poisoned' below.
 */
#define INTEL_NEEDS_WA_220579888 INTEL_WA_220579888_GFX_VER
#define INTEL_NEEDS_WA_1305770284 INTEL_WA_1305770284_GFX_VER
#define INTEL_NEEDS_WA_1306055483 INTEL_WA_1306055483_GFX_VER
#define INTEL_NEEDS_WA_1306463417 INTEL_WA_1306463417_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1405543622)
PRAGMA_POISON(INTEL_NEEDS_WA_1405586840)
#define INTEL_NEEDS_WA_1406306137 INTEL_WA_1406306137_GFX_VER
#define INTEL_NEEDS_WA_1406337848 INTEL_WA_1406337848_GFX_VER
#define INTEL_NEEDS_WA_1406606421 INTEL_WA_1406606421_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1406609750)
#define INTEL_NEEDS_WA_1406614636 INTEL_WA_1406614636_GFX_VER
#define INTEL_NEEDS_WA_1406697149 INTEL_WA_1406697149_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1406756463)
#define INTEL_NEEDS_WA_1406950495 INTEL_WA_1406950495_GFX_VER
#define INTEL_NEEDS_WA_1407240128 INTEL_WA_1407240128_GFX_VER
#define INTEL_NEEDS_WA_1407528679 INTEL_WA_1407528679_GFX_VER
#define INTEL_NEEDS_WA_1407685933 INTEL_WA_1407685933_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1408224581)
#define INTEL_NEEDS_WA_1408264532 INTEL_WA_1408264532_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1408556878)
#define INTEL_NEEDS_WA_1408908852 INTEL_WA_1408908852_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1409392000)
#define INTEL_NEEDS_WA_1409600907 INTEL_WA_1409600907_GFX_VER
#define INTEL_NEEDS_WA_1508744258 INTEL_WA_1508744258_GFX_VER
#define INTEL_NEEDS_WA_1509820217 INTEL_WA_1509820217_GFX_VER
#define INTEL_NEEDS_WA_1604061319 INTEL_WA_1604061319_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1604366864)
PRAGMA_POISON(INTEL_NEEDS_WA_1605967699)
#define INTEL_NEEDS_WA_1606932921 INTEL_WA_1606932921_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1607446692)
PRAGMA_POISON(INTEL_NEEDS_WA_1607610283)
PRAGMA_POISON(INTEL_NEEDS_WA_1607794140)
#define INTEL_NEEDS_WA_1607854226 INTEL_WA_1607854226_GFX_VER
#define INTEL_NEEDS_WA_1607956946 INTEL_WA_1607956946_GFX_VER
#define INTEL_NEEDS_WA_1805811773 INTEL_WA_1805811773_GFX_VER
#define INTEL_NEEDS_WA_1805992985 INTEL_WA_1805992985_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1806068545)
#define INTEL_NEEDS_WA_1806230709 INTEL_WA_1806230709_GFX_VER
#define INTEL_NEEDS_WA_1806527549 INTEL_WA_1806527549_GFX_VER
#define INTEL_NEEDS_WA_1806565034 INTEL_WA_1806565034_GFX_VER
#define INTEL_NEEDS_WA_1808121037 INTEL_WA_1808121037_GFX_VER
#define INTEL_NEEDS_WA_1808850743 INTEL_WA_1808850743_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_1809626530)
#define INTEL_NEEDS_WA_2201039848 INTEL_WA_2201039848_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14010013414)
#define INTEL_NEEDS_WA_14010017096 INTEL_WA_14010017096_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14010755945)
#define INTEL_NEEDS_WA_14010840176 INTEL_WA_14010840176_GFX_VER
#define INTEL_NEEDS_WA_14010915640 INTEL_WA_14010915640_GFX_VER
#define INTEL_NEEDS_WA_14012437816 INTEL_WA_14012437816_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14012688258)
#define INTEL_NEEDS_WA_14013111325 INTEL_WA_14013111325_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14013672992)
#define INTEL_NEEDS_WA_14014063774 INTEL_WA_14014063774_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14014097488)
#define INTEL_NEEDS_WA_14014176256 INTEL_WA_14014176256_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14014414195)
#define INTEL_NEEDS_WA_14014595444 INTEL_WA_14014595444_GFX_VER
#define INTEL_NEEDS_WA_14014617373 INTEL_WA_14014617373_GFX_VER
#define INTEL_NEEDS_WA_14014851047 INTEL_WA_14014851047_GFX_VER
#define INTEL_NEEDS_WA_14015055625 INTEL_WA_14015055625_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14015360517)
#define INTEL_NEEDS_WA_14015420481 INTEL_WA_14015420481_GFX_VER
#define INTEL_NEEDS_WA_14015782607 INTEL_WA_14015782607_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14015868140)
PRAGMA_POISON(INTEL_NEEDS_WA_14015907227)
PRAGMA_POISON(INTEL_NEEDS_WA_14016074189)
PRAGMA_POISON(INTEL_NEEDS_WA_14016243945)
PRAGMA_POISON(INTEL_NEEDS_WA_14016407139)
PRAGMA_POISON(INTEL_NEEDS_WA_14016712196)
PRAGMA_POISON(INTEL_NEEDS_WA_14016896531)
PRAGMA_POISON(INTEL_NEEDS_WA_14017240301)
PRAGMA_POISON(INTEL_NEEDS_WA_14017245111)
#define INTEL_NEEDS_WA_14017468336 INTEL_WA_14017468336_GFX_VER
#define INTEL_NEEDS_WA_14018126777 INTEL_WA_14018126777_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_14018545335)
PRAGMA_POISON(INTEL_NEEDS_WA_14018912822)
PRAGMA_POISON(INTEL_NEEDS_WA_14019028097)
#define INTEL_NEEDS_WA_15011116421 INTEL_WA_15011116421_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_16010655327)
#define INTEL_NEEDS_WA_16011107343 INTEL_WA_16011107343_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_16011411144)
#define INTEL_NEEDS_WA_16011448509 INTEL_WA_16011448509_GFX_VER
#define INTEL_NEEDS_WA_16011478345 INTEL_WA_16011478345_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_16011627967)
PRAGMA_POISON(INTEL_NEEDS_WA_16011773973)
#define INTEL_NEEDS_WA_16012775297 INTEL_WA_16012775297_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_16013000631)
#define INTEL_NEEDS_WA_16013063087 INTEL_WA_16013063087_GFX_VER
#define INTEL_NEEDS_WA_16013994831 INTEL_WA_16013994831_GFX_VER
#define INTEL_NEEDS_WA_16014390852 INTEL_WA_16014390852_GFX_VER
#define INTEL_NEEDS_WA_16014538804 INTEL_WA_16014538804_GFX_VER
#define INTEL_NEEDS_WA_16014912113 INTEL_WA_16014912113_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_16016015852)
PRAGMA_POISON(INTEL_NEEDS_WA_16018063123)
PRAGMA_POISON(INTEL_NEEDS_WA_18012201914)
#define INTEL_NEEDS_WA_18012660806 INTEL_WA_18012660806_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_18013179988)
#define INTEL_NEEDS_WA_18013889147 INTEL_WA_18013889147_GFX_VER
#define INTEL_NEEDS_WA_18019110168 INTEL_WA_18019110168_GFX_VER
#define INTEL_NEEDS_WA_18019816803 INTEL_WA_18019816803_GFX_VER
#define INTEL_NEEDS_WA_18020335297 INTEL_WA_18020335297_GFX_VER
#define INTEL_NEEDS_WA_18020603990 INTEL_WA_18020603990_GFX_VER
#define INTEL_NEEDS_WA_18022330953 INTEL_WA_18022330953_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_18022502561)
#define INTEL_NEEDS_WA_18022508906 INTEL_WA_18022508906_GFX_VER
#define INTEL_NEEDS_WA_18023881693 INTEL_WA_18023881693_GFX_VER
#define INTEL_NEEDS_WA_22010893396 INTEL_WA_22010893396_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_22011186057)
PRAGMA_POISON(INTEL_NEEDS_WA_22011440098)
#define INTEL_NEEDS_WA_22011782311 INTEL_WA_22011782311_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_22012699309)
PRAGMA_POISON(INTEL_NEEDS_WA_22012725308)
PRAGMA_POISON(INTEL_NEEDS_WA_22013045878)
PRAGMA_POISON(INTEL_NEEDS_WA_22013073587)
#define INTEL_NEEDS_WA_22013689345 INTEL_WA_22013689345_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_22014344549)
#define INTEL_NEEDS_WA_22014412737 INTEL_WA_22014412737_GFX_VER
PRAGMA_POISON(INTEL_NEEDS_WA_22015614752)

#define INTEL_ALL_WA \
  INTEL_WA(220579888), \
  INTEL_WA(1305770284), \
  INTEL_WA(1306055483), \
  INTEL_WA(1306463417), \
  INTEL_WA(1405543622), \
  INTEL_WA(1405586840), \
  INTEL_WA(1406306137), \
  INTEL_WA(1406337848), \
  INTEL_WA(1406606421), \
  INTEL_WA(1406609750), \
  INTEL_WA(1406614636), \
  INTEL_WA(1406697149), \
  INTEL_WA(1406756463), \
  INTEL_WA(1406950495), \
  INTEL_WA(1407240128), \
  INTEL_WA(1407528679), \
  INTEL_WA(1407685933), \
  INTEL_WA(1408224581), \
  INTEL_WA(1408264532), \
  INTEL_WA(1408556878), \
  INTEL_WA(1408908852), \
  INTEL_WA(1409392000), \
  INTEL_WA(1409600907), \
  INTEL_WA(1508744258), \
  INTEL_WA(1509820217), \
  INTEL_WA(1604061319), \
  INTEL_WA(1604366864), \
  INTEL_WA(1605967699), \
  INTEL_WA(1606932921), \
  INTEL_WA(1607446692), \
  INTEL_WA(1607610283), \
  INTEL_WA(1607794140), \
  INTEL_WA(1607854226), \
  INTEL_WA(1607956946), \
  INTEL_WA(1805811773), \
  INTEL_WA(1805992985), \
  INTEL_WA(1806068545), \
  INTEL_WA(1806230709), \
  INTEL_WA(1806527549), \
  INTEL_WA(1806565034), \
  INTEL_WA(1808121037), \
  INTEL_WA(1808850743), \
  INTEL_WA(1809626530), \
  INTEL_WA(2201039848), \
  INTEL_WA(14010013414), \
  INTEL_WA(14010017096), \
  INTEL_WA(14010755945), \
  INTEL_WA(14010840176), \
  INTEL_WA(14010915640), \
  INTEL_WA(14012437816), \
  INTEL_WA(14012688258), \
  INTEL_WA(14013111325), \
  INTEL_WA(14013672992), \
  INTEL_WA(14014063774), \
  INTEL_WA(14014097488), \
  INTEL_WA(14014176256), \
  INTEL_WA(14014414195), \
  INTEL_WA(14014595444), \
  INTEL_WA(14014617373), \
  INTEL_WA(14014851047), \
  INTEL_WA(14015055625), \
  INTEL_WA(14015360517), \
  INTEL_WA(14015420481), \
  INTEL_WA(14015782607), \
  INTEL_WA(14015868140), \
  INTEL_WA(14015907227), \
  INTEL_WA(14016074189), \
  INTEL_WA(14016243945), \
  INTEL_WA(14016407139), \
  INTEL_WA(14016712196), \
  INTEL_WA(14016896531), \
  INTEL_WA(14017240301), \
  INTEL_WA(14017245111), \
  INTEL_WA(14017468336), \
  INTEL_WA(14018126777), \
  INTEL_WA(14018545335), \
  INTEL_WA(14018912822), \
  INTEL_WA(14019028097), \
  INTEL_WA(15011116421), \
  INTEL_WA(16010655327), \
  INTEL_WA(16011107343), \
  INTEL_WA(16011411144), \
  INTEL_WA(16011448509), \
  INTEL_WA(16011478345), \
  INTEL_WA(16011627967), \
  INTEL_WA(16011773973), \
  INTEL_WA(16012775297), \
  INTEL_WA(16013000631), \
  INTEL_WA(16013063087), \
  INTEL_WA(16013994831), \
  INTEL_WA(16014390852), \
  INTEL_WA(16014538804), \
  INTEL_WA(16014912113), \
  INTEL_WA(16016015852), \
  INTEL_WA(16018063123), \
  INTEL_WA(18012201914), \
  INTEL_WA(18012660806), \
  INTEL_WA(18013179988), \
  INTEL_WA(18013889147), \
  INTEL_WA(18019110168), \
  INTEL_WA(18019816803), \
  INTEL_WA(18020335297), \
  INTEL_WA(18020603990), \
  INTEL_WA(18022330953), \
  INTEL_WA(18022502561), \
  INTEL_WA(18022508906), \
  INTEL_WA(18023881693), \
  INTEL_WA(22010893396), \
  INTEL_WA(22011186057), \
  INTEL_WA(22011440098), \
  INTEL_WA(22011782311), \
  INTEL_WA(22012699309), \
  INTEL_WA(22012725308), \
  INTEL_WA(22013045878), \
  INTEL_WA(22013073587), \
  INTEL_WA(22013689345), \
  INTEL_WA(22014344549), \
  INTEL_WA(22014412737), \
  INTEL_WA(22015614752), \

#ifdef __cplusplus
}
#endif

#endif /* INTEL_WA_H */
