/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.animation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Random;

class Star {
    private static final Random seed = new Random();
    static final int averageStarWidth = 10;
    static final int averageFallSpeed = 4;
    static final int averageRotationSpeed = 2;
    private static final Color WATER_LIVE_COLOR = new Color(80, 131, 160);
    private final int w;
    private final int h;
    private int radiusX;
    private int radiusY;
    private int maxRadiusX;
    private int maxRadiusY;
    private final Point center = new Point();
    private final int fallSpeed;
    private final boolean orientation;
    private final int[] originalColor = new int[3];
    private final int[] color = new int[this.originalColor.length];
    private int direction;
    private final boolean haveEight;

    Star(int w, int h) {
        this.w = w;
        this.h = h;
        this.createRadiuses();
        this.haveEight = seed.nextBoolean();
        this.center.x = seed.nextInt(w + 1);
        this.center.y = seed.nextInt(h + 1);
        this.fallSpeed = 2 + seed.nextInt(2);
        this.orientation = seed.nextBoolean();
        this.direction = -(1 + seed.nextInt(1));
        if (seed.nextInt(4) == 0) {
            this.originalColor[0] = Color.yellow.getRed();
            this.originalColor[1] = Color.yellow.getGreen();
            this.originalColor[2] = Color.yellow.getBlue();
        } else {
            this.originalColor[0] = WATER_LIVE_COLOR.getRed();
            this.originalColor[1] = WATER_LIVE_COLOR.getGreen();
            this.originalColor[2] = WATER_LIVE_COLOR.getBlue();
        }
    }

    void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(new Color(this.color[0], this.color[1], this.color[2]));
        Polygon p = this.createPolygon();
        if (this.haveEight) {
            int min1 = Math.min(this.radiusX, this.radiusY);
            int min2 = min1 / 2;
            g.fillRect(this.center.x - min2, this.center.y - min2, min1, min1);
        }
        g.fillPolygon(p);
        g.setColor(c);
    }

    void animate() {
        this.center.y += this.fallSpeed;
        if (this.orientation) {
            this.radiusX += this.direction;
            if (this.radiusX <= -this.direction) {
                this.radiusX = this.direction = -this.direction;
            }
            if (this.radiusX >= this.maxRadiusX) {
                this.direction = -this.direction;
                this.radiusX = this.maxRadiusX;
            }
            this.interpolateColors(this.radiusX, this.maxRadiusX);
        } else {
            this.radiusY += this.direction;
            if (this.radiusY <= -this.direction) {
                this.radiusY = this.direction = -this.direction;
            }
            if (this.radiusY >= this.maxRadiusY) {
                this.direction = -this.direction;
                this.radiusY = this.maxRadiusY;
            }
            this.interpolateColors(this.radiusY, this.maxRadiusY);
        }
        if (this.center.y > this.h + this.radiusX * 2 || this.center.y > this.h + this.radiusY * 2) {
            this.createRadiuses();
            this.center.x = seed.nextInt(this.w + 1);
            this.center.y = -this.radiusY * 2;
        }
    }

    private static int createRadius() {
        return 5 + seed.nextInt(10);
    }

    private Polygon createPolygon() {
        int min = Math.min(this.radiusX, this.radiusY) / 3;
        Polygon p = new Polygon();
        p.addPoint(this.center.x - this.radiusX, this.center.y);
        p.addPoint(this.center.x - min, this.center.y - min);
        p.addPoint(this.center.x, this.center.y - this.radiusY);
        p.addPoint(this.center.x + min, this.center.y - min);
        p.addPoint(this.center.x + this.radiusX, this.center.y);
        p.addPoint(this.center.x + min, this.center.y + min);
        p.addPoint(this.center.x, this.center.y + this.radiusY);
        p.addPoint(this.center.x - min, this.center.y + min);
        return p;
    }

    private void interpolateColors(int is, int max) {
        for (int i = 0; i < this.originalColor.length; ++i) {
            int fadeMin = this.center.y < 0 ? 0 : (this.center.y > this.h ? 255 : (int)Star.interpol(this.h, this.center.y, 255.0, 0.0));
            int fadeMax = this.center.y < 0 ? 0 : (this.center.y > this.h ? this.originalColor[i] : (int)Star.interpol(this.h, this.center.y, this.originalColor[i], 0.0));
            this.color[i] = (int)Star.interpol(max, is, fadeMin, fadeMax);
        }
    }

    private void createRadiuses() {
        this.radiusY = this.radiusX = Star.createRadius();
        switch (seed.nextInt(3)) {
            case 0: {
                this.radiusX += 2 * this.radiusX / 3;
                break;
            }
            case 1: {
                this.radiusY += 2 * this.radiusY / 3;
                break;
            }
        }
        this.maxRadiusX = this.radiusX;
        this.maxRadiusY = this.radiusY;
    }

    static double interpol(double origSize, double currentSize, double from, double to) {
        return currentSize / origSize * (to - from) + from;
    }
}

