; -*- coding: iso-2022-7bit  -*-
;;; ujisx0208.el --- tables between UCS and JIS X 0208-1990

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from JIX0208.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'japanese-jisx0208 'unicode-assoc
     'jis-x-0208-1990-vs-unicode-assoc)

(defvar
  jis-x-0208-1990-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$B!!(B . "0x3000") ;; IDEOGRAPHIC SPACE
       (?$B!"(B . "0x3001") ;; IDEOGRAPHIC COMMA
       (?$B!#(B . "0x3002") ;; IDEOGRAPHIC FULL STOP
       (?$B!$(B . "0xFF0C") ;; FULLWIDTH COMMA
       (?$B!%(B . "0xFF0E") ;; FULLWIDTH FULL STOP
       (?$B!&(B . "0x30FB") ;; KATAKANA MIDDLE DOT
       (?$B!'(B . "0xFF1A") ;; FULLWIDTH COLON
       (?$B!((B . "0xFF1B") ;; FULLWIDTH SEMICOLON
       (?$B!)(B . "0xFF1F") ;; FULLWIDTH QUESTION MARK
       (?$B!*(B . "0xFF01") ;; FULLWIDTH EXCLAMATION MARK
       (?$B!+(B . "0x309B") ;; KATAKANA-HIRAGANA VOICED SOUND MARK
       (?$B!,(B . "0x309C") ;; KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
       (?$B!-(B . "0x00B4") ;; ACUTE ACCENT
       (?$B!.(B . "0xFF40") ;; FULLWIDTH GRAVE ACCENT
       (?$B!/(B . "0x00A8") ;; DIAERESIS
       (?$B!0(B . "0xFF3E") ;; FULLWIDTH CIRCUMFLEX ACCENT
       (?$B!1(B . "0xFFE3") ;; FULLWIDTH MACRON
       (?$B!2(B . "0xFF3F") ;; FULLWIDTH LOW LINE
       (?$B!3(B . "0x30FD") ;; KATAKANA ITERATION MARK
       (?$B!4(B . "0x30FE") ;; KATAKANA VOICED ITERATION MARK
       (?$B!5(B . "0x309D") ;; HIRAGANA ITERATION MARK
       (?$B!6(B . "0x309E") ;; HIRAGANA VOICED ITERATION MARK
       (?$B!7(B . "0x3003") ;; DITTO MARK
       (?$B!8(B . "0x4EDD") ;; <CJK>
       (?$B!9(B . "0x3005") ;; IDEOGRAPHIC ITERATION MARK
       (?$B!:(B . "0x3006") ;; IDEOGRAPHIC CLOSING MARK
       (?$B!;(B . "0x3007") ;; IDEOGRAPHIC NUMBER ZERO
       (?$B!<(B . "0x30FC") ;; KATAKANA-HIRAGANA PROLONGED SOUND MARK
       (?$B!=(B . "0x2015") ;; HORIZONTAL BAR
       (?$B!>(B . "0x2010") ;; HYPHEN
       (?$B!?(B . "0xFF0F") ;; FULLWIDTH SOLIDUS
       (?$B!@(B . "0x005C") ;; REVERSE SOLIDUS
       (?$B!A(B . "0x301C") ;; WAVE DASH
       (?$B!B(B . "0x2016") ;; DOUBLE VERTICAL LINE
       (?$B!C(B . "0xFF5C") ;; FULLWIDTH VERTICAL LINE
       (?$B!D(B . "0x2026") ;; HORIZONTAL ELLIPSIS
       (?$B!E(B . "0x2025") ;; TWO DOT LEADER
       (?$B!F(B . "0x2018") ;; LEFT SINGLE QUOTATION MARK
       (?$B!G(B . "0x2019") ;; RIGHT SINGLE QUOTATION MARK
       (?$B!H(B . "0x201C") ;; LEFT DOUBLE QUOTATION MARK
       (?$B!I(B . "0x201D") ;; RIGHT DOUBLE QUOTATION MARK
       (?$B!J(B . "0xFF08") ;; FULLWIDTH LEFT PARENTHESIS
       (?$B!K(B . "0xFF09") ;; FULLWIDTH RIGHT PARENTHESIS
       (?$B!L(B . "0x3014") ;; LEFT TORTOISE SHELL BRACKET
       (?$B!M(B . "0x3015") ;; RIGHT TORTOISE SHELL BRACKET
       (?$B!N(B . "0xFF3B") ;; FULLWIDTH LEFT SQUARE BRACKET
       (?$B!O(B . "0xFF3D") ;; FULLWIDTH RIGHT SQUARE BRACKET
       (?$B!P(B . "0xFF5B") ;; FULLWIDTH LEFT CURLY BRACKET
       (?$B!Q(B . "0xFF5D") ;; FULLWIDTH RIGHT CURLY BRACKET
       (?$B!R(B . "0x3008") ;; LEFT ANGLE BRACKET
       (?$B!S(B . "0x3009") ;; RIGHT ANGLE BRACKET
       (?$B!T(B . "0x300A") ;; LEFT DOUBLE ANGLE BRACKET
       (?$B!U(B . "0x300B") ;; RIGHT DOUBLE ANGLE BRACKET
       (?$B!V(B . "0x300C") ;; LEFT CORNER BRACKET
       (?$B!W(B . "0x300D") ;; RIGHT CORNER BRACKET
       (?$B!X(B . "0x300E") ;; LEFT WHITE CORNER BRACKET
       (?$B!Y(B . "0x300F") ;; RIGHT WHITE CORNER BRACKET
       (?$B!Z(B . "0x3010") ;; LEFT BLACK LENTICULAR BRACKET
       (?$B![(B . "0x3011") ;; RIGHT BLACK LENTICULAR BRACKET
       (?$B!\(B . "0xFF0B") ;; FULLWIDTH PLUS SIGN
       (?$B!](B . "0x2212") ;; MINUS SIGN
       (?$B!^(B . "0x00B1") ;; PLUS-MINUS SIGN
       (?$B!_(B . "0x00D7") ;; MULTIPLICATION SIGN
       (?$B!`(B . "0x00F7") ;; DIVISION SIGN
       (?$B!a(B . "0xFF1D") ;; FULLWIDTH EQUALS SIGN
       (?$B!b(B . "0x2260") ;; NOT EQUAL TO
       (?$B!c(B . "0xFF1C") ;; FULLWIDTH LESS-THAN SIGN
       (?$B!d(B . "0xFF1E") ;; FULLWIDTH GREATER-THAN SIGN
       (?$B!e(B . "0x2266") ;; LESS-THAN OVER EQUAL TO
       (?$B!f(B . "0x2267") ;; GREATER-THAN OVER EQUAL TO
       (?$B!g(B . "0x221E") ;; INFINITY
       (?$B!h(B . "0x2234") ;; THEREFORE
       (?$B!i(B . "0x2642") ;; MALE SIGN
       (?$B!j(B . "0x2640") ;; FEMALE SIGN
       (?$B!k(B . "0x00B0") ;; DEGREE SIGN
       (?$B!l(B . "0x2032") ;; PRIME
       (?$B!m(B . "0x2033") ;; DOUBLE PRIME
       (?$B!n(B . "0x2103") ;; DEGREE CELSIUS
       (?$B!o(B . "0xFFE5") ;; FULLWIDTH YEN SIGN
       (?$B!p(B . "0xFF04") ;; FULLWIDTH DOLLAR SIGN
       (?$B!q(B . "0x00A2") ;; CENT SIGN
       (?$B!r(B . "0x00A3") ;; POUND SIGN
       (?$B!s(B . "0xFF05") ;; FULLWIDTH PERCENT SIGN
       (?$B!t(B . "0xFF03") ;; FULLWIDTH NUMBER SIGN
       (?$B!u(B . "0xFF06") ;; FULLWIDTH AMPERSAND
       (?$B!v(B . "0xFF0A") ;; FULLWIDTH ASTERISK
       (?$B!w(B . "0xFF20") ;; FULLWIDTH COMMERCIAL AT
       (?$B!x(B . "0x00A7") ;; SECTION SIGN
       (?$B!y(B . "0x2606") ;; WHITE STAR
       (?$B!z(B . "0x2605") ;; BLACK STAR
       (?$B!{(B . "0x25CB") ;; WHITE CIRCLE
       (?$B!|(B . "0x25CF") ;; BLACK CIRCLE
       (?$B!}(B . "0x25CE") ;; BULLSEYE
       (?$B!~(B . "0x25C7") ;; WHITE DIAMOND
       (?$B"!(B . "0x25C6") ;; BLACK DIAMOND
       (?$B""(B . "0x25A1") ;; WHITE SQUARE
       (?$B"#(B . "0x25A0") ;; BLACK SQUARE
       (?$B"$(B . "0x25B3") ;; WHITE UP-POINTING TRIANGLE
       (?$B"%(B . "0x25B2") ;; BLACK UP-POINTING TRIANGLE
       (?$B"&(B . "0x25BD") ;; WHITE DOWN-POINTING TRIANGLE
       (?$B"'(B . "0x25BC") ;; BLACK DOWN-POINTING TRIANGLE
       (?$B"((B . "0x203B") ;; REFERENCE MARK
       (?$B")(B . "0x3012") ;; POSTAL MARK
       (?$B"*(B . "0x2192") ;; RIGHTWARDS ARROW
       (?$B"+(B . "0x2190") ;; LEFTWARDS ARROW
       (?$B",(B . "0x2191") ;; UPWARDS ARROW
       (?$B"-(B . "0x2193") ;; DOWNWARDS ARROW
       (?$B".(B . "0x3013") ;; GETA MARK
       (?$B":(B . "0x2208") ;; ELEMENT OF
       (?$B";(B . "0x220B") ;; CONTAINS AS MEMBER
       (?$B"<(B . "0x2286") ;; SUBSET OF OR EQUAL TO
       (?$B"=(B . "0x2287") ;; SUPERSET OF OR EQUAL TO
       (?$B">(B . "0x2282") ;; SUBSET OF
       (?$B"?(B . "0x2283") ;; SUPERSET OF
       (?$B"@(B . "0x222A") ;; UNION
       (?$B"A(B . "0x2229") ;; INTERSECTION
       (?$B"J(B . "0x2227") ;; LOGICAL AND
       (?$B"K(B . "0x2228") ;; LOGICAL OR
       (?$B"L(B . "0x00AC") ;; NOT SIGN
       (?$B"M(B . "0x21D2") ;; RIGHTWARDS DOUBLE ARROW
       (?$B"N(B . "0x21D4") ;; LEFT RIGHT DOUBLE ARROW
       (?$B"O(B . "0x2200") ;; FOR ALL
       (?$B"P(B . "0x2203") ;; THERE EXISTS
       (?$B"\(B . "0x2220") ;; ANGLE
       (?$B"](B . "0x22A5") ;; UP TACK
       (?$B"^(B . "0x2312") ;; ARC
       (?$B"_(B . "0x2202") ;; PARTIAL DIFFERENTIAL
       (?$B"`(B . "0x2207") ;; NABLA
       (?$B"a(B . "0x2261") ;; IDENTICAL TO
       (?$B"b(B . "0x2252") ;; APPROXIMATELY EQUAL TO OR THE IMAGE OF
       (?$B"c(B . "0x226A") ;; MUCH LESS-THAN
       (?$B"d(B . "0x226B") ;; MUCH GREATER-THAN
       (?$B"e(B . "0x221A") ;; SQUARE ROOT
       (?$B"f(B . "0x223D") ;; REVERSED TILDE
       (?$B"g(B . "0x221D") ;; PROPORTIONAL TO
       (?$B"h(B . "0x2235") ;; BECAUSE
       (?$B"i(B . "0x222B") ;; INTEGRAL
       (?$B"j(B . "0x222C") ;; DOUBLE INTEGRAL
       (?$B"r(B . "0x212B") ;; ANGSTROM SIGN
       (?$B"s(B . "0x2030") ;; PER MILLE SIGN
       (?$B"t(B . "0x266F") ;; MUSIC SHARP SIGN
       (?$B"u(B . "0x266D") ;; MUSIC FLAT SIGN
       (?$B"v(B . "0x266A") ;; EIGHTH NOTE
       (?$B"w(B . "0x2020") ;; DAGGER
       (?$B"x(B . "0x2021") ;; DOUBLE DAGGER
       (?$B"y(B . "0x00B6") ;; PILCROW SIGN
       (?$B"~(B . "0x25EF") ;; LARGE CIRCLE
       (?$B#0(B . "0xFF10") ;; FULLWIDTH DIGIT ZERO
       (?$B#1(B . "0xFF11") ;; FULLWIDTH DIGIT ONE
       (?$B#2(B . "0xFF12") ;; FULLWIDTH DIGIT TWO
       (?$B#3(B . "0xFF13") ;; FULLWIDTH DIGIT THREE
       (?$B#4(B . "0xFF14") ;; FULLWIDTH DIGIT FOUR
       (?$B#5(B . "0xFF15") ;; FULLWIDTH DIGIT FIVE
       (?$B#6(B . "0xFF16") ;; FULLWIDTH DIGIT SIX
       (?$B#7(B . "0xFF17") ;; FULLWIDTH DIGIT SEVEN
       (?$B#8(B . "0xFF18") ;; FULLWIDTH DIGIT EIGHT
       (?$B#9(B . "0xFF19") ;; FULLWIDTH DIGIT NINE
       (?$B#A(B . "0xFF21") ;; FULLWIDTH LATIN CAPITAL LETTER A
       (?$B#B(B . "0xFF22") ;; FULLWIDTH LATIN CAPITAL LETTER B
       (?$B#C(B . "0xFF23") ;; FULLWIDTH LATIN CAPITAL LETTER C
       (?$B#D(B . "0xFF24") ;; FULLWIDTH LATIN CAPITAL LETTER D
       (?$B#E(B . "0xFF25") ;; FULLWIDTH LATIN CAPITAL LETTER E
       (?$B#F(B . "0xFF26") ;; FULLWIDTH LATIN CAPITAL LETTER F
       (?$B#G(B . "0xFF27") ;; FULLWIDTH LATIN CAPITAL LETTER G
       (?$B#H(B . "0xFF28") ;; FULLWIDTH LATIN CAPITAL LETTER H
       (?$B#I(B . "0xFF29") ;; FULLWIDTH LATIN CAPITAL LETTER I
       (?$B#J(B . "0xFF2A") ;; FULLWIDTH LATIN CAPITAL LETTER J
       (?$B#K(B . "0xFF2B") ;; FULLWIDTH LATIN CAPITAL LETTER K
       (?$B#L(B . "0xFF2C") ;; FULLWIDTH LATIN CAPITAL LETTER L
       (?$B#M(B . "0xFF2D") ;; FULLWIDTH LATIN CAPITAL LETTER M
       (?$B#N(B . "0xFF2E") ;; FULLWIDTH LATIN CAPITAL LETTER N
       (?$B#O(B . "0xFF2F") ;; FULLWIDTH LATIN CAPITAL LETTER O
       (?$B#P(B . "0xFF30") ;; FULLWIDTH LATIN CAPITAL LETTER P
       (?$B#Q(B . "0xFF31") ;; FULLWIDTH LATIN CAPITAL LETTER Q
       (?$B#R(B . "0xFF32") ;; FULLWIDTH LATIN CAPITAL LETTER R
       (?$B#S(B . "0xFF33") ;; FULLWIDTH LATIN CAPITAL LETTER S
       (?$B#T(B . "0xFF34") ;; FULLWIDTH LATIN CAPITAL LETTER T
       (?$B#U(B . "0xFF35") ;; FULLWIDTH LATIN CAPITAL LETTER U
       (?$B#V(B . "0xFF36") ;; FULLWIDTH LATIN CAPITAL LETTER V
       (?$B#W(B . "0xFF37") ;; FULLWIDTH LATIN CAPITAL LETTER W
       (?$B#X(B . "0xFF38") ;; FULLWIDTH LATIN CAPITAL LETTER X
       (?$B#Y(B . "0xFF39") ;; FULLWIDTH LATIN CAPITAL LETTER Y
       (?$B#Z(B . "0xFF3A") ;; FULLWIDTH LATIN CAPITAL LETTER Z
       (?$B#a(B . "0xFF41") ;; FULLWIDTH LATIN SMALL LETTER A
       (?$B#b(B . "0xFF42") ;; FULLWIDTH LATIN SMALL LETTER B
       (?$B#c(B . "0xFF43") ;; FULLWIDTH LATIN SMALL LETTER C
       (?$B#d(B . "0xFF44") ;; FULLWIDTH LATIN SMALL LETTER D
       (?$B#e(B . "0xFF45") ;; FULLWIDTH LATIN SMALL LETTER E
       (?$B#f(B . "0xFF46") ;; FULLWIDTH LATIN SMALL LETTER F
       (?$B#g(B . "0xFF47") ;; FULLWIDTH LATIN SMALL LETTER G
       (?$B#h(B . "0xFF48") ;; FULLWIDTH LATIN SMALL LETTER H
       (?$B#i(B . "0xFF49") ;; FULLWIDTH LATIN SMALL LETTER I
       (?$B#j(B . "0xFF4A") ;; FULLWIDTH LATIN SMALL LETTER J
       (?$B#k(B . "0xFF4B") ;; FULLWIDTH LATIN SMALL LETTER K
       (?$B#l(B . "0xFF4C") ;; FULLWIDTH LATIN SMALL LETTER L
       (?$B#m(B . "0xFF4D") ;; FULLWIDTH LATIN SMALL LETTER M
       (?$B#n(B . "0xFF4E") ;; FULLWIDTH LATIN SMALL LETTER N
       (?$B#o(B . "0xFF4F") ;; FULLWIDTH LATIN SMALL LETTER O
       (?$B#p(B . "0xFF50") ;; FULLWIDTH LATIN SMALL LETTER P
       (?$B#q(B . "0xFF51") ;; FULLWIDTH LATIN SMALL LETTER Q
       (?$B#r(B . "0xFF52") ;; FULLWIDTH LATIN SMALL LETTER R
       (?$B#s(B . "0xFF53") ;; FULLWIDTH LATIN SMALL LETTER S
       (?$B#t(B . "0xFF54") ;; FULLWIDTH LATIN SMALL LETTER T
       (?$B#u(B . "0xFF55") ;; FULLWIDTH LATIN SMALL LETTER U
       (?$B#v(B . "0xFF56") ;; FULLWIDTH LATIN SMALL LETTER V
       (?$B#w(B . "0xFF57") ;; FULLWIDTH LATIN SMALL LETTER W
       (?$B#x(B . "0xFF58") ;; FULLWIDTH LATIN SMALL LETTER X
       (?$B#y(B . "0xFF59") ;; FULLWIDTH LATIN SMALL LETTER Y
       (?$B#z(B . "0xFF5A") ;; FULLWIDTH LATIN SMALL LETTER Z
       (?$B$!(B . "0x3041") ;; HIRAGANA LETTER SMALL A
       (?$B$"(B . "0x3042") ;; HIRAGANA LETTER A
       (?$B$#(B . "0x3043") ;; HIRAGANA LETTER SMALL I
       (?$B$$(B . "0x3044") ;; HIRAGANA LETTER I
       (?$B$%(B . "0x3045") ;; HIRAGANA LETTER SMALL U
       (?$B$&(B . "0x3046") ;; HIRAGANA LETTER U
       (?$B$'(B . "0x3047") ;; HIRAGANA LETTER SMALL E
       (?$B$((B . "0x3048") ;; HIRAGANA LETTER E
       (?$B$)(B . "0x3049") ;; HIRAGANA LETTER SMALL O
       (?$B$*(B . "0x304A") ;; HIRAGANA LETTER O
       (?$B$+(B . "0x304B") ;; HIRAGANA LETTER KA
       (?$B$,(B . "0x304C") ;; HIRAGANA LETTER GA
       (?$B$-(B . "0x304D") ;; HIRAGANA LETTER KI
       (?$B$.(B . "0x304E") ;; HIRAGANA LETTER GI
       (?$B$/(B . "0x304F") ;; HIRAGANA LETTER KU
       (?$B$0(B . "0x3050") ;; HIRAGANA LETTER GU
       (?$B$1(B . "0x3051") ;; HIRAGANA LETTER KE
       (?$B$2(B . "0x3052") ;; HIRAGANA LETTER GE
       (?$B$3(B . "0x3053") ;; HIRAGANA LETTER KO
       (?$B$4(B . "0x3054") ;; HIRAGANA LETTER GO
       (?$B$5(B . "0x3055") ;; HIRAGANA LETTER SA
       (?$B$6(B . "0x3056") ;; HIRAGANA LETTER ZA
       (?$B$7(B . "0x3057") ;; HIRAGANA LETTER SI
       (?$B$8(B . "0x3058") ;; HIRAGANA LETTER ZI
       (?$B$9(B . "0x3059") ;; HIRAGANA LETTER SU
       (?$B$:(B . "0x305A") ;; HIRAGANA LETTER ZU
       (?$B$;(B . "0x305B") ;; HIRAGANA LETTER SE
       (?$B$<(B . "0x305C") ;; HIRAGANA LETTER ZE
       (?$B$=(B . "0x305D") ;; HIRAGANA LETTER SO
       (?$B$>(B . "0x305E") ;; HIRAGANA LETTER ZO
       (?$B$?(B . "0x305F") ;; HIRAGANA LETTER TA
       (?$B$@(B . "0x3060") ;; HIRAGANA LETTER DA
       (?$B$A(B . "0x3061") ;; HIRAGANA LETTER TI
       (?$B$B(B . "0x3062") ;; HIRAGANA LETTER DI
       (?$B$C(B . "0x3063") ;; HIRAGANA LETTER SMALL TU
       (?$B$D(B . "0x3064") ;; HIRAGANA LETTER TU
       (?$B$E(B . "0x3065") ;; HIRAGANA LETTER DU
       (?$B$F(B . "0x3066") ;; HIRAGANA LETTER TE
       (?$B$G(B . "0x3067") ;; HIRAGANA LETTER DE
       (?$B$H(B . "0x3068") ;; HIRAGANA LETTER TO
       (?$B$I(B . "0x3069") ;; HIRAGANA LETTER DO
       (?$B$J(B . "0x306A") ;; HIRAGANA LETTER NA
       (?$B$K(B . "0x306B") ;; HIRAGANA LETTER NI
       (?$B$L(B . "0x306C") ;; HIRAGANA LETTER NU
       (?$B$M(B . "0x306D") ;; HIRAGANA LETTER NE
       (?$B$N(B . "0x306E") ;; HIRAGANA LETTER NO
       (?$B$O(B . "0x306F") ;; HIRAGANA LETTER HA
       (?$B$P(B . "0x3070") ;; HIRAGANA LETTER BA
       (?$B$Q(B . "0x3071") ;; HIRAGANA LETTER PA
       (?$B$R(B . "0x3072") ;; HIRAGANA LETTER HI
       (?$B$S(B . "0x3073") ;; HIRAGANA LETTER BI
       (?$B$T(B . "0x3074") ;; HIRAGANA LETTER PI
       (?$B$U(B . "0x3075") ;; HIRAGANA LETTER HU
       (?$B$V(B . "0x3076") ;; HIRAGANA LETTER BU
       (?$B$W(B . "0x3077") ;; HIRAGANA LETTER PU
       (?$B$X(B . "0x3078") ;; HIRAGANA LETTER HE
       (?$B$Y(B . "0x3079") ;; HIRAGANA LETTER BE
       (?$B$Z(B . "0x307A") ;; HIRAGANA LETTER PE
       (?$B$[(B . "0x307B") ;; HIRAGANA LETTER HO
       (?$B$\(B . "0x307C") ;; HIRAGANA LETTER BO
       (?$B$](B . "0x307D") ;; HIRAGANA LETTER PO
       (?$B$^(B . "0x307E") ;; HIRAGANA LETTER MA
       (?$B$_(B . "0x307F") ;; HIRAGANA LETTER MI
       (?$B$`(B . "0x3080") ;; HIRAGANA LETTER MU
       (?$B$a(B . "0x3081") ;; HIRAGANA LETTER ME
       (?$B$b(B . "0x3082") ;; HIRAGANA LETTER MO
       (?$B$c(B . "0x3083") ;; HIRAGANA LETTER SMALL YA
       (?$B$d(B . "0x3084") ;; HIRAGANA LETTER YA
       (?$B$e(B . "0x3085") ;; HIRAGANA LETTER SMALL YU
       (?$B$f(B . "0x3086") ;; HIRAGANA LETTER YU
       (?$B$g(B . "0x3087") ;; HIRAGANA LETTER SMALL YO
       (?$B$h(B . "0x3088") ;; HIRAGANA LETTER YO
       (?$B$i(B . "0x3089") ;; HIRAGANA LETTER RA
       (?$B$j(B . "0x308A") ;; HIRAGANA LETTER RI
       (?$B$k(B . "0x308B") ;; HIRAGANA LETTER RU
       (?$B$l(B . "0x308C") ;; HIRAGANA LETTER RE
       (?$B$m(B . "0x308D") ;; HIRAGANA LETTER RO
       (?$B$n(B . "0x308E") ;; HIRAGANA LETTER SMALL WA
       (?$B$o(B . "0x308F") ;; HIRAGANA LETTER WA
       (?$B$p(B . "0x3090") ;; HIRAGANA LETTER WI
       (?$B$q(B . "0x3091") ;; HIRAGANA LETTER WE
       (?$B$r(B . "0x3092") ;; HIRAGANA LETTER WO
       (?$B$s(B . "0x3093") ;; HIRAGANA LETTER N
       (?$B%!(B . "0x30A1") ;; KATAKANA LETTER SMALL A
       (?$B%"(B . "0x30A2") ;; KATAKANA LETTER A
       (?$B%#(B . "0x30A3") ;; KATAKANA LETTER SMALL I
       (?$B%$(B . "0x30A4") ;; KATAKANA LETTER I
       (?$B%%(B . "0x30A5") ;; KATAKANA LETTER SMALL U
       (?$B%&(B . "0x30A6") ;; KATAKANA LETTER U
       (?$B%'(B . "0x30A7") ;; KATAKANA LETTER SMALL E
       (?$B%((B . "0x30A8") ;; KATAKANA LETTER E
       (?$B%)(B . "0x30A9") ;; KATAKANA LETTER SMALL O
       (?$B%*(B . "0x30AA") ;; KATAKANA LETTER O
       (?$B%+(B . "0x30AB") ;; KATAKANA LETTER KA
       (?$B%,(B . "0x30AC") ;; KATAKANA LETTER GA
       (?$B%-(B . "0x30AD") ;; KATAKANA LETTER KI
       (?$B%.(B . "0x30AE") ;; KATAKANA LETTER GI
       (?$B%/(B . "0x30AF") ;; KATAKANA LETTER KU
       (?$B%0(B . "0x30B0") ;; KATAKANA LETTER GU
       (?$B%1(B . "0x30B1") ;; KATAKANA LETTER KE
       (?$B%2(B . "0x30B2") ;; KATAKANA LETTER GE
       (?$B%3(B . "0x30B3") ;; KATAKANA LETTER KO
       (?$B%4(B . "0x30B4") ;; KATAKANA LETTER GO
       (?$B%5(B . "0x30B5") ;; KATAKANA LETTER SA
       (?$B%6(B . "0x30B6") ;; KATAKANA LETTER ZA
       (?$B%7(B . "0x30B7") ;; KATAKANA LETTER SI
       (?$B%8(B . "0x30B8") ;; KATAKANA LETTER ZI
       (?$B%9(B . "0x30B9") ;; KATAKANA LETTER SU
       (?$B%:(B . "0x30BA") ;; KATAKANA LETTER ZU
       (?$B%;(B . "0x30BB") ;; KATAKANA LETTER SE
       (?$B%<(B . "0x30BC") ;; KATAKANA LETTER ZE
       (?$B%=(B . "0x30BD") ;; KATAKANA LETTER SO
       (?$B%>(B . "0x30BE") ;; KATAKANA LETTER ZO
       (?$B%?(B . "0x30BF") ;; KATAKANA LETTER TA
       (?$B%@(B . "0x30C0") ;; KATAKANA LETTER DA
       (?$B%A(B . "0x30C1") ;; KATAKANA LETTER TI
       (?$B%B(B . "0x30C2") ;; KATAKANA LETTER DI
       (?$B%C(B . "0x30C3") ;; KATAKANA LETTER SMALL TU
       (?$B%D(B . "0x30C4") ;; KATAKANA LETTER TU
       (?$B%E(B . "0x30C5") ;; KATAKANA LETTER DU
       (?$B%F(B . "0x30C6") ;; KATAKANA LETTER TE
       (?$B%G(B . "0x30C7") ;; KATAKANA LETTER DE
       (?$B%H(B . "0x30C8") ;; KATAKANA LETTER TO
       (?$B%I(B . "0x30C9") ;; KATAKANA LETTER DO
       (?$B%J(B . "0x30CA") ;; KATAKANA LETTER NA
       (?$B%K(B . "0x30CB") ;; KATAKANA LETTER NI
       (?$B%L(B . "0x30CC") ;; KATAKANA LETTER NU
       (?$B%M(B . "0x30CD") ;; KATAKANA LETTER NE
       (?$B%N(B . "0x30CE") ;; KATAKANA LETTER NO
       (?$B%O(B . "0x30CF") ;; KATAKANA LETTER HA
       (?$B%P(B . "0x30D0") ;; KATAKANA LETTER BA
       (?$B%Q(B . "0x30D1") ;; KATAKANA LETTER PA
       (?$B%R(B . "0x30D2") ;; KATAKANA LETTER HI
       (?$B%S(B . "0x30D3") ;; KATAKANA LETTER BI
       (?$B%T(B . "0x30D4") ;; KATAKANA LETTER PI
       (?$B%U(B . "0x30D5") ;; KATAKANA LETTER HU
       (?$B%V(B . "0x30D6") ;; KATAKANA LETTER BU
       (?$B%W(B . "0x30D7") ;; KATAKANA LETTER PU
       (?$B%X(B . "0x30D8") ;; KATAKANA LETTER HE
       (?$B%Y(B . "0x30D9") ;; KATAKANA LETTER BE
       (?$B%Z(B . "0x30DA") ;; KATAKANA LETTER PE
       (?$B%[(B . "0x30DB") ;; KATAKANA LETTER HO
       (?$B%\(B . "0x30DC") ;; KATAKANA LETTER BO
       (?$B%](B . "0x30DD") ;; KATAKANA LETTER PO
       (?$B%^(B . "0x30DE") ;; KATAKANA LETTER MA
       (?$B%_(B . "0x30DF") ;; KATAKANA LETTER MI
       (?$B%`(B . "0x30E0") ;; KATAKANA LETTER MU
       (?$B%a(B . "0x30E1") ;; KATAKANA LETTER ME
       (?$B%b(B . "0x30E2") ;; KATAKANA LETTER MO
       (?$B%c(B . "0x30E3") ;; KATAKANA LETTER SMALL YA
       (?$B%d(B . "0x30E4") ;; KATAKANA LETTER YA
       (?$B%e(B . "0x30E5") ;; KATAKANA LETTER SMALL YU
       (?$B%f(B . "0x30E6") ;; KATAKANA LETTER YU
       (?$B%g(B . "0x30E7") ;; KATAKANA LETTER SMALL YO
       (?$B%h(B . "0x30E8") ;; KATAKANA LETTER YO
       (?$B%i(B . "0x30E9") ;; KATAKANA LETTER RA
       (?$B%j(B . "0x30EA") ;; KATAKANA LETTER RI
       (?$B%k(B . "0x30EB") ;; KATAKANA LETTER RU
       (?$B%l(B . "0x30EC") ;; KATAKANA LETTER RE
       (?$B%m(B . "0x30ED") ;; KATAKANA LETTER RO
       (?$B%n(B . "0x30EE") ;; KATAKANA LETTER SMALL WA
       (?$B%o(B . "0x30EF") ;; KATAKANA LETTER WA
       (?$B%p(B . "0x30F0") ;; KATAKANA LETTER WI
       (?$B%q(B . "0x30F1") ;; KATAKANA LETTER WE
       (?$B%r(B . "0x30F2") ;; KATAKANA LETTER WO
       (?$B%s(B . "0x30F3") ;; KATAKANA LETTER N
       (?$B%t(B . "0x30F4") ;; KATAKANA LETTER VU
       (?$B%u(B . "0x30F5") ;; KATAKANA LETTER SMALL KA
       (?$B%v(B . "0x30F6") ;; KATAKANA LETTER SMALL KE
       (?$B&!(B . "0x0391") ;; GREEK CAPITAL LETTER ALPHA
       (?$B&"(B . "0x0392") ;; GREEK CAPITAL LETTER BETA
       (?$B&#(B . "0x0393") ;; GREEK CAPITAL LETTER GAMMA
       (?$B&$(B . "0x0394") ;; GREEK CAPITAL LETTER DELTA
       (?$B&%(B . "0x0395") ;; GREEK CAPITAL LETTER EPSILON
       (?$B&&(B . "0x0396") ;; GREEK CAPITAL LETTER ZETA
       (?$B&'(B . "0x0397") ;; GREEK CAPITAL LETTER ETA
       (?$B&((B . "0x0398") ;; GREEK CAPITAL LETTER THETA
       (?$B&)(B . "0x0399") ;; GREEK CAPITAL LETTER IOTA
       (?$B&*(B . "0x039A") ;; GREEK CAPITAL LETTER KAPPA
       (?$B&+(B . "0x039B") ;; GREEK CAPITAL LETTER LAMDA
       (?$B&,(B . "0x039C") ;; GREEK CAPITAL LETTER MU
       (?$B&-(B . "0x039D") ;; GREEK CAPITAL LETTER NU
       (?$B&.(B . "0x039E") ;; GREEK CAPITAL LETTER XI
       (?$B&/(B . "0x039F") ;; GREEK CAPITAL LETTER OMICRON
       (?$B&0(B . "0x03A0") ;; GREEK CAPITAL LETTER PI
       (?$B&1(B . "0x03A1") ;; GREEK CAPITAL LETTER RHO
       (?$B&2(B . "0x03A3") ;; GREEK CAPITAL LETTER SIGMA
       (?$B&3(B . "0x03A4") ;; GREEK CAPITAL LETTER TAU
       (?$B&4(B . "0x03A5") ;; GREEK CAPITAL LETTER UPSILON
       (?$B&5(B . "0x03A6") ;; GREEK CAPITAL LETTER PHI
       (?$B&6(B . "0x03A7") ;; GREEK CAPITAL LETTER CHI
       (?$B&7(B . "0x03A8") ;; GREEK CAPITAL LETTER PSI
       (?$B&8(B . "0x03A9") ;; GREEK CAPITAL LETTER OMEGA
       (?$B&A(B . "0x03B1") ;; GREEK SMALL LETTER ALPHA
       (?$B&B(B . "0x03B2") ;; GREEK SMALL LETTER BETA
       (?$B&C(B . "0x03B3") ;; GREEK SMALL LETTER GAMMA
       (?$B&D(B . "0x03B4") ;; GREEK SMALL LETTER DELTA
       (?$B&E(B . "0x03B5") ;; GREEK SMALL LETTER EPSILON
       (?$B&F(B . "0x03B6") ;; GREEK SMALL LETTER ZETA
       (?$B&G(B . "0x03B7") ;; GREEK SMALL LETTER ETA
       (?$B&H(B . "0x03B8") ;; GREEK SMALL LETTER THETA
       (?$B&I(B . "0x03B9") ;; GREEK SMALL LETTER IOTA
       (?$B&J(B . "0x03BA") ;; GREEK SMALL LETTER KAPPA
       (?$B&K(B . "0x03BB") ;; GREEK SMALL LETTER LAMDA
       (?$B&L(B . "0x03BC") ;; GREEK SMALL LETTER MU
       (?$B&M(B . "0x03BD") ;; GREEK SMALL LETTER NU
       (?$B&N(B . "0x03BE") ;; GREEK SMALL LETTER XI
       (?$B&O(B . "0x03BF") ;; GREEK SMALL LETTER OMICRON
       (?$B&P(B . "0x03C0") ;; GREEK SMALL LETTER PI
       (?$B&Q(B . "0x03C1") ;; GREEK SMALL LETTER RHO
       (?$B&R(B . "0x03C3") ;; GREEK SMALL LETTER SIGMA
       (?$B&S(B . "0x03C4") ;; GREEK SMALL LETTER TAU
       (?$B&T(B . "0x03C5") ;; GREEK SMALL LETTER UPSILON
       (?$B&U(B . "0x03C6") ;; GREEK SMALL LETTER PHI
       (?$B&V(B . "0x03C7") ;; GREEK SMALL LETTER CHI
       (?$B&W(B . "0x03C8") ;; GREEK SMALL LETTER PSI
       (?$B&X(B . "0x03C9") ;; GREEK SMALL LETTER OMEGA
       (?$B'!(B . "0x0410") ;; CYRILLIC CAPITAL LETTER A
       (?$B'"(B . "0x0411") ;; CYRILLIC CAPITAL LETTER BE
       (?$B'#(B . "0x0412") ;; CYRILLIC CAPITAL LETTER VE
       (?$B'$(B . "0x0413") ;; CYRILLIC CAPITAL LETTER GHE
       (?$B'%(B . "0x0414") ;; CYRILLIC CAPITAL LETTER DE
       (?$B'&(B . "0x0415") ;; CYRILLIC CAPITAL LETTER IE
       (?$B''(B . "0x0401") ;; CYRILLIC CAPITAL LETTER IO
       (?$B'((B . "0x0416") ;; CYRILLIC CAPITAL LETTER ZHE
       (?$B')(B . "0x0417") ;; CYRILLIC CAPITAL LETTER ZE
       (?$B'*(B . "0x0418") ;; CYRILLIC CAPITAL LETTER I
       (?$B'+(B . "0x0419") ;; CYRILLIC CAPITAL LETTER SHORT I
       (?$B',(B . "0x041A") ;; CYRILLIC CAPITAL LETTER KA
       (?$B'-(B . "0x041B") ;; CYRILLIC CAPITAL LETTER EL
       (?$B'.(B . "0x041C") ;; CYRILLIC CAPITAL LETTER EM
       (?$B'/(B . "0x041D") ;; CYRILLIC CAPITAL LETTER EN
       (?$B'0(B . "0x041E") ;; CYRILLIC CAPITAL LETTER O
       (?$B'1(B . "0x041F") ;; CYRILLIC CAPITAL LETTER PE
       (?$B'2(B . "0x0420") ;; CYRILLIC CAPITAL LETTER ER
       (?$B'3(B . "0x0421") ;; CYRILLIC CAPITAL LETTER ES
       (?$B'4(B . "0x0422") ;; CYRILLIC CAPITAL LETTER TE
       (?$B'5(B . "0x0423") ;; CYRILLIC CAPITAL LETTER U
       (?$B'6(B . "0x0424") ;; CYRILLIC CAPITAL LETTER EF
       (?$B'7(B . "0x0425") ;; CYRILLIC CAPITAL LETTER HA
       (?$B'8(B . "0x0426") ;; CYRILLIC CAPITAL LETTER TSE
       (?$B'9(B . "0x0427") ;; CYRILLIC CAPITAL LETTER CHE
       (?$B':(B . "0x0428") ;; CYRILLIC CAPITAL LETTER SHA
       (?$B';(B . "0x0429") ;; CYRILLIC CAPITAL LETTER SHCHA
       (?$B'<(B . "0x042A") ;; CYRILLIC CAPITAL LETTER HARD SIGN
       (?$B'=(B . "0x042B") ;; CYRILLIC CAPITAL LETTER YERU
       (?$B'>(B . "0x042C") ;; CYRILLIC CAPITAL LETTER SOFT SIGN
       (?$B'?(B . "0x042D") ;; CYRILLIC CAPITAL LETTER E
       (?$B'@(B . "0x042E") ;; CYRILLIC CAPITAL LETTER YU
       (?$B'A(B . "0x042F") ;; CYRILLIC CAPITAL LETTER YA
       (?$B'Q(B . "0x0430") ;; CYRILLIC SMALL LETTER A
       (?$B'R(B . "0x0431") ;; CYRILLIC SMALL LETTER BE
       (?$B'S(B . "0x0432") ;; CYRILLIC SMALL LETTER VE
       (?$B'T(B . "0x0433") ;; CYRILLIC SMALL LETTER GHE
       (?$B'U(B . "0x0434") ;; CYRILLIC SMALL LETTER DE
       (?$B'V(B . "0x0435") ;; CYRILLIC SMALL LETTER IE
       (?$B'W(B . "0x0451") ;; CYRILLIC SMALL LETTER IO
       (?$B'X(B . "0x0436") ;; CYRILLIC SMALL LETTER ZHE
       (?$B'Y(B . "0x0437") ;; CYRILLIC SMALL LETTER ZE
       (?$B'Z(B . "0x0438") ;; CYRILLIC SMALL LETTER I
       (?$B'[(B . "0x0439") ;; CYRILLIC SMALL LETTER SHORT I
       (?$B'\(B . "0x043A") ;; CYRILLIC SMALL LETTER KA
       (?$B'](B . "0x043B") ;; CYRILLIC SMALL LETTER EL
       (?$B'^(B . "0x043C") ;; CYRILLIC SMALL LETTER EM
       (?$B'_(B . "0x043D") ;; CYRILLIC SMALL LETTER EN
       (?$B'`(B . "0x043E") ;; CYRILLIC SMALL LETTER O
       (?$B'a(B . "0x043F") ;; CYRILLIC SMALL LETTER PE
       (?$B'b(B . "0x0440") ;; CYRILLIC SMALL LETTER ER
       (?$B'c(B . "0x0441") ;; CYRILLIC SMALL LETTER ES
       (?$B'd(B . "0x0442") ;; CYRILLIC SMALL LETTER TE
       (?$B'e(B . "0x0443") ;; CYRILLIC SMALL LETTER U
       (?$B'f(B . "0x0444") ;; CYRILLIC SMALL LETTER EF
       (?$B'g(B . "0x0445") ;; CYRILLIC SMALL LETTER HA
       (?$B'h(B . "0x0446") ;; CYRILLIC SMALL LETTER TSE
       (?$B'i(B . "0x0447") ;; CYRILLIC SMALL LETTER CHE
       (?$B'j(B . "0x0448") ;; CYRILLIC SMALL LETTER SHA
       (?$B'k(B . "0x0449") ;; CYRILLIC SMALL LETTER SHCHA
       (?$B'l(B . "0x044A") ;; CYRILLIC SMALL LETTER HARD SIGN
       (?$B'm(B . "0x044B") ;; CYRILLIC SMALL LETTER YERU
       (?$B'n(B . "0x044C") ;; CYRILLIC SMALL LETTER SOFT SIGN
       (?$B'o(B . "0x044D") ;; CYRILLIC SMALL LETTER E
       (?$B'p(B . "0x044E") ;; CYRILLIC SMALL LETTER YU
       (?$B'q(B . "0x044F") ;; CYRILLIC SMALL LETTER YA
       (?$B(!(B . "0x2500") ;; BOX DRAWINGS LIGHT HORIZONTAL
       (?$B("(B . "0x2502") ;; BOX DRAWINGS LIGHT VERTICAL
       (?$B(#(B . "0x250C") ;; BOX DRAWINGS LIGHT DOWN AND RIGHT
       (?$B($(B . "0x2510") ;; BOX DRAWINGS LIGHT DOWN AND LEFT
       (?$B(%(B . "0x2518") ;; BOX DRAWINGS LIGHT UP AND LEFT
       (?$B(&(B . "0x2514") ;; BOX DRAWINGS LIGHT UP AND RIGHT
       (?$B('(B . "0x251C") ;; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
       (?$B(((B . "0x252C") ;; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
       (?$B()(B . "0x2524") ;; BOX DRAWINGS LIGHT VERTICAL AND LEFT
       (?$B(*(B . "0x2534") ;; BOX DRAWINGS LIGHT UP AND HORIZONTAL
       (?$B(+(B . "0x253C") ;; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
       (?$B(,(B . "0x2501") ;; BOX DRAWINGS HEAVY HORIZONTAL
       (?$B(-(B . "0x2503") ;; BOX DRAWINGS HEAVY VERTICAL
       (?$B(.(B . "0x250F") ;; BOX DRAWINGS HEAVY DOWN AND RIGHT
       (?$B(/(B . "0x2513") ;; BOX DRAWINGS HEAVY DOWN AND LEFT
       (?$B(0(B . "0x251B") ;; BOX DRAWINGS HEAVY UP AND LEFT
       (?$B(1(B . "0x2517") ;; BOX DRAWINGS HEAVY UP AND RIGHT
       (?$B(2(B . "0x2523") ;; BOX DRAWINGS HEAVY VERTICAL AND RIGHT
       (?$B(3(B . "0x2533") ;; BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
       (?$B(4(B . "0x252B") ;; BOX DRAWINGS HEAVY VERTICAL AND LEFT
       (?$B(5(B . "0x253B") ;; BOX DRAWINGS HEAVY UP AND HORIZONTAL
       (?$B(6(B . "0x254B") ;; BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
       (?$B(7(B . "0x2520") ;; BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
       (?$B(8(B . "0x252F") ;; BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
       (?$B(9(B . "0x2528") ;; BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
       (?$B(:(B . "0x2537") ;; BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
       (?$B(;(B . "0x253F") ;; BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
       (?$B(<(B . "0x251D") ;; BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
       (?$B(=(B . "0x2530") ;; BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
       (?$B(>(B . "0x2525") ;; BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
       (?$B(?(B . "0x2538") ;; BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
       (?$B(@(B . "0x2542") ;; BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
       (?$B0!(B . "0x4E9C") ;; <CJK>
       (?$B0"(B . "0x5516") ;; <CJK>
       (?$B0#(B . "0x5A03") ;; <CJK>
       (?$B0$(B . "0x963F") ;; <CJK>
       (?$B0%(B . "0x54C0") ;; <CJK>
       (?$B0&(B . "0x611B") ;; <CJK>
       (?$B0'(B . "0x6328") ;; <CJK>
       (?$B0((B . "0x59F6") ;; <CJK>
       (?$B0)(B . "0x9022") ;; <CJK>
       (?$B0*(B . "0x8475") ;; <CJK>
       (?$B0+(B . "0x831C") ;; <CJK>
       (?$B0,(B . "0x7A50") ;; <CJK>
       (?$B0-(B . "0x60AA") ;; <CJK>
       (?$B0.(B . "0x63E1") ;; <CJK>
       (?$B0/(B . "0x6E25") ;; <CJK>
       (?$B00(B . "0x65ED") ;; <CJK>
       (?$B01(B . "0x8466") ;; <CJK>
       (?$B02(B . "0x82A6") ;; <CJK>
       (?$B03(B . "0x9BF5") ;; <CJK>
       (?$B04(B . "0x6893") ;; <CJK>
       (?$B05(B . "0x5727") ;; <CJK>
       (?$B06(B . "0x65A1") ;; <CJK>
       (?$B07(B . "0x6271") ;; <CJK>
       (?$B08(B . "0x5B9B") ;; <CJK>
       (?$B09(B . "0x59D0") ;; <CJK>
       (?$B0:(B . "0x867B") ;; <CJK>
       (?$B0;(B . "0x98F4") ;; <CJK>
       (?$B0<(B . "0x7D62") ;; <CJK>
       (?$B0=(B . "0x7DBE") ;; <CJK>
       (?$B0>(B . "0x9B8E") ;; <CJK>
       (?$B0?(B . "0x6216") ;; <CJK>
       (?$B0@(B . "0x7C9F") ;; <CJK>
       (?$B0A(B . "0x88B7") ;; <CJK>
       (?$B0B(B . "0x5B89") ;; <CJK>
       (?$B0C(B . "0x5EB5") ;; <CJK>
       (?$B0D(B . "0x6309") ;; <CJK>
       (?$B0E(B . "0x6697") ;; <CJK>
       (?$B0F(B . "0x6848") ;; <CJK>
       (?$B0G(B . "0x95C7") ;; <CJK>
       (?$B0H(B . "0x978D") ;; <CJK>
       (?$B0I(B . "0x674F") ;; <CJK>
       (?$B0J(B . "0x4EE5") ;; <CJK>
       (?$B0K(B . "0x4F0A") ;; <CJK>
       (?$B0L(B . "0x4F4D") ;; <CJK>
       (?$B0M(B . "0x4F9D") ;; <CJK>
       (?$B0N(B . "0x5049") ;; <CJK>
       (?$B0O(B . "0x56F2") ;; <CJK>
       (?$B0P(B . "0x5937") ;; <CJK>
       (?$B0Q(B . "0x59D4") ;; <CJK>
       (?$B0R(B . "0x5A01") ;; <CJK>
       (?$B0S(B . "0x5C09") ;; <CJK>
       (?$B0T(B . "0x60DF") ;; <CJK>
       (?$B0U(B . "0x610F") ;; <CJK>
       (?$B0V(B . "0x6170") ;; <CJK>
       (?$B0W(B . "0x6613") ;; <CJK>
       (?$B0X(B . "0x6905") ;; <CJK>
       (?$B0Y(B . "0x70BA") ;; <CJK>
       (?$B0Z(B . "0x754F") ;; <CJK>
       (?$B0[(B . "0x7570") ;; <CJK>
       (?$B0\(B . "0x79FB") ;; <CJK>
       (?$B0](B . "0x7DAD") ;; <CJK>
       (?$B0^(B . "0x7DEF") ;; <CJK>
       (?$B0_(B . "0x80C3") ;; <CJK>
       (?$B0`(B . "0x840E") ;; <CJK>
       (?$B0a(B . "0x8863") ;; <CJK>
       (?$B0b(B . "0x8B02") ;; <CJK>
       (?$B0c(B . "0x9055") ;; <CJK>
       (?$B0d(B . "0x907A") ;; <CJK>
       (?$B0e(B . "0x533B") ;; <CJK>
       (?$B0f(B . "0x4E95") ;; <CJK>
       (?$B0g(B . "0x4EA5") ;; <CJK>
       (?$B0h(B . "0x57DF") ;; <CJK>
       (?$B0i(B . "0x80B2") ;; <CJK>
       (?$B0j(B . "0x90C1") ;; <CJK>
       (?$B0k(B . "0x78EF") ;; <CJK>
       (?$B0l(B . "0x4E00") ;; <CJK>
       (?$B0m(B . "0x58F1") ;; <CJK>
       (?$B0n(B . "0x6EA2") ;; <CJK>
       (?$B0o(B . "0x9038") ;; <CJK>
       (?$B0p(B . "0x7A32") ;; <CJK>
       (?$B0q(B . "0x8328") ;; <CJK>
       (?$B0r(B . "0x828B") ;; <CJK>
       (?$B0s(B . "0x9C2F") ;; <CJK>
       (?$B0t(B . "0x5141") ;; <CJK>
       (?$B0u(B . "0x5370") ;; <CJK>
       (?$B0v(B . "0x54BD") ;; <CJK>
       (?$B0w(B . "0x54E1") ;; <CJK>
       (?$B0x(B . "0x56E0") ;; <CJK>
       (?$B0y(B . "0x59FB") ;; <CJK>
       (?$B0z(B . "0x5F15") ;; <CJK>
       (?$B0{(B . "0x98F2") ;; <CJK>
       (?$B0|(B . "0x6DEB") ;; <CJK>
       (?$B0}(B . "0x80E4") ;; <CJK>
       (?$B0~(B . "0x852D") ;; <CJK>
       (?$B1!(B . "0x9662") ;; <CJK>
       (?$B1"(B . "0x9670") ;; <CJK>
       (?$B1#(B . "0x96A0") ;; <CJK>
       (?$B1$(B . "0x97FB") ;; <CJK>
       (?$B1%(B . "0x540B") ;; <CJK>
       (?$B1&(B . "0x53F3") ;; <CJK>
       (?$B1'(B . "0x5B87") ;; <CJK>
       (?$B1((B . "0x70CF") ;; <CJK>
       (?$B1)(B . "0x7FBD") ;; <CJK>
       (?$B1*(B . "0x8FC2") ;; <CJK>
       (?$B1+(B . "0x96E8") ;; <CJK>
       (?$B1,(B . "0x536F") ;; <CJK>
       (?$B1-(B . "0x9D5C") ;; <CJK>
       (?$B1.(B . "0x7ABA") ;; <CJK>
       (?$B1/(B . "0x4E11") ;; <CJK>
       (?$B10(B . "0x7893") ;; <CJK>
       (?$B11(B . "0x81FC") ;; <CJK>
       (?$B12(B . "0x6E26") ;; <CJK>
       (?$B13(B . "0x5618") ;; <CJK>
       (?$B14(B . "0x5504") ;; <CJK>
       (?$B15(B . "0x6B1D") ;; <CJK>
       (?$B16(B . "0x851A") ;; <CJK>
       (?$B17(B . "0x9C3B") ;; <CJK>
       (?$B18(B . "0x59E5") ;; <CJK>
       (?$B19(B . "0x53A9") ;; <CJK>
       (?$B1:(B . "0x6D66") ;; <CJK>
       (?$B1;(B . "0x74DC") ;; <CJK>
       (?$B1<(B . "0x958F") ;; <CJK>
       (?$B1=(B . "0x5642") ;; <CJK>
       (?$B1>(B . "0x4E91") ;; <CJK>
       (?$B1?(B . "0x904B") ;; <CJK>
       (?$B1@(B . "0x96F2") ;; <CJK>
       (?$B1A(B . "0x834F") ;; <CJK>
       (?$B1B(B . "0x990C") ;; <CJK>
       (?$B1C(B . "0x53E1") ;; <CJK>
       (?$B1D(B . "0x55B6") ;; <CJK>
       (?$B1E(B . "0x5B30") ;; <CJK>
       (?$B1F(B . "0x5F71") ;; <CJK>
       (?$B1G(B . "0x6620") ;; <CJK>
       (?$B1H(B . "0x66F3") ;; <CJK>
       (?$B1I(B . "0x6804") ;; <CJK>
       (?$B1J(B . "0x6C38") ;; <CJK>
       (?$B1K(B . "0x6CF3") ;; <CJK>
       (?$B1L(B . "0x6D29") ;; <CJK>
       (?$B1M(B . "0x745B") ;; <CJK>
       (?$B1N(B . "0x76C8") ;; <CJK>
       (?$B1O(B . "0x7A4E") ;; <CJK>
       (?$B1P(B . "0x9834") ;; <CJK>
       (?$B1Q(B . "0x82F1") ;; <CJK>
       (?$B1R(B . "0x885B") ;; <CJK>
       (?$B1S(B . "0x8A60") ;; <CJK>
       (?$B1T(B . "0x92ED") ;; <CJK>
       (?$B1U(B . "0x6DB2") ;; <CJK>
       (?$B1V(B . "0x75AB") ;; <CJK>
       (?$B1W(B . "0x76CA") ;; <CJK>
       (?$B1X(B . "0x99C5") ;; <CJK>
       (?$B1Y(B . "0x60A6") ;; <CJK>
       (?$B1Z(B . "0x8B01") ;; <CJK>
       (?$B1[(B . "0x8D8A") ;; <CJK>
       (?$B1\(B . "0x95B2") ;; <CJK>
       (?$B1](B . "0x698E") ;; <CJK>
       (?$B1^(B . "0x53AD") ;; <CJK>
       (?$B1_(B . "0x5186") ;; <CJK>
       (?$B1`(B . "0x5712") ;; <CJK>
       (?$B1a(B . "0x5830") ;; <CJK>
       (?$B1b(B . "0x5944") ;; <CJK>
       (?$B1c(B . "0x5BB4") ;; <CJK>
       (?$B1d(B . "0x5EF6") ;; <CJK>
       (?$B1e(B . "0x6028") ;; <CJK>
       (?$B1f(B . "0x63A9") ;; <CJK>
       (?$B1g(B . "0x63F4") ;; <CJK>
       (?$B1h(B . "0x6CBF") ;; <CJK>
       (?$B1i(B . "0x6F14") ;; <CJK>
       (?$B1j(B . "0x708E") ;; <CJK>
       (?$B1k(B . "0x7114") ;; <CJK>
       (?$B1l(B . "0x7159") ;; <CJK>
       (?$B1m(B . "0x71D5") ;; <CJK>
       (?$B1n(B . "0x733F") ;; <CJK>
       (?$B1o(B . "0x7E01") ;; <CJK>
       (?$B1p(B . "0x8276") ;; <CJK>
       (?$B1q(B . "0x82D1") ;; <CJK>
       (?$B1r(B . "0x8597") ;; <CJK>
       (?$B1s(B . "0x9060") ;; <CJK>
       (?$B1t(B . "0x925B") ;; <CJK>
       (?$B1u(B . "0x9D1B") ;; <CJK>
       (?$B1v(B . "0x5869") ;; <CJK>
       (?$B1w(B . "0x65BC") ;; <CJK>
       (?$B1x(B . "0x6C5A") ;; <CJK>
       (?$B1y(B . "0x7525") ;; <CJK>
       (?$B1z(B . "0x51F9") ;; <CJK>
       (?$B1{(B . "0x592E") ;; <CJK>
       (?$B1|(B . "0x5965") ;; <CJK>
       (?$B1}(B . "0x5F80") ;; <CJK>
       (?$B1~(B . "0x5FDC") ;; <CJK>
       (?$B2!(B . "0x62BC") ;; <CJK>
       (?$B2"(B . "0x65FA") ;; <CJK>
       (?$B2#(B . "0x6A2A") ;; <CJK>
       (?$B2$(B . "0x6B27") ;; <CJK>
       (?$B2%(B . "0x6BB4") ;; <CJK>
       (?$B2&(B . "0x738B") ;; <CJK>
       (?$B2'(B . "0x7FC1") ;; <CJK>
       (?$B2((B . "0x8956") ;; <CJK>
       (?$B2)(B . "0x9D2C") ;; <CJK>
       (?$B2*(B . "0x9D0E") ;; <CJK>
       (?$B2+(B . "0x9EC4") ;; <CJK>
       (?$B2,(B . "0x5CA1") ;; <CJK>
       (?$B2-(B . "0x6C96") ;; <CJK>
       (?$B2.(B . "0x837B") ;; <CJK>
       (?$B2/(B . "0x5104") ;; <CJK>
       (?$B20(B . "0x5C4B") ;; <CJK>
       (?$B21(B . "0x61B6") ;; <CJK>
       (?$B22(B . "0x81C6") ;; <CJK>
       (?$B23(B . "0x6876") ;; <CJK>
       (?$B24(B . "0x7261") ;; <CJK>
       (?$B25(B . "0x4E59") ;; <CJK>
       (?$B26(B . "0x4FFA") ;; <CJK>
       (?$B27(B . "0x5378") ;; <CJK>
       (?$B28(B . "0x6069") ;; <CJK>
       (?$B29(B . "0x6E29") ;; <CJK>
       (?$B2:(B . "0x7A4F") ;; <CJK>
       (?$B2;(B . "0x97F3") ;; <CJK>
       (?$B2<(B . "0x4E0B") ;; <CJK>
       (?$B2=(B . "0x5316") ;; <CJK>
       (?$B2>(B . "0x4EEE") ;; <CJK>
       (?$B2?(B . "0x4F55") ;; <CJK>
       (?$B2@(B . "0x4F3D") ;; <CJK>
       (?$B2A(B . "0x4FA1") ;; <CJK>
       (?$B2B(B . "0x4F73") ;; <CJK>
       (?$B2C(B . "0x52A0") ;; <CJK>
       (?$B2D(B . "0x53EF") ;; <CJK>
       (?$B2E(B . "0x5609") ;; <CJK>
       (?$B2F(B . "0x590F") ;; <CJK>
       (?$B2G(B . "0x5AC1") ;; <CJK>
       (?$B2H(B . "0x5BB6") ;; <CJK>
       (?$B2I(B . "0x5BE1") ;; <CJK>
       (?$B2J(B . "0x79D1") ;; <CJK>
       (?$B2K(B . "0x6687") ;; <CJK>
       (?$B2L(B . "0x679C") ;; <CJK>
       (?$B2M(B . "0x67B6") ;; <CJK>
       (?$B2N(B . "0x6B4C") ;; <CJK>
       (?$B2O(B . "0x6CB3") ;; <CJK>
       (?$B2P(B . "0x706B") ;; <CJK>
       (?$B2Q(B . "0x73C2") ;; <CJK>
       (?$B2R(B . "0x798D") ;; <CJK>
       (?$B2S(B . "0x79BE") ;; <CJK>
       (?$B2T(B . "0x7A3C") ;; <CJK>
       (?$B2U(B . "0x7B87") ;; <CJK>
       (?$B2V(B . "0x82B1") ;; <CJK>
       (?$B2W(B . "0x82DB") ;; <CJK>
       (?$B2X(B . "0x8304") ;; <CJK>
       (?$B2Y(B . "0x8377") ;; <CJK>
       (?$B2Z(B . "0x83EF") ;; <CJK>
       (?$B2[(B . "0x83D3") ;; <CJK>
       (?$B2\(B . "0x8766") ;; <CJK>
       (?$B2](B . "0x8AB2") ;; <CJK>
       (?$B2^(B . "0x5629") ;; <CJK>
       (?$B2_(B . "0x8CA8") ;; <CJK>
       (?$B2`(B . "0x8FE6") ;; <CJK>
       (?$B2a(B . "0x904E") ;; <CJK>
       (?$B2b(B . "0x971E") ;; <CJK>
       (?$B2c(B . "0x868A") ;; <CJK>
       (?$B2d(B . "0x4FC4") ;; <CJK>
       (?$B2e(B . "0x5CE8") ;; <CJK>
       (?$B2f(B . "0x6211") ;; <CJK>
       (?$B2g(B . "0x7259") ;; <CJK>
       (?$B2h(B . "0x753B") ;; <CJK>
       (?$B2i(B . "0x81E5") ;; <CJK>
       (?$B2j(B . "0x82BD") ;; <CJK>
       (?$B2k(B . "0x86FE") ;; <CJK>
       (?$B2l(B . "0x8CC0") ;; <CJK>
       (?$B2m(B . "0x96C5") ;; <CJK>
       (?$B2n(B . "0x9913") ;; <CJK>
       (?$B2o(B . "0x99D5") ;; <CJK>
       (?$B2p(B . "0x4ECB") ;; <CJK>
       (?$B2q(B . "0x4F1A") ;; <CJK>
       (?$B2r(B . "0x89E3") ;; <CJK>
       (?$B2s(B . "0x56DE") ;; <CJK>
       (?$B2t(B . "0x584A") ;; <CJK>
       (?$B2u(B . "0x58CA") ;; <CJK>
       (?$B2v(B . "0x5EFB") ;; <CJK>
       (?$B2w(B . "0x5FEB") ;; <CJK>
       (?$B2x(B . "0x602A") ;; <CJK>
       (?$B2y(B . "0x6094") ;; <CJK>
       (?$B2z(B . "0x6062") ;; <CJK>
       (?$B2{(B . "0x61D0") ;; <CJK>
       (?$B2|(B . "0x6212") ;; <CJK>
       (?$B2}(B . "0x62D0") ;; <CJK>
       (?$B2~(B . "0x6539") ;; <CJK>
       (?$B3!(B . "0x9B41") ;; <CJK>
       (?$B3"(B . "0x6666") ;; <CJK>
       (?$B3#(B . "0x68B0") ;; <CJK>
       (?$B3$(B . "0x6D77") ;; <CJK>
       (?$B3%(B . "0x7070") ;; <CJK>
       (?$B3&(B . "0x754C") ;; <CJK>
       (?$B3'(B . "0x7686") ;; <CJK>
       (?$B3((B . "0x7D75") ;; <CJK>
       (?$B3)(B . "0x82A5") ;; <CJK>
       (?$B3*(B . "0x87F9") ;; <CJK>
       (?$B3+(B . "0x958B") ;; <CJK>
       (?$B3,(B . "0x968E") ;; <CJK>
       (?$B3-(B . "0x8C9D") ;; <CJK>
       (?$B3.(B . "0x51F1") ;; <CJK>
       (?$B3/(B . "0x52BE") ;; <CJK>
       (?$B30(B . "0x5916") ;; <CJK>
       (?$B31(B . "0x54B3") ;; <CJK>
       (?$B32(B . "0x5BB3") ;; <CJK>
       (?$B33(B . "0x5D16") ;; <CJK>
       (?$B34(B . "0x6168") ;; <CJK>
       (?$B35(B . "0x6982") ;; <CJK>
       (?$B36(B . "0x6DAF") ;; <CJK>
       (?$B37(B . "0x788D") ;; <CJK>
       (?$B38(B . "0x84CB") ;; <CJK>
       (?$B39(B . "0x8857") ;; <CJK>
       (?$B3:(B . "0x8A72") ;; <CJK>
       (?$B3;(B . "0x93A7") ;; <CJK>
       (?$B3<(B . "0x9AB8") ;; <CJK>
       (?$B3=(B . "0x6D6C") ;; <CJK>
       (?$B3>(B . "0x99A8") ;; <CJK>
       (?$B3?(B . "0x86D9") ;; <CJK>
       (?$B3@(B . "0x57A3") ;; <CJK>
       (?$B3A(B . "0x67FF") ;; <CJK>
       (?$B3B(B . "0x86CE") ;; <CJK>
       (?$B3C(B . "0x920E") ;; <CJK>
       (?$B3D(B . "0x5283") ;; <CJK>
       (?$B3E(B . "0x5687") ;; <CJK>
       (?$B3F(B . "0x5404") ;; <CJK>
       (?$B3G(B . "0x5ED3") ;; <CJK>
       (?$B3H(B . "0x62E1") ;; <CJK>
       (?$B3I(B . "0x64B9") ;; <CJK>
       (?$B3J(B . "0x683C") ;; <CJK>
       (?$B3K(B . "0x6838") ;; <CJK>
       (?$B3L(B . "0x6BBB") ;; <CJK>
       (?$B3M(B . "0x7372") ;; <CJK>
       (?$B3N(B . "0x78BA") ;; <CJK>
       (?$B3O(B . "0x7A6B") ;; <CJK>
       (?$B3P(B . "0x899A") ;; <CJK>
       (?$B3Q(B . "0x89D2") ;; <CJK>
       (?$B3R(B . "0x8D6B") ;; <CJK>
       (?$B3S(B . "0x8F03") ;; <CJK>
       (?$B3T(B . "0x90ED") ;; <CJK>
       (?$B3U(B . "0x95A3") ;; <CJK>
       (?$B3V(B . "0x9694") ;; <CJK>
       (?$B3W(B . "0x9769") ;; <CJK>
       (?$B3X(B . "0x5B66") ;; <CJK>
       (?$B3Y(B . "0x5CB3") ;; <CJK>
       (?$B3Z(B . "0x697D") ;; <CJK>
       (?$B3[(B . "0x984D") ;; <CJK>
       (?$B3\(B . "0x984E") ;; <CJK>
       (?$B3](B . "0x639B") ;; <CJK>
       (?$B3^(B . "0x7B20") ;; <CJK>
       (?$B3_(B . "0x6A2B") ;; <CJK>
       (?$B3`(B . "0x6A7F") ;; <CJK>
       (?$B3a(B . "0x68B6") ;; <CJK>
       (?$B3b(B . "0x9C0D") ;; <CJK>
       (?$B3c(B . "0x6F5F") ;; <CJK>
       (?$B3d(B . "0x5272") ;; <CJK>
       (?$B3e(B . "0x559D") ;; <CJK>
       (?$B3f(B . "0x6070") ;; <CJK>
       (?$B3g(B . "0x62EC") ;; <CJK>
       (?$B3h(B . "0x6D3B") ;; <CJK>
       (?$B3i(B . "0x6E07") ;; <CJK>
       (?$B3j(B . "0x6ED1") ;; <CJK>
       (?$B3k(B . "0x845B") ;; <CJK>
       (?$B3l(B . "0x8910") ;; <CJK>
       (?$B3m(B . "0x8F44") ;; <CJK>
       (?$B3n(B . "0x4E14") ;; <CJK>
       (?$B3o(B . "0x9C39") ;; <CJK>
       (?$B3p(B . "0x53F6") ;; <CJK>
       (?$B3q(B . "0x691B") ;; <CJK>
       (?$B3r(B . "0x6A3A") ;; <CJK>
       (?$B3s(B . "0x9784") ;; <CJK>
       (?$B3t(B . "0x682A") ;; <CJK>
       (?$B3u(B . "0x515C") ;; <CJK>
       (?$B3v(B . "0x7AC3") ;; <CJK>
       (?$B3w(B . "0x84B2") ;; <CJK>
       (?$B3x(B . "0x91DC") ;; <CJK>
       (?$B3y(B . "0x938C") ;; <CJK>
       (?$B3z(B . "0x565B") ;; <CJK>
       (?$B3{(B . "0x9D28") ;; <CJK>
       (?$B3|(B . "0x6822") ;; <CJK>
       (?$B3}(B . "0x8305") ;; <CJK>
       (?$B3~(B . "0x8431") ;; <CJK>
       (?$B4!(B . "0x7CA5") ;; <CJK>
       (?$B4"(B . "0x5208") ;; <CJK>
       (?$B4#(B . "0x82C5") ;; <CJK>
       (?$B4$(B . "0x74E6") ;; <CJK>
       (?$B4%(B . "0x4E7E") ;; <CJK>
       (?$B4&(B . "0x4F83") ;; <CJK>
       (?$B4'(B . "0x51A0") ;; <CJK>
       (?$B4((B . "0x5BD2") ;; <CJK>
       (?$B4)(B . "0x520A") ;; <CJK>
       (?$B4*(B . "0x52D8") ;; <CJK>
       (?$B4+(B . "0x52E7") ;; <CJK>
       (?$B4,(B . "0x5DFB") ;; <CJK>
       (?$B4-(B . "0x559A") ;; <CJK>
       (?$B4.(B . "0x582A") ;; <CJK>
       (?$B4/(B . "0x59E6") ;; <CJK>
       (?$B40(B . "0x5B8C") ;; <CJK>
       (?$B41(B . "0x5B98") ;; <CJK>
       (?$B42(B . "0x5BDB") ;; <CJK>
       (?$B43(B . "0x5E72") ;; <CJK>
       (?$B44(B . "0x5E79") ;; <CJK>
       (?$B45(B . "0x60A3") ;; <CJK>
       (?$B46(B . "0x611F") ;; <CJK>
       (?$B47(B . "0x6163") ;; <CJK>
       (?$B48(B . "0x61BE") ;; <CJK>
       (?$B49(B . "0x63DB") ;; <CJK>
       (?$B4:(B . "0x6562") ;; <CJK>
       (?$B4;(B . "0x67D1") ;; <CJK>
       (?$B4<(B . "0x6853") ;; <CJK>
       (?$B4=(B . "0x68FA") ;; <CJK>
       (?$B4>(B . "0x6B3E") ;; <CJK>
       (?$B4?(B . "0x6B53") ;; <CJK>
       (?$B4@(B . "0x6C57") ;; <CJK>
       (?$B4A(B . "0x6F22") ;; <CJK>
       (?$B4B(B . "0x6F97") ;; <CJK>
       (?$B4C(B . "0x6F45") ;; <CJK>
       (?$B4D(B . "0x74B0") ;; <CJK>
       (?$B4E(B . "0x7518") ;; <CJK>
       (?$B4F(B . "0x76E3") ;; <CJK>
       (?$B4G(B . "0x770B") ;; <CJK>
       (?$B4H(B . "0x7AFF") ;; <CJK>
       (?$B4I(B . "0x7BA1") ;; <CJK>
       (?$B4J(B . "0x7C21") ;; <CJK>
       (?$B4K(B . "0x7DE9") ;; <CJK>
       (?$B4L(B . "0x7F36") ;; <CJK>
       (?$B4M(B . "0x7FF0") ;; <CJK>
       (?$B4N(B . "0x809D") ;; <CJK>
       (?$B4O(B . "0x8266") ;; <CJK>
       (?$B4P(B . "0x839E") ;; <CJK>
       (?$B4Q(B . "0x89B3") ;; <CJK>
       (?$B4R(B . "0x8ACC") ;; <CJK>
       (?$B4S(B . "0x8CAB") ;; <CJK>
       (?$B4T(B . "0x9084") ;; <CJK>
       (?$B4U(B . "0x9451") ;; <CJK>
       (?$B4V(B . "0x9593") ;; <CJK>
       (?$B4W(B . "0x9591") ;; <CJK>
       (?$B4X(B . "0x95A2") ;; <CJK>
       (?$B4Y(B . "0x9665") ;; <CJK>
       (?$B4Z(B . "0x97D3") ;; <CJK>
       (?$B4[(B . "0x9928") ;; <CJK>
       (?$B4\(B . "0x8218") ;; <CJK>
       (?$B4](B . "0x4E38") ;; <CJK>
       (?$B4^(B . "0x542B") ;; <CJK>
       (?$B4_(B . "0x5CB8") ;; <CJK>
       (?$B4`(B . "0x5DCC") ;; <CJK>
       (?$B4a(B . "0x73A9") ;; <CJK>
       (?$B4b(B . "0x764C") ;; <CJK>
       (?$B4c(B . "0x773C") ;; <CJK>
       (?$B4d(B . "0x5CA9") ;; <CJK>
       (?$B4e(B . "0x7FEB") ;; <CJK>
       (?$B4f(B . "0x8D0B") ;; <CJK>
       (?$B4g(B . "0x96C1") ;; <CJK>
       (?$B4h(B . "0x9811") ;; <CJK>
       (?$B4i(B . "0x9854") ;; <CJK>
       (?$B4j(B . "0x9858") ;; <CJK>
       (?$B4k(B . "0x4F01") ;; <CJK>
       (?$B4l(B . "0x4F0E") ;; <CJK>
       (?$B4m(B . "0x5371") ;; <CJK>
       (?$B4n(B . "0x559C") ;; <CJK>
       (?$B4o(B . "0x5668") ;; <CJK>
       (?$B4p(B . "0x57FA") ;; <CJK>
       (?$B4q(B . "0x5947") ;; <CJK>
       (?$B4r(B . "0x5B09") ;; <CJK>
       (?$B4s(B . "0x5BC4") ;; <CJK>
       (?$B4t(B . "0x5C90") ;; <CJK>
       (?$B4u(B . "0x5E0C") ;; <CJK>
       (?$B4v(B . "0x5E7E") ;; <CJK>
       (?$B4w(B . "0x5FCC") ;; <CJK>
       (?$B4x(B . "0x63EE") ;; <CJK>
       (?$B4y(B . "0x673A") ;; <CJK>
       (?$B4z(B . "0x65D7") ;; <CJK>
       (?$B4{(B . "0x65E2") ;; <CJK>
       (?$B4|(B . "0x671F") ;; <CJK>
       (?$B4}(B . "0x68CB") ;; <CJK>
       (?$B4~(B . "0x68C4") ;; <CJK>
       (?$B5!(B . "0x6A5F") ;; <CJK>
       (?$B5"(B . "0x5E30") ;; <CJK>
       (?$B5#(B . "0x6BC5") ;; <CJK>
       (?$B5$(B . "0x6C17") ;; <CJK>
       (?$B5%(B . "0x6C7D") ;; <CJK>
       (?$B5&(B . "0x757F") ;; <CJK>
       (?$B5'(B . "0x7948") ;; <CJK>
       (?$B5((B . "0x5B63") ;; <CJK>
       (?$B5)(B . "0x7A00") ;; <CJK>
       (?$B5*(B . "0x7D00") ;; <CJK>
       (?$B5+(B . "0x5FBD") ;; <CJK>
       (?$B5,(B . "0x898F") ;; <CJK>
       (?$B5-(B . "0x8A18") ;; <CJK>
       (?$B5.(B . "0x8CB4") ;; <CJK>
       (?$B5/(B . "0x8D77") ;; <CJK>
       (?$B50(B . "0x8ECC") ;; <CJK>
       (?$B51(B . "0x8F1D") ;; <CJK>
       (?$B52(B . "0x98E2") ;; <CJK>
       (?$B53(B . "0x9A0E") ;; <CJK>
       (?$B54(B . "0x9B3C") ;; <CJK>
       (?$B55(B . "0x4E80") ;; <CJK>
       (?$B56(B . "0x507D") ;; <CJK>
       (?$B57(B . "0x5100") ;; <CJK>
       (?$B58(B . "0x5993") ;; <CJK>
       (?$B59(B . "0x5B9C") ;; <CJK>
       (?$B5:(B . "0x622F") ;; <CJK>
       (?$B5;(B . "0x6280") ;; <CJK>
       (?$B5<(B . "0x64EC") ;; <CJK>
       (?$B5=(B . "0x6B3A") ;; <CJK>
       (?$B5>(B . "0x72A0") ;; <CJK>
       (?$B5?(B . "0x7591") ;; <CJK>
       (?$B5@(B . "0x7947") ;; <CJK>
       (?$B5A(B . "0x7FA9") ;; <CJK>
       (?$B5B(B . "0x87FB") ;; <CJK>
       (?$B5C(B . "0x8ABC") ;; <CJK>
       (?$B5D(B . "0x8B70") ;; <CJK>
       (?$B5E(B . "0x63AC") ;; <CJK>
       (?$B5F(B . "0x83CA") ;; <CJK>
       (?$B5G(B . "0x97A0") ;; <CJK>
       (?$B5H(B . "0x5409") ;; <CJK>
       (?$B5I(B . "0x5403") ;; <CJK>
       (?$B5J(B . "0x55AB") ;; <CJK>
       (?$B5K(B . "0x6854") ;; <CJK>
       (?$B5L(B . "0x6A58") ;; <CJK>
       (?$B5M(B . "0x8A70") ;; <CJK>
       (?$B5N(B . "0x7827") ;; <CJK>
       (?$B5O(B . "0x6775") ;; <CJK>
       (?$B5P(B . "0x9ECD") ;; <CJK>
       (?$B5Q(B . "0x5374") ;; <CJK>
       (?$B5R(B . "0x5BA2") ;; <CJK>
       (?$B5S(B . "0x811A") ;; <CJK>
       (?$B5T(B . "0x8650") ;; <CJK>
       (?$B5U(B . "0x9006") ;; <CJK>
       (?$B5V(B . "0x4E18") ;; <CJK>
       (?$B5W(B . "0x4E45") ;; <CJK>
       (?$B5X(B . "0x4EC7") ;; <CJK>
       (?$B5Y(B . "0x4F11") ;; <CJK>
       (?$B5Z(B . "0x53CA") ;; <CJK>
       (?$B5[(B . "0x5438") ;; <CJK>
       (?$B5\(B . "0x5BAE") ;; <CJK>
       (?$B5](B . "0x5F13") ;; <CJK>
       (?$B5^(B . "0x6025") ;; <CJK>
       (?$B5_(B . "0x6551") ;; <CJK>
       (?$B5`(B . "0x673D") ;; <CJK>
       (?$B5a(B . "0x6C42") ;; <CJK>
       (?$B5b(B . "0x6C72") ;; <CJK>
       (?$B5c(B . "0x6CE3") ;; <CJK>
       (?$B5d(B . "0x7078") ;; <CJK>
       (?$B5e(B . "0x7403") ;; <CJK>
       (?$B5f(B . "0x7A76") ;; <CJK>
       (?$B5g(B . "0x7AAE") ;; <CJK>
       (?$B5h(B . "0x7B08") ;; <CJK>
       (?$B5i(B . "0x7D1A") ;; <CJK>
       (?$B5j(B . "0x7CFE") ;; <CJK>
       (?$B5k(B . "0x7D66") ;; <CJK>
       (?$B5l(B . "0x65E7") ;; <CJK>
       (?$B5m(B . "0x725B") ;; <CJK>
       (?$B5n(B . "0x53BB") ;; <CJK>
       (?$B5o(B . "0x5C45") ;; <CJK>
       (?$B5p(B . "0x5DE8") ;; <CJK>
       (?$B5q(B . "0x62D2") ;; <CJK>
       (?$B5r(B . "0x62E0") ;; <CJK>
       (?$B5s(B . "0x6319") ;; <CJK>
       (?$B5t(B . "0x6E20") ;; <CJK>
       (?$B5u(B . "0x865A") ;; <CJK>
       (?$B5v(B . "0x8A31") ;; <CJK>
       (?$B5w(B . "0x8DDD") ;; <CJK>
       (?$B5x(B . "0x92F8") ;; <CJK>
       (?$B5y(B . "0x6F01") ;; <CJK>
       (?$B5z(B . "0x79A6") ;; <CJK>
       (?$B5{(B . "0x9B5A") ;; <CJK>
       (?$B5|(B . "0x4EA8") ;; <CJK>
       (?$B5}(B . "0x4EAB") ;; <CJK>
       (?$B5~(B . "0x4EAC") ;; <CJK>
       (?$B6!(B . "0x4F9B") ;; <CJK>
       (?$B6"(B . "0x4FA0") ;; <CJK>
       (?$B6#(B . "0x50D1") ;; <CJK>
       (?$B6$(B . "0x5147") ;; <CJK>
       (?$B6%(B . "0x7AF6") ;; <CJK>
       (?$B6&(B . "0x5171") ;; <CJK>
       (?$B6'(B . "0x51F6") ;; <CJK>
       (?$B6((B . "0x5354") ;; <CJK>
       (?$B6)(B . "0x5321") ;; <CJK>
       (?$B6*(B . "0x537F") ;; <CJK>
       (?$B6+(B . "0x53EB") ;; <CJK>
       (?$B6,(B . "0x55AC") ;; <CJK>
       (?$B6-(B . "0x5883") ;; <CJK>
       (?$B6.(B . "0x5CE1") ;; <CJK>
       (?$B6/(B . "0x5F37") ;; <CJK>
       (?$B60(B . "0x5F4A") ;; <CJK>
       (?$B61(B . "0x602F") ;; <CJK>
       (?$B62(B . "0x6050") ;; <CJK>
       (?$B63(B . "0x606D") ;; <CJK>
       (?$B64(B . "0x631F") ;; <CJK>
       (?$B65(B . "0x6559") ;; <CJK>
       (?$B66(B . "0x6A4B") ;; <CJK>
       (?$B67(B . "0x6CC1") ;; <CJK>
       (?$B68(B . "0x72C2") ;; <CJK>
       (?$B69(B . "0x72ED") ;; <CJK>
       (?$B6:(B . "0x77EF") ;; <CJK>
       (?$B6;(B . "0x80F8") ;; <CJK>
       (?$B6<(B . "0x8105") ;; <CJK>
       (?$B6=(B . "0x8208") ;; <CJK>
       (?$B6>(B . "0x854E") ;; <CJK>
       (?$B6?(B . "0x90F7") ;; <CJK>
       (?$B6@(B . "0x93E1") ;; <CJK>
       (?$B6A(B . "0x97FF") ;; <CJK>
       (?$B6B(B . "0x9957") ;; <CJK>
       (?$B6C(B . "0x9A5A") ;; <CJK>
       (?$B6D(B . "0x4EF0") ;; <CJK>
       (?$B6E(B . "0x51DD") ;; <CJK>
       (?$B6F(B . "0x5C2D") ;; <CJK>
       (?$B6G(B . "0x6681") ;; <CJK>
       (?$B6H(B . "0x696D") ;; <CJK>
       (?$B6I(B . "0x5C40") ;; <CJK>
       (?$B6J(B . "0x66F2") ;; <CJK>
       (?$B6K(B . "0x6975") ;; <CJK>
       (?$B6L(B . "0x7389") ;; <CJK>
       (?$B6M(B . "0x6850") ;; <CJK>
       (?$B6N(B . "0x7C81") ;; <CJK>
       (?$B6O(B . "0x50C5") ;; <CJK>
       (?$B6P(B . "0x52E4") ;; <CJK>
       (?$B6Q(B . "0x5747") ;; <CJK>
       (?$B6R(B . "0x5DFE") ;; <CJK>
       (?$B6S(B . "0x9326") ;; <CJK>
       (?$B6T(B . "0x65A4") ;; <CJK>
       (?$B6U(B . "0x6B23") ;; <CJK>
       (?$B6V(B . "0x6B3D") ;; <CJK>
       (?$B6W(B . "0x7434") ;; <CJK>
       (?$B6X(B . "0x7981") ;; <CJK>
       (?$B6Y(B . "0x79BD") ;; <CJK>
       (?$B6Z(B . "0x7B4B") ;; <CJK>
       (?$B6[(B . "0x7DCA") ;; <CJK>
       (?$B6\(B . "0x82B9") ;; <CJK>
       (?$B6](B . "0x83CC") ;; <CJK>
       (?$B6^(B . "0x887F") ;; <CJK>
       (?$B6_(B . "0x895F") ;; <CJK>
       (?$B6`(B . "0x8B39") ;; <CJK>
       (?$B6a(B . "0x8FD1") ;; <CJK>
       (?$B6b(B . "0x91D1") ;; <CJK>
       (?$B6c(B . "0x541F") ;; <CJK>
       (?$B6d(B . "0x9280") ;; <CJK>
       (?$B6e(B . "0x4E5D") ;; <CJK>
       (?$B6f(B . "0x5036") ;; <CJK>
       (?$B6g(B . "0x53E5") ;; <CJK>
       (?$B6h(B . "0x533A") ;; <CJK>
       (?$B6i(B . "0x72D7") ;; <CJK>
       (?$B6j(B . "0x7396") ;; <CJK>
       (?$B6k(B . "0x77E9") ;; <CJK>
       (?$B6l(B . "0x82E6") ;; <CJK>
       (?$B6m(B . "0x8EAF") ;; <CJK>
       (?$B6n(B . "0x99C6") ;; <CJK>
       (?$B6o(B . "0x99C8") ;; <CJK>
       (?$B6p(B . "0x99D2") ;; <CJK>
       (?$B6q(B . "0x5177") ;; <CJK>
       (?$B6r(B . "0x611A") ;; <CJK>
       (?$B6s(B . "0x865E") ;; <CJK>
       (?$B6t(B . "0x55B0") ;; <CJK>
       (?$B6u(B . "0x7A7A") ;; <CJK>
       (?$B6v(B . "0x5076") ;; <CJK>
       (?$B6w(B . "0x5BD3") ;; <CJK>
       (?$B6x(B . "0x9047") ;; <CJK>
       (?$B6y(B . "0x9685") ;; <CJK>
       (?$B6z(B . "0x4E32") ;; <CJK>
       (?$B6{(B . "0x6ADB") ;; <CJK>
       (?$B6|(B . "0x91E7") ;; <CJK>
       (?$B6}(B . "0x5C51") ;; <CJK>
       (?$B6~(B . "0x5C48") ;; <CJK>
       (?$B7!(B . "0x6398") ;; <CJK>
       (?$B7"(B . "0x7A9F") ;; <CJK>
       (?$B7#(B . "0x6C93") ;; <CJK>
       (?$B7$(B . "0x9774") ;; <CJK>
       (?$B7%(B . "0x8F61") ;; <CJK>
       (?$B7&(B . "0x7AAA") ;; <CJK>
       (?$B7'(B . "0x718A") ;; <CJK>
       (?$B7((B . "0x9688") ;; <CJK>
       (?$B7)(B . "0x7C82") ;; <CJK>
       (?$B7*(B . "0x6817") ;; <CJK>
       (?$B7+(B . "0x7E70") ;; <CJK>
       (?$B7,(B . "0x6851") ;; <CJK>
       (?$B7-(B . "0x936C") ;; <CJK>
       (?$B7.(B . "0x52F2") ;; <CJK>
       (?$B7/(B . "0x541B") ;; <CJK>
       (?$B70(B . "0x85AB") ;; <CJK>
       (?$B71(B . "0x8A13") ;; <CJK>
       (?$B72(B . "0x7FA4") ;; <CJK>
       (?$B73(B . "0x8ECD") ;; <CJK>
       (?$B74(B . "0x90E1") ;; <CJK>
       (?$B75(B . "0x5366") ;; <CJK>
       (?$B76(B . "0x8888") ;; <CJK>
       (?$B77(B . "0x7941") ;; <CJK>
       (?$B78(B . "0x4FC2") ;; <CJK>
       (?$B79(B . "0x50BE") ;; <CJK>
       (?$B7:(B . "0x5211") ;; <CJK>
       (?$B7;(B . "0x5144") ;; <CJK>
       (?$B7<(B . "0x5553") ;; <CJK>
       (?$B7=(B . "0x572D") ;; <CJK>
       (?$B7>(B . "0x73EA") ;; <CJK>
       (?$B7?(B . "0x578B") ;; <CJK>
       (?$B7@(B . "0x5951") ;; <CJK>
       (?$B7A(B . "0x5F62") ;; <CJK>
       (?$B7B(B . "0x5F84") ;; <CJK>
       (?$B7C(B . "0x6075") ;; <CJK>
       (?$B7D(B . "0x6176") ;; <CJK>
       (?$B7E(B . "0x6167") ;; <CJK>
       (?$B7F(B . "0x61A9") ;; <CJK>
       (?$B7G(B . "0x63B2") ;; <CJK>
       (?$B7H(B . "0x643A") ;; <CJK>
       (?$B7I(B . "0x656C") ;; <CJK>
       (?$B7J(B . "0x666F") ;; <CJK>
       (?$B7K(B . "0x6842") ;; <CJK>
       (?$B7L(B . "0x6E13") ;; <CJK>
       (?$B7M(B . "0x7566") ;; <CJK>
       (?$B7N(B . "0x7A3D") ;; <CJK>
       (?$B7O(B . "0x7CFB") ;; <CJK>
       (?$B7P(B . "0x7D4C") ;; <CJK>
       (?$B7Q(B . "0x7D99") ;; <CJK>
       (?$B7R(B . "0x7E4B") ;; <CJK>
       (?$B7S(B . "0x7F6B") ;; <CJK>
       (?$B7T(B . "0x830E") ;; <CJK>
       (?$B7U(B . "0x834A") ;; <CJK>
       (?$B7V(B . "0x86CD") ;; <CJK>
       (?$B7W(B . "0x8A08") ;; <CJK>
       (?$B7X(B . "0x8A63") ;; <CJK>
       (?$B7Y(B . "0x8B66") ;; <CJK>
       (?$B7Z(B . "0x8EFD") ;; <CJK>
       (?$B7[(B . "0x981A") ;; <CJK>
       (?$B7\(B . "0x9D8F") ;; <CJK>
       (?$B7](B . "0x82B8") ;; <CJK>
       (?$B7^(B . "0x8FCE") ;; <CJK>
       (?$B7_(B . "0x9BE8") ;; <CJK>
       (?$B7`(B . "0x5287") ;; <CJK>
       (?$B7a(B . "0x621F") ;; <CJK>
       (?$B7b(B . "0x6483") ;; <CJK>
       (?$B7c(B . "0x6FC0") ;; <CJK>
       (?$B7d(B . "0x9699") ;; <CJK>
       (?$B7e(B . "0x6841") ;; <CJK>
       (?$B7f(B . "0x5091") ;; <CJK>
       (?$B7g(B . "0x6B20") ;; <CJK>
       (?$B7h(B . "0x6C7A") ;; <CJK>
       (?$B7i(B . "0x6F54") ;; <CJK>
       (?$B7j(B . "0x7A74") ;; <CJK>
       (?$B7k(B . "0x7D50") ;; <CJK>
       (?$B7l(B . "0x8840") ;; <CJK>
       (?$B7m(B . "0x8A23") ;; <CJK>
       (?$B7n(B . "0x6708") ;; <CJK>
       (?$B7o(B . "0x4EF6") ;; <CJK>
       (?$B7p(B . "0x5039") ;; <CJK>
       (?$B7q(B . "0x5026") ;; <CJK>
       (?$B7r(B . "0x5065") ;; <CJK>
       (?$B7s(B . "0x517C") ;; <CJK>
       (?$B7t(B . "0x5238") ;; <CJK>
       (?$B7u(B . "0x5263") ;; <CJK>
       (?$B7v(B . "0x55A7") ;; <CJK>
       (?$B7w(B . "0x570F") ;; <CJK>
       (?$B7x(B . "0x5805") ;; <CJK>
       (?$B7y(B . "0x5ACC") ;; <CJK>
       (?$B7z(B . "0x5EFA") ;; <CJK>
       (?$B7{(B . "0x61B2") ;; <CJK>
       (?$B7|(B . "0x61F8") ;; <CJK>
       (?$B7}(B . "0x62F3") ;; <CJK>
       (?$B7~(B . "0x6372") ;; <CJK>
       (?$B8!(B . "0x691C") ;; <CJK>
       (?$B8"(B . "0x6A29") ;; <CJK>
       (?$B8#(B . "0x727D") ;; <CJK>
       (?$B8$(B . "0x72AC") ;; <CJK>
       (?$B8%(B . "0x732E") ;; <CJK>
       (?$B8&(B . "0x7814") ;; <CJK>
       (?$B8'(B . "0x786F") ;; <CJK>
       (?$B8((B . "0x7D79") ;; <CJK>
       (?$B8)(B . "0x770C") ;; <CJK>
       (?$B8*(B . "0x80A9") ;; <CJK>
       (?$B8+(B . "0x898B") ;; <CJK>
       (?$B8,(B . "0x8B19") ;; <CJK>
       (?$B8-(B . "0x8CE2") ;; <CJK>
       (?$B8.(B . "0x8ED2") ;; <CJK>
       (?$B8/(B . "0x9063") ;; <CJK>
       (?$B80(B . "0x9375") ;; <CJK>
       (?$B81(B . "0x967A") ;; <CJK>
       (?$B82(B . "0x9855") ;; <CJK>
       (?$B83(B . "0x9A13") ;; <CJK>
       (?$B84(B . "0x9E78") ;; <CJK>
       (?$B85(B . "0x5143") ;; <CJK>
       (?$B86(B . "0x539F") ;; <CJK>
       (?$B87(B . "0x53B3") ;; <CJK>
       (?$B88(B . "0x5E7B") ;; <CJK>
       (?$B89(B . "0x5F26") ;; <CJK>
       (?$B8:(B . "0x6E1B") ;; <CJK>
       (?$B8;(B . "0x6E90") ;; <CJK>
       (?$B8<(B . "0x7384") ;; <CJK>
       (?$B8=(B . "0x73FE") ;; <CJK>
       (?$B8>(B . "0x7D43") ;; <CJK>
       (?$B8?(B . "0x8237") ;; <CJK>
       (?$B8@(B . "0x8A00") ;; <CJK>
       (?$B8A(B . "0x8AFA") ;; <CJK>
       (?$B8B(B . "0x9650") ;; <CJK>
       (?$B8C(B . "0x4E4E") ;; <CJK>
       (?$B8D(B . "0x500B") ;; <CJK>
       (?$B8E(B . "0x53E4") ;; <CJK>
       (?$B8F(B . "0x547C") ;; <CJK>
       (?$B8G(B . "0x56FA") ;; <CJK>
       (?$B8H(B . "0x59D1") ;; <CJK>
       (?$B8I(B . "0x5B64") ;; <CJK>
       (?$B8J(B . "0x5DF1") ;; <CJK>
       (?$B8K(B . "0x5EAB") ;; <CJK>
       (?$B8L(B . "0x5F27") ;; <CJK>
       (?$B8M(B . "0x6238") ;; <CJK>
       (?$B8N(B . "0x6545") ;; <CJK>
       (?$B8O(B . "0x67AF") ;; <CJK>
       (?$B8P(B . "0x6E56") ;; <CJK>
       (?$B8Q(B . "0x72D0") ;; <CJK>
       (?$B8R(B . "0x7CCA") ;; <CJK>
       (?$B8S(B . "0x88B4") ;; <CJK>
       (?$B8T(B . "0x80A1") ;; <CJK>
       (?$B8U(B . "0x80E1") ;; <CJK>
       (?$B8V(B . "0x83F0") ;; <CJK>
       (?$B8W(B . "0x864E") ;; <CJK>
       (?$B8X(B . "0x8A87") ;; <CJK>
       (?$B8Y(B . "0x8DE8") ;; <CJK>
       (?$B8Z(B . "0x9237") ;; <CJK>
       (?$B8[(B . "0x96C7") ;; <CJK>
       (?$B8\(B . "0x9867") ;; <CJK>
       (?$B8](B . "0x9F13") ;; <CJK>
       (?$B8^(B . "0x4E94") ;; <CJK>
       (?$B8_(B . "0x4E92") ;; <CJK>
       (?$B8`(B . "0x4F0D") ;; <CJK>
       (?$B8a(B . "0x5348") ;; <CJK>
       (?$B8b(B . "0x5449") ;; <CJK>
       (?$B8c(B . "0x543E") ;; <CJK>
       (?$B8d(B . "0x5A2F") ;; <CJK>
       (?$B8e(B . "0x5F8C") ;; <CJK>
       (?$B8f(B . "0x5FA1") ;; <CJK>
       (?$B8g(B . "0x609F") ;; <CJK>
       (?$B8h(B . "0x68A7") ;; <CJK>
       (?$B8i(B . "0x6A8E") ;; <CJK>
       (?$B8j(B . "0x745A") ;; <CJK>
       (?$B8k(B . "0x7881") ;; <CJK>
       (?$B8l(B . "0x8A9E") ;; <CJK>
       (?$B8m(B . "0x8AA4") ;; <CJK>
       (?$B8n(B . "0x8B77") ;; <CJK>
       (?$B8o(B . "0x9190") ;; <CJK>
       (?$B8p(B . "0x4E5E") ;; <CJK>
       (?$B8q(B . "0x9BC9") ;; <CJK>
       (?$B8r(B . "0x4EA4") ;; <CJK>
       (?$B8s(B . "0x4F7C") ;; <CJK>
       (?$B8t(B . "0x4FAF") ;; <CJK>
       (?$B8u(B . "0x5019") ;; <CJK>
       (?$B8v(B . "0x5016") ;; <CJK>
       (?$B8w(B . "0x5149") ;; <CJK>
       (?$B8x(B . "0x516C") ;; <CJK>
       (?$B8y(B . "0x529F") ;; <CJK>
       (?$B8z(B . "0x52B9") ;; <CJK>
       (?$B8{(B . "0x52FE") ;; <CJK>
       (?$B8|(B . "0x539A") ;; <CJK>
       (?$B8}(B . "0x53E3") ;; <CJK>
       (?$B8~(B . "0x5411") ;; <CJK>
       (?$B9!(B . "0x540E") ;; <CJK>
       (?$B9"(B . "0x5589") ;; <CJK>
       (?$B9#(B . "0x5751") ;; <CJK>
       (?$B9$(B . "0x57A2") ;; <CJK>
       (?$B9%(B . "0x597D") ;; <CJK>
       (?$B9&(B . "0x5B54") ;; <CJK>
       (?$B9'(B . "0x5B5D") ;; <CJK>
       (?$B9((B . "0x5B8F") ;; <CJK>
       (?$B9)(B . "0x5DE5") ;; <CJK>
       (?$B9*(B . "0x5DE7") ;; <CJK>
       (?$B9+(B . "0x5DF7") ;; <CJK>
       (?$B9,(B . "0x5E78") ;; <CJK>
       (?$B9-(B . "0x5E83") ;; <CJK>
       (?$B9.(B . "0x5E9A") ;; <CJK>
       (?$B9/(B . "0x5EB7") ;; <CJK>
       (?$B90(B . "0x5F18") ;; <CJK>
       (?$B91(B . "0x6052") ;; <CJK>
       (?$B92(B . "0x614C") ;; <CJK>
       (?$B93(B . "0x6297") ;; <CJK>
       (?$B94(B . "0x62D8") ;; <CJK>
       (?$B95(B . "0x63A7") ;; <CJK>
       (?$B96(B . "0x653B") ;; <CJK>
       (?$B97(B . "0x6602") ;; <CJK>
       (?$B98(B . "0x6643") ;; <CJK>
       (?$B99(B . "0x66F4") ;; <CJK>
       (?$B9:(B . "0x676D") ;; <CJK>
       (?$B9;(B . "0x6821") ;; <CJK>
       (?$B9<(B . "0x6897") ;; <CJK>
       (?$B9=(B . "0x69CB") ;; <CJK>
       (?$B9>(B . "0x6C5F") ;; <CJK>
       (?$B9?(B . "0x6D2A") ;; <CJK>
       (?$B9@(B . "0x6D69") ;; <CJK>
       (?$B9A(B . "0x6E2F") ;; <CJK>
       (?$B9B(B . "0x6E9D") ;; <CJK>
       (?$B9C(B . "0x7532") ;; <CJK>
       (?$B9D(B . "0x7687") ;; <CJK>
       (?$B9E(B . "0x786C") ;; <CJK>
       (?$B9F(B . "0x7A3F") ;; <CJK>
       (?$B9G(B . "0x7CE0") ;; <CJK>
       (?$B9H(B . "0x7D05") ;; <CJK>
       (?$B9I(B . "0x7D18") ;; <CJK>
       (?$B9J(B . "0x7D5E") ;; <CJK>
       (?$B9K(B . "0x7DB1") ;; <CJK>
       (?$B9L(B . "0x8015") ;; <CJK>
       (?$B9M(B . "0x8003") ;; <CJK>
       (?$B9N(B . "0x80AF") ;; <CJK>
       (?$B9O(B . "0x80B1") ;; <CJK>
       (?$B9P(B . "0x8154") ;; <CJK>
       (?$B9Q(B . "0x818F") ;; <CJK>
       (?$B9R(B . "0x822A") ;; <CJK>
       (?$B9S(B . "0x8352") ;; <CJK>
       (?$B9T(B . "0x884C") ;; <CJK>
       (?$B9U(B . "0x8861") ;; <CJK>
       (?$B9V(B . "0x8B1B") ;; <CJK>
       (?$B9W(B . "0x8CA2") ;; <CJK>
       (?$B9X(B . "0x8CFC") ;; <CJK>
       (?$B9Y(B . "0x90CA") ;; <CJK>
       (?$B9Z(B . "0x9175") ;; <CJK>
       (?$B9[(B . "0x9271") ;; <CJK>
       (?$B9\(B . "0x783F") ;; <CJK>
       (?$B9](B . "0x92FC") ;; <CJK>
       (?$B9^(B . "0x95A4") ;; <CJK>
       (?$B9_(B . "0x964D") ;; <CJK>
       (?$B9`(B . "0x9805") ;; <CJK>
       (?$B9a(B . "0x9999") ;; <CJK>
       (?$B9b(B . "0x9AD8") ;; <CJK>
       (?$B9c(B . "0x9D3B") ;; <CJK>
       (?$B9d(B . "0x525B") ;; <CJK>
       (?$B9e(B . "0x52AB") ;; <CJK>
       (?$B9f(B . "0x53F7") ;; <CJK>
       (?$B9g(B . "0x5408") ;; <CJK>
       (?$B9h(B . "0x58D5") ;; <CJK>
       (?$B9i(B . "0x62F7") ;; <CJK>
       (?$B9j(B . "0x6FE0") ;; <CJK>
       (?$B9k(B . "0x8C6A") ;; <CJK>
       (?$B9l(B . "0x8F5F") ;; <CJK>
       (?$B9m(B . "0x9EB9") ;; <CJK>
       (?$B9n(B . "0x514B") ;; <CJK>
       (?$B9o(B . "0x523B") ;; <CJK>
       (?$B9p(B . "0x544A") ;; <CJK>
       (?$B9q(B . "0x56FD") ;; <CJK>
       (?$B9r(B . "0x7A40") ;; <CJK>
       (?$B9s(B . "0x9177") ;; <CJK>
       (?$B9t(B . "0x9D60") ;; <CJK>
       (?$B9u(B . "0x9ED2") ;; <CJK>
       (?$B9v(B . "0x7344") ;; <CJK>
       (?$B9w(B . "0x6F09") ;; <CJK>
       (?$B9x(B . "0x8170") ;; <CJK>
       (?$B9y(B . "0x7511") ;; <CJK>
       (?$B9z(B . "0x5FFD") ;; <CJK>
       (?$B9{(B . "0x60DA") ;; <CJK>
       (?$B9|(B . "0x9AA8") ;; <CJK>
       (?$B9}(B . "0x72DB") ;; <CJK>
       (?$B9~(B . "0x8FBC") ;; <CJK>
       (?$B:!(B . "0x6B64") ;; <CJK>
       (?$B:"(B . "0x9803") ;; <CJK>
       (?$B:#(B . "0x4ECA") ;; <CJK>
       (?$B:$(B . "0x56F0") ;; <CJK>
       (?$B:%(B . "0x5764") ;; <CJK>
       (?$B:&(B . "0x58BE") ;; <CJK>
       (?$B:'(B . "0x5A5A") ;; <CJK>
       (?$B:((B . "0x6068") ;; <CJK>
       (?$B:)(B . "0x61C7") ;; <CJK>
       (?$B:*(B . "0x660F") ;; <CJK>
       (?$B:+(B . "0x6606") ;; <CJK>
       (?$B:,(B . "0x6839") ;; <CJK>
       (?$B:-(B . "0x68B1") ;; <CJK>
       (?$B:.(B . "0x6DF7") ;; <CJK>
       (?$B:/(B . "0x75D5") ;; <CJK>
       (?$B:0(B . "0x7D3A") ;; <CJK>
       (?$B:1(B . "0x826E") ;; <CJK>
       (?$B:2(B . "0x9B42") ;; <CJK>
       (?$B:3(B . "0x4E9B") ;; <CJK>
       (?$B:4(B . "0x4F50") ;; <CJK>
       (?$B:5(B . "0x53C9") ;; <CJK>
       (?$B:6(B . "0x5506") ;; <CJK>
       (?$B:7(B . "0x5D6F") ;; <CJK>
       (?$B:8(B . "0x5DE6") ;; <CJK>
       (?$B:9(B . "0x5DEE") ;; <CJK>
       (?$B::(B . "0x67FB") ;; <CJK>
       (?$B:;(B . "0x6C99") ;; <CJK>
       (?$B:<(B . "0x7473") ;; <CJK>
       (?$B:=(B . "0x7802") ;; <CJK>
       (?$B:>(B . "0x8A50") ;; <CJK>
       (?$B:?(B . "0x9396") ;; <CJK>
       (?$B:@(B . "0x88DF") ;; <CJK>
       (?$B:A(B . "0x5750") ;; <CJK>
       (?$B:B(B . "0x5EA7") ;; <CJK>
       (?$B:C(B . "0x632B") ;; <CJK>
       (?$B:D(B . "0x50B5") ;; <CJK>
       (?$B:E(B . "0x50AC") ;; <CJK>
       (?$B:F(B . "0x518D") ;; <CJK>
       (?$B:G(B . "0x6700") ;; <CJK>
       (?$B:H(B . "0x54C9") ;; <CJK>
       (?$B:I(B . "0x585E") ;; <CJK>
       (?$B:J(B . "0x59BB") ;; <CJK>
       (?$B:K(B . "0x5BB0") ;; <CJK>
       (?$B:L(B . "0x5F69") ;; <CJK>
       (?$B:M(B . "0x624D") ;; <CJK>
       (?$B:N(B . "0x63A1") ;; <CJK>
       (?$B:O(B . "0x683D") ;; <CJK>
       (?$B:P(B . "0x6B73") ;; <CJK>
       (?$B:Q(B . "0x6E08") ;; <CJK>
       (?$B:R(B . "0x707D") ;; <CJK>
       (?$B:S(B . "0x91C7") ;; <CJK>
       (?$B:T(B . "0x7280") ;; <CJK>
       (?$B:U(B . "0x7815") ;; <CJK>
       (?$B:V(B . "0x7826") ;; <CJK>
       (?$B:W(B . "0x796D") ;; <CJK>
       (?$B:X(B . "0x658E") ;; <CJK>
       (?$B:Y(B . "0x7D30") ;; <CJK>
       (?$B:Z(B . "0x83DC") ;; <CJK>
       (?$B:[(B . "0x88C1") ;; <CJK>
       (?$B:\(B . "0x8F09") ;; <CJK>
       (?$B:](B . "0x969B") ;; <CJK>
       (?$B:^(B . "0x5264") ;; <CJK>
       (?$B:_(B . "0x5728") ;; <CJK>
       (?$B:`(B . "0x6750") ;; <CJK>
       (?$B:a(B . "0x7F6A") ;; <CJK>
       (?$B:b(B . "0x8CA1") ;; <CJK>
       (?$B:c(B . "0x51B4") ;; <CJK>
       (?$B:d(B . "0x5742") ;; <CJK>
       (?$B:e(B . "0x962A") ;; <CJK>
       (?$B:f(B . "0x583A") ;; <CJK>
       (?$B:g(B . "0x698A") ;; <CJK>
       (?$B:h(B . "0x80B4") ;; <CJK>
       (?$B:i(B . "0x54B2") ;; <CJK>
       (?$B:j(B . "0x5D0E") ;; <CJK>
       (?$B:k(B . "0x57FC") ;; <CJK>
       (?$B:l(B . "0x7895") ;; <CJK>
       (?$B:m(B . "0x9DFA") ;; <CJK>
       (?$B:n(B . "0x4F5C") ;; <CJK>
       (?$B:o(B . "0x524A") ;; <CJK>
       (?$B:p(B . "0x548B") ;; <CJK>
       (?$B:q(B . "0x643E") ;; <CJK>
       (?$B:r(B . "0x6628") ;; <CJK>
       (?$B:s(B . "0x6714") ;; <CJK>
       (?$B:t(B . "0x67F5") ;; <CJK>
       (?$B:u(B . "0x7A84") ;; <CJK>
       (?$B:v(B . "0x7B56") ;; <CJK>
       (?$B:w(B . "0x7D22") ;; <CJK>
       (?$B:x(B . "0x932F") ;; <CJK>
       (?$B:y(B . "0x685C") ;; <CJK>
       (?$B:z(B . "0x9BAD") ;; <CJK>
       (?$B:{(B . "0x7B39") ;; <CJK>
       (?$B:|(B . "0x5319") ;; <CJK>
       (?$B:}(B . "0x518A") ;; <CJK>
       (?$B:~(B . "0x5237") ;; <CJK>
       (?$B;!(B . "0x5BDF") ;; <CJK>
       (?$B;"(B . "0x62F6") ;; <CJK>
       (?$B;#(B . "0x64AE") ;; <CJK>
       (?$B;$(B . "0x64E6") ;; <CJK>
       (?$B;%(B . "0x672D") ;; <CJK>
       (?$B;&(B . "0x6BBA") ;; <CJK>
       (?$B;'(B . "0x85A9") ;; <CJK>
       (?$B;((B . "0x96D1") ;; <CJK>
       (?$B;)(B . "0x7690") ;; <CJK>
       (?$B;*(B . "0x9BD6") ;; <CJK>
       (?$B;+(B . "0x634C") ;; <CJK>
       (?$B;,(B . "0x9306") ;; <CJK>
       (?$B;-(B . "0x9BAB") ;; <CJK>
       (?$B;.(B . "0x76BF") ;; <CJK>
       (?$B;/(B . "0x6652") ;; <CJK>
       (?$B;0(B . "0x4E09") ;; <CJK>
       (?$B;1(B . "0x5098") ;; <CJK>
       (?$B;2(B . "0x53C2") ;; <CJK>
       (?$B;3(B . "0x5C71") ;; <CJK>
       (?$B;4(B . "0x60E8") ;; <CJK>
       (?$B;5(B . "0x6492") ;; <CJK>
       (?$B;6(B . "0x6563") ;; <CJK>
       (?$B;7(B . "0x685F") ;; <CJK>
       (?$B;8(B . "0x71E6") ;; <CJK>
       (?$B;9(B . "0x73CA") ;; <CJK>
       (?$B;:(B . "0x7523") ;; <CJK>
       (?$B;;(B . "0x7B97") ;; <CJK>
       (?$B;<(B . "0x7E82") ;; <CJK>
       (?$B;=(B . "0x8695") ;; <CJK>
       (?$B;>(B . "0x8B83") ;; <CJK>
       (?$B;?(B . "0x8CDB") ;; <CJK>
       (?$B;@(B . "0x9178") ;; <CJK>
       (?$B;A(B . "0x9910") ;; <CJK>
       (?$B;B(B . "0x65AC") ;; <CJK>
       (?$B;C(B . "0x66AB") ;; <CJK>
       (?$B;D(B . "0x6B8B") ;; <CJK>
       (?$B;E(B . "0x4ED5") ;; <CJK>
       (?$B;F(B . "0x4ED4") ;; <CJK>
       (?$B;G(B . "0x4F3A") ;; <CJK>
       (?$B;H(B . "0x4F7F") ;; <CJK>
       (?$B;I(B . "0x523A") ;; <CJK>
       (?$B;J(B . "0x53F8") ;; <CJK>
       (?$B;K(B . "0x53F2") ;; <CJK>
       (?$B;L(B . "0x55E3") ;; <CJK>
       (?$B;M(B . "0x56DB") ;; <CJK>
       (?$B;N(B . "0x58EB") ;; <CJK>
       (?$B;O(B . "0x59CB") ;; <CJK>
       (?$B;P(B . "0x59C9") ;; <CJK>
       (?$B;Q(B . "0x59FF") ;; <CJK>
       (?$B;R(B . "0x5B50") ;; <CJK>
       (?$B;S(B . "0x5C4D") ;; <CJK>
       (?$B;T(B . "0x5E02") ;; <CJK>
       (?$B;U(B . "0x5E2B") ;; <CJK>
       (?$B;V(B . "0x5FD7") ;; <CJK>
       (?$B;W(B . "0x601D") ;; <CJK>
       (?$B;X(B . "0x6307") ;; <CJK>
       (?$B;Y(B . "0x652F") ;; <CJK>
       (?$B;Z(B . "0x5B5C") ;; <CJK>
       (?$B;[(B . "0x65AF") ;; <CJK>
       (?$B;\(B . "0x65BD") ;; <CJK>
       (?$B;](B . "0x65E8") ;; <CJK>
       (?$B;^(B . "0x679D") ;; <CJK>
       (?$B;_(B . "0x6B62") ;; <CJK>
       (?$B;`(B . "0x6B7B") ;; <CJK>
       (?$B;a(B . "0x6C0F") ;; <CJK>
       (?$B;b(B . "0x7345") ;; <CJK>
       (?$B;c(B . "0x7949") ;; <CJK>
       (?$B;d(B . "0x79C1") ;; <CJK>
       (?$B;e(B . "0x7CF8") ;; <CJK>
       (?$B;f(B . "0x7D19") ;; <CJK>
       (?$B;g(B . "0x7D2B") ;; <CJK>
       (?$B;h(B . "0x80A2") ;; <CJK>
       (?$B;i(B . "0x8102") ;; <CJK>
       (?$B;j(B . "0x81F3") ;; <CJK>
       (?$B;k(B . "0x8996") ;; <CJK>
       (?$B;l(B . "0x8A5E") ;; <CJK>
       (?$B;m(B . "0x8A69") ;; <CJK>
       (?$B;n(B . "0x8A66") ;; <CJK>
       (?$B;o(B . "0x8A8C") ;; <CJK>
       (?$B;p(B . "0x8AEE") ;; <CJK>
       (?$B;q(B . "0x8CC7") ;; <CJK>
       (?$B;r(B . "0x8CDC") ;; <CJK>
       (?$B;s(B . "0x96CC") ;; <CJK>
       (?$B;t(B . "0x98FC") ;; <CJK>
       (?$B;u(B . "0x6B6F") ;; <CJK>
       (?$B;v(B . "0x4E8B") ;; <CJK>
       (?$B;w(B . "0x4F3C") ;; <CJK>
       (?$B;x(B . "0x4F8D") ;; <CJK>
       (?$B;y(B . "0x5150") ;; <CJK>
       (?$B;z(B . "0x5B57") ;; <CJK>
       (?$B;{(B . "0x5BFA") ;; <CJK>
       (?$B;|(B . "0x6148") ;; <CJK>
       (?$B;}(B . "0x6301") ;; <CJK>
       (?$B;~(B . "0x6642") ;; <CJK>
       (?$B<!(B . "0x6B21") ;; <CJK>
       (?$B<"(B . "0x6ECB") ;; <CJK>
       (?$B<#(B . "0x6CBB") ;; <CJK>
       (?$B<$(B . "0x723E") ;; <CJK>
       (?$B<%(B . "0x74BD") ;; <CJK>
       (?$B<&(B . "0x75D4") ;; <CJK>
       (?$B<'(B . "0x78C1") ;; <CJK>
       (?$B<((B . "0x793A") ;; <CJK>
       (?$B<)(B . "0x800C") ;; <CJK>
       (?$B<*(B . "0x8033") ;; <CJK>
       (?$B<+(B . "0x81EA") ;; <CJK>
       (?$B<,(B . "0x8494") ;; <CJK>
       (?$B<-(B . "0x8F9E") ;; <CJK>
       (?$B<.(B . "0x6C50") ;; <CJK>
       (?$B</(B . "0x9E7F") ;; <CJK>
       (?$B<0(B . "0x5F0F") ;; <CJK>
       (?$B<1(B . "0x8B58") ;; <CJK>
       (?$B<2(B . "0x9D2B") ;; <CJK>
       (?$B<3(B . "0x7AFA") ;; <CJK>
       (?$B<4(B . "0x8EF8") ;; <CJK>
       (?$B<5(B . "0x5B8D") ;; <CJK>
       (?$B<6(B . "0x96EB") ;; <CJK>
       (?$B<7(B . "0x4E03") ;; <CJK>
       (?$B<8(B . "0x53F1") ;; <CJK>
       (?$B<9(B . "0x57F7") ;; <CJK>
       (?$B<:(B . "0x5931") ;; <CJK>
       (?$B<;(B . "0x5AC9") ;; <CJK>
       (?$B<<(B . "0x5BA4") ;; <CJK>
       (?$B<=(B . "0x6089") ;; <CJK>
       (?$B<>(B . "0x6E7F") ;; <CJK>
       (?$B<?(B . "0x6F06") ;; <CJK>
       (?$B<@(B . "0x75BE") ;; <CJK>
       (?$B<A(B . "0x8CEA") ;; <CJK>
       (?$B<B(B . "0x5B9F") ;; <CJK>
       (?$B<C(B . "0x8500") ;; <CJK>
       (?$B<D(B . "0x7BE0") ;; <CJK>
       (?$B<E(B . "0x5072") ;; <CJK>
       (?$B<F(B . "0x67F4") ;; <CJK>
       (?$B<G(B . "0x829D") ;; <CJK>
       (?$B<H(B . "0x5C61") ;; <CJK>
       (?$B<I(B . "0x854A") ;; <CJK>
       (?$B<J(B . "0x7E1E") ;; <CJK>
       (?$B<K(B . "0x820E") ;; <CJK>
       (?$B<L(B . "0x5199") ;; <CJK>
       (?$B<M(B . "0x5C04") ;; <CJK>
       (?$B<N(B . "0x6368") ;; <CJK>
       (?$B<O(B . "0x8D66") ;; <CJK>
       (?$B<P(B . "0x659C") ;; <CJK>
       (?$B<Q(B . "0x716E") ;; <CJK>
       (?$B<R(B . "0x793E") ;; <CJK>
       (?$B<S(B . "0x7D17") ;; <CJK>
       (?$B<T(B . "0x8005") ;; <CJK>
       (?$B<U(B . "0x8B1D") ;; <CJK>
       (?$B<V(B . "0x8ECA") ;; <CJK>
       (?$B<W(B . "0x906E") ;; <CJK>
       (?$B<X(B . "0x86C7") ;; <CJK>
       (?$B<Y(B . "0x90AA") ;; <CJK>
       (?$B<Z(B . "0x501F") ;; <CJK>
       (?$B<[(B . "0x52FA") ;; <CJK>
       (?$B<\(B . "0x5C3A") ;; <CJK>
       (?$B<](B . "0x6753") ;; <CJK>
       (?$B<^(B . "0x707C") ;; <CJK>
       (?$B<_(B . "0x7235") ;; <CJK>
       (?$B<`(B . "0x914C") ;; <CJK>
       (?$B<a(B . "0x91C8") ;; <CJK>
       (?$B<b(B . "0x932B") ;; <CJK>
       (?$B<c(B . "0x82E5") ;; <CJK>
       (?$B<d(B . "0x5BC2") ;; <CJK>
       (?$B<e(B . "0x5F31") ;; <CJK>
       (?$B<f(B . "0x60F9") ;; <CJK>
       (?$B<g(B . "0x4E3B") ;; <CJK>
       (?$B<h(B . "0x53D6") ;; <CJK>
       (?$B<i(B . "0x5B88") ;; <CJK>
       (?$B<j(B . "0x624B") ;; <CJK>
       (?$B<k(B . "0x6731") ;; <CJK>
       (?$B<l(B . "0x6B8A") ;; <CJK>
       (?$B<m(B . "0x72E9") ;; <CJK>
       (?$B<n(B . "0x73E0") ;; <CJK>
       (?$B<o(B . "0x7A2E") ;; <CJK>
       (?$B<p(B . "0x816B") ;; <CJK>
       (?$B<q(B . "0x8DA3") ;; <CJK>
       (?$B<r(B . "0x9152") ;; <CJK>
       (?$B<s(B . "0x9996") ;; <CJK>
       (?$B<t(B . "0x5112") ;; <CJK>
       (?$B<u(B . "0x53D7") ;; <CJK>
       (?$B<v(B . "0x546A") ;; <CJK>
       (?$B<w(B . "0x5BFF") ;; <CJK>
       (?$B<x(B . "0x6388") ;; <CJK>
       (?$B<y(B . "0x6A39") ;; <CJK>
       (?$B<z(B . "0x7DAC") ;; <CJK>
       (?$B<{(B . "0x9700") ;; <CJK>
       (?$B<|(B . "0x56DA") ;; <CJK>
       (?$B<}(B . "0x53CE") ;; <CJK>
       (?$B<~(B . "0x5468") ;; <CJK>
       (?$B=!(B . "0x5B97") ;; <CJK>
       (?$B="(B . "0x5C31") ;; <CJK>
       (?$B=#(B . "0x5DDE") ;; <CJK>
       (?$B=$(B . "0x4FEE") ;; <CJK>
       (?$B=%(B . "0x6101") ;; <CJK>
       (?$B=&(B . "0x62FE") ;; <CJK>
       (?$B='(B . "0x6D32") ;; <CJK>
       (?$B=((B . "0x79C0") ;; <CJK>
       (?$B=)(B . "0x79CB") ;; <CJK>
       (?$B=*(B . "0x7D42") ;; <CJK>
       (?$B=+(B . "0x7E4D") ;; <CJK>
       (?$B=,(B . "0x7FD2") ;; <CJK>
       (?$B=-(B . "0x81ED") ;; <CJK>
       (?$B=.(B . "0x821F") ;; <CJK>
       (?$B=/(B . "0x8490") ;; <CJK>
       (?$B=0(B . "0x8846") ;; <CJK>
       (?$B=1(B . "0x8972") ;; <CJK>
       (?$B=2(B . "0x8B90") ;; <CJK>
       (?$B=3(B . "0x8E74") ;; <CJK>
       (?$B=4(B . "0x8F2F") ;; <CJK>
       (?$B=5(B . "0x9031") ;; <CJK>
       (?$B=6(B . "0x914B") ;; <CJK>
       (?$B=7(B . "0x916C") ;; <CJK>
       (?$B=8(B . "0x96C6") ;; <CJK>
       (?$B=9(B . "0x919C") ;; <CJK>
       (?$B=:(B . "0x4EC0") ;; <CJK>
       (?$B=;(B . "0x4F4F") ;; <CJK>
       (?$B=<(B . "0x5145") ;; <CJK>
       (?$B==(B . "0x5341") ;; <CJK>
       (?$B=>(B . "0x5F93") ;; <CJK>
       (?$B=?(B . "0x620E") ;; <CJK>
       (?$B=@(B . "0x67D4") ;; <CJK>
       (?$B=A(B . "0x6C41") ;; <CJK>
       (?$B=B(B . "0x6E0B") ;; <CJK>
       (?$B=C(B . "0x7363") ;; <CJK>
       (?$B=D(B . "0x7E26") ;; <CJK>
       (?$B=E(B . "0x91CD") ;; <CJK>
       (?$B=F(B . "0x9283") ;; <CJK>
       (?$B=G(B . "0x53D4") ;; <CJK>
       (?$B=H(B . "0x5919") ;; <CJK>
       (?$B=I(B . "0x5BBF") ;; <CJK>
       (?$B=J(B . "0x6DD1") ;; <CJK>
       (?$B=K(B . "0x795D") ;; <CJK>
       (?$B=L(B . "0x7E2E") ;; <CJK>
       (?$B=M(B . "0x7C9B") ;; <CJK>
       (?$B=N(B . "0x587E") ;; <CJK>
       (?$B=O(B . "0x719F") ;; <CJK>
       (?$B=P(B . "0x51FA") ;; <CJK>
       (?$B=Q(B . "0x8853") ;; <CJK>
       (?$B=R(B . "0x8FF0") ;; <CJK>
       (?$B=S(B . "0x4FCA") ;; <CJK>
       (?$B=T(B . "0x5CFB") ;; <CJK>
       (?$B=U(B . "0x6625") ;; <CJK>
       (?$B=V(B . "0x77AC") ;; <CJK>
       (?$B=W(B . "0x7AE3") ;; <CJK>
       (?$B=X(B . "0x821C") ;; <CJK>
       (?$B=Y(B . "0x99FF") ;; <CJK>
       (?$B=Z(B . "0x51C6") ;; <CJK>
       (?$B=[(B . "0x5FAA") ;; <CJK>
       (?$B=\(B . "0x65EC") ;; <CJK>
       (?$B=](B . "0x696F") ;; <CJK>
       (?$B=^(B . "0x6B89") ;; <CJK>
       (?$B=_(B . "0x6DF3") ;; <CJK>
       (?$B=`(B . "0x6E96") ;; <CJK>
       (?$B=a(B . "0x6F64") ;; <CJK>
       (?$B=b(B . "0x76FE") ;; <CJK>
       (?$B=c(B . "0x7D14") ;; <CJK>
       (?$B=d(B . "0x5DE1") ;; <CJK>
       (?$B=e(B . "0x9075") ;; <CJK>
       (?$B=f(B . "0x9187") ;; <CJK>
       (?$B=g(B . "0x9806") ;; <CJK>
       (?$B=h(B . "0x51E6") ;; <CJK>
       (?$B=i(B . "0x521D") ;; <CJK>
       (?$B=j(B . "0x6240") ;; <CJK>
       (?$B=k(B . "0x6691") ;; <CJK>
       (?$B=l(B . "0x66D9") ;; <CJK>
       (?$B=m(B . "0x6E1A") ;; <CJK>
       (?$B=n(B . "0x5EB6") ;; <CJK>
       (?$B=o(B . "0x7DD2") ;; <CJK>
       (?$B=p(B . "0x7F72") ;; <CJK>
       (?$B=q(B . "0x66F8") ;; <CJK>
       (?$B=r(B . "0x85AF") ;; <CJK>
       (?$B=s(B . "0x85F7") ;; <CJK>
       (?$B=t(B . "0x8AF8") ;; <CJK>
       (?$B=u(B . "0x52A9") ;; <CJK>
       (?$B=v(B . "0x53D9") ;; <CJK>
       (?$B=w(B . "0x5973") ;; <CJK>
       (?$B=x(B . "0x5E8F") ;; <CJK>
       (?$B=y(B . "0x5F90") ;; <CJK>
       (?$B=z(B . "0x6055") ;; <CJK>
       (?$B={(B . "0x92E4") ;; <CJK>
       (?$B=|(B . "0x9664") ;; <CJK>
       (?$B=}(B . "0x50B7") ;; <CJK>
       (?$B=~(B . "0x511F") ;; <CJK>
       (?$B>!(B . "0x52DD") ;; <CJK>
       (?$B>"(B . "0x5320") ;; <CJK>
       (?$B>#(B . "0x5347") ;; <CJK>
       (?$B>$(B . "0x53EC") ;; <CJK>
       (?$B>%(B . "0x54E8") ;; <CJK>
       (?$B>&(B . "0x5546") ;; <CJK>
       (?$B>'(B . "0x5531") ;; <CJK>
       (?$B>((B . "0x5617") ;; <CJK>
       (?$B>)(B . "0x5968") ;; <CJK>
       (?$B>*(B . "0x59BE") ;; <CJK>
       (?$B>+(B . "0x5A3C") ;; <CJK>
       (?$B>,(B . "0x5BB5") ;; <CJK>
       (?$B>-(B . "0x5C06") ;; <CJK>
       (?$B>.(B . "0x5C0F") ;; <CJK>
       (?$B>/(B . "0x5C11") ;; <CJK>
       (?$B>0(B . "0x5C1A") ;; <CJK>
       (?$B>1(B . "0x5E84") ;; <CJK>
       (?$B>2(B . "0x5E8A") ;; <CJK>
       (?$B>3(B . "0x5EE0") ;; <CJK>
       (?$B>4(B . "0x5F70") ;; <CJK>
       (?$B>5(B . "0x627F") ;; <CJK>
       (?$B>6(B . "0x6284") ;; <CJK>
       (?$B>7(B . "0x62DB") ;; <CJK>
       (?$B>8(B . "0x638C") ;; <CJK>
       (?$B>9(B . "0x6377") ;; <CJK>
       (?$B>:(B . "0x6607") ;; <CJK>
       (?$B>;(B . "0x660C") ;; <CJK>
       (?$B><(B . "0x662D") ;; <CJK>
       (?$B>=(B . "0x6676") ;; <CJK>
       (?$B>>(B . "0x677E") ;; <CJK>
       (?$B>?(B . "0x68A2") ;; <CJK>
       (?$B>@(B . "0x6A1F") ;; <CJK>
       (?$B>A(B . "0x6A35") ;; <CJK>
       (?$B>B(B . "0x6CBC") ;; <CJK>
       (?$B>C(B . "0x6D88") ;; <CJK>
       (?$B>D(B . "0x6E09") ;; <CJK>
       (?$B>E(B . "0x6E58") ;; <CJK>
       (?$B>F(B . "0x713C") ;; <CJK>
       (?$B>G(B . "0x7126") ;; <CJK>
       (?$B>H(B . "0x7167") ;; <CJK>
       (?$B>I(B . "0x75C7") ;; <CJK>
       (?$B>J(B . "0x7701") ;; <CJK>
       (?$B>K(B . "0x785D") ;; <CJK>
       (?$B>L(B . "0x7901") ;; <CJK>
       (?$B>M(B . "0x7965") ;; <CJK>
       (?$B>N(B . "0x79F0") ;; <CJK>
       (?$B>O(B . "0x7AE0") ;; <CJK>
       (?$B>P(B . "0x7B11") ;; <CJK>
       (?$B>Q(B . "0x7CA7") ;; <CJK>
       (?$B>R(B . "0x7D39") ;; <CJK>
       (?$B>S(B . "0x8096") ;; <CJK>
       (?$B>T(B . "0x83D6") ;; <CJK>
       (?$B>U(B . "0x848B") ;; <CJK>
       (?$B>V(B . "0x8549") ;; <CJK>
       (?$B>W(B . "0x885D") ;; <CJK>
       (?$B>X(B . "0x88F3") ;; <CJK>
       (?$B>Y(B . "0x8A1F") ;; <CJK>
       (?$B>Z(B . "0x8A3C") ;; <CJK>
       (?$B>[(B . "0x8A54") ;; <CJK>
       (?$B>\(B . "0x8A73") ;; <CJK>
       (?$B>](B . "0x8C61") ;; <CJK>
       (?$B>^(B . "0x8CDE") ;; <CJK>
       (?$B>_(B . "0x91A4") ;; <CJK>
       (?$B>`(B . "0x9266") ;; <CJK>
       (?$B>a(B . "0x937E") ;; <CJK>
       (?$B>b(B . "0x9418") ;; <CJK>
       (?$B>c(B . "0x969C") ;; <CJK>
       (?$B>d(B . "0x9798") ;; <CJK>
       (?$B>e(B . "0x4E0A") ;; <CJK>
       (?$B>f(B . "0x4E08") ;; <CJK>
       (?$B>g(B . "0x4E1E") ;; <CJK>
       (?$B>h(B . "0x4E57") ;; <CJK>
       (?$B>i(B . "0x5197") ;; <CJK>
       (?$B>j(B . "0x5270") ;; <CJK>
       (?$B>k(B . "0x57CE") ;; <CJK>
       (?$B>l(B . "0x5834") ;; <CJK>
       (?$B>m(B . "0x58CC") ;; <CJK>
       (?$B>n(B . "0x5B22") ;; <CJK>
       (?$B>o(B . "0x5E38") ;; <CJK>
       (?$B>p(B . "0x60C5") ;; <CJK>
       (?$B>q(B . "0x64FE") ;; <CJK>
       (?$B>r(B . "0x6761") ;; <CJK>
       (?$B>s(B . "0x6756") ;; <CJK>
       (?$B>t(B . "0x6D44") ;; <CJK>
       (?$B>u(B . "0x72B6") ;; <CJK>
       (?$B>v(B . "0x7573") ;; <CJK>
       (?$B>w(B . "0x7A63") ;; <CJK>
       (?$B>x(B . "0x84B8") ;; <CJK>
       (?$B>y(B . "0x8B72") ;; <CJK>
       (?$B>z(B . "0x91B8") ;; <CJK>
       (?$B>{(B . "0x9320") ;; <CJK>
       (?$B>|(B . "0x5631") ;; <CJK>
       (?$B>}(B . "0x57F4") ;; <CJK>
       (?$B>~(B . "0x98FE") ;; <CJK>
       (?$B?!(B . "0x62ED") ;; <CJK>
       (?$B?"(B . "0x690D") ;; <CJK>
       (?$B?#(B . "0x6B96") ;; <CJK>
       (?$B?$(B . "0x71ED") ;; <CJK>
       (?$B?%(B . "0x7E54") ;; <CJK>
       (?$B?&(B . "0x8077") ;; <CJK>
       (?$B?'(B . "0x8272") ;; <CJK>
       (?$B?((B . "0x89E6") ;; <CJK>
       (?$B?)(B . "0x98DF") ;; <CJK>
       (?$B?*(B . "0x8755") ;; <CJK>
       (?$B?+(B . "0x8FB1") ;; <CJK>
       (?$B?,(B . "0x5C3B") ;; <CJK>
       (?$B?-(B . "0x4F38") ;; <CJK>
       (?$B?.(B . "0x4FE1") ;; <CJK>
       (?$B?/(B . "0x4FB5") ;; <CJK>
       (?$B?0(B . "0x5507") ;; <CJK>
       (?$B?1(B . "0x5A20") ;; <CJK>
       (?$B?2(B . "0x5BDD") ;; <CJK>
       (?$B?3(B . "0x5BE9") ;; <CJK>
       (?$B?4(B . "0x5FC3") ;; <CJK>
       (?$B?5(B . "0x614E") ;; <CJK>
       (?$B?6(B . "0x632F") ;; <CJK>
       (?$B?7(B . "0x65B0") ;; <CJK>
       (?$B?8(B . "0x664B") ;; <CJK>
       (?$B?9(B . "0x68EE") ;; <CJK>
       (?$B?:(B . "0x699B") ;; <CJK>
       (?$B?;(B . "0x6D78") ;; <CJK>
       (?$B?<(B . "0x6DF1") ;; <CJK>
       (?$B?=(B . "0x7533") ;; <CJK>
       (?$B?>(B . "0x75B9") ;; <CJK>
       (?$B??(B . "0x771F") ;; <CJK>
       (?$B?@(B . "0x795E") ;; <CJK>
       (?$B?A(B . "0x79E6") ;; <CJK>
       (?$B?B(B . "0x7D33") ;; <CJK>
       (?$B?C(B . "0x81E3") ;; <CJK>
       (?$B?D(B . "0x82AF") ;; <CJK>
       (?$B?E(B . "0x85AA") ;; <CJK>
       (?$B?F(B . "0x89AA") ;; <CJK>
       (?$B?G(B . "0x8A3A") ;; <CJK>
       (?$B?H(B . "0x8EAB")  ;; <CJK>
       (?$B?I(B . "0x8F9B")  ;; <CJK>
       (?$B?J(B . "0x9032")  ;; <CJK>
       (?$B?K(B . "0x91DD")  ;; <CJK>
       (?$B?L(B . "0x9707")  ;; <CJK>
       (?$B?M(B . "0x4EBA")  ;; <CJK>
       (?$B?N(B . "0x4EC1")  ;; <CJK>
       (?$B?O(B . "0x5203")  ;; <CJK>
       (?$B?P(B . "0x5875")  ;; <CJK>
       (?$B?Q(B . "0x58EC")  ;; <CJK>
       (?$B?R(B . "0x5C0B")  ;; <CJK>
       (?$B?S(B . "0x751A")  ;; <CJK>
       (?$B?T(B . "0x5C3D")  ;; <CJK>
       (?$B?U(B . "0x814E")  ;; <CJK>
       (?$B?V(B . "0x8A0A")  ;; <CJK>
       (?$B?W(B . "0x8FC5")  ;; <CJK>
       (?$B?X(B . "0x9663")  ;; <CJK>
       (?$B?Y(B . "0x976D")  ;; <CJK>
       (?$B?Z(B . "0x7B25")  ;; <CJK>
       (?$B?[(B . "0x8ACF")  ;; <CJK>
       (?$B?\(B . "0x9808")  ;; <CJK>
       (?$B?](B . "0x9162")  ;; <CJK>
       (?$B?^(B . "0x56F3")  ;; <CJK>
       (?$B?_(B . "0x53A8")  ;; <CJK>
       (?$B?`(B . "0x9017")  ;; <CJK>
       (?$B?a(B . "0x5439")  ;; <CJK>
       (?$B?b(B . "0x5782")  ;; <CJK>
       (?$B?c(B . "0x5E25")  ;; <CJK>
       (?$B?d(B . "0x63A8")  ;; <CJK>
       (?$B?e(B . "0x6C34")  ;; <CJK>
       (?$B?f(B . "0x708A")  ;; <CJK>
       (?$B?g(B . "0x7761")  ;; <CJK>
       (?$B?h(B . "0x7C8B")  ;; <CJK>
       (?$B?i(B . "0x7FE0")  ;; <CJK>
       (?$B?j(B . "0x8870")  ;; <CJK>
       (?$B?k(B . "0x9042")  ;; <CJK>
       (?$B?l(B . "0x9154")  ;; <CJK>
       (?$B?m(B . "0x9310")  ;; <CJK>
       (?$B?n(B . "0x9318")  ;; <CJK>
       (?$B?o(B . "0x968F")  ;; <CJK>
       (?$B?p(B . "0x745E")  ;; <CJK>
       (?$B?q(B . "0x9AC4")  ;; <CJK>
       (?$B?r(B . "0x5D07")  ;; <CJK>
       (?$B?s(B . "0x5D69")  ;; <CJK>
       (?$B?t(B . "0x6570")  ;; <CJK>
       (?$B?u(B . "0x67A2")  ;; <CJK>
       (?$B?v(B . "0x8DA8")  ;; <CJK>
       (?$B?w(B . "0x96DB")  ;; <CJK>
       (?$B?x(B . "0x636E")  ;; <CJK>
       (?$B?y(B . "0x6749")  ;; <CJK>
       (?$B?z(B . "0x6919")  ;; <CJK>
       (?$B?{(B . "0x83C5")  ;; <CJK>
       (?$B?|(B . "0x9817")  ;; <CJK>
       (?$B?}(B . "0x96C0")  ;; <CJK>
       (?$B?~(B . "0x88FE")  ;; <CJK>
       (?$B@!(B . "0x6F84")  ;; <CJK>
       (?$B@"(B . "0x647A")  ;; <CJK>
       (?$B@#(B . "0x5BF8")  ;; <CJK>
       (?$B@$(B . "0x4E16")  ;; <CJK>
       (?$B@%(B . "0x702C")  ;; <CJK>
       (?$B@&(B . "0x755D")  ;; <CJK>
       (?$B@'(B . "0x662F")  ;; <CJK>
       (?$B@((B . "0x51C4")  ;; <CJK>
       (?$B@)(B . "0x5236")  ;; <CJK>
       (?$B@*(B . "0x52E2")  ;; <CJK>
       (?$B@+(B . "0x59D3")  ;; <CJK>
       (?$B@,(B . "0x5F81")  ;; <CJK>
       (?$B@-(B . "0x6027")  ;; <CJK>
       (?$B@.(B . "0x6210")  ;; <CJK>
       (?$B@/(B . "0x653F")  ;; <CJK>
       (?$B@0(B . "0x6574")  ;; <CJK>
       (?$B@1(B . "0x661F")  ;; <CJK>
       (?$B@2(B . "0x6674")  ;; <CJK>
       (?$B@3(B . "0x68F2")  ;; <CJK>
       (?$B@4(B . "0x6816")  ;; <CJK>
       (?$B@5(B . "0x6B63")  ;; <CJK>
       (?$B@6(B . "0x6E05")  ;; <CJK>
       (?$B@7(B . "0x7272")  ;; <CJK>
       (?$B@8(B . "0x751F")  ;; <CJK>
       (?$B@9(B . "0x76DB")  ;; <CJK>
       (?$B@:(B . "0x7CBE")  ;; <CJK>
       (?$B@;(B . "0x8056")  ;; <CJK>
       (?$B@<(B . "0x58F0")  ;; <CJK>
       (?$B@=(B . "0x88FD")  ;; <CJK>
       (?$B@>(B . "0x897F")  ;; <CJK>
       (?$B@?(B . "0x8AA0")  ;; <CJK>
       (?$B@@(B . "0x8A93")  ;; <CJK>
       (?$B@A(B . "0x8ACB")  ;; <CJK>
       (?$B@B(B . "0x901D")  ;; <CJK>
       (?$B@C(B . "0x9192")  ;; <CJK>
       (?$B@D(B . "0x9752")  ;; <CJK>
       (?$B@E(B . "0x9759")  ;; <CJK>
       (?$B@F(B . "0x6589")  ;; <CJK>
       (?$B@G(B . "0x7A0E")  ;; <CJK>
       (?$B@H(B . "0x8106")  ;; <CJK>
       (?$B@I(B . "0x96BB")  ;; <CJK>
       (?$B@J(B . "0x5E2D")  ;; <CJK>
       (?$B@K(B . "0x60DC")  ;; <CJK>
       (?$B@L(B . "0x621A")  ;; <CJK>
       (?$B@M(B . "0x65A5")  ;; <CJK>
       (?$B@N(B . "0x6614")  ;; <CJK>
       (?$B@O(B . "0x6790")  ;; <CJK>
       (?$B@P(B . "0x77F3")  ;; <CJK>
       (?$B@Q(B . "0x7A4D")  ;; <CJK>
       (?$B@R(B . "0x7C4D")  ;; <CJK>
       (?$B@S(B . "0x7E3E")  ;; <CJK>
       (?$B@T(B . "0x810A")  ;; <CJK>
       (?$B@U(B . "0x8CAC")  ;; <CJK>
       (?$B@V(B . "0x8D64")  ;; <CJK>
       (?$B@W(B . "0x8DE1")  ;; <CJK>
       (?$B@X(B . "0x8E5F")  ;; <CJK>
       (?$B@Y(B . "0x78A9")  ;; <CJK>
       (?$B@Z(B . "0x5207")  ;; <CJK>
       (?$B@[(B . "0x62D9")  ;; <CJK>
       (?$B@\(B . "0x63A5")  ;; <CJK>
       (?$B@](B . "0x6442")  ;; <CJK>
       (?$B@^(B . "0x6298")  ;; <CJK>
       (?$B@_(B . "0x8A2D")  ;; <CJK>
       (?$B@`(B . "0x7A83")  ;; <CJK>
       (?$B@a(B . "0x7BC0")  ;; <CJK>
       (?$B@b(B . "0x8AAC")  ;; <CJK>
       (?$B@c(B . "0x96EA")  ;; <CJK>
       (?$B@d(B . "0x7D76")  ;; <CJK>
       (?$B@e(B . "0x820C")  ;; <CJK>
       (?$B@f(B . "0x8749")  ;; <CJK>
       (?$B@g(B . "0x4ED9")  ;; <CJK>
       (?$B@h(B . "0x5148")  ;; <CJK>
       (?$B@i(B . "0x5343")  ;; <CJK>
       (?$B@j(B . "0x5360")  ;; <CJK>
       (?$B@k(B . "0x5BA3")  ;; <CJK>
       (?$B@l(B . "0x5C02")  ;; <CJK>
       (?$B@m(B . "0x5C16")  ;; <CJK>
       (?$B@n(B . "0x5DDD")  ;; <CJK>
       (?$B@o(B . "0x6226")  ;; <CJK>
       (?$B@p(B . "0x6247")  ;; <CJK>
       (?$B@q(B . "0x64B0")  ;; <CJK>
       (?$B@r(B . "0x6813")  ;; <CJK>
       (?$B@s(B . "0x6834")  ;; <CJK>
       (?$B@t(B . "0x6CC9")  ;; <CJK>
       (?$B@u(B . "0x6D45")  ;; <CJK>
       (?$B@v(B . "0x6D17")  ;; <CJK>
       (?$B@w(B . "0x67D3")  ;; <CJK>
       (?$B@x(B . "0x6F5C")  ;; <CJK>
       (?$B@y(B . "0x714E")  ;; <CJK>
       (?$B@z(B . "0x717D")  ;; <CJK>
       (?$B@{(B . "0x65CB")  ;; <CJK>
       (?$B@|(B . "0x7A7F")  ;; <CJK>
       (?$B@}(B . "0x7BAD")  ;; <CJK>
       (?$B@~(B . "0x7DDA")  ;; <CJK>
       (?$BA!(B . "0x7E4A")  ;; <CJK>
       (?$BA"(B . "0x7FA8")  ;; <CJK>
       (?$BA#(B . "0x817A")  ;; <CJK>
       (?$BA$(B . "0x821B")  ;; <CJK>
       (?$BA%(B . "0x8239")  ;; <CJK>
       (?$BA&(B . "0x85A6")  ;; <CJK>
       (?$BA'(B . "0x8A6E")  ;; <CJK>
       (?$BA((B . "0x8CCE")  ;; <CJK>
       (?$BA)(B . "0x8DF5")  ;; <CJK>
       (?$BA*(B . "0x9078")  ;; <CJK>
       (?$BA+(B . "0x9077")  ;; <CJK>
       (?$BA,(B . "0x92AD")  ;; <CJK>
       (?$BA-(B . "0x9291")  ;; <CJK>
       (?$BA.(B . "0x9583")  ;; <CJK>
       (?$BA/(B . "0x9BAE")  ;; <CJK>
       (?$BA0(B . "0x524D")  ;; <CJK>
       (?$BA1(B . "0x5584")  ;; <CJK>
       (?$BA2(B . "0x6F38")  ;; <CJK>
       (?$BA3(B . "0x7136")  ;; <CJK>
       (?$BA4(B . "0x5168")  ;; <CJK>
       (?$BA5(B . "0x7985")  ;; <CJK>
       (?$BA6(B . "0x7E55")  ;; <CJK>
       (?$BA7(B . "0x81B3")  ;; <CJK>
       (?$BA8(B . "0x7CCE")  ;; <CJK>
       (?$BA9(B . "0x564C")  ;; <CJK>
       (?$BA:(B . "0x5851")  ;; <CJK>
       (?$BA;(B . "0x5CA8")  ;; <CJK>
       (?$BA<(B . "0x63AA")  ;; <CJK>
       (?$BA=(B . "0x66FE")  ;; <CJK>
       (?$BA>(B . "0x66FD")  ;; <CJK>
       (?$BA?(B . "0x695A")  ;; <CJK>
       (?$BA@(B . "0x72D9")  ;; <CJK>
       (?$BAA(B . "0x758F")  ;; <CJK>
       (?$BAB(B . "0x758E")  ;; <CJK>
       (?$BAC(B . "0x790E")  ;; <CJK>
       (?$BAD(B . "0x7956")  ;; <CJK>
       (?$BAE(B . "0x79DF")  ;; <CJK>
       (?$BAF(B . "0x7C97")  ;; <CJK>
       (?$BAG(B . "0x7D20")  ;; <CJK>
       (?$BAH(B . "0x7D44")  ;; <CJK>
       (?$BAI(B . "0x8607")  ;; <CJK>
       (?$BAJ(B . "0x8A34")  ;; <CJK>
       (?$BAK(B . "0x963B")  ;; <CJK>
       (?$BAL(B . "0x9061")  ;; <CJK>
       (?$BAM(B . "0x9F20")  ;; <CJK>
       (?$BAN(B . "0x50E7")  ;; <CJK>
       (?$BAO(B . "0x5275")  ;; <CJK>
       (?$BAP(B . "0x53CC")  ;; <CJK>
       (?$BAQ(B . "0x53E2")  ;; <CJK>
       (?$BAR(B . "0x5009")  ;; <CJK>
       (?$BAS(B . "0x55AA")  ;; <CJK>
       (?$BAT(B . "0x58EE")  ;; <CJK>
       (?$BAU(B . "0x594F")  ;; <CJK>
       (?$BAV(B . "0x723D")  ;; <CJK>
       (?$BAW(B . "0x5B8B")  ;; <CJK>
       (?$BAX(B . "0x5C64")  ;; <CJK>
       (?$BAY(B . "0x531D")  ;; <CJK>
       (?$BAZ(B . "0x60E3")  ;; <CJK>
       (?$BA[(B . "0x60F3")  ;; <CJK>
       (?$BA\(B . "0x635C")  ;; <CJK>
       (?$BA](B . "0x6383")  ;; <CJK>
       (?$BA^(B . "0x633F")  ;; <CJK>
       (?$BA_(B . "0x63BB")  ;; <CJK>
       (?$BA`(B . "0x64CD")  ;; <CJK>
       (?$BAa(B . "0x65E9")  ;; <CJK>
       (?$BAb(B . "0x66F9")  ;; <CJK>
       (?$BAc(B . "0x5DE3")  ;; <CJK>
       (?$BAd(B . "0x69CD")  ;; <CJK>
       (?$BAe(B . "0x69FD")  ;; <CJK>
       (?$BAf(B . "0x6F15")  ;; <CJK>
       (?$BAg(B . "0x71E5")  ;; <CJK>
       (?$BAh(B . "0x4E89")  ;; <CJK>
       (?$BAi(B . "0x75E9")  ;; <CJK>
       (?$BAj(B . "0x76F8")  ;; <CJK>
       (?$BAk(B . "0x7A93")  ;; <CJK>
       (?$BAl(B . "0x7CDF")  ;; <CJK>
       (?$BAm(B . "0x7DCF")  ;; <CJK>
       (?$BAn(B . "0x7D9C")  ;; <CJK>
       (?$BAo(B . "0x8061")  ;; <CJK>
       (?$BAp(B . "0x8349")  ;; <CJK>
       (?$BAq(B . "0x8358")  ;; <CJK>
       (?$BAr(B . "0x846C")  ;; <CJK>
       (?$BAs(B . "0x84BC")  ;; <CJK>
       (?$BAt(B . "0x85FB")  ;; <CJK>
       (?$BAu(B . "0x88C5")  ;; <CJK>
       (?$BAv(B . "0x8D70")  ;; <CJK>
       (?$BAw(B . "0x9001")  ;; <CJK>
       (?$BAx(B . "0x906D")  ;; <CJK>
       (?$BAy(B . "0x9397")  ;; <CJK>
       (?$BAz(B . "0x971C")  ;; <CJK>
       (?$BA{(B . "0x9A12")  ;; <CJK>
       (?$BA|(B . "0x50CF")  ;; <CJK>
       (?$BA}(B . "0x5897")  ;; <CJK>
       (?$BA~(B . "0x618E")  ;; <CJK>
       (?$BB!(B . "0x81D3")  ;; <CJK>
       (?$BB"(B . "0x8535")  ;; <CJK>
       (?$BB#(B . "0x8D08")  ;; <CJK>
       (?$BB$(B . "0x9020")  ;; <CJK>
       (?$BB%(B . "0x4FC3")  ;; <CJK>
       (?$BB&(B . "0x5074")  ;; <CJK>
       (?$BB'(B . "0x5247")  ;; <CJK>
       (?$BB((B . "0x5373")  ;; <CJK>
       (?$BB)(B . "0x606F")  ;; <CJK>
       (?$BB*(B . "0x6349")  ;; <CJK>
       (?$BB+(B . "0x675F")  ;; <CJK>
       (?$BB,(B . "0x6E2C")  ;; <CJK>
       (?$BB-(B . "0x8DB3")  ;; <CJK>
       (?$BB.(B . "0x901F")  ;; <CJK>
       (?$BB/(B . "0x4FD7")  ;; <CJK>
       (?$BB0(B . "0x5C5E")  ;; <CJK>
       (?$BB1(B . "0x8CCA")  ;; <CJK>
       (?$BB2(B . "0x65CF")  ;; <CJK>
       (?$BB3(B . "0x7D9A")  ;; <CJK>
       (?$BB4(B . "0x5352")  ;; <CJK>
       (?$BB5(B . "0x8896")  ;; <CJK>
       (?$BB6(B . "0x5176")  ;; <CJK>
       (?$BB7(B . "0x63C3")  ;; <CJK>
       (?$BB8(B . "0x5B58")  ;; <CJK>
       (?$BB9(B . "0x5B6B")  ;; <CJK>
       (?$BB:(B . "0x5C0A")  ;; <CJK>
       (?$BB;(B . "0x640D")  ;; <CJK>
       (?$BB<(B . "0x6751")  ;; <CJK>
       (?$BB=(B . "0x905C")  ;; <CJK>
       (?$BB>(B . "0x4ED6")  ;; <CJK>
       (?$BB?(B . "0x591A")  ;; <CJK>
       (?$BB@(B . "0x592A")  ;; <CJK>
       (?$BBA(B . "0x6C70")  ;; <CJK>
       (?$BBB(B . "0x8A51")  ;; <CJK>
       (?$BBC(B . "0x553E")  ;; <CJK>
       (?$BBD(B . "0x5815")  ;; <CJK>
       (?$BBE(B . "0x59A5")  ;; <CJK>
       (?$BBF(B . "0x60F0")  ;; <CJK>
       (?$BBG(B . "0x6253")  ;; <CJK>
       (?$BBH(B . "0x67C1")  ;; <CJK>
       (?$BBI(B . "0x8235")  ;; <CJK>
       (?$BBJ(B . "0x6955")  ;; <CJK>
       (?$BBK(B . "0x9640")  ;; <CJK>
       (?$BBL(B . "0x99C4")  ;; <CJK>
       (?$BBM(B . "0x9A28")  ;; <CJK>
       (?$BBN(B . "0x4F53")  ;; <CJK>
       (?$BBO(B . "0x5806")  ;; <CJK>
       (?$BBP(B . "0x5BFE")  ;; <CJK>
       (?$BBQ(B . "0x8010")  ;; <CJK>
       (?$BBR(B . "0x5CB1")  ;; <CJK>
       (?$BBS(B . "0x5E2F")  ;; <CJK>
       (?$BBT(B . "0x5F85")  ;; <CJK>
       (?$BBU(B . "0x6020")  ;; <CJK>
       (?$BBV(B . "0x614B")  ;; <CJK>
       (?$BBW(B . "0x6234")  ;; <CJK>
       (?$BBX(B . "0x66FF")  ;; <CJK>
       (?$BBY(B . "0x6CF0")  ;; <CJK>
       (?$BBZ(B . "0x6EDE")  ;; <CJK>
       (?$BB[(B . "0x80CE")  ;; <CJK>
       (?$BB\(B . "0x817F")  ;; <CJK>
       (?$BB](B . "0x82D4")  ;; <CJK>
       (?$BB^(B . "0x888B")  ;; <CJK>
       (?$BB_(B . "0x8CB8")  ;; <CJK>
       (?$BB`(B . "0x9000")  ;; <CJK>
       (?$BBa(B . "0x902E")  ;; <CJK>
       (?$BBb(B . "0x968A")  ;; <CJK>
       (?$BBc(B . "0x9EDB")  ;; <CJK>
       (?$BBd(B . "0x9BDB")  ;; <CJK>
       (?$BBe(B . "0x4EE3")  ;; <CJK>
       (?$BBf(B . "0x53F0")  ;; <CJK>
       (?$BBg(B . "0x5927")  ;; <CJK>
       (?$BBh(B . "0x7B2C")  ;; <CJK>
       (?$BBi(B . "0x918D")  ;; <CJK>
       (?$BBj(B . "0x984C")  ;; <CJK>
       (?$BBk(B . "0x9DF9")  ;; <CJK>
       (?$BBl(B . "0x6EDD")  ;; <CJK>
       (?$BBm(B . "0x7027")  ;; <CJK>
       (?$BBn(B . "0x5353")  ;; <CJK>
       (?$BBo(B . "0x5544")  ;; <CJK>
       (?$BBp(B . "0x5B85")  ;; <CJK>
       (?$BBq(B . "0x6258")  ;; <CJK>
       (?$BBr(B . "0x629E")  ;; <CJK>
       (?$BBs(B . "0x62D3")  ;; <CJK>
       (?$BBt(B . "0x6CA2")  ;; <CJK>
       (?$BBu(B . "0x6FEF")  ;; <CJK>
       (?$BBv(B . "0x7422")  ;; <CJK>
       (?$BBw(B . "0x8A17")  ;; <CJK>
       (?$BBx(B . "0x9438")  ;; <CJK>
       (?$BBy(B . "0x6FC1")  ;; <CJK>
       (?$BBz(B . "0x8AFE")  ;; <CJK>
       (?$BB{(B . "0x8338")  ;; <CJK>
       (?$BB|(B . "0x51E7")  ;; <CJK>
       (?$BB}(B . "0x86F8")  ;; <CJK>
       (?$BB~(B . "0x53EA")  ;; <CJK>
       (?$BC!(B . "0x53E9")  ;; <CJK>
       (?$BC"(B . "0x4F46")  ;; <CJK>
       (?$BC#(B . "0x9054")  ;; <CJK>
       (?$BC$(B . "0x8FB0")  ;; <CJK>
       (?$BC%(B . "0x596A")  ;; <CJK>
       (?$BC&(B . "0x8131")  ;; <CJK>
       (?$BC'(B . "0x5DFD")  ;; <CJK>
       (?$BC((B . "0x7AEA")  ;; <CJK>
       (?$BC)(B . "0x8FBF")  ;; <CJK>
       (?$BC*(B . "0x68DA")  ;; <CJK>
       (?$BC+(B . "0x8C37")  ;; <CJK>
       (?$BC,(B . "0x72F8")  ;; <CJK>
       (?$BC-(B . "0x9C48")  ;; <CJK>
       (?$BC.(B . "0x6A3D")  ;; <CJK>
       (?$BC/(B . "0x8AB0")  ;; <CJK>
       (?$BC0(B . "0x4E39")  ;; <CJK>
       (?$BC1(B . "0x5358")  ;; <CJK>
       (?$BC2(B . "0x5606")  ;; <CJK>
       (?$BC3(B . "0x5766")  ;; <CJK>
       (?$BC4(B . "0x62C5")  ;; <CJK>
       (?$BC5(B . "0x63A2")  ;; <CJK>
       (?$BC6(B . "0x65E6")  ;; <CJK>
       (?$BC7(B . "0x6B4E")  ;; <CJK>
       (?$BC8(B . "0x6DE1")  ;; <CJK>
       (?$BC9(B . "0x6E5B")  ;; <CJK>
       (?$BC:(B . "0x70AD")  ;; <CJK>
       (?$BC;(B . "0x77ED")  ;; <CJK>
       (?$BC<(B . "0x7AEF")  ;; <CJK>
       (?$BC=(B . "0x7BAA")  ;; <CJK>
       (?$BC>(B . "0x7DBB")  ;; <CJK>
       (?$BC?(B . "0x803D")  ;; <CJK>
       (?$BC@(B . "0x80C6")  ;; <CJK>
       (?$BCA(B . "0x86CB")  ;; <CJK>
       (?$BCB(B . "0x8A95")  ;; <CJK>
       (?$BCC(B . "0x935B")  ;; <CJK>
       (?$BCD(B . "0x56E3")  ;; <CJK>
       (?$BCE(B . "0x58C7")  ;; <CJK>
       (?$BCF(B . "0x5F3E")  ;; <CJK>
       (?$BCG(B . "0x65AD")  ;; <CJK>
       (?$BCH(B . "0x6696")  ;; <CJK>
       (?$BCI(B . "0x6A80")  ;; <CJK>
       (?$BCJ(B . "0x6BB5")  ;; <CJK>
       (?$BCK(B . "0x7537")  ;; <CJK>
       (?$BCL(B . "0x8AC7")  ;; <CJK>
       (?$BCM(B . "0x5024")  ;; <CJK>
       (?$BCN(B . "0x77E5")  ;; <CJK>
       (?$BCO(B . "0x5730")  ;; <CJK>
       (?$BCP(B . "0x5F1B")  ;; <CJK>
       (?$BCQ(B . "0x6065")  ;; <CJK>
       (?$BCR(B . "0x667A")  ;; <CJK>
       (?$BCS(B . "0x6C60")  ;; <CJK>
       (?$BCT(B . "0x75F4")  ;; <CJK>
       (?$BCU(B . "0x7A1A")  ;; <CJK>
       (?$BCV(B . "0x7F6E")  ;; <CJK>
       (?$BCW(B . "0x81F4")  ;; <CJK>
       (?$BCX(B . "0x8718")  ;; <CJK>
       (?$BCY(B . "0x9045")  ;; <CJK>
       (?$BCZ(B . "0x99B3")  ;; <CJK>
       (?$BC[(B . "0x7BC9")  ;; <CJK>
       (?$BC\(B . "0x755C")  ;; <CJK>
       (?$BC](B . "0x7AF9")  ;; <CJK>
       (?$BC^(B . "0x7B51")  ;; <CJK>
       (?$BC_(B . "0x84C4")  ;; <CJK>
       (?$BC`(B . "0x9010")  ;; <CJK>
       (?$BCa(B . "0x79E9")  ;; <CJK>
       (?$BCb(B . "0x7A92")  ;; <CJK>
       (?$BCc(B . "0x8336")  ;; <CJK>
       (?$BCd(B . "0x5AE1")  ;; <CJK>
       (?$BCe(B . "0x7740")  ;; <CJK>
       (?$BCf(B . "0x4E2D")  ;; <CJK>
       (?$BCg(B . "0x4EF2")  ;; <CJK>
       (?$BCh(B . "0x5B99")  ;; <CJK>
       (?$BCi(B . "0x5FE0")  ;; <CJK>
       (?$BCj(B . "0x62BD")  ;; <CJK>
       (?$BCk(B . "0x663C")  ;; <CJK>
       (?$BCl(B . "0x67F1")  ;; <CJK>
       (?$BCm(B . "0x6CE8")  ;; <CJK>
       (?$BCn(B . "0x866B")  ;; <CJK>
       (?$BCo(B . "0x8877")  ;; <CJK>
       (?$BCp(B . "0x8A3B")  ;; <CJK>
       (?$BCq(B . "0x914E")  ;; <CJK>
       (?$BCr(B . "0x92F3")  ;; <CJK>
       (?$BCs(B . "0x99D0")  ;; <CJK>
       (?$BCt(B . "0x6A17")  ;; <CJK>
       (?$BCu(B . "0x7026")  ;; <CJK>
       (?$BCv(B . "0x732A")  ;; <CJK>
       (?$BCw(B . "0x82E7")  ;; <CJK>
       (?$BCx(B . "0x8457")  ;; <CJK>
       (?$BCy(B . "0x8CAF")  ;; <CJK>
       (?$BCz(B . "0x4E01")  ;; <CJK>
       (?$BC{(B . "0x5146")  ;; <CJK>
       (?$BC|(B . "0x51CB")  ;; <CJK>
       (?$BC}(B . "0x558B")  ;; <CJK>
       (?$BC~(B . "0x5BF5")  ;; <CJK>
       (?$BD!(B . "0x5E16")  ;; <CJK>
       (?$BD"(B . "0x5E33")  ;; <CJK>
       (?$BD#(B . "0x5E81")  ;; <CJK>
       (?$BD$(B . "0x5F14")  ;; <CJK>
       (?$BD%(B . "0x5F35")  ;; <CJK>
       (?$BD&(B . "0x5F6B")  ;; <CJK>
       (?$BD'(B . "0x5FB4")  ;; <CJK>
       (?$BD((B . "0x61F2")  ;; <CJK>
       (?$BD)(B . "0x6311")  ;; <CJK>
       (?$BD*(B . "0x66A2")  ;; <CJK>
       (?$BD+(B . "0x671D")  ;; <CJK>
       (?$BD,(B . "0x6F6E")  ;; <CJK>
       (?$BD-(B . "0x7252")  ;; <CJK>
       (?$BD.(B . "0x753A")  ;; <CJK>
       (?$BD/(B . "0x773A")  ;; <CJK>
       (?$BD0(B . "0x8074")  ;; <CJK>
       (?$BD1(B . "0x8139")  ;; <CJK>
       (?$BD2(B . "0x8178")  ;; <CJK>
       (?$BD3(B . "0x8776")  ;; <CJK>
       (?$BD4(B . "0x8ABF")  ;; <CJK>
       (?$BD5(B . "0x8ADC")  ;; <CJK>
       (?$BD6(B . "0x8D85")  ;; <CJK>
       (?$BD7(B . "0x8DF3")  ;; <CJK>
       (?$BD8(B . "0x929A")  ;; <CJK>
       (?$BD9(B . "0x9577")  ;; <CJK>
       (?$BD:(B . "0x9802")  ;; <CJK>
       (?$BD;(B . "0x9CE5")  ;; <CJK>
       (?$BD<(B . "0x52C5")  ;; <CJK>
       (?$BD=(B . "0x6357")  ;; <CJK>
       (?$BD>(B . "0x76F4")  ;; <CJK>
       (?$BD?(B . "0x6715")  ;; <CJK>
       (?$BD@(B . "0x6C88")  ;; <CJK>
       (?$BDA(B . "0x73CD")  ;; <CJK>
       (?$BDB(B . "0x8CC3")  ;; <CJK>
       (?$BDC(B . "0x93AE")  ;; <CJK>
       (?$BDD(B . "0x9673")  ;; <CJK>
       (?$BDE(B . "0x6D25")  ;; <CJK>
       (?$BDF(B . "0x589C")  ;; <CJK>
       (?$BDG(B . "0x690E")  ;; <CJK>
       (?$BDH(B . "0x69CC")  ;; <CJK>
       (?$BDI(B . "0x8FFD")  ;; <CJK>
       (?$BDJ(B . "0x939A")  ;; <CJK>
       (?$BDK(B . "0x75DB")  ;; <CJK>
       (?$BDL(B . "0x901A")  ;; <CJK>
       (?$BDM(B . "0x585A")  ;; <CJK>
       (?$BDN(B . "0x6802")  ;; <CJK>
       (?$BDO(B . "0x63B4")  ;; <CJK>
       (?$BDP(B . "0x69FB")  ;; <CJK>
       (?$BDQ(B . "0x4F43")  ;; <CJK>
       (?$BDR(B . "0x6F2C")  ;; <CJK>
       (?$BDS(B . "0x67D8")  ;; <CJK>
       (?$BDT(B . "0x8FBB")  ;; <CJK>
       (?$BDU(B . "0x8526")  ;; <CJK>
       (?$BDV(B . "0x7DB4")  ;; <CJK>
       (?$BDW(B . "0x9354")  ;; <CJK>
       (?$BDX(B . "0x693F")  ;; <CJK>
       (?$BDY(B . "0x6F70")  ;; <CJK>
       (?$BDZ(B . "0x576A")  ;; <CJK>
       (?$BD[(B . "0x58F7")  ;; <CJK>
       (?$BD\(B . "0x5B2C")  ;; <CJK>
       (?$BD](B . "0x7D2C")  ;; <CJK>
       (?$BD^(B . "0x722A")  ;; <CJK>
       (?$BD_(B . "0x540A")  ;; <CJK>
       (?$BD`(B . "0x91E3")  ;; <CJK>
       (?$BDa(B . "0x9DB4")  ;; <CJK>
       (?$BDb(B . "0x4EAD")  ;; <CJK>
       (?$BDc(B . "0x4F4E")  ;; <CJK>
       (?$BDd(B . "0x505C")  ;; <CJK>
       (?$BDe(B . "0x5075")  ;; <CJK>
       (?$BDf(B . "0x5243")  ;; <CJK>
       (?$BDg(B . "0x8C9E")  ;; <CJK>
       (?$BDh(B . "0x5448")  ;; <CJK>
       (?$BDi(B . "0x5824")  ;; <CJK>
       (?$BDj(B . "0x5B9A")  ;; <CJK>
       (?$BDk(B . "0x5E1D")  ;; <CJK>
       (?$BDl(B . "0x5E95")  ;; <CJK>
       (?$BDm(B . "0x5EAD")  ;; <CJK>
       (?$BDn(B . "0x5EF7")  ;; <CJK>
       (?$BDo(B . "0x5F1F")  ;; <CJK>
       (?$BDp(B . "0x608C")  ;; <CJK>
       (?$BDq(B . "0x62B5")  ;; <CJK>
       (?$BDr(B . "0x633A")  ;; <CJK>
       (?$BDs(B . "0x63D0")  ;; <CJK>
       (?$BDt(B . "0x68AF")  ;; <CJK>
       (?$BDu(B . "0x6C40")  ;; <CJK>
       (?$BDv(B . "0x7887")  ;; <CJK>
       (?$BDw(B . "0x798E")  ;; <CJK>
       (?$BDx(B . "0x7A0B")  ;; <CJK>
       (?$BDy(B . "0x7DE0")  ;; <CJK>
       (?$BDz(B . "0x8247")  ;; <CJK>
       (?$BD{(B . "0x8A02")  ;; <CJK>
       (?$BD|(B . "0x8AE6")  ;; <CJK>
       (?$BD}(B . "0x8E44")  ;; <CJK>
       (?$BD~(B . "0x9013")  ;; <CJK>
       (?$BE!(B . "0x90B8")  ;; <CJK>
       (?$BE"(B . "0x912D")  ;; <CJK>
       (?$BE#(B . "0x91D8")  ;; <CJK>
       (?$BE$(B . "0x9F0E")  ;; <CJK>
       (?$BE%(B . "0x6CE5")  ;; <CJK>
       (?$BE&(B . "0x6458")  ;; <CJK>
       (?$BE'(B . "0x64E2")  ;; <CJK>
       (?$BE((B . "0x6575")  ;; <CJK>
       (?$BE)(B . "0x6EF4")  ;; <CJK>
       (?$BE*(B . "0x7684")  ;; <CJK>
       (?$BE+(B . "0x7B1B")  ;; <CJK>
       (?$BE,(B . "0x9069")  ;; <CJK>
       (?$BE-(B . "0x93D1")  ;; <CJK>
       (?$BE.(B . "0x6EBA")  ;; <CJK>
       (?$BE/(B . "0x54F2")  ;; <CJK>
       (?$BE0(B . "0x5FB9")  ;; <CJK>
       (?$BE1(B . "0x64A4")  ;; <CJK>
       (?$BE2(B . "0x8F4D")  ;; <CJK>
       (?$BE3(B . "0x8FED")  ;; <CJK>
       (?$BE4(B . "0x9244")  ;; <CJK>
       (?$BE5(B . "0x5178")  ;; <CJK>
       (?$BE6(B . "0x586B")  ;; <CJK>
       (?$BE7(B . "0x5929")  ;; <CJK>
       (?$BE8(B . "0x5C55")  ;; <CJK>
       (?$BE9(B . "0x5E97")  ;; <CJK>
       (?$BE:(B . "0x6DFB")  ;; <CJK>
       (?$BE;(B . "0x7E8F")  ;; <CJK>
       (?$BE<(B . "0x751C")  ;; <CJK>
       (?$BE=(B . "0x8CBC")  ;; <CJK>
       (?$BE>(B . "0x8EE2")  ;; <CJK>
       (?$BE?(B . "0x985B")  ;; <CJK>
       (?$BE@(B . "0x70B9")  ;; <CJK>
       (?$BEA(B . "0x4F1D")  ;; <CJK>
       (?$BEB(B . "0x6BBF")  ;; <CJK>
       (?$BEC(B . "0x6FB1")  ;; <CJK>
       (?$BED(B . "0x7530")  ;; <CJK>
       (?$BEE(B . "0x96FB")  ;; <CJK>
       (?$BEF(B . "0x514E")  ;; <CJK>
       (?$BEG(B . "0x5410")  ;; <CJK>
       (?$BEH(B . "0x5835")  ;; <CJK>
       (?$BEI(B . "0x5857")  ;; <CJK>
       (?$BEJ(B . "0x59AC")  ;; <CJK>
       (?$BEK(B . "0x5C60")  ;; <CJK>
       (?$BEL(B . "0x5F92")  ;; <CJK>
       (?$BEM(B . "0x6597")  ;; <CJK>
       (?$BEN(B . "0x675C")  ;; <CJK>
       (?$BEO(B . "0x6E21")  ;; <CJK>
       (?$BEP(B . "0x767B")  ;; <CJK>
       (?$BEQ(B . "0x83DF")  ;; <CJK>
       (?$BER(B . "0x8CED")  ;; <CJK>
       (?$BES(B . "0x9014")  ;; <CJK>
       (?$BET(B . "0x90FD")  ;; <CJK>
       (?$BEU(B . "0x934D")  ;; <CJK>
       (?$BEV(B . "0x7825")  ;; <CJK>
       (?$BEW(B . "0x783A")  ;; <CJK>
       (?$BEX(B . "0x52AA")  ;; <CJK>
       (?$BEY(B . "0x5EA6")  ;; <CJK>
       (?$BEZ(B . "0x571F")  ;; <CJK>
       (?$BE[(B . "0x5974")  ;; <CJK>
       (?$BE\(B . "0x6012")  ;; <CJK>
       (?$BE](B . "0x5012")  ;; <CJK>
       (?$BE^(B . "0x515A")  ;; <CJK>
       (?$BE_(B . "0x51AC")  ;; <CJK>
       (?$BE`(B . "0x51CD")  ;; <CJK>
       (?$BEa(B . "0x5200")  ;; <CJK>
       (?$BEb(B . "0x5510")  ;; <CJK>
       (?$BEc(B . "0x5854")  ;; <CJK>
       (?$BEd(B . "0x5858")  ;; <CJK>
       (?$BEe(B . "0x5957")  ;; <CJK>
       (?$BEf(B . "0x5B95")  ;; <CJK>
       (?$BEg(B . "0x5CF6")  ;; <CJK>
       (?$BEh(B . "0x5D8B")  ;; <CJK>
       (?$BEi(B . "0x60BC")  ;; <CJK>
       (?$BEj(B . "0x6295")  ;; <CJK>
       (?$BEk(B . "0x642D")  ;; <CJK>
       (?$BEl(B . "0x6771")  ;; <CJK>
       (?$BEm(B . "0x6843")  ;; <CJK>
       (?$BEn(B . "0x68BC")  ;; <CJK>
       (?$BEo(B . "0x68DF")  ;; <CJK>
       (?$BEp(B . "0x76D7")  ;; <CJK>
       (?$BEq(B . "0x6DD8")  ;; <CJK>
       (?$BEr(B . "0x6E6F")  ;; <CJK>
       (?$BEs(B . "0x6D9B")  ;; <CJK>
       (?$BEt(B . "0x706F")  ;; <CJK>
       (?$BEu(B . "0x71C8")  ;; <CJK>
       (?$BEv(B . "0x5F53")  ;; <CJK>
       (?$BEw(B . "0x75D8")  ;; <CJK>
       (?$BEx(B . "0x7977")  ;; <CJK>
       (?$BEy(B . "0x7B49")  ;; <CJK>
       (?$BEz(B . "0x7B54")  ;; <CJK>
       (?$BE{(B . "0x7B52")  ;; <CJK>
       (?$BE|(B . "0x7CD6")  ;; <CJK>
       (?$BE}(B . "0x7D71")  ;; <CJK>
       (?$BE~(B . "0x5230")  ;; <CJK>
       (?$BF!(B . "0x8463")  ;; <CJK>
       (?$BF"(B . "0x8569")  ;; <CJK>
       (?$BF#(B . "0x85E4")  ;; <CJK>
       (?$BF$(B . "0x8A0E")  ;; <CJK>
       (?$BF%(B . "0x8B04")  ;; <CJK>
       (?$BF&(B . "0x8C46")  ;; <CJK>
       (?$BF'(B . "0x8E0F")  ;; <CJK>
       (?$BF((B . "0x9003")  ;; <CJK>
       (?$BF)(B . "0x900F")  ;; <CJK>
       (?$BF*(B . "0x9419")  ;; <CJK>
       (?$BF+(B . "0x9676")  ;; <CJK>
       (?$BF,(B . "0x982D")  ;; <CJK>
       (?$BF-(B . "0x9A30")  ;; <CJK>
       (?$BF.(B . "0x95D8")  ;; <CJK>
       (?$BF/(B . "0x50CD")  ;; <CJK>
       (?$BF0(B . "0x52D5")  ;; <CJK>
       (?$BF1(B . "0x540C")  ;; <CJK>
       (?$BF2(B . "0x5802")  ;; <CJK>
       (?$BF3(B . "0x5C0E")  ;; <CJK>
       (?$BF4(B . "0x61A7")  ;; <CJK>
       (?$BF5(B . "0x649E")  ;; <CJK>
       (?$BF6(B . "0x6D1E")  ;; <CJK>
       (?$BF7(B . "0x77B3")  ;; <CJK>
       (?$BF8(B . "0x7AE5")  ;; <CJK>
       (?$BF9(B . "0x80F4")  ;; <CJK>
       (?$BF:(B . "0x8404")  ;; <CJK>
       (?$BF;(B . "0x9053")  ;; <CJK>
       (?$BF<(B . "0x9285")  ;; <CJK>
       (?$BF=(B . "0x5CE0")  ;; <CJK>
       (?$BF>(B . "0x9D07")  ;; <CJK>
       (?$BF?(B . "0x533F")  ;; <CJK>
       (?$BF@(B . "0x5F97")  ;; <CJK>
       (?$BFA(B . "0x5FB3")  ;; <CJK>
       (?$BFB(B . "0x6D9C")  ;; <CJK>
       (?$BFC(B . "0x7279")  ;; <CJK>
       (?$BFD(B . "0x7763")  ;; <CJK>
       (?$BFE(B . "0x79BF")  ;; <CJK>
       (?$BFF(B . "0x7BE4")  ;; <CJK>
       (?$BFG(B . "0x6BD2")  ;; <CJK>
       (?$BFH(B . "0x72EC")  ;; <CJK>
       (?$BFI(B . "0x8AAD")  ;; <CJK>
       (?$BFJ(B . "0x6803")  ;; <CJK>
       (?$BFK(B . "0x6A61")  ;; <CJK>
       (?$BFL(B . "0x51F8")  ;; <CJK>
       (?$BFM(B . "0x7A81")  ;; <CJK>
       (?$BFN(B . "0x6934")  ;; <CJK>
       (?$BFO(B . "0x5C4A")  ;; <CJK>
       (?$BFP(B . "0x9CF6")  ;; <CJK>
       (?$BFQ(B . "0x82EB")  ;; <CJK>
       (?$BFR(B . "0x5BC5")  ;; <CJK>
       (?$BFS(B . "0x9149")  ;; <CJK>
       (?$BFT(B . "0x701E")  ;; <CJK>
       (?$BFU(B . "0x5678")  ;; <CJK>
       (?$BFV(B . "0x5C6F")  ;; <CJK>
       (?$BFW(B . "0x60C7")  ;; <CJK>
       (?$BFX(B . "0x6566")  ;; <CJK>
       (?$BFY(B . "0x6C8C")  ;; <CJK>
       (?$BFZ(B . "0x8C5A")  ;; <CJK>
       (?$BF[(B . "0x9041")  ;; <CJK>
       (?$BF\(B . "0x9813")  ;; <CJK>
       (?$BF](B . "0x5451")  ;; <CJK>
       (?$BF^(B . "0x66C7")  ;; <CJK>
       (?$BF_(B . "0x920D")  ;; <CJK>
       (?$BF`(B . "0x5948")  ;; <CJK>
       (?$BFa(B . "0x90A3")  ;; <CJK>
       (?$BFb(B . "0x5185")  ;; <CJK>
       (?$BFc(B . "0x4E4D")  ;; <CJK>
       (?$BFd(B . "0x51EA")  ;; <CJK>
       (?$BFe(B . "0x8599")  ;; <CJK>
       (?$BFf(B . "0x8B0E")  ;; <CJK>
       (?$BFg(B . "0x7058")  ;; <CJK>
       (?$BFh(B . "0x637A")  ;; <CJK>
       (?$BFi(B . "0x934B")  ;; <CJK>
       (?$BFj(B . "0x6962")  ;; <CJK>
       (?$BFk(B . "0x99B4")  ;; <CJK>
       (?$BFl(B . "0x7E04")  ;; <CJK>
       (?$BFm(B . "0x7577")  ;; <CJK>
       (?$BFn(B . "0x5357")  ;; <CJK>
       (?$BFo(B . "0x6960")  ;; <CJK>
       (?$BFp(B . "0x8EDF")  ;; <CJK>
       (?$BFq(B . "0x96E3")  ;; <CJK>
       (?$BFr(B . "0x6C5D")  ;; <CJK>
       (?$BFs(B . "0x4E8C")  ;; <CJK>
       (?$BFt(B . "0x5C3C")  ;; <CJK>
       (?$BFu(B . "0x5F10")  ;; <CJK>
       (?$BFv(B . "0x8FE9")  ;; <CJK>
       (?$BFw(B . "0x5302")  ;; <CJK>
       (?$BFx(B . "0x8CD1")  ;; <CJK>
       (?$BFy(B . "0x8089")  ;; <CJK>
       (?$BFz(B . "0x8679")  ;; <CJK>
       (?$BF{(B . "0x5EFF")  ;; <CJK>
       (?$BF|(B . "0x65E5")  ;; <CJK>
       (?$BF}(B . "0x4E73")  ;; <CJK>
       (?$BF~(B . "0x5165")  ;; <CJK>
       (?$BG!(B . "0x5982")  ;; <CJK>
       (?$BG"(B . "0x5C3F")  ;; <CJK>
       (?$BG#(B . "0x97EE")  ;; <CJK>
       (?$BG$(B . "0x4EFB")  ;; <CJK>
       (?$BG%(B . "0x598A")  ;; <CJK>
       (?$BG&(B . "0x5FCD")  ;; <CJK>
       (?$BG'(B . "0x8A8D")  ;; <CJK>
       (?$BG((B . "0x6FE1")  ;; <CJK>
       (?$BG)(B . "0x79B0")  ;; <CJK>
       (?$BG*(B . "0x7962")  ;; <CJK>
       (?$BG+(B . "0x5BE7")  ;; <CJK>
       (?$BG,(B . "0x8471")  ;; <CJK>
       (?$BG-(B . "0x732B")  ;; <CJK>
       (?$BG.(B . "0x71B1")  ;; <CJK>
       (?$BG/(B . "0x5E74")  ;; <CJK>
       (?$BG0(B . "0x5FF5")  ;; <CJK>
       (?$BG1(B . "0x637B")  ;; <CJK>
       (?$BG2(B . "0x649A")  ;; <CJK>
       (?$BG3(B . "0x71C3")  ;; <CJK>
       (?$BG4(B . "0x7C98")  ;; <CJK>
       (?$BG5(B . "0x4E43")  ;; <CJK>
       (?$BG6(B . "0x5EFC")  ;; <CJK>
       (?$BG7(B . "0x4E4B")  ;; <CJK>
       (?$BG8(B . "0x57DC")  ;; <CJK>
       (?$BG9(B . "0x56A2")  ;; <CJK>
       (?$BG:(B . "0x60A9")  ;; <CJK>
       (?$BG;(B . "0x6FC3")  ;; <CJK>
       (?$BG<(B . "0x7D0D")  ;; <CJK>
       (?$BG=(B . "0x80FD")  ;; <CJK>
       (?$BG>(B . "0x8133")  ;; <CJK>
       (?$BG?(B . "0x81BF")  ;; <CJK>
       (?$BG@(B . "0x8FB2")  ;; <CJK>
       (?$BGA(B . "0x8997")  ;; <CJK>
       (?$BGB(B . "0x86A4")  ;; <CJK>
       (?$BGC(B . "0x5DF4")  ;; <CJK>
       (?$BGD(B . "0x628A")  ;; <CJK>
       (?$BGE(B . "0x64AD")  ;; <CJK>
       (?$BGF(B . "0x8987")  ;; <CJK>
       (?$BGG(B . "0x6777")  ;; <CJK>
       (?$BGH(B . "0x6CE2")  ;; <CJK>
       (?$BGI(B . "0x6D3E")  ;; <CJK>
       (?$BGJ(B . "0x7436")  ;; <CJK>
       (?$BGK(B . "0x7834")  ;; <CJK>
       (?$BGL(B . "0x5A46")  ;; <CJK>
       (?$BGM(B . "0x7F75")  ;; <CJK>
       (?$BGN(B . "0x82AD")  ;; <CJK>
       (?$BGO(B . "0x99AC")  ;; <CJK>
       (?$BGP(B . "0x4FF3")  ;; <CJK>
       (?$BGQ(B . "0x5EC3")  ;; <CJK>
       (?$BGR(B . "0x62DD")  ;; <CJK>
       (?$BGS(B . "0x6392")  ;; <CJK>
       (?$BGT(B . "0x6557")  ;; <CJK>
       (?$BGU(B . "0x676F")  ;; <CJK>
       (?$BGV(B . "0x76C3")  ;; <CJK>
       (?$BGW(B . "0x724C")  ;; <CJK>
       (?$BGX(B . "0x80CC")  ;; <CJK>
       (?$BGY(B . "0x80BA")  ;; <CJK>
       (?$BGZ(B . "0x8F29")  ;; <CJK>
       (?$BG[(B . "0x914D")  ;; <CJK>
       (?$BG\(B . "0x500D")  ;; <CJK>
       (?$BG](B . "0x57F9")  ;; <CJK>
       (?$BG^(B . "0x5A92")  ;; <CJK>
       (?$BG_(B . "0x6885")  ;; <CJK>
       (?$BG`(B . "0x6973")  ;; <CJK>
       (?$BGa(B . "0x7164")  ;; <CJK>
       (?$BGb(B . "0x72FD")  ;; <CJK>
       (?$BGc(B . "0x8CB7")  ;; <CJK>
       (?$BGd(B . "0x58F2")  ;; <CJK>
       (?$BGe(B . "0x8CE0")  ;; <CJK>
       (?$BGf(B . "0x966A")  ;; <CJK>
       (?$BGg(B . "0x9019")  ;; <CJK>
       (?$BGh(B . "0x877F")  ;; <CJK>
       (?$BGi(B . "0x79E4")  ;; <CJK>
       (?$BGj(B . "0x77E7")  ;; <CJK>
       (?$BGk(B . "0x8429")  ;; <CJK>
       (?$BGl(B . "0x4F2F")  ;; <CJK>
       (?$BGm(B . "0x5265")  ;; <CJK>
       (?$BGn(B . "0x535A")  ;; <CJK>
       (?$BGo(B . "0x62CD")  ;; <CJK>
       (?$BGp(B . "0x67CF")  ;; <CJK>
       (?$BGq(B . "0x6CCA")  ;; <CJK>
       (?$BGr(B . "0x767D")  ;; <CJK>
       (?$BGs(B . "0x7B94")  ;; <CJK>
       (?$BGt(B . "0x7C95")  ;; <CJK>
       (?$BGu(B . "0x8236")  ;; <CJK>
       (?$BGv(B . "0x8584")  ;; <CJK>
       (?$BGw(B . "0x8FEB")  ;; <CJK>
       (?$BGx(B . "0x66DD")  ;; <CJK>
       (?$BGy(B . "0x6F20")  ;; <CJK>
       (?$BGz(B . "0x7206")  ;; <CJK>
       (?$BG{(B . "0x7E1B")  ;; <CJK>
       (?$BG|(B . "0x83AB")  ;; <CJK>
       (?$BG}(B . "0x99C1")  ;; <CJK>
       (?$BG~(B . "0x9EA6")  ;; <CJK>
       (?$BH!(B . "0x51FD")  ;; <CJK>
       (?$BH"(B . "0x7BB1")  ;; <CJK>
       (?$BH#(B . "0x7872")  ;; <CJK>
       (?$BH$(B . "0x7BB8")  ;; <CJK>
       (?$BH%(B . "0x8087")  ;; <CJK>
       (?$BH&(B . "0x7B48")  ;; <CJK>
       (?$BH'(B . "0x6AE8")  ;; <CJK>
       (?$BH((B . "0x5E61")  ;; <CJK>
       (?$BH)(B . "0x808C")  ;; <CJK>
       (?$BH*(B . "0x7551")  ;; <CJK>
       (?$BH+(B . "0x7560")  ;; <CJK>
       (?$BH,(B . "0x516B")  ;; <CJK>
       (?$BH-(B . "0x9262")  ;; <CJK>
       (?$BH.(B . "0x6E8C")  ;; <CJK>
       (?$BH/(B . "0x767A")  ;; <CJK>
       (?$BH0(B . "0x9197")  ;; <CJK>
       (?$BH1(B . "0x9AEA")  ;; <CJK>
       (?$BH2(B . "0x4F10")  ;; <CJK>
       (?$BH3(B . "0x7F70")  ;; <CJK>
       (?$BH4(B . "0x629C")  ;; <CJK>
       (?$BH5(B . "0x7B4F")  ;; <CJK>
       (?$BH6(B . "0x95A5")  ;; <CJK>
       (?$BH7(B . "0x9CE9")  ;; <CJK>
       (?$BH8(B . "0x567A")  ;; <CJK>
       (?$BH9(B . "0x5859")  ;; <CJK>
       (?$BH:(B . "0x86E4")  ;; <CJK>
       (?$BH;(B . "0x96BC")  ;; <CJK>
       (?$BH<(B . "0x4F34")  ;; <CJK>
       (?$BH=(B . "0x5224")  ;; <CJK>
       (?$BH>(B . "0x534A")  ;; <CJK>
       (?$BH?(B . "0x53CD")  ;; <CJK>
       (?$BH@(B . "0x53DB")  ;; <CJK>
       (?$BHA(B . "0x5E06")  ;; <CJK>
       (?$BHB(B . "0x642C")  ;; <CJK>
       (?$BHC(B . "0x6591")  ;; <CJK>
       (?$BHD(B . "0x677F")  ;; <CJK>
       (?$BHE(B . "0x6C3E")  ;; <CJK>
       (?$BHF(B . "0x6C4E")  ;; <CJK>
       (?$BHG(B . "0x7248")  ;; <CJK>
       (?$BHH(B . "0x72AF")  ;; <CJK>
       (?$BHI(B . "0x73ED")  ;; <CJK>
       (?$BHJ(B . "0x7554")  ;; <CJK>
       (?$BHK(B . "0x7E41")  ;; <CJK>
       (?$BHL(B . "0x822C")  ;; <CJK>
       (?$BHM(B . "0x85E9")  ;; <CJK>
       (?$BHN(B . "0x8CA9")  ;; <CJK>
       (?$BHO(B . "0x7BC4")  ;; <CJK>
       (?$BHP(B . "0x91C6")  ;; <CJK>
       (?$BHQ(B . "0x7169")  ;; <CJK>
       (?$BHR(B . "0x9812")  ;; <CJK>
       (?$BHS(B . "0x98EF")  ;; <CJK>
       (?$BHT(B . "0x633D")  ;; <CJK>
       (?$BHU(B . "0x6669")  ;; <CJK>
       (?$BHV(B . "0x756A")  ;; <CJK>
       (?$BHW(B . "0x76E4")  ;; <CJK>
       (?$BHX(B . "0x78D0")  ;; <CJK>
       (?$BHY(B . "0x8543")  ;; <CJK>
       (?$BHZ(B . "0x86EE")  ;; <CJK>
       (?$BH[(B . "0x532A")  ;; <CJK>
       (?$BH\(B . "0x5351")  ;; <CJK>
       (?$BH](B . "0x5426")  ;; <CJK>
       (?$BH^(B . "0x5983")  ;; <CJK>
       (?$BH_(B . "0x5E87")  ;; <CJK>
       (?$BH`(B . "0x5F7C")  ;; <CJK>
       (?$BHa(B . "0x60B2")  ;; <CJK>
       (?$BHb(B . "0x6249")  ;; <CJK>
       (?$BHc(B . "0x6279")  ;; <CJK>
       (?$BHd(B . "0x62AB")  ;; <CJK>
       (?$BHe(B . "0x6590")  ;; <CJK>
       (?$BHf(B . "0x6BD4")  ;; <CJK>
       (?$BHg(B . "0x6CCC")  ;; <CJK>
       (?$BHh(B . "0x75B2")  ;; <CJK>
       (?$BHi(B . "0x76AE")  ;; <CJK>
       (?$BHj(B . "0x7891")  ;; <CJK>
       (?$BHk(B . "0x79D8")  ;; <CJK>
       (?$BHl(B . "0x7DCB")  ;; <CJK>
       (?$BHm(B . "0x7F77")  ;; <CJK>
       (?$BHn(B . "0x80A5")  ;; <CJK>
       (?$BHo(B . "0x88AB")  ;; <CJK>
       (?$BHp(B . "0x8AB9")  ;; <CJK>
       (?$BHq(B . "0x8CBB")  ;; <CJK>
       (?$BHr(B . "0x907F")  ;; <CJK>
       (?$BHs(B . "0x975E")  ;; <CJK>
       (?$BHt(B . "0x98DB")  ;; <CJK>
       (?$BHu(B . "0x6A0B")  ;; <CJK>
       (?$BHv(B . "0x7C38")  ;; <CJK>
       (?$BHw(B . "0x5099")  ;; <CJK>
       (?$BHx(B . "0x5C3E")  ;; <CJK>
       (?$BHy(B . "0x5FAE")  ;; <CJK>
       (?$BHz(B . "0x6787")  ;; <CJK>
       (?$BH{(B . "0x6BD8")  ;; <CJK>
       (?$BH|(B . "0x7435")  ;; <CJK>
       (?$BH}(B . "0x7709")  ;; <CJK>
       (?$BH~(B . "0x7F8E")  ;; <CJK>
       (?$BI!(B . "0x9F3B")  ;; <CJK>
       (?$BI"(B . "0x67CA")  ;; <CJK>
       (?$BI#(B . "0x7A17")  ;; <CJK>
       (?$BI$(B . "0x5339")  ;; <CJK>
       (?$BI%(B . "0x758B")  ;; <CJK>
       (?$BI&(B . "0x9AED")  ;; <CJK>
       (?$BI'(B . "0x5F66")  ;; <CJK>
       (?$BI((B . "0x819D")  ;; <CJK>
       (?$BI)(B . "0x83F1")  ;; <CJK>
       (?$BI*(B . "0x8098")  ;; <CJK>
       (?$BI+(B . "0x5F3C")  ;; <CJK>
       (?$BI,(B . "0x5FC5")  ;; <CJK>
       (?$BI-(B . "0x7562")  ;; <CJK>
       (?$BI.(B . "0x7B46")  ;; <CJK>
       (?$BI/(B . "0x903C")  ;; <CJK>
       (?$BI0(B . "0x6867")  ;; <CJK>
       (?$BI1(B . "0x59EB")  ;; <CJK>
       (?$BI2(B . "0x5A9B")  ;; <CJK>
       (?$BI3(B . "0x7D10")  ;; <CJK>
       (?$BI4(B . "0x767E")  ;; <CJK>
       (?$BI5(B . "0x8B2C")  ;; <CJK>
       (?$BI6(B . "0x4FF5")  ;; <CJK>
       (?$BI7(B . "0x5F6A")  ;; <CJK>
       (?$BI8(B . "0x6A19")  ;; <CJK>
       (?$BI9(B . "0x6C37")  ;; <CJK>
       (?$BI:(B . "0x6F02")  ;; <CJK>
       (?$BI;(B . "0x74E2")  ;; <CJK>
       (?$BI<(B . "0x7968")  ;; <CJK>
       (?$BI=(B . "0x8868")  ;; <CJK>
       (?$BI>(B . "0x8A55")  ;; <CJK>
       (?$BI?(B . "0x8C79")  ;; <CJK>
       (?$BI@(B . "0x5EDF")  ;; <CJK>
       (?$BIA(B . "0x63CF")  ;; <CJK>
       (?$BIB(B . "0x75C5")  ;; <CJK>
       (?$BIC(B . "0x79D2")  ;; <CJK>
       (?$BID(B . "0x82D7")  ;; <CJK>
       (?$BIE(B . "0x9328")  ;; <CJK>
       (?$BIF(B . "0x92F2")  ;; <CJK>
       (?$BIG(B . "0x849C")  ;; <CJK>
       (?$BIH(B . "0x86ED")  ;; <CJK>
       (?$BII(B . "0x9C2D")  ;; <CJK>
       (?$BIJ(B . "0x54C1")  ;; <CJK>
       (?$BIK(B . "0x5F6C")  ;; <CJK>
       (?$BIL(B . "0x658C")  ;; <CJK>
       (?$BIM(B . "0x6D5C")  ;; <CJK>
       (?$BIN(B . "0x7015")  ;; <CJK>
       (?$BIO(B . "0x8CA7")  ;; <CJK>
       (?$BIP(B . "0x8CD3")  ;; <CJK>
       (?$BIQ(B . "0x983B")  ;; <CJK>
       (?$BIR(B . "0x654F")  ;; <CJK>
       (?$BIS(B . "0x74F6")  ;; <CJK>
       (?$BIT(B . "0x4E0D")  ;; <CJK>
       (?$BIU(B . "0x4ED8")  ;; <CJK>
       (?$BIV(B . "0x57E0")  ;; <CJK>
       (?$BIW(B . "0x592B")  ;; <CJK>
       (?$BIX(B . "0x5A66")  ;; <CJK>
       (?$BIY(B . "0x5BCC")  ;; <CJK>
       (?$BIZ(B . "0x51A8")  ;; <CJK>
       (?$BI[(B . "0x5E03")  ;; <CJK>
       (?$BI\(B . "0x5E9C")  ;; <CJK>
       (?$BI](B . "0x6016")  ;; <CJK>
       (?$BI^(B . "0x6276")  ;; <CJK>
       (?$BI_(B . "0x6577")  ;; <CJK>
       (?$BI`(B . "0x65A7")  ;; <CJK>
       (?$BIa(B . "0x666E")  ;; <CJK>
       (?$BIb(B . "0x6D6E")  ;; <CJK>
       (?$BIc(B . "0x7236")  ;; <CJK>
       (?$BId(B . "0x7B26")  ;; <CJK>
       (?$BIe(B . "0x8150")  ;; <CJK>
       (?$BIf(B . "0x819A")  ;; <CJK>
       (?$BIg(B . "0x8299")  ;; <CJK>
       (?$BIh(B . "0x8B5C")  ;; <CJK>
       (?$BIi(B . "0x8CA0")  ;; <CJK>
       (?$BIj(B . "0x8CE6")  ;; <CJK>
       (?$BIk(B . "0x8D74")  ;; <CJK>
       (?$BIl(B . "0x961C")  ;; <CJK>
       (?$BIm(B . "0x9644")  ;; <CJK>
       (?$BIn(B . "0x4FAE")  ;; <CJK>
       (?$BIo(B . "0x64AB")  ;; <CJK>
       (?$BIp(B . "0x6B66")  ;; <CJK>
       (?$BIq(B . "0x821E")  ;; <CJK>
       (?$BIr(B . "0x8461")  ;; <CJK>
       (?$BIs(B . "0x856A")  ;; <CJK>
       (?$BIt(B . "0x90E8")  ;; <CJK>
       (?$BIu(B . "0x5C01")  ;; <CJK>
       (?$BIv(B . "0x6953")  ;; <CJK>
       (?$BIw(B . "0x98A8")  ;; <CJK>
       (?$BIx(B . "0x847A")  ;; <CJK>
       (?$BIy(B . "0x8557")  ;; <CJK>
       (?$BIz(B . "0x4F0F")  ;; <CJK>
       (?$BI{(B . "0x526F")  ;; <CJK>
       (?$BI|(B . "0x5FA9")  ;; <CJK>
       (?$BI}(B . "0x5E45")  ;; <CJK>
       (?$BI~(B . "0x670D")  ;; <CJK>
       (?$BJ!(B . "0x798F")  ;; <CJK>
       (?$BJ"(B . "0x8179")  ;; <CJK>
       (?$BJ#(B . "0x8907")  ;; <CJK>
       (?$BJ$(B . "0x8986")  ;; <CJK>
       (?$BJ%(B . "0x6DF5")  ;; <CJK>
       (?$BJ&(B . "0x5F17")  ;; <CJK>
       (?$BJ'(B . "0x6255")  ;; <CJK>
       (?$BJ((B . "0x6CB8")  ;; <CJK>
       (?$BJ)(B . "0x4ECF")  ;; <CJK>
       (?$BJ*(B . "0x7269")  ;; <CJK>
       (?$BJ+(B . "0x9B92")  ;; <CJK>
       (?$BJ,(B . "0x5206")  ;; <CJK>
       (?$BJ-(B . "0x543B")  ;; <CJK>
       (?$BJ.(B . "0x5674")  ;; <CJK>
       (?$BJ/(B . "0x58B3")  ;; <CJK>
       (?$BJ0(B . "0x61A4")  ;; <CJK>
       (?$BJ1(B . "0x626E")  ;; <CJK>
       (?$BJ2(B . "0x711A")  ;; <CJK>
       (?$BJ3(B . "0x596E")  ;; <CJK>
       (?$BJ4(B . "0x7C89")  ;; <CJK>
       (?$BJ5(B . "0x7CDE")  ;; <CJK>
       (?$BJ6(B . "0x7D1B")  ;; <CJK>
       (?$BJ7(B . "0x96F0")  ;; <CJK>
       (?$BJ8(B . "0x6587")  ;; <CJK>
       (?$BJ9(B . "0x805E")  ;; <CJK>
       (?$BJ:(B . "0x4E19")  ;; <CJK>
       (?$BJ;(B . "0x4F75")  ;; <CJK>
       (?$BJ<(B . "0x5175")  ;; <CJK>
       (?$BJ=(B . "0x5840")  ;; <CJK>
       (?$BJ>(B . "0x5E63")  ;; <CJK>
       (?$BJ?(B . "0x5E73")  ;; <CJK>
       (?$BJ@(B . "0x5F0A")  ;; <CJK>
       (?$BJA(B . "0x67C4")  ;; <CJK>
       (?$BJB(B . "0x4E26")  ;; <CJK>
       (?$BJC(B . "0x853D")  ;; <CJK>
       (?$BJD(B . "0x9589")  ;; <CJK>
       (?$BJE(B . "0x965B")  ;; <CJK>
       (?$BJF(B . "0x7C73")  ;; <CJK>
       (?$BJG(B . "0x9801")  ;; <CJK>
       (?$BJH(B . "0x50FB")  ;; <CJK>
       (?$BJI(B . "0x58C1")  ;; <CJK>
       (?$BJJ(B . "0x7656")  ;; <CJK>
       (?$BJK(B . "0x78A7")  ;; <CJK>
       (?$BJL(B . "0x5225")  ;; <CJK>
       (?$BJM(B . "0x77A5")  ;; <CJK>
       (?$BJN(B . "0x8511")  ;; <CJK>
       (?$BJO(B . "0x7B86")  ;; <CJK>
       (?$BJP(B . "0x504F")  ;; <CJK>
       (?$BJQ(B . "0x5909")  ;; <CJK>
       (?$BJR(B . "0x7247")  ;; <CJK>
       (?$BJS(B . "0x7BC7")  ;; <CJK>
       (?$BJT(B . "0x7DE8")  ;; <CJK>
       (?$BJU(B . "0x8FBA")  ;; <CJK>
       (?$BJV(B . "0x8FD4")  ;; <CJK>
       (?$BJW(B . "0x904D")  ;; <CJK>
       (?$BJX(B . "0x4FBF")  ;; <CJK>
       (?$BJY(B . "0x52C9")  ;; <CJK>
       (?$BJZ(B . "0x5A29")  ;; <CJK>
       (?$BJ[(B . "0x5F01")  ;; <CJK>
       (?$BJ\(B . "0x97AD")  ;; <CJK>
       (?$BJ](B . "0x4FDD")  ;; <CJK>
       (?$BJ^(B . "0x8217")  ;; <CJK>
       (?$BJ_(B . "0x92EA")  ;; <CJK>
       (?$BJ`(B . "0x5703")  ;; <CJK>
       (?$BJa(B . "0x6355")  ;; <CJK>
       (?$BJb(B . "0x6B69")  ;; <CJK>
       (?$BJc(B . "0x752B")  ;; <CJK>
       (?$BJd(B . "0x88DC")  ;; <CJK>
       (?$BJe(B . "0x8F14")  ;; <CJK>
       (?$BJf(B . "0x7A42")  ;; <CJK>
       (?$BJg(B . "0x52DF")  ;; <CJK>
       (?$BJh(B . "0x5893")  ;; <CJK>
       (?$BJi(B . "0x6155")  ;; <CJK>
       (?$BJj(B . "0x620A")  ;; <CJK>
       (?$BJk(B . "0x66AE")  ;; <CJK>
       (?$BJl(B . "0x6BCD")  ;; <CJK>
       (?$BJm(B . "0x7C3F")  ;; <CJK>
       (?$BJn(B . "0x83E9")  ;; <CJK>
       (?$BJo(B . "0x5023")  ;; <CJK>
       (?$BJp(B . "0x4FF8")  ;; <CJK>
       (?$BJq(B . "0x5305")  ;; <CJK>
       (?$BJr(B . "0x5446")  ;; <CJK>
       (?$BJs(B . "0x5831")  ;; <CJK>
       (?$BJt(B . "0x5949")  ;; <CJK>
       (?$BJu(B . "0x5B9D")  ;; <CJK>
       (?$BJv(B . "0x5CF0")  ;; <CJK>
       (?$BJw(B . "0x5CEF")  ;; <CJK>
       (?$BJx(B . "0x5D29")  ;; <CJK>
       (?$BJy(B . "0x5E96")  ;; <CJK>
       (?$BJz(B . "0x62B1")  ;; <CJK>
       (?$BJ{(B . "0x6367")  ;; <CJK>
       (?$BJ|(B . "0x653E")  ;; <CJK>
       (?$BJ}(B . "0x65B9")  ;; <CJK>
       (?$BJ~(B . "0x670B")  ;; <CJK>
       (?$BK!(B . "0x6CD5")  ;; <CJK>
       (?$BK"(B . "0x6CE1")  ;; <CJK>
       (?$BK#(B . "0x70F9")  ;; <CJK>
       (?$BK$(B . "0x7832")  ;; <CJK>
       (?$BK%(B . "0x7E2B")  ;; <CJK>
       (?$BK&(B . "0x80DE")  ;; <CJK>
       (?$BK'(B . "0x82B3")  ;; <CJK>
       (?$BK((B . "0x840C")  ;; <CJK>
       (?$BK)(B . "0x84EC")  ;; <CJK>
       (?$BK*(B . "0x8702")  ;; <CJK>
       (?$BK+(B . "0x8912")  ;; <CJK>
       (?$BK,(B . "0x8A2A")  ;; <CJK>
       (?$BK-(B . "0x8C4A")  ;; <CJK>
       (?$BK.(B . "0x90A6")  ;; <CJK>
       (?$BK/(B . "0x92D2")  ;; <CJK>
       (?$BK0(B . "0x98FD")  ;; <CJK>
       (?$BK1(B . "0x9CF3")  ;; <CJK>
       (?$BK2(B . "0x9D6C")  ;; <CJK>
       (?$BK3(B . "0x4E4F")  ;; <CJK>
       (?$BK4(B . "0x4EA1")  ;; <CJK>
       (?$BK5(B . "0x508D")  ;; <CJK>
       (?$BK6(B . "0x5256")  ;; <CJK>
       (?$BK7(B . "0x574A")  ;; <CJK>
       (?$BK8(B . "0x59A8")  ;; <CJK>
       (?$BK9(B . "0x5E3D")  ;; <CJK>
       (?$BK:(B . "0x5FD8")  ;; <CJK>
       (?$BK;(B . "0x5FD9")  ;; <CJK>
       (?$BK<(B . "0x623F")  ;; <CJK>
       (?$BK=(B . "0x66B4")  ;; <CJK>
       (?$BK>(B . "0x671B")  ;; <CJK>
       (?$BK?(B . "0x67D0")  ;; <CJK>
       (?$BK@(B . "0x68D2")  ;; <CJK>
       (?$BKA(B . "0x5192")  ;; <CJK>
       (?$BKB(B . "0x7D21")  ;; <CJK>
       (?$BKC(B . "0x80AA")  ;; <CJK>
       (?$BKD(B . "0x81A8")  ;; <CJK>
       (?$BKE(B . "0x8B00")  ;; <CJK>
       (?$BKF(B . "0x8C8C")  ;; <CJK>
       (?$BKG(B . "0x8CBF")  ;; <CJK>
       (?$BKH(B . "0x927E")  ;; <CJK>
       (?$BKI(B . "0x9632")  ;; <CJK>
       (?$BKJ(B . "0x5420")  ;; <CJK>
       (?$BKK(B . "0x982C")  ;; <CJK>
       (?$BKL(B . "0x5317")  ;; <CJK>
       (?$BKM(B . "0x50D5")  ;; <CJK>
       (?$BKN(B . "0x535C")  ;; <CJK>
       (?$BKO(B . "0x58A8")  ;; <CJK>
       (?$BKP(B . "0x64B2")  ;; <CJK>
       (?$BKQ(B . "0x6734")  ;; <CJK>
       (?$BKR(B . "0x7267")  ;; <CJK>
       (?$BKS(B . "0x7766")  ;; <CJK>
       (?$BKT(B . "0x7A46")  ;; <CJK>
       (?$BKU(B . "0x91E6")  ;; <CJK>
       (?$BKV(B . "0x52C3")  ;; <CJK>
       (?$BKW(B . "0x6CA1")  ;; <CJK>
       (?$BKX(B . "0x6B86")  ;; <CJK>
       (?$BKY(B . "0x5800")  ;; <CJK>
       (?$BKZ(B . "0x5E4C")  ;; <CJK>
       (?$BK[(B . "0x5954")  ;; <CJK>
       (?$BK\(B . "0x672C")  ;; <CJK>
       (?$BK](B . "0x7FFB")  ;; <CJK>
       (?$BK^(B . "0x51E1")  ;; <CJK>
       (?$BK_(B . "0x76C6")  ;; <CJK>
       (?$BK`(B . "0x6469")  ;; <CJK>
       (?$BKa(B . "0x78E8")  ;; <CJK>
       (?$BKb(B . "0x9B54")  ;; <CJK>
       (?$BKc(B . "0x9EBB")  ;; <CJK>
       (?$BKd(B . "0x57CB")  ;; <CJK>
       (?$BKe(B . "0x59B9")  ;; <CJK>
       (?$BKf(B . "0x6627")  ;; <CJK>
       (?$BKg(B . "0x679A")  ;; <CJK>
       (?$BKh(B . "0x6BCE")  ;; <CJK>
       (?$BKi(B . "0x54E9")  ;; <CJK>
       (?$BKj(B . "0x69D9")  ;; <CJK>
       (?$BKk(B . "0x5E55")  ;; <CJK>
       (?$BKl(B . "0x819C")  ;; <CJK>
       (?$BKm(B . "0x6795")  ;; <CJK>
       (?$BKn(B . "0x9BAA")  ;; <CJK>
       (?$BKo(B . "0x67FE")  ;; <CJK>
       (?$BKp(B . "0x9C52")  ;; <CJK>
       (?$BKq(B . "0x685D")  ;; <CJK>
       (?$BKr(B . "0x4EA6")  ;; <CJK>
       (?$BKs(B . "0x4FE3")  ;; <CJK>
       (?$BKt(B . "0x53C8")  ;; <CJK>
       (?$BKu(B . "0x62B9")  ;; <CJK>
       (?$BKv(B . "0x672B")  ;; <CJK>
       (?$BKw(B . "0x6CAB")  ;; <CJK>
       (?$BKx(B . "0x8FC4")  ;; <CJK>
       (?$BKy(B . "0x4FAD")  ;; <CJK>
       (?$BKz(B . "0x7E6D")  ;; <CJK>
       (?$BK{(B . "0x9EBF")  ;; <CJK>
       (?$BK|(B . "0x4E07")  ;; <CJK>
       (?$BK}(B . "0x6162")  ;; <CJK>
       (?$BK~(B . "0x6E80")  ;; <CJK>
       (?$BL!(B . "0x6F2B")  ;; <CJK>
       (?$BL"(B . "0x8513")  ;; <CJK>
       (?$BL#(B . "0x5473")  ;; <CJK>
       (?$BL$(B . "0x672A")  ;; <CJK>
       (?$BL%(B . "0x9B45")  ;; <CJK>
       (?$BL&(B . "0x5DF3")  ;; <CJK>
       (?$BL'(B . "0x7B95")  ;; <CJK>
       (?$BL((B . "0x5CAC")  ;; <CJK>
       (?$BL)(B . "0x5BC6")  ;; <CJK>
       (?$BL*(B . "0x871C")  ;; <CJK>
       (?$BL+(B . "0x6E4A")  ;; <CJK>
       (?$BL,(B . "0x84D1")  ;; <CJK>
       (?$BL-(B . "0x7A14")  ;; <CJK>
       (?$BL.(B . "0x8108")  ;; <CJK>
       (?$BL/(B . "0x5999")  ;; <CJK>
       (?$BL0(B . "0x7C8D")  ;; <CJK>
       (?$BL1(B . "0x6C11")  ;; <CJK>
       (?$BL2(B . "0x7720")  ;; <CJK>
       (?$BL3(B . "0x52D9")  ;; <CJK>
       (?$BL4(B . "0x5922")  ;; <CJK>
       (?$BL5(B . "0x7121")  ;; <CJK>
       (?$BL6(B . "0x725F")  ;; <CJK>
       (?$BL7(B . "0x77DB")  ;; <CJK>
       (?$BL8(B . "0x9727")  ;; <CJK>
       (?$BL9(B . "0x9D61")  ;; <CJK>
       (?$BL:(B . "0x690B")  ;; <CJK>
       (?$BL;(B . "0x5A7F")  ;; <CJK>
       (?$BL<(B . "0x5A18")  ;; <CJK>
       (?$BL=(B . "0x51A5")  ;; <CJK>
       (?$BL>(B . "0x540D")  ;; <CJK>
       (?$BL?(B . "0x547D")  ;; <CJK>
       (?$BL@(B . "0x660E")  ;; <CJK>
       (?$BLA(B . "0x76DF")  ;; <CJK>
       (?$BLB(B . "0x8FF7")  ;; <CJK>
       (?$BLC(B . "0x9298")  ;; <CJK>
       (?$BLD(B . "0x9CF4")  ;; <CJK>
       (?$BLE(B . "0x59EA")  ;; <CJK>
       (?$BLF(B . "0x725D")  ;; <CJK>
       (?$BLG(B . "0x6EC5")  ;; <CJK>
       (?$BLH(B . "0x514D")  ;; <CJK>
       (?$BLI(B . "0x68C9")  ;; <CJK>
       (?$BLJ(B . "0x7DBF")  ;; <CJK>
       (?$BLK(B . "0x7DEC")  ;; <CJK>
       (?$BLL(B . "0x9762")  ;; <CJK>
       (?$BLM(B . "0x9EBA")  ;; <CJK>
       (?$BLN(B . "0x6478")  ;; <CJK>
       (?$BLO(B . "0x6A21")  ;; <CJK>
       (?$BLP(B . "0x8302")  ;; <CJK>
       (?$BLQ(B . "0x5984")  ;; <CJK>
       (?$BLR(B . "0x5B5F")  ;; <CJK>
       (?$BLS(B . "0x6BDB")  ;; <CJK>
       (?$BLT(B . "0x731B")  ;; <CJK>
       (?$BLU(B . "0x76F2")  ;; <CJK>
       (?$BLV(B . "0x7DB2")  ;; <CJK>
       (?$BLW(B . "0x8017")  ;; <CJK>
       (?$BLX(B . "0x8499")  ;; <CJK>
       (?$BLY(B . "0x5132")  ;; <CJK>
       (?$BLZ(B . "0x6728")  ;; <CJK>
       (?$BL[(B . "0x9ED9")  ;; <CJK>
       (?$BL\(B . "0x76EE")  ;; <CJK>
       (?$BL](B . "0x6762")  ;; <CJK>
       (?$BL^(B . "0x52FF")  ;; <CJK>
       (?$BL_(B . "0x9905")  ;; <CJK>
       (?$BL`(B . "0x5C24")  ;; <CJK>
       (?$BLa(B . "0x623B")  ;; <CJK>
       (?$BLb(B . "0x7C7E")  ;; <CJK>
       (?$BLc(B . "0x8CB0")  ;; <CJK>
       (?$BLd(B . "0x554F")  ;; <CJK>
       (?$BLe(B . "0x60B6")  ;; <CJK>
       (?$BLf(B . "0x7D0B")  ;; <CJK>
       (?$BLg(B . "0x9580")  ;; <CJK>
       (?$BLh(B . "0x5301")  ;; <CJK>
       (?$BLi(B . "0x4E5F")  ;; <CJK>
       (?$BLj(B . "0x51B6")  ;; <CJK>
       (?$BLk(B . "0x591C")  ;; <CJK>
       (?$BLl(B . "0x723A")  ;; <CJK>
       (?$BLm(B . "0x8036")  ;; <CJK>
       (?$BLn(B . "0x91CE")  ;; <CJK>
       (?$BLo(B . "0x5F25")  ;; <CJK>
       (?$BLp(B . "0x77E2")  ;; <CJK>
       (?$BLq(B . "0x5384")  ;; <CJK>
       (?$BLr(B . "0x5F79")  ;; <CJK>
       (?$BLs(B . "0x7D04")  ;; <CJK>
       (?$BLt(B . "0x85AC")  ;; <CJK>
       (?$BLu(B . "0x8A33")  ;; <CJK>
       (?$BLv(B . "0x8E8D")  ;; <CJK>
       (?$BLw(B . "0x9756")  ;; <CJK>
       (?$BLx(B . "0x67F3")  ;; <CJK>
       (?$BLy(B . "0x85AE")  ;; <CJK>
       (?$BLz(B . "0x9453")  ;; <CJK>
       (?$BL{(B . "0x6109")  ;; <CJK>
       (?$BL|(B . "0x6108")  ;; <CJK>
       (?$BL}(B . "0x6CB9")  ;; <CJK>
       (?$BL~(B . "0x7652")  ;; <CJK>
       (?$BM!(B . "0x8AED")  ;; <CJK>
       (?$BM"(B . "0x8F38")  ;; <CJK>
       (?$BM#(B . "0x552F")  ;; <CJK>
       (?$BM$(B . "0x4F51")  ;; <CJK>
       (?$BM%(B . "0x512A")  ;; <CJK>
       (?$BM&(B . "0x52C7")  ;; <CJK>
       (?$BM'(B . "0x53CB")  ;; <CJK>
       (?$BM((B . "0x5BA5")  ;; <CJK>
       (?$BM)(B . "0x5E7D")  ;; <CJK>
       (?$BM*(B . "0x60A0")  ;; <CJK>
       (?$BM+(B . "0x6182")  ;; <CJK>
       (?$BM,(B . "0x63D6")  ;; <CJK>
       (?$BM-(B . "0x6709")  ;; <CJK>
       (?$BM.(B . "0x67DA")  ;; <CJK>
       (?$BM/(B . "0x6E67")  ;; <CJK>
       (?$BM0(B . "0x6D8C")  ;; <CJK>
       (?$BM1(B . "0x7336")  ;; <CJK>
       (?$BM2(B . "0x7337")  ;; <CJK>
       (?$BM3(B . "0x7531")  ;; <CJK>
       (?$BM4(B . "0x7950")  ;; <CJK>
       (?$BM5(B . "0x88D5")  ;; <CJK>
       (?$BM6(B . "0x8A98")  ;; <CJK>
       (?$BM7(B . "0x904A")  ;; <CJK>
       (?$BM8(B . "0x9091")  ;; <CJK>
       (?$BM9(B . "0x90F5")  ;; <CJK>
       (?$BM:(B . "0x96C4")  ;; <CJK>
       (?$BM;(B . "0x878D")  ;; <CJK>
       (?$BM<(B . "0x5915")  ;; <CJK>
       (?$BM=(B . "0x4E88")  ;; <CJK>
       (?$BM>(B . "0x4F59")  ;; <CJK>
       (?$BM?(B . "0x4E0E")  ;; <CJK>
       (?$BM@(B . "0x8A89")  ;; <CJK>
       (?$BMA(B . "0x8F3F")  ;; <CJK>
       (?$BMB(B . "0x9810")  ;; <CJK>
       (?$BMC(B . "0x50AD")  ;; <CJK>
       (?$BMD(B . "0x5E7C")  ;; <CJK>
       (?$BME(B . "0x5996")  ;; <CJK>
       (?$BMF(B . "0x5BB9")  ;; <CJK>
       (?$BMG(B . "0x5EB8")  ;; <CJK>
       (?$BMH(B . "0x63DA")  ;; <CJK>
       (?$BMI(B . "0x63FA")  ;; <CJK>
       (?$BMJ(B . "0x64C1")  ;; <CJK>
       (?$BMK(B . "0x66DC")  ;; <CJK>
       (?$BML(B . "0x694A")  ;; <CJK>
       (?$BMM(B . "0x69D8")  ;; <CJK>
       (?$BMN(B . "0x6D0B")  ;; <CJK>
       (?$BMO(B . "0x6EB6")  ;; <CJK>
       (?$BMP(B . "0x7194")  ;; <CJK>
       (?$BMQ(B . "0x7528")  ;; <CJK>
       (?$BMR(B . "0x7AAF")  ;; <CJK>
       (?$BMS(B . "0x7F8A")  ;; <CJK>
       (?$BMT(B . "0x8000")  ;; <CJK>
       (?$BMU(B . "0x8449")  ;; <CJK>
       (?$BMV(B . "0x84C9")  ;; <CJK>
       (?$BMW(B . "0x8981")  ;; <CJK>
       (?$BMX(B . "0x8B21")  ;; <CJK>
       (?$BMY(B . "0x8E0A")  ;; <CJK>
       (?$BMZ(B . "0x9065")  ;; <CJK>
       (?$BM[(B . "0x967D")  ;; <CJK>
       (?$BM\(B . "0x990A")  ;; <CJK>
       (?$BM](B . "0x617E")  ;; <CJK>
       (?$BM^(B . "0x6291")  ;; <CJK>
       (?$BM_(B . "0x6B32")  ;; <CJK>
       (?$BM`(B . "0x6C83")  ;; <CJK>
       (?$BMa(B . "0x6D74")  ;; <CJK>
       (?$BMb(B . "0x7FCC")  ;; <CJK>
       (?$BMc(B . "0x7FFC")  ;; <CJK>
       (?$BMd(B . "0x6DC0")  ;; <CJK>
       (?$BMe(B . "0x7F85")  ;; <CJK>
       (?$BMf(B . "0x87BA")  ;; <CJK>
       (?$BMg(B . "0x88F8")  ;; <CJK>
       (?$BMh(B . "0x6765")  ;; <CJK>
       (?$BMi(B . "0x83B1")  ;; <CJK>
       (?$BMj(B . "0x983C")  ;; <CJK>
       (?$BMk(B . "0x96F7")  ;; <CJK>
       (?$BMl(B . "0x6D1B")  ;; <CJK>
       (?$BMm(B . "0x7D61")  ;; <CJK>
       (?$BMn(B . "0x843D")  ;; <CJK>
       (?$BMo(B . "0x916A")  ;; <CJK>
       (?$BMp(B . "0x4E71")  ;; <CJK>
       (?$BMq(B . "0x5375")  ;; <CJK>
       (?$BMr(B . "0x5D50")  ;; <CJK>
       (?$BMs(B . "0x6B04")  ;; <CJK>
       (?$BMt(B . "0x6FEB")  ;; <CJK>
       (?$BMu(B . "0x85CD")  ;; <CJK>
       (?$BMv(B . "0x862D")  ;; <CJK>
       (?$BMw(B . "0x89A7")  ;; <CJK>
       (?$BMx(B . "0x5229")  ;; <CJK>
       (?$BMy(B . "0x540F")  ;; <CJK>
       (?$BMz(B . "0x5C65")  ;; <CJK>
       (?$BM{(B . "0x674E")  ;; <CJK>
       (?$BM|(B . "0x68A8")  ;; <CJK>
       (?$BM}(B . "0x7406")  ;; <CJK>
       (?$BM~(B . "0x7483")  ;; <CJK>
       (?$BN!(B . "0x75E2")  ;; <CJK>
       (?$BN"(B . "0x88CF")  ;; <CJK>
       (?$BN#(B . "0x88E1")  ;; <CJK>
       (?$BN$(B . "0x91CC")  ;; <CJK>
       (?$BN%(B . "0x96E2")  ;; <CJK>
       (?$BN&(B . "0x9678")  ;; <CJK>
       (?$BN'(B . "0x5F8B")  ;; <CJK>
       (?$BN((B . "0x7387")  ;; <CJK>
       (?$BN)(B . "0x7ACB")  ;; <CJK>
       (?$BN*(B . "0x844E")  ;; <CJK>
       (?$BN+(B . "0x63A0")  ;; <CJK>
       (?$BN,(B . "0x7565")  ;; <CJK>
       (?$BN-(B . "0x5289")  ;; <CJK>
       (?$BN.(B . "0x6D41")  ;; <CJK>
       (?$BN/(B . "0x6E9C")  ;; <CJK>
       (?$BN0(B . "0x7409")  ;; <CJK>
       (?$BN1(B . "0x7559")  ;; <CJK>
       (?$BN2(B . "0x786B")  ;; <CJK>
       (?$BN3(B . "0x7C92")  ;; <CJK>
       (?$BN4(B . "0x9686")  ;; <CJK>
       (?$BN5(B . "0x7ADC")  ;; <CJK>
       (?$BN6(B . "0x9F8D")  ;; <CJK>
       (?$BN7(B . "0x4FB6")  ;; <CJK>
       (?$BN8(B . "0x616E")  ;; <CJK>
       (?$BN9(B . "0x65C5")  ;; <CJK>
       (?$BN:(B . "0x865C")  ;; <CJK>
       (?$BN;(B . "0x4E86")  ;; <CJK>
       (?$BN<(B . "0x4EAE")  ;; <CJK>
       (?$BN=(B . "0x50DA")  ;; <CJK>
       (?$BN>(B . "0x4E21")  ;; <CJK>
       (?$BN?(B . "0x51CC")  ;; <CJK>
       (?$BN@(B . "0x5BEE")  ;; <CJK>
       (?$BNA(B . "0x6599")  ;; <CJK>
       (?$BNB(B . "0x6881")  ;; <CJK>
       (?$BNC(B . "0x6DBC")  ;; <CJK>
       (?$BND(B . "0x731F")  ;; <CJK>
       (?$BNE(B . "0x7642")  ;; <CJK>
       (?$BNF(B . "0x77AD")  ;; <CJK>
       (?$BNG(B . "0x7A1C")  ;; <CJK>
       (?$BNH(B . "0x7CE7")  ;; <CJK>
       (?$BNI(B . "0x826F")  ;; <CJK>
       (?$BNJ(B . "0x8AD2")  ;; <CJK>
       (?$BNK(B . "0x907C")  ;; <CJK>
       (?$BNL(B . "0x91CF")  ;; <CJK>
       (?$BNM(B . "0x9675")  ;; <CJK>
       (?$BNN(B . "0x9818")  ;; <CJK>
       (?$BNO(B . "0x529B")  ;; <CJK>
       (?$BNP(B . "0x7DD1")  ;; <CJK>
       (?$BNQ(B . "0x502B")  ;; <CJK>
       (?$BNR(B . "0x5398")  ;; <CJK>
       (?$BNS(B . "0x6797")  ;; <CJK>
       (?$BNT(B . "0x6DCB")  ;; <CJK>
       (?$BNU(B . "0x71D0")  ;; <CJK>
       (?$BNV(B . "0x7433")  ;; <CJK>
       (?$BNW(B . "0x81E8")  ;; <CJK>
       (?$BNX(B . "0x8F2A")  ;; <CJK>
       (?$BNY(B . "0x96A3")  ;; <CJK>
       (?$BNZ(B . "0x9C57")  ;; <CJK>
       (?$BN[(B . "0x9E9F")  ;; <CJK>
       (?$BN\(B . "0x7460")  ;; <CJK>
       (?$BN](B . "0x5841")  ;; <CJK>
       (?$BN^(B . "0x6D99")  ;; <CJK>
       (?$BN_(B . "0x7D2F")  ;; <CJK>
       (?$BN`(B . "0x985E")  ;; <CJK>
       (?$BNa(B . "0x4EE4")  ;; <CJK>
       (?$BNb(B . "0x4F36")  ;; <CJK>
       (?$BNc(B . "0x4F8B")  ;; <CJK>
       (?$BNd(B . "0x51B7")  ;; <CJK>
       (?$BNe(B . "0x52B1")  ;; <CJK>
       (?$BNf(B . "0x5DBA")  ;; <CJK>
       (?$BNg(B . "0x601C")  ;; <CJK>
       (?$BNh(B . "0x73B2")  ;; <CJK>
       (?$BNi(B . "0x793C")  ;; <CJK>
       (?$BNj(B . "0x82D3")  ;; <CJK>
       (?$BNk(B . "0x9234")  ;; <CJK>
       (?$BNl(B . "0x96B7")  ;; <CJK>
       (?$BNm(B . "0x96F6")  ;; <CJK>
       (?$BNn(B . "0x970A")  ;; <CJK>
       (?$BNo(B . "0x9E97")  ;; <CJK>
       (?$BNp(B . "0x9F62")  ;; <CJK>
       (?$BNq(B . "0x66A6")  ;; <CJK>
       (?$BNr(B . "0x6B74")  ;; <CJK>
       (?$BNs(B . "0x5217")  ;; <CJK>
       (?$BNt(B . "0x52A3")  ;; <CJK>
       (?$BNu(B . "0x70C8")  ;; <CJK>
       (?$BNv(B . "0x88C2")  ;; <CJK>
       (?$BNw(B . "0x5EC9")  ;; <CJK>
       (?$BNx(B . "0x604B")  ;; <CJK>
       (?$BNy(B . "0x6190")  ;; <CJK>
       (?$BNz(B . "0x6F23")  ;; <CJK>
       (?$BN{(B . "0x7149")  ;; <CJK>
       (?$BN|(B . "0x7C3E")  ;; <CJK>
       (?$BN}(B . "0x7DF4")  ;; <CJK>
       (?$BN~(B . "0x806F")  ;; <CJK>
       (?$BO!(B . "0x84EE")  ;; <CJK>
       (?$BO"(B . "0x9023")  ;; <CJK>
       (?$BO#(B . "0x932C")  ;; <CJK>
       (?$BO$(B . "0x5442")  ;; <CJK>
       (?$BO%(B . "0x9B6F")  ;; <CJK>
       (?$BO&(B . "0x6AD3")  ;; <CJK>
       (?$BO'(B . "0x7089")  ;; <CJK>
       (?$BO((B . "0x8CC2")  ;; <CJK>
       (?$BO)(B . "0x8DEF")  ;; <CJK>
       (?$BO*(B . "0x9732")  ;; <CJK>
       (?$BO+(B . "0x52B4")  ;; <CJK>
       (?$BO,(B . "0x5A41")  ;; <CJK>
       (?$BO-(B . "0x5ECA")  ;; <CJK>
       (?$BO.(B . "0x5F04")  ;; <CJK>
       (?$BO/(B . "0x6717")  ;; <CJK>
       (?$BO0(B . "0x697C")  ;; <CJK>
       (?$BO1(B . "0x6994")  ;; <CJK>
       (?$BO2(B . "0x6D6A")  ;; <CJK>
       (?$BO3(B . "0x6F0F")  ;; <CJK>
       (?$BO4(B . "0x7262")  ;; <CJK>
       (?$BO5(B . "0x72FC")  ;; <CJK>
       (?$BO6(B . "0x7BED")  ;; <CJK>
       (?$BO7(B . "0x8001")  ;; <CJK>
       (?$BO8(B . "0x807E")  ;; <CJK>
       (?$BO9(B . "0x874B")  ;; <CJK>
       (?$BO:(B . "0x90CE")  ;; <CJK>
       (?$BO;(B . "0x516D")  ;; <CJK>
       (?$BO<(B . "0x9E93")  ;; <CJK>
       (?$BO=(B . "0x7984")  ;; <CJK>
       (?$BO>(B . "0x808B")  ;; <CJK>
       (?$BO?(B . "0x9332")  ;; <CJK>
       (?$BO@(B . "0x8AD6")  ;; <CJK>
       (?$BOA(B . "0x502D")  ;; <CJK>
       (?$BOB(B . "0x548C")  ;; <CJK>
       (?$BOC(B . "0x8A71")  ;; <CJK>
       (?$BOD(B . "0x6B6A")  ;; <CJK>
       (?$BOE(B . "0x8CC4")  ;; <CJK>
       (?$BOF(B . "0x8107")  ;; <CJK>
       (?$BOG(B . "0x60D1")  ;; <CJK>
       (?$BOH(B . "0x67A0")  ;; <CJK>
       (?$BOI(B . "0x9DF2")  ;; <CJK>
       (?$BOJ(B . "0x4E99")  ;; <CJK>
       (?$BOK(B . "0x4E98")  ;; <CJK>
       (?$BOL(B . "0x9C10")  ;; <CJK>
       (?$BOM(B . "0x8A6B")  ;; <CJK>
       (?$BON(B . "0x85C1")  ;; <CJK>
       (?$BOO(B . "0x8568")  ;; <CJK>
       (?$BOP(B . "0x6900")  ;; <CJK>
       (?$BOQ(B . "0x6E7E")  ;; <CJK>
       (?$BOR(B . "0x7897")  ;; <CJK>
       (?$BOS(B . "0x8155")  ;; <CJK>
       (?$BP!(B . "0x5F0C")  ;; <CJK>
       (?$BP"(B . "0x4E10")  ;; <CJK>
       (?$BP#(B . "0x4E15")  ;; <CJK>
       (?$BP$(B . "0x4E2A")  ;; <CJK>
       (?$BP%(B . "0x4E31")  ;; <CJK>
       (?$BP&(B . "0x4E36")  ;; <CJK>
       (?$BP'(B . "0x4E3C")  ;; <CJK>
       (?$BP((B . "0x4E3F")  ;; <CJK>
       (?$BP)(B . "0x4E42")  ;; <CJK>
       (?$BP*(B . "0x4E56")  ;; <CJK>
       (?$BP+(B . "0x4E58")  ;; <CJK>
       (?$BP,(B . "0x4E82")  ;; <CJK>
       (?$BP-(B . "0x4E85")  ;; <CJK>
       (?$BP.(B . "0x8C6B")  ;; <CJK>
       (?$BP/(B . "0x4E8A")  ;; <CJK>
       (?$BP0(B . "0x8212")  ;; <CJK>
       (?$BP1(B . "0x5F0D")  ;; <CJK>
       (?$BP2(B . "0x4E8E")  ;; <CJK>
       (?$BP3(B . "0x4E9E")  ;; <CJK>
       (?$BP4(B . "0x4E9F")  ;; <CJK>
       (?$BP5(B . "0x4EA0")  ;; <CJK>
       (?$BP6(B . "0x4EA2")  ;; <CJK>
       (?$BP7(B . "0x4EB0")  ;; <CJK>
       (?$BP8(B . "0x4EB3")  ;; <CJK>
       (?$BP9(B . "0x4EB6")  ;; <CJK>
       (?$BP:(B . "0x4ECE")  ;; <CJK>
       (?$BP;(B . "0x4ECD")  ;; <CJK>
       (?$BP<(B . "0x4EC4")  ;; <CJK>
       (?$BP=(B . "0x4EC6")  ;; <CJK>
       (?$BP>(B . "0x4EC2")  ;; <CJK>
       (?$BP?(B . "0x4ED7")  ;; <CJK>
       (?$BP@(B . "0x4EDE")  ;; <CJK>
       (?$BPA(B . "0x4EED")  ;; <CJK>
       (?$BPB(B . "0x4EDF")  ;; <CJK>
       (?$BPC(B . "0x4EF7")  ;; <CJK>
       (?$BPD(B . "0x4F09")  ;; <CJK>
       (?$BPE(B . "0x4F5A")  ;; <CJK>
       (?$BPF(B . "0x4F30")  ;; <CJK>
       (?$BPG(B . "0x4F5B")  ;; <CJK>
       (?$BPH(B . "0x4F5D")  ;; <CJK>
       (?$BPI(B . "0x4F57")  ;; <CJK>
       (?$BPJ(B . "0x4F47")  ;; <CJK>
       (?$BPK(B . "0x4F76")  ;; <CJK>
       (?$BPL(B . "0x4F88")  ;; <CJK>
       (?$BPM(B . "0x4F8F")  ;; <CJK>
       (?$BPN(B . "0x4F98")  ;; <CJK>
       (?$BPO(B . "0x4F7B")  ;; <CJK>
       (?$BPP(B . "0x4F69")  ;; <CJK>
       (?$BPQ(B . "0x4F70")  ;; <CJK>
       (?$BPR(B . "0x4F91")  ;; <CJK>
       (?$BPS(B . "0x4F6F")  ;; <CJK>
       (?$BPT(B . "0x4F86")  ;; <CJK>
       (?$BPU(B . "0x4F96")  ;; <CJK>
       (?$BPV(B . "0x5118")  ;; <CJK>
       (?$BPW(B . "0x4FD4")  ;; <CJK>
       (?$BPX(B . "0x4FDF")  ;; <CJK>
       (?$BPY(B . "0x4FCE")  ;; <CJK>
       (?$BPZ(B . "0x4FD8")  ;; <CJK>
       (?$BP[(B . "0x4FDB")  ;; <CJK>
       (?$BP\(B . "0x4FD1")  ;; <CJK>
       (?$BP](B . "0x4FDA")  ;; <CJK>
       (?$BP^(B . "0x4FD0")  ;; <CJK>
       (?$BP_(B . "0x4FE4")  ;; <CJK>
       (?$BP`(B . "0x4FE5")  ;; <CJK>
       (?$BPa(B . "0x501A")  ;; <CJK>
       (?$BPb(B . "0x5028")  ;; <CJK>
       (?$BPc(B . "0x5014")  ;; <CJK>
       (?$BPd(B . "0x502A")  ;; <CJK>
       (?$BPe(B . "0x5025")  ;; <CJK>
       (?$BPf(B . "0x5005")  ;; <CJK>
       (?$BPg(B . "0x4F1C")  ;; <CJK>
       (?$BPh(B . "0x4FF6")  ;; <CJK>
       (?$BPi(B . "0x5021")  ;; <CJK>
       (?$BPj(B . "0x5029")  ;; <CJK>
       (?$BPk(B . "0x502C")  ;; <CJK>
       (?$BPl(B . "0x4FFE")  ;; <CJK>
       (?$BPm(B . "0x4FEF")  ;; <CJK>
       (?$BPn(B . "0x5011")  ;; <CJK>
       (?$BPo(B . "0x5006")  ;; <CJK>
       (?$BPp(B . "0x5043")  ;; <CJK>
       (?$BPq(B . "0x5047")  ;; <CJK>
       (?$BPr(B . "0x6703")  ;; <CJK>
       (?$BPs(B . "0x5055")  ;; <CJK>
       (?$BPt(B . "0x5050")  ;; <CJK>
       (?$BPu(B . "0x5048")  ;; <CJK>
       (?$BPv(B . "0x505A")  ;; <CJK>
       (?$BPw(B . "0x5056")  ;; <CJK>
       (?$BPx(B . "0x506C")  ;; <CJK>
       (?$BPy(B . "0x5078")  ;; <CJK>
       (?$BPz(B . "0x5080")  ;; <CJK>
       (?$BP{(B . "0x509A")  ;; <CJK>
       (?$BP|(B . "0x5085")  ;; <CJK>
       (?$BP}(B . "0x50B4")  ;; <CJK>
       (?$BP~(B . "0x50B2")  ;; <CJK>
       (?$BQ!(B . "0x50C9")  ;; <CJK>
       (?$BQ"(B . "0x50CA")  ;; <CJK>
       (?$BQ#(B . "0x50B3")  ;; <CJK>
       (?$BQ$(B . "0x50C2")  ;; <CJK>
       (?$BQ%(B . "0x50D6")  ;; <CJK>
       (?$BQ&(B . "0x50DE")  ;; <CJK>
       (?$BQ'(B . "0x50E5")  ;; <CJK>
       (?$BQ((B . "0x50ED")  ;; <CJK>
       (?$BQ)(B . "0x50E3")  ;; <CJK>
       (?$BQ*(B . "0x50EE")  ;; <CJK>
       (?$BQ+(B . "0x50F9")  ;; <CJK>
       (?$BQ,(B . "0x50F5")  ;; <CJK>
       (?$BQ-(B . "0x5109")  ;; <CJK>
       (?$BQ.(B . "0x5101")  ;; <CJK>
       (?$BQ/(B . "0x5102")  ;; <CJK>
       (?$BQ0(B . "0x5116")  ;; <CJK>
       (?$BQ1(B . "0x5115")  ;; <CJK>
       (?$BQ2(B . "0x5114")  ;; <CJK>
       (?$BQ3(B . "0x511A")  ;; <CJK>
       (?$BQ4(B . "0x5121")  ;; <CJK>
       (?$BQ5(B . "0x513A")  ;; <CJK>
       (?$BQ6(B . "0x5137")  ;; <CJK>
       (?$BQ7(B . "0x513C")  ;; <CJK>
       (?$BQ8(B . "0x513B")  ;; <CJK>
       (?$BQ9(B . "0x513F")  ;; <CJK>
       (?$BQ:(B . "0x5140")  ;; <CJK>
       (?$BQ;(B . "0x5152")  ;; <CJK>
       (?$BQ<(B . "0x514C")  ;; <CJK>
       (?$BQ=(B . "0x5154")  ;; <CJK>
       (?$BQ>(B . "0x5162")  ;; <CJK>
       (?$BQ?(B . "0x7AF8")  ;; <CJK>
       (?$BQ@(B . "0x5169")  ;; <CJK>
       (?$BQA(B . "0x516A")  ;; <CJK>
       (?$BQB(B . "0x516E")  ;; <CJK>
       (?$BQC(B . "0x5180")  ;; <CJK>
       (?$BQD(B . "0x5182")  ;; <CJK>
       (?$BQE(B . "0x56D8")  ;; <CJK>
       (?$BQF(B . "0x518C")  ;; <CJK>
       (?$BQG(B . "0x5189")  ;; <CJK>
       (?$BQH(B . "0x518F")  ;; <CJK>
       (?$BQI(B . "0x5191")  ;; <CJK>
       (?$BQJ(B . "0x5193")  ;; <CJK>
       (?$BQK(B . "0x5195")  ;; <CJK>
       (?$BQL(B . "0x5196")  ;; <CJK>
       (?$BQM(B . "0x51A4")  ;; <CJK>
       (?$BQN(B . "0x51A6")  ;; <CJK>
       (?$BQO(B . "0x51A2")  ;; <CJK>
       (?$BQP(B . "0x51A9")  ;; <CJK>
       (?$BQQ(B . "0x51AA")  ;; <CJK>
       (?$BQR(B . "0x51AB")  ;; <CJK>
       (?$BQS(B . "0x51B3")  ;; <CJK>
       (?$BQT(B . "0x51B1")  ;; <CJK>
       (?$BQU(B . "0x51B2")  ;; <CJK>
       (?$BQV(B . "0x51B0")  ;; <CJK>
       (?$BQW(B . "0x51B5")  ;; <CJK>
       (?$BQX(B . "0x51BD")  ;; <CJK>
       (?$BQY(B . "0x51C5")  ;; <CJK>
       (?$BQZ(B . "0x51C9")  ;; <CJK>
       (?$BQ[(B . "0x51DB")  ;; <CJK>
       (?$BQ\(B . "0x51E0")  ;; <CJK>
       (?$BQ](B . "0x8655")  ;; <CJK>
       (?$BQ^(B . "0x51E9")  ;; <CJK>
       (?$BQ_(B . "0x51ED")  ;; <CJK>
       (?$BQ`(B . "0x51F0")  ;; <CJK>
       (?$BQa(B . "0x51F5")  ;; <CJK>
       (?$BQb(B . "0x51FE")  ;; <CJK>
       (?$BQc(B . "0x5204")  ;; <CJK>
       (?$BQd(B . "0x520B")  ;; <CJK>
       (?$BQe(B . "0x5214")  ;; <CJK>
       (?$BQf(B . "0x520E")  ;; <CJK>
       (?$BQg(B . "0x5227")  ;; <CJK>
       (?$BQh(B . "0x522A")  ;; <CJK>
       (?$BQi(B . "0x522E")  ;; <CJK>
       (?$BQj(B . "0x5233")  ;; <CJK>
       (?$BQk(B . "0x5239")  ;; <CJK>
       (?$BQl(B . "0x524F")  ;; <CJK>
       (?$BQm(B . "0x5244")  ;; <CJK>
       (?$BQn(B . "0x524B")  ;; <CJK>
       (?$BQo(B . "0x524C")  ;; <CJK>
       (?$BQp(B . "0x525E")  ;; <CJK>
       (?$BQq(B . "0x5254")  ;; <CJK>
       (?$BQr(B . "0x526A")  ;; <CJK>
       (?$BQs(B . "0x5274")  ;; <CJK>
       (?$BQt(B . "0x5269")  ;; <CJK>
       (?$BQu(B . "0x5273")  ;; <CJK>
       (?$BQv(B . "0x527F")  ;; <CJK>
       (?$BQw(B . "0x527D")  ;; <CJK>
       (?$BQx(B . "0x528D")  ;; <CJK>
       (?$BQy(B . "0x5294")  ;; <CJK>
       (?$BQz(B . "0x5292")  ;; <CJK>
       (?$BQ{(B . "0x5271")  ;; <CJK>
       (?$BQ|(B . "0x5288")  ;; <CJK>
       (?$BQ}(B . "0x5291")  ;; <CJK>
       (?$BQ~(B . "0x8FA8")  ;; <CJK>
       (?$BR!(B . "0x8FA7")  ;; <CJK>
       (?$BR"(B . "0x52AC")  ;; <CJK>
       (?$BR#(B . "0x52AD")  ;; <CJK>
       (?$BR$(B . "0x52BC")  ;; <CJK>
       (?$BR%(B . "0x52B5")  ;; <CJK>
       (?$BR&(B . "0x52C1")  ;; <CJK>
       (?$BR'(B . "0x52CD")  ;; <CJK>
       (?$BR((B . "0x52D7")  ;; <CJK>
       (?$BR)(B . "0x52DE")  ;; <CJK>
       (?$BR*(B . "0x52E3")  ;; <CJK>
       (?$BR+(B . "0x52E6")  ;; <CJK>
       (?$BR,(B . "0x98ED")  ;; <CJK>
       (?$BR-(B . "0x52E0")  ;; <CJK>
       (?$BR.(B . "0x52F3")  ;; <CJK>
       (?$BR/(B . "0x52F5")  ;; <CJK>
       (?$BR0(B . "0x52F8")  ;; <CJK>
       (?$BR1(B . "0x52F9")  ;; <CJK>
       (?$BR2(B . "0x5306")  ;; <CJK>
       (?$BR3(B . "0x5308")  ;; <CJK>
       (?$BR4(B . "0x7538")  ;; <CJK>
       (?$BR5(B . "0x530D")  ;; <CJK>
       (?$BR6(B . "0x5310")  ;; <CJK>
       (?$BR7(B . "0x530F")  ;; <CJK>
       (?$BR8(B . "0x5315")  ;; <CJK>
       (?$BR9(B . "0x531A")  ;; <CJK>
       (?$BR:(B . "0x5323")  ;; <CJK>
       (?$BR;(B . "0x532F")  ;; <CJK>
       (?$BR<(B . "0x5331")  ;; <CJK>
       (?$BR=(B . "0x5333")  ;; <CJK>
       (?$BR>(B . "0x5338")  ;; <CJK>
       (?$BR?(B . "0x5340")  ;; <CJK>
       (?$BR@(B . "0x5346")  ;; <CJK>
       (?$BRA(B . "0x5345")  ;; <CJK>
       (?$BRB(B . "0x4E17")  ;; <CJK>
       (?$BRC(B . "0x5349")  ;; <CJK>
       (?$BRD(B . "0x534D")  ;; <CJK>
       (?$BRE(B . "0x51D6")  ;; <CJK>
       (?$BRF(B . "0x535E")  ;; <CJK>
       (?$BRG(B . "0x5369")  ;; <CJK>
       (?$BRH(B . "0x536E")  ;; <CJK>
       (?$BRI(B . "0x5918")  ;; <CJK>
       (?$BRJ(B . "0x537B")  ;; <CJK>
       (?$BRK(B . "0x5377")  ;; <CJK>
       (?$BRL(B . "0x5382")  ;; <CJK>
       (?$BRM(B . "0x5396")  ;; <CJK>
       (?$BRN(B . "0x53A0")  ;; <CJK>
       (?$BRO(B . "0x53A6")  ;; <CJK>
       (?$BRP(B . "0x53A5")  ;; <CJK>
       (?$BRQ(B . "0x53AE")  ;; <CJK>
       (?$BRR(B . "0x53B0")  ;; <CJK>
       (?$BRS(B . "0x53B6")  ;; <CJK>
       (?$BRT(B . "0x53C3")  ;; <CJK>
       (?$BRU(B . "0x7C12")  ;; <CJK>
       (?$BRV(B . "0x96D9")  ;; <CJK>
       (?$BRW(B . "0x53DF")  ;; <CJK>
       (?$BRX(B . "0x66FC")  ;; <CJK>
       (?$BRY(B . "0x71EE")  ;; <CJK>
       (?$BRZ(B . "0x53EE")  ;; <CJK>
       (?$BR[(B . "0x53E8")  ;; <CJK>
       (?$BR\(B . "0x53ED")  ;; <CJK>
       (?$BR](B . "0x53FA")  ;; <CJK>
       (?$BR^(B . "0x5401")  ;; <CJK>
       (?$BR_(B . "0x543D")  ;; <CJK>
       (?$BR`(B . "0x5440")  ;; <CJK>
       (?$BRa(B . "0x542C")  ;; <CJK>
       (?$BRb(B . "0x542D")  ;; <CJK>
       (?$BRc(B . "0x543C")  ;; <CJK>
       (?$BRd(B . "0x542E")  ;; <CJK>
       (?$BRe(B . "0x5436")  ;; <CJK>
       (?$BRf(B . "0x5429")  ;; <CJK>
       (?$BRg(B . "0x541D")  ;; <CJK>
       (?$BRh(B . "0x544E")  ;; <CJK>
       (?$BRi(B . "0x548F")  ;; <CJK>
       (?$BRj(B . "0x5475")  ;; <CJK>
       (?$BRk(B . "0x548E")  ;; <CJK>
       (?$BRl(B . "0x545F")  ;; <CJK>
       (?$BRm(B . "0x5471")  ;; <CJK>
       (?$BRn(B . "0x5477")  ;; <CJK>
       (?$BRo(B . "0x5470")  ;; <CJK>
       (?$BRp(B . "0x5492")  ;; <CJK>
       (?$BRq(B . "0x547B")  ;; <CJK>
       (?$BRr(B . "0x5480")  ;; <CJK>
       (?$BRs(B . "0x5476")  ;; <CJK>
       (?$BRt(B . "0x5484")  ;; <CJK>
       (?$BRu(B . "0x5490")  ;; <CJK>
       (?$BRv(B . "0x5486")  ;; <CJK>
       (?$BRw(B . "0x54C7")  ;; <CJK>
       (?$BRx(B . "0x54A2")  ;; <CJK>
       (?$BRy(B . "0x54B8")  ;; <CJK>
       (?$BRz(B . "0x54A5")  ;; <CJK>
       (?$BR{(B . "0x54AC")  ;; <CJK>
       (?$BR|(B . "0x54C4")  ;; <CJK>
       (?$BR}(B . "0x54C8")  ;; <CJK>
       (?$BR~(B . "0x54A8")  ;; <CJK>
       (?$BS!(B . "0x54AB")  ;; <CJK>
       (?$BS"(B . "0x54C2")  ;; <CJK>
       (?$BS#(B . "0x54A4")  ;; <CJK>
       (?$BS$(B . "0x54BE")  ;; <CJK>
       (?$BS%(B . "0x54BC")  ;; <CJK>
       (?$BS&(B . "0x54D8")  ;; <CJK>
       (?$BS'(B . "0x54E5")  ;; <CJK>
       (?$BS((B . "0x54E6")  ;; <CJK>
       (?$BS)(B . "0x550F")  ;; <CJK>
       (?$BS*(B . "0x5514")  ;; <CJK>
       (?$BS+(B . "0x54FD")  ;; <CJK>
       (?$BS,(B . "0x54EE")  ;; <CJK>
       (?$BS-(B . "0x54ED")  ;; <CJK>
       (?$BS.(B . "0x54FA")  ;; <CJK>
       (?$BS/(B . "0x54E2")  ;; <CJK>
       (?$BS0(B . "0x5539")  ;; <CJK>
       (?$BS1(B . "0x5540")  ;; <CJK>
       (?$BS2(B . "0x5563")  ;; <CJK>
       (?$BS3(B . "0x554C")  ;; <CJK>
       (?$BS4(B . "0x552E")  ;; <CJK>
       (?$BS5(B . "0x555C")  ;; <CJK>
       (?$BS6(B . "0x5545")  ;; <CJK>
       (?$BS7(B . "0x5556")  ;; <CJK>
       (?$BS8(B . "0x5557")  ;; <CJK>
       (?$BS9(B . "0x5538")  ;; <CJK>
       (?$BS:(B . "0x5533")  ;; <CJK>
       (?$BS;(B . "0x555D")  ;; <CJK>
       (?$BS<(B . "0x5599")  ;; <CJK>
       (?$BS=(B . "0x5580")  ;; <CJK>
       (?$BS>(B . "0x54AF")  ;; <CJK>
       (?$BS?(B . "0x558A")  ;; <CJK>
       (?$BS@(B . "0x559F")  ;; <CJK>
       (?$BSA(B . "0x557B")  ;; <CJK>
       (?$BSB(B . "0x557E")  ;; <CJK>
       (?$BSC(B . "0x5598")  ;; <CJK>
       (?$BSD(B . "0x559E")  ;; <CJK>
       (?$BSE(B . "0x55AE")  ;; <CJK>
       (?$BSF(B . "0x557C")  ;; <CJK>
       (?$BSG(B . "0x5583")  ;; <CJK>
       (?$BSH(B . "0x55A9")  ;; <CJK>
       (?$BSI(B . "0x5587")  ;; <CJK>
       (?$BSJ(B . "0x55A8")  ;; <CJK>
       (?$BSK(B . "0x55DA")  ;; <CJK>
       (?$BSL(B . "0x55C5")  ;; <CJK>
       (?$BSM(B . "0x55DF")  ;; <CJK>
       (?$BSN(B . "0x55C4")  ;; <CJK>
       (?$BSO(B . "0x55DC")  ;; <CJK>
       (?$BSP(B . "0x55E4")  ;; <CJK>
       (?$BSQ(B . "0x55D4")  ;; <CJK>
       (?$BSR(B . "0x5614")  ;; <CJK>
       (?$BSS(B . "0x55F7")  ;; <CJK>
       (?$BST(B . "0x5616")  ;; <CJK>
       (?$BSU(B . "0x55FE")  ;; <CJK>
       (?$BSV(B . "0x55FD")  ;; <CJK>
       (?$BSW(B . "0x561B")  ;; <CJK>
       (?$BSX(B . "0x55F9")  ;; <CJK>
       (?$BSY(B . "0x564E")  ;; <CJK>
       (?$BSZ(B . "0x5650")  ;; <CJK>
       (?$BS[(B . "0x71DF")  ;; <CJK>
       (?$BS\(B . "0x5634")  ;; <CJK>
       (?$BS](B . "0x5636")  ;; <CJK>
       (?$BS^(B . "0x5632")  ;; <CJK>
       (?$BS_(B . "0x5638")  ;; <CJK>
       (?$BS`(B . "0x566B")  ;; <CJK>
       (?$BSa(B . "0x5664")  ;; <CJK>
       (?$BSb(B . "0x562F")  ;; <CJK>
       (?$BSc(B . "0x566C")  ;; <CJK>
       (?$BSd(B . "0x566A")  ;; <CJK>
       (?$BSe(B . "0x5686")  ;; <CJK>
       (?$BSf(B . "0x5680")  ;; <CJK>
       (?$BSg(B . "0x568A")  ;; <CJK>
       (?$BSh(B . "0x56A0")  ;; <CJK>
       (?$BSi(B . "0x5694")  ;; <CJK>
       (?$BSj(B . "0x568F")  ;; <CJK>
       (?$BSk(B . "0x56A5")  ;; <CJK>
       (?$BSl(B . "0x56AE")  ;; <CJK>
       (?$BSm(B . "0x56B6")  ;; <CJK>
       (?$BSn(B . "0x56B4")  ;; <CJK>
       (?$BSo(B . "0x56C2")  ;; <CJK>
       (?$BSp(B . "0x56BC")  ;; <CJK>
       (?$BSq(B . "0x56C1")  ;; <CJK>
       (?$BSr(B . "0x56C3")  ;; <CJK>
       (?$BSs(B . "0x56C0")  ;; <CJK>
       (?$BSt(B . "0x56C8")  ;; <CJK>
       (?$BSu(B . "0x56CE")  ;; <CJK>
       (?$BSv(B . "0x56D1")  ;; <CJK>
       (?$BSw(B . "0x56D3")  ;; <CJK>
       (?$BSx(B . "0x56D7")  ;; <CJK>
       (?$BSy(B . "0x56EE")  ;; <CJK>
       (?$BSz(B . "0x56F9")  ;; <CJK>
       (?$BS{(B . "0x5700")  ;; <CJK>
       (?$BS|(B . "0x56FF")  ;; <CJK>
       (?$BS}(B . "0x5704")  ;; <CJK>
       (?$BS~(B . "0x5709")  ;; <CJK>
       (?$BT!(B . "0x5708")  ;; <CJK>
       (?$BT"(B . "0x570B")  ;; <CJK>
       (?$BT#(B . "0x570D")  ;; <CJK>
       (?$BT$(B . "0x5713")  ;; <CJK>
       (?$BT%(B . "0x5718")  ;; <CJK>
       (?$BT&(B . "0x5716")  ;; <CJK>
       (?$BT'(B . "0x55C7")  ;; <CJK>
       (?$BT((B . "0x571C")  ;; <CJK>
       (?$BT)(B . "0x5726")  ;; <CJK>
       (?$BT*(B . "0x5737")  ;; <CJK>
       (?$BT+(B . "0x5738")  ;; <CJK>
       (?$BT,(B . "0x574E")  ;; <CJK>
       (?$BT-(B . "0x573B")  ;; <CJK>
       (?$BT.(B . "0x5740")  ;; <CJK>
       (?$BT/(B . "0x574F")  ;; <CJK>
       (?$BT0(B . "0x5769")  ;; <CJK>
       (?$BT1(B . "0x57C0")  ;; <CJK>
       (?$BT2(B . "0x5788")  ;; <CJK>
       (?$BT3(B . "0x5761")  ;; <CJK>
       (?$BT4(B . "0x577F")  ;; <CJK>
       (?$BT5(B . "0x5789")  ;; <CJK>
       (?$BT6(B . "0x5793")  ;; <CJK>
       (?$BT7(B . "0x57A0")  ;; <CJK>
       (?$BT8(B . "0x57B3")  ;; <CJK>
       (?$BT9(B . "0x57A4")  ;; <CJK>
       (?$BT:(B . "0x57AA")  ;; <CJK>
       (?$BT;(B . "0x57B0")  ;; <CJK>
       (?$BT<(B . "0x57C3")  ;; <CJK>
       (?$BT=(B . "0x57C6")  ;; <CJK>
       (?$BT>(B . "0x57D4")  ;; <CJK>
       (?$BT?(B . "0x57D2")  ;; <CJK>
       (?$BT@(B . "0x57D3")  ;; <CJK>
       (?$BTA(B . "0x580A")  ;; <CJK>
       (?$BTB(B . "0x57D6")  ;; <CJK>
       (?$BTC(B . "0x57E3")  ;; <CJK>
       (?$BTD(B . "0x580B")  ;; <CJK>
       (?$BTE(B . "0x5819")  ;; <CJK>
       (?$BTF(B . "0x581D")  ;; <CJK>
       (?$BTG(B . "0x5872")  ;; <CJK>
       (?$BTH(B . "0x5821")  ;; <CJK>
       (?$BTI(B . "0x5862")  ;; <CJK>
       (?$BTJ(B . "0x584B")  ;; <CJK>
       (?$BTK(B . "0x5870")  ;; <CJK>
       (?$BTL(B . "0x6BC0")  ;; <CJK>
       (?$BTM(B . "0x5852")  ;; <CJK>
       (?$BTN(B . "0x583D")  ;; <CJK>
       (?$BTO(B . "0x5879")  ;; <CJK>
       (?$BTP(B . "0x5885")  ;; <CJK>
       (?$BTQ(B . "0x58B9")  ;; <CJK>
       (?$BTR(B . "0x589F")  ;; <CJK>
       (?$BTS(B . "0x58AB")  ;; <CJK>
       (?$BTT(B . "0x58BA")  ;; <CJK>
       (?$BTU(B . "0x58DE")  ;; <CJK>
       (?$BTV(B . "0x58BB")  ;; <CJK>
       (?$BTW(B . "0x58B8")  ;; <CJK>
       (?$BTX(B . "0x58AE")  ;; <CJK>
       (?$BTY(B . "0x58C5")  ;; <CJK>
       (?$BTZ(B . "0x58D3")  ;; <CJK>
       (?$BT[(B . "0x58D1")  ;; <CJK>
       (?$BT\(B . "0x58D7")  ;; <CJK>
       (?$BT](B . "0x58D9")  ;; <CJK>
       (?$BT^(B . "0x58D8")  ;; <CJK>
       (?$BT_(B . "0x58E5")  ;; <CJK>
       (?$BT`(B . "0x58DC")  ;; <CJK>
       (?$BTa(B . "0x58E4")  ;; <CJK>
       (?$BTb(B . "0x58DF")  ;; <CJK>
       (?$BTc(B . "0x58EF")  ;; <CJK>
       (?$BTd(B . "0x58FA")  ;; <CJK>
       (?$BTe(B . "0x58F9")  ;; <CJK>
       (?$BTf(B . "0x58FB")  ;; <CJK>
       (?$BTg(B . "0x58FC")  ;; <CJK>
       (?$BTh(B . "0x58FD")  ;; <CJK>
       (?$BTi(B . "0x5902")  ;; <CJK>
       (?$BTj(B . "0x590A")  ;; <CJK>
       (?$BTk(B . "0x5910")  ;; <CJK>
       (?$BTl(B . "0x591B")  ;; <CJK>
       (?$BTm(B . "0x68A6")  ;; <CJK>
       (?$BTn(B . "0x5925")  ;; <CJK>
       (?$BTo(B . "0x592C")  ;; <CJK>
       (?$BTp(B . "0x592D")  ;; <CJK>
       (?$BTq(B . "0x5932")  ;; <CJK>
       (?$BTr(B . "0x5938")  ;; <CJK>
       (?$BTs(B . "0x593E")  ;; <CJK>
       (?$BTt(B . "0x7AD2")  ;; <CJK>
       (?$BTu(B . "0x5955")  ;; <CJK>
       (?$BTv(B . "0x5950")  ;; <CJK>
       (?$BTw(B . "0x594E")  ;; <CJK>
       (?$BTx(B . "0x595A")  ;; <CJK>
       (?$BTy(B . "0x5958")  ;; <CJK>
       (?$BTz(B . "0x5962")  ;; <CJK>
       (?$BT{(B . "0x5960")  ;; <CJK>
       (?$BT|(B . "0x5967")  ;; <CJK>
       (?$BT}(B . "0x596C")  ;; <CJK>
       (?$BT~(B . "0x5969")  ;; <CJK>
       (?$BU!(B . "0x5978")  ;; <CJK>
       (?$BU"(B . "0x5981")  ;; <CJK>
       (?$BU#(B . "0x599D")  ;; <CJK>
       (?$BU$(B . "0x4F5E")  ;; <CJK>
       (?$BU%(B . "0x4FAB")  ;; <CJK>
       (?$BU&(B . "0x59A3")  ;; <CJK>
       (?$BU'(B . "0x59B2")  ;; <CJK>
       (?$BU((B . "0x59C6")  ;; <CJK>
       (?$BU)(B . "0x59E8")  ;; <CJK>
       (?$BU*(B . "0x59DC")  ;; <CJK>
       (?$BU+(B . "0x598D")  ;; <CJK>
       (?$BU,(B . "0x59D9")  ;; <CJK>
       (?$BU-(B . "0x59DA")  ;; <CJK>
       (?$BU.(B . "0x5A25")  ;; <CJK>
       (?$BU/(B . "0x5A1F")  ;; <CJK>
       (?$BU0(B . "0x5A11")  ;; <CJK>
       (?$BU1(B . "0x5A1C")  ;; <CJK>
       (?$BU2(B . "0x5A09")  ;; <CJK>
       (?$BU3(B . "0x5A1A")  ;; <CJK>
       (?$BU4(B . "0x5A40")  ;; <CJK>
       (?$BU5(B . "0x5A6C")  ;; <CJK>
       (?$BU6(B . "0x5A49")  ;; <CJK>
       (?$BU7(B . "0x5A35")  ;; <CJK>
       (?$BU8(B . "0x5A36")  ;; <CJK>
       (?$BU9(B . "0x5A62")  ;; <CJK>
       (?$BU:(B . "0x5A6A")  ;; <CJK>
       (?$BU;(B . "0x5A9A")  ;; <CJK>
       (?$BU<(B . "0x5ABC")  ;; <CJK>
       (?$BU=(B . "0x5ABE")  ;; <CJK>
       (?$BU>(B . "0x5ACB")  ;; <CJK>
       (?$BU?(B . "0x5AC2")  ;; <CJK>
       (?$BU@(B . "0x5ABD")  ;; <CJK>
       (?$BUA(B . "0x5AE3")  ;; <CJK>
       (?$BUB(B . "0x5AD7")  ;; <CJK>
       (?$BUC(B . "0x5AE6")  ;; <CJK>
       (?$BUD(B . "0x5AE9")  ;; <CJK>
       (?$BUE(B . "0x5AD6")  ;; <CJK>
       (?$BUF(B . "0x5AFA")  ;; <CJK>
       (?$BUG(B . "0x5AFB")  ;; <CJK>
       (?$BUH(B . "0x5B0C")  ;; <CJK>
       (?$BUI(B . "0x5B0B")  ;; <CJK>
       (?$BUJ(B . "0x5B16")  ;; <CJK>
       (?$BUK(B . "0x5B32")  ;; <CJK>
       (?$BUL(B . "0x5AD0")  ;; <CJK>
       (?$BUM(B . "0x5B2A")  ;; <CJK>
       (?$BUN(B . "0x5B36")  ;; <CJK>
       (?$BUO(B . "0x5B3E")  ;; <CJK>
       (?$BUP(B . "0x5B43")  ;; <CJK>
       (?$BUQ(B . "0x5B45")  ;; <CJK>
       (?$BUR(B . "0x5B40")  ;; <CJK>
       (?$BUS(B . "0x5B51")  ;; <CJK>
       (?$BUT(B . "0x5B55")  ;; <CJK>
       (?$BUU(B . "0x5B5A")  ;; <CJK>
       (?$BUV(B . "0x5B5B")  ;; <CJK>
       (?$BUW(B . "0x5B65")  ;; <CJK>
       (?$BUX(B . "0x5B69")  ;; <CJK>
       (?$BUY(B . "0x5B70")  ;; <CJK>
       (?$BUZ(B . "0x5B73")  ;; <CJK>
       (?$BU[(B . "0x5B75")  ;; <CJK>
       (?$BU\(B . "0x5B78")  ;; <CJK>
       (?$BU](B . "0x6588")  ;; <CJK>
       (?$BU^(B . "0x5B7A")  ;; <CJK>
       (?$BU_(B . "0x5B80")  ;; <CJK>
       (?$BU`(B . "0x5B83")  ;; <CJK>
       (?$BUa(B . "0x5BA6")  ;; <CJK>
       (?$BUb(B . "0x5BB8")  ;; <CJK>
       (?$BUc(B . "0x5BC3")  ;; <CJK>
       (?$BUd(B . "0x5BC7")  ;; <CJK>
       (?$BUe(B . "0x5BC9")  ;; <CJK>
       (?$BUf(B . "0x5BD4")  ;; <CJK>
       (?$BUg(B . "0x5BD0")  ;; <CJK>
       (?$BUh(B . "0x5BE4")  ;; <CJK>
       (?$BUi(B . "0x5BE6")  ;; <CJK>
       (?$BUj(B . "0x5BE2")  ;; <CJK>
       (?$BUk(B . "0x5BDE")  ;; <CJK>
       (?$BUl(B . "0x5BE5")  ;; <CJK>
       (?$BUm(B . "0x5BEB")  ;; <CJK>
       (?$BUn(B . "0x5BF0")  ;; <CJK>
       (?$BUo(B . "0x5BF6")  ;; <CJK>
       (?$BUp(B . "0x5BF3")  ;; <CJK>
       (?$BUq(B . "0x5C05")  ;; <CJK>
       (?$BUr(B . "0x5C07")  ;; <CJK>
       (?$BUs(B . "0x5C08")  ;; <CJK>
       (?$BUt(B . "0x5C0D")  ;; <CJK>
       (?$BUu(B . "0x5C13")  ;; <CJK>
       (?$BUv(B . "0x5C20")  ;; <CJK>
       (?$BUw(B . "0x5C22")  ;; <CJK>
       (?$BUx(B . "0x5C28")  ;; <CJK>
       (?$BUy(B . "0x5C38")  ;; <CJK>
       (?$BUz(B . "0x5C39")  ;; <CJK>
       (?$BU{(B . "0x5C41")  ;; <CJK>
       (?$BU|(B . "0x5C46")  ;; <CJK>
       (?$BU}(B . "0x5C4E")  ;; <CJK>
       (?$BU~(B . "0x5C53")  ;; <CJK>
       (?$BV!(B . "0x5C50")  ;; <CJK>
       (?$BV"(B . "0x5C4F")  ;; <CJK>
       (?$BV#(B . "0x5B71")  ;; <CJK>
       (?$BV$(B . "0x5C6C")  ;; <CJK>
       (?$BV%(B . "0x5C6E")  ;; <CJK>
       (?$BV&(B . "0x4E62")  ;; <CJK>
       (?$BV'(B . "0x5C76")  ;; <CJK>
       (?$BV((B . "0x5C79")  ;; <CJK>
       (?$BV)(B . "0x5C8C")  ;; <CJK>
       (?$BV*(B . "0x5C91")  ;; <CJK>
       (?$BV+(B . "0x5C94")  ;; <CJK>
       (?$BV,(B . "0x599B")  ;; <CJK>
       (?$BV-(B . "0x5CAB")  ;; <CJK>
       (?$BV.(B . "0x5CBB")  ;; <CJK>
       (?$BV/(B . "0x5CB6")  ;; <CJK>
       (?$BV0(B . "0x5CBC")  ;; <CJK>
       (?$BV1(B . "0x5CB7")  ;; <CJK>
       (?$BV2(B . "0x5CC5")  ;; <CJK>
       (?$BV3(B . "0x5CBE")  ;; <CJK>
       (?$BV4(B . "0x5CC7")  ;; <CJK>
       (?$BV5(B . "0x5CD9")  ;; <CJK>
       (?$BV6(B . "0x5CE9")  ;; <CJK>
       (?$BV7(B . "0x5CFD")  ;; <CJK>
       (?$BV8(B . "0x5CFA")  ;; <CJK>
       (?$BV9(B . "0x5CED")  ;; <CJK>
       (?$BV:(B . "0x5D8C")  ;; <CJK>
       (?$BV;(B . "0x5CEA")  ;; <CJK>
       (?$BV<(B . "0x5D0B")  ;; <CJK>
       (?$BV=(B . "0x5D15")  ;; <CJK>
       (?$BV>(B . "0x5D17")  ;; <CJK>
       (?$BV?(B . "0x5D5C")  ;; <CJK>
       (?$BV@(B . "0x5D1F")  ;; <CJK>
       (?$BVA(B . "0x5D1B")  ;; <CJK>
       (?$BVB(B . "0x5D11")  ;; <CJK>
       (?$BVC(B . "0x5D14")  ;; <CJK>
       (?$BVD(B . "0x5D22")  ;; <CJK>
       (?$BVE(B . "0x5D1A")  ;; <CJK>
       (?$BVF(B . "0x5D19")  ;; <CJK>
       (?$BVG(B . "0x5D18")  ;; <CJK>
       (?$BVH(B . "0x5D4C")  ;; <CJK>
       (?$BVI(B . "0x5D52")  ;; <CJK>
       (?$BVJ(B . "0x5D4E")  ;; <CJK>
       (?$BVK(B . "0x5D4B")  ;; <CJK>
       (?$BVL(B . "0x5D6C")  ;; <CJK>
       (?$BVM(B . "0x5D73")  ;; <CJK>
       (?$BVN(B . "0x5D76")  ;; <CJK>
       (?$BVO(B . "0x5D87")  ;; <CJK>
       (?$BVP(B . "0x5D84")  ;; <CJK>
       (?$BVQ(B . "0x5D82")  ;; <CJK>
       (?$BVR(B . "0x5DA2")  ;; <CJK>
       (?$BVS(B . "0x5D9D")  ;; <CJK>
       (?$BVT(B . "0x5DAC")  ;; <CJK>
       (?$BVU(B . "0x5DAE")  ;; <CJK>
       (?$BVV(B . "0x5DBD")  ;; <CJK>
       (?$BVW(B . "0x5D90")  ;; <CJK>
       (?$BVX(B . "0x5DB7")  ;; <CJK>
       (?$BVY(B . "0x5DBC")  ;; <CJK>
       (?$BVZ(B . "0x5DC9")  ;; <CJK>
       (?$BV[(B . "0x5DCD")  ;; <CJK>
       (?$BV\(B . "0x5DD3")  ;; <CJK>
       (?$BV](B . "0x5DD2")  ;; <CJK>
       (?$BV^(B . "0x5DD6")  ;; <CJK>
       (?$BV_(B . "0x5DDB")  ;; <CJK>
       (?$BV`(B . "0x5DEB")  ;; <CJK>
       (?$BVa(B . "0x5DF2")  ;; <CJK>
       (?$BVb(B . "0x5DF5")  ;; <CJK>
       (?$BVc(B . "0x5E0B")  ;; <CJK>
       (?$BVd(B . "0x5E1A")  ;; <CJK>
       (?$BVe(B . "0x5E19")  ;; <CJK>
       (?$BVf(B . "0x5E11")  ;; <CJK>
       (?$BVg(B . "0x5E1B")  ;; <CJK>
       (?$BVh(B . "0x5E36")  ;; <CJK>
       (?$BVi(B . "0x5E37")  ;; <CJK>
       (?$BVj(B . "0x5E44")  ;; <CJK>
       (?$BVk(B . "0x5E43")  ;; <CJK>
       (?$BVl(B . "0x5E40")  ;; <CJK>
       (?$BVm(B . "0x5E4E")  ;; <CJK>
       (?$BVn(B . "0x5E57")  ;; <CJK>
       (?$BVo(B . "0x5E54")  ;; <CJK>
       (?$BVp(B . "0x5E5F")  ;; <CJK>
       (?$BVq(B . "0x5E62")  ;; <CJK>
       (?$BVr(B . "0x5E64")  ;; <CJK>
       (?$BVs(B . "0x5E47")  ;; <CJK>
       (?$BVt(B . "0x5E75")  ;; <CJK>
       (?$BVu(B . "0x5E76")  ;; <CJK>
       (?$BVv(B . "0x5E7A")  ;; <CJK>
       (?$BVw(B . "0x9EBC")  ;; <CJK>
       (?$BVx(B . "0x5E7F")  ;; <CJK>
       (?$BVy(B . "0x5EA0")  ;; <CJK>
       (?$BVz(B . "0x5EC1")  ;; <CJK>
       (?$BV{(B . "0x5EC2")  ;; <CJK>
       (?$BV|(B . "0x5EC8")  ;; <CJK>
       (?$BV}(B . "0x5ED0")  ;; <CJK>
       (?$BV~(B . "0x5ECF")  ;; <CJK>
       (?$BW!(B . "0x5ED6")  ;; <CJK>
       (?$BW"(B . "0x5EE3")  ;; <CJK>
       (?$BW#(B . "0x5EDD")  ;; <CJK>
       (?$BW$(B . "0x5EDA")  ;; <CJK>
       (?$BW%(B . "0x5EDB")  ;; <CJK>
       (?$BW&(B . "0x5EE2")  ;; <CJK>
       (?$BW'(B . "0x5EE1")  ;; <CJK>
       (?$BW((B . "0x5EE8")  ;; <CJK>
       (?$BW)(B . "0x5EE9")  ;; <CJK>
       (?$BW*(B . "0x5EEC")  ;; <CJK>
       (?$BW+(B . "0x5EF1")  ;; <CJK>
       (?$BW,(B . "0x5EF3")  ;; <CJK>
       (?$BW-(B . "0x5EF0")  ;; <CJK>
       (?$BW.(B . "0x5EF4")  ;; <CJK>
       (?$BW/(B . "0x5EF8")  ;; <CJK>
       (?$BW0(B . "0x5EFE")  ;; <CJK>
       (?$BW1(B . "0x5F03")  ;; <CJK>
       (?$BW2(B . "0x5F09")  ;; <CJK>
       (?$BW3(B . "0x5F5D")  ;; <CJK>
       (?$BW4(B . "0x5F5C")  ;; <CJK>
       (?$BW5(B . "0x5F0B")  ;; <CJK>
       (?$BW6(B . "0x5F11")  ;; <CJK>
       (?$BW7(B . "0x5F16")  ;; <CJK>
       (?$BW8(B . "0x5F29")  ;; <CJK>
       (?$BW9(B . "0x5F2D")  ;; <CJK>
       (?$BW:(B . "0x5F38")  ;; <CJK>
       (?$BW;(B . "0x5F41")  ;; <CJK>
       (?$BW<(B . "0x5F48")  ;; <CJK>
       (?$BW=(B . "0x5F4C")  ;; <CJK>
       (?$BW>(B . "0x5F4E")  ;; <CJK>
       (?$BW?(B . "0x5F2F")  ;; <CJK>
       (?$BW@(B . "0x5F51")  ;; <CJK>
       (?$BWA(B . "0x5F56")  ;; <CJK>
       (?$BWB(B . "0x5F57")  ;; <CJK>
       (?$BWC(B . "0x5F59")  ;; <CJK>
       (?$BWD(B . "0x5F61")  ;; <CJK>
       (?$BWE(B . "0x5F6D")  ;; <CJK>
       (?$BWF(B . "0x5F73")  ;; <CJK>
       (?$BWG(B . "0x5F77")  ;; <CJK>
       (?$BWH(B . "0x5F83")  ;; <CJK>
       (?$BWI(B . "0x5F82")  ;; <CJK>
       (?$BWJ(B . "0x5F7F")  ;; <CJK>
       (?$BWK(B . "0x5F8A")  ;; <CJK>
       (?$BWL(B . "0x5F88")  ;; <CJK>
       (?$BWM(B . "0x5F91")  ;; <CJK>
       (?$BWN(B . "0x5F87")  ;; <CJK>
       (?$BWO(B . "0x5F9E")  ;; <CJK>
       (?$BWP(B . "0x5F99")  ;; <CJK>
       (?$BWQ(B . "0x5F98")  ;; <CJK>
       (?$BWR(B . "0x5FA0")  ;; <CJK>
       (?$BWS(B . "0x5FA8")  ;; <CJK>
       (?$BWT(B . "0x5FAD")  ;; <CJK>
       (?$BWU(B . "0x5FBC")  ;; <CJK>
       (?$BWV(B . "0x5FD6")  ;; <CJK>
       (?$BWW(B . "0x5FFB")  ;; <CJK>
       (?$BWX(B . "0x5FE4")  ;; <CJK>
       (?$BWY(B . "0x5FF8")  ;; <CJK>
       (?$BWZ(B . "0x5FF1")  ;; <CJK>
       (?$BW[(B . "0x5FDD")  ;; <CJK>
       (?$BW\(B . "0x60B3")  ;; <CJK>
       (?$BW](B . "0x5FFF")  ;; <CJK>
       (?$BW^(B . "0x6021")  ;; <CJK>
       (?$BW_(B . "0x6060")  ;; <CJK>
       (?$BW`(B . "0x6019")  ;; <CJK>
       (?$BWa(B . "0x6010")  ;; <CJK>
       (?$BWb(B . "0x6029")  ;; <CJK>
       (?$BWc(B . "0x600E")  ;; <CJK>
       (?$BWd(B . "0x6031")  ;; <CJK>
       (?$BWe(B . "0x601B")  ;; <CJK>
       (?$BWf(B . "0x6015")  ;; <CJK>
       (?$BWg(B . "0x602B")  ;; <CJK>
       (?$BWh(B . "0x6026")  ;; <CJK>
       (?$BWi(B . "0x600F")  ;; <CJK>
       (?$BWj(B . "0x603A")  ;; <CJK>
       (?$BWk(B . "0x605A")  ;; <CJK>
       (?$BWl(B . "0x6041")  ;; <CJK>
       (?$BWm(B . "0x606A")  ;; <CJK>
       (?$BWn(B . "0x6077")  ;; <CJK>
       (?$BWo(B . "0x605F")  ;; <CJK>
       (?$BWp(B . "0x604A")  ;; <CJK>
       (?$BWq(B . "0x6046")  ;; <CJK>
       (?$BWr(B . "0x604D")  ;; <CJK>
       (?$BWs(B . "0x6063")  ;; <CJK>
       (?$BWt(B . "0x6043")  ;; <CJK>
       (?$BWu(B . "0x6064")  ;; <CJK>
       (?$BWv(B . "0x6042")  ;; <CJK>
       (?$BWw(B . "0x606C")  ;; <CJK>
       (?$BWx(B . "0x606B")  ;; <CJK>
       (?$BWy(B . "0x6059")  ;; <CJK>
       (?$BWz(B . "0x6081")  ;; <CJK>
       (?$BW{(B . "0x608D")  ;; <CJK>
       (?$BW|(B . "0x60E7")  ;; <CJK>
       (?$BW}(B . "0x6083")  ;; <CJK>
       (?$BW~(B . "0x609A")  ;; <CJK>
       (?$BX!(B . "0x6084")  ;; <CJK>
       (?$BX"(B . "0x609B")  ;; <CJK>
       (?$BX#(B . "0x6096")  ;; <CJK>
       (?$BX$(B . "0x6097")  ;; <CJK>
       (?$BX%(B . "0x6092")  ;; <CJK>
       (?$BX&(B . "0x60A7")  ;; <CJK>
       (?$BX'(B . "0x608B")  ;; <CJK>
       (?$BX((B . "0x60E1")  ;; <CJK>
       (?$BX)(B . "0x60B8")  ;; <CJK>
       (?$BX*(B . "0x60E0")  ;; <CJK>
       (?$BX+(B . "0x60D3")  ;; <CJK>
       (?$BX,(B . "0x60B4")  ;; <CJK>
       (?$BX-(B . "0x5FF0")  ;; <CJK>
       (?$BX.(B . "0x60BD")  ;; <CJK>
       (?$BX/(B . "0x60C6")  ;; <CJK>
       (?$BX0(B . "0x60B5")  ;; <CJK>
       (?$BX1(B . "0x60D8")  ;; <CJK>
       (?$BX2(B . "0x614D")  ;; <CJK>
       (?$BX3(B . "0x6115")  ;; <CJK>
       (?$BX4(B . "0x6106")  ;; <CJK>
       (?$BX5(B . "0x60F6")  ;; <CJK>
       (?$BX6(B . "0x60F7")  ;; <CJK>
       (?$BX7(B . "0x6100")  ;; <CJK>
       (?$BX8(B . "0x60F4")  ;; <CJK>
       (?$BX9(B . "0x60FA")  ;; <CJK>
       (?$BX:(B . "0x6103")  ;; <CJK>
       (?$BX;(B . "0x6121")  ;; <CJK>
       (?$BX<(B . "0x60FB")  ;; <CJK>
       (?$BX=(B . "0x60F1")  ;; <CJK>
       (?$BX>(B . "0x610D")  ;; <CJK>
       (?$BX?(B . "0x610E")  ;; <CJK>
       (?$BX@(B . "0x6147")  ;; <CJK>
       (?$BXA(B . "0x613E")  ;; <CJK>
       (?$BXB(B . "0x6128")  ;; <CJK>
       (?$BXC(B . "0x6127")  ;; <CJK>
       (?$BXD(B . "0x614A")  ;; <CJK>
       (?$BXE(B . "0x613F")  ;; <CJK>
       (?$BXF(B . "0x613C")  ;; <CJK>
       (?$BXG(B . "0x612C")  ;; <CJK>
       (?$BXH(B . "0x6134")  ;; <CJK>
       (?$BXI(B . "0x613D")  ;; <CJK>
       (?$BXJ(B . "0x6142")  ;; <CJK>
       (?$BXK(B . "0x6144")  ;; <CJK>
       (?$BXL(B . "0x6173")  ;; <CJK>
       (?$BXM(B . "0x6177")  ;; <CJK>
       (?$BXN(B . "0x6158")  ;; <CJK>
       (?$BXO(B . "0x6159")  ;; <CJK>
       (?$BXP(B . "0x615A")  ;; <CJK>
       (?$BXQ(B . "0x616B")  ;; <CJK>
       (?$BXR(B . "0x6174")  ;; <CJK>
       (?$BXS(B . "0x616F")  ;; <CJK>
       (?$BXT(B . "0x6165")  ;; <CJK>
       (?$BXU(B . "0x6171")  ;; <CJK>
       (?$BXV(B . "0x615F")  ;; <CJK>
       (?$BXW(B . "0x615D")  ;; <CJK>
       (?$BXX(B . "0x6153")  ;; <CJK>
       (?$BXY(B . "0x6175")  ;; <CJK>
       (?$BXZ(B . "0x6199")  ;; <CJK>
       (?$BX[(B . "0x6196")  ;; <CJK>
       (?$BX\(B . "0x6187")  ;; <CJK>
       (?$BX](B . "0x61AC")  ;; <CJK>
       (?$BX^(B . "0x6194")  ;; <CJK>
       (?$BX_(B . "0x619A")  ;; <CJK>
       (?$BX`(B . "0x618A")  ;; <CJK>
       (?$BXa(B . "0x6191")  ;; <CJK>
       (?$BXb(B . "0x61AB")  ;; <CJK>
       (?$BXc(B . "0x61AE")  ;; <CJK>
       (?$BXd(B . "0x61CC")  ;; <CJK>
       (?$BXe(B . "0x61CA")  ;; <CJK>
       (?$BXf(B . "0x61C9")  ;; <CJK>
       (?$BXg(B . "0x61F7")  ;; <CJK>
       (?$BXh(B . "0x61C8")  ;; <CJK>
       (?$BXi(B . "0x61C3")  ;; <CJK>
       (?$BXj(B . "0x61C6")  ;; <CJK>
       (?$BXk(B . "0x61BA")  ;; <CJK>
       (?$BXl(B . "0x61CB")  ;; <CJK>
       (?$BXm(B . "0x7F79")  ;; <CJK>
       (?$BXn(B . "0x61CD")  ;; <CJK>
       (?$BXo(B . "0x61E6")  ;; <CJK>
       (?$BXp(B . "0x61E3")  ;; <CJK>
       (?$BXq(B . "0x61F6")  ;; <CJK>
       (?$BXr(B . "0x61FA")  ;; <CJK>
       (?$BXs(B . "0x61F4")  ;; <CJK>
       (?$BXt(B . "0x61FF")  ;; <CJK>
       (?$BXu(B . "0x61FD")  ;; <CJK>
       (?$BXv(B . "0x61FC")  ;; <CJK>
       (?$BXw(B . "0x61FE")  ;; <CJK>
       (?$BXx(B . "0x6200")  ;; <CJK>
       (?$BXy(B . "0x6208")  ;; <CJK>
       (?$BXz(B . "0x6209")  ;; <CJK>
       (?$BX{(B . "0x620D")  ;; <CJK>
       (?$BX|(B . "0x620C")  ;; <CJK>
       (?$BX}(B . "0x6214")  ;; <CJK>
       (?$BX~(B . "0x621B")  ;; <CJK>
       (?$BY!(B . "0x621E")  ;; <CJK>
       (?$BY"(B . "0x6221")  ;; <CJK>
       (?$BY#(B . "0x622A")  ;; <CJK>
       (?$BY$(B . "0x622E")  ;; <CJK>
       (?$BY%(B . "0x6230")  ;; <CJK>
       (?$BY&(B . "0x6232")  ;; <CJK>
       (?$BY'(B . "0x6233")  ;; <CJK>
       (?$BY((B . "0x6241")  ;; <CJK>
       (?$BY)(B . "0x624E")  ;; <CJK>
       (?$BY*(B . "0x625E")  ;; <CJK>
       (?$BY+(B . "0x6263")  ;; <CJK>
       (?$BY,(B . "0x625B")  ;; <CJK>
       (?$BY-(B . "0x6260")  ;; <CJK>
       (?$BY.(B . "0x6268")  ;; <CJK>
       (?$BY/(B . "0x627C")  ;; <CJK>
       (?$BY0(B . "0x6282")  ;; <CJK>
       (?$BY1(B . "0x6289")  ;; <CJK>
       (?$BY2(B . "0x627E")  ;; <CJK>
       (?$BY3(B . "0x6292")  ;; <CJK>
       (?$BY4(B . "0x6293")  ;; <CJK>
       (?$BY5(B . "0x6296")  ;; <CJK>
       (?$BY6(B . "0x62D4")  ;; <CJK>
       (?$BY7(B . "0x6283")  ;; <CJK>
       (?$BY8(B . "0x6294")  ;; <CJK>
       (?$BY9(B . "0x62D7")  ;; <CJK>
       (?$BY:(B . "0x62D1")  ;; <CJK>
       (?$BY;(B . "0x62BB")  ;; <CJK>
       (?$BY<(B . "0x62CF")  ;; <CJK>
       (?$BY=(B . "0x62FF")  ;; <CJK>
       (?$BY>(B . "0x62C6")  ;; <CJK>
       (?$BY?(B . "0x64D4")  ;; <CJK>
       (?$BY@(B . "0x62C8")  ;; <CJK>
       (?$BYA(B . "0x62DC")  ;; <CJK>
       (?$BYB(B . "0x62CC")  ;; <CJK>
       (?$BYC(B . "0x62CA")  ;; <CJK>
       (?$BYD(B . "0x62C2")  ;; <CJK>
       (?$BYE(B . "0x62C7")  ;; <CJK>
       (?$BYF(B . "0x629B")  ;; <CJK>
       (?$BYG(B . "0x62C9")  ;; <CJK>
       (?$BYH(B . "0x630C")  ;; <CJK>
       (?$BYI(B . "0x62EE")  ;; <CJK>
       (?$BYJ(B . "0x62F1")  ;; <CJK>
       (?$BYK(B . "0x6327")  ;; <CJK>
       (?$BYL(B . "0x6302")  ;; <CJK>
       (?$BYM(B . "0x6308")  ;; <CJK>
       (?$BYN(B . "0x62EF")  ;; <CJK>
       (?$BYO(B . "0x62F5")  ;; <CJK>
       (?$BYP(B . "0x6350")  ;; <CJK>
       (?$BYQ(B . "0x633E")  ;; <CJK>
       (?$BYR(B . "0x634D")  ;; <CJK>
       (?$BYS(B . "0x641C")  ;; <CJK>
       (?$BYT(B . "0x634F")  ;; <CJK>
       (?$BYU(B . "0x6396")  ;; <CJK>
       (?$BYV(B . "0x638E")  ;; <CJK>
       (?$BYW(B . "0x6380")  ;; <CJK>
       (?$BYX(B . "0x63AB")  ;; <CJK>
       (?$BYY(B . "0x6376")  ;; <CJK>
       (?$BYZ(B . "0x63A3")  ;; <CJK>
       (?$BY[(B . "0x638F")  ;; <CJK>
       (?$BY\(B . "0x6389")  ;; <CJK>
       (?$BY](B . "0x639F")  ;; <CJK>
       (?$BY^(B . "0x63B5")  ;; <CJK>
       (?$BY_(B . "0x636B")  ;; <CJK>
       (?$BY`(B . "0x6369")  ;; <CJK>
       (?$BYa(B . "0x63BE")  ;; <CJK>
       (?$BYb(B . "0x63E9")  ;; <CJK>
       (?$BYc(B . "0x63C0")  ;; <CJK>
       (?$BYd(B . "0x63C6")  ;; <CJK>
       (?$BYe(B . "0x63E3")  ;; <CJK>
       (?$BYf(B . "0x63C9")  ;; <CJK>
       (?$BYg(B . "0x63D2")  ;; <CJK>
       (?$BYh(B . "0x63F6")  ;; <CJK>
       (?$BYi(B . "0x63C4")  ;; <CJK>
       (?$BYj(B . "0x6416")  ;; <CJK>
       (?$BYk(B . "0x6434")  ;; <CJK>
       (?$BYl(B . "0x6406")  ;; <CJK>
       (?$BYm(B . "0x6413")  ;; <CJK>
       (?$BYn(B . "0x6426")  ;; <CJK>
       (?$BYo(B . "0x6436")  ;; <CJK>
       (?$BYp(B . "0x651D")  ;; <CJK>
       (?$BYq(B . "0x6417")  ;; <CJK>
       (?$BYr(B . "0x6428")  ;; <CJK>
       (?$BYs(B . "0x640F")  ;; <CJK>
       (?$BYt(B . "0x6467")  ;; <CJK>
       (?$BYu(B . "0x646F")  ;; <CJK>
       (?$BYv(B . "0x6476")  ;; <CJK>
       (?$BYw(B . "0x644E")  ;; <CJK>
       (?$BYx(B . "0x652A")  ;; <CJK>
       (?$BYy(B . "0x6495")  ;; <CJK>
       (?$BYz(B . "0x6493")  ;; <CJK>
       (?$BY{(B . "0x64A5")  ;; <CJK>
       (?$BY|(B . "0x64A9")  ;; <CJK>
       (?$BY}(B . "0x6488")  ;; <CJK>
       (?$BY~(B . "0x64BC")  ;; <CJK>
       (?$BZ!(B . "0x64DA")  ;; <CJK>
       (?$BZ"(B . "0x64D2")  ;; <CJK>
       (?$BZ#(B . "0x64C5")  ;; <CJK>
       (?$BZ$(B . "0x64C7")  ;; <CJK>
       (?$BZ%(B . "0x64BB")  ;; <CJK>
       (?$BZ&(B . "0x64D8")  ;; <CJK>
       (?$BZ'(B . "0x64C2")  ;; <CJK>
       (?$BZ((B . "0x64F1")  ;; <CJK>
       (?$BZ)(B . "0x64E7")  ;; <CJK>
       (?$BZ*(B . "0x8209")  ;; <CJK>
       (?$BZ+(B . "0x64E0")  ;; <CJK>
       (?$BZ,(B . "0x64E1")  ;; <CJK>
       (?$BZ-(B . "0x62AC")  ;; <CJK>
       (?$BZ.(B . "0x64E3")  ;; <CJK>
       (?$BZ/(B . "0x64EF")  ;; <CJK>
       (?$BZ0(B . "0x652C")  ;; <CJK>
       (?$BZ1(B . "0x64F6")  ;; <CJK>
       (?$BZ2(B . "0x64F4")  ;; <CJK>
       (?$BZ3(B . "0x64F2")  ;; <CJK>
       (?$BZ4(B . "0x64FA")  ;; <CJK>
       (?$BZ5(B . "0x6500")  ;; <CJK>
       (?$BZ6(B . "0x64FD")  ;; <CJK>
       (?$BZ7(B . "0x6518")  ;; <CJK>
       (?$BZ8(B . "0x651C")  ;; <CJK>
       (?$BZ9(B . "0x6505")  ;; <CJK>
       (?$BZ:(B . "0x6524")  ;; <CJK>
       (?$BZ;(B . "0x6523")  ;; <CJK>
       (?$BZ<(B . "0x652B")  ;; <CJK>
       (?$BZ=(B . "0x6534")  ;; <CJK>
       (?$BZ>(B . "0x6535")  ;; <CJK>
       (?$BZ?(B . "0x6537")  ;; <CJK>
       (?$BZ@(B . "0x6536")  ;; <CJK>
       (?$BZA(B . "0x6538")  ;; <CJK>
       (?$BZB(B . "0x754B")  ;; <CJK>
       (?$BZC(B . "0x6548")  ;; <CJK>
       (?$BZD(B . "0x6556")  ;; <CJK>
       (?$BZE(B . "0x6555")  ;; <CJK>
       (?$BZF(B . "0x654D")  ;; <CJK>
       (?$BZG(B . "0x6558")  ;; <CJK>
       (?$BZH(B . "0x655E")  ;; <CJK>
       (?$BZI(B . "0x655D")  ;; <CJK>
       (?$BZJ(B . "0x6572")  ;; <CJK>
       (?$BZK(B . "0x6578")  ;; <CJK>
       (?$BZL(B . "0x6582")  ;; <CJK>
       (?$BZM(B . "0x6583")  ;; <CJK>
       (?$BZN(B . "0x8B8A")  ;; <CJK>
       (?$BZO(B . "0x659B")  ;; <CJK>
       (?$BZP(B . "0x659F")  ;; <CJK>
       (?$BZQ(B . "0x65AB")  ;; <CJK>
       (?$BZR(B . "0x65B7")  ;; <CJK>
       (?$BZS(B . "0x65C3")  ;; <CJK>
       (?$BZT(B . "0x65C6")  ;; <CJK>
       (?$BZU(B . "0x65C1")  ;; <CJK>
       (?$BZV(B . "0x65C4")  ;; <CJK>
       (?$BZW(B . "0x65CC")  ;; <CJK>
       (?$BZX(B . "0x65D2")  ;; <CJK>
       (?$BZY(B . "0x65DB")  ;; <CJK>
       (?$BZZ(B . "0x65D9")  ;; <CJK>
       (?$BZ[(B . "0x65E0")  ;; <CJK>
       (?$BZ\(B . "0x65E1")  ;; <CJK>
       (?$BZ](B . "0x65F1")  ;; <CJK>
       (?$BZ^(B . "0x6772")  ;; <CJK>
       (?$BZ_(B . "0x660A")  ;; <CJK>
       (?$BZ`(B . "0x6603")  ;; <CJK>
       (?$BZa(B . "0x65FB")  ;; <CJK>
       (?$BZb(B . "0x6773")  ;; <CJK>
       (?$BZc(B . "0x6635")  ;; <CJK>
       (?$BZd(B . "0x6636")  ;; <CJK>
       (?$BZe(B . "0x6634")  ;; <CJK>
       (?$BZf(B . "0x661C")  ;; <CJK>
       (?$BZg(B . "0x664F")  ;; <CJK>
       (?$BZh(B . "0x6644")  ;; <CJK>
       (?$BZi(B . "0x6649")  ;; <CJK>
       (?$BZj(B . "0x6641")  ;; <CJK>
       (?$BZk(B . "0x665E")  ;; <CJK>
       (?$BZl(B . "0x665D")  ;; <CJK>
       (?$BZm(B . "0x6664")  ;; <CJK>
       (?$BZn(B . "0x6667")  ;; <CJK>
       (?$BZo(B . "0x6668")  ;; <CJK>
       (?$BZp(B . "0x665F")  ;; <CJK>
       (?$BZq(B . "0x6662")  ;; <CJK>
       (?$BZr(B . "0x6670")  ;; <CJK>
       (?$BZs(B . "0x6683")  ;; <CJK>
       (?$BZt(B . "0x6688")  ;; <CJK>
       (?$BZu(B . "0x668E")  ;; <CJK>
       (?$BZv(B . "0x6689")  ;; <CJK>
       (?$BZw(B . "0x6684")  ;; <CJK>
       (?$BZx(B . "0x6698")  ;; <CJK>
       (?$BZy(B . "0x669D")  ;; <CJK>
       (?$BZz(B . "0x66C1")  ;; <CJK>
       (?$BZ{(B . "0x66B9")  ;; <CJK>
       (?$BZ|(B . "0x66C9")  ;; <CJK>
       (?$BZ}(B . "0x66BE")  ;; <CJK>
       (?$BZ~(B . "0x66BC")  ;; <CJK>
       (?$B[!(B . "0x66C4")  ;; <CJK>
       (?$B["(B . "0x66B8")  ;; <CJK>
       (?$B[#(B . "0x66D6")  ;; <CJK>
       (?$B[$(B . "0x66DA")  ;; <CJK>
       (?$B[%(B . "0x66E0")  ;; <CJK>
       (?$B[&(B . "0x663F")  ;; <CJK>
       (?$B['(B . "0x66E6")  ;; <CJK>
       (?$B[((B . "0x66E9")  ;; <CJK>
       (?$B[)(B . "0x66F0")  ;; <CJK>
       (?$B[*(B . "0x66F5")  ;; <CJK>
       (?$B[+(B . "0x66F7")  ;; <CJK>
       (?$B[,(B . "0x670F")  ;; <CJK>
       (?$B[-(B . "0x6716")  ;; <CJK>
       (?$B[.(B . "0x671E")  ;; <CJK>
       (?$B[/(B . "0x6726")  ;; <CJK>
       (?$B[0(B . "0x6727")  ;; <CJK>
       (?$B[1(B . "0x9738")  ;; <CJK>
       (?$B[2(B . "0x672E")  ;; <CJK>
       (?$B[3(B . "0x673F")  ;; <CJK>
       (?$B[4(B . "0x6736")  ;; <CJK>
       (?$B[5(B . "0x6741")  ;; <CJK>
       (?$B[6(B . "0x6738")  ;; <CJK>
       (?$B[7(B . "0x6737")  ;; <CJK>
       (?$B[8(B . "0x6746")  ;; <CJK>
       (?$B[9(B . "0x675E")  ;; <CJK>
       (?$B[:(B . "0x6760")  ;; <CJK>
       (?$B[;(B . "0x6759")  ;; <CJK>
       (?$B[<(B . "0x6763")  ;; <CJK>
       (?$B[=(B . "0x6764")  ;; <CJK>
       (?$B[>(B . "0x6789")  ;; <CJK>
       (?$B[?(B . "0x6770")  ;; <CJK>
       (?$B[@(B . "0x67A9")  ;; <CJK>
       (?$B[A(B . "0x677C")  ;; <CJK>
       (?$B[B(B . "0x676A")  ;; <CJK>
       (?$B[C(B . "0x678C")  ;; <CJK>
       (?$B[D(B . "0x678B")  ;; <CJK>
       (?$B[E(B . "0x67A6")  ;; <CJK>
       (?$B[F(B . "0x67A1")  ;; <CJK>
       (?$B[G(B . "0x6785")  ;; <CJK>
       (?$B[H(B . "0x67B7")  ;; <CJK>
       (?$B[I(B . "0x67EF")  ;; <CJK>
       (?$B[J(B . "0x67B4")  ;; <CJK>
       (?$B[K(B . "0x67EC")  ;; <CJK>
       (?$B[L(B . "0x67B3")  ;; <CJK>
       (?$B[M(B . "0x67E9")  ;; <CJK>
       (?$B[N(B . "0x67B8")  ;; <CJK>
       (?$B[O(B . "0x67E4")  ;; <CJK>
       (?$B[P(B . "0x67DE")  ;; <CJK>
       (?$B[Q(B . "0x67DD")  ;; <CJK>
       (?$B[R(B . "0x67E2")  ;; <CJK>
       (?$B[S(B . "0x67EE")  ;; <CJK>
       (?$B[T(B . "0x67B9")  ;; <CJK>
       (?$B[U(B . "0x67CE")  ;; <CJK>
       (?$B[V(B . "0x67C6")  ;; <CJK>
       (?$B[W(B . "0x67E7")  ;; <CJK>
       (?$B[X(B . "0x6A9C")  ;; <CJK>
       (?$B[Y(B . "0x681E")  ;; <CJK>
       (?$B[Z(B . "0x6846")  ;; <CJK>
       (?$B[[(B . "0x6829")  ;; <CJK>
       (?$B[\(B . "0x6840")  ;; <CJK>
       (?$B[](B . "0x684D")  ;; <CJK>
       (?$B[^(B . "0x6832")  ;; <CJK>
       (?$B[_(B . "0x684E")  ;; <CJK>
       (?$B[`(B . "0x68B3")  ;; <CJK>
       (?$B[a(B . "0x682B")  ;; <CJK>
       (?$B[b(B . "0x6859")  ;; <CJK>
       (?$B[c(B . "0x6863")  ;; <CJK>
       (?$B[d(B . "0x6877")  ;; <CJK>
       (?$B[e(B . "0x687F")  ;; <CJK>
       (?$B[f(B . "0x689F")  ;; <CJK>
       (?$B[g(B . "0x688F")  ;; <CJK>
       (?$B[h(B . "0x68AD")  ;; <CJK>
       (?$B[i(B . "0x6894")  ;; <CJK>
       (?$B[j(B . "0x689D")  ;; <CJK>
       (?$B[k(B . "0x689B")  ;; <CJK>
       (?$B[l(B . "0x6883")  ;; <CJK>
       (?$B[m(B . "0x6AAE")  ;; <CJK>
       (?$B[n(B . "0x68B9")  ;; <CJK>
       (?$B[o(B . "0x6874")  ;; <CJK>
       (?$B[p(B . "0x68B5")  ;; <CJK>
       (?$B[q(B . "0x68A0")  ;; <CJK>
       (?$B[r(B . "0x68BA")  ;; <CJK>
       (?$B[s(B . "0x690F")  ;; <CJK>
       (?$B[t(B . "0x688D")  ;; <CJK>
       (?$B[u(B . "0x687E")  ;; <CJK>
       (?$B[v(B . "0x6901")  ;; <CJK>
       (?$B[w(B . "0x68CA")  ;; <CJK>
       (?$B[x(B . "0x6908")  ;; <CJK>
       (?$B[y(B . "0x68D8")  ;; <CJK>
       (?$B[z(B . "0x6922")  ;; <CJK>
       (?$B[{(B . "0x6926")  ;; <CJK>
       (?$B[|(B . "0x68E1")  ;; <CJK>
       (?$B[}(B . "0x690C")  ;; <CJK>
       (?$B[~(B . "0x68CD")  ;; <CJK>
       (?$B\!(B . "0x68D4")  ;; <CJK>
       (?$B\"(B . "0x68E7")  ;; <CJK>
       (?$B\#(B . "0x68D5")  ;; <CJK>
       (?$B\$(B . "0x6936")  ;; <CJK>
       (?$B\%(B . "0x6912")  ;; <CJK>
       (?$B\&(B . "0x6904")  ;; <CJK>
       (?$B\'(B . "0x68D7")  ;; <CJK>
       (?$B\((B . "0x68E3")  ;; <CJK>
       (?$B\)(B . "0x6925")  ;; <CJK>
       (?$B\*(B . "0x68F9")  ;; <CJK>
       (?$B\+(B . "0x68E0")  ;; <CJK>
       (?$B\,(B . "0x68EF")  ;; <CJK>
       (?$B\-(B . "0x6928")  ;; <CJK>
       (?$B\.(B . "0x692A")  ;; <CJK>
       (?$B\/(B . "0x691A")  ;; <CJK>
       (?$B\0(B . "0x6923")  ;; <CJK>
       (?$B\1(B . "0x6921")  ;; <CJK>
       (?$B\2(B . "0x68C6")  ;; <CJK>
       (?$B\3(B . "0x6979")  ;; <CJK>
       (?$B\4(B . "0x6977")  ;; <CJK>
       (?$B\5(B . "0x695C")  ;; <CJK>
       (?$B\6(B . "0x6978")  ;; <CJK>
       (?$B\7(B . "0x696B")  ;; <CJK>
       (?$B\8(B . "0x6954")  ;; <CJK>
       (?$B\9(B . "0x697E")  ;; <CJK>
       (?$B\:(B . "0x696E")  ;; <CJK>
       (?$B\;(B . "0x6939")  ;; <CJK>
       (?$B\<(B . "0x6974")  ;; <CJK>
       (?$B\=(B . "0x693D")  ;; <CJK>
       (?$B\>(B . "0x6959")  ;; <CJK>
       (?$B\?(B . "0x6930")  ;; <CJK>
       (?$B\@(B . "0x6961")  ;; <CJK>
       (?$B\A(B . "0x695E")  ;; <CJK>
       (?$B\B(B . "0x695D")  ;; <CJK>
       (?$B\C(B . "0x6981")  ;; <CJK>
       (?$B\D(B . "0x696A")  ;; <CJK>
       (?$B\E(B . "0x69B2")  ;; <CJK>
       (?$B\F(B . "0x69AE")  ;; <CJK>
       (?$B\G(B . "0x69D0")  ;; <CJK>
       (?$B\H(B . "0x69BF")  ;; <CJK>
       (?$B\I(B . "0x69C1")  ;; <CJK>
       (?$B\J(B . "0x69D3")  ;; <CJK>
       (?$B\K(B . "0x69BE")  ;; <CJK>
       (?$B\L(B . "0x69CE")  ;; <CJK>
       (?$B\M(B . "0x5BE8")  ;; <CJK>
       (?$B\N(B . "0x69CA")  ;; <CJK>
       (?$B\O(B . "0x69DD")  ;; <CJK>
       (?$B\P(B . "0x69BB")  ;; <CJK>
       (?$B\Q(B . "0x69C3")  ;; <CJK>
       (?$B\R(B . "0x69A7")  ;; <CJK>
       (?$B\S(B . "0x6A2E")  ;; <CJK>
       (?$B\T(B . "0x6991")  ;; <CJK>
       (?$B\U(B . "0x69A0")  ;; <CJK>
       (?$B\V(B . "0x699C")  ;; <CJK>
       (?$B\W(B . "0x6995")  ;; <CJK>
       (?$B\X(B . "0x69B4")  ;; <CJK>
       (?$B\Y(B . "0x69DE")  ;; <CJK>
       (?$B\Z(B . "0x69E8")  ;; <CJK>
       (?$B\[(B . "0x6A02")  ;; <CJK>
       (?$B\\(B . "0x6A1B")  ;; <CJK>
       (?$B\](B . "0x69FF")  ;; <CJK>
       (?$B\^(B . "0x6B0A")  ;; <CJK>
       (?$B\_(B . "0x69F9")  ;; <CJK>
       (?$B\`(B . "0x69F2")  ;; <CJK>
       (?$B\a(B . "0x69E7")  ;; <CJK>
       (?$B\b(B . "0x6A05")  ;; <CJK>
       (?$B\c(B . "0x69B1")  ;; <CJK>
       (?$B\d(B . "0x6A1E")  ;; <CJK>
       (?$B\e(B . "0x69ED")  ;; <CJK>
       (?$B\f(B . "0x6A14")  ;; <CJK>
       (?$B\g(B . "0x69EB")  ;; <CJK>
       (?$B\h(B . "0x6A0A")  ;; <CJK>
       (?$B\i(B . "0x6A12")  ;; <CJK>
       (?$B\j(B . "0x6AC1")  ;; <CJK>
       (?$B\k(B . "0x6A23")  ;; <CJK>
       (?$B\l(B . "0x6A13")  ;; <CJK>
       (?$B\m(B . "0x6A44")  ;; <CJK>
       (?$B\n(B . "0x6A0C")  ;; <CJK>
       (?$B\o(B . "0x6A72")  ;; <CJK>
       (?$B\p(B . "0x6A36")  ;; <CJK>
       (?$B\q(B . "0x6A78")  ;; <CJK>
       (?$B\r(B . "0x6A47")  ;; <CJK>
       (?$B\s(B . "0x6A62")  ;; <CJK>
       (?$B\t(B . "0x6A59")  ;; <CJK>
       (?$B\u(B . "0x6A66")  ;; <CJK>
       (?$B\v(B . "0x6A48")  ;; <CJK>
       (?$B\w(B . "0x6A38")  ;; <CJK>
       (?$B\x(B . "0x6A22")  ;; <CJK>
       (?$B\y(B . "0x6A90")  ;; <CJK>
       (?$B\z(B . "0x6A8D")  ;; <CJK>
       (?$B\{(B . "0x6AA0")  ;; <CJK>
       (?$B\|(B . "0x6A84")  ;; <CJK>
       (?$B\}(B . "0x6AA2")  ;; <CJK>
       (?$B\~(B . "0x6AA3")  ;; <CJK>
       (?$B]!(B . "0x6A97")  ;; <CJK>
       (?$B]"(B . "0x8617")  ;; <CJK>
       (?$B]#(B . "0x6ABB")  ;; <CJK>
       (?$B]$(B . "0x6AC3")  ;; <CJK>
       (?$B]%(B . "0x6AC2")  ;; <CJK>
       (?$B]&(B . "0x6AB8")  ;; <CJK>
       (?$B]'(B . "0x6AB3")  ;; <CJK>
       (?$B]((B . "0x6AAC")  ;; <CJK>
       (?$B])(B . "0x6ADE")  ;; <CJK>
       (?$B]*(B . "0x6AD1")  ;; <CJK>
       (?$B]+(B . "0x6ADF")  ;; <CJK>
       (?$B],(B . "0x6AAA")  ;; <CJK>
       (?$B]-(B . "0x6ADA")  ;; <CJK>
       (?$B].(B . "0x6AEA")  ;; <CJK>
       (?$B]/(B . "0x6AFB")  ;; <CJK>
       (?$B]0(B . "0x6B05")  ;; <CJK>
       (?$B]1(B . "0x8616")  ;; <CJK>
       (?$B]2(B . "0x6AFA")  ;; <CJK>
       (?$B]3(B . "0x6B12")  ;; <CJK>
       (?$B]4(B . "0x6B16")  ;; <CJK>
       (?$B]5(B . "0x9B31")  ;; <CJK>
       (?$B]6(B . "0x6B1F")  ;; <CJK>
       (?$B]7(B . "0x6B38")  ;; <CJK>
       (?$B]8(B . "0x6B37")  ;; <CJK>
       (?$B]9(B . "0x76DC")  ;; <CJK>
       (?$B]:(B . "0x6B39")  ;; <CJK>
       (?$B];(B . "0x98EE")  ;; <CJK>
       (?$B]<(B . "0x6B47")  ;; <CJK>
       (?$B]=(B . "0x6B43")  ;; <CJK>
       (?$B]>(B . "0x6B49")  ;; <CJK>
       (?$B]?(B . "0x6B50")  ;; <CJK>
       (?$B]@(B . "0x6B59")  ;; <CJK>
       (?$B]A(B . "0x6B54")  ;; <CJK>
       (?$B]B(B . "0x6B5B")  ;; <CJK>
       (?$B]C(B . "0x6B5F")  ;; <CJK>
       (?$B]D(B . "0x6B61")  ;; <CJK>
       (?$B]E(B . "0x6B78")  ;; <CJK>
       (?$B]F(B . "0x6B79")  ;; <CJK>
       (?$B]G(B . "0x6B7F")  ;; <CJK>
       (?$B]H(B . "0x6B80")  ;; <CJK>
       (?$B]I(B . "0x6B84")  ;; <CJK>
       (?$B]J(B . "0x6B83")  ;; <CJK>
       (?$B]K(B . "0x6B8D")  ;; <CJK>
       (?$B]L(B . "0x6B98")  ;; <CJK>
       (?$B]M(B . "0x6B95")  ;; <CJK>
       (?$B]N(B . "0x6B9E")  ;; <CJK>
       (?$B]O(B . "0x6BA4")  ;; <CJK>
       (?$B]P(B . "0x6BAA")  ;; <CJK>
       (?$B]Q(B . "0x6BAB")  ;; <CJK>
       (?$B]R(B . "0x6BAF")  ;; <CJK>
       (?$B]S(B . "0x6BB2")  ;; <CJK>
       (?$B]T(B . "0x6BB1")  ;; <CJK>
       (?$B]U(B . "0x6BB3")  ;; <CJK>
       (?$B]V(B . "0x6BB7")  ;; <CJK>
       (?$B]W(B . "0x6BBC")  ;; <CJK>
       (?$B]X(B . "0x6BC6")  ;; <CJK>
       (?$B]Y(B . "0x6BCB")  ;; <CJK>
       (?$B]Z(B . "0x6BD3")  ;; <CJK>
       (?$B][(B . "0x6BDF")  ;; <CJK>
       (?$B]\(B . "0x6BEC")  ;; <CJK>
       (?$B]](B . "0x6BEB")  ;; <CJK>
       (?$B]^(B . "0x6BF3")  ;; <CJK>
       (?$B]_(B . "0x6BEF")  ;; <CJK>
       (?$B]`(B . "0x9EBE")  ;; <CJK>
       (?$B]a(B . "0x6C08")  ;; <CJK>
       (?$B]b(B . "0x6C13")  ;; <CJK>
       (?$B]c(B . "0x6C14")  ;; <CJK>
       (?$B]d(B . "0x6C1B")  ;; <CJK>
       (?$B]e(B . "0x6C24")  ;; <CJK>
       (?$B]f(B . "0x6C23")  ;; <CJK>
       (?$B]g(B . "0x6C5E")  ;; <CJK>
       (?$B]h(B . "0x6C55")  ;; <CJK>
       (?$B]i(B . "0x6C62")  ;; <CJK>
       (?$B]j(B . "0x6C6A")  ;; <CJK>
       (?$B]k(B . "0x6C82")  ;; <CJK>
       (?$B]l(B . "0x6C8D")  ;; <CJK>
       (?$B]m(B . "0x6C9A")  ;; <CJK>
       (?$B]n(B . "0x6C81")  ;; <CJK>
       (?$B]o(B . "0x6C9B")  ;; <CJK>
       (?$B]p(B . "0x6C7E")  ;; <CJK>
       (?$B]q(B . "0x6C68")  ;; <CJK>
       (?$B]r(B . "0x6C73")  ;; <CJK>
       (?$B]s(B . "0x6C92")  ;; <CJK>
       (?$B]t(B . "0x6C90")  ;; <CJK>
       (?$B]u(B . "0x6CC4")  ;; <CJK>
       (?$B]v(B . "0x6CF1")  ;; <CJK>
       (?$B]w(B . "0x6CD3")  ;; <CJK>
       (?$B]x(B . "0x6CBD")  ;; <CJK>
       (?$B]y(B . "0x6CD7")  ;; <CJK>
       (?$B]z(B . "0x6CC5")  ;; <CJK>
       (?$B]{(B . "0x6CDD")  ;; <CJK>
       (?$B]|(B . "0x6CAE")  ;; <CJK>
       (?$B]}(B . "0x6CB1")  ;; <CJK>
       (?$B]~(B . "0x6CBE")  ;; <CJK>
       (?$B^!(B . "0x6CBA")  ;; <CJK>
       (?$B^"(B . "0x6CDB")  ;; <CJK>
       (?$B^#(B . "0x6CEF")  ;; <CJK>
       (?$B^$(B . "0x6CD9")  ;; <CJK>
       (?$B^%(B . "0x6CEA")  ;; <CJK>
       (?$B^&(B . "0x6D1F")  ;; <CJK>
       (?$B^'(B . "0x884D")  ;; <CJK>
       (?$B^((B . "0x6D36")  ;; <CJK>
       (?$B^)(B . "0x6D2B")  ;; <CJK>
       (?$B^*(B . "0x6D3D")  ;; <CJK>
       (?$B^+(B . "0x6D38")  ;; <CJK>
       (?$B^,(B . "0x6D19")  ;; <CJK>
       (?$B^-(B . "0x6D35")  ;; <CJK>
       (?$B^.(B . "0x6D33")  ;; <CJK>
       (?$B^/(B . "0x6D12")  ;; <CJK>
       (?$B^0(B . "0x6D0C")  ;; <CJK>
       (?$B^1(B . "0x6D63")  ;; <CJK>
       (?$B^2(B . "0x6D93")  ;; <CJK>
       (?$B^3(B . "0x6D64")  ;; <CJK>
       (?$B^4(B . "0x6D5A")  ;; <CJK>
       (?$B^5(B . "0x6D79")  ;; <CJK>
       (?$B^6(B . "0x6D59")  ;; <CJK>
       (?$B^7(B . "0x6D8E")  ;; <CJK>
       (?$B^8(B . "0x6D95")  ;; <CJK>
       (?$B^9(B . "0x6FE4")  ;; <CJK>
       (?$B^:(B . "0x6D85")  ;; <CJK>
       (?$B^;(B . "0x6DF9")  ;; <CJK>
       (?$B^<(B . "0x6E15")  ;; <CJK>
       (?$B^=(B . "0x6E0A")  ;; <CJK>
       (?$B^>(B . "0x6DB5")  ;; <CJK>
       (?$B^?(B . "0x6DC7")  ;; <CJK>
       (?$B^@(B . "0x6DE6")  ;; <CJK>
       (?$B^A(B . "0x6DB8")  ;; <CJK>
       (?$B^B(B . "0x6DC6")  ;; <CJK>
       (?$B^C(B . "0x6DEC")  ;; <CJK>
       (?$B^D(B . "0x6DDE")  ;; <CJK>
       (?$B^E(B . "0x6DCC")  ;; <CJK>
       (?$B^F(B . "0x6DE8")  ;; <CJK>
       (?$B^G(B . "0x6DD2")  ;; <CJK>
       (?$B^H(B . "0x6DC5")  ;; <CJK>
       (?$B^I(B . "0x6DFA")  ;; <CJK>
       (?$B^J(B . "0x6DD9")  ;; <CJK>
       (?$B^K(B . "0x6DE4")  ;; <CJK>
       (?$B^L(B . "0x6DD5")  ;; <CJK>
       (?$B^M(B . "0x6DEA")  ;; <CJK>
       (?$B^N(B . "0x6DEE")  ;; <CJK>
       (?$B^O(B . "0x6E2D")  ;; <CJK>
       (?$B^P(B . "0x6E6E")  ;; <CJK>
       (?$B^Q(B . "0x6E2E")  ;; <CJK>
       (?$B^R(B . "0x6E19")  ;; <CJK>
       (?$B^S(B . "0x6E72")  ;; <CJK>
       (?$B^T(B . "0x6E5F")  ;; <CJK>
       (?$B^U(B . "0x6E3E")  ;; <CJK>
       (?$B^V(B . "0x6E23")  ;; <CJK>
       (?$B^W(B . "0x6E6B")  ;; <CJK>
       (?$B^X(B . "0x6E2B")  ;; <CJK>
       (?$B^Y(B . "0x6E76")  ;; <CJK>
       (?$B^Z(B . "0x6E4D")  ;; <CJK>
       (?$B^[(B . "0x6E1F")  ;; <CJK>
       (?$B^\(B . "0x6E43")  ;; <CJK>
       (?$B^](B . "0x6E3A")  ;; <CJK>
       (?$B^^(B . "0x6E4E")  ;; <CJK>
       (?$B^_(B . "0x6E24")  ;; <CJK>
       (?$B^`(B . "0x6EFF")  ;; <CJK>
       (?$B^a(B . "0x6E1D")  ;; <CJK>
       (?$B^b(B . "0x6E38")  ;; <CJK>
       (?$B^c(B . "0x6E82")  ;; <CJK>
       (?$B^d(B . "0x6EAA")  ;; <CJK>
       (?$B^e(B . "0x6E98")  ;; <CJK>
       (?$B^f(B . "0x6EC9")  ;; <CJK>
       (?$B^g(B . "0x6EB7")  ;; <CJK>
       (?$B^h(B . "0x6ED3")  ;; <CJK>
       (?$B^i(B . "0x6EBD")  ;; <CJK>
       (?$B^j(B . "0x6EAF")  ;; <CJK>
       (?$B^k(B . "0x6EC4")  ;; <CJK>
       (?$B^l(B . "0x6EB2")  ;; <CJK>
       (?$B^m(B . "0x6ED4")  ;; <CJK>
       (?$B^n(B . "0x6ED5")  ;; <CJK>
       (?$B^o(B . "0x6E8F")  ;; <CJK>
       (?$B^p(B . "0x6EA5")  ;; <CJK>
       (?$B^q(B . "0x6EC2")  ;; <CJK>
       (?$B^r(B . "0x6E9F")  ;; <CJK>
       (?$B^s(B . "0x6F41")  ;; <CJK>
       (?$B^t(B . "0x6F11")  ;; <CJK>
       (?$B^u(B . "0x704C")  ;; <CJK>
       (?$B^v(B . "0x6EEC")  ;; <CJK>
       (?$B^w(B . "0x6EF8")  ;; <CJK>
       (?$B^x(B . "0x6EFE")  ;; <CJK>
       (?$B^y(B . "0x6F3F")  ;; <CJK>
       (?$B^z(B . "0x6EF2")  ;; <CJK>
       (?$B^{(B . "0x6F31")  ;; <CJK>
       (?$B^|(B . "0x6EEF")  ;; <CJK>
       (?$B^}(B . "0x6F32")  ;; <CJK>
       (?$B^~(B . "0x6ECC")  ;; <CJK>
       (?$B_!(B . "0x6F3E")  ;; <CJK>
       (?$B_"(B . "0x6F13")  ;; <CJK>
       (?$B_#(B . "0x6EF7")  ;; <CJK>
       (?$B_$(B . "0x6F86")  ;; <CJK>
       (?$B_%(B . "0x6F7A")  ;; <CJK>
       (?$B_&(B . "0x6F78")  ;; <CJK>
       (?$B_'(B . "0x6F81")  ;; <CJK>
       (?$B_((B . "0x6F80")  ;; <CJK>
       (?$B_)(B . "0x6F6F")  ;; <CJK>
       (?$B_*(B . "0x6F5B")  ;; <CJK>
       (?$B_+(B . "0x6FF3")  ;; <CJK>
       (?$B_,(B . "0x6F6D")  ;; <CJK>
       (?$B_-(B . "0x6F82")  ;; <CJK>
       (?$B_.(B . "0x6F7C")  ;; <CJK>
       (?$B_/(B . "0x6F58")  ;; <CJK>
       (?$B_0(B . "0x6F8E")  ;; <CJK>
       (?$B_1(B . "0x6F91")  ;; <CJK>
       (?$B_2(B . "0x6FC2")  ;; <CJK>
       (?$B_3(B . "0x6F66")  ;; <CJK>
       (?$B_4(B . "0x6FB3")  ;; <CJK>
       (?$B_5(B . "0x6FA3")  ;; <CJK>
       (?$B_6(B . "0x6FA1")  ;; <CJK>
       (?$B_7(B . "0x6FA4")  ;; <CJK>
       (?$B_8(B . "0x6FB9")  ;; <CJK>
       (?$B_9(B . "0x6FC6")  ;; <CJK>
       (?$B_:(B . "0x6FAA")  ;; <CJK>
       (?$B_;(B . "0x6FDF")  ;; <CJK>
       (?$B_<(B . "0x6FD5")  ;; <CJK>
       (?$B_=(B . "0x6FEC")  ;; <CJK>
       (?$B_>(B . "0x6FD4")  ;; <CJK>
       (?$B_?(B . "0x6FD8")  ;; <CJK>
       (?$B_@(B . "0x6FF1")  ;; <CJK>
       (?$B_A(B . "0x6FEE")  ;; <CJK>
       (?$B_B(B . "0x6FDB")  ;; <CJK>
       (?$B_C(B . "0x7009")  ;; <CJK>
       (?$B_D(B . "0x700B")  ;; <CJK>
       (?$B_E(B . "0x6FFA")  ;; <CJK>
       (?$B_F(B . "0x7011")  ;; <CJK>
       (?$B_G(B . "0x7001")  ;; <CJK>
       (?$B_H(B . "0x700F")  ;; <CJK>
       (?$B_I(B . "0x6FFE")  ;; <CJK>
       (?$B_J(B . "0x701B")  ;; <CJK>
       (?$B_K(B . "0x701A")  ;; <CJK>
       (?$B_L(B . "0x6F74")  ;; <CJK>
       (?$B_M(B . "0x701D")  ;; <CJK>
       (?$B_N(B . "0x7018")  ;; <CJK>
       (?$B_O(B . "0x701F")  ;; <CJK>
       (?$B_P(B . "0x7030")  ;; <CJK>
       (?$B_Q(B . "0x703E")  ;; <CJK>
       (?$B_R(B . "0x7032")  ;; <CJK>
       (?$B_S(B . "0x7051")  ;; <CJK>
       (?$B_T(B . "0x7063")  ;; <CJK>
       (?$B_U(B . "0x7099")  ;; <CJK>
       (?$B_V(B . "0x7092")  ;; <CJK>
       (?$B_W(B . "0x70AF")  ;; <CJK>
       (?$B_X(B . "0x70F1")  ;; <CJK>
       (?$B_Y(B . "0x70AC")  ;; <CJK>
       (?$B_Z(B . "0x70B8")  ;; <CJK>
       (?$B_[(B . "0x70B3")  ;; <CJK>
       (?$B_\(B . "0x70AE")  ;; <CJK>
       (?$B_](B . "0x70DF")  ;; <CJK>
       (?$B_^(B . "0x70CB")  ;; <CJK>
       (?$B__(B . "0x70DD")  ;; <CJK>
       (?$B_`(B . "0x70D9")  ;; <CJK>
       (?$B_a(B . "0x7109")  ;; <CJK>
       (?$B_b(B . "0x70FD")  ;; <CJK>
       (?$B_c(B . "0x711C")  ;; <CJK>
       (?$B_d(B . "0x7119")  ;; <CJK>
       (?$B_e(B . "0x7165")  ;; <CJK>
       (?$B_f(B . "0x7155")  ;; <CJK>
       (?$B_g(B . "0x7188")  ;; <CJK>
       (?$B_h(B . "0x7166")  ;; <CJK>
       (?$B_i(B . "0x7162")  ;; <CJK>
       (?$B_j(B . "0x714C")  ;; <CJK>
       (?$B_k(B . "0x7156")  ;; <CJK>
       (?$B_l(B . "0x716C")  ;; <CJK>
       (?$B_m(B . "0x718F")  ;; <CJK>
       (?$B_n(B . "0x71FB")  ;; <CJK>
       (?$B_o(B . "0x7184")  ;; <CJK>
       (?$B_p(B . "0x7195")  ;; <CJK>
       (?$B_q(B . "0x71A8")  ;; <CJK>
       (?$B_r(B . "0x71AC")  ;; <CJK>
       (?$B_s(B . "0x71D7")  ;; <CJK>
       (?$B_t(B . "0x71B9")  ;; <CJK>
       (?$B_u(B . "0x71BE")  ;; <CJK>
       (?$B_v(B . "0x71D2")  ;; <CJK>
       (?$B_w(B . "0x71C9")  ;; <CJK>
       (?$B_x(B . "0x71D4")  ;; <CJK>
       (?$B_y(B . "0x71CE")  ;; <CJK>
       (?$B_z(B . "0x71E0")  ;; <CJK>
       (?$B_{(B . "0x71EC")  ;; <CJK>
       (?$B_|(B . "0x71E7")  ;; <CJK>
       (?$B_}(B . "0x71F5")  ;; <CJK>
       (?$B_~(B . "0x71FC")  ;; <CJK>
       (?$B`!(B . "0x71F9")  ;; <CJK>
       (?$B`"(B . "0x71FF")  ;; <CJK>
       (?$B`#(B . "0x720D")  ;; <CJK>
       (?$B`$(B . "0x7210")  ;; <CJK>
       (?$B`%(B . "0x721B")  ;; <CJK>
       (?$B`&(B . "0x7228")  ;; <CJK>
       (?$B`'(B . "0x722D")  ;; <CJK>
       (?$B`((B . "0x722C")  ;; <CJK>
       (?$B`)(B . "0x7230")  ;; <CJK>
       (?$B`*(B . "0x7232")  ;; <CJK>
       (?$B`+(B . "0x723B")  ;; <CJK>
       (?$B`,(B . "0x723C")  ;; <CJK>
       (?$B`-(B . "0x723F")  ;; <CJK>
       (?$B`.(B . "0x7240")  ;; <CJK>
       (?$B`/(B . "0x7246")  ;; <CJK>
       (?$B`0(B . "0x724B")  ;; <CJK>
       (?$B`1(B . "0x7258")  ;; <CJK>
       (?$B`2(B . "0x7274")  ;; <CJK>
       (?$B`3(B . "0x727E")  ;; <CJK>
       (?$B`4(B . "0x7282")  ;; <CJK>
       (?$B`5(B . "0x7281")  ;; <CJK>
       (?$B`6(B . "0x7287")  ;; <CJK>
       (?$B`7(B . "0x7292")  ;; <CJK>
       (?$B`8(B . "0x7296")  ;; <CJK>
       (?$B`9(B . "0x72A2")  ;; <CJK>
       (?$B`:(B . "0x72A7")  ;; <CJK>
       (?$B`;(B . "0x72B9")  ;; <CJK>
       (?$B`<(B . "0x72B2")  ;; <CJK>
       (?$B`=(B . "0x72C3")  ;; <CJK>
       (?$B`>(B . "0x72C6")  ;; <CJK>
       (?$B`?(B . "0x72C4")  ;; <CJK>
       (?$B`@(B . "0x72CE")  ;; <CJK>
       (?$B`A(B . "0x72D2")  ;; <CJK>
       (?$B`B(B . "0x72E2")  ;; <CJK>
       (?$B`C(B . "0x72E0")  ;; <CJK>
       (?$B`D(B . "0x72E1")  ;; <CJK>
       (?$B`E(B . "0x72F9")  ;; <CJK>
       (?$B`F(B . "0x72F7")  ;; <CJK>
       (?$B`G(B . "0x500F")  ;; <CJK>
       (?$B`H(B . "0x7317")  ;; <CJK>
       (?$B`I(B . "0x730A")  ;; <CJK>
       (?$B`J(B . "0x731C")  ;; <CJK>
       (?$B`K(B . "0x7316")  ;; <CJK>
       (?$B`L(B . "0x731D")  ;; <CJK>
       (?$B`M(B . "0x7334")  ;; <CJK>
       (?$B`N(B . "0x732F")  ;; <CJK>
       (?$B`O(B . "0x7329")  ;; <CJK>
       (?$B`P(B . "0x7325")  ;; <CJK>
       (?$B`Q(B . "0x733E")  ;; <CJK>
       (?$B`R(B . "0x734E")  ;; <CJK>
       (?$B`S(B . "0x734F")  ;; <CJK>
       (?$B`T(B . "0x9ED8")  ;; <CJK>
       (?$B`U(B . "0x7357")  ;; <CJK>
       (?$B`V(B . "0x736A")  ;; <CJK>
       (?$B`W(B . "0x7368")  ;; <CJK>
       (?$B`X(B . "0x7370")  ;; <CJK>
       (?$B`Y(B . "0x7378")  ;; <CJK>
       (?$B`Z(B . "0x7375")  ;; <CJK>
       (?$B`[(B . "0x737B")  ;; <CJK>
       (?$B`\(B . "0x737A")  ;; <CJK>
       (?$B`](B . "0x73C8")  ;; <CJK>
       (?$B`^(B . "0x73B3")  ;; <CJK>
       (?$B`_(B . "0x73CE")  ;; <CJK>
       (?$B``(B . "0x73BB")  ;; <CJK>
       (?$B`a(B . "0x73C0")  ;; <CJK>
       (?$B`b(B . "0x73E5")  ;; <CJK>
       (?$B`c(B . "0x73EE")  ;; <CJK>
       (?$B`d(B . "0x73DE")  ;; <CJK>
       (?$B`e(B . "0x74A2")  ;; <CJK>
       (?$B`f(B . "0x7405")  ;; <CJK>
       (?$B`g(B . "0x746F")  ;; <CJK>
       (?$B`h(B . "0x7425")  ;; <CJK>
       (?$B`i(B . "0x73F8")  ;; <CJK>
       (?$B`j(B . "0x7432")  ;; <CJK>
       (?$B`k(B . "0x743A")  ;; <CJK>
       (?$B`l(B . "0x7455")  ;; <CJK>
       (?$B`m(B . "0x743F")  ;; <CJK>
       (?$B`n(B . "0x745F")  ;; <CJK>
       (?$B`o(B . "0x7459")  ;; <CJK>
       (?$B`p(B . "0x7441")  ;; <CJK>
       (?$B`q(B . "0x745C")  ;; <CJK>
       (?$B`r(B . "0x7469")  ;; <CJK>
       (?$B`s(B . "0x7470")  ;; <CJK>
       (?$B`t(B . "0x7463")  ;; <CJK>
       (?$B`u(B . "0x746A")  ;; <CJK>
       (?$B`v(B . "0x7476")  ;; <CJK>
       (?$B`w(B . "0x747E")  ;; <CJK>
       (?$B`x(B . "0x748B")  ;; <CJK>
       (?$B`y(B . "0x749E")  ;; <CJK>
       (?$B`z(B . "0x74A7")  ;; <CJK>
       (?$B`{(B . "0x74CA")  ;; <CJK>
       (?$B`|(B . "0x74CF")  ;; <CJK>
       (?$B`}(B . "0x74D4")  ;; <CJK>
       (?$B`~(B . "0x73F1")  ;; <CJK>
       (?$Ba!(B . "0x74E0")  ;; <CJK>
       (?$Ba"(B . "0x74E3")  ;; <CJK>
       (?$Ba#(B . "0x74E7")  ;; <CJK>
       (?$Ba$(B . "0x74E9")  ;; <CJK>
       (?$Ba%(B . "0x74EE")  ;; <CJK>
       (?$Ba&(B . "0x74F2")  ;; <CJK>
       (?$Ba'(B . "0x74F0")  ;; <CJK>
       (?$Ba((B . "0x74F1")  ;; <CJK>
       (?$Ba)(B . "0x74F8")  ;; <CJK>
       (?$Ba*(B . "0x74F7")  ;; <CJK>
       (?$Ba+(B . "0x7504")  ;; <CJK>
       (?$Ba,(B . "0x7503")  ;; <CJK>
       (?$Ba-(B . "0x7505")  ;; <CJK>
       (?$Ba.(B . "0x750C")  ;; <CJK>
       (?$Ba/(B . "0x750E")  ;; <CJK>
       (?$Ba0(B . "0x750D")  ;; <CJK>
       (?$Ba1(B . "0x7515")  ;; <CJK>
       (?$Ba2(B . "0x7513")  ;; <CJK>
       (?$Ba3(B . "0x751E")  ;; <CJK>
       (?$Ba4(B . "0x7526")  ;; <CJK>
       (?$Ba5(B . "0x752C")  ;; <CJK>
       (?$Ba6(B . "0x753C")  ;; <CJK>
       (?$Ba7(B . "0x7544")  ;; <CJK>
       (?$Ba8(B . "0x754D")  ;; <CJK>
       (?$Ba9(B . "0x754A")  ;; <CJK>
       (?$Ba:(B . "0x7549")  ;; <CJK>
       (?$Ba;(B . "0x755B")  ;; <CJK>
       (?$Ba<(B . "0x7546")  ;; <CJK>
       (?$Ba=(B . "0x755A")  ;; <CJK>
       (?$Ba>(B . "0x7569")  ;; <CJK>
       (?$Ba?(B . "0x7564")  ;; <CJK>
       (?$Ba@(B . "0x7567")  ;; <CJK>
       (?$BaA(B . "0x756B")  ;; <CJK>
       (?$BaB(B . "0x756D")  ;; <CJK>
       (?$BaC(B . "0x7578")  ;; <CJK>
       (?$BaD(B . "0x7576")  ;; <CJK>
       (?$BaE(B . "0x7586")  ;; <CJK>
       (?$BaF(B . "0x7587")  ;; <CJK>
       (?$BaG(B . "0x7574")  ;; <CJK>
       (?$BaH(B . "0x758A")  ;; <CJK>
       (?$BaI(B . "0x7589")  ;; <CJK>
       (?$BaJ(B . "0x7582")  ;; <CJK>
       (?$BaK(B . "0x7594")  ;; <CJK>
       (?$BaL(B . "0x759A")  ;; <CJK>
       (?$BaM(B . "0x759D")  ;; <CJK>
       (?$BaN(B . "0x75A5")  ;; <CJK>
       (?$BaO(B . "0x75A3")  ;; <CJK>
       (?$BaP(B . "0x75C2")  ;; <CJK>
       (?$BaQ(B . "0x75B3")  ;; <CJK>
       (?$BaR(B . "0x75C3")  ;; <CJK>
       (?$BaS(B . "0x75B5")  ;; <CJK>
       (?$BaT(B . "0x75BD")  ;; <CJK>
       (?$BaU(B . "0x75B8")  ;; <CJK>
       (?$BaV(B . "0x75BC")  ;; <CJK>
       (?$BaW(B . "0x75B1")  ;; <CJK>
       (?$BaX(B . "0x75CD")  ;; <CJK>
       (?$BaY(B . "0x75CA")  ;; <CJK>
       (?$BaZ(B . "0x75D2")  ;; <CJK>
       (?$Ba[(B . "0x75D9")  ;; <CJK>
       (?$Ba\(B . "0x75E3")  ;; <CJK>
       (?$Ba](B . "0x75DE")  ;; <CJK>
       (?$Ba^(B . "0x75FE")  ;; <CJK>
       (?$Ba_(B . "0x75FF")  ;; <CJK>
       (?$Ba`(B . "0x75FC")  ;; <CJK>
       (?$Baa(B . "0x7601")  ;; <CJK>
       (?$Bab(B . "0x75F0")  ;; <CJK>
       (?$Bac(B . "0x75FA")  ;; <CJK>
       (?$Bad(B . "0x75F2")  ;; <CJK>
       (?$Bae(B . "0x75F3")  ;; <CJK>
       (?$Baf(B . "0x760B")  ;; <CJK>
       (?$Bag(B . "0x760D")  ;; <CJK>
       (?$Bah(B . "0x7609")  ;; <CJK>
       (?$Bai(B . "0x761F")  ;; <CJK>
       (?$Baj(B . "0x7627")  ;; <CJK>
       (?$Bak(B . "0x7620")  ;; <CJK>
       (?$Bal(B . "0x7621")  ;; <CJK>
       (?$Bam(B . "0x7622")  ;; <CJK>
       (?$Ban(B . "0x7624")  ;; <CJK>
       (?$Bao(B . "0x7634")  ;; <CJK>
       (?$Bap(B . "0x7630")  ;; <CJK>
       (?$Baq(B . "0x763B")  ;; <CJK>
       (?$Bar(B . "0x7647")  ;; <CJK>
       (?$Bas(B . "0x7648")  ;; <CJK>
       (?$Bat(B . "0x7646")  ;; <CJK>
       (?$Bau(B . "0x765C")  ;; <CJK>
       (?$Bav(B . "0x7658")  ;; <CJK>
       (?$Baw(B . "0x7661")  ;; <CJK>
       (?$Bax(B . "0x7662")  ;; <CJK>
       (?$Bay(B . "0x7668")  ;; <CJK>
       (?$Baz(B . "0x7669")  ;; <CJK>
       (?$Ba{(B . "0x766A")  ;; <CJK>
       (?$Ba|(B . "0x7667")  ;; <CJK>
       (?$Ba}(B . "0x766C")  ;; <CJK>
       (?$Ba~(B . "0x7670")  ;; <CJK>
       (?$Bb!(B . "0x7672")  ;; <CJK>
       (?$Bb"(B . "0x7676")  ;; <CJK>
       (?$Bb#(B . "0x7678")  ;; <CJK>
       (?$Bb$(B . "0x767C")  ;; <CJK>
       (?$Bb%(B . "0x7680")  ;; <CJK>
       (?$Bb&(B . "0x7683")  ;; <CJK>
       (?$Bb'(B . "0x7688")  ;; <CJK>
       (?$Bb((B . "0x768B")  ;; <CJK>
       (?$Bb)(B . "0x768E")  ;; <CJK>
       (?$Bb*(B . "0x7696")  ;; <CJK>
       (?$Bb+(B . "0x7693")  ;; <CJK>
       (?$Bb,(B . "0x7699")  ;; <CJK>
       (?$Bb-(B . "0x769A")  ;; <CJK>
       (?$Bb.(B . "0x76B0")  ;; <CJK>
       (?$Bb/(B . "0x76B4")  ;; <CJK>
       (?$Bb0(B . "0x76B8")  ;; <CJK>
       (?$Bb1(B . "0x76B9")  ;; <CJK>
       (?$Bb2(B . "0x76BA")  ;; <CJK>
       (?$Bb3(B . "0x76C2")  ;; <CJK>
       (?$Bb4(B . "0x76CD")  ;; <CJK>
       (?$Bb5(B . "0x76D6")  ;; <CJK>
       (?$Bb6(B . "0x76D2")  ;; <CJK>
       (?$Bb7(B . "0x76DE")  ;; <CJK>
       (?$Bb8(B . "0x76E1")  ;; <CJK>
       (?$Bb9(B . "0x76E5")  ;; <CJK>
       (?$Bb:(B . "0x76E7")  ;; <CJK>
       (?$Bb;(B . "0x76EA")  ;; <CJK>
       (?$Bb<(B . "0x862F")  ;; <CJK>
       (?$Bb=(B . "0x76FB")  ;; <CJK>
       (?$Bb>(B . "0x7708")  ;; <CJK>
       (?$Bb?(B . "0x7707")  ;; <CJK>
       (?$Bb@(B . "0x7704")  ;; <CJK>
       (?$BbA(B . "0x7729")  ;; <CJK>
       (?$BbB(B . "0x7724")  ;; <CJK>
       (?$BbC(B . "0x771E")  ;; <CJK>
       (?$BbD(B . "0x7725")  ;; <CJK>
       (?$BbE(B . "0x7726")  ;; <CJK>
       (?$BbF(B . "0x771B")  ;; <CJK>
       (?$BbG(B . "0x7737")  ;; <CJK>
       (?$BbH(B . "0x7738")  ;; <CJK>
       (?$BbI(B . "0x7747")  ;; <CJK>
       (?$BbJ(B . "0x775A")  ;; <CJK>
       (?$BbK(B . "0x7768")  ;; <CJK>
       (?$BbL(B . "0x776B")  ;; <CJK>
       (?$BbM(B . "0x775B")  ;; <CJK>
       (?$BbN(B . "0x7765")  ;; <CJK>
       (?$BbO(B . "0x777F")  ;; <CJK>
       (?$BbP(B . "0x777E")  ;; <CJK>
       (?$BbQ(B . "0x7779")  ;; <CJK>
       (?$BbR(B . "0x778E")  ;; <CJK>
       (?$BbS(B . "0x778B")  ;; <CJK>
       (?$BbT(B . "0x7791")  ;; <CJK>
       (?$BbU(B . "0x77A0")  ;; <CJK>
       (?$BbV(B . "0x779E")  ;; <CJK>
       (?$BbW(B . "0x77B0")  ;; <CJK>
       (?$BbX(B . "0x77B6")  ;; <CJK>
       (?$BbY(B . "0x77B9")  ;; <CJK>
       (?$BbZ(B . "0x77BF")  ;; <CJK>
       (?$Bb[(B . "0x77BC")  ;; <CJK>
       (?$Bb\(B . "0x77BD")  ;; <CJK>
       (?$Bb](B . "0x77BB")  ;; <CJK>
       (?$Bb^(B . "0x77C7")  ;; <CJK>
       (?$Bb_(B . "0x77CD")  ;; <CJK>
       (?$Bb`(B . "0x77D7")  ;; <CJK>
       (?$Bba(B . "0x77DA")  ;; <CJK>
       (?$Bbb(B . "0x77DC")  ;; <CJK>
       (?$Bbc(B . "0x77E3")  ;; <CJK>
       (?$Bbd(B . "0x77EE")  ;; <CJK>
       (?$Bbe(B . "0x77FC")  ;; <CJK>
       (?$Bbf(B . "0x780C")  ;; <CJK>
       (?$Bbg(B . "0x7812")  ;; <CJK>
       (?$Bbh(B . "0x7926")  ;; <CJK>
       (?$Bbi(B . "0x7820")  ;; <CJK>
       (?$Bbj(B . "0x792A")  ;; <CJK>
       (?$Bbk(B . "0x7845")  ;; <CJK>
       (?$Bbl(B . "0x788E")  ;; <CJK>
       (?$Bbm(B . "0x7874")  ;; <CJK>
       (?$Bbn(B . "0x7886")  ;; <CJK>
       (?$Bbo(B . "0x787C")  ;; <CJK>
       (?$Bbp(B . "0x789A")  ;; <CJK>
       (?$Bbq(B . "0x788C")  ;; <CJK>
       (?$Bbr(B . "0x78A3")  ;; <CJK>
       (?$Bbs(B . "0x78B5")  ;; <CJK>
       (?$Bbt(B . "0x78AA")  ;; <CJK>
       (?$Bbu(B . "0x78AF")  ;; <CJK>
       (?$Bbv(B . "0x78D1")  ;; <CJK>
       (?$Bbw(B . "0x78C6")  ;; <CJK>
       (?$Bbx(B . "0x78CB")  ;; <CJK>
       (?$Bby(B . "0x78D4")  ;; <CJK>
       (?$Bbz(B . "0x78BE")  ;; <CJK>
       (?$Bb{(B . "0x78BC")  ;; <CJK>
       (?$Bb|(B . "0x78C5")  ;; <CJK>
       (?$Bb}(B . "0x78CA")  ;; <CJK>
       (?$Bb~(B . "0x78EC")  ;; <CJK>
       (?$Bc!(B . "0x78E7")  ;; <CJK>
       (?$Bc"(B . "0x78DA")  ;; <CJK>
       (?$Bc#(B . "0x78FD")  ;; <CJK>
       (?$Bc$(B . "0x78F4")  ;; <CJK>
       (?$Bc%(B . "0x7907")  ;; <CJK>
       (?$Bc&(B . "0x7912")  ;; <CJK>
       (?$Bc'(B . "0x7911")  ;; <CJK>
       (?$Bc((B . "0x7919")  ;; <CJK>
       (?$Bc)(B . "0x792C")  ;; <CJK>
       (?$Bc*(B . "0x792B")  ;; <CJK>
       (?$Bc+(B . "0x7940")  ;; <CJK>
       (?$Bc,(B . "0x7960")  ;; <CJK>
       (?$Bc-(B . "0x7957")  ;; <CJK>
       (?$Bc.(B . "0x795F")  ;; <CJK>
       (?$Bc/(B . "0x795A")  ;; <CJK>
       (?$Bc0(B . "0x7955")  ;; <CJK>
       (?$Bc1(B . "0x7953")  ;; <CJK>
       (?$Bc2(B . "0x797A")  ;; <CJK>
       (?$Bc3(B . "0x797F")  ;; <CJK>
       (?$Bc4(B . "0x798A")  ;; <CJK>
       (?$Bc5(B . "0x799D")  ;; <CJK>
       (?$Bc6(B . "0x79A7")  ;; <CJK>
       (?$Bc7(B . "0x9F4B")  ;; <CJK>
       (?$Bc8(B . "0x79AA")  ;; <CJK>
       (?$Bc9(B . "0x79AE")  ;; <CJK>
       (?$Bc:(B . "0x79B3")  ;; <CJK>
       (?$Bc;(B . "0x79B9")  ;; <CJK>
       (?$Bc<(B . "0x79BA")  ;; <CJK>
       (?$Bc=(B . "0x79C9")  ;; <CJK>
       (?$Bc>(B . "0x79D5")  ;; <CJK>
       (?$Bc?(B . "0x79E7")  ;; <CJK>
       (?$Bc@(B . "0x79EC")  ;; <CJK>
       (?$BcA(B . "0x79E1")  ;; <CJK>
       (?$BcB(B . "0x79E3")  ;; <CJK>
       (?$BcC(B . "0x7A08")  ;; <CJK>
       (?$BcD(B . "0x7A0D")  ;; <CJK>
       (?$BcE(B . "0x7A18")  ;; <CJK>
       (?$BcF(B . "0x7A19")  ;; <CJK>
       (?$BcG(B . "0x7A20")  ;; <CJK>
       (?$BcH(B . "0x7A1F")  ;; <CJK>
       (?$BcI(B . "0x7980")  ;; <CJK>
       (?$BcJ(B . "0x7A31")  ;; <CJK>
       (?$BcK(B . "0x7A3B")  ;; <CJK>
       (?$BcL(B . "0x7A3E")  ;; <CJK>
       (?$BcM(B . "0x7A37")  ;; <CJK>
       (?$BcN(B . "0x7A43")  ;; <CJK>
       (?$BcO(B . "0x7A57")  ;; <CJK>
       (?$BcP(B . "0x7A49")  ;; <CJK>
       (?$BcQ(B . "0x7A61")  ;; <CJK>
       (?$BcR(B . "0x7A62")  ;; <CJK>
       (?$BcS(B . "0x7A69")  ;; <CJK>
       (?$BcT(B . "0x9F9D")  ;; <CJK>
       (?$BcU(B . "0x7A70")  ;; <CJK>
       (?$BcV(B . "0x7A79")  ;; <CJK>
       (?$BcW(B . "0x7A7D")  ;; <CJK>
       (?$BcX(B . "0x7A88")  ;; <CJK>
       (?$BcY(B . "0x7A97")  ;; <CJK>
       (?$BcZ(B . "0x7A95")  ;; <CJK>
       (?$Bc[(B . "0x7A98")  ;; <CJK>
       (?$Bc\(B . "0x7A96")  ;; <CJK>
       (?$Bc](B . "0x7AA9")  ;; <CJK>
       (?$Bc^(B . "0x7AC8")  ;; <CJK>
       (?$Bc_(B . "0x7AB0")  ;; <CJK>
       (?$Bc`(B . "0x7AB6")  ;; <CJK>
       (?$Bca(B . "0x7AC5")  ;; <CJK>
       (?$Bcb(B . "0x7AC4")  ;; <CJK>
       (?$Bcc(B . "0x7ABF")  ;; <CJK>
       (?$Bcd(B . "0x9083")  ;; <CJK>
       (?$Bce(B . "0x7AC7")  ;; <CJK>
       (?$Bcf(B . "0x7ACA")  ;; <CJK>
       (?$Bcg(B . "0x7ACD")  ;; <CJK>
       (?$Bch(B . "0x7ACF")  ;; <CJK>
       (?$Bci(B . "0x7AD5")  ;; <CJK>
       (?$Bcj(B . "0x7AD3")  ;; <CJK>
       (?$Bck(B . "0x7AD9")  ;; <CJK>
       (?$Bcl(B . "0x7ADA")  ;; <CJK>
       (?$Bcm(B . "0x7ADD")  ;; <CJK>
       (?$Bcn(B . "0x7AE1")  ;; <CJK>
       (?$Bco(B . "0x7AE2")  ;; <CJK>
       (?$Bcp(B . "0x7AE6")  ;; <CJK>
       (?$Bcq(B . "0x7AED")  ;; <CJK>
       (?$Bcr(B . "0x7AF0")  ;; <CJK>
       (?$Bcs(B . "0x7B02")  ;; <CJK>
       (?$Bct(B . "0x7B0F")  ;; <CJK>
       (?$Bcu(B . "0x7B0A")  ;; <CJK>
       (?$Bcv(B . "0x7B06")  ;; <CJK>
       (?$Bcw(B . "0x7B33")  ;; <CJK>
       (?$Bcx(B . "0x7B18")  ;; <CJK>
       (?$Bcy(B . "0x7B19")  ;; <CJK>
       (?$Bcz(B . "0x7B1E")  ;; <CJK>
       (?$Bc{(B . "0x7B35")  ;; <CJK>
       (?$Bc|(B . "0x7B28")  ;; <CJK>
       (?$Bc}(B . "0x7B36")  ;; <CJK>
       (?$Bc~(B . "0x7B50")  ;; <CJK>
       (?$Bd!(B . "0x7B7A")  ;; <CJK>
       (?$Bd"(B . "0x7B04")  ;; <CJK>
       (?$Bd#(B . "0x7B4D")  ;; <CJK>
       (?$Bd$(B . "0x7B0B")  ;; <CJK>
       (?$Bd%(B . "0x7B4C")  ;; <CJK>
       (?$Bd&(B . "0x7B45")  ;; <CJK>
       (?$Bd'(B . "0x7B75")  ;; <CJK>
       (?$Bd((B . "0x7B65")  ;; <CJK>
       (?$Bd)(B . "0x7B74")  ;; <CJK>
       (?$Bd*(B . "0x7B67")  ;; <CJK>
       (?$Bd+(B . "0x7B70")  ;; <CJK>
       (?$Bd,(B . "0x7B71")  ;; <CJK>
       (?$Bd-(B . "0x7B6C")  ;; <CJK>
       (?$Bd.(B . "0x7B6E")  ;; <CJK>
       (?$Bd/(B . "0x7B9D")  ;; <CJK>
       (?$Bd0(B . "0x7B98")  ;; <CJK>
       (?$Bd1(B . "0x7B9F")  ;; <CJK>
       (?$Bd2(B . "0x7B8D")  ;; <CJK>
       (?$Bd3(B . "0x7B9C")  ;; <CJK>
       (?$Bd4(B . "0x7B9A")  ;; <CJK>
       (?$Bd5(B . "0x7B8B")  ;; <CJK>
       (?$Bd6(B . "0x7B92")  ;; <CJK>
       (?$Bd7(B . "0x7B8F")  ;; <CJK>
       (?$Bd8(B . "0x7B5D")  ;; <CJK>
       (?$Bd9(B . "0x7B99")  ;; <CJK>
       (?$Bd:(B . "0x7BCB")  ;; <CJK>
       (?$Bd;(B . "0x7BC1")  ;; <CJK>
       (?$Bd<(B . "0x7BCC")  ;; <CJK>
       (?$Bd=(B . "0x7BCF")  ;; <CJK>
       (?$Bd>(B . "0x7BB4")  ;; <CJK>
       (?$Bd?(B . "0x7BC6")  ;; <CJK>
       (?$Bd@(B . "0x7BDD")  ;; <CJK>
       (?$BdA(B . "0x7BE9")  ;; <CJK>
       (?$BdB(B . "0x7C11")  ;; <CJK>
       (?$BdC(B . "0x7C14")  ;; <CJK>
       (?$BdD(B . "0x7BE6")  ;; <CJK>
       (?$BdE(B . "0x7BE5")  ;; <CJK>
       (?$BdF(B . "0x7C60")  ;; <CJK>
       (?$BdG(B . "0x7C00")  ;; <CJK>
       (?$BdH(B . "0x7C07")  ;; <CJK>
       (?$BdI(B . "0x7C13")  ;; <CJK>
       (?$BdJ(B . "0x7BF3")  ;; <CJK>
       (?$BdK(B . "0x7BF7")  ;; <CJK>
       (?$BdL(B . "0x7C17")  ;; <CJK>
       (?$BdM(B . "0x7C0D")  ;; <CJK>
       (?$BdN(B . "0x7BF6")  ;; <CJK>
       (?$BdO(B . "0x7C23")  ;; <CJK>
       (?$BdP(B . "0x7C27")  ;; <CJK>
       (?$BdQ(B . "0x7C2A")  ;; <CJK>
       (?$BdR(B . "0x7C1F")  ;; <CJK>
       (?$BdS(B . "0x7C37")  ;; <CJK>
       (?$BdT(B . "0x7C2B")  ;; <CJK>
       (?$BdU(B . "0x7C3D")  ;; <CJK>
       (?$BdV(B . "0x7C4C")  ;; <CJK>
       (?$BdW(B . "0x7C43")  ;; <CJK>
       (?$BdX(B . "0x7C54")  ;; <CJK>
       (?$BdY(B . "0x7C4F")  ;; <CJK>
       (?$BdZ(B . "0x7C40")  ;; <CJK>
       (?$Bd[(B . "0x7C50")  ;; <CJK>
       (?$Bd\(B . "0x7C58")  ;; <CJK>
       (?$Bd](B . "0x7C5F")  ;; <CJK>
       (?$Bd^(B . "0x7C64")  ;; <CJK>
       (?$Bd_(B . "0x7C56")  ;; <CJK>
       (?$Bd`(B . "0x7C65")  ;; <CJK>
       (?$Bda(B . "0x7C6C")  ;; <CJK>
       (?$Bdb(B . "0x7C75")  ;; <CJK>
       (?$Bdc(B . "0x7C83")  ;; <CJK>
       (?$Bdd(B . "0x7C90")  ;; <CJK>
       (?$Bde(B . "0x7CA4")  ;; <CJK>
       (?$Bdf(B . "0x7CAD")  ;; <CJK>
       (?$Bdg(B . "0x7CA2")  ;; <CJK>
       (?$Bdh(B . "0x7CAB")  ;; <CJK>
       (?$Bdi(B . "0x7CA1")  ;; <CJK>
       (?$Bdj(B . "0x7CA8")  ;; <CJK>
       (?$Bdk(B . "0x7CB3")  ;; <CJK>
       (?$Bdl(B . "0x7CB2")  ;; <CJK>
       (?$Bdm(B . "0x7CB1")  ;; <CJK>
       (?$Bdn(B . "0x7CAE")  ;; <CJK>
       (?$Bdo(B . "0x7CB9")  ;; <CJK>
       (?$Bdp(B . "0x7CBD")  ;; <CJK>
       (?$Bdq(B . "0x7CC0")  ;; <CJK>
       (?$Bdr(B . "0x7CC5")  ;; <CJK>
       (?$Bds(B . "0x7CC2")  ;; <CJK>
       (?$Bdt(B . "0x7CD8")  ;; <CJK>
       (?$Bdu(B . "0x7CD2")  ;; <CJK>
       (?$Bdv(B . "0x7CDC")  ;; <CJK>
       (?$Bdw(B . "0x7CE2")  ;; <CJK>
       (?$Bdx(B . "0x9B3B")  ;; <CJK>
       (?$Bdy(B . "0x7CEF")  ;; <CJK>
       (?$Bdz(B . "0x7CF2")  ;; <CJK>
       (?$Bd{(B . "0x7CF4")  ;; <CJK>
       (?$Bd|(B . "0x7CF6")  ;; <CJK>
       (?$Bd}(B . "0x7CFA")  ;; <CJK>
       (?$Bd~(B . "0x7D06")  ;; <CJK>
       (?$Be!(B . "0x7D02")  ;; <CJK>
       (?$Be"(B . "0x7D1C")  ;; <CJK>
       (?$Be#(B . "0x7D15")  ;; <CJK>
       (?$Be$(B . "0x7D0A")  ;; <CJK>
       (?$Be%(B . "0x7D45")  ;; <CJK>
       (?$Be&(B . "0x7D4B")  ;; <CJK>
       (?$Be'(B . "0x7D2E")  ;; <CJK>
       (?$Be((B . "0x7D32")  ;; <CJK>
       (?$Be)(B . "0x7D3F")  ;; <CJK>
       (?$Be*(B . "0x7D35")  ;; <CJK>
       (?$Be+(B . "0x7D46")  ;; <CJK>
       (?$Be,(B . "0x7D73")  ;; <CJK>
       (?$Be-(B . "0x7D56")  ;; <CJK>
       (?$Be.(B . "0x7D4E")  ;; <CJK>
       (?$Be/(B . "0x7D72")  ;; <CJK>
       (?$Be0(B . "0x7D68")  ;; <CJK>
       (?$Be1(B . "0x7D6E")  ;; <CJK>
       (?$Be2(B . "0x7D4F")  ;; <CJK>
       (?$Be3(B . "0x7D63")  ;; <CJK>
       (?$Be4(B . "0x7D93")  ;; <CJK>
       (?$Be5(B . "0x7D89")  ;; <CJK>
       (?$Be6(B . "0x7D5B")  ;; <CJK>
       (?$Be7(B . "0x7D8F")  ;; <CJK>
       (?$Be8(B . "0x7D7D")  ;; <CJK>
       (?$Be9(B . "0x7D9B")  ;; <CJK>
       (?$Be:(B . "0x7DBA")  ;; <CJK>
       (?$Be;(B . "0x7DAE")  ;; <CJK>
       (?$Be<(B . "0x7DA3")  ;; <CJK>
       (?$Be=(B . "0x7DB5")  ;; <CJK>
       (?$Be>(B . "0x7DC7")  ;; <CJK>
       (?$Be?(B . "0x7DBD")  ;; <CJK>
       (?$Be@(B . "0x7DAB")  ;; <CJK>
       (?$BeA(B . "0x7E3D")  ;; <CJK>
       (?$BeB(B . "0x7DA2")  ;; <CJK>
       (?$BeC(B . "0x7DAF")  ;; <CJK>
       (?$BeD(B . "0x7DDC")  ;; <CJK>
       (?$BeE(B . "0x7DB8")  ;; <CJK>
       (?$BeF(B . "0x7D9F")  ;; <CJK>
       (?$BeG(B . "0x7DB0")  ;; <CJK>
       (?$BeH(B . "0x7DD8")  ;; <CJK>
       (?$BeI(B . "0x7DDD")  ;; <CJK>
       (?$BeJ(B . "0x7DE4")  ;; <CJK>
       (?$BeK(B . "0x7DDE")  ;; <CJK>
       (?$BeL(B . "0x7DFB")  ;; <CJK>
       (?$BeM(B . "0x7DF2")  ;; <CJK>
       (?$BeN(B . "0x7DE1")  ;; <CJK>
       (?$BeO(B . "0x7E05")  ;; <CJK>
       (?$BeP(B . "0x7E0A")  ;; <CJK>
       (?$BeQ(B . "0x7E23")  ;; <CJK>
       (?$BeR(B . "0x7E21")  ;; <CJK>
       (?$BeS(B . "0x7E12")  ;; <CJK>
       (?$BeT(B . "0x7E31")  ;; <CJK>
       (?$BeU(B . "0x7E1F")  ;; <CJK>
       (?$BeV(B . "0x7E09")  ;; <CJK>
       (?$BeW(B . "0x7E0B")  ;; <CJK>
       (?$BeX(B . "0x7E22")  ;; <CJK>
       (?$BeY(B . "0x7E46")  ;; <CJK>
       (?$BeZ(B . "0x7E66")  ;; <CJK>
       (?$Be[(B . "0x7E3B")  ;; <CJK>
       (?$Be\(B . "0x7E35")  ;; <CJK>
       (?$Be](B . "0x7E39")  ;; <CJK>
       (?$Be^(B . "0x7E43")  ;; <CJK>
       (?$Be_(B . "0x7E37")  ;; <CJK>
       (?$Be`(B . "0x7E32")  ;; <CJK>
       (?$Bea(B . "0x7E3A")  ;; <CJK>
       (?$Beb(B . "0x7E67")  ;; <CJK>
       (?$Bec(B . "0x7E5D")  ;; <CJK>
       (?$Bed(B . "0x7E56")  ;; <CJK>
       (?$Bee(B . "0x7E5E")  ;; <CJK>
       (?$Bef(B . "0x7E59")  ;; <CJK>
       (?$Beg(B . "0x7E5A")  ;; <CJK>
       (?$Beh(B . "0x7E79")  ;; <CJK>
       (?$Bei(B . "0x7E6A")  ;; <CJK>
       (?$Bej(B . "0x7E69")  ;; <CJK>
       (?$Bek(B . "0x7E7C")  ;; <CJK>
       (?$Bel(B . "0x7E7B")  ;; <CJK>
       (?$Bem(B . "0x7E83")  ;; <CJK>
       (?$Ben(B . "0x7DD5")  ;; <CJK>
       (?$Beo(B . "0x7E7D")  ;; <CJK>
       (?$Bep(B . "0x8FAE")  ;; <CJK>
       (?$Beq(B . "0x7E7F")  ;; <CJK>
       (?$Ber(B . "0x7E88")  ;; <CJK>
       (?$Bes(B . "0x7E89")  ;; <CJK>
       (?$Bet(B . "0x7E8C")  ;; <CJK>
       (?$Beu(B . "0x7E92")  ;; <CJK>
       (?$Bev(B . "0x7E90")  ;; <CJK>
       (?$Bew(B . "0x7E93")  ;; <CJK>
       (?$Bex(B . "0x7E94")  ;; <CJK>
       (?$Bey(B . "0x7E96")  ;; <CJK>
       (?$Bez(B . "0x7E8E")  ;; <CJK>
       (?$Be{(B . "0x7E9B")  ;; <CJK>
       (?$Be|(B . "0x7E9C")  ;; <CJK>
       (?$Be}(B . "0x7F38")  ;; <CJK>
       (?$Be~(B . "0x7F3A")  ;; <CJK>
       (?$Bf!(B . "0x7F45")  ;; <CJK>
       (?$Bf"(B . "0x7F4C")  ;; <CJK>
       (?$Bf#(B . "0x7F4D")  ;; <CJK>
       (?$Bf$(B . "0x7F4E")  ;; <CJK>
       (?$Bf%(B . "0x7F50")  ;; <CJK>
       (?$Bf&(B . "0x7F51")  ;; <CJK>
       (?$Bf'(B . "0x7F55")  ;; <CJK>
       (?$Bf((B . "0x7F54")  ;; <CJK>
       (?$Bf)(B . "0x7F58")  ;; <CJK>
       (?$Bf*(B . "0x7F5F")  ;; <CJK>
       (?$Bf+(B . "0x7F60")  ;; <CJK>
       (?$Bf,(B . "0x7F68")  ;; <CJK>
       (?$Bf-(B . "0x7F69")  ;; <CJK>
       (?$Bf.(B . "0x7F67")  ;; <CJK>
       (?$Bf/(B . "0x7F78")  ;; <CJK>
       (?$Bf0(B . "0x7F82")  ;; <CJK>
       (?$Bf1(B . "0x7F86")  ;; <CJK>
       (?$Bf2(B . "0x7F83")  ;; <CJK>
       (?$Bf3(B . "0x7F88")  ;; <CJK>
       (?$Bf4(B . "0x7F87")  ;; <CJK>
       (?$Bf5(B . "0x7F8C")  ;; <CJK>
       (?$Bf6(B . "0x7F94")  ;; <CJK>
       (?$Bf7(B . "0x7F9E")  ;; <CJK>
       (?$Bf8(B . "0x7F9D")  ;; <CJK>
       (?$Bf9(B . "0x7F9A")  ;; <CJK>
       (?$Bf:(B . "0x7FA3")  ;; <CJK>
       (?$Bf;(B . "0x7FAF")  ;; <CJK>
       (?$Bf<(B . "0x7FB2")  ;; <CJK>
       (?$Bf=(B . "0x7FB9")  ;; <CJK>
       (?$Bf>(B . "0x7FAE")  ;; <CJK>
       (?$Bf?(B . "0x7FB6")  ;; <CJK>
       (?$Bf@(B . "0x7FB8")  ;; <CJK>
       (?$BfA(B . "0x8B71")  ;; <CJK>
       (?$BfB(B . "0x7FC5")  ;; <CJK>
       (?$BfC(B . "0x7FC6")  ;; <CJK>
       (?$BfD(B . "0x7FCA")  ;; <CJK>
       (?$BfE(B . "0x7FD5")  ;; <CJK>
       (?$BfF(B . "0x7FD4")  ;; <CJK>
       (?$BfG(B . "0x7FE1")  ;; <CJK>
       (?$BfH(B . "0x7FE6")  ;; <CJK>
       (?$BfI(B . "0x7FE9")  ;; <CJK>
       (?$BfJ(B . "0x7FF3")  ;; <CJK>
       (?$BfK(B . "0x7FF9")  ;; <CJK>
       (?$BfL(B . "0x98DC")  ;; <CJK>
       (?$BfM(B . "0x8006")  ;; <CJK>
       (?$BfN(B . "0x8004")  ;; <CJK>
       (?$BfO(B . "0x800B")  ;; <CJK>
       (?$BfP(B . "0x8012")  ;; <CJK>
       (?$BfQ(B . "0x8018")  ;; <CJK>
       (?$BfR(B . "0x8019")  ;; <CJK>
       (?$BfS(B . "0x801C")  ;; <CJK>
       (?$BfT(B . "0x8021")  ;; <CJK>
       (?$BfU(B . "0x8028")  ;; <CJK>
       (?$BfV(B . "0x803F")  ;; <CJK>
       (?$BfW(B . "0x803B")  ;; <CJK>
       (?$BfX(B . "0x804A")  ;; <CJK>
       (?$BfY(B . "0x8046")  ;; <CJK>
       (?$BfZ(B . "0x8052")  ;; <CJK>
       (?$Bf[(B . "0x8058")  ;; <CJK>
       (?$Bf\(B . "0x805A")  ;; <CJK>
       (?$Bf](B . "0x805F")  ;; <CJK>
       (?$Bf^(B . "0x8062")  ;; <CJK>
       (?$Bf_(B . "0x8068")  ;; <CJK>
       (?$Bf`(B . "0x8073")  ;; <CJK>
       (?$Bfa(B . "0x8072")  ;; <CJK>
       (?$Bfb(B . "0x8070")  ;; <CJK>
       (?$Bfc(B . "0x8076")  ;; <CJK>
       (?$Bfd(B . "0x8079")  ;; <CJK>
       (?$Bfe(B . "0x807D")  ;; <CJK>
       (?$Bff(B . "0x807F")  ;; <CJK>
       (?$Bfg(B . "0x8084")  ;; <CJK>
       (?$Bfh(B . "0x8086")  ;; <CJK>
       (?$Bfi(B . "0x8085")  ;; <CJK>
       (?$Bfj(B . "0x809B")  ;; <CJK>
       (?$Bfk(B . "0x8093")  ;; <CJK>
       (?$Bfl(B . "0x809A")  ;; <CJK>
       (?$Bfm(B . "0x80AD")  ;; <CJK>
       (?$Bfn(B . "0x5190")  ;; <CJK>
       (?$Bfo(B . "0x80AC")  ;; <CJK>
       (?$Bfp(B . "0x80DB")  ;; <CJK>
       (?$Bfq(B . "0x80E5")  ;; <CJK>
       (?$Bfr(B . "0x80D9")  ;; <CJK>
       (?$Bfs(B . "0x80DD")  ;; <CJK>
       (?$Bft(B . "0x80C4")  ;; <CJK>
       (?$Bfu(B . "0x80DA")  ;; <CJK>
       (?$Bfv(B . "0x80D6")  ;; <CJK>
       (?$Bfw(B . "0x8109")  ;; <CJK>
       (?$Bfx(B . "0x80EF")  ;; <CJK>
       (?$Bfy(B . "0x80F1")  ;; <CJK>
       (?$Bfz(B . "0x811B")  ;; <CJK>
       (?$Bf{(B . "0x8129")  ;; <CJK>
       (?$Bf|(B . "0x8123")  ;; <CJK>
       (?$Bf}(B . "0x812F")  ;; <CJK>
       (?$Bf~(B . "0x814B")  ;; <CJK>
       (?$Bg!(B . "0x968B")  ;; <CJK>
       (?$Bg"(B . "0x8146")  ;; <CJK>
       (?$Bg#(B . "0x813E")  ;; <CJK>
       (?$Bg$(B . "0x8153")  ;; <CJK>
       (?$Bg%(B . "0x8151")  ;; <CJK>
       (?$Bg&(B . "0x80FC")  ;; <CJK>
       (?$Bg'(B . "0x8171")  ;; <CJK>
       (?$Bg((B . "0x816E")  ;; <CJK>
       (?$Bg)(B . "0x8165")  ;; <CJK>
       (?$Bg*(B . "0x8166")  ;; <CJK>
       (?$Bg+(B . "0x8174")  ;; <CJK>
       (?$Bg,(B . "0x8183")  ;; <CJK>
       (?$Bg-(B . "0x8188")  ;; <CJK>
       (?$Bg.(B . "0x818A")  ;; <CJK>
       (?$Bg/(B . "0x8180")  ;; <CJK>
       (?$Bg0(B . "0x8182")  ;; <CJK>
       (?$Bg1(B . "0x81A0")  ;; <CJK>
       (?$Bg2(B . "0x8195")  ;; <CJK>
       (?$Bg3(B . "0x81A4")  ;; <CJK>
       (?$Bg4(B . "0x81A3")  ;; <CJK>
       (?$Bg5(B . "0x815F")  ;; <CJK>
       (?$Bg6(B . "0x8193")  ;; <CJK>
       (?$Bg7(B . "0x81A9")  ;; <CJK>
       (?$Bg8(B . "0x81B0")  ;; <CJK>
       (?$Bg9(B . "0x81B5")  ;; <CJK>
       (?$Bg:(B . "0x81BE")  ;; <CJK>
       (?$Bg;(B . "0x81B8")  ;; <CJK>
       (?$Bg<(B . "0x81BD")  ;; <CJK>
       (?$Bg=(B . "0x81C0")  ;; <CJK>
       (?$Bg>(B . "0x81C2")  ;; <CJK>
       (?$Bg?(B . "0x81BA")  ;; <CJK>
       (?$Bg@(B . "0x81C9")  ;; <CJK>
       (?$BgA(B . "0x81CD")  ;; <CJK>
       (?$BgB(B . "0x81D1")  ;; <CJK>
       (?$BgC(B . "0x81D9")  ;; <CJK>
       (?$BgD(B . "0x81D8")  ;; <CJK>
       (?$BgE(B . "0x81C8")  ;; <CJK>
       (?$BgF(B . "0x81DA")  ;; <CJK>
       (?$BgG(B . "0x81DF")  ;; <CJK>
       (?$BgH(B . "0x81E0")  ;; <CJK>
       (?$BgI(B . "0x81E7")  ;; <CJK>
       (?$BgJ(B . "0x81FA")  ;; <CJK>
       (?$BgK(B . "0x81FB")  ;; <CJK>
       (?$BgL(B . "0x81FE")  ;; <CJK>
       (?$BgM(B . "0x8201")  ;; <CJK>
       (?$BgN(B . "0x8202")  ;; <CJK>
       (?$BgO(B . "0x8205")  ;; <CJK>
       (?$BgP(B . "0x8207")  ;; <CJK>
       (?$BgQ(B . "0x820A")  ;; <CJK>
       (?$BgR(B . "0x820D")  ;; <CJK>
       (?$BgS(B . "0x8210")  ;; <CJK>
       (?$BgT(B . "0x8216")  ;; <CJK>
       (?$BgU(B . "0x8229")  ;; <CJK>
       (?$BgV(B . "0x822B")  ;; <CJK>
       (?$BgW(B . "0x8238")  ;; <CJK>
       (?$BgX(B . "0x8233")  ;; <CJK>
       (?$BgY(B . "0x8240")  ;; <CJK>
       (?$BgZ(B . "0x8259")  ;; <CJK>
       (?$Bg[(B . "0x8258")  ;; <CJK>
       (?$Bg\(B . "0x825D")  ;; <CJK>
       (?$Bg](B . "0x825A")  ;; <CJK>
       (?$Bg^(B . "0x825F")  ;; <CJK>
       (?$Bg_(B . "0x8264")  ;; <CJK>
       (?$Bg`(B . "0x8262")  ;; <CJK>
       (?$Bga(B . "0x8268")  ;; <CJK>
       (?$Bgb(B . "0x826A")  ;; <CJK>
       (?$Bgc(B . "0x826B")  ;; <CJK>
       (?$Bgd(B . "0x822E")  ;; <CJK>
       (?$Bge(B . "0x8271")  ;; <CJK>
       (?$Bgf(B . "0x8277")  ;; <CJK>
       (?$Bgg(B . "0x8278")  ;; <CJK>
       (?$Bgh(B . "0x827E")  ;; <CJK>
       (?$Bgi(B . "0x828D")  ;; <CJK>
       (?$Bgj(B . "0x8292")  ;; <CJK>
       (?$Bgk(B . "0x82AB")  ;; <CJK>
       (?$Bgl(B . "0x829F")  ;; <CJK>
       (?$Bgm(B . "0x82BB")  ;; <CJK>
       (?$Bgn(B . "0x82AC")  ;; <CJK>
       (?$Bgo(B . "0x82E1")  ;; <CJK>
       (?$Bgp(B . "0x82E3")  ;; <CJK>
       (?$Bgq(B . "0x82DF")  ;; <CJK>
       (?$Bgr(B . "0x82D2")  ;; <CJK>
       (?$Bgs(B . "0x82F4")  ;; <CJK>
       (?$Bgt(B . "0x82F3")  ;; <CJK>
       (?$Bgu(B . "0x82FA")  ;; <CJK>
       (?$Bgv(B . "0x8393")  ;; <CJK>
       (?$Bgw(B . "0x8303")  ;; <CJK>
       (?$Bgx(B . "0x82FB")  ;; <CJK>
       (?$Bgy(B . "0x82F9")  ;; <CJK>
       (?$Bgz(B . "0x82DE")  ;; <CJK>
       (?$Bg{(B . "0x8306")  ;; <CJK>
       (?$Bg|(B . "0x82DC")  ;; <CJK>
       (?$Bg}(B . "0x8309")  ;; <CJK>
       (?$Bg~(B . "0x82D9")  ;; <CJK>
       (?$Bh!(B . "0x8335")  ;; <CJK>
       (?$Bh"(B . "0x8334")  ;; <CJK>
       (?$Bh#(B . "0x8316")  ;; <CJK>
       (?$Bh$(B . "0x8332")  ;; <CJK>
       (?$Bh%(B . "0x8331")  ;; <CJK>
       (?$Bh&(B . "0x8340")  ;; <CJK>
       (?$Bh'(B . "0x8339")  ;; <CJK>
       (?$Bh((B . "0x8350")  ;; <CJK>
       (?$Bh)(B . "0x8345")  ;; <CJK>
       (?$Bh*(B . "0x832F")  ;; <CJK>
       (?$Bh+(B . "0x832B")  ;; <CJK>
       (?$Bh,(B . "0x8317")  ;; <CJK>
       (?$Bh-(B . "0x8318")  ;; <CJK>
       (?$Bh.(B . "0x8385")  ;; <CJK>
       (?$Bh/(B . "0x839A")  ;; <CJK>
       (?$Bh0(B . "0x83AA")  ;; <CJK>
       (?$Bh1(B . "0x839F")  ;; <CJK>
       (?$Bh2(B . "0x83A2")  ;; <CJK>
       (?$Bh3(B . "0x8396")  ;; <CJK>
       (?$Bh4(B . "0x8323")  ;; <CJK>
       (?$Bh5(B . "0x838E")  ;; <CJK>
       (?$Bh6(B . "0x8387")  ;; <CJK>
       (?$Bh7(B . "0x838A")  ;; <CJK>
       (?$Bh8(B . "0x837C")  ;; <CJK>
       (?$Bh9(B . "0x83B5")  ;; <CJK>
       (?$Bh:(B . "0x8373")  ;; <CJK>
       (?$Bh;(B . "0x8375")  ;; <CJK>
       (?$Bh<(B . "0x83A0")  ;; <CJK>
       (?$Bh=(B . "0x8389")  ;; <CJK>
       (?$Bh>(B . "0x83A8")  ;; <CJK>
       (?$Bh?(B . "0x83F4")  ;; <CJK>
       (?$Bh@(B . "0x8413")  ;; <CJK>
       (?$BhA(B . "0x83EB")  ;; <CJK>
       (?$BhB(B . "0x83CE")  ;; <CJK>
       (?$BhC(B . "0x83FD")  ;; <CJK>
       (?$BhD(B . "0x8403")  ;; <CJK>
       (?$BhE(B . "0x83D8")  ;; <CJK>
       (?$BhF(B . "0x840B")  ;; <CJK>
       (?$BhG(B . "0x83C1")  ;; <CJK>
       (?$BhH(B . "0x83F7")  ;; <CJK>
       (?$BhI(B . "0x8407")  ;; <CJK>
       (?$BhJ(B . "0x83E0")  ;; <CJK>
       (?$BhK(B . "0x83F2")  ;; <CJK>
       (?$BhL(B . "0x840D")  ;; <CJK>
       (?$BhM(B . "0x8422")  ;; <CJK>
       (?$BhN(B . "0x8420")  ;; <CJK>
       (?$BhO(B . "0x83BD")  ;; <CJK>
       (?$BhP(B . "0x8438")  ;; <CJK>
       (?$BhQ(B . "0x8506")  ;; <CJK>
       (?$BhR(B . "0x83FB")  ;; <CJK>
       (?$BhS(B . "0x846D")  ;; <CJK>
       (?$BhT(B . "0x842A")  ;; <CJK>
       (?$BhU(B . "0x843C")  ;; <CJK>
       (?$BhV(B . "0x855A")  ;; <CJK>
       (?$BhW(B . "0x8484")  ;; <CJK>
       (?$BhX(B . "0x8477")  ;; <CJK>
       (?$BhY(B . "0x846B")  ;; <CJK>
       (?$BhZ(B . "0x84AD")  ;; <CJK>
       (?$Bh[(B . "0x846E")  ;; <CJK>
       (?$Bh\(B . "0x8482")  ;; <CJK>
       (?$Bh](B . "0x8469")  ;; <CJK>
       (?$Bh^(B . "0x8446")  ;; <CJK>
       (?$Bh_(B . "0x842C")  ;; <CJK>
       (?$Bh`(B . "0x846F")  ;; <CJK>
       (?$Bha(B . "0x8479")  ;; <CJK>
       (?$Bhb(B . "0x8435")  ;; <CJK>
       (?$Bhc(B . "0x84CA")  ;; <CJK>
       (?$Bhd(B . "0x8462")  ;; <CJK>
       (?$Bhe(B . "0x84B9")  ;; <CJK>
       (?$Bhf(B . "0x84BF")  ;; <CJK>
       (?$Bhg(B . "0x849F")  ;; <CJK>
       (?$Bhh(B . "0x84D9")  ;; <CJK>
       (?$Bhi(B . "0x84CD")  ;; <CJK>
       (?$Bhj(B . "0x84BB")  ;; <CJK>
       (?$Bhk(B . "0x84DA")  ;; <CJK>
       (?$Bhl(B . "0x84D0")  ;; <CJK>
       (?$Bhm(B . "0x84C1")  ;; <CJK>
       (?$Bhn(B . "0x84C6")  ;; <CJK>
       (?$Bho(B . "0x84D6")  ;; <CJK>
       (?$Bhp(B . "0x84A1")  ;; <CJK>
       (?$Bhq(B . "0x8521")  ;; <CJK>
       (?$Bhr(B . "0x84FF")  ;; <CJK>
       (?$Bhs(B . "0x84F4")  ;; <CJK>
       (?$Bht(B . "0x8517")  ;; <CJK>
       (?$Bhu(B . "0x8518")  ;; <CJK>
       (?$Bhv(B . "0x852C")  ;; <CJK>
       (?$Bhw(B . "0x851F")  ;; <CJK>
       (?$Bhx(B . "0x8515")  ;; <CJK>
       (?$Bhy(B . "0x8514")  ;; <CJK>
       (?$Bhz(B . "0x84FC")  ;; <CJK>
       (?$Bh{(B . "0x8540")  ;; <CJK>
       (?$Bh|(B . "0x8563")  ;; <CJK>
       (?$Bh}(B . "0x8558")  ;; <CJK>
       (?$Bh~(B . "0x8548")  ;; <CJK>
       (?$Bi!(B . "0x8541")  ;; <CJK>
       (?$Bi"(B . "0x8602")  ;; <CJK>
       (?$Bi#(B . "0x854B")  ;; <CJK>
       (?$Bi$(B . "0x8555")  ;; <CJK>
       (?$Bi%(B . "0x8580")  ;; <CJK>
       (?$Bi&(B . "0x85A4")  ;; <CJK>
       (?$Bi'(B . "0x8588")  ;; <CJK>
       (?$Bi((B . "0x8591")  ;; <CJK>
       (?$Bi)(B . "0x858A")  ;; <CJK>
       (?$Bi*(B . "0x85A8")  ;; <CJK>
       (?$Bi+(B . "0x856D")  ;; <CJK>
       (?$Bi,(B . "0x8594")  ;; <CJK>
       (?$Bi-(B . "0x859B")  ;; <CJK>
       (?$Bi.(B . "0x85EA")  ;; <CJK>
       (?$Bi/(B . "0x8587")  ;; <CJK>
       (?$Bi0(B . "0x859C")  ;; <CJK>
       (?$Bi1(B . "0x8577")  ;; <CJK>
       (?$Bi2(B . "0x857E")  ;; <CJK>
       (?$Bi3(B . "0x8590")  ;; <CJK>
       (?$Bi4(B . "0x85C9")  ;; <CJK>
       (?$Bi5(B . "0x85BA")  ;; <CJK>
       (?$Bi6(B . "0x85CF")  ;; <CJK>
       (?$Bi7(B . "0x85B9")  ;; <CJK>
       (?$Bi8(B . "0x85D0")  ;; <CJK>
       (?$Bi9(B . "0x85D5")  ;; <CJK>
       (?$Bi:(B . "0x85DD")  ;; <CJK>
       (?$Bi;(B . "0x85E5")  ;; <CJK>
       (?$Bi<(B . "0x85DC")  ;; <CJK>
       (?$Bi=(B . "0x85F9")  ;; <CJK>
       (?$Bi>(B . "0x860A")  ;; <CJK>
       (?$Bi?(B . "0x8613")  ;; <CJK>
       (?$Bi@(B . "0x860B")  ;; <CJK>
       (?$BiA(B . "0x85FE")  ;; <CJK>
       (?$BiB(B . "0x85FA")  ;; <CJK>
       (?$BiC(B . "0x8606")  ;; <CJK>
       (?$BiD(B . "0x8622")  ;; <CJK>
       (?$BiE(B . "0x861A")  ;; <CJK>
       (?$BiF(B . "0x8630")  ;; <CJK>
       (?$BiG(B . "0x863F")  ;; <CJK>
       (?$BiH(B . "0x864D")  ;; <CJK>
       (?$BiI(B . "0x4E55")  ;; <CJK>
       (?$BiJ(B . "0x8654")  ;; <CJK>
       (?$BiK(B . "0x865F")  ;; <CJK>
       (?$BiL(B . "0x8667")  ;; <CJK>
       (?$BiM(B . "0x8671")  ;; <CJK>
       (?$BiN(B . "0x8693")  ;; <CJK>
       (?$BiO(B . "0x86A3")  ;; <CJK>
       (?$BiP(B . "0x86A9")  ;; <CJK>
       (?$BiQ(B . "0x86AA")  ;; <CJK>
       (?$BiR(B . "0x868B")  ;; <CJK>
       (?$BiS(B . "0x868C")  ;; <CJK>
       (?$BiT(B . "0x86B6")  ;; <CJK>
       (?$BiU(B . "0x86AF")  ;; <CJK>
       (?$BiV(B . "0x86C4")  ;; <CJK>
       (?$BiW(B . "0x86C6")  ;; <CJK>
       (?$BiX(B . "0x86B0")  ;; <CJK>
       (?$BiY(B . "0x86C9")  ;; <CJK>
       (?$BiZ(B . "0x8823")  ;; <CJK>
       (?$Bi[(B . "0x86AB")  ;; <CJK>
       (?$Bi\(B . "0x86D4")  ;; <CJK>
       (?$Bi](B . "0x86DE")  ;; <CJK>
       (?$Bi^(B . "0x86E9")  ;; <CJK>
       (?$Bi_(B . "0x86EC")  ;; <CJK>
       (?$Bi`(B . "0x86DF")  ;; <CJK>
       (?$Bia(B . "0x86DB")  ;; <CJK>
       (?$Bib(B . "0x86EF")  ;; <CJK>
       (?$Bic(B . "0x8712")  ;; <CJK>
       (?$Bid(B . "0x8706")  ;; <CJK>
       (?$Bie(B . "0x8708")  ;; <CJK>
       (?$Bif(B . "0x8700")  ;; <CJK>
       (?$Big(B . "0x8703")  ;; <CJK>
       (?$Bih(B . "0x86FB")  ;; <CJK>
       (?$Bii(B . "0x8711")  ;; <CJK>
       (?$Bij(B . "0x8709")  ;; <CJK>
       (?$Bik(B . "0x870D")  ;; <CJK>
       (?$Bil(B . "0x86F9")  ;; <CJK>
       (?$Bim(B . "0x870A")  ;; <CJK>
       (?$Bin(B . "0x8734")  ;; <CJK>
       (?$Bio(B . "0x873F")  ;; <CJK>
       (?$Bip(B . "0x8737")  ;; <CJK>
       (?$Biq(B . "0x873B")  ;; <CJK>
       (?$Bir(B . "0x8725")  ;; <CJK>
       (?$Bis(B . "0x8729")  ;; <CJK>
       (?$Bit(B . "0x871A")  ;; <CJK>
       (?$Biu(B . "0x8760")  ;; <CJK>
       (?$Biv(B . "0x875F")  ;; <CJK>
       (?$Biw(B . "0x8778")  ;; <CJK>
       (?$Bix(B . "0x874C")  ;; <CJK>
       (?$Biy(B . "0x874E")  ;; <CJK>
       (?$Biz(B . "0x8774")  ;; <CJK>
       (?$Bi{(B . "0x8757")  ;; <CJK>
       (?$Bi|(B . "0x8768")  ;; <CJK>
       (?$Bi}(B . "0x876E")  ;; <CJK>
       (?$Bi~(B . "0x8759")  ;; <CJK>
       (?$Bj!(B . "0x8753")  ;; <CJK>
       (?$Bj"(B . "0x8763")  ;; <CJK>
       (?$Bj#(B . "0x876A")  ;; <CJK>
       (?$Bj$(B . "0x8805")  ;; <CJK>
       (?$Bj%(B . "0x87A2")  ;; <CJK>
       (?$Bj&(B . "0x879F")  ;; <CJK>
       (?$Bj'(B . "0x8782")  ;; <CJK>
       (?$Bj((B . "0x87AF")  ;; <CJK>
       (?$Bj)(B . "0x87CB")  ;; <CJK>
       (?$Bj*(B . "0x87BD")  ;; <CJK>
       (?$Bj+(B . "0x87C0")  ;; <CJK>
       (?$Bj,(B . "0x87D0")  ;; <CJK>
       (?$Bj-(B . "0x96D6")  ;; <CJK>
       (?$Bj.(B . "0x87AB")  ;; <CJK>
       (?$Bj/(B . "0x87C4")  ;; <CJK>
       (?$Bj0(B . "0x87B3")  ;; <CJK>
       (?$Bj1(B . "0x87C7")  ;; <CJK>
       (?$Bj2(B . "0x87C6")  ;; <CJK>
       (?$Bj3(B . "0x87BB")  ;; <CJK>
       (?$Bj4(B . "0x87EF")  ;; <CJK>
       (?$Bj5(B . "0x87F2")  ;; <CJK>
       (?$Bj6(B . "0x87E0")  ;; <CJK>
       (?$Bj7(B . "0x880F")  ;; <CJK>
       (?$Bj8(B . "0x880D")  ;; <CJK>
       (?$Bj9(B . "0x87FE")  ;; <CJK>
       (?$Bj:(B . "0x87F6")  ;; <CJK>
       (?$Bj;(B . "0x87F7")  ;; <CJK>
       (?$Bj<(B . "0x880E")  ;; <CJK>
       (?$Bj=(B . "0x87D2")  ;; <CJK>
       (?$Bj>(B . "0x8811")  ;; <CJK>
       (?$Bj?(B . "0x8816")  ;; <CJK>
       (?$Bj@(B . "0x8815")  ;; <CJK>
       (?$BjA(B . "0x8822")  ;; <CJK>
       (?$BjB(B . "0x8821")  ;; <CJK>
       (?$BjC(B . "0x8831")  ;; <CJK>
       (?$BjD(B . "0x8836")  ;; <CJK>
       (?$BjE(B . "0x8839")  ;; <CJK>
       (?$BjF(B . "0x8827")  ;; <CJK>
       (?$BjG(B . "0x883B")  ;; <CJK>
       (?$BjH(B . "0x8844")  ;; <CJK>
       (?$BjI(B . "0x8842")  ;; <CJK>
       (?$BjJ(B . "0x8852")  ;; <CJK>
       (?$BjK(B . "0x8859")  ;; <CJK>
       (?$BjL(B . "0x885E")  ;; <CJK>
       (?$BjM(B . "0x8862")  ;; <CJK>
       (?$BjN(B . "0x886B")  ;; <CJK>
       (?$BjO(B . "0x8881")  ;; <CJK>
       (?$BjP(B . "0x887E")  ;; <CJK>
       (?$BjQ(B . "0x889E")  ;; <CJK>
       (?$BjR(B . "0x8875")  ;; <CJK>
       (?$BjS(B . "0x887D")  ;; <CJK>
       (?$BjT(B . "0x88B5")  ;; <CJK>
       (?$BjU(B . "0x8872")  ;; <CJK>
       (?$BjV(B . "0x8882")  ;; <CJK>
       (?$BjW(B . "0x8897")  ;; <CJK>
       (?$BjX(B . "0x8892")  ;; <CJK>
       (?$BjY(B . "0x88AE")  ;; <CJK>
       (?$BjZ(B . "0x8899")  ;; <CJK>
       (?$Bj[(B . "0x88A2")  ;; <CJK>
       (?$Bj\(B . "0x888D")  ;; <CJK>
       (?$Bj](B . "0x88A4")  ;; <CJK>
       (?$Bj^(B . "0x88B0")  ;; <CJK>
       (?$Bj_(B . "0x88BF")  ;; <CJK>
       (?$Bj`(B . "0x88B1")  ;; <CJK>
       (?$Bja(B . "0x88C3")  ;; <CJK>
       (?$Bjb(B . "0x88C4")  ;; <CJK>
       (?$Bjc(B . "0x88D4")  ;; <CJK>
       (?$Bjd(B . "0x88D8")  ;; <CJK>
       (?$Bje(B . "0x88D9")  ;; <CJK>
       (?$Bjf(B . "0x88DD")  ;; <CJK>
       (?$Bjg(B . "0x88F9")  ;; <CJK>
       (?$Bjh(B . "0x8902")  ;; <CJK>
       (?$Bji(B . "0x88FC")  ;; <CJK>
       (?$Bjj(B . "0x88F4")  ;; <CJK>
       (?$Bjk(B . "0x88E8")  ;; <CJK>
       (?$Bjl(B . "0x88F2")  ;; <CJK>
       (?$Bjm(B . "0x8904")  ;; <CJK>
       (?$Bjn(B . "0x890C")  ;; <CJK>
       (?$Bjo(B . "0x890A")  ;; <CJK>
       (?$Bjp(B . "0x8913")  ;; <CJK>
       (?$Bjq(B . "0x8943")  ;; <CJK>
       (?$Bjr(B . "0x891E")  ;; <CJK>
       (?$Bjs(B . "0x8925")  ;; <CJK>
       (?$Bjt(B . "0x892A")  ;; <CJK>
       (?$Bju(B . "0x892B")  ;; <CJK>
       (?$Bjv(B . "0x8941")  ;; <CJK>
       (?$Bjw(B . "0x8944")  ;; <CJK>
       (?$Bjx(B . "0x893B")  ;; <CJK>
       (?$Bjy(B . "0x8936")  ;; <CJK>
       (?$Bjz(B . "0x8938")  ;; <CJK>
       (?$Bj{(B . "0x894C")  ;; <CJK>
       (?$Bj|(B . "0x891D")  ;; <CJK>
       (?$Bj}(B . "0x8960")  ;; <CJK>
       (?$Bj~(B . "0x895E")  ;; <CJK>
       (?$Bk!(B . "0x8966")  ;; <CJK>
       (?$Bk"(B . "0x8964")  ;; <CJK>
       (?$Bk#(B . "0x896D")  ;; <CJK>
       (?$Bk$(B . "0x896A")  ;; <CJK>
       (?$Bk%(B . "0x896F")  ;; <CJK>
       (?$Bk&(B . "0x8974")  ;; <CJK>
       (?$Bk'(B . "0x8977")  ;; <CJK>
       (?$Bk((B . "0x897E")  ;; <CJK>
       (?$Bk)(B . "0x8983")  ;; <CJK>
       (?$Bk*(B . "0x8988")  ;; <CJK>
       (?$Bk+(B . "0x898A")  ;; <CJK>
       (?$Bk,(B . "0x8993")  ;; <CJK>
       (?$Bk-(B . "0x8998")  ;; <CJK>
       (?$Bk.(B . "0x89A1")  ;; <CJK>
       (?$Bk/(B . "0x89A9")  ;; <CJK>
       (?$Bk0(B . "0x89A6")  ;; <CJK>
       (?$Bk1(B . "0x89AC")  ;; <CJK>
       (?$Bk2(B . "0x89AF")  ;; <CJK>
       (?$Bk3(B . "0x89B2")  ;; <CJK>
       (?$Bk4(B . "0x89BA")  ;; <CJK>
       (?$Bk5(B . "0x89BD")  ;; <CJK>
       (?$Bk6(B . "0x89BF")  ;; <CJK>
       (?$Bk7(B . "0x89C0")  ;; <CJK>
       (?$Bk8(B . "0x89DA")  ;; <CJK>
       (?$Bk9(B . "0x89DC")  ;; <CJK>
       (?$Bk:(B . "0x89DD")  ;; <CJK>
       (?$Bk;(B . "0x89E7")  ;; <CJK>
       (?$Bk<(B . "0x89F4")  ;; <CJK>
       (?$Bk=(B . "0x89F8")  ;; <CJK>
       (?$Bk>(B . "0x8A03")  ;; <CJK>
       (?$Bk?(B . "0x8A16")  ;; <CJK>
       (?$Bk@(B . "0x8A10")  ;; <CJK>
       (?$BkA(B . "0x8A0C")  ;; <CJK>
       (?$BkB(B . "0x8A1B")  ;; <CJK>
       (?$BkC(B . "0x8A1D")  ;; <CJK>
       (?$BkD(B . "0x8A25")  ;; <CJK>
       (?$BkE(B . "0x8A36")  ;; <CJK>
       (?$BkF(B . "0x8A41")  ;; <CJK>
       (?$BkG(B . "0x8A5B")  ;; <CJK>
       (?$BkH(B . "0x8A52")  ;; <CJK>
       (?$BkI(B . "0x8A46")  ;; <CJK>
       (?$BkJ(B . "0x8A48")  ;; <CJK>
       (?$BkK(B . "0x8A7C")  ;; <CJK>
       (?$BkL(B . "0x8A6D")  ;; <CJK>
       (?$BkM(B . "0x8A6C")  ;; <CJK>
       (?$BkN(B . "0x8A62")  ;; <CJK>
       (?$BkO(B . "0x8A85")  ;; <CJK>
       (?$BkP(B . "0x8A82")  ;; <CJK>
       (?$BkQ(B . "0x8A84")  ;; <CJK>
       (?$BkR(B . "0x8AA8")  ;; <CJK>
       (?$BkS(B . "0x8AA1")  ;; <CJK>
       (?$BkT(B . "0x8A91")  ;; <CJK>
       (?$BkU(B . "0x8AA5")  ;; <CJK>
       (?$BkV(B . "0x8AA6")  ;; <CJK>
       (?$BkW(B . "0x8A9A")  ;; <CJK>
       (?$BkX(B . "0x8AA3")  ;; <CJK>
       (?$BkY(B . "0x8AC4")  ;; <CJK>
       (?$BkZ(B . "0x8ACD")  ;; <CJK>
       (?$Bk[(B . "0x8AC2")  ;; <CJK>
       (?$Bk\(B . "0x8ADA")  ;; <CJK>
       (?$Bk](B . "0x8AEB")  ;; <CJK>
       (?$Bk^(B . "0x8AF3")  ;; <CJK>
       (?$Bk_(B . "0x8AE7")  ;; <CJK>
       (?$Bk`(B . "0x8AE4")  ;; <CJK>
       (?$Bka(B . "0x8AF1")  ;; <CJK>
       (?$Bkb(B . "0x8B14")  ;; <CJK>
       (?$Bkc(B . "0x8AE0")  ;; <CJK>
       (?$Bkd(B . "0x8AE2")  ;; <CJK>
       (?$Bke(B . "0x8AF7")  ;; <CJK>
       (?$Bkf(B . "0x8ADE")  ;; <CJK>
       (?$Bkg(B . "0x8ADB")  ;; <CJK>
       (?$Bkh(B . "0x8B0C")  ;; <CJK>
       (?$Bki(B . "0x8B07")  ;; <CJK>
       (?$Bkj(B . "0x8B1A")  ;; <CJK>
       (?$Bkk(B . "0x8AE1")  ;; <CJK>
       (?$Bkl(B . "0x8B16")  ;; <CJK>
       (?$Bkm(B . "0x8B10")  ;; <CJK>
       (?$Bkn(B . "0x8B17")  ;; <CJK>
       (?$Bko(B . "0x8B20")  ;; <CJK>
       (?$Bkp(B . "0x8B33")  ;; <CJK>
       (?$Bkq(B . "0x97AB")  ;; <CJK>
       (?$Bkr(B . "0x8B26")  ;; <CJK>
       (?$Bks(B . "0x8B2B")  ;; <CJK>
       (?$Bkt(B . "0x8B3E")  ;; <CJK>
       (?$Bku(B . "0x8B28")  ;; <CJK>
       (?$Bkv(B . "0x8B41")  ;; <CJK>
       (?$Bkw(B . "0x8B4C")  ;; <CJK>
       (?$Bkx(B . "0x8B4F")  ;; <CJK>
       (?$Bky(B . "0x8B4E")  ;; <CJK>
       (?$Bkz(B . "0x8B49")  ;; <CJK>
       (?$Bk{(B . "0x8B56")  ;; <CJK>
       (?$Bk|(B . "0x8B5B")  ;; <CJK>
       (?$Bk}(B . "0x8B5A")  ;; <CJK>
       (?$Bk~(B . "0x8B6B")  ;; <CJK>
       (?$Bl!(B . "0x8B5F")  ;; <CJK>
       (?$Bl"(B . "0x8B6C")  ;; <CJK>
       (?$Bl#(B . "0x8B6F")  ;; <CJK>
       (?$Bl$(B . "0x8B74")  ;; <CJK>
       (?$Bl%(B . "0x8B7D")  ;; <CJK>
       (?$Bl&(B . "0x8B80")  ;; <CJK>
       (?$Bl'(B . "0x8B8C")  ;; <CJK>
       (?$Bl((B . "0x8B8E")  ;; <CJK>
       (?$Bl)(B . "0x8B92")  ;; <CJK>
       (?$Bl*(B . "0x8B93")  ;; <CJK>
       (?$Bl+(B . "0x8B96")  ;; <CJK>
       (?$Bl,(B . "0x8B99")  ;; <CJK>
       (?$Bl-(B . "0x8B9A")  ;; <CJK>
       (?$Bl.(B . "0x8C3A")  ;; <CJK>
       (?$Bl/(B . "0x8C41")  ;; <CJK>
       (?$Bl0(B . "0x8C3F")  ;; <CJK>
       (?$Bl1(B . "0x8C48")  ;; <CJK>
       (?$Bl2(B . "0x8C4C")  ;; <CJK>
       (?$Bl3(B . "0x8C4E")  ;; <CJK>
       (?$Bl4(B . "0x8C50")  ;; <CJK>
       (?$Bl5(B . "0x8C55")  ;; <CJK>
       (?$Bl6(B . "0x8C62")  ;; <CJK>
       (?$Bl7(B . "0x8C6C")  ;; <CJK>
       (?$Bl8(B . "0x8C78")  ;; <CJK>
       (?$Bl9(B . "0x8C7A")  ;; <CJK>
       (?$Bl:(B . "0x8C82")  ;; <CJK>
       (?$Bl;(B . "0x8C89")  ;; <CJK>
       (?$Bl<(B . "0x8C85")  ;; <CJK>
       (?$Bl=(B . "0x8C8A")  ;; <CJK>
       (?$Bl>(B . "0x8C8D")  ;; <CJK>
       (?$Bl?(B . "0x8C8E")  ;; <CJK>
       (?$Bl@(B . "0x8C94")  ;; <CJK>
       (?$BlA(B . "0x8C7C")  ;; <CJK>
       (?$BlB(B . "0x8C98")  ;; <CJK>
       (?$BlC(B . "0x621D")  ;; <CJK>
       (?$BlD(B . "0x8CAD")  ;; <CJK>
       (?$BlE(B . "0x8CAA")  ;; <CJK>
       (?$BlF(B . "0x8CBD")  ;; <CJK>
       (?$BlG(B . "0x8CB2")  ;; <CJK>
       (?$BlH(B . "0x8CB3")  ;; <CJK>
       (?$BlI(B . "0x8CAE")  ;; <CJK>
       (?$BlJ(B . "0x8CB6")  ;; <CJK>
       (?$BlK(B . "0x8CC8")  ;; <CJK>
       (?$BlL(B . "0x8CC1")  ;; <CJK>
       (?$BlM(B . "0x8CE4")  ;; <CJK>
       (?$BlN(B . "0x8CE3")  ;; <CJK>
       (?$BlO(B . "0x8CDA")  ;; <CJK>
       (?$BlP(B . "0x8CFD")  ;; <CJK>
       (?$BlQ(B . "0x8CFA")  ;; <CJK>
       (?$BlR(B . "0x8CFB")  ;; <CJK>
       (?$BlS(B . "0x8D04")  ;; <CJK>
       (?$BlT(B . "0x8D05")  ;; <CJK>
       (?$BlU(B . "0x8D0A")  ;; <CJK>
       (?$BlV(B . "0x8D07")  ;; <CJK>
       (?$BlW(B . "0x8D0F")  ;; <CJK>
       (?$BlX(B . "0x8D0D")  ;; <CJK>
       (?$BlY(B . "0x8D10")  ;; <CJK>
       (?$BlZ(B . "0x9F4E")  ;; <CJK>
       (?$Bl[(B . "0x8D13")  ;; <CJK>
       (?$Bl\(B . "0x8CCD")  ;; <CJK>
       (?$Bl](B . "0x8D14")  ;; <CJK>
       (?$Bl^(B . "0x8D16")  ;; <CJK>
       (?$Bl_(B . "0x8D67")  ;; <CJK>
       (?$Bl`(B . "0x8D6D")  ;; <CJK>
       (?$Bla(B . "0x8D71")  ;; <CJK>
       (?$Blb(B . "0x8D73")  ;; <CJK>
       (?$Blc(B . "0x8D81")  ;; <CJK>
       (?$Bld(B . "0x8D99")  ;; <CJK>
       (?$Ble(B . "0x8DC2")  ;; <CJK>
       (?$Blf(B . "0x8DBE")  ;; <CJK>
       (?$Blg(B . "0x8DBA")  ;; <CJK>
       (?$Blh(B . "0x8DCF")  ;; <CJK>
       (?$Bli(B . "0x8DDA")  ;; <CJK>
       (?$Blj(B . "0x8DD6")  ;; <CJK>
       (?$Blk(B . "0x8DCC")  ;; <CJK>
       (?$Bll(B . "0x8DDB")  ;; <CJK>
       (?$Blm(B . "0x8DCB")  ;; <CJK>
       (?$Bln(B . "0x8DEA")  ;; <CJK>
       (?$Blo(B . "0x8DEB")  ;; <CJK>
       (?$Blp(B . "0x8DDF")  ;; <CJK>
       (?$Blq(B . "0x8DE3")  ;; <CJK>
       (?$Blr(B . "0x8DFC")  ;; <CJK>
       (?$Bls(B . "0x8E08")  ;; <CJK>
       (?$Blt(B . "0x8E09")  ;; <CJK>
       (?$Blu(B . "0x8DFF")  ;; <CJK>
       (?$Blv(B . "0x8E1D")  ;; <CJK>
       (?$Blw(B . "0x8E1E")  ;; <CJK>
       (?$Blx(B . "0x8E10")  ;; <CJK>
       (?$Bly(B . "0x8E1F")  ;; <CJK>
       (?$Blz(B . "0x8E42")  ;; <CJK>
       (?$Bl{(B . "0x8E35")  ;; <CJK>
       (?$Bl|(B . "0x8E30")  ;; <CJK>
       (?$Bl}(B . "0x8E34")  ;; <CJK>
       (?$Bl~(B . "0x8E4A")  ;; <CJK>
       (?$Bm!(B . "0x8E47")  ;; <CJK>
       (?$Bm"(B . "0x8E49")  ;; <CJK>
       (?$Bm#(B . "0x8E4C")  ;; <CJK>
       (?$Bm$(B . "0x8E50")  ;; <CJK>
       (?$Bm%(B . "0x8E48")  ;; <CJK>
       (?$Bm&(B . "0x8E59")  ;; <CJK>
       (?$Bm'(B . "0x8E64")  ;; <CJK>
       (?$Bm((B . "0x8E60")  ;; <CJK>
       (?$Bm)(B . "0x8E2A")  ;; <CJK>
       (?$Bm*(B . "0x8E63")  ;; <CJK>
       (?$Bm+(B . "0x8E55")  ;; <CJK>
       (?$Bm,(B . "0x8E76")  ;; <CJK>
       (?$Bm-(B . "0x8E72")  ;; <CJK>
       (?$Bm.(B . "0x8E7C")  ;; <CJK>
       (?$Bm/(B . "0x8E81")  ;; <CJK>
       (?$Bm0(B . "0x8E87")  ;; <CJK>
       (?$Bm1(B . "0x8E85")  ;; <CJK>
       (?$Bm2(B . "0x8E84")  ;; <CJK>
       (?$Bm3(B . "0x8E8B")  ;; <CJK>
       (?$Bm4(B . "0x8E8A")  ;; <CJK>
       (?$Bm5(B . "0x8E93")  ;; <CJK>
       (?$Bm6(B . "0x8E91")  ;; <CJK>
       (?$Bm7(B . "0x8E94")  ;; <CJK>
       (?$Bm8(B . "0x8E99")  ;; <CJK>
       (?$Bm9(B . "0x8EAA")  ;; <CJK>
       (?$Bm:(B . "0x8EA1")  ;; <CJK>
       (?$Bm;(B . "0x8EAC")  ;; <CJK>
       (?$Bm<(B . "0x8EB0")  ;; <CJK>
       (?$Bm=(B . "0x8EC6")  ;; <CJK>
       (?$Bm>(B . "0x8EB1")  ;; <CJK>
       (?$Bm?(B . "0x8EBE")  ;; <CJK>
       (?$Bm@(B . "0x8EC5")  ;; <CJK>
       (?$BmA(B . "0x8EC8")  ;; <CJK>
       (?$BmB(B . "0x8ECB")  ;; <CJK>
       (?$BmC(B . "0x8EDB")  ;; <CJK>
       (?$BmD(B . "0x8EE3")  ;; <CJK>
       (?$BmE(B . "0x8EFC")  ;; <CJK>
       (?$BmF(B . "0x8EFB")  ;; <CJK>
       (?$BmG(B . "0x8EEB")  ;; <CJK>
       (?$BmH(B . "0x8EFE")  ;; <CJK>
       (?$BmI(B . "0x8F0A")  ;; <CJK>
       (?$BmJ(B . "0x8F05")  ;; <CJK>
       (?$BmK(B . "0x8F15")  ;; <CJK>
       (?$BmL(B . "0x8F12")  ;; <CJK>
       (?$BmM(B . "0x8F19")  ;; <CJK>
       (?$BmN(B . "0x8F13")  ;; <CJK>
       (?$BmO(B . "0x8F1C")  ;; <CJK>
       (?$BmP(B . "0x8F1F")  ;; <CJK>
       (?$BmQ(B . "0x8F1B")  ;; <CJK>
       (?$BmR(B . "0x8F0C")  ;; <CJK>
       (?$BmS(B . "0x8F26")  ;; <CJK>
       (?$BmT(B . "0x8F33")  ;; <CJK>
       (?$BmU(B . "0x8F3B")  ;; <CJK>
       (?$BmV(B . "0x8F39")  ;; <CJK>
       (?$BmW(B . "0x8F45")  ;; <CJK>
       (?$BmX(B . "0x8F42")  ;; <CJK>
       (?$BmY(B . "0x8F3E")  ;; <CJK>
       (?$BmZ(B . "0x8F4C")  ;; <CJK>
       (?$Bm[(B . "0x8F49")  ;; <CJK>
       (?$Bm\(B . "0x8F46")  ;; <CJK>
       (?$Bm](B . "0x8F4E")  ;; <CJK>
       (?$Bm^(B . "0x8F57")  ;; <CJK>
       (?$Bm_(B . "0x8F5C")  ;; <CJK>
       (?$Bm`(B . "0x8F62")  ;; <CJK>
       (?$Bma(B . "0x8F63")  ;; <CJK>
       (?$Bmb(B . "0x8F64")  ;; <CJK>
       (?$Bmc(B . "0x8F9C")  ;; <CJK>
       (?$Bmd(B . "0x8F9F")  ;; <CJK>
       (?$Bme(B . "0x8FA3")  ;; <CJK>
       (?$Bmf(B . "0x8FAD")  ;; <CJK>
       (?$Bmg(B . "0x8FAF")  ;; <CJK>
       (?$Bmh(B . "0x8FB7")  ;; <CJK>
       (?$Bmi(B . "0x8FDA")  ;; <CJK>
       (?$Bmj(B . "0x8FE5")  ;; <CJK>
       (?$Bmk(B . "0x8FE2")  ;; <CJK>
       (?$Bml(B . "0x8FEA")  ;; <CJK>
       (?$Bmm(B . "0x8FEF")  ;; <CJK>
       (?$Bmn(B . "0x9087")  ;; <CJK>
       (?$Bmo(B . "0x8FF4")  ;; <CJK>
       (?$Bmp(B . "0x9005")  ;; <CJK>
       (?$Bmq(B . "0x8FF9")  ;; <CJK>
       (?$Bmr(B . "0x8FFA")  ;; <CJK>
       (?$Bms(B . "0x9011")  ;; <CJK>
       (?$Bmt(B . "0x9015")  ;; <CJK>
       (?$Bmu(B . "0x9021")  ;; <CJK>
       (?$Bmv(B . "0x900D")  ;; <CJK>
       (?$Bmw(B . "0x901E")  ;; <CJK>
       (?$Bmx(B . "0x9016")  ;; <CJK>
       (?$Bmy(B . "0x900B")  ;; <CJK>
       (?$Bmz(B . "0x9027")  ;; <CJK>
       (?$Bm{(B . "0x9036")  ;; <CJK>
       (?$Bm|(B . "0x9035")  ;; <CJK>
       (?$Bm}(B . "0x9039")  ;; <CJK>
       (?$Bm~(B . "0x8FF8")  ;; <CJK>
       (?$Bn!(B . "0x904F")  ;; <CJK>
       (?$Bn"(B . "0x9050")  ;; <CJK>
       (?$Bn#(B . "0x9051")  ;; <CJK>
       (?$Bn$(B . "0x9052")  ;; <CJK>
       (?$Bn%(B . "0x900E")  ;; <CJK>
       (?$Bn&(B . "0x9049")  ;; <CJK>
       (?$Bn'(B . "0x903E")  ;; <CJK>
       (?$Bn((B . "0x9056")  ;; <CJK>
       (?$Bn)(B . "0x9058")  ;; <CJK>
       (?$Bn*(B . "0x905E")  ;; <CJK>
       (?$Bn+(B . "0x9068")  ;; <CJK>
       (?$Bn,(B . "0x906F")  ;; <CJK>
       (?$Bn-(B . "0x9076")  ;; <CJK>
       (?$Bn.(B . "0x96A8")  ;; <CJK>
       (?$Bn/(B . "0x9072")  ;; <CJK>
       (?$Bn0(B . "0x9082")  ;; <CJK>
       (?$Bn1(B . "0x907D")  ;; <CJK>
       (?$Bn2(B . "0x9081")  ;; <CJK>
       (?$Bn3(B . "0x9080")  ;; <CJK>
       (?$Bn4(B . "0x908A")  ;; <CJK>
       (?$Bn5(B . "0x9089")  ;; <CJK>
       (?$Bn6(B . "0x908F")  ;; <CJK>
       (?$Bn7(B . "0x90A8")  ;; <CJK>
       (?$Bn8(B . "0x90AF")  ;; <CJK>
       (?$Bn9(B . "0x90B1")  ;; <CJK>
       (?$Bn:(B . "0x90B5")  ;; <CJK>
       (?$Bn;(B . "0x90E2")  ;; <CJK>
       (?$Bn<(B . "0x90E4")  ;; <CJK>
       (?$Bn=(B . "0x6248")  ;; <CJK>
       (?$Bn>(B . "0x90DB")  ;; <CJK>
       (?$Bn?(B . "0x9102")  ;; <CJK>
       (?$Bn@(B . "0x9112")  ;; <CJK>
       (?$BnA(B . "0x9119")  ;; <CJK>
       (?$BnB(B . "0x9132")  ;; <CJK>
       (?$BnC(B . "0x9130")  ;; <CJK>
       (?$BnD(B . "0x914A")  ;; <CJK>
       (?$BnE(B . "0x9156")  ;; <CJK>
       (?$BnF(B . "0x9158")  ;; <CJK>
       (?$BnG(B . "0x9163")  ;; <CJK>
       (?$BnH(B . "0x9165")  ;; <CJK>
       (?$BnI(B . "0x9169")  ;; <CJK>
       (?$BnJ(B . "0x9173")  ;; <CJK>
       (?$BnK(B . "0x9172")  ;; <CJK>
       (?$BnL(B . "0x918B")  ;; <CJK>
       (?$BnM(B . "0x9189")  ;; <CJK>
       (?$BnN(B . "0x9182")  ;; <CJK>
       (?$BnO(B . "0x91A2")  ;; <CJK>
       (?$BnP(B . "0x91AB")  ;; <CJK>
       (?$BnQ(B . "0x91AF")  ;; <CJK>
       (?$BnR(B . "0x91AA")  ;; <CJK>
       (?$BnS(B . "0x91B5")  ;; <CJK>
       (?$BnT(B . "0x91B4")  ;; <CJK>
       (?$BnU(B . "0x91BA")  ;; <CJK>
       (?$BnV(B . "0x91C0")  ;; <CJK>
       (?$BnW(B . "0x91C1")  ;; <CJK>
       (?$BnX(B . "0x91C9")  ;; <CJK>
       (?$BnY(B . "0x91CB")  ;; <CJK>
       (?$BnZ(B . "0x91D0")  ;; <CJK>
       (?$Bn[(B . "0x91D6")  ;; <CJK>
       (?$Bn\(B . "0x91DF")  ;; <CJK>
       (?$Bn](B . "0x91E1")  ;; <CJK>
       (?$Bn^(B . "0x91DB")  ;; <CJK>
       (?$Bn_(B . "0x91FC")  ;; <CJK>
       (?$Bn`(B . "0x91F5")  ;; <CJK>
       (?$Bna(B . "0x91F6")  ;; <CJK>
       (?$Bnb(B . "0x921E")  ;; <CJK>
       (?$Bnc(B . "0x91FF")  ;; <CJK>
       (?$Bnd(B . "0x9214")  ;; <CJK>
       (?$Bne(B . "0x922C")  ;; <CJK>
       (?$Bnf(B . "0x9215")  ;; <CJK>
       (?$Bng(B . "0x9211")  ;; <CJK>
       (?$Bnh(B . "0x925E")  ;; <CJK>
       (?$Bni(B . "0x9257")  ;; <CJK>
       (?$Bnj(B . "0x9245")  ;; <CJK>
       (?$Bnk(B . "0x9249")  ;; <CJK>
       (?$Bnl(B . "0x9264")  ;; <CJK>
       (?$Bnm(B . "0x9248")  ;; <CJK>
       (?$Bnn(B . "0x9295")  ;; <CJK>
       (?$Bno(B . "0x923F")  ;; <CJK>
       (?$Bnp(B . "0x924B")  ;; <CJK>
       (?$Bnq(B . "0x9250")  ;; <CJK>
       (?$Bnr(B . "0x929C")  ;; <CJK>
       (?$Bns(B . "0x9296")  ;; <CJK>
       (?$Bnt(B . "0x9293")  ;; <CJK>
       (?$Bnu(B . "0x929B")  ;; <CJK>
       (?$Bnv(B . "0x925A")  ;; <CJK>
       (?$Bnw(B . "0x92CF")  ;; <CJK>
       (?$Bnx(B . "0x92B9")  ;; <CJK>
       (?$Bny(B . "0x92B7")  ;; <CJK>
       (?$Bnz(B . "0x92E9")  ;; <CJK>
       (?$Bn{(B . "0x930F")  ;; <CJK>
       (?$Bn|(B . "0x92FA")  ;; <CJK>
       (?$Bn}(B . "0x9344")  ;; <CJK>
       (?$Bn~(B . "0x932E")  ;; <CJK>
       (?$Bo!(B . "0x9319")  ;; <CJK>
       (?$Bo"(B . "0x9322")  ;; <CJK>
       (?$Bo#(B . "0x931A")  ;; <CJK>
       (?$Bo$(B . "0x9323")  ;; <CJK>
       (?$Bo%(B . "0x933A")  ;; <CJK>
       (?$Bo&(B . "0x9335")  ;; <CJK>
       (?$Bo'(B . "0x933B")  ;; <CJK>
       (?$Bo((B . "0x935C")  ;; <CJK>
       (?$Bo)(B . "0x9360")  ;; <CJK>
       (?$Bo*(B . "0x937C")  ;; <CJK>
       (?$Bo+(B . "0x936E")  ;; <CJK>
       (?$Bo,(B . "0x9356")  ;; <CJK>
       (?$Bo-(B . "0x93B0")  ;; <CJK>
       (?$Bo.(B . "0x93AC")  ;; <CJK>
       (?$Bo/(B . "0x93AD")  ;; <CJK>
       (?$Bo0(B . "0x9394")  ;; <CJK>
       (?$Bo1(B . "0x93B9")  ;; <CJK>
       (?$Bo2(B . "0x93D6")  ;; <CJK>
       (?$Bo3(B . "0x93D7")  ;; <CJK>
       (?$Bo4(B . "0x93E8")  ;; <CJK>
       (?$Bo5(B . "0x93E5")  ;; <CJK>
       (?$Bo6(B . "0x93D8")  ;; <CJK>
       (?$Bo7(B . "0x93C3")  ;; <CJK>
       (?$Bo8(B . "0x93DD")  ;; <CJK>
       (?$Bo9(B . "0x93D0")  ;; <CJK>
       (?$Bo:(B . "0x93C8")  ;; <CJK>
       (?$Bo;(B . "0x93E4")  ;; <CJK>
       (?$Bo<(B . "0x941A")  ;; <CJK>
       (?$Bo=(B . "0x9414")  ;; <CJK>
       (?$Bo>(B . "0x9413")  ;; <CJK>
       (?$Bo?(B . "0x9403")  ;; <CJK>
       (?$Bo@(B . "0x9407")  ;; <CJK>
       (?$BoA(B . "0x9410")  ;; <CJK>
       (?$BoB(B . "0x9436")  ;; <CJK>
       (?$BoC(B . "0x942B")  ;; <CJK>
       (?$BoD(B . "0x9435")  ;; <CJK>
       (?$BoE(B . "0x9421")  ;; <CJK>
       (?$BoF(B . "0x943A")  ;; <CJK>
       (?$BoG(B . "0x9441")  ;; <CJK>
       (?$BoH(B . "0x9452")  ;; <CJK>
       (?$BoI(B . "0x9444")  ;; <CJK>
       (?$BoJ(B . "0x945B")  ;; <CJK>
       (?$BoK(B . "0x9460")  ;; <CJK>
       (?$BoL(B . "0x9462")  ;; <CJK>
       (?$BoM(B . "0x945E")  ;; <CJK>
       (?$BoN(B . "0x946A")  ;; <CJK>
       (?$BoO(B . "0x9229")  ;; <CJK>
       (?$BoP(B . "0x9470")  ;; <CJK>
       (?$BoQ(B . "0x9475")  ;; <CJK>
       (?$BoR(B . "0x9477")  ;; <CJK>
       (?$BoS(B . "0x947D")  ;; <CJK>
       (?$BoT(B . "0x945A")  ;; <CJK>
       (?$BoU(B . "0x947C")  ;; <CJK>
       (?$BoV(B . "0x947E")  ;; <CJK>
       (?$BoW(B . "0x9481")  ;; <CJK>
       (?$BoX(B . "0x947F")  ;; <CJK>
       (?$BoY(B . "0x9582")  ;; <CJK>
       (?$BoZ(B . "0x9587")  ;; <CJK>
       (?$Bo[(B . "0x958A")  ;; <CJK>
       (?$Bo\(B . "0x9594")  ;; <CJK>
       (?$Bo](B . "0x9596")  ;; <CJK>
       (?$Bo^(B . "0x9598")  ;; <CJK>
       (?$Bo_(B . "0x9599")  ;; <CJK>
       (?$Bo`(B . "0x95A0")  ;; <CJK>
       (?$Boa(B . "0x95A8")  ;; <CJK>
       (?$Bob(B . "0x95A7")  ;; <CJK>
       (?$Boc(B . "0x95AD")  ;; <CJK>
       (?$Bod(B . "0x95BC")  ;; <CJK>
       (?$Boe(B . "0x95BB")  ;; <CJK>
       (?$Bof(B . "0x95B9")  ;; <CJK>
       (?$Bog(B . "0x95BE")  ;; <CJK>
       (?$Boh(B . "0x95CA")  ;; <CJK>
       (?$Boi(B . "0x6FF6")  ;; <CJK>
       (?$Boj(B . "0x95C3")  ;; <CJK>
       (?$Bok(B . "0x95CD")  ;; <CJK>
       (?$Bol(B . "0x95CC")  ;; <CJK>
       (?$Bom(B . "0x95D5")  ;; <CJK>
       (?$Bon(B . "0x95D4")  ;; <CJK>
       (?$Boo(B . "0x95D6")  ;; <CJK>
       (?$Bop(B . "0x95DC")  ;; <CJK>
       (?$Boq(B . "0x95E1")  ;; <CJK>
       (?$Bor(B . "0x95E5")  ;; <CJK>
       (?$Bos(B . "0x95E2")  ;; <CJK>
       (?$Bot(B . "0x9621")  ;; <CJK>
       (?$Bou(B . "0x9628")  ;; <CJK>
       (?$Bov(B . "0x962E")  ;; <CJK>
       (?$Bow(B . "0x962F")  ;; <CJK>
       (?$Box(B . "0x9642")  ;; <CJK>
       (?$Boy(B . "0x964C")  ;; <CJK>
       (?$Boz(B . "0x964F")  ;; <CJK>
       (?$Bo{(B . "0x964B")  ;; <CJK>
       (?$Bo|(B . "0x9677")  ;; <CJK>
       (?$Bo}(B . "0x965C")  ;; <CJK>
       (?$Bo~(B . "0x965E")  ;; <CJK>
       (?$Bp!(B . "0x965D")  ;; <CJK>
       (?$Bp"(B . "0x965F")  ;; <CJK>
       (?$Bp#(B . "0x9666")  ;; <CJK>
       (?$Bp$(B . "0x9672")  ;; <CJK>
       (?$Bp%(B . "0x966C")  ;; <CJK>
       (?$Bp&(B . "0x968D")  ;; <CJK>
       (?$Bp'(B . "0x9698")  ;; <CJK>
       (?$Bp((B . "0x9695")  ;; <CJK>
       (?$Bp)(B . "0x9697")  ;; <CJK>
       (?$Bp*(B . "0x96AA")  ;; <CJK>
       (?$Bp+(B . "0x96A7")  ;; <CJK>
       (?$Bp,(B . "0x96B1")  ;; <CJK>
       (?$Bp-(B . "0x96B2")  ;; <CJK>
       (?$Bp.(B . "0x96B0")  ;; <CJK>
       (?$Bp/(B . "0x96B4")  ;; <CJK>
       (?$Bp0(B . "0x96B6")  ;; <CJK>
       (?$Bp1(B . "0x96B8")  ;; <CJK>
       (?$Bp2(B . "0x96B9")  ;; <CJK>
       (?$Bp3(B . "0x96CE")  ;; <CJK>
       (?$Bp4(B . "0x96CB")  ;; <CJK>
       (?$Bp5(B . "0x96C9")  ;; <CJK>
       (?$Bp6(B . "0x96CD")  ;; <CJK>
       (?$Bp7(B . "0x894D")  ;; <CJK>
       (?$Bp8(B . "0x96DC")  ;; <CJK>
       (?$Bp9(B . "0x970D")  ;; <CJK>
       (?$Bp:(B . "0x96D5")  ;; <CJK>
       (?$Bp;(B . "0x96F9")  ;; <CJK>
       (?$Bp<(B . "0x9704")  ;; <CJK>
       (?$Bp=(B . "0x9706")  ;; <CJK>
       (?$Bp>(B . "0x9708")  ;; <CJK>
       (?$Bp?(B . "0x9713")  ;; <CJK>
       (?$Bp@(B . "0x970E")  ;; <CJK>
       (?$BpA(B . "0x9711")  ;; <CJK>
       (?$BpB(B . "0x970F")  ;; <CJK>
       (?$BpC(B . "0x9716")  ;; <CJK>
       (?$BpD(B . "0x9719")  ;; <CJK>
       (?$BpE(B . "0x9724")  ;; <CJK>
       (?$BpF(B . "0x972A")  ;; <CJK>
       (?$BpG(B . "0x9730")  ;; <CJK>
       (?$BpH(B . "0x9739")  ;; <CJK>
       (?$BpI(B . "0x973D")  ;; <CJK>
       (?$BpJ(B . "0x973E")  ;; <CJK>
       (?$BpK(B . "0x9744")  ;; <CJK>
       (?$BpL(B . "0x9746")  ;; <CJK>
       (?$BpM(B . "0x9748")  ;; <CJK>
       (?$BpN(B . "0x9742")  ;; <CJK>
       (?$BpO(B . "0x9749")  ;; <CJK>
       (?$BpP(B . "0x975C")  ;; <CJK>
       (?$BpQ(B . "0x9760")  ;; <CJK>
       (?$BpR(B . "0x9764")  ;; <CJK>
       (?$BpS(B . "0x9766")  ;; <CJK>
       (?$BpT(B . "0x9768")  ;; <CJK>
       (?$BpU(B . "0x52D2")  ;; <CJK>
       (?$BpV(B . "0x976B")  ;; <CJK>
       (?$BpW(B . "0x9771")  ;; <CJK>
       (?$BpX(B . "0x9779")  ;; <CJK>
       (?$BpY(B . "0x9785")  ;; <CJK>
       (?$BpZ(B . "0x977C")  ;; <CJK>
       (?$Bp[(B . "0x9781")  ;; <CJK>
       (?$Bp\(B . "0x977A")  ;; <CJK>
       (?$Bp](B . "0x9786")  ;; <CJK>
       (?$Bp^(B . "0x978B")  ;; <CJK>
       (?$Bp_(B . "0x978F")  ;; <CJK>
       (?$Bp`(B . "0x9790")  ;; <CJK>
       (?$Bpa(B . "0x979C")  ;; <CJK>
       (?$Bpb(B . "0x97A8")  ;; <CJK>
       (?$Bpc(B . "0x97A6")  ;; <CJK>
       (?$Bpd(B . "0x97A3")  ;; <CJK>
       (?$Bpe(B . "0x97B3")  ;; <CJK>
       (?$Bpf(B . "0x97B4")  ;; <CJK>
       (?$Bpg(B . "0x97C3")  ;; <CJK>
       (?$Bph(B . "0x97C6")  ;; <CJK>
       (?$Bpi(B . "0x97C8")  ;; <CJK>
       (?$Bpj(B . "0x97CB")  ;; <CJK>
       (?$Bpk(B . "0x97DC")  ;; <CJK>
       (?$Bpl(B . "0x97ED")  ;; <CJK>
       (?$Bpm(B . "0x9F4F")  ;; <CJK>
       (?$Bpn(B . "0x97F2")  ;; <CJK>
       (?$Bpo(B . "0x7ADF")  ;; <CJK>
       (?$Bpp(B . "0x97F6")  ;; <CJK>
       (?$Bpq(B . "0x97F5")  ;; <CJK>
       (?$Bpr(B . "0x980F")  ;; <CJK>
       (?$Bps(B . "0x980C")  ;; <CJK>
       (?$Bpt(B . "0x9838")  ;; <CJK>
       (?$Bpu(B . "0x9824")  ;; <CJK>
       (?$Bpv(B . "0x9821")  ;; <CJK>
       (?$Bpw(B . "0x9837")  ;; <CJK>
       (?$Bpx(B . "0x983D")  ;; <CJK>
       (?$Bpy(B . "0x9846")  ;; <CJK>
       (?$Bpz(B . "0x984F")  ;; <CJK>
       (?$Bp{(B . "0x984B")  ;; <CJK>
       (?$Bp|(B . "0x986B")  ;; <CJK>
       (?$Bp}(B . "0x986F")  ;; <CJK>
       (?$Bp~(B . "0x9870")  ;; <CJK>
       (?$Bq!(B . "0x9871")  ;; <CJK>
       (?$Bq"(B . "0x9874")  ;; <CJK>
       (?$Bq#(B . "0x9873")  ;; <CJK>
       (?$Bq$(B . "0x98AA")  ;; <CJK>
       (?$Bq%(B . "0x98AF")  ;; <CJK>
       (?$Bq&(B . "0x98B1")  ;; <CJK>
       (?$Bq'(B . "0x98B6")  ;; <CJK>
       (?$Bq((B . "0x98C4")  ;; <CJK>
       (?$Bq)(B . "0x98C3")  ;; <CJK>
       (?$Bq*(B . "0x98C6")  ;; <CJK>
       (?$Bq+(B . "0x98E9")  ;; <CJK>
       (?$Bq,(B . "0x98EB")  ;; <CJK>
       (?$Bq-(B . "0x9903")  ;; <CJK>
       (?$Bq.(B . "0x9909")  ;; <CJK>
       (?$Bq/(B . "0x9912")  ;; <CJK>
       (?$Bq0(B . "0x9914")  ;; <CJK>
       (?$Bq1(B . "0x9918")  ;; <CJK>
       (?$Bq2(B . "0x9921")  ;; <CJK>
       (?$Bq3(B . "0x991D")  ;; <CJK>
       (?$Bq4(B . "0x991E")  ;; <CJK>
       (?$Bq5(B . "0x9924")  ;; <CJK>
       (?$Bq6(B . "0x9920")  ;; <CJK>
       (?$Bq7(B . "0x992C")  ;; <CJK>
       (?$Bq8(B . "0x992E")  ;; <CJK>
       (?$Bq9(B . "0x993D")  ;; <CJK>
       (?$Bq:(B . "0x993E")  ;; <CJK>
       (?$Bq;(B . "0x9942")  ;; <CJK>
       (?$Bq<(B . "0x9949")  ;; <CJK>
       (?$Bq=(B . "0x9945")  ;; <CJK>
       (?$Bq>(B . "0x9950")  ;; <CJK>
       (?$Bq?(B . "0x994B")  ;; <CJK>
       (?$Bq@(B . "0x9951")  ;; <CJK>
       (?$BqA(B . "0x9952")  ;; <CJK>
       (?$BqB(B . "0x994C")  ;; <CJK>
       (?$BqC(B . "0x9955")  ;; <CJK>
       (?$BqD(B . "0x9997")  ;; <CJK>
       (?$BqE(B . "0x9998")  ;; <CJK>
       (?$BqF(B . "0x99A5")  ;; <CJK>
       (?$BqG(B . "0x99AD")  ;; <CJK>
       (?$BqH(B . "0x99AE")  ;; <CJK>
       (?$BqI(B . "0x99BC")  ;; <CJK>
       (?$BqJ(B . "0x99DF")  ;; <CJK>
       (?$BqK(B . "0x99DB")  ;; <CJK>
       (?$BqL(B . "0x99DD")  ;; <CJK>
       (?$BqM(B . "0x99D8")  ;; <CJK>
       (?$BqN(B . "0x99D1")  ;; <CJK>
       (?$BqO(B . "0x99ED")  ;; <CJK>
       (?$BqP(B . "0x99EE")  ;; <CJK>
       (?$BqQ(B . "0x99F1")  ;; <CJK>
       (?$BqR(B . "0x99F2")  ;; <CJK>
       (?$BqS(B . "0x99FB")  ;; <CJK>
       (?$BqT(B . "0x99F8")  ;; <CJK>
       (?$BqU(B . "0x9A01")  ;; <CJK>
       (?$BqV(B . "0x9A0F")  ;; <CJK>
       (?$BqW(B . "0x9A05")  ;; <CJK>
       (?$BqX(B . "0x99E2")  ;; <CJK>
       (?$BqY(B . "0x9A19")  ;; <CJK>
       (?$BqZ(B . "0x9A2B")  ;; <CJK>
       (?$Bq[(B . "0x9A37")  ;; <CJK>
       (?$Bq\(B . "0x9A45")  ;; <CJK>
       (?$Bq](B . "0x9A42")  ;; <CJK>
       (?$Bq^(B . "0x9A40")  ;; <CJK>
       (?$Bq_(B . "0x9A43")  ;; <CJK>
       (?$Bq`(B . "0x9A3E")  ;; <CJK>
       (?$Bqa(B . "0x9A55")  ;; <CJK>
       (?$Bqb(B . "0x9A4D")  ;; <CJK>
       (?$Bqc(B . "0x9A5B")  ;; <CJK>
       (?$Bqd(B . "0x9A57")  ;; <CJK>
       (?$Bqe(B . "0x9A5F")  ;; <CJK>
       (?$Bqf(B . "0x9A62")  ;; <CJK>
       (?$Bqg(B . "0x9A65")  ;; <CJK>
       (?$Bqh(B . "0x9A64")  ;; <CJK>
       (?$Bqi(B . "0x9A69")  ;; <CJK>
       (?$Bqj(B . "0x9A6B")  ;; <CJK>
       (?$Bqk(B . "0x9A6A")  ;; <CJK>
       (?$Bql(B . "0x9AAD")  ;; <CJK>
       (?$Bqm(B . "0x9AB0")  ;; <CJK>
       (?$Bqn(B . "0x9ABC")  ;; <CJK>
       (?$Bqo(B . "0x9AC0")  ;; <CJK>
       (?$Bqp(B . "0x9ACF")  ;; <CJK>
       (?$Bqq(B . "0x9AD1")  ;; <CJK>
       (?$Bqr(B . "0x9AD3")  ;; <CJK>
       (?$Bqs(B . "0x9AD4")  ;; <CJK>
       (?$Bqt(B . "0x9ADE")  ;; <CJK>
       (?$Bqu(B . "0x9ADF")  ;; <CJK>
       (?$Bqv(B . "0x9AE2")  ;; <CJK>
       (?$Bqw(B . "0x9AE3")  ;; <CJK>
       (?$Bqx(B . "0x9AE6")  ;; <CJK>
       (?$Bqy(B . "0x9AEF")  ;; <CJK>
       (?$Bqz(B . "0x9AEB")  ;; <CJK>
       (?$Bq{(B . "0x9AEE")  ;; <CJK>
       (?$Bq|(B . "0x9AF4")  ;; <CJK>
       (?$Bq}(B . "0x9AF1")  ;; <CJK>
       (?$Bq~(B . "0x9AF7")  ;; <CJK>
       (?$Br!(B . "0x9AFB")  ;; <CJK>
       (?$Br"(B . "0x9B06")  ;; <CJK>
       (?$Br#(B . "0x9B18")  ;; <CJK>
       (?$Br$(B . "0x9B1A")  ;; <CJK>
       (?$Br%(B . "0x9B1F")  ;; <CJK>
       (?$Br&(B . "0x9B22")  ;; <CJK>
       (?$Br'(B . "0x9B23")  ;; <CJK>
       (?$Br((B . "0x9B25")  ;; <CJK>
       (?$Br)(B . "0x9B27")  ;; <CJK>
       (?$Br*(B . "0x9B28")  ;; <CJK>
       (?$Br+(B . "0x9B29")  ;; <CJK>
       (?$Br,(B . "0x9B2A")  ;; <CJK>
       (?$Br-(B . "0x9B2E")  ;; <CJK>
       (?$Br.(B . "0x9B2F")  ;; <CJK>
       (?$Br/(B . "0x9B32")  ;; <CJK>
       (?$Br0(B . "0x9B44")  ;; <CJK>
       (?$Br1(B . "0x9B43")  ;; <CJK>
       (?$Br2(B . "0x9B4F")  ;; <CJK>
       (?$Br3(B . "0x9B4D")  ;; <CJK>
       (?$Br4(B . "0x9B4E")  ;; <CJK>
       (?$Br5(B . "0x9B51")  ;; <CJK>
       (?$Br6(B . "0x9B58")  ;; <CJK>
       (?$Br7(B . "0x9B74")  ;; <CJK>
       (?$Br8(B . "0x9B93")  ;; <CJK>
       (?$Br9(B . "0x9B83")  ;; <CJK>
       (?$Br:(B . "0x9B91")  ;; <CJK>
       (?$Br;(B . "0x9B96")  ;; <CJK>
       (?$Br<(B . "0x9B97")  ;; <CJK>
       (?$Br=(B . "0x9B9F")  ;; <CJK>
       (?$Br>(B . "0x9BA0")  ;; <CJK>
       (?$Br?(B . "0x9BA8")  ;; <CJK>
       (?$Br@(B . "0x9BB4")  ;; <CJK>
       (?$BrA(B . "0x9BC0")  ;; <CJK>
       (?$BrB(B . "0x9BCA")  ;; <CJK>
       (?$BrC(B . "0x9BB9")  ;; <CJK>
       (?$BrD(B . "0x9BC6")  ;; <CJK>
       (?$BrE(B . "0x9BCF")  ;; <CJK>
       (?$BrF(B . "0x9BD1")  ;; <CJK>
       (?$BrG(B . "0x9BD2")  ;; <CJK>
       (?$BrH(B . "0x9BE3")  ;; <CJK>
       (?$BrI(B . "0x9BE2")  ;; <CJK>
       (?$BrJ(B . "0x9BE4")  ;; <CJK>
       (?$BrK(B . "0x9BD4")  ;; <CJK>
       (?$BrL(B . "0x9BE1")  ;; <CJK>
       (?$BrM(B . "0x9C3A")  ;; <CJK>
       (?$BrN(B . "0x9BF2")  ;; <CJK>
       (?$BrO(B . "0x9BF1")  ;; <CJK>
       (?$BrP(B . "0x9BF0")  ;; <CJK>
       (?$BrQ(B . "0x9C15")  ;; <CJK>
       (?$BrR(B . "0x9C14")  ;; <CJK>
       (?$BrS(B . "0x9C09")  ;; <CJK>
       (?$BrT(B . "0x9C13")  ;; <CJK>
       (?$BrU(B . "0x9C0C")  ;; <CJK>
       (?$BrV(B . "0x9C06")  ;; <CJK>
       (?$BrW(B . "0x9C08")  ;; <CJK>
       (?$BrX(B . "0x9C12")  ;; <CJK>
       (?$BrY(B . "0x9C0A")  ;; <CJK>
       (?$BrZ(B . "0x9C04")  ;; <CJK>
       (?$Br[(B . "0x9C2E")  ;; <CJK>
       (?$Br\(B . "0x9C1B")  ;; <CJK>
       (?$Br](B . "0x9C25")  ;; <CJK>
       (?$Br^(B . "0x9C24")  ;; <CJK>
       (?$Br_(B . "0x9C21")  ;; <CJK>
       (?$Br`(B . "0x9C30")  ;; <CJK>
       (?$Bra(B . "0x9C47")  ;; <CJK>
       (?$Brb(B . "0x9C32")  ;; <CJK>
       (?$Brc(B . "0x9C46")  ;; <CJK>
       (?$Brd(B . "0x9C3E")  ;; <CJK>
       (?$Bre(B . "0x9C5A")  ;; <CJK>
       (?$Brf(B . "0x9C60")  ;; <CJK>
       (?$Brg(B . "0x9C67")  ;; <CJK>
       (?$Brh(B . "0x9C76")  ;; <CJK>
       (?$Bri(B . "0x9C78")  ;; <CJK>
       (?$Brj(B . "0x9CE7")  ;; <CJK>
       (?$Brk(B . "0x9CEC")  ;; <CJK>
       (?$Brl(B . "0x9CF0")  ;; <CJK>
       (?$Brm(B . "0x9D09")  ;; <CJK>
       (?$Brn(B . "0x9D08")  ;; <CJK>
       (?$Bro(B . "0x9CEB")  ;; <CJK>
       (?$Brp(B . "0x9D03")  ;; <CJK>
       (?$Brq(B . "0x9D06")  ;; <CJK>
       (?$Brr(B . "0x9D2A")  ;; <CJK>
       (?$Brs(B . "0x9D26")  ;; <CJK>
       (?$Brt(B . "0x9DAF")  ;; <CJK>
       (?$Bru(B . "0x9D23")  ;; <CJK>
       (?$Brv(B . "0x9D1F")  ;; <CJK>
       (?$Brw(B . "0x9D44")  ;; <CJK>
       (?$Brx(B . "0x9D15")  ;; <CJK>
       (?$Bry(B . "0x9D12")  ;; <CJK>
       (?$Brz(B . "0x9D41")  ;; <CJK>
       (?$Br{(B . "0x9D3F")  ;; <CJK>
       (?$Br|(B . "0x9D3E")  ;; <CJK>
       (?$Br}(B . "0x9D46")  ;; <CJK>
       (?$Br~(B . "0x9D48")  ;; <CJK>
       (?$Bs!(B . "0x9D5D")  ;; <CJK>
       (?$Bs"(B . "0x9D5E")  ;; <CJK>
       (?$Bs#(B . "0x9D64")  ;; <CJK>
       (?$Bs$(B . "0x9D51")  ;; <CJK>
       (?$Bs%(B . "0x9D50")  ;; <CJK>
       (?$Bs&(B . "0x9D59")  ;; <CJK>
       (?$Bs'(B . "0x9D72")  ;; <CJK>
       (?$Bs((B . "0x9D89")  ;; <CJK>
       (?$Bs)(B . "0x9D87")  ;; <CJK>
       (?$Bs*(B . "0x9DAB")  ;; <CJK>
       (?$Bs+(B . "0x9D6F")  ;; <CJK>
       (?$Bs,(B . "0x9D7A")  ;; <CJK>
       (?$Bs-(B . "0x9D9A")  ;; <CJK>
       (?$Bs.(B . "0x9DA4")  ;; <CJK>
       (?$Bs/(B . "0x9DA9")  ;; <CJK>
       (?$Bs0(B . "0x9DB2")  ;; <CJK>
       (?$Bs1(B . "0x9DC4")  ;; <CJK>
       (?$Bs2(B . "0x9DC1")  ;; <CJK>
       (?$Bs3(B . "0x9DBB")  ;; <CJK>
       (?$Bs4(B . "0x9DB8")  ;; <CJK>
       (?$Bs5(B . "0x9DBA")  ;; <CJK>
       (?$Bs6(B . "0x9DC6")  ;; <CJK>
       (?$Bs7(B . "0x9DCF")  ;; <CJK>
       (?$Bs8(B . "0x9DC2")  ;; <CJK>
       (?$Bs9(B . "0x9DD9")  ;; <CJK>
       (?$Bs:(B . "0x9DD3")  ;; <CJK>
       (?$Bs;(B . "0x9DF8")  ;; <CJK>
       (?$Bs<(B . "0x9DE6")  ;; <CJK>
       (?$Bs=(B . "0x9DED")  ;; <CJK>
       (?$Bs>(B . "0x9DEF")  ;; <CJK>
       (?$Bs?(B . "0x9DFD")  ;; <CJK>
       (?$Bs@(B . "0x9E1A")  ;; <CJK>
       (?$BsA(B . "0x9E1B")  ;; <CJK>
       (?$BsB(B . "0x9E1E")  ;; <CJK>
       (?$BsC(B . "0x9E75")  ;; <CJK>
       (?$BsD(B . "0x9E79")  ;; <CJK>
       (?$BsE(B . "0x9E7D")  ;; <CJK>
       (?$BsF(B . "0x9E81")  ;; <CJK>
       (?$BsG(B . "0x9E88")  ;; <CJK>
       (?$BsH(B . "0x9E8B")  ;; <CJK>
       (?$BsI(B . "0x9E8C")  ;; <CJK>
       (?$BsJ(B . "0x9E92")  ;; <CJK>
       (?$BsK(B . "0x9E95")  ;; <CJK>
       (?$BsL(B . "0x9E91")  ;; <CJK>
       (?$BsM(B . "0x9E9D")  ;; <CJK>
       (?$BsN(B . "0x9EA5")  ;; <CJK>
       (?$BsO(B . "0x9EA9")  ;; <CJK>
       (?$BsP(B . "0x9EB8")  ;; <CJK>
       (?$BsQ(B . "0x9EAA")  ;; <CJK>
       (?$BsR(B . "0x9EAD")  ;; <CJK>
       (?$BsS(B . "0x9761")  ;; <CJK>
       (?$BsT(B . "0x9ECC")  ;; <CJK>
       (?$BsU(B . "0x9ECE")  ;; <CJK>
       (?$BsV(B . "0x9ECF")  ;; <CJK>
       (?$BsW(B . "0x9ED0")  ;; <CJK>
       (?$BsX(B . "0x9ED4")  ;; <CJK>
       (?$BsY(B . "0x9EDC")  ;; <CJK>
       (?$BsZ(B . "0x9EDE")  ;; <CJK>
       (?$Bs[(B . "0x9EDD")  ;; <CJK>
       (?$Bs\(B . "0x9EE0")  ;; <CJK>
       (?$Bs](B . "0x9EE5")  ;; <CJK>
       (?$Bs^(B . "0x9EE8")  ;; <CJK>
       (?$Bs_(B . "0x9EEF")  ;; <CJK>
       (?$Bs`(B . "0x9EF4")  ;; <CJK>
       (?$Bsa(B . "0x9EF6")  ;; <CJK>
       (?$Bsb(B . "0x9EF7")  ;; <CJK>
       (?$Bsc(B . "0x9EF9")  ;; <CJK>
       (?$Bsd(B . "0x9EFB")  ;; <CJK>
       (?$Bse(B . "0x9EFC")  ;; <CJK>
       (?$Bsf(B . "0x9EFD")  ;; <CJK>
       (?$Bsg(B . "0x9F07")  ;; <CJK>
       (?$Bsh(B . "0x9F08")  ;; <CJK>
       (?$Bsi(B . "0x76B7")  ;; <CJK>
       (?$Bsj(B . "0x9F15")  ;; <CJK>
       (?$Bsk(B . "0x9F21")  ;; <CJK>
       (?$Bsl(B . "0x9F2C")  ;; <CJK>
       (?$Bsm(B . "0x9F3E")  ;; <CJK>
       (?$Bsn(B . "0x9F4A")  ;; <CJK>
       (?$Bso(B . "0x9F52")  ;; <CJK>
       (?$Bsp(B . "0x9F54")  ;; <CJK>
       (?$Bsq(B . "0x9F63")  ;; <CJK>
       (?$Bsr(B . "0x9F5F")  ;; <CJK>
       (?$Bss(B . "0x9F60")  ;; <CJK>
       (?$Bst(B . "0x9F61")  ;; <CJK>
       (?$Bsu(B . "0x9F66")  ;; <CJK>
       (?$Bsv(B . "0x9F67")  ;; <CJK>
       (?$Bsw(B . "0x9F6C")  ;; <CJK>
       (?$Bsx(B . "0x9F6A")  ;; <CJK>
       (?$Bsy(B . "0x9F77")  ;; <CJK>
       (?$Bsz(B . "0x9F72")  ;; <CJK>
       (?$Bs{(B . "0x9F76")  ;; <CJK>
       (?$Bs|(B . "0x9F95")  ;; <CJK>
       (?$Bs}(B . "0x9F9C")  ;; <CJK>
       (?$Bs~(B . "0x9FA0")  ;; <CJK>
       (?$Bt!(B . "0x582F")  ;; <CJK>
       (?$Bt"(B . "0x69C7")  ;; <CJK>
       (?$Bt#(B . "0x9059")  ;; <CJK>
       (?$Bt$(B . "0x7464")  ;; <CJK>
       (?$Bt%(B . "0x51DC")  ;; <CJK>
       (?$Bt&(B . "0x7199")  ;; <CJK>
       ))))
 
(defvar jis-x-0208-vs-unicode-assoc jis-x-0208-1990-vs-unicode-assoc)

(provide 'ujisx0208)
 
