
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : vietnamese.scm
;; DESCRIPTION : typing vietnamese accented characters
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(texmacs-module (text vietnamese vietnamese)
  (:use (text text-kbd)))

(kbd-map
  ;;(:mode in-vietnamese-vietnamese?)

  ("a grave" "")
  ("a <#309>" "<#1EA3>")
  ("a <#303>" "")
  ("a acute" "")
  ("a <#323>" "<#1EA1>")

  ("e grave" "")
  ("e <#309>" "<#1EBB>")
  ("e <#303>" "<#1EBD>")
  ("e acute" "")
  ("e <#323>" "<#1EB9>")

  ("i grave" "")
  ("i <#309>" "<#1EC9>")
  ("i <#303>" "<#129>")
  ("i acute" "")
  ("i <#323>" "<#1ECB>")

  ("o grave" "")
  ("o <#309>" "<#1ECF>")
  ("o <#303>" "")
  ("o acute" "")
  ("o <#323>" "<#1ECD>")

  ("u grave" "")
  ("u <#309>" "<#1EE7>")
  ("u <#303>" "<#169>")
  ("u acute" "")
  ("u <#323>" "<#1EE5>")

  ("y grave" "<#1EF3>")
  ("y <#309>" "<#1EF7>")
  ("y <#303>" "<#1EF9>")
  ("y acute" "")
  ("y <#323>" "<#1EF5>")

  ("A grave" "")
  ("A <#309>" "<#1EA2>")
  ("A <#303>" "")
  ("A acute" "")
  ("A <#323>" "<#1EA0>")

  ("E grave" "")
  ("E <#309>" "<#1EBA>")
  ("E <#303>" "<#1EBC>")
  ("E acute" "")
  ("E <#323>" "<#1EB8>")

  ("I grave" "")
  ("I <#309>" "<#1EC8>")
  ("I <#303>" "<#128>")
  ("I acute" "")
  ("I <#323>" "<#1ECA>")

  ("O grave" "")
  ("O <#309>" "<#1ECE>")
  ("O <#303>" "")
  ("O acute" "")
  ("O <#323>" "<#1ECC>")

  ("U grave" "")
  ("U <#309>" "<#1EE6>")
  ("U <#303>" "<#168>")
  ("U acute" "")
  ("U <#323>" "<#1EE4>")

  ("Y grave" "<#1EF2>")
  ("Y <#309>" "<#1EF6>")
  ("Y <#303>" "<#1EF8>")
  ("Y acute" "")
  ("Y <#323>" "<#1EF4>")

  ("<#1B0> grave" "<#1EEB>")
  ("<#1B0> <#309>" "<#1EED>")
  ("<#1B0> <#303>" "<#1EEF>")
  ("<#1B0> acute" "<#1EE9>")
  ("<#1B0> <#323>" "<#1EF1>")

  ("<#1A1> grave" "<#1EDD>")
  ("<#1A1> <#309>" "<#1EDF>")
  ("<#1A1> <#303>" "<#1EE1>")
  ("<#1A1> acute" "<#1EDB>")
  ("<#1A1> <#323>" "<#1EE3>")

  ("<#1AF> grave" "<#1EEA>")
  ("<#1AF> <#309>" "<#1EEC>")
  ("<#1AF> <#303>" "<#1EEE>")
  ("<#1AF> acute" "<#1EE8>")
  ("<#1AF> <#323>" "<#1EF0>")

  ("<#1A0> grave" "<#1EDC>")
  ("<#1A0> <#309>" "<#1EDE>")
  ("<#1A0> <#303>" "<#1EE0>")
  ("<#1A0> acute" "<#1EDA>")
  ("<#1A0> <#323>" "<#1EE2>")

  ("<#103>" "")
  ("<#103> grave" "<#1EB1>")
  ("<#103> <#309>" "<#1EB3>")
  ("<#103> <#303>" "<#1EB5>")
  ("<#103> acute" "<#1EAF>")
  ("<#103> <#323>" "<#1EB7>")

  ("" "")
  (" grave" "<#1EA7>")
  (" <#309>" "<#1EA9>")
  (" <#303>" "<#1EAB>")
  (" acute" "<#1EA5>")
  (" <#323>" "<#1EAD>")

  ("" "")
  (" grave" "<#1EC1>")
  (" <#309>" "<#1EC3>")
  (" <#303>" "<#1EC5>")
  (" acute" "<#1EBF>")
  (" <#323>" "<#1EC7>")

  ("" "")
  (" grave" "<#1ED3>")
  (" <#309>" "<#1ED5>")
  (" <#303>" "<#1ED7>")
  (" acute" "<#1ED1>")
  (" <#323>" "<#1ED9>")

  ("<#102>" "")
  ("<#102> grave" "<#1EB0>")
  ("<#102> <#309>" "<#1EB2>")
  ("<#102> <#303>" "<#1EB4>")
  ("<#102> acute" "<#1EAE>")
  ("<#102> <#323>" "<#1EB6>")

  ("" "")
  (" grave" "<#1EA6>")
  (" <#309>" "<#1EA8>")
  (" <#303>" "<#1EAA>")
  (" acute" "<#1EA4>")
  (" <#323>" "<#1EAC>")

  ("" "")
  (" grave" "<#1EC0>")
  (" <#309>" "<#1EC2>")
  (" <#303>" "<#1EC4>")
  (" acute" "<#1EBE>")
  (" <#323>" "<#1EC6>")

  ("" "")
  (" grave" "<#1ED2>")
  (" <#309>" "<#1ED4>")
  (" <#303>" "<#1ED6>")
  (" acute" "<#1ED0>")
  (" <#323>" "<#1ED8>")

  ("ă" "")
  ("ă grave" "<#1EB1>")
  ("ă <#309>" "<#1EB3>")
  ("ă <#303>" "<#1EB5>")
  ("ă acute" "<#1EAF>")
  ("ă <#323>" "<#1EB7>")

  ("â" "")
  ("â grave" "<#1EA7>")
  ("â <#309>" "<#1EA9>")
  ("â <#303>" "<#1EAB>")
  ("â acute" "<#1EA5>")
  ("â <#323>" "<#1EAD>")

  ("ê" "")
  ("ê grave" "<#1EC1>")
  ("ê <#309>" "<#1EC3>")
  ("ê <#303>" "<#1EC5>")
  ("ê acute" "<#1EBF>")
  ("ê <#323>" "<#1EC7>")

  ("ô" "")
  ("ô grave" "<#1ED3>")
  ("ô <#309>" "<#1ED5>")
  ("ô <#303>" "<#1ED7>")
  ("ô acute" "<#1ED1>")
  ("ô <#323>" "<#1ED9>")

  ("Ă" "")
  ("Ă grave" "<#1EB0>")
  ("Ă <#309>" "<#1EB2>")
  ("Ă <#303>" "<#1EB4>")
  ("Ă acute" "<#1EAE>")
  ("Ă <#323>" "<#1EB6>")

  ("Â" "")
  ("Â grave" "<#1EA6>")
  ("Â <#309>" "<#1EA8>")
  ("Â <#303>" "<#1EAA>")
  ("Â acute" "<#1EA4>")
  ("Â <#323>" "<#1EAC>")

  ("Ê" "")
  ("Ê grave" "<#1EC0>")
  ("Ê <#309>" "<#1EC2>")
  ("Ê <#303>" "<#1EC4>")
  ("Ê acute" "<#1EBE>")
  ("Ê <#323>" "<#1EC6>")

  ("Ô" "")
  ("Ô grave" "<#1ED2>")
  ("Ô <#309>" "<#1ED4>")
  ("Ô <#303>" "<#1ED6>")
  ("Ô acute" "<#1ED0>")
  ("Ô <#323>" "<#1ED8>"))
