<TeXmacs|1.99.12>

<style|<tuple|tmdoc|old-spacing|old-dots>>

<\body>
  <tmdoc-title|Some examples>

  <\session|python|default>
    <\output>
      Python plugin for Python. Please see the documentation in
      Help-\<gtr\>plugins-\<gtr\>Python
    </output>

    <\unfolded-io>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|unfolded-io>
      # This is a comment

      for i in range(1):

      \ \ \ for j in range(1):

      \ \ \ \ \ \ \ print (i,j)

      \ \ \ print("*") # Another comment

      print("#")
    <|unfolded-io>
      0 0

      *

      #
    </unfolded-io>

    <\input>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|input>
      a=5
    </input>

    <\unfolded-io>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|unfolded-io>
      print(a+5)
    <|unfolded-io>
      10
    </unfolded-io>

    <\input>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|input>
      \;
    </input>
  </session>

  <paragraph|An example using <python|matplotlib>>

  For the following example you'll need <python|matplotlib> and
  <python|numpy> installed in your system.

  <\session|python|default>
    <\input>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|input>
      import matplotlib as mpl

      mpl.use('PS')

      import matplotlib.pyplot as pl

      import numpy as np

      x = np.linspace(0,3)

      pl.plot(x, np.sin(2*x))

      fig = pl.gcf()
    </input>

    <\unfolded-io>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|unfolded-io>
      ps_out(fig)
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.7par|||>
    </unfolded-io>

    <\input>
      \<gtr\>\<gtr\>\<gtr\>\ 
    <|input>
      \;
    </input>
  </session>

  Using <menu|Insert|Executable|Python> it is possible to embed images into
  your document without having sessions. Assuming you've run the code above,
  pressing <key|S-return> \ in the executable environment in the next figure
  will compile the code in it and display the graph:

  <big-figure|<\script-input|python|default>
    # Try me! Press Shift+return

    pl.clf() # Clear the last figure

    pl.plot(x, x + np.sin(4*x))

    ps_out(fig)
  </script-input|<image|<tuple|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|ps>|0.7par|||>>|A
  graph with the code \Pbehind\Q>

  <tmdoc-copyright|2004, 2014|Adrin Soto|Miguel de Benito Delgado>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|page-type|letter>
    <associate|par-hyphen|normal>
  </collection>
</initial>