/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NavisetProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_HEADER = 0;
    public static final int MSG_DATA = 1;
    public static final int MSG_RESPONSE = 2;
    public static final int MSG_RESERVE = 3;

    public NavisetProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(1);
            response.writeShortLE(buf.getUnsignedShortLE(buf.writerIndex() - 2));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
        int length = buf.readUnsignedShortLE();
        int type = BitUtil.between(length, 14, 16);
        buf.readUnsignedShortLE();
        if (type == 0) {
            this.getDeviceSession(channel, remoteAddress, buf.readCharSequence(15, StandardCharsets.US_ASCII).toString());
        } else if (type == 1) {
            LinkedList<Position> positions = new LinkedList<Position>();
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            short blockMask = buf.readUnsignedByte();
            while (buf.readableBytes() > 2) {
                int i;
                short dataMask;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.set("index", buf.readUnsignedShortLE());
                position.set("status", buf.readUnsignedByte());
                position.setValid(true);
                position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                position.setLatitude((double)buf.readUnsignedIntLE() * 1.0E-6);
                position.setLongitude((double)buf.readUnsignedIntLE() * 1.0E-6);
                position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShortLE() * 0.1));
                if (BitUtil.check(blockMask, 0)) {
                    dataMask = buf.readUnsignedByte();
                    if (BitUtil.check(dataMask, 0)) {
                        short satellites = buf.readUnsignedByte();
                        position.setValid(BitUtil.check(satellites, 7));
                        position.set("sat", BitUtil.to(satellites, 7));
                    }
                    if (BitUtil.check(dataMask, 1)) {
                        position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
                    }
                    if (BitUtil.check(dataMask, 2)) {
                        position.setAltitude(buf.readShortLE());
                    }
                    if (BitUtil.check(dataMask, 3)) {
                        position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
                    }
                    if (BitUtil.check(dataMask, 4)) {
                        position.set("power", (double)buf.readUnsignedShortLE() * 0.001);
                        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
                    }
                    if (BitUtil.check(dataMask, 5)) {
                        position.set("input", buf.readUnsignedByte());
                        position.set("output", buf.readUnsignedByte());
                    }
                    if (BitUtil.check(dataMask, 6)) {
                        position.set("odometer", buf.readUnsignedIntLE());
                    }
                    if (BitUtil.check(dataMask, 7)) {
                        buf.skipBytes(6);
                    }
                }
                if (BitUtil.check(blockMask, 1)) {
                    dataMask = buf.readUnsignedByte();
                    for (i = 0; i < 8; ++i) {
                        if (!BitUtil.check(dataMask, i)) continue;
                        position.set("adc" + (i + 1), buf.readUnsignedShortLE());
                    }
                }
                if (BitUtil.check(blockMask, 2)) {
                    dataMask = buf.readUnsignedByte();
                    if (BitUtil.check(dataMask, 0)) {
                        position.set("deviceTemp", Integer.valueOf(buf.readByte()));
                    }
                    if (BitUtil.check(dataMask, 1)) {
                        buf.skipBytes(6);
                    }
                    if (BitUtil.check(dataMask, 2)) {
                        position.set("temp1", Integer.valueOf(buf.readByte()));
                        position.set("temp2", Integer.valueOf(buf.readByte()));
                    }
                    if (BitUtil.check(dataMask, 3)) {
                        position.set("temp3", Integer.valueOf(buf.readByte()));
                        position.set("temp4", Integer.valueOf(buf.readByte()));
                    }
                    if (BitUtil.check(dataMask, 4)) {
                        position.set("temp5", Integer.valueOf(buf.readByte()));
                        position.set("temp6", Integer.valueOf(buf.readByte()));
                        position.set("temp7", Integer.valueOf(buf.readByte()));
                        position.set("temp8", Integer.valueOf(buf.readByte()));
                    }
                    if (BitUtil.check(dataMask, 5)) {
                        position.set("hours", (double)buf.readUnsignedShortLE() / 60.0);
                    }
                    if (BitUtil.check(dataMask, 6)) {
                        buf.readUnsignedByte();
                    }
                    if (BitUtil.check(dataMask, 7)) {
                        buf.readUnsignedByte();
                    }
                }
                if (BitUtil.check(blockMask, 3)) {
                    dataMask = buf.readUnsignedByte();
                    if (BitUtil.check(dataMask, 0)) {
                        position.set("fuel1", buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(dataMask, 1)) {
                        position.set("fuel2", buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(dataMask, 2)) {
                        position.set("fuel", buf.readUnsignedShortLE());
                    }
                    if (BitUtil.check(dataMask, 3)) {
                        buf.skipBytes(18);
                    }
                    if (BitUtil.check(dataMask, 4)) {
                        buf.readUnsignedByte();
                    }
                    if (BitUtil.check(dataMask, 5)) {
                        buf.readUnsignedByte();
                    }
                    if (BitUtil.check(dataMask, 6)) {
                        buf.readUnsignedShortLE();
                    }
                    if (BitUtil.check(dataMask, 7)) {
                        buf.readUnsignedShortLE();
                    }
                }
                if (BitUtil.check(blockMask, 4)) {
                    dataMask = buf.readUnsignedByte();
                    if (BitUtil.check(dataMask, 0)) {
                        buf.readUnsignedByte();
                        position.set("rpm", buf.readUnsignedShortLE());
                        position.set("coolantTemp", Integer.valueOf(buf.readByte()));
                    }
                    if (BitUtil.check(dataMask, 1)) {
                        buf.readUnsignedIntLE();
                    }
                    if (BitUtil.check(dataMask, 2)) {
                        position.set("odometer", buf.readUnsignedIntLE());
                    }
                    for (i = 3; i < 8; ++i) {
                        if (!BitUtil.check(dataMask, i)) continue;
                        buf.readUnsignedShortLE();
                    }
                }
                if (BitUtil.check(blockMask, 4)) {
                    dataMask = buf.readUnsignedByte();
                    if (BitUtil.check(dataMask, 0)) {
                        buf.readUnsignedByte();
                    }
                    if (BitUtil.check(dataMask, 1)) {
                        buf.readUnsignedMediumLE();
                    }
                    if (BitUtil.check(dataMask, 2)) {
                        buf.readUnsignedIntLE();
                    }
                    if (BitUtil.check(dataMask, 3)) {
                        buf.readUnsignedIntLE();
                    }
                    if (BitUtil.check(dataMask, 4)) {
                        buf.readUnsignedShortLE();
                    }
                    if (BitUtil.check(dataMask, 5)) {
                        buf.skipBytes(26);
                    }
                    if (BitUtil.check(dataMask, 6)) {
                        buf.readUnsignedIntLE();
                    }
                    if (BitUtil.check(dataMask, 7)) {
                        buf.readUnsignedIntLE();
                    }
                }
                positions.add(position);
            }
            return positions;
        }
        return null;
    }
}

