/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.SQSActions;
import com.amazonaws.auth.policy.conditions.ConditionFactory;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Topics {
    public static String subscribeQueue(AmazonSNS sns, AmazonSQS sqs, String snsTopicArn, String sqsQueueUrl) throws AmazonClientException, AmazonServiceException {
        return Topics.subscribeQueue(sns, sqs, snsTopicArn, sqsQueueUrl, false);
    }

    public static String subscribeQueue(AmazonSNS sns, AmazonSQS sqs, String snsTopicArn, String sqsQueueUrl, boolean extendPolicy) throws AmazonClientException, AmazonServiceException {
        List<String> sqsAttrNames = Arrays.asList(QueueAttributeName.QueueArn.toString(), QueueAttributeName.Policy.toString());
        Map sqsAttrs = sqs.getQueueAttributes(sqsQueueUrl, sqsAttrNames).getAttributes();
        String sqsQueueArn = (String)sqsAttrs.get(QueueAttributeName.QueueArn.toString());
        String policyJson = (String)sqsAttrs.get(QueueAttributeName.Policy.toString());
        Policy policy = extendPolicy && policyJson != null && policyJson.length() > 0 ? Policy.fromJson((String)policyJson) : new Policy();
        policy.getStatements().add(new Statement(Statement.Effect.Allow).withId("topic-subscription-" + snsTopicArn).withPrincipals(new Principal[]{Principal.AllUsers}).withActions(new Action[]{SQSActions.SendMessage}).withResources(new Resource[]{new Resource(sqsQueueArn)}).withConditions(new Condition[]{ConditionFactory.newSourceArnCondition((String)snsTopicArn)}));
        HashMap<String, String> newAttrs = new HashMap<String, String>();
        newAttrs.put(QueueAttributeName.Policy.toString(), policy.toJson());
        sqs.setQueueAttributes(new SetQueueAttributesRequest(sqsQueueUrl, newAttrs));
        SubscribeResult subscribeResult = sns.subscribe(snsTopicArn, "sqs", sqsQueueArn);
        return subscribeResult.getSubscriptionArn();
    }
}

