/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.FixedConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.DefaultExtendableItem;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    static final String[] DEPENDENCY_REGULAR_ATTRIBUTES = new String[]{"org", "name", "branch", "branchConstraint", "rev", "revConstraint", "force", "transitive", "changing", "conf"};
    private static final XmlModuleDescriptorParser INSTANCE = new XmlModuleDescriptorParser();

    public static XmlModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    protected XmlModuleDescriptorParser() {
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings object, URL uRL, Resource resource, boolean bl) throws ParseException, IOException {
        object = this.newParser((ParserSettings)object);
        ((Parser)object).setValidate(bl);
        ((Parser)object).setResource(resource);
        ((Parser)object).setInput(uRL);
        ((Parser)object).parse();
        return ((Parser)object).getModuleDescriptor();
    }

    protected Parser newParser(ParserSettings parserSettings) {
        return new Parser(this, parserSettings);
    }

    @Override
    public boolean accept(Resource resource) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void toIvyFile(InputStream inputStream, Resource resource, File file, ModuleDescriptor moduleDescriptor) throws IOException, ParseException {
        try {
            Namespace namespace = null;
            if (moduleDescriptor instanceof DefaultModuleDescriptor) {
                DefaultModuleDescriptor defaultModuleDescriptor = (DefaultModuleDescriptor)moduleDescriptor;
                namespace = defaultModuleDescriptor.getNamespace();
            }
            XmlModuleDescriptorUpdater.update(inputStream, resource, file, new UpdateOptions().setSettings(IvyContext.getContext().getSettings()).setStatus(moduleDescriptor.getStatus()).setRevision(moduleDescriptor.getResolvedModuleRevisionId().getRevision()).setPubdate(moduleDescriptor.getResolvedPublicationDate()).setUpdateBranch(false).setNamespace(namespace));
            if (inputStream == null) return;
        }
        catch (SAXException sAXException) {
            try {
                ParseException parseException = new ParseException("exception occurred while parsing " + resource, 0);
                parseException.initCause(sAXException);
                throw parseException;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
        }
        inputStream.close();
        return;
    }

    public String toString() {
        return "ivy parser";
    }

    public static class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        protected static final List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0", "2.1", "2.2", "2.3");
        private ParserSettings settings;
        private boolean validate = true;
        private URL descriptorURL;
        private InputStream descriptorInput;
        private int state = 0;
        private PatternMatcher defaultMatcher;
        private DefaultDependencyDescriptor dd;
        private ConfigurationAware confAware;
        private MDArtifact artifact;
        private String conf;
        private boolean artifactsDeclared = false;
        private StringBuffer buffer;
        private String descriptorVersion;
        private String[] publicationsDefaultConf;

        public Parser(ModuleDescriptorParser moduleDescriptorParser, ParserSettings parserSettings) {
            super(moduleDescriptorParser);
            this.settings = parserSettings;
        }

        public void setInput(URL uRL) {
            this.descriptorURL = uRL;
        }

        public void setValidate(boolean bl) {
            this.validate = bl;
        }

        public void parse() throws ParseException, IOException {
            try {
                URL uRL;
                URL uRL2 = uRL = this.validate ? this.getSchemaURL() : null;
                if (this.descriptorURL != null) {
                    XMLHelper.parse(this.descriptorURL, uRL, this);
                } else {
                    XMLHelper.parse(this.descriptorInput, uRL, (DefaultHandler)this, null);
                }
                this.checkConfigurations();
                this.replaceConfigurationWildcards();
                this.getMd().setModuleArtifact(DefaultArtifact.newIvyArtifact(this.getMd().getResolvedModuleRevisionId(), this.getMd().getPublicationDate()));
                if (!this.artifactsDeclared) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.getMd().addArtifact(stringArray[i], new MDArtifact(this.getMd(), this.getMd().getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this.getMd().check();
                return;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                IllegalStateException illegalStateException = new IllegalStateException(parserConfigurationException.getMessage() + " in " + this.descriptorURL);
                illegalStateException.initCause(parserConfigurationException);
                throw illegalStateException;
            }
            catch (Exception exception) {
                this.checkErrors();
                ParseException parseException = new ParseException(exception.getMessage() + " in " + this.descriptorURL, 0);
                parseException.initCause(exception);
                throw parseException;
            }
        }

        @Override
        public void startElement(String object, String object2, String string, Attributes attributes) throws SAXException {
            block28: {
                try {
                    if (this.state == 11) {
                        this.getBuffer().append("<").append(string);
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            this.getBuffer().append(" ");
                            this.getBuffer().append(attributes.getQName(i));
                            this.getBuffer().append("=\"");
                            this.getBuffer().append(attributes.getValue(i));
                            this.getBuffer().append("\"");
                        }
                        this.getBuffer().append(">");
                        return;
                    }
                    if ("ivy-module".equals(string)) {
                        this.ivyModuleStarted(attributes);
                        break block28;
                    }
                    if ("info".equals(string)) {
                        this.infoStarted(attributes);
                        break block28;
                    }
                    if (this.state == 1 && "extends".equals(string)) {
                        this.extendsStarted(attributes);
                        break block28;
                    }
                    if (this.state == 1 && "license".equals(string)) {
                        this.getMd().addLicense(new License(this.settings.substitute(attributes.getValue("name")), this.settings.substitute(attributes.getValue("url"))));
                        break block28;
                    }
                    if (this.state == 1 && "description".equals(string)) {
                        this.getMd().setHomePage(this.settings.substitute(attributes.getValue("homepage")));
                        this.state = 11;
                        this.buffer = new StringBuffer();
                        break block28;
                    }
                    if (!(this.state == 1 && "ivyauthor".equals(string) || this.state == 1 && "repository".equals(string))) {
                        if (this.state == 1 && this.isOtherNamespace(string)) {
                            this.buffer = new StringBuffer();
                            this.state = 12;
                            break block28;
                        }
                        if ("configurations".equals(string)) {
                            this.configurationStarted(attributes);
                            break block28;
                        }
                        if ("publications".equals(string)) {
                            this.publicationsStarted(attributes);
                            break block28;
                        }
                        if ("dependencies".equals(string)) {
                            this.dependenciesStarted(attributes);
                            break block28;
                        }
                        if ("conflicts".equals(string)) {
                            if (!this.descriptorVersion.startsWith("1.")) {
                                Message.deprecated("using conflicts section is deprecated: please use hints section instead. Ivy file URL: " + this.descriptorURL);
                            }
                            this.state = 8;
                            this.checkConfigurations();
                            break block28;
                        }
                        if ("artifact".equals(string)) {
                            this.artifactStarted(string, attributes);
                            break block28;
                        }
                        if ("include".equals(string) && this.state == 4) {
                            this.addIncludeRule(string, attributes);
                            break block28;
                        }
                        if ("exclude".equals(string) && this.state == 4) {
                            this.addExcludeRule(string, attributes);
                            break block28;
                        }
                        if ("exclude".equals(string) && this.state == 10) {
                            this.state = 9;
                            this.parseRule(string, attributes);
                            this.getMd().addExcludeRule((ExcludeRule)((Object)this.confAware));
                            break block28;
                        }
                        if ("dependency".equals(string)) {
                            this.dependencyStarted(attributes);
                            break block28;
                        }
                        if ("conf".equals(string)) {
                            this.confStarted(attributes);
                            break block28;
                        }
                        if ("mapped".equals(string)) {
                            this.dd.addDependencyConfiguration(this.conf, this.settings.substitute(attributes.getValue("name")));
                            break block28;
                        }
                        if ("conflict".equals(string) && this.state == 10 || "manager".equals(string) && this.state == 8) {
                            this.managerStarted(attributes, this.state == 8 ? "name" : "manager");
                            break block28;
                        }
                        if ("override".equals(string) && this.state == 10) {
                            this.mediationOverrideStarted(attributes);
                            break block28;
                        }
                        if ("include".equals(string) && this.state == 2) {
                            this.includeConfStarted(attributes);
                            break block28;
                        }
                        if (this.validate && this.state != 12 && this.state != 11) {
                            this.addError("unknown tag " + string);
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    object = exception;
                    if (exception instanceof SAXException) {
                        throw (SAXException)object;
                    }
                    object2 = new SAXException("Problem occurred while parsing ivy file: " + ((Throwable)object).getMessage(), (Exception)object);
                    ((Throwable)object2).initCause((Throwable)object);
                    throw object2;
                }
            }
        }

        protected String getDefaultParentLocation() {
            return "../ivy.xml";
        }

        protected void extendsStarted(Attributes list) throws ParseException {
            Object object;
            Object object2 = this.settings.substitute(list.getValue("organisation"));
            Object object3 = this.settings.substitute(list.getValue("module"));
            String string = list.getValue("revision") != null ? this.settings.substitute(list.getValue("revision")) : Ivy.getWorkingRevision();
            String string2 = list.getValue("location") != null ? this.settings.substitute(list.getValue("location")) : this.getDefaultParentLocation();
            ModuleDescriptor moduleDescriptor = null;
            list = list.getValue("extendType") != null ? this.settings.substitute(list.getValue("extendType").toLowerCase(Locale.US)) : "all";
            list = Arrays.asList(((String)((Object)list)).split(","));
            object2 = new ModuleId((String)object2, (String)object3);
            object3 = new ModuleRevisionId((ModuleId)object2, string);
            boolean bl = false;
            try {
                moduleDescriptor = this.parseParentModuleOnFilesystem(string2);
                if (moduleDescriptor != null && !((ModuleId)(object = moduleDescriptor.getResolvedModuleRevisionId().getModuleId())).equals(object2)) {
                    Message.info("Found a parent module with unexpected ModuleRevisionId at source location " + string2 + "! Expected: " + object2 + ". Found: " + object + ". This parent module will be ignored.");
                    moduleDescriptor = null;
                }
                bl = moduleDescriptor != null;
            }
            catch (IOException iOException) {
                Message.warn("Unable to parse included ivy file " + string2 + ": " + iOException.getMessage());
            }
            if (moduleDescriptor == null) {
                try {
                    moduleDescriptor = this.parseOtherIvyFile((ModuleRevisionId)object3);
                }
                catch (ParseException parseException) {
                    Message.warn("Unable to parse included ivy file for " + ((ModuleRevisionId)object3).toString());
                }
            }
            if (moduleDescriptor == null) {
                throw new ParseException("Unable to parse included ivy file for " + ((ModuleRevisionId)object3).toString(), 0);
            }
            List<String> list2 = list;
            object = new DefaultExtendsDescriptor(moduleDescriptor, string2, list2.toArray(new String[list2.size()]), bl);
            this.getMd().addInheritedDescriptor((ExtendsDescriptor)object);
            this.mergeWithOtherModuleDescriptor(list, moduleDescriptor);
        }

        protected void mergeWithOtherModuleDescriptor(List list, ModuleDescriptor moduleDescriptor) throws ParseException {
            if (list.contains("all")) {
                this.mergeAll(moduleDescriptor);
                return;
            }
            if (list.contains("info")) {
                this.mergeInfo(moduleDescriptor);
            }
            if (list.contains("configurations")) {
                this.mergeConfigurations(moduleDescriptor);
            }
            if (list.contains("dependencies")) {
                this.mergeDependencies(moduleDescriptor.getDependencies());
            }
            if (list.contains("description")) {
                this.mergeDescription(moduleDescriptor.getDescription());
            }
            if (list.contains("licenses")) {
                this.mergeLicenses(moduleDescriptor.getLicenses());
            }
        }

        protected void mergeAll(ModuleDescriptor moduleDescriptor) {
            this.mergeInfo(moduleDescriptor);
            this.mergeConfigurations(moduleDescriptor);
            this.mergeDependencies(moduleDescriptor.getDependencies());
            this.mergeDescription(moduleDescriptor.getDescription());
            this.mergeLicenses(moduleDescriptor.getLicenses());
        }

        protected void mergeInfo(ModuleDescriptor object) {
            ModuleRevisionId moduleRevisionId = object.getModuleRevisionId();
            DefaultModuleDescriptor defaultModuleDescriptor = this.getMd();
            ModuleRevisionId moduleRevisionId2 = defaultModuleDescriptor.getModuleRevisionId();
            moduleRevisionId = ModuleRevisionId.newInstance(Parser.mergeValue(moduleRevisionId.getOrganisation(), moduleRevisionId2.getOrganisation()), moduleRevisionId2.getName(), Parser.mergeValue(moduleRevisionId.getBranch(), moduleRevisionId2.getBranch()), Parser.mergeRevisionValue(moduleRevisionId.getRevision(), moduleRevisionId2.getRevision()), Parser.mergeValues(moduleRevisionId.getQualifiedExtraAttributes(), moduleRevisionId2.getQualifiedExtraAttributes()));
            defaultModuleDescriptor.setModuleRevisionId(moduleRevisionId);
            defaultModuleDescriptor.setResolvedModuleRevisionId(moduleRevisionId);
            defaultModuleDescriptor.setStatus(Parser.mergeValue(object.getStatus(), defaultModuleDescriptor.getStatus()));
            if (defaultModuleDescriptor.getNamespace() == null && object instanceof DefaultModuleDescriptor) {
                object = ((DefaultModuleDescriptor)object).getNamespace();
                defaultModuleDescriptor.setNamespace((Namespace)object);
            }
        }

        private static String mergeRevisionValue(String string, String string2) {
            if (string2 == null || string2.equals(Ivy.getWorkingRevision())) {
                return string;
            }
            return string2;
        }

        private static String mergeValue(String string, String string2) {
            if (string2 == null) {
                return string;
            }
            return string2;
        }

        private static Map mergeValues(Map map, Map map2) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(map.size() + map2.size());
            linkedHashMap.putAll(map);
            linkedHashMap.putAll(map2);
            return linkedHashMap;
        }

        protected void mergeConfigurations(ModuleDescriptor moduleDescriptor) {
            ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
            Configuration[] configurationArray = moduleDescriptor.getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                Configuration configuration = configurationArray[i];
                Message.debug("Merging configuration with: " + configuration.getName());
                this.getMd().addConfiguration(new Configuration(configuration, moduleRevisionId));
            }
            if (moduleDescriptor instanceof DefaultModuleDescriptor) {
                this.setDefaultConfMapping(((DefaultModuleDescriptor)moduleDescriptor).getDefaultConfMapping());
                this.setDefaultConf(((DefaultModuleDescriptor)moduleDescriptor).getDefaultConf());
                this.getMd().setMappingOverride(((DefaultModuleDescriptor)moduleDescriptor).isMappingOverride());
            }
        }

        protected void mergeDependencies(DependencyDescriptor[] dependencyDescriptorArray) {
            DefaultModuleDescriptor defaultModuleDescriptor = this.getMd();
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[i];
                Message.debug("Merging dependency with: " + dependencyDescriptor.getDependencyRevisionId().toString());
                defaultModuleDescriptor.addDependency(dependencyDescriptor);
            }
        }

        protected void mergeDescription(String string) {
            String string2 = this.getMd().getDescription();
            if (string2 == null || string2.trim().length() == 0) {
                this.getMd().setDescription(string);
            }
        }

        public void mergeLicenses(License[] licenseArray) {
            for (int i = 0; i < licenseArray.length; ++i) {
                this.getMd().addLicense(licenseArray[i]);
            }
        }

        private ModuleDescriptor parseParentModuleOnFilesystem(String object) throws IOException, ParseException {
            if (!"file".equals(this.descriptorURL.getProtocol())) {
                return null;
            }
            File file = new File((String)object);
            if (!file.isAbsolute()) {
                object = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, (String)object);
                try {
                    file = new File(new URI(((URL)object).toExternalForm()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(((URL)object).getPath());
                }
            }
            if (!(file = FileUtil.normalize(file.getAbsolutePath())).exists()) {
                Message.verbose("Parent module doesn't exist on the filesystem: " + file.getAbsolutePath());
                return null;
            }
            object = new FileResource(null, file);
            ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser((Resource)object);
            return moduleDescriptorParser.parseDescriptor(this.getSettings(), file.toURL(), (Resource)object, this.isValidate());
        }

        protected ModuleDescriptor parseOtherIvyFile(ModuleRevisionId moduleRevisionId) throws ParseException {
            Object object;
            Message.debug("Trying to parse included ivy file by asking repository for module :" + moduleRevisionId.toString());
            DependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, true);
            Object object2 = IvyContext.getContext().getResolveData();
            if (object2 == null) {
                object = IvyContext.getContext().getIvy().getResolveEngine();
                object2 = new ResolveOptions();
                ((ResolveOptions)object2).setDownload(false);
                object2 = new ResolveData((ResolveEngine)object, (ResolveOptions)object2);
            }
            if ((object2 = (object = this.getSettings().getResolver(moduleRevisionId)).getDependency(dependencyDescriptor = NameSpaceHelper.toSystem(dependencyDescriptor, this.getSettings().getContextNamespace()), (ResolveData)object2)) == null) {
                throw new ParseException("Unable to find " + moduleRevisionId.toString(), 0);
            }
            return ((ResolvedModuleRevision)object2).getDescriptor();
        }

        protected void publicationsStarted(Attributes object) {
            this.state = 3;
            this.artifactsDeclared = true;
            this.checkConfigurations();
            object = this.settings.substitute(object.getValue("defaultconf"));
            if (object != null) {
                this.setPublicationsDefaultConf((String)object);
            }
        }

        protected void setPublicationsDefaultConf(String string) {
            this.publicationsDefaultConf = string == null ? null : string.split(",");
        }

        protected boolean isOtherNamespace(String string) {
            return string.indexOf(58) != -1;
        }

        protected void managerStarted(Attributes attributes, String object) {
            String string = this.settings.substitute(attributes.getValue("org"));
            string = string == null ? "*" : string;
            String string2 = this.settings.substitute(attributes.getValue("module"));
            string2 = string2 == null ? "*" : string2;
            Object object2 = this.settings.substitute(attributes.getValue((String)object));
            object = this.settings.substitute(attributes.getValue("rev"));
            if (object != null) {
                object2 = ((String)object).split(",");
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object2[i] = object2[i].trim();
                }
                object = new FixedConflictManager((String[])object2);
            } else if (object2 != null) {
                object = this.settings.getConflictManager((String)object2);
                if (object == null) {
                    this.addError("unknown conflict manager: " + (String)object2);
                    return;
                }
            } else {
                this.addError("bad conflict manager: no manager nor rev");
                return;
            }
            object2 = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher = object2 == null ? this.defaultMatcher : this.settings.getMatcher((String)object2);
            if (patternMatcher == null) {
                this.addError("unknown matcher: " + (String)object2);
                return;
            }
            this.getMd().addConflictManager(new ModuleId(string, string2), patternMatcher, (ConflictManager)object);
        }

        protected void mediationOverrideStarted(Attributes object) {
            String string = this.settings.substitute(object.getValue("org"));
            string = string == null ? "*" : string;
            String string2 = this.settings.substitute(object.getValue("module"));
            string2 = string2 == null ? "*" : string2;
            String string3 = this.settings.substitute(object.getValue("rev"));
            String string4 = this.settings.substitute(object.getValue("branch"));
            PatternMatcher patternMatcher = (object = this.settings.substitute(object.getValue("matcher"))) == null ? this.defaultMatcher : this.settings.getMatcher((String)object);
            if (patternMatcher == null) {
                this.addError("unknown matcher: " + (String)object);
                return;
            }
            this.getMd().addDependencyDescriptorMediator(new ModuleId(string, string2), patternMatcher, new OverrideDependencyDescriptorMediator(string4, string3));
        }

        protected void includeConfStarted(Attributes object) throws SAXException, IOException, ParserConfigurationException, ParseException {
            object = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, this.settings.substitute(object.getValue("file")), this.settings.substitute(object.getValue("url")));
            if (object == null) {
                throw new SAXException("include tag must have a file or an url attribute");
            }
            Parser parser = new Parser(this.getModuleDescriptorParser(), this.settings);
            parser.setInput((URL)object);
            parser.setMd(new DefaultModuleDescriptor(this.getModuleDescriptorParser(), new URLResource((URL)object)));
            XMLHelper.parse((URL)object, null, parser);
            object = parser.getModuleDescriptor().getConfigurations();
            for (int i = 0; i < ((Configuration[])object).length; ++i) {
                this.getMd().addConfiguration(object[i]);
            }
            if (parser.getDefaultConfMapping() != null) {
                Message.debug("setting default conf mapping from imported configurations file: " + parser.getDefaultConfMapping());
                this.setDefaultConfMapping(parser.getDefaultConfMapping());
            }
            if (parser.getDefaultConf() != null) {
                Message.debug("setting default conf from imported configurations file: " + parser.getDefaultConf());
                this.setDefaultConf(parser.getDefaultConf());
            }
            if (parser.getMd().isMappingOverride()) {
                Message.debug("enabling mapping-override from imported configurations file");
                this.getMd().setMappingOverride(true);
            }
        }

        protected void confStarted(Attributes object) {
            Object object2 = this.settings.substitute(object.getValue("name"));
            switch (this.state) {
                case 2: {
                    String string = this.settings.substitute(object.getValue("visibility"));
                    String string2 = this.settings.substitute(object.getValue("extends"));
                    String string3 = object.getValue("transitive");
                    boolean bl = string3 == null ? true : Boolean.valueOf(object.getValue("transitive"));
                    String string4 = object.getValue("deprecated");
                    object2 = new Configuration((String)object2, Configuration.Visibility.getVisibility(string == null ? "public" : string), this.settings.substitute(object.getValue("description")), string2 == null ? null : string2.split(","), bl, string4);
                    ExtendableItemHelper.fillExtraAttributes(this.settings, (DefaultExtendableItem)object2, (Attributes)object, new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"});
                    this.getMd().addConfiguration((Configuration)object2);
                    return;
                }
                case 3: {
                    if ("*".equals(object2)) {
                        object = this.getMd().getConfigurationsNames();
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            this.artifact.addConfiguration((String)object[i]);
                            this.getMd().addArtifact((String)object[i], this.artifact);
                        }
                        return;
                    }
                    this.artifact.addConfiguration((String)object2);
                    this.getMd().addArtifact((String)object2, this.artifact);
                    return;
                }
                case 4: {
                    this.conf = object2;
                    object = this.settings.substitute(object.getValue("mapped"));
                    if (object == null) break;
                    String[] stringArray = ((String)object).split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.dd.addDependencyConfiguration((String)object2, stringArray[i].trim());
                    }
                    return;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.addConfiguration((String)object2);
                    return;
                }
                default: {
                    if (!this.validate) break;
                    this.addError("conf tag found in invalid tag: " + this.state);
                }
            }
        }

        protected void dependencyStarted(Attributes object) {
            this.state = 4;
            Object object2 = this.settings.substitute(object.getValue("org"));
            if (object2 == null) {
                object2 = this.getMd().getModuleRevisionId().getOrganisation();
            }
            boolean bl = Boolean.valueOf(this.settings.substitute(object.getValue("force")));
            boolean bl2 = Boolean.valueOf(this.settings.substitute(object.getValue("changing")));
            String string = this.settings.substitute(object.getValue("transitive"));
            boolean bl3 = string == null ? true : Boolean.valueOf(object.getValue("transitive"));
            String string2 = this.settings.substitute(object.getValue("name"));
            String string3 = this.settings.substitute(object.getValue("branch"));
            String string4 = this.settings.substitute(object.getValue("branchConstraint"));
            String string5 = this.settings.substitute(object.getValue("rev"));
            String string6 = this.settings.substitute(object.getValue("revConstraint"));
            Map map = ExtendableItemHelper.getExtraAttributes(this.settings, (Attributes)object, DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance((String)object2, string2, string3, string5, map);
            object2 = string6 == null && string4 == null ? ModuleRevisionId.newInstance((String)object2, string2, string3, string5, map, false) : (string4 == null ? ModuleRevisionId.newInstance((String)object2, string2, null, string6, map, false) : ModuleRevisionId.newInstance((String)object2, string2, string4, string6, map));
            this.dd = new DefaultDependencyDescriptor(this.getMd(), moduleRevisionId, (ModuleRevisionId)object2, bl, bl2, bl3);
            this.getMd().addDependency(this.dd);
            object = this.settings.substitute(object.getValue("conf"));
            if (object != null && ((String)object).length() > 0) {
                this.parseDepsConfs((String)object, this.dd);
            }
        }

        protected void artifactStarted(String object, Attributes attributes) throws MalformedURLException {
            if (this.state == 3) {
                object = this.settings.substitute(attributes.getValue("name"));
                object = object == null ? this.getMd().getModuleRevisionId().getName() : object;
                String string = this.settings.substitute(attributes.getValue("type"));
                string = string == null ? "jar" : string;
                String string2 = this.settings.substitute(attributes.getValue("ext"));
                string2 = string2 != null ? string2 : string;
                String string3 = this.settings.substitute(attributes.getValue("url"));
                this.artifact = new MDArtifact(this.getMd(), (String)object, string, string2, string3 == null ? null : new URL(string3), ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"ext", "type", "name", "conf"}));
                object = this.settings.substitute(attributes.getValue("conf"));
                if (object != null && object.length() > 0) {
                    object = "*".equals(object) ? this.getMd().getConfigurationsNames() : object.split(",");
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        this.artifact.addConfiguration(object[i].trim());
                        this.getMd().addArtifact(object[i].trim(), this.artifact);
                    }
                }
                return;
            }
            if (this.state == 4) {
                this.addDependencyArtifacts((String)object, attributes);
                return;
            }
            if (this.validate) {
                this.addError("artifact tag found in invalid tag: " + this.state);
            }
        }

        protected void dependenciesStarted(Attributes object) {
            this.state = 10;
            String string = this.settings.substitute(object.getValue("defaultconf"));
            if (string != null) {
                this.setDefaultConf(string);
            }
            if ((string = this.settings.substitute(object.getValue("defaultconfmapping"))) != null) {
                this.setDefaultConfMapping(string);
            }
            if ((object = this.settings.substitute(object.getValue("confmappingoverride"))) != null) {
                this.getMd().setMappingOverride(Boolean.valueOf((String)object));
            }
            this.checkConfigurations();
        }

        protected void configurationStarted(Attributes attributes) {
            this.state = 2;
            Parser parser = this;
            parser.setDefaultConfMapping(parser.settings.substitute(attributes.getValue("defaultconfmapping")));
            Parser parser2 = this;
            parser2.setDefaultConf(parser2.settings.substitute(attributes.getValue("defaultconf")));
            this.getMd().setMappingOverride(Boolean.valueOf(this.settings.substitute(attributes.getValue("confmappingoverride"))));
        }

        protected void infoStarted(Attributes object) {
            this.state = 1;
            String string = this.settings.substitute(object.getValue("organisation"));
            Object object2 = this.settings.substitute(object.getValue("module"));
            String string2 = this.settings.substitute(object.getValue("revision"));
            String string3 = this.settings.substitute(object.getValue("branch"));
            this.getMd().setModuleRevisionId(ModuleRevisionId.newInstance(string, (String)object2, string3, string2, ExtendableItemHelper.getExtraAttributes(this.settings, (Attributes)object, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"})));
            string = this.settings.substitute(object.getValue("namespace"));
            if (string != null) {
                object2 = this.settings.getNamespace(string);
                if (object2 == null) {
                    Message.warn("namespace not found for " + this.getMd().getModuleRevisionId() + ": " + string);
                } else {
                    this.getMd().setNamespace((Namespace)object2);
                }
            }
            object2 = this.settings.substitute(object.getValue("status"));
            this.getMd().setStatus((String)(object2 == null ? this.settings.getStatusManager().getDefaultStatus() : object2));
            this.getMd().setDefault(Boolean.valueOf(this.settings.substitute(object.getValue("default"))));
            object = this.settings.substitute(object.getValue("publication"));
            if (object != null && ((String)object).length() > 0) {
                try {
                    this.getMd().setPublicationDate(DateUtil.parse((String)object));
                    return;
                }
                catch (ParseException parseException) {
                    this.addError("invalid publication date format: " + (String)object);
                }
            }
            this.getMd().setPublicationDate(this.getDefaultPubDate());
        }

        protected void ivyModuleStarted(Attributes attributes) throws SAXException {
            this.descriptorVersion = attributes.getValue("version");
            int n = ALLOWED_VERSIONS.indexOf(this.descriptorVersion);
            if (n == -1) {
                this.addError("invalid version " + this.descriptorVersion);
                throw new SAXException("invalid version " + this.descriptorVersion);
            }
            if (n >= ALLOWED_VERSIONS.indexOf("1.3")) {
                Message.debug("post 1.3 ivy file: using exact as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exact");
            } else {
                Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exactOrRegexp");
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).startsWith("xmlns:")) continue;
                this.getMd().addExtraAttributeNamespace(attributes.getQName(n).substring(6), attributes.getValue(n));
            }
        }

        protected void addDependencyArtifacts(String string, Attributes attributes) throws MalformedURLException {
            this.state = 5;
            this.parseRule(string, attributes);
        }

        protected void addIncludeRule(String string, Attributes attributes) throws MalformedURLException {
            this.state = 6;
            this.parseRule(string, attributes);
        }

        protected void addExcludeRule(String string, Attributes attributes) throws MalformedURLException {
            this.state = 7;
            this.parseRule(string, attributes);
        }

        protected void parseRule(String object, Attributes attributes) throws MalformedURLException {
            String string;
            Object object2;
            Object object3;
            String string2;
            Object object4 = this.settings.substitute(attributes.getValue("name"));
            if (object4 == null && (object4 = this.settings.substitute(attributes.getValue("artifact"))) == null) {
                Object object5 = object4 = "artifact".equals(object) ? this.dd.getDependencyId().getName() : "*";
            }
            if ((string2 = this.settings.substitute(attributes.getValue("type"))) == null) {
                string2 = "artifact".equals(object) ? "jar" : "*";
            }
            Object object6 = object = (object = this.settings.substitute(attributes.getValue("ext"))) != null ? object : string2;
            if (this.state == 5) {
                object3 = this.settings.substitute(attributes.getValue("url"));
                object2 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"name", "type", "ext", "url", "conf"});
                this.confAware = new DefaultDependencyArtifactDescriptor(this.dd, (String)object4, string2, (String)object, object3 == null ? null : new URL((String)object3), (Map)object2);
            } else if (this.state == 6) {
                object3 = this.getPatternMatcher(attributes.getValue("matcher"));
                object2 = this.settings.substitute(attributes.getValue("org"));
                object2 = object2 == null ? "*" : object2;
                string = this.settings.substitute(attributes.getValue("module"));
                string = string == null ? "*" : string;
                object = new ArtifactId(new ModuleId((String)object2, string), (String)object4, string2, (String)object);
                object4 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultIncludeRule((ArtifactId)object, (PatternMatcher)object3, (Map)object4);
            } else {
                object3 = this.getPatternMatcher(attributes.getValue("matcher"));
                object2 = this.settings.substitute(attributes.getValue("org"));
                object2 = object2 == null ? "*" : object2;
                string = this.settings.substitute(attributes.getValue("module"));
                string = string == null ? "*" : string;
                object = new ArtifactId(new ModuleId((String)object2, string), (String)object4, string2, (String)object);
                object4 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultExcludeRule((ArtifactId)object, (PatternMatcher)object3, (Map)object4);
            }
            object3 = this.settings.substitute(attributes.getValue("conf"));
            if (object3 != null && ((String)object3).length() > 0) {
                object2 = "*".equals(object3) ? this.getMd().getConfigurationsNames() : ((String)object3).split(",");
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    this.addConfiguration(object2[i].trim());
                }
            }
        }

        protected void addConfiguration(String string) {
            this.confAware.addConfiguration(string);
            if (this.state != 9) {
                if (this.confAware instanceof DependencyArtifactDescriptor) {
                    this.dd.addDependencyArtifact(string, (DependencyArtifactDescriptor)((Object)this.confAware));
                    return;
                }
                if (this.confAware instanceof IncludeRule) {
                    this.dd.addIncludeRule(string, (IncludeRule)((Object)this.confAware));
                    return;
                }
                if (this.confAware instanceof ExcludeRule) {
                    this.dd.addExcludeRule(string, (ExcludeRule)((Object)this.confAware));
                }
            }
        }

        protected PatternMatcher getPatternMatcher(String string) {
            PatternMatcher patternMatcher = (string = this.settings.substitute(string)) == null ? this.defaultMatcher : this.settings.getMatcher(string);
            if (patternMatcher == null) {
                throw new IllegalArgumentException("unknown matcher " + string);
            }
            return patternMatcher;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String stringArray, String string, String string2) throws SAXException {
            if (this.state == 3 && "artifact".equals(string2) && this.artifact.getConfigurations().length == 0) {
                stringArray = this.publicationsDefaultConf == null ? this.getMd().getConfigurationsNames() : this.publicationsDefaultConf;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.artifact.addConfiguration(stringArray[i].trim());
                    this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
                }
                return;
            }
            if ("configurations".equals(string2)) {
                this.checkConfigurations();
                return;
            }
            if (this.state == 5 && "artifact".equals(string2) || this.state == 6 && "include".equals(string2) || this.state == 7 && "exclude".equals(string2)) {
                this.state = 4;
                if (this.confAware.getConfigurations().length == 0) {
                    stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addConfiguration(stringArray[i]);
                    }
                }
                this.confAware = null;
                return;
            }
            if ("exclude".equals(string2) && this.state == 9) {
                if (this.confAware.getConfigurations().length == 0) {
                    stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addConfiguration(stringArray[i]);
                    }
                }
                this.confAware = null;
                this.state = 10;
                return;
            }
            if ("dependency".equals(string2) && this.state == 4) {
                if (this.dd.getModuleConfigurations().length == 0) {
                    Parser parser = this;
                    parser.parseDepsConfs(parser.getDefaultConf(), this.dd);
                }
                this.state = 10;
                return;
            }
            if ("dependencies".equals(string2) && this.state == 10) {
                this.state = 0;
                return;
            }
            if (this.state == 1 && "info".equals(string2)) {
                this.state = 0;
                return;
            }
            if (this.state == 11 && "description".equals(string2)) {
                this.getMd().setDescription(this.buffer == null ? "" : this.buffer.toString().trim());
                this.buffer = null;
                this.state = 1;
                return;
            }
            if (this.state == 12) {
                this.getMd().addExtraInfo(string2, this.buffer == null ? "" : this.buffer.toString());
                this.buffer = null;
                this.state = 1;
                return;
            }
            if (this.state == 11) {
                if (this.buffer.toString().endsWith("<" + string2 + ">")) {
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                    this.buffer.append("/>");
                    return;
                }
                this.buffer.append("</" + string2 + ">");
            }
        }

        protected void checkConfigurations() {
            if (this.getMd().getConfigurations().length == 0) {
                this.getMd().addConfiguration(new Configuration("default"));
            }
        }

        protected void replaceConfigurationWildcards() {
            Configuration[] configurationArray = this.getMd().getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                configurationArray[i].replaceWildcards(this.getMd());
            }
        }

        protected ParserSettings getSettings() {
            return this.settings;
        }

        protected StringBuffer getBuffer() {
            return this.buffer;
        }

        protected boolean isValidate() {
            return this.validate;
        }

        protected URL getSchemaURL() {
            return this.getClass().getResource("ivy.xsd");
        }
    }
}

