/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.namespace;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.MRIDRule;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.util.Message;

public class MRIDTransformationRule
implements NamespaceTransformer {
    private List src;
    private MRIDRule dest;

    @Override
    public ModuleRevisionId transform(ModuleRevisionId moduleRevisionId) {
        Object object = new MridRuleMatcher();
        for (MRIDRule mRIDRule : this.src) {
            if (!((MridRuleMatcher)object).match(mRIDRule, moduleRevisionId)) continue;
            object = ((MridRuleMatcher)object).apply(this.dest, moduleRevisionId);
            Message.debug("found matching namespace rule: " + mRIDRule + ". Applied " + this.dest + " on " + moduleRevisionId + ". Transformed to " + object);
            return object;
        }
        return moduleRevisionId;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    private static class MridRuleMatcher {
        private static final String[] TYPES = new String[]{"o", "m", "b", "r"};
        private Matcher[] matchers = new Matcher[TYPES.length];

        private MridRuleMatcher() {
        }

        public boolean match(MRIDRule mRIDRule, ModuleRevisionId moduleRevisionId) {
            this.matchers[0] = Pattern.compile(this.getPattern(mRIDRule.getOrg())).matcher(moduleRevisionId.getOrganisation());
            if (!this.matchers[0].matches()) {
                return false;
            }
            this.matchers[1] = Pattern.compile(this.getPattern(mRIDRule.getModule())).matcher(moduleRevisionId.getName());
            if (!this.matchers[1].matches()) {
                return false;
            }
            if (moduleRevisionId.getBranch() == null) {
                this.matchers[2] = null;
            } else {
                this.matchers[2] = Pattern.compile(this.getPattern(mRIDRule.getBranch())).matcher(moduleRevisionId.getBranch());
                if (!this.matchers[2].matches()) {
                    return false;
                }
            }
            this.matchers[3] = Pattern.compile(this.getPattern(mRIDRule.getRev())).matcher(moduleRevisionId.getRevision());
            return this.matchers[3].matches();
        }

        public ModuleRevisionId apply(MRIDRule object, ModuleRevisionId moduleRevisionId) {
            String string = this.applyRules(((MRIDRule)object).getOrg(), "o");
            String string2 = this.applyRules(((MRIDRule)object).getModule(), "m");
            String string3 = this.applyRules(((MRIDRule)object).getBranch(), "b");
            object = this.applyRules(((MRIDRule)object).getRev(), "r");
            return ModuleRevisionId.newInstance(string, string2, string3, (String)object, moduleRevisionId.getQualifiedExtraAttributes());
        }

        private String applyRules(String string, String string2) {
            for (int i = 0; i < TYPES.length; ++i) {
                string = this.applyTypeRule(string, TYPES[i], string2, this.matchers[i]);
            }
            return string;
        }

        private String applyTypeRule(String string, String string2, String string3, Matcher matcher) {
            if (matcher == null) {
                return string;
            }
            String string4 = string == null ? "$" + string3 + "0" : string;
            for (int i = 0; i < TYPES.length; ++i) {
                if (TYPES[i].equals(string2)) {
                    string4 = string4.replaceAll("([^\\\\])\\$" + string2, "$1\\$");
                    string4 = string4.replaceAll("^\\$" + string2, "\\$");
                    continue;
                }
                string4 = string4.replaceAll("([^\\\\])\\$" + TYPES[i], "$1\\\\\\$" + TYPES[i]);
                string4 = string4.replaceAll("^\\$" + TYPES[i], "\\\\\\$" + TYPES[i]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            matcher.reset();
            matcher.find();
            matcher.appendReplacement(stringBuffer, string4);
            string2 = stringBuffer.toString();
            if (string == null && ("$" + string3 + "0").equals(string2)) {
                return null;
            }
            return string2;
        }

        private String getPattern(String string) {
            if (string == null) {
                return ".*";
            }
            return string;
        }
    }
}

