/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.UnindexedFilesScannerExecutor;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.testFramework.DumbModeTestUtils;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.indexing.UnindexedFilesScannerExecutorImpl;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/IndexingTestUtil;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "waitAfterWriteAction", "", "waitNow", "dispatchAllEventsInIdeEventQueue", "", "shouldWait", "suspendUntilIndexesAreReady", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitUntilFinished", "Companion", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nIndexingTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingTestUtil.kt\ncom/intellij/testFramework/IndexingTestUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,176:1\n24#2:177\n24#2:178\n24#2:179\n24#2:180\n24#2:181\n24#2:182\n24#2:183\n*S KotlinDebug\n*F\n+ 1 IndexingTestUtil.kt\ncom/intellij/testFramework/IndexingTestUtil\n*L\n54#1:177\n60#1:178\n103#1:179\n122#1:180\n133#1:181\n144#1:182\n150#1:183\n*E\n"})
public final class IndexingTestUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public IndexingTestUtil(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void waitAfterWriteAction() {
        if (this.project.isDisposed()) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable listenerDisposable = disposable;
        UnindexedFilesScannerExecutor unindexedFilesScannerExecutor = UnindexedFilesScannerExecutor.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)unindexedFilesScannerExecutor, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposable parentDisposable = (Disposable)unindexedFilesScannerExecutor;
        Disposer.register((Disposable)parentDisposable, (Disposable)listenerDisposable);
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(listenerDisposable, this){
            private volatile int nested;
            final /* synthetic */ Disposable $listenerDisposable;
            final /* synthetic */ IndexingTestUtil this$0;
            {
                this.$listenerDisposable = $listenerDisposable;
                this.this$0 = $receiver;
                this.nested = 1;
            }

            public void beforeWriteActionStart(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                int n = this.nested;
                this.nested = n + 1;
            }

            public void afterWriteActionFinished(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                int n = this.nested;
                this.nested = n + -1;
                int n2 = n = this.nested >= 0 ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl = false;
                    String string = "We counted more finished write actions than started.";
                    throw new AssertionError((Object)string);
                }
                if (this.nested <= 0) {
                    Disposer.dispose((Disposable)this.$listenerDisposable);
                    IndexingTestUtil.access$waitNow(this.this$0);
                }
            }
        }, listenerDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitNow() {
        IndexingTestUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexingTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitNow, thread=" + Thread.currentThread());
        Assert.assertFalse((String)"Should not be invoked from write action", (boolean)ApplicationManager.getApplication().isWriteAccessAllowed());
        if (!this.shouldWait()) {
            return;
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(IndexingTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.debug("waitNow will be waiting, thread=" + Thread.currentThread());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)"Indexing waiter", (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (boolean)false, (int)4, null);
            Job waiting2 = BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IndexingTestUtil this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = IndexingTestUtil.access$suspendUntilIndexesAreReady(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            try {
                do {
                    PlatformTestUtil.waitWithEventsDispatching("Indexing timeout", () -> IndexingTestUtil.waitNow$lambda$0(waiting2), 600);
                } while (this.dispatchAllEventsInIdeEventQueue());
            }
            finally {
                Job.DefaultImpls.cancel$default((Job)waiting2, null, (int)1, null);
            }
        } else {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IndexingTestUtil this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = IndexingTestUtil.access$suspendUntilIndexesAreReady(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final boolean dispatchAllEventsInIdeEventQueue() {
        boolean hasDispatchedEvents = false;
        while (PlatformTestUtil.dispatchNextEventIfAny() != null) {
            hasDispatchedEvents = true;
        }
        return hasDispatchedEvents;
    }

    private final boolean shouldWait() {
        DumbServiceImpl dumbService = DumbServiceImpl.Companion.getInstance(this.project);
        dumbService.ensureInitialDumbTaskRequiredForSmartModeSubmitted();
        UnindexedFilesScannerExecutorImpl scannerExecutor = UnindexedFilesScannerExecutorImpl.Companion.getInstance(this.project);
        if (scannerExecutor.getHasQueuedTasks()) {
            boolean bl;
            if (scannerExecutor.scanningWaitsForNonDumbMode() && dumbService.isDumb()) {
                boolean isEternal = DumbModeTestUtils.INSTANCE.isEternalDumbTaskRunning$intellij_platform_testFramework(this.project);
                if (isEternal) {
                    IndexingTestUtil $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(IndexingTestUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Do not wait for queued scanning task, because eternal dumb task is running in the project [" + this.project + "]");
                }
                bl = !isEternal;
            } else {
                bl = true;
            }
            return bl;
        }
        if (dumbService.hasScheduledTasks()) {
            return true;
        }
        if (((Boolean)scannerExecutor.isRunning().getValue()).booleanValue() || dumbService.isRunning()) {
            return true;
        }
        if (dumbService.isDumb()) {
            boolean isEternal = DumbModeTestUtils.INSTANCE.isEternalDumbTaskRunning$intellij_platform_testFramework(this.project);
            if (isEternal) {
                IndexingTestUtil $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IndexingTestUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Do not wait for smart mode, because eternal dumb task is running in the project [" + this.project + "]");
            }
            return !isEternal;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final Object suspendUntilIndexesAreReady(Continuation<? super Unit> $completion) {
        if (!($completion instanceof suspendUntilIndexesAreReady.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexingTestUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexingTestUtil.access$suspendUntilIndexesAreReady(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.shouldWait()) {
                    $i$f$thisLogger = false;
                    v0 = Logger.getInstance(IndexingTestUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                    v0.debug("suspendUntilIndexesAreReady will be waiting, thread=" + Thread.currentThread());
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)600, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IndexingTestUtil this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                // 3 sources

                                while (IndexingTestUtil.access$shouldWait(this.this$0)) {
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)1L, (Continuation)((Continuation)this));
                                    if (v0 != var2_2) continue;
                                    return var2_2;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl5
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var7_4) goto lbl25
lbl24:
                // 1 sources

                return var7_4;
lbl25:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                this = (IndexingTestUtil)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (TimeoutCancellationException e) {
                    $i$f$thisLogger = false;
                    v2 = Logger.getInstance(IndexingTestUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.warn(ThreadDumper.dumpThreadsToString(), (Throwable)e);
                    throw e;
                }
lbl39:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void waitUntilFinished() {
        IndexingTestUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexingTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitUntilFinished, thread=" + Thread.currentThread() + ", WA=" + ApplicationManager.getApplication().isWriteAccessAllowed());
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.waitAfterWriteAction();
        } else {
            this.waitNow();
        }
    }

    private static final boolean waitNow$lambda$0(Job $waiting) {
        return !$waiting.isActive();
    }

    @JvmStatic
    public static final void waitUntilIndexesAreReadyInAllOpenedProjects() {
        Companion.waitUntilIndexesAreReadyInAllOpenedProjects();
    }

    @JvmStatic
    public static final void waitUntilIndexesAreReady(@NotNull Project project) {
        Companion.waitUntilIndexesAreReady(project);
    }

    public static final /* synthetic */ void access$waitNow(IndexingTestUtil $this) {
        $this.waitNow();
    }

    public static final /* synthetic */ boolean access$shouldWait(IndexingTestUtil $this) {
        return $this.shouldWait();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/testFramework/IndexingTestUtil$Companion;", "", "<init>", "()V", "waitUntilIndexesAreReadyInAllOpenedProjects", "", "waitUntilIndexesAreReady", "project", "Lcom/intellij/openapi/project/Project;", "suspendUntilIndexesAreReady", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void waitUntilIndexesAreReadyInAllOpenedProjects() {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                new IndexingTestUtil(project).waitUntilFinished();
            }
        }

        @JvmStatic
        public final void waitUntilIndexesAreReady(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            new IndexingTestUtil(project).waitUntilFinished();
        }

        @Nullable
        public final Object suspendUntilIndexesAreReady(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Object object = new IndexingTestUtil(project).suspendUntilIndexesAreReady((Continuation<? super Unit>)$completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

