/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.intellij.util.Alarm;
import com.jetbrains.performancePlugin.commands.CodeAnalysisStateListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForSmartCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "completeWhenSmartModeIsLongEnough", "project", "Lcom/intellij/openapi/project/Project;", "completion", "Lkotlinx/coroutines/CompletableDeferred;", "alarm", "Lcom/intellij/util/Alarm;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nWaitForSmartCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForSmartCommand.kt\ncom/jetbrains/performancePlugin/commands/WaitForSmartCommand\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,57:1\n31#2,2:58\n*S KotlinDebug\n*F\n+ 1 WaitForSmartCommand.kt\ncom/jetbrains/performancePlugin/commands/WaitForSmartCommand\n*L\n37#1:58,2\n*E\n"})
public final class WaitForSmartCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%waitForSmart";
    private static final int SMART_MODE_MINIMUM_DELAY = 3000;

    public WaitForSmartCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CodeAnalysisStateListener> serviceClass$iv = CodeAnalysisStateListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Alarm alarm = new Alarm(((CodeAnalysisStateListener)object).getCs(), null, 2, null);
        CompletableDeferred completion = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        Project project2 = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.completeWhenSmartModeIsLongEnough(project2, (CompletableDeferred<Unit>)completion, alarm);
        Object object2 = completion.await($completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private final void completeWhenSmartModeIsLongEnough(Project project, CompletableDeferred<Unit> completion, Alarm alarm) {
        DumbService.Companion.getInstance(project).runWhenSmart(() -> WaitForSmartCommand.completeWhenSmartModeIsLongEnough$lambda$2(alarm, this, project, completion));
    }

    private static final boolean completeWhenSmartModeIsLongEnough$lambda$2$lambda$1$lambda$0(Project $project) {
        return DumbService.Companion.isDumb($project);
    }

    private static final void completeWhenSmartModeIsLongEnough$lambda$2$lambda$1(WaitForSmartCommand this$0, Project $project, CompletableDeferred $completion, Alarm $alarm) {
        if (((Boolean)ActionsKt.runReadAction(() -> WaitForSmartCommand.completeWhenSmartModeIsLongEnough$lambda$2$lambda$1$lambda$0($project))).booleanValue()) {
            this$0.completeWhenSmartModeIsLongEnough($project, (CompletableDeferred<Unit>)$completion, $alarm);
        } else {
            $completion.complete((Object)Unit.INSTANCE);
        }
    }

    private static final void completeWhenSmartModeIsLongEnough$lambda$2(Alarm $alarm, WaitForSmartCommand this$0, Project $project, CompletableDeferred $completion) {
        $alarm.addRequest(() -> WaitForSmartCommand.completeWhenSmartModeIsLongEnough$lambda$2$lambda$1(this$0, $project, $completion, $alarm), 3000);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForSmartCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "SMART_MODE_MINIMUM_DELAY", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

