/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome.features;

import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001:\u0001\u0013J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "", "id", "", "getId", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "title", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getTitle", "description", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor$Description;", "getDescription", "()Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor$Description;", "getWebmPreviewData", "", "Description", "intellij.llmInstaller"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nWelcomeFeatureDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeFeatureDescriptor.kt\ncom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n14#2:95\n97#2,6:96\n14#2:102\n104#2:103\n*S KotlinDebug\n*F\n+ 1 WelcomeFeatureDescriptor.kt\ncom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor\n*L\n87#1:95\n92#1:96,6\n92#1:102\n92#1:103\n*E\n"})
public interface WelcomeFeatureDescriptor {
    @NotNull
    public String getId();

    @Nullable
    public Icon getIcon();

    @NotNull
    public String getTitle();

    @NotNull
    public Description getDescription();

    @Nullable
    default public byte[] getWebmPreviewData() {
        Object $this$getWebmPreviewData_u24lambda_u240;
        Path file;
        String resourcePath = "video/" + PlatformUtils.getPlatformPrefix() + "/" + this.getId() + ".webm";
        Path path = PluginManagerCoreKt.getPluginDistDirByClass(WelcomeFeatureDescriptor.class);
        Path path2 = file = path != null ? path.resolve(resourcePath) : null;
        if (file == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WelcomeFeatureDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Resource " + resourcePath + " is not found");
            return null;
        }
        WelcomeFeatureDescriptor $i$f$logger = this;
        try {
            $this$getWebmPreviewData_u24lambda_u240 = $i$f$logger;
            boolean bl = false;
            $this$getWebmPreviewData_u24lambda_u240 = Result.constructor-impl((Object)Files.readAllBytes(file));
        }
        catch (Throwable throwable) {
            $this$getWebmPreviewData_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object $this$getOrLogException$iv = $this$getWebmPreviewData_u24lambda_u240;
        boolean $i$f$getOrLogException = false;
        Object object = $this$getOrLogException$iv;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e$iv = throwable;
            boolean bl = false;
            if (e$iv instanceof ProcessCanceledException || e$iv instanceof CancellationException) {
                throw e$iv;
            }
            Throwable it = e$iv;
            boolean bl2 = false;
            boolean $i$f$logger2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Logger.getInstance(WelcomeFeatureDescriptor.class), (String)"getInstance(...)");
        }
        return (byte[])(Result.isFailure-impl((Object)object) ? null : object);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B8\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000f\b\u0002\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u000f\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010\u0010\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J<\u0010\u0012\u001a\u00020\u00002\u000f\b\u0002\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0018\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor$Description;", "", "steps", "", "Lorg/jetbrains/annotations/Nls;", "beforeSteps", "afterSteps", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSteps", "()Ljava/lang/String;", "getBeforeSteps", "getAfterSteps", "getAsHtml", "getStepsAsHtml", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.llmInstaller"})
    @ApiStatus.Experimental
    public static final class Description {
        @Nullable
        private final String steps;
        @Nullable
        private final String beforeSteps;
        @Nullable
        private final String afterSteps;

        public Description(@Nullable String steps, @Nullable String beforeSteps, @Nullable String afterSteps) {
            this.steps = steps;
            this.beforeSteps = beforeSteps;
            this.afterSteps = afterSteps;
        }

        public /* synthetic */ Description(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Nullable
        public final String getSteps() {
            return this.steps;
        }

        @Nullable
        public final String getBeforeSteps() {
            return this.beforeSteps;
        }

        @Nullable
        public final String getAfterSteps() {
            return this.afterSteps;
        }

        @Nullable
        public final String getAsHtml() {
            StringBuilder result;
            block4: {
                String it;
                result = new StringBuilder();
                String string = this.beforeSteps;
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    result.append(it);
                }
                String string2 = this.getStepsAsHtml();
                if (string2 != null) {
                    it = string2;
                    boolean bl = false;
                    if (((CharSequence)result).length() > 0) {
                        result.append("<p>");
                    }
                    result.append(it);
                }
                String string3 = this.afterSteps;
                if (string3 == null) break block4;
                it = string3;
                boolean bl = false;
                if (((CharSequence)result).length() > 0) {
                    result.append("<p>");
                }
                result.append(it);
            }
            return StringsKt.isBlank((CharSequence)result) ? null : result.toString();
        }

        private final String getStepsAsHtml() {
            if (this.steps == null) {
                return null;
            }
            String[] stringArray = new String[]{"<p>"};
            List items = StringsKt.split$default((CharSequence)this.steps, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Object object = new String[]{"<table width='100%'>"};
            List rows = CollectionsKt.mutableListOf((Object[])object);
            object = ((Iterable)items).iterator();
            int n = 0;
            while (object.hasNext()) {
                String number;
                String numberColor;
                int index = n++;
                String paragraph = (String)object.next();
                String string = "%02d";
                Object[] objectArray = new Object[]{index + 1};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                Intrinsics.checkNotNullExpressionValue((Object)ColorUtil.toHex((Color)JBUI.CurrentTheme.Label.disabledForeground()), (String)"toHex(...)");
                rows.add("<tr><td style='color:#" + numberColor + ";'>" + number + "</td><td width='100%'>" + paragraph + "</td></tr>");
            }
            rows.add("</table>");
            return CollectionsKt.joinToString$default((Iterable)rows, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        @Nullable
        public final String component1() {
            return this.steps;
        }

        @Nullable
        public final String component2() {
            return this.beforeSteps;
        }

        @Nullable
        public final String component3() {
            return this.afterSteps;
        }

        @NotNull
        public final Description copy(@Nullable String steps, @Nullable String beforeSteps, @Nullable String afterSteps) {
            return new Description(steps, beforeSteps, afterSteps);
        }

        public static /* synthetic */ Description copy$default(Description description, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = description.steps;
            }
            if ((n & 2) != 0) {
                string2 = description.beforeSteps;
            }
            if ((n & 4) != 0) {
                string3 = description.afterSteps;
            }
            return description.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Description(steps=" + this.steps + ", beforeSteps=" + this.beforeSteps + ", afterSteps=" + this.afterSteps + ")";
        }

        public int hashCode() {
            int result = this.steps == null ? 0 : this.steps.hashCode();
            result = result * 31 + (this.beforeSteps == null ? 0 : this.beforeSteps.hashCode());
            result = result * 31 + (this.afterSteps == null ? 0 : this.afterSteps.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Description)) {
                return false;
            }
            Description description = (Description)other;
            if (!Intrinsics.areEqual((Object)this.steps, (Object)description.steps)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.beforeSteps, (Object)description.beforeSteps)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.afterSteps, (Object)description.afterSteps);
        }
    }
}

