/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tools.StringTools;

public final class ManualSynthesizer {
    private static final String SUFFIX_MARKER = "+";
    private final Set<String> possibleTags;
    private static final int OFFSET_SHIFT = 8;
    private static final int MAX_LENGTH = 255;
    private static final int MAX_OFFSET = 0xFFFFFF;
    private static final int ENTRY_SIZE = 3;
    private final String[] data;
    private final Int2IntMap map;
    private static final String DEFAULT_SEPARATOR = "\t";

    public ManualSynthesizer(InputStream inputStream) throws IOException {
        Map<TaggedWord, List<String>> mapping = ManualSynthesizer.loadMapping(inputStream);
        Int2ObjectOpenHashMap<List<Triple<String, String, String>>> byHash = ManualSynthesizer.groupByHash(mapping);
        this.map = new Int2IntOpenHashMap(byHash.size());
        int valueCount = mapping.values().stream().mapToInt(v -> v.size()).sum();
        final int firstIndex = 3;
        this.data = new String[valueCount * 3 + firstIndex];
        if (valueCount > 0xFFFFFF) {
            throw new UnsupportedOperationException("Too many values (" + valueCount + "), the storage needs adjusting");
        }
        byHash.int2ObjectEntrySet().fastForEach((Consumer)new Consumer<Int2ObjectMap.Entry<List<Triple<String, String, String>>>>(){
            int index;
            {
                this.index = firstIndex;
            }

            @Override
            public void accept(Int2ObjectMap.Entry<List<Triple<String, String, String>>> listEntry) {
                int hash2 = listEntry.getIntKey();
                List value = (List)listEntry.getValue();
                if (value.size() > 255) {
                    throw new UnsupportedOperationException("Too many lemmas (" + value.size() + " for the same hash " + value + ", the storage needs adjusting");
                }
                ManualSynthesizer.this.map.put(hash2, this.index / 3 << 8 | value.size());
                for (Triple triple : value) {
                    ((ManualSynthesizer)ManualSynthesizer.this).data[this.index++] = (String)triple.getLeft();
                    ((ManualSynthesizer)ManualSynthesizer.this).data[this.index++] = (String)triple.getMiddle();
                    ((ManualSynthesizer)ManualSynthesizer.this).data[this.index++] = (String)triple.getRight();
                }
            }
        });
        this.possibleTags = Collections.unmodifiableSet(ManualSynthesizer.collectTags(mapping));
    }

    private static Int2ObjectOpenHashMap<List<Triple<String, String, String>>> groupByHash(Map<TaggedWord, List<String>> mapping) {
        Int2ObjectOpenHashMap byHash = new Int2ObjectOpenHashMap(mapping.size());
        HashMap internedStrings = new HashMap();
        for (Map.Entry<TaggedWord, List<String>> entry2 : mapping.entrySet()) {
            TaggedWord tw = entry2.getKey();
            String lemma = tw.getLemma();
            int hash2 = ManualSynthesizer.hashCode(lemma, tw.getPosTag());
            ArrayList<ImmutableTriple> list = (ArrayList<ImmutableTriple>)byHash.get(hash2);
            if (list == null) {
                list = new ArrayList<ImmutableTriple>();
                byHash.put(hash2, list);
            }
            for (String word : entry2.getValue()) {
                if (word.startsWith(SUFFIX_MARKER)) {
                    throw new UnsupportedOperationException("Words can't start with +");
                }
                String value = (String)internedStrings.computeIfAbsent(ManualSynthesizer.encodeForm(lemma, word), Function.identity());
                list.add(new ImmutableTriple((Object)lemma, (Object)tw.getPosTag(), (Object)value));
            }
        }
        return byHash;
    }

    private static String encodeForm(String lemma, String word) {
        if (word.length() > lemma.length() && word.startsWith(lemma)) {
            return SUFFIX_MARKER + word.substring(lemma.length());
        }
        if (word.length() >= lemma.length() && word.startsWith(lemma.substring(0, lemma.length() - 1))) {
            return "++" + word.substring(lemma.length() - 1);
        }
        return word;
    }

    private static String decodeForm(String lemma, String word) {
        if (word.startsWith(SUFFIX_MARKER)) {
            if (word.startsWith(SUFFIX_MARKER, SUFFIX_MARKER.length())) {
                return lemma.substring(0, lemma.length() - 1) + word.substring(SUFFIX_MARKER.length() * 2);
            }
            return lemma + word.substring(SUFFIX_MARKER.length());
        }
        return word;
    }

    private static ObjectOpenHashSet<String> collectTags(Map<TaggedWord, List<String>> mapping) {
        ObjectOpenHashSet tags = new ObjectOpenHashSet();
        for (TaggedWord tw : mapping.keySet()) {
            tags.add((Object)tw.getPosTag());
        }
        tags.trim();
        return tags;
    }

    private static int hashCode(String lemma, String posTag) {
        return lemma.hashCode() * 31 + posTag.hashCode();
    }

    public Set<String> getPossibleTags() {
        return this.possibleTags;
    }

    @Nullable
    public List<String> lookup(String lemma, String posTag) {
        if (lemma == null || posTag == null) {
            return null;
        }
        int value = this.map.get(ManualSynthesizer.hashCode(lemma, posTag));
        if (value == 0) {
            return null;
        }
        int offset = (value >>> 8) * 3;
        int length = value & 0xFF;
        ArrayList<String> result2 = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            if (!lemma.equals(this.data[offset + i * 3]) || !posTag.equals(this.data[offset + i * 3 + 1])) continue;
            String word = this.data[offset + i * 3 + 2];
            result2.add(ManualSynthesizer.decodeForm(lemma, word));
        }
        return result2;
    }

    private static Map<TaggedWord, List<String>> loadMapping(InputStream inputStream) throws IOException {
        HashMap internedStrings = new HashMap();
        HashMap<TaggedWord, List<String>> mapping = new HashMap<TaggedWord, List<String>>();
        HashMap interned = new HashMap();
        try (Scanner scanner = new Scanner(inputStream, "utf8");){
            String separator = DEFAULT_SEPARATOR;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if ((line = line.trim()).startsWith("#separatorRegExp=")) {
                    separator = line.replace("#separatorRegExp=", "");
                }
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = (line = StringUtils.substringBefore((String)line, (String)"#").trim()).split(separator);
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual synthesizer dictionary, expected 3 parts separated by '" + separator + "', found " + parts.length + ": '" + line + "'");
                }
                String form = parts[0];
                String lemma = parts[1];
                if (form.equals(lemma)) {
                    form = lemma;
                }
                lemma = (String)interned.computeIfAbsent(lemma, Function.identity());
                String posTag = (String)internedStrings.computeIfAbsent(parts[2], Function.identity());
                mapping.computeIfAbsent(new TaggedWord(lemma, posTag), __ -> new ArrayList()).add(form);
            }
        }
        return mapping;
    }
}

